#  Copyright 2021 Simone Rubino - Agile Business Group
#  License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl.html).

from odoo.tests import TransactionCase
from odoo.tools import DEFAULT_SERVER_DATE_FORMAT, test_reports


class TestAgedPartnerBalance(TransactionCase):
    def setUp(self):
        super().setUp()
        self.wizard_model = self.env["aged.partner.balance.report.wizard"]

    def test_report(self):
        """Check that report is produced correctly."""
        wizard = self.wizard_model.create(
            {
                "show_move_line_details": True,
                "receivable_accounts_only": True,
            }
        )
        wizard.onchange_type_accounts_only()
        data = wizard._prepare_report_aged_partner_balance()

        # Simulate web client behavior:
        # default value is a datetime.date but web client sends back strings
        data.update({"date_at": data["date_at"].strftime(DEFAULT_SERVER_DATE_FORMAT)})
        result = test_reports.try_report(
            self.env.cr,
            self.env.uid,
            "account_financial_report.aged_partner_balance",
            wizard.ids,
            data=data,
        )
        self.assertTrue(result)
