# Copyright 2023 Dixmit
# License AGPL-3.0 or later (https://www.gnu.org/licenses/agpl).

from odoo import _, fields, models


class AccountJournal(models.Model):
    _inherit = "account.journal"

    reconcile_mode = fields.Selection(
        [("edit", "Edit Move"), ("keep", "Keep Suspense Accounts")],
        default="edit",
        required=True,
    )
    company_currency_id = fields.Many2one(
        related="company_id.currency_id", string="Company Currency"
    )
    reconcile_aggregate = fields.Selection(
        [
            ("statement", "Statement"),
            ("day", "Day"),
            ("week", "Week"),
            ("month", "Month"),
        ],
        string="Reconcile aggregation",
        help="Aggregation to use on reconcile view",
    )

    def get_rainbowman_message(self):
        self.ensure_one()
        if (
            self._get_journal_dashboard_data_batched()[self.id]["number_to_reconcile"]
            > 0
        ):
            return False
        return _("Well done! Everything has been reconciled")

    def open_action(self):
        """
        Return OCA *Reconcile All* when core *Bank Statements* tree is requested;
        leave other actions unchanged.
        """
        action = super().open_action()
        if action.get("xml_id") == "account.action_bank_statement_tree":
            action = self.env["ir.actions.actions"]._for_xml_id(
                "account_reconcile_oca.action_bank_statement_line_reconcile_all"
            )
        return action
