from collections import OrderedDict

grammar = OrderedDict(
    {
        "Telheader_Quelle": {
            "type": "str",
            "length": 10,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": "get_source",
        },
        "Telheader_Ziel": {
            "type": "str",
            "length": 10,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": "get_destination",
        },
        "Telheader_TelSeq": {
            "type": "int",
            "length": 6,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": "get_sequence_number",
        },
        "Telheader_AnlZeit": {
            "type": "datetime",
            "length": 14,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": "get_current_datetime",
        },
        "Satzart": {
            "type": "str",
            "length": 9,
            "dp": False,
            "ubl_path": False,
            "df_val": "KRETK0051",
            "df_func": False,
        },
        "RxKretk_KretId_Mand": {
            "type": "str",
            "length": 3,
            "dp": False,
            "ubl_path": False,
            "df_val": "000",
            "df_func": False,
        },
        "RxKretk_KretId_KretNr": {
            "type": "str",
            "length": 20,
            "dp": False,
            "ubl_path": "DespatchAdvice.cbc:ID",
            "df_val": False,
            "df_func": False,
        },
        "RxKretk_KretId_HostKretKz": {
            "type": "str",
            "length": 5,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": "get_source",
        },
        "RxKretk_ExtRef": {
            "type": "str",
            "length": 20,
            "dp": False,
            "ubl_path": "DespatchAdvice.cac:OrderReference.cbc:ID",
            "df_val": False,
            "df_func": False,
        },
        "RxKretk_KRETTYP_Typ": {
            "type": "str",
            "length": 6,
            "dp": False,
            "ubl_path": False,
            "df_val": "RETCLI",
            "df_func": False,
        },
        "RxKretk_KST_Mand": {
            "type": "str",
            "length": 3,
            "dp": False,
            "ubl_path": False,
            "df_val": "000",
            "df_func": False,
        },
        "RxKretk_KST_KuNr": {
            "type": "str",
            "length": 13,
            "dp": False,
            "ubl_path": "DespatchAdvice.cac:DespatchSupplierParty."
            "cbc:CustomerAssignedAccountID",
            "df_val": False,
            "df_func": False,
        },
        "RxKretk_Adrs_Name": {
            "type": "str",
            "length": 40,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": "supplier_get_Adrs_Name",
        },
        "RxKretk_Adrs_Name2": {
            "type": "str",
            "length": 40,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": "supplier_get_Adrs_Name2",
        },
        "RxKretk_Adrs_Name3": {
            "type": "str",
            "length": 40,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": "supplier_get_Adrs_Name3",
        },
        "RxKretk_Adrs_Name4": {
            "type": "str",
            "length": 40,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": "supplier_get_Adrs_Name4",
        },
        "RxKretk_Adrs_Anrede": {
            "type": "str",
            "length": 15,
            "dp": False,
            "ubl_path": "DespatchAdvice.cac:DespatchSupplierParty."
            "cac:Party.cac:Contact.cbc:Title",
            "df_val": False,
            "df_func": False,
        },
        "RxKretk_Adrs_Adr": {
            "type": "str",
            "length": 40,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": "supplier_get_Adrs_Adr",
        },
        "RxKretk_Adrs_Adr2": {
            "type": "str",
            "length": 40,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": False,
        },
        "RxKretk_Adrs_PLZ": {
            "type": "str",
            "length": 10,
            "dp": False,
            "ubl_path": "DespatchAdvice.cac:DespatchSupplierParty."
            "cac:Party.cac:PostalAddress.cbc:PostalZone",
            "df_val": False,
            "df_func": False,
        },
        "RxKretk_Adrs_Ort": {
            "type": "str",
            "length": 40,
            "dp": False,
            "ubl_path": "DespatchAdvice.cac:DespatchSupplierParty."
            "cac:Party.cac:PostalAddress.cbc:CityName",
            "df_val": False,
            "df_func": False,
        },
        "RxKretk_Adrs_OrtTeil": {
            "type": "str",
            "length": 40,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": False,
        },
        "RxKretk_Adrs_Land": {
            "type": "str",
            "length": 4,
            "dp": False,
            "ubl_path": "DespatchAdvice.cac:DespatchSupplierParty."
            "cac:Party.cac:PostalAddress.cac:Country.cbc:IdentificationCode",
            "df_val": False,
            "df_func": False,
        },
        "RxKretk_Adrs_Tel": {
            "type": "str",
            "length": 35,
            "dp": False,
            "ubl_path": "DespatchAdvice.cac:DespatchSupplierParty."
            "cac:Party.cac:Contact.cbc:Telephone",
            "df_val": False,
            "df_func": False,
        },
        "RxKretk_Adrs_Email": {
            "type": "str",
            "length": 40,
            "dp": False,
            "ubl_path": "DespatchAdvice.cac:DespatchSupplierParty."
            "cac:Party.cac:Contact.cbc:ElectronicMail",
            "df_val": False,
            "df_func": False,
        },
        "RxKretk_Adrs_Fax": {
            "type": "str",
            "length": 35,
            "dp": False,
            "ubl_path": "DespatchAdvice.cac:DespatchSupplierParty."
            "cac:Party.cac:Contact.cbc:Telefax",
            "df_val": False,
            "df_func": False,
        },
        "RxKretk_Adrs_WWW": {
            "type": "str",
            "length": 35,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": False,
        },
        "RxKretk_Adrs_ILN": {
            "type": "str",
            "length": 13,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": False,
        },
        "RxKretk_KretFlaeche_FeldId": {
            "type": "str",
            "length": 14,
            "dp": False,
            "ubl_path": False,
            "df_val": "SF-EM-RETCLI",
            "df_func": False,
        },
        "RxKretk_Info2Wamas": {
            "type": "str",
            "length": 77,
            "dp": False,
            "ubl_path": "DespatchAdvice.cbc:Note",
            "df_val": False,
            "df_func": False,
        },
        "RxKretk_LiefTerm": {
            "type": "datetime",
            "length": 14,
            "dp": False,
            "ubl_path": [
                "DespatchAdvice.cac:Shipment.cac:Delivery."
                "cac:EstimatedDeliveryPeriod.cbc:EndDate",
                "DespatchAdvice.cac:Shipment.cac:Delivery."
                "cac:EstimatedDeliveryPeriod.cbc:EndTime",
            ],
            "df_val": False,
            "df_func": False,
        },
        "RxKretk_TOR_Tor": {
            "type": "str",
            "length": 10,
            "dp": False,
            "ubl_path": False,
            "df_val": False,
            "df_func": False,
        },
    }
)
