# Copyright 2021 ACSONE SA/NV (<http://acsone.eu>)
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl.html).

from odoo import fields, models


class SaleOrder(models.Model):
    _inherit = "sale.order"

    contract_auto_confirm = fields.Boolean(
        compute="_compute_contract_auto_confirm",
        help="This is a technical field in order to know if the order should"
        "be automatically confirmed if generated by contract.",
    )

    def _compute_contract_auto_confirm(self):
        sale_auto_confirm = self.filtered(
            lambda sale: any(
                line.contract_line_id.contract_id.sale_autoconfirm
                for line in sale.order_line
            )
        )
        sale_auto_confirm.contract_auto_confirm = True
        (self - sale_auto_confirm).contract_auto_confirm = False
