# -*- coding: utf-8 -*-
##############################################################################
#
#    Odoo, Open Source Management Solution
#    Copyright (C) 2020-Today Entrivis Tech PVT. LTD. (<http://www.entrivistech.com>)
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>
#
##############################################################################
from odoo import models, fields, api, _


class MailTemplate(models.Model):
    _inherit = 'mail.template'

    email_bcc = fields.Char("Bcc")

    def generate_email(self, res_ids, fields):
        fields.append('email_bcc')
        return super(MailTemplate ,self).generate_email(res_ids, fields)

    def send_mail(self, res_id, force_send=False, raise_exception=False, email_values=None, notif_layout=False):
        return super(MailTemplate, self.with_context(with_bcc=self.email_bcc and True or False, with_email_bcc=self.email_bcc)).send_mail(
            res_id, force_send, raise_exception, email_values, notif_layout)


class MailMail(models.Model):
    _inherit = 'mail.mail'

    email_bcc = fields.Char("Bcc")

    @api.model
    def create(self, vals):
        if self.env.context.get('with_bcc') and self.env.context.get('with_email_bcc'):
            vals['email_bcc'] = self.env.context.get('with_email_bcc')
        return super(MailMail, self).create(vals)


class IrMailServer(models.Model):
    _inherit = "ir.mail_server"

    def build_email(self, email_from, email_to, subject, body, email_cc=None, email_bcc=None, reply_to=False,
                attachments=None, message_id=None, references=None, object_id=False, subtype='plain', headers=None,
                body_alternative=None, subtype_alternative='plain'):
        email_bcc = email_bcc and (email_bcc + ',' + self.env.context.get('with_email_bcc')) or self.env.context.get('with_email_bcc')
        return super().build_email(email_from, email_to, subject, body, email_cc, email_bcc, reply_to,
                attachments, message_id, references, object_id, subtype, headers,
                body_alternative, subtype_alternative)

