# -*- coding: utf-8 -*-
##############################################################################
#
#    Author: Joël Grand-Guillaume
#    Copyright 2012 Camptocamp SA
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import fields
from osv.orm import Model
import decimal_precision as dp

class Product(Model):
    """Add floor price to product"""
    _inherit = 'product.product'
    _columns = {'floor_price_limit': fields.float('Floor Price',
                                                  digits_compute=dp.get_precision('Sale Price'),
                                                  help="Floor price for this product:"
                                                  "salesmen will not be able to make"
                                                  "a discount in SO below that price.")}
