# Copyright (c) 2019, Link IT Europe Srl
# @author: Matteo Bilotta <mbilotta@linkeurope.it>

from odoo import api, fields, models


class PurchaseOrder(models.Model):
    _inherit = 'purchase.order'

    delivery_note_ids = fields.Many2many('stock.delivery.note',
                                         compute='_compute_delivery_notes')
    delivery_note_count = fields.Integer(compute='_compute_delivery_notes')

    @api.multi
    def _compute_delivery_notes(self):
        for order in self:
            delivery_notes = order.order_line.mapped(
                'delivery_note_line_ids.delivery_note_id')

            order.delivery_note_ids = delivery_notes
            order.delivery_note_count = len(delivery_notes)

    @api.multi
    def goto_delivery_notes(self, **kwargs):
        delivery_notes = self.mapped('delivery_note_ids')
        action = self.env.ref(
            'l10n_it_delivery_note.stock_delivery_note_action').read()[0]
        action.update(kwargs)

        if len(delivery_notes) > 1:
            action['domain'] = [('id', 'in', delivery_notes.ids)]

        elif len(delivery_notes) == 1:
            action['views'] = [(
                self.env.ref(
                    'l10n_it_delivery_note.stock_delivery_note_form_view'
                ).id, 'form'
            )]
            action['res_id'] = delivery_notes.id

        else:
            action = {'type': 'ir.actions.act_window_close'}

        return action


class PurchaseOrderLine(models.Model):
    _inherit = 'purchase.order.line'

    delivery_note_line_ids = fields.One2many('stock.delivery.note.line',
                                             'purchase_line_id', readonly=True)
    delivery_picking_id = fields.Many2one('stock.picking', readonly=True,
                                          copy=False)
