# Copyright 2015 Pedro M. Baeza <pedro.baeza@tecnativa.com>
# Copyright 2015 Antonio Espinosa <antonio.espinosa@tecnativa.com>
# Copyright 2015 Javier Iniesta <javieria@antiun.com>
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl.html).

from . import base
from odoo.exceptions import UserError


class PartnerMailListWizardCase(base.BaseCase):

    def test_add_to_mail_list(self):
        wizard = self.env['partner.mail.list.wizard'].create(
            {'mail_list_id': self.mailing_list.id})
        wizard.partner_ids = [self.partner.id]
        wizard.add_to_mail_list()
        contacts = self.env['mail.mass_mailing.contact'].search([
            ('partner_id', '=', self.partner.id)])
        cont = contacts.filtered(lambda r: wizard.mail_list_id in r.list_ids)
        self.assertEqual(len(cont), 1)
        self.check_mailing_contact_partner(cont)
        # This line does not create a new contact
        wizard.add_to_mail_list()
        partner = self.env['res.partner'].create({'name': 'No email partner'})
        wizard.partner_ids = [partner.id]
        with self.assertRaises(UserError):
            wizard.add_to_mail_list()
