# -*- coding: utf-8 -*-
##############################################################################
#
#    Author: Guewen Baconnier
#    Copyright 2015 Camptocamp SA
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

# flake8: noqa : ignore style in this file because it is a data file
# only

"""
Magento responses for calls done by the connector.

This set of responses has been recorded for the synchronizations
with a Magento 1.7 version with demo data.

It has been recorded using ``magentoerpconnect.unit.backend_adapter.record``
and ``magentoerpconnect.unit.backend_adapter.output_recorder``
"""
import time

FMT = "%Y-%m-%d %H:%M:%S"

guest_order_responses = \
    {('sales_order.info', (900000700,)): {'adjustment_negative': None,
                                        'adjustment_positive': None,
                                        'applied_rule_ids': None,
                                        'base_adjustment_negative': None,
                                        'base_adjustment_positive': None,
                                        'base_currency_code': 'EUR',
                                        'base_custbalance_amount': None,
                                        'base_discount_amount': '0.0000',
                                        'base_discount_canceled': None,
                                        'base_discount_invoiced': None,
                                        'base_discount_refunded': None,
                                        'base_grand_total': '166.9400',
                                        'base_hidden_tax_amount': '0.0000',
                                        'base_hidden_tax_invoiced': None,
                                        'base_hidden_tax_refunded': None,
                                        'base_shipping_amount': '5.0000',
                                        'base_shipping_canceled': None,
                                        'base_shipping_discount_amount': '0.0000',
                                        'base_shipping_hidden_tax_amnt': '0.0000',
                                        'base_shipping_hidden_tax_amount': '0.0000',
                                        'base_shipping_incl_tax': '5.0000',
                                        'base_shipping_invoiced': None,
                                        'base_shipping_refunded': None,
                                        'base_shipping_tax_amount': '0.0000',
                                        'base_shipping_tax_refunded': None,
                                        'base_subtotal': '161.9400',
                                        'base_subtotal_canceled': None,
                                        'base_subtotal_incl_tax': '161.9400',
                                        'base_subtotal_invoiced': None,
                                        'base_subtotal_refunded': None,
                                        'base_tax_amount': '0.0000',
                                        'base_tax_canceled': None,
                                        'base_tax_invoiced': None,
                                        'base_tax_refunded': None,
                                        'base_to_global_rate': '1.0000',
                                        'base_to_order_rate': '1.0000',
                                        'base_total_canceled': None,
                                        'base_total_due': None,
                                        'base_total_invoiced': None,
                                        'base_total_invoiced_cost': None,
                                        'base_total_offline_refunded': None,
                                        'base_total_online_refunded': None,
                                        'base_total_paid': None,
                                        'base_total_qty_ordered': None,
                                        'base_total_refunded': None,
                                        'billing_address': {'address_id': '15',
                                                            'address_type': 'billing',
                                                            'city': 'Oberehrendingen',
                                                            'company': None,
                                                            'country_id': 'CH',
                                                            'customer_address_id': None,
                                                            'customer_id': None,
                                                            'email': 'chtrokatoral@example.com',
                                                            'fax': None,
                                                            'firstname': "Ch'Troka",
                                                            'gift_message_id': None,
                                                            'lastname': 'Toral',
                                                            'middlename': None,
                                                            'parent_id': '8',
                                                            'postcode': '5420',
                                                            'prefix': None,
                                                            'quote_address_id': None,
                                                            'region': 'Aargau',
                                                            'region_id': '104',
                                                            'street': 'Clius 25',
                                                            'suffix': None,
                                                            'tax_id': None,
                                                            'telephone': '056 524 10 76',
                                                            'vat_id': None,
                                                            'vat_is_valid': None,
                                                            'vat_request_date': None,
                                                            'vat_request_id': None,
                                                            'vat_request_success': None},
                                        'billing_address_id': '15',
                                        'can_ship_partially': None,
                                        'can_ship_partially_item': None,
                                        'coupon_code': None,
                                        'coupon_rule_name': None,
                                        'created_at': time.strftime(FMT),
                                        'currency_base_id': None,
                                        'currency_code': None,
                                        'currency_rate': None,
                                        'custbalance_amount': None,
                                        'customer_dob': None,
                                        'customer_email': 'ChTrokaToral@rhyta.com',
                                        'customer_firstname': "Ch'Troka",
                                        'customer_gender': None,
                                        'customer_group_id': '0',
                                        'customer_id': 'guestorder:900000700',
                                        'customer_is_guest': True,
                                        'customer_lastname': 'Toral',
                                        'customer_middlename': None,
                                        'customer_note': None,
                                        'customer_note_notify': '1',
                                        'customer_prefix': None,
                                        'customer_suffix': None,
                                        'customer_taxvat': None,
                                        'discount_amount': '0.0000',
                                        'discount_canceled': None,
                                        'discount_description': None,
                                        'discount_invoiced': None,
                                        'discount_refunded': None,
                                        'edit_increment': None,
                                        'email_sent': '1',
                                        'ext_customer_id': None,
                                        'ext_order_id': None,
                                        'forced_do_shipment_with_invoice': None,
                                        'forced_shipment_with_invoice': None,
                                        'gift_message_id': None,
                                        'global_currency_code': 'EUR',
                                        'grand_total': '166.9400',
                                        'hidden_tax_amount': '0.0000',
                                        'hidden_tax_invoiced': None,
                                        'hidden_tax_refunded': None,
                                        'hold_before_state': None,
                                        'hold_before_status': None,
                                        'imported': '0',
                                        'increment_id': '900000700',
                                        'is_hold': None,
                                        'is_multi_payment': None,
                                        'is_virtual': '0',
                                        'items': [{'additional_data': None,
                                                   'amount_refunded': '0.0000',
                                                   'applied_rule_ids': None,
                                                   'base_amount_refunded': '0.0000',
                                                   'base_cost': '29.9900',
                                                   'base_discount_amount': '0.0000',
                                                   'base_discount_invoiced': '0.0000',
                                                   'base_discount_refunded': None,
                                                   'base_hidden_tax_amount': None,
                                                   'base_hidden_tax_invoiced': None,
                                                   'base_hidden_tax_refunded': None,
                                                   'base_original_price': '161.9400',
                                                   'base_price': '161.9400',
                                                   'base_price_incl_tax': '161.9400',
                                                   'base_row_invoiced': '0.0000',
                                                   'base_row_total': '161.9400',
                                                   'base_row_total_incl_tax': '161.9400',
                                                   'base_tax_amount': '0.0000',
                                                   'base_tax_before_discount': None,
                                                   'base_tax_invoiced': '0.0000',
                                                   'base_tax_refunded': None,
                                                   'base_weee_tax_applied_amount': '0.0000',
                                                   'base_weee_tax_applied_row_amnt': '0.0000',
                                                   'base_weee_tax_applied_row_amount': '0.0000',
                                                   'base_weee_tax_disposition': '0.0000',
                                                   'base_weee_tax_row_disposition': '0.0000',
                                                   'created_at': time.strftime(FMT),
                                                   'description': None,
                                                   'discount_amount': '0.0000',
                                                   'discount_invoiced': '0.0000',
                                                   'discount_percent': '0.0000',
                                                   'discount_refunded': None,
                                                   'ext_order_item_id': None,
                                                   'free_shipping': '0',
                                                   'gift_message_available': None,
                                                   'gift_message_id': None,
                                                   'hidden_tax_amount': None,
                                                   'hidden_tax_canceled': None,
                                                   'hidden_tax_invoiced': None,
                                                   'hidden_tax_refunded': None,
                                                   'is_nominal': '0',
                                                   'is_qty_decimal': '0',
                                                   'is_virtual': '0',
                                                   'item_id': '11',
                                                   'locked_do_invoice': None,
                                                   'locked_do_ship': None,
                                                   'name': ' Olympus Stylus 750 7.1MP Digital Camera',
                                                   'no_discount': '0',
                                                   'order_id': '8',
                                                   'original_price': '161.9400',
                                                   'parent_item_id': None,
                                                   'price': '161.9400',
                                                   'price_incl_tax': '161.9400',
                                                   'product_id': '46',
                                                   'product_options': 'a:1:{s:15:"info_buyRequest";a:4:{s:4:"uenc";s:116:"aHR0cDovL2xvY2FsaG9zdDo5MTAwL2luZGV4LnBocC9vbHltcHVzLXN0eWx1cy03NTAtNy0xbXAtZGlnaXRhbC1jYW1lcmEuaHRtbD9fX19TSUQ9VQ,,";s:7:"product";s:2:"46";s:15:"related_product";s:0:"";s:3:"qty";s:1:"1";}}',
                                                   'product_type': 'simple',
                                                   'qty_backordered': None,
                                                   'qty_canceled': '0.0000',
                                                   'qty_invoiced': '0.0000',
                                                   'qty_ordered': '1.0000',
                                                   'qty_refunded': '0.0000',
                                                   'qty_shipped': '0.0000',
                                                   'quote_item_id': '11',
                                                   'row_invoiced': '0.0000',
                                                   'row_total': '161.9400',
                                                   'row_total_incl_tax': '161.9400',
                                                   'row_weight': '2.0000',
                                                   'sku': '750',
                                                   'store_id': '1',
                                                   'tax_amount': '0.0000',
                                                   'tax_before_discount': None,
                                                   'tax_canceled': None,
                                                   'tax_invoiced': '0.0000',
                                                   'tax_percent': '0.0000',
                                                   'tax_refunded': None,
                                                   'updated_at': '2015-03-19 12:57:14',
                                                   'weee_tax_applied': 'a:0:{}',
                                                   'weee_tax_applied_amount': '0.0000',
                                                   'weee_tax_applied_row_amount': '0.0000',
                                                   'weee_tax_disposition': '0.0000',
                                                   'weee_tax_row_disposition': '0.0000',
                                                   'weight': '2.0000'}],
                                        'order_currency_code': 'EUR',
                                        'order_id': '8',
                                        'original_increment_id': None,
                                        'payment': {'account_status': None,
                                                    'additional_data': None,
                                                    'additional_information': [],
                                                    'address_status': None,
                                                    'amount': None,
                                                    'amount_authorized': None,
                                                    'amount_canceled': None,
                                                    'amount_ordered': '166.9400',
                                                    'amount_paid': None,
                                                    'amount_refunded': None,
                                                    'anet_trans_method': None,
                                                    'base_amount_authorized': None,
                                                    'base_amount_canceled': None,
                                                    'base_amount_ordered': '166.9400',
                                                    'base_amount_paid': None,
                                                    'base_amount_paid_online': None,
                                                    'base_amount_refunded': None,
                                                    'base_amount_refunded_online': None,
                                                    'base_shipping_amount': '5.0000',
                                                    'base_shipping_captured': None,
                                                    'base_shipping_refunded': None,
                                                    'cc_approval': None,
                                                    'cc_avs_status': None,
                                                    'cc_cid_status': None,
                                                    'cc_debug_request_body': None,
                                                    'cc_debug_response_body': None,
                                                    'cc_debug_response_serialized': None,
                                                    'cc_exp_month': '0',
                                                    'cc_exp_year': '0',
                                                    'cc_last4': None,
                                                    'cc_number_enc': None,
                                                    'cc_owner': None,
                                                    'cc_raw_request': None,
                                                    'cc_raw_response': None,
                                                    'cc_secure_verify': None,
                                                    'cc_ss_issue': None,
                                                    'cc_ss_start_month': '0',
                                                    'cc_ss_start_year': '0',
                                                    'cc_status': None,
                                                    'cc_status_description': None,
                                                    'cc_trans_id': None,
                                                    'cc_type': None,
                                                    'customer_payment_id': None,
                                                    'cybersource_token': None,
                                                    'echeck_account_name': None,
                                                    'echeck_account_type': None,
                                                    'echeck_bank_name': None,
                                                    'echeck_routing_number': None,
                                                    'echeck_type': None,
                                                    'flo2cash_account_id': None,
                                                    'ideal_issuer_id': None,
                                                    'ideal_issuer_title': None,
                                                    'ideal_transaction_checked': None,
                                                    'last_trans_id': None,
                                                    'method': 'checkmo',
                                                    'parent_id': '8',
                                                    'paybox_question_number': None,
                                                    'paybox_request_number': None,
                                                    'payment_id': '8',
                                                    'po_number': None,
                                                    'protection_eligibility': None,
                                                    'quote_payment_id': None,
                                                    'shipping_amount': '5.0000',
                                                    'shipping_captured': None,
                                                    'shipping_refunded': None},
                                        'payment_auth_expiration': None,
                                        'payment_authorization_amount': None,
                                        'payment_authorization_expiration': None,
                                        'paypal_ipn_customer_notified': None,
                                        'protect_code': 'db6fd3',
                                        'quote_address_id': None,
                                        'quote_id': '9',
                                        'real_order_id': None,
                                        'relation_child_id': None,
                                        'relation_child_real_id': None,
                                        'relation_parent_id': None,
                                        'relation_parent_real_id': None,
                                        'remote_ip': '10.0.2.2',
                                        'shipping_address': {'address_id': '16',
                                                             'address_type': 'shipping',
                                                             'city': 'Oberehrendingen',
                                                             'company': None,
                                                             'country_id': 'CH',
                                                             'customer_address_id': None,
                                                             'customer_id': None,
                                                             'email': 'ChTrokaToral@rhyta.com',
                                                             'fax': None,
                                                             'firstname': "Ch'Troka",
                                                             'gift_message_id': None,
                                                             'lastname': 'Toral',
                                                             'middlename': None,
                                                             'parent_id': '8',
                                                             'postcode': '5420',
                                                             'prefix': None,
                                                             'quote_address_id': None,
                                                             'region': 'Aargau',
                                                             'region_id': '104',
                                                             'street': 'Clius 25',
                                                             'suffix': None,
                                                             'tax_id': None,
                                                             'telephone': '056 524 10 76',
                                                             'vat_id': None,
                                                             'vat_is_valid': None,
                                                             'vat_request_date': None,
                                                             'vat_request_id': None,
                                                             'vat_request_success': None},
                                        'shipping_address_id': '16',
                                        'shipping_amount': '5.0000',
                                        'shipping_canceled': None,
                                        'shipping_description': 'Flat Rate - Fixed',
                                        'shipping_discount_amount': '0.0000',
                                        'shipping_hidden_tax_amount': '0.0000',
                                        'shipping_incl_tax': '5.0000',
                                        'shipping_invoiced': None,
                                        'shipping_method': 'flatrate_flatrate',
                                        'shipping_refunded': None,
                                        'shipping_tax_amount': '0.0000',
                                        'shipping_tax_refunded': None,
                                        'state': 'new',
                                        'status': 'pending',
                                        'status_history': [{'comment': None,
                                                            'created_at': time.strftime(FMT),
                                                            'entity_name': 'order',
                                                            'is_customer_notified': '1',
                                                            'is_visible_on_front': '0',
                                                            'parent_id': '8',
                                                            'status': 'pending',
                                                            'store_id': '1'}],
                                        'store_currency_code': 'EUR',
                                        'store_id': '1',
                                        'store_name': 'Main Website\nMain Store\nEnglish',
                                        'store_to_base_rate': '1.0000',
                                        'store_to_order_rate': '1.0000',
                                        'subtotal': '161.9400',
                                        'subtotal_canceled': None,
                                        'subtotal_incl_tax': '161.9400',
                                        'subtotal_invoiced': None,
                                        'subtotal_refunded': None,
                                        'tax_amount': '0.0000',
                                        'tax_canceled': None,
                                        'tax_invoiced': None,
                                        'tax_percent': None,
                                        'tax_refunded': None,
                                        'total_canceled': None,
                                        'total_due': None,
                                        'total_invoiced': None,
                                        'total_item_count': '1',
                                        'total_offline_refunded': None,
                                        'total_online_refunded': None,
                                        'total_paid': None,
                                        'total_qty_ordered': '1.0000',
                                        'total_refunded': None,
                                        'tracking_numbers': None,
                                        'updated_at': '2015-03-19 12:57:14',
                                        'website_id': u'1',
                                        'weight': '2.0000',
                                        'x_forwarded_for': None},
}
