# -*- coding: utf-8 -*-
##############################################################################
#
#    Author: Guewen Baconnier
#    Copyright 2013 Camptocamp SA
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

# flake8: noqa : ignore style in this file because it is a data file
# only

"""
Magento responses for calls done by the connector.

This set of responses has been recorded for the synchronizations
with a Magento 1.7 version with demo data.

It has been recorded using ``magentoerpconnect.unit.backend_adapter.record``
and ``magentoerpconnect.unit.backend_adapter.output_recorder``
"""
import time


FMT = "%Y-%m-%d %H:%M:%S"


magento_base_responses = \
    {('catalog_category.info', (1, )): {'all_children': '1,3,10,22,23,13,12,25,26,15,27,28,29,30,31,32,33,34,8,18,19,4,5,16,17',
                                                  'available_sort_by': None,
                                                  'category_id': '1',
                                                  'children': '3',
                                                  'created_at': '2007-07-20 18:46:08',
                                                  'custom_apply_to_products': None,
                                                  'custom_design': None,
                                                  'custom_design_from': None,
                                                  'custom_design_to': None,
                                                  'custom_layout_update': None,
                                                  'custom_use_parent_settings': None,
                                                  'default_sort_by': None,
                                                  'description': None,
                                                  'display_mode': None,
                                                  'filter_price_range': None,
                                                  'image': None,
                                                  'include_in_menu': '1',
                                                  'increment_id': None,
                                                  'is_active': '1',
                                                  'is_anchor': None,
                                                  'landing_page': None,
                                                  'level': '0',
                                                  'meta_description': None,
                                                  'meta_keywords': None,
                                                  'meta_title': None,
                                                  'name': None,
                                                  'page_layout': None,
                                                  'parent_id': 0,
                                                  'path': '1',
                                                  'path_in_store': None,
                                                  'position': '1',
                                                  'thumbnail': None,
                                                  'updated_at': '2007-08-07 09:50:15',
                                                  'url_key': None,
                                                  'url_path': None},
     ('catalog_category.info', (1, u'2', )): {'all_children': '1,3,10,22,23,13,12,25,26,15,27,28,29,30,31,32,33,34,8,18,19,4,5,16,17',
                                                  'available_sort_by': None,
                                                  'category_id': '1',
                                                  'children': '3',
                                                  'created_at': '2007-07-20 18:46:08',
                                                  'custom_apply_to_products': None,
                                                  'custom_design': None,
                                                  'custom_design_from': None,
                                                  'custom_design_to': None,
                                                  'custom_layout_update': None,
                                                  'custom_use_parent_settings': None,
                                                  'default_sort_by': None,
                                                  'description': None,
                                                  'display_mode': None,
                                                  'filter_price_range': None,
                                                  'image': None,
                                                  'include_in_menu': '1',
                                                  'increment_id': None,
                                                  'is_active': '1',
                                                  'is_anchor': None,
                                                  'landing_page': None,
                                                  'level': '0',
                                                  'meta_description': None,
                                                  'meta_keywords': None,
                                                  'meta_title': None,
                                                  'name': None,
                                                  'page_layout': None,
                                                  'parent_id': 0,
                                                  'path': '1',
                                                  'path_in_store': None,
                                                  'position': '1',
                                                  'thumbnail': None,
                                                  'updated_at': '2007-08-07 09:50:15',
                                                  'url_key': None,
                                                  'url_path': None},
        ('catalog_category.info', (1, u'3', )): {'all_children': '1,3,10,22,23,13,12,25,26,15,27,28,29,30,31,32,33,34,8,18,19,4,5,16,17',
                                                     'available_sort_by': None,
                                                     'category_id': '1',
                                                     'children': '3',
                                                     'created_at': '2007-07-20 18:46:08',
                                                     'custom_apply_to_products': None,
                                                     'custom_design': None,
                                                     'custom_design_from': None,
                                                     'custom_design_to': None,
                                                     'custom_layout_update': None,
                                                     'custom_use_parent_settings': None,
                                                     'default_sort_by': None,
                                                     'description': None,
                                                     'display_mode': None,
                                                     'filter_price_range': None,
                                                     'image': None,
                                                     'include_in_menu': '1',
                                                     'increment_id': None,
                                                     'is_active': '1',
                                                     'is_anchor': None,
                                                     'landing_page': None,
                                                     'level': '0',
                                                     'meta_description': None,
                                                     'meta_keywords': None,
                                                     'meta_title': None,
                                                     'name': None,
                                                     'page_layout': None,
                                                     'parent_id': 0,
                                                     'path': '1',
                                                     'path_in_store': None,
                                                     'position': '1',
                                                     'thumbnail': None,
                                                     'updated_at': '2007-08-07 09:50:15',
                                                     'url_key': None,
                                                     'url_path': None},
        ('catalog_category.info', (3, )): {'all_children': '3,10,22,23,13,12,25,26,15,27,28,29,30,31,32,33,34,8,18,19,4,5,16,17',
                                                     'available_sort_by': None,
                                                     'category_id': '3',
                                                     'children': '10,13,18',
                                                     'created_at': '2007-08-22 15:54:41',
                                                     'custom_apply_to_products': None,
                                                     'custom_design': None,
                                                     'custom_design_from': None,
                                                     'custom_design_to': None,
                                                     'custom_layout_update': None,
                                                     'custom_use_parent_settings': None,
                                                     'default_sort_by': None,
                                                     'description': None,
                                                     'display_mode': 'PRODUCTS',
                                                     'filter_price_range': None,
                                                     'image': None,
                                                     'include_in_menu': '1',
                                                     'increment_id': None,
                                                     'is_active': '1',
                                                     'is_anchor': None,
                                                     'landing_page': None,
                                                     'level': '1',
                                                     'meta_description': None,
                                                     'meta_keywords': None,
                                                     'meta_title': None,
                                                     'name': 'Root Catalog',
                                                     'page_layout': None,
                                                     'parent_id': 1,
                                                     'path': '1/3',
                                                     'path_in_store': '',
                                                     'position': '3',
                                                     'thumbnail': None,
                                                     'updated_at': '2007-12-05 04:38:59',
                                                     'url_key': 'root-catalog',
                                                     'url_path': None},
        ('catalog_category.info', (3, u'2', )): {'all_children': '3,10,22,23,13,12,25,26,15,27,28,29,30,31,32,33,34,8,18,19,4,5,16,17',
                                                     'available_sort_by': None,
                                                     'category_id': '3',
                                                     'children': '10,13,18',
                                                     'created_at': '2007-08-22 15:54:41',
                                                     'custom_apply_to_products': None,
                                                     'custom_design': None,
                                                     'custom_design_from': None,
                                                     'custom_design_to': None,
                                                     'custom_layout_update': None,
                                                     'custom_use_parent_settings': None,
                                                     'default_sort_by': None,
                                                     'description': None,
                                                     'display_mode': 'PRODUCTS',
                                                     'filter_price_range': None,
                                                     'image': None,
                                                     'include_in_menu': '1',
                                                     'increment_id': None,
                                                     'is_active': '1',
                                                     'is_anchor': None,
                                                     'landing_page': None,
                                                     'level': '1',
                                                     'meta_description': None,
                                                     'meta_keywords': None,
                                                     'meta_title': None,
                                                     'name': 'Root Catalog',
                                                     'page_layout': None,
                                                     'parent_id': 1,
                                                     'path': '1/3',
                                                     'path_in_store': '',
                                                     'position': '3',
                                                     'thumbnail': None,
                                                     'updated_at': '2007-12-05 04:38:59',
                                                     'url_key': 'root-catalog',
                                                     'url_path': None},
        ('catalog_category.info', (3, u'3', )): {'all_children': '3,10,22,23,13,12,25,26,15,27,28,29,30,31,32,33,34,8,18,19,4,5,16,17',
                                                     'available_sort_by': None,
                                                     'category_id': '3',
                                                     'children': '10,13,18',
                                                     'created_at': '2007-08-22 15:54:41',
                                                     'custom_apply_to_products': None,
                                                     'custom_design': None,
                                                     'custom_design_from': None,
                                                     'custom_design_to': None,
                                                     'custom_layout_update': None,
                                                     'custom_use_parent_settings': None,
                                                     'default_sort_by': None,
                                                     'description': None,
                                                     'display_mode': 'PRODUCTS',
                                                     'filter_price_range': None,
                                                     'image': None,
                                                     'include_in_menu': '1',
                                                     'increment_id': None,
                                                     'is_active': '1',
                                                     'is_anchor': None,
                                                     'landing_page': None,
                                                     'level': '1',
                                                     'meta_description': None,
                                                     'meta_keywords': None,
                                                     'meta_title': None,
                                                     'name': 'Root Catalog',
                                                     'page_layout': None,
                                                     'parent_id': 1,
                                                     'path': '1/3',
                                                     'path_in_store': '',
                                                     'position': '3',
                                                     'thumbnail': None,
                                                     'updated_at': '2007-12-05 04:38:59',
                                                     'url_key': 'root-catalog',
                                                     'url_path': None},
        ('catalog_category.info', (4, )): {'all_children': '4',
                                                     'available_sort_by': None,
                                                     'category_id': '4',
                                                     'children': '',
                                                     'created_at': '2007-08-22 15:55:34',
                                                     'custom_apply_to_products': '1',
                                                     'custom_design': '',
                                                     'custom_design_from': None,
                                                     'custom_design_to': None,
                                                     'custom_layout_update': '',
                                                     'custom_use_parent_settings': '1',
                                                     'default_sort_by': None,
                                                     'description': '',
                                                     'display_mode': 'PRODUCTS',
                                                     'filter_price_range': None,
                                                     'image': 'shirts.jpg',
                                                     'include_in_menu': '1',
                                                     'increment_id': None,
                                                     'is_active': '1',
                                                     'is_anchor': '1',
                                                     'landing_page': None,
                                                     'level': '3',
                                                     'meta_description': '',
                                                     'meta_keywords': '',
                                                     'meta_title': '',
                                                     'name': 'Shirts',
                                                     'page_layout': '',
                                                     'parent_id': 18,
                                                     'path': '1/3/18/4',
                                                     'path_in_store': '4,18',
                                                     'position': '4',
                                                     'thumbnail': None,
                                                     'updated_at': '2008-08-08 00:56:48',
                                                     'url_key': 'shirts',
                                                     'url_path': 'apparel/shirts.html'},
        ('catalog_category.info', (4, u'2', )): {'all_children': '4',
                                                     'available_sort_by': None,
                                                     'category_id': '4',
                                                     'children': '',
                                                     'created_at': '2007-08-22 15:55:34',
                                                     'custom_apply_to_products': '1',
                                                     'custom_design': '',
                                                     'custom_design_from': None,
                                                     'custom_design_to': None,
                                                     'custom_layout_update': '',
                                                     'custom_use_parent_settings': '1',
                                                     'default_sort_by': None,
                                                     'description': '',
                                                     'display_mode': 'PRODUCTS',
                                                     'filter_price_range': None,
                                                     'image': 'shirts.jpg',
                                                     'include_in_menu': '1',
                                                     'increment_id': None,
                                                     'is_active': '1',
                                                     'is_anchor': '1',
                                                     'landing_page': None,
                                                     'level': '3',
                                                     'meta_description': '',
                                                     'meta_keywords': '',
                                                     'meta_title': '',
                                                     'name': 'Shirts',
                                                     'page_layout': '',
                                                     'parent_id': 18,
                                                     'path': '1/3/18/4',
                                                     'path_in_store': '4,18',
                                                     'position': '4',
                                                     'thumbnail': None,
                                                     'updated_at': '2008-08-08 00:56:48',
                                                     'url_key': 'shirts',
                                                     'url_path': 'apparel/shirts.html'},
        ('catalog_category.info', (4, u'3', )): {'all_children': '4',
                                                     'available_sort_by': None,
                                                     'category_id': '4',
                                                     'children': '',
                                                     'created_at': '2007-08-22 15:55:34',
                                                     'custom_apply_to_products': '1',
                                                     'custom_design': '',
                                                     'custom_design_from': None,
                                                     'custom_design_to': None,
                                                     'custom_layout_update': '',
                                                     'custom_use_parent_settings': '1',
                                                     'default_sort_by': None,
                                                     'description': '',
                                                     'display_mode': 'PRODUCTS',
                                                     'filter_price_range': None,
                                                     'image': 'shirts.jpg',
                                                     'include_in_menu': '1',
                                                     'increment_id': None,
                                                     'is_active': '1',
                                                     'is_anchor': '1',
                                                     'landing_page': None,
                                                     'level': '3',
                                                     'meta_description': '',
                                                     'meta_keywords': '',
                                                     'meta_title': '',
                                                     'name': 'Shirts',
                                                     'page_layout': '',
                                                     'parent_id': 18,
                                                     'path': '1/3/18/4',
                                                     'path_in_store': '4,18',
                                                     'position': '4',
                                                     'thumbnail': None,
                                                     'updated_at': '2008-08-08 00:56:48',
                                                     'url_key': 'shirts',
                                                     'url_path': 'apparel/shirts.html'},
        ('catalog_category.info', (5, )): {'all_children': '5,16,17',
                                                     'available_sort_by': None,
                                                     'category_id': '5',
                                                     'children': '16,17',
                                                     'created_at': '2007-08-22 16:21:29',
                                                     'custom_apply_to_products': '1',
                                                     'custom_design': '',
                                                     'custom_design_from': None,
                                                     'custom_design_to': None,
                                                     'custom_layout_update': '',
                                                     'custom_use_parent_settings': '1',
                                                     'default_sort_by': None,
                                                     'description': '',
                                                     'display_mode': 'PRODUCTS',
                                                     'filter_price_range': None,
                                                     'image': 'shoes.jpg',
                                                     'include_in_menu': '1',
                                                     'increment_id': None,
                                                     'is_active': '1',
                                                     'is_anchor': '1',
                                                     'landing_page': None,
                                                     'level': '3',
                                                     'meta_description': '',
                                                     'meta_keywords': '',
                                                     'meta_title': '',
                                                     'name': 'Shoes',
                                                     'page_layout': '',
                                                     'parent_id': 18,
                                                     'path': '1/3/18/5',
                                                     'path_in_store': '5,18',
                                                     'position': '5',
                                                     'thumbnail': None,
                                                     'updated_at': '2008-08-07 23:55:38',
                                                     'url_key': 'shoes',
                                                     'url_path': 'apparel/shoes.html'},
        ('catalog_category.info', (5, u'2', )): {'all_children': '5,16,17',
                                                     'available_sort_by': None,
                                                     'category_id': '5',
                                                     'children': '16,17',
                                                     'created_at': '2007-08-22 16:21:29',
                                                     'custom_apply_to_products': '1',
                                                     'custom_design': '',
                                                     'custom_design_from': None,
                                                     'custom_design_to': None,
                                                     'custom_layout_update': '',
                                                     'custom_use_parent_settings': '1',
                                                     'default_sort_by': None,
                                                     'description': '',
                                                     'display_mode': 'PRODUCTS',
                                                     'filter_price_range': None,
                                                     'image': 'shoes.jpg',
                                                     'include_in_menu': '1',
                                                     'increment_id': None,
                                                     'is_active': '1',
                                                     'is_anchor': '1',
                                                     'landing_page': None,
                                                     'level': '3',
                                                     'meta_description': '',
                                                     'meta_keywords': '',
                                                     'meta_title': '',
                                                     'name': 'Shoes',
                                                     'page_layout': '',
                                                     'parent_id': 18,
                                                     'path': '1/3/18/5',
                                                     'path_in_store': '5,18',
                                                     'position': '5',
                                                     'thumbnail': None,
                                                     'updated_at': '2008-08-07 23:55:38',
                                                     'url_key': 'shoes',
                                                     'url_path': 'apparel/shoes.html'},
        ('catalog_category.info', (5, u'3', )): {'all_children': '5,16,17',
                                                     'available_sort_by': None,
                                                     'category_id': '5',
                                                     'children': '16,17',
                                                     'created_at': '2007-08-22 16:21:29',
                                                     'custom_apply_to_products': '1',
                                                     'custom_design': '',
                                                     'custom_design_from': None,
                                                     'custom_design_to': None,
                                                     'custom_layout_update': '',
                                                     'custom_use_parent_settings': '1',
                                                     'default_sort_by': None,
                                                     'description': '',
                                                     'display_mode': 'PRODUCTS',
                                                     'filter_price_range': None,
                                                     'image': 'shoes.jpg',
                                                     'include_in_menu': '1',
                                                     'increment_id': None,
                                                     'is_active': '1',
                                                     'is_anchor': '1',
                                                     'landing_page': None,
                                                     'level': '3',
                                                     'meta_description': '',
                                                     'meta_keywords': '',
                                                     'meta_title': '',
                                                     'name': 'Shoes',
                                                     'page_layout': '',
                                                     'parent_id': 18,
                                                     'path': '1/3/18/5',
                                                     'path_in_store': '5,18',
                                                     'position': '5',
                                                     'thumbnail': None,
                                                     'updated_at': '2008-08-07 23:55:38',
                                                     'url_key': 'shoes',
                                                     'url_path': 'apparel/shoes.html'},
        ('catalog_category.info', (8, )): {'all_children': '8',
                                                     'available_sort_by': None,
                                                     'category_id': '8',
                                                     'children': '',
                                                     'created_at': '2007-08-22 18:10:30',
                                                     'custom_apply_to_products': '1',
                                                     'custom_design': '',
                                                     'custom_design_from': None,
                                                     'custom_design_to': None,
                                                     'custom_layout_update': '',
                                                     'custom_use_parent_settings': '1',
                                                     'default_sort_by': None,
                                                     'description': '',
                                                     'display_mode': 'PRODUCTS_AND_PAGE',
                                                     'filter_price_range': None,
                                                     'image': None,
                                                     'include_in_menu': '1',
                                                     'increment_id': None,
                                                     'is_active': '1',
                                                     'is_anchor': '1',
                                                     'landing_page': '4',
                                                     'level': '3',
                                                     'meta_description': '',
                                                     'meta_keywords': '',
                                                     'meta_title': '',
                                                     'name': 'Cell Phones',
                                                     'page_layout': '',
                                                     'parent_id': 13,
                                                     'path': '1/3/13/8',
                                                     'path_in_store': '8,13',
                                                     'position': '8',
                                                     'thumbnail': None,
                                                     'updated_at': '2008-08-07 23:51:26',
                                                     'url_key': 'cell-phones',
                                                     'url_path': 'electronics/cell-phones.html'},
        ('catalog_category.info', (8, u'2', )): {'all_children': '8',
                                                     'available_sort_by': None,
                                                     'category_id': '8',
                                                     'children': '',
                                                     'created_at': '2007-08-22 18:10:30',
                                                     'custom_apply_to_products': '1',
                                                     'custom_design': '',
                                                     'custom_design_from': None,
                                                     'custom_design_to': None,
                                                     'custom_layout_update': '',
                                                     'custom_use_parent_settings': '1',
                                                     'default_sort_by': None,
                                                     'description': '',
                                                     'display_mode': 'PRODUCTS_AND_PAGE',
                                                     'filter_price_range': None,
                                                     'image': None,
                                                     'include_in_menu': '1',
                                                     'increment_id': None,
                                                     'is_active': '1',
                                                     'is_anchor': '1',
                                                     'landing_page': '4',
                                                     'level': '3',
                                                     'meta_description': '',
                                                     'meta_keywords': '',
                                                     'meta_title': '',
                                                     'name': 'Cell Phones',
                                                     'page_layout': '',
                                                     'parent_id': 13,
                                                     'path': '1/3/13/8',
                                                     'path_in_store': '8,13',
                                                     'position': '8',
                                                     'thumbnail': None,
                                                     'updated_at': '2008-08-07 23:51:26',
                                                     'url_key': 'cell-phones',
                                                     'url_path': 'electronics/cell-phones.html'},
        ('catalog_category.info', (8, u'3', )): {'all_children': '8',
                                                     'available_sort_by': None,
                                                     'category_id': '8',
                                                     'children': '',
                                                     'created_at': '2007-08-22 18:10:30',
                                                     'custom_apply_to_products': '1',
                                                     'custom_design': '',
                                                     'custom_design_from': None,
                                                     'custom_design_to': None,
                                                     'custom_layout_update': '',
                                                     'custom_use_parent_settings': '1',
                                                     'default_sort_by': None,
                                                     'description': '',
                                                     'display_mode': 'PRODUCTS_AND_PAGE',
                                                     'filter_price_range': None,
                                                     'image': None,
                                                     'include_in_menu': '1',
                                                     'increment_id': None,
                                                     'is_active': '1',
                                                     'is_anchor': '1',
                                                     'landing_page': '4',
                                                     'level': '3',
                                                     'meta_description': '',
                                                     'meta_keywords': '',
                                                     'meta_title': '',
                                                     'name': 'Cell Phones',
                                                     'page_layout': '',
                                                     'parent_id': 13,
                                                     'path': '1/3/13/8',
                                                     'path_in_store': '8,13',
                                                     'position': '8',
                                                     'thumbnail': None,
                                                     'updated_at': '2008-08-07 23:51:26',
                                                     'url_key': 'cell-phones',
                                                     'url_path': 'electronics/cell-phones.html'},
        ('catalog_category.info', (10, )): {'all_children': '10,22,23',
                                                      'available_sort_by': None,
                                                      'category_id': '10',
                                                      'children': '22,23',
                                                      'created_at': '2007-08-23 11:45:22',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': 'furniture.jpg',
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '2',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Furniture',
                                                      'page_layout': '',
                                                      'parent_id': 3,
                                                      'path': '1/3/10',
                                                      'path_in_store': '10',
                                                      'position': '10',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-08 00:01:18',
                                                      'url_key': 'furniture',
                                                      'url_path': 'furniture.html'},
        ('catalog_category.info', (10, u'2', )): {'all_children': '10,22,23',
                                                      'available_sort_by': None,
                                                      'category_id': '10',
                                                      'children': '22,23',
                                                      'created_at': '2007-08-23 11:45:22',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': 'furniture.jpg',
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '2',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Furniture',
                                                      'page_layout': '',
                                                      'parent_id': 3,
                                                      'path': '1/3/10',
                                                      'path_in_store': '10',
                                                      'position': '10',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-08 00:01:18',
                                                      'url_key': 'furniture',
                                                      'url_path': 'furniture.html'},
        ('catalog_category.info', (10, u'3', )): {'all_children': '10,22,23',
                                                      'available_sort_by': None,
                                                      'category_id': '10',
                                                      'children': '22,23',
                                                      'created_at': '2007-08-23 11:45:22',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': 'furniture.jpg',
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '2',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Furniture',
                                                      'page_layout': '',
                                                      'parent_id': 3,
                                                      'path': '1/3/10',
                                                      'path_in_store': '10',
                                                      'position': '10',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-08 00:01:18',
                                                      'url_key': 'furniture',
                                                      'url_path': 'furniture.html'},
        ('catalog_category.info', (12, )): {'all_children': '12,25,26',
                                                      'available_sort_by': None,
                                                      'category_id': '12',
                                                      'children': '25,26',
                                                      'created_at': '2007-08-24 12:34:30',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': 'camera.jpg',
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Cameras',
                                                      'page_layout': '',
                                                      'parent_id': 13,
                                                      'path': '1/3/13/12',
                                                      'path_in_store': '12,13',
                                                      'position': '12',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:54:48',
                                                      'url_key': 'cameras',
                                                      'url_path': 'electronics/cameras.html'},
        ('catalog_category.info', (12, u'2', )): {'all_children': '12,25,26',
                                                      'available_sort_by': None,
                                                      'category_id': '12',
                                                      'children': '25,26',
                                                      'created_at': '2007-08-24 12:34:30',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': 'camera.jpg',
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Cameras',
                                                      'page_layout': '',
                                                      'parent_id': 13,
                                                      'path': '1/3/13/12',
                                                      'path_in_store': '12,13',
                                                      'position': '12',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:54:48',
                                                      'url_key': 'cameras',
                                                      'url_path': 'electronics/cameras.html'},
        ('catalog_category.info', (12, u'3', )): {'all_children': '12,25,26',
                                                      'available_sort_by': None,
                                                      'category_id': '12',
                                                      'children': '25,26',
                                                      'created_at': '2007-08-24 12:34:30',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': 'camera.jpg',
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Cameras',
                                                      'page_layout': '',
                                                      'parent_id': 13,
                                                      'path': '1/3/13/12',
                                                      'path_in_store': '12,13',
                                                      'position': '12',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:54:48',
                                                      'url_key': 'cameras',
                                                      'url_path': 'electronics/cameras.html'},
        ('catalog_category.info', (13, )): {'all_children': '13,12,25,26,15,27,28,29,30,31,32,33,34,8',
                                                      'available_sort_by': None,
                                                      'category_id': '13',
                                                      'children': '8,12,15',
                                                      'created_at': '2007-08-24 13:31:01',
                                                      'custom_apply_to_products': None,
                                                      'custom_design': None,
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': None,
                                                      'custom_use_parent_settings': None,
                                                      'default_sort_by': None,
                                                      'description': None,
                                                      'display_mode': 'PAGE',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': '3',
                                                      'level': '2',
                                                      'meta_description': None,
                                                      'meta_keywords': None,
                                                      'meta_title': None,
                                                      'name': 'Electronics',
                                                      'page_layout': 'one_column',
                                                      'parent_id': 3,
                                                      'path': '1/3/13',
                                                      'path_in_store': '13',
                                                      'position': '13',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-08 00:02:23',
                                                      'url_key': 'electronics',
                                                      'url_path': 'electronics.html'},
        ('catalog_category.info', (13, u'2', )): {'all_children': '13,12,25,26,15,27,28,29,30,31,32,33,34,8',
                                                      'available_sort_by': None,
                                                      'category_id': '13',
                                                      'children': '8,12,15',
                                                      'created_at': '2007-08-24 13:31:01',
                                                      'custom_apply_to_products': None,
                                                      'custom_design': None,
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': None,
                                                      'custom_use_parent_settings': None,
                                                      'default_sort_by': None,
                                                      'description': None,
                                                      'display_mode': 'PAGE',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': '3',
                                                      'level': '2',
                                                      'meta_description': None,
                                                      'meta_keywords': None,
                                                      'meta_title': None,
                                                      'name': 'Electronics',
                                                      'page_layout': 'one_column',
                                                      'parent_id': 3,
                                                      'path': '1/3/13',
                                                      'path_in_store': '13',
                                                      'position': '13',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-08 00:02:23',
                                                      'url_key': 'electronics',
                                                      'url_path': 'electronics.html'},
        ('catalog_category.info', (13, u'3', )): {'all_children': '13,12,25,26,15,27,28,29,30,31,32,33,34,8',
                                                      'available_sort_by': None,
                                                      'category_id': '13',
                                                      'children': '8,12,15',
                                                      'created_at': '2007-08-24 13:31:01',
                                                      'custom_apply_to_products': None,
                                                      'custom_design': None,
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': None,
                                                      'custom_use_parent_settings': None,
                                                      'default_sort_by': None,
                                                      'description': None,
                                                      'display_mode': 'PAGE',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': '3',
                                                      'level': '2',
                                                      'meta_description': None,
                                                      'meta_keywords': None,
                                                      'meta_title': None,
                                                      'name': 'Electronics',
                                                      'page_layout': 'one_column',
                                                      'parent_id': 3,
                                                      'path': '1/3/13',
                                                      'path_in_store': '13',
                                                      'position': '13',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-08 00:02:23',
                                                      'url_key': 'electronics',
                                                      'url_path': 'electronics.html'},
        ('catalog_category.info', (15, )): {'all_children': '15,27,28,29,30,31,32,33,34',
                                                      'available_sort_by': None,
                                                      'category_id': '15',
                                                      'children': '27,28,29,30,31,32,33,34',
                                                      'created_at': '2007-08-24 13:33:17',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Computers',
                                                      'page_layout': '',
                                                      'parent_id': 13,
                                                      'path': '1/3/13/15',
                                                      'path_in_store': '15,13',
                                                      'position': '15',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 01:53:39',
                                                      'url_key': 'computers',
                                                      'url_path': 'electronics/computers.html'},
        ('catalog_category.info', (15, u'2', )): {'all_children': '15,27,28,29,30,31,32,33,34',
                                                      'available_sort_by': None,
                                                      'category_id': '15',
                                                      'children': '27,28,29,30,31,32,33,34',
                                                      'created_at': '2007-08-24 13:33:17',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Computers',
                                                      'page_layout': '',
                                                      'parent_id': 13,
                                                      'path': '1/3/13/15',
                                                      'path_in_store': '15,13',
                                                      'position': '15',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 01:53:39',
                                                      'url_key': 'computers',
                                                      'url_path': 'electronics/computers.html'},
        ('catalog_category.info', (15, u'3', )): {'all_children': '15,27,28,29,30,31,32,33,34',
                                                      'available_sort_by': None,
                                                      'category_id': '15',
                                                      'children': '27,28,29,30,31,32,33,34',
                                                      'created_at': '2007-08-24 13:33:17',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Computers',
                                                      'page_layout': '',
                                                      'parent_id': 13,
                                                      'path': '1/3/13/15',
                                                      'path_in_store': '15,13',
                                                      'position': '15',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 01:53:39',
                                                      'url_key': 'computers',
                                                      'url_path': 'electronics/computers.html'},
        ('catalog_category.info', (16, )): {'all_children': '16',
                                                      'available_sort_by': None,
                                                      'category_id': '16',
                                                      'children': '',
                                                      'created_at': '2007-08-24 15:41:52',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Mens',
                                                      'page_layout': '',
                                                      'parent_id': 5,
                                                      'path': '1/3/18/5/16',
                                                      'path_in_store': '16,5,18',
                                                      'position': '16',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:56:01',
                                                      'url_key': 'mens',
                                                      'url_path': 'apparel/shoes/mens.html'},
        ('catalog_category.info', (16, u'2', )): {'all_children': '16',
                                                      'available_sort_by': None,
                                                      'category_id': '16',
                                                      'children': '',
                                                      'created_at': '2007-08-24 15:41:52',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Mens',
                                                      'page_layout': '',
                                                      'parent_id': 5,
                                                      'path': '1/3/18/5/16',
                                                      'path_in_store': '16,5,18',
                                                      'position': '16',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:56:01',
                                                      'url_key': 'mens',
                                                      'url_path': 'apparel/shoes/mens.html'},
        ('catalog_category.info', (16, u'3', )): {'all_children': '16',
                                                      'available_sort_by': None,
                                                      'category_id': '16',
                                                      'children': '',
                                                      'created_at': '2007-08-24 15:41:52',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Mens',
                                                      'page_layout': '',
                                                      'parent_id': 5,
                                                      'path': '1/3/18/5/16',
                                                      'path_in_store': '16,5,18',
                                                      'position': '16',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:56:01',
                                                      'url_key': 'mens',
                                                      'url_path': 'apparel/shoes/mens.html'},
        ('catalog_category.info', (17, )): {'all_children': '17',
                                                      'available_sort_by': None,
                                                      'category_id': '17',
                                                      'children': '',
                                                      'created_at': '2007-08-24 15:43:07',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Womens',
                                                      'page_layout': '',
                                                      'parent_id': 5,
                                                      'path': '1/3/18/5/17',
                                                      'path_in_store': '17,5,18',
                                                      'position': '17',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:56:28',
                                                      'url_key': 'womens',
                                                      'url_path': 'apparel/shoes/womens.html'},
        ('catalog_category.info', (17, u'2', )): {'all_children': '17',
                                                      'available_sort_by': None,
                                                      'category_id': '17',
                                                      'children': '',
                                                      'created_at': '2007-08-24 15:43:07',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Womens',
                                                      'page_layout': '',
                                                      'parent_id': 5,
                                                      'path': '1/3/18/5/17',
                                                      'path_in_store': '17,5,18',
                                                      'position': '17',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:56:28',
                                                      'url_key': 'womens',
                                                      'url_path': 'apparel/shoes/womens.html'},
        ('catalog_category.info', (17, u'3', )): {'all_children': '17',
                                                      'available_sort_by': None,
                                                      'category_id': '17',
                                                      'children': '',
                                                      'created_at': '2007-08-24 15:43:07',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Womens',
                                                      'page_layout': '',
                                                      'parent_id': 5,
                                                      'path': '1/3/18/5/17',
                                                      'path_in_store': '17,5,18',
                                                      'position': '17',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:56:28',
                                                      'url_key': 'womens',
                                                      'url_path': 'apparel/shoes/womens.html'},
        ('catalog_category.info', (18, )): {'all_children': '18,19,4,5,16,17',
                                                      'available_sort_by': None,
                                                      'category_id': '18',
                                                      'children': '19,4,5',
                                                      'created_at': '2007-08-24 15:44:31',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': 'apparel.jpg',
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '2',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Apparel',
                                                      'page_layout': '',
                                                      'parent_id': 3,
                                                      'path': '1/3/18',
                                                      'path_in_store': '18',
                                                      'position': '18',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:54:16',
                                                      'url_key': 'apparel',
                                                      'url_path': 'apparel.html'},
        ('catalog_category.info', (18, u'2', )): {'all_children': '18,19,4,5,16,17',
                                                      'available_sort_by': None,
                                                      'category_id': '18',
                                                      'children': '19,4,5',
                                                      'created_at': '2007-08-24 15:44:31',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': 'apparel.jpg',
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '2',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Apparel',
                                                      'page_layout': '',
                                                      'parent_id': 3,
                                                      'path': '1/3/18',
                                                      'path_in_store': '18',
                                                      'position': '18',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:54:16',
                                                      'url_key': 'apparel',
                                                      'url_path': 'apparel.html'},
        ('catalog_category.info', (18, u'3', )): {'all_children': '18,19,4,5,16,17',
                                                      'available_sort_by': None,
                                                      'category_id': '18',
                                                      'children': '19,4,5',
                                                      'created_at': '2007-08-24 15:44:31',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': 'apparel.jpg',
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '2',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Apparel',
                                                      'page_layout': '',
                                                      'parent_id': 3,
                                                      'path': '1/3/18',
                                                      'path_in_store': '18',
                                                      'position': '18',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:54:16',
                                                      'url_key': 'apparel',
                                                      'url_path': 'apparel.html'},
        ('catalog_category.info', (19, )): {'all_children': '19',
                                                      'available_sort_by': None,
                                                      'category_id': '19',
                                                      'children': '',
                                                      'created_at': '2007-08-24 20:05:28',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Hoodies',
                                                      'page_layout': '',
                                                      'parent_id': 18,
                                                      'path': '1/3/18/19',
                                                      'path_in_store': '19,18',
                                                      'position': '19',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:57:03',
                                                      'url_key': 'hoodies',
                                                      'url_path': 'apparel/hoodies.html'},
        ('catalog_category.info', (19, u'2', )): {'all_children': '19',
                                                      'available_sort_by': None,
                                                      'category_id': '19',
                                                      'children': '',
                                                      'created_at': '2007-08-24 20:05:28',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Hoodies',
                                                      'page_layout': '',
                                                      'parent_id': 18,
                                                      'path': '1/3/18/19',
                                                      'path_in_store': '19,18',
                                                      'position': '19',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:57:03',
                                                      'url_key': 'hoodies',
                                                      'url_path': 'apparel/hoodies.html'},
        ('catalog_category.info', (19, u'3', )): {'all_children': '19',
                                                      'available_sort_by': None,
                                                      'category_id': '19',
                                                      'children': '',
                                                      'created_at': '2007-08-24 20:05:28',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Hoodies',
                                                      'page_layout': '',
                                                      'parent_id': 18,
                                                      'path': '1/3/18/19',
                                                      'path_in_store': '19,18',
                                                      'position': '19',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:57:03',
                                                      'url_key': 'hoodies',
                                                      'url_path': 'apparel/hoodies.html'},
        ('catalog_category.info', (20, )): {'all_children': '20',
                                                      'available_sort_by': None,
                                                      'category_id': '20',
                                                      'children': '',
                                                      'created_at': '2007-08-25 13:14:09',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '0',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '2',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Household Items',
                                                      'page_layout': '',
                                                      'parent_id': 3,
                                                      'path': '1/3/20',
                                                      'path_in_store': '20',
                                                      'position': '20',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:58:57',
                                                      'url_key': 'household-items',
                                                      'url_path': 'household-items.html'},
        ('catalog_category.info', (20, u'2', )): {'all_children': '20',
                                                      'available_sort_by': None,
                                                      'category_id': '20',
                                                      'children': '',
                                                      'created_at': '2007-08-25 13:14:09',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '0',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '2',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Household Items',
                                                      'page_layout': '',
                                                      'parent_id': 3,
                                                      'path': '1/3/20',
                                                      'path_in_store': '20',
                                                      'position': '20',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:58:57',
                                                      'url_key': 'household-items',
                                                      'url_path': 'household-items.html'},
        ('catalog_category.info', (20, u'3', )): {'all_children': '20',
                                                      'available_sort_by': None,
                                                      'category_id': '20',
                                                      'children': '',
                                                      'created_at': '2007-08-25 13:14:09',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '0',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '2',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Household Items',
                                                      'page_layout': '',
                                                      'parent_id': 3,
                                                      'path': '1/3/20',
                                                      'path_in_store': '20',
                                                      'position': '20',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:58:57',
                                                      'url_key': 'household-items',
                                                      'url_path': 'household-items.html'},
        ('catalog_category.info', (22, )): {'all_children': '22',
                                                      'available_sort_by': None,
                                                      'category_id': '22',
                                                      'children': '',
                                                      'created_at': '2007-08-26 14:49:39',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS_AND_PAGE',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Living Room',
                                                      'page_layout': '',
                                                      'parent_id': 10,
                                                      'path': '1/3/10/22',
                                                      'path_in_store': '22,10',
                                                      'position': '22',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-08 00:01:45',
                                                      'url_key': 'living-room',
                                                      'url_path': 'furniture/living-room.html'},
        ('catalog_category.info', (22, u'2', )): {'all_children': '22',
                                                      'available_sort_by': None,
                                                      'category_id': '22',
                                                      'children': '',
                                                      'created_at': '2007-08-26 14:49:39',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS_AND_PAGE',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Living Room',
                                                      'page_layout': '',
                                                      'parent_id': 10,
                                                      'path': '1/3/10/22',
                                                      'path_in_store': '22,10',
                                                      'position': '22',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-08 00:01:45',
                                                      'url_key': 'living-room',
                                                      'url_path': 'furniture/living-room.html'},
        ('catalog_category.info', (22, u'3', )): {'all_children': '22',
                                                      'available_sort_by': None,
                                                      'category_id': '22',
                                                      'children': '',
                                                      'created_at': '2007-08-26 14:49:39',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS_AND_PAGE',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Living Room',
                                                      'page_layout': '',
                                                      'parent_id': 10,
                                                      'path': '1/3/10/22',
                                                      'path_in_store': '22,10',
                                                      'position': '22',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-08 00:01:45',
                                                      'url_key': 'living-room',
                                                      'url_path': 'furniture/living-room.html'},
        ('catalog_category.info', (23, )): {'all_children': '23',
                                                      'available_sort_by': None,
                                                      'category_id': '23',
                                                      'children': '',
                                                      'created_at': '2007-08-27 10:35:27',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': 'bedroom.jpg',
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Bedroom',
                                                      'page_layout': '',
                                                      'parent_id': 10,
                                                      'path': '1/3/10/23',
                                                      'path_in_store': '23,10',
                                                      'position': '23',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:49:18',
                                                      'url_key': 'bedroom',
                                                      'url_path': 'furniture/bedroom.html'},
        ('catalog_category.info', (23, u'2', )): {'all_children': '23',
                                                      'available_sort_by': None,
                                                      'category_id': '23',
                                                      'children': '',
                                                      'created_at': '2007-08-27 10:35:27',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': 'bedroom.jpg',
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Bedroom',
                                                      'page_layout': '',
                                                      'parent_id': 10,
                                                      'path': '1/3/10/23',
                                                      'path_in_store': '23,10',
                                                      'position': '23',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:49:18',
                                                      'url_key': 'bedroom',
                                                      'url_path': 'furniture/bedroom.html'},
        ('catalog_category.info', (23, u'3', )): {'all_children': '23',
                                                      'available_sort_by': None,
                                                      'category_id': '23',
                                                      'children': '',
                                                      'created_at': '2007-08-27 10:35:27',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': 'bedroom.jpg',
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Bedroom',
                                                      'page_layout': '',
                                                      'parent_id': 10,
                                                      'path': '1/3/10/23',
                                                      'path_in_store': '23,10',
                                                      'position': '23',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:49:18',
                                                      'url_key': 'bedroom',
                                                      'url_path': 'furniture/bedroom.html'},
        ('catalog_category.info', (24, )): {'all_children': '24',
                                                      'available_sort_by': None,
                                                      'category_id': '24',
                                                      'children': '',
                                                      'created_at': '2007-08-28 18:32:41',
                                                      'custom_apply_to_products': None,
                                                      'custom_design': None,
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': None,
                                                      'custom_use_parent_settings': None,
                                                      'default_sort_by': None,
                                                      'description': None,
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '0',
                                                      'is_anchor': None,
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': None,
                                                      'meta_keywords': None,
                                                      'meta_title': None,
                                                      'name': 'Pants',
                                                      'page_layout': None,
                                                      'parent_id': 18,
                                                      'path': '1/3/18/24',
                                                      'path_in_store': '24,18',
                                                      'position': '24',
                                                      'thumbnail': None,
                                                      'updated_at': '2007-08-29 23:20:36',
                                                      'url_key': 'pants',
                                                      'url_path': 'apparel/pants.html'},
        ('catalog_category.info', (24, u'2', )): {'all_children': '24',
                                                      'available_sort_by': None,
                                                      'category_id': '24',
                                                      'children': '',
                                                      'created_at': '2007-08-28 18:32:41',
                                                      'custom_apply_to_products': None,
                                                      'custom_design': None,
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': None,
                                                      'custom_use_parent_settings': None,
                                                      'default_sort_by': None,
                                                      'description': None,
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '0',
                                                      'is_anchor': None,
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': None,
                                                      'meta_keywords': None,
                                                      'meta_title': None,
                                                      'name': 'Pants',
                                                      'page_layout': None,
                                                      'parent_id': 18,
                                                      'path': '1/3/18/24',
                                                      'path_in_store': '24,18',
                                                      'position': '24',
                                                      'thumbnail': None,
                                                      'updated_at': '2007-08-29 23:20:36',
                                                      'url_key': 'pants',
                                                      'url_path': 'apparel/pants.html'},
        ('catalog_category.info', (24, u'3', )): {'all_children': '24',
                                                      'available_sort_by': None,
                                                      'category_id': '24',
                                                      'children': '',
                                                      'created_at': '2007-08-28 18:32:41',
                                                      'custom_apply_to_products': None,
                                                      'custom_design': None,
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': None,
                                                      'custom_use_parent_settings': None,
                                                      'default_sort_by': None,
                                                      'description': None,
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '0',
                                                      'is_anchor': None,
                                                      'landing_page': None,
                                                      'level': '3',
                                                      'meta_description': None,
                                                      'meta_keywords': None,
                                                      'meta_title': None,
                                                      'name': 'Pants',
                                                      'page_layout': None,
                                                      'parent_id': 18,
                                                      'path': '1/3/18/24',
                                                      'path_in_store': '24,18',
                                                      'position': '24',
                                                      'thumbnail': None,
                                                      'updated_at': '2007-08-29 23:20:36',
                                                      'url_key': 'pants',
                                                      'url_path': 'apparel/pants.html'},
        ('catalog_category.info', (25, )): {'all_children': '25',
                                                      'available_sort_by': None,
                                                      'category_id': '25',
                                                      'children': '',
                                                      'created_at': '2007-08-29 19:49:52',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': 'Random accessories for different electronic items',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': 'electric, accesories, gadgets',
                                                      'meta_title': '',
                                                      'name': 'Accessories',
                                                      'page_layout': '',
                                                      'parent_id': 12,
                                                      'path': '1/3/13/12/25',
                                                      'path_in_store': '25,12,13',
                                                      'position': '25',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:46:35',
                                                      'url_key': 'accessories',
                                                      'url_path': 'electronics/cameras/accessories.html'},
        ('catalog_category.info', (25, u'2', )): {'all_children': '25',
                                                      'available_sort_by': None,
                                                      'category_id': '25',
                                                      'children': '',
                                                      'created_at': '2007-08-29 19:49:52',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': 'Random accessories for different electronic items',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': 'electric, accesories, gadgets',
                                                      'meta_title': '',
                                                      'name': 'Accessories',
                                                      'page_layout': '',
                                                      'parent_id': 12,
                                                      'path': '1/3/13/12/25',
                                                      'path_in_store': '25,12,13',
                                                      'position': '25',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:46:35',
                                                      'url_key': 'accessories',
                                                      'url_path': 'electronics/cameras/accessories.html'},
        ('catalog_category.info', (25, u'3', )): {'all_children': '25',
                                                      'available_sort_by': None,
                                                      'category_id': '25',
                                                      'children': '',
                                                      'created_at': '2007-08-29 19:49:52',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': 'Random accessories for different electronic items',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': 'electric, accesories, gadgets',
                                                      'meta_title': '',
                                                      'name': 'Accessories',
                                                      'page_layout': '',
                                                      'parent_id': 12,
                                                      'path': '1/3/13/12/25',
                                                      'path_in_store': '25,12,13',
                                                      'position': '25',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:46:35',
                                                      'url_key': 'accessories',
                                                      'url_path': 'electronics/cameras/accessories.html'},
        ('catalog_category.info', (26, )): {'all_children': '26',
                                                      'available_sort_by': None,
                                                      'category_id': '26',
                                                      'children': '',
                                                      'created_at': '2007-08-29 20:37:22',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Digital Cameras',
                                                      'page_layout': '',
                                                      'parent_id': 12,
                                                      'path': '1/3/13/12/26',
                                                      'path_in_store': '26,12,13',
                                                      'position': '26',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:47:02',
                                                      'url_key': 'digital-cameras',
                                                      'url_path': 'electronics/cameras/digital-cameras.html'},
        ('catalog_category.info', (26, u'2', )): {'all_children': '26',
                                                      'available_sort_by': None,
                                                      'category_id': '26',
                                                      'children': '',
                                                      'created_at': '2007-08-29 20:37:22',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Digital Cameras',
                                                      'page_layout': '',
                                                      'parent_id': 12,
                                                      'path': '1/3/13/12/26',
                                                      'path_in_store': '26,12,13',
                                                      'position': '26',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:47:02',
                                                      'url_key': 'digital-cameras',
                                                      'url_path': 'electronics/cameras/digital-cameras.html'},
        ('catalog_category.info', (26, u'3', )): {'all_children': '26',
                                                      'available_sort_by': None,
                                                      'category_id': '26',
                                                      'children': '',
                                                      'created_at': '2007-08-29 20:37:22',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Digital Cameras',
                                                      'page_layout': '',
                                                      'parent_id': 12,
                                                      'path': '1/3/13/12/26',
                                                      'path_in_store': '26,12,13',
                                                      'position': '26',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:47:02',
                                                      'url_key': 'digital-cameras',
                                                      'url_path': 'electronics/cameras/digital-cameras.html'},
        ('catalog_category.info', (27, )): {'all_children': '27',
                                                      'available_sort_by': None,
                                                      'category_id': '27',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:36:22',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Build Your Own',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/27',
                                                      'path_in_store': None,
                                                      'position': '1',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:48:15',
                                                      'url_key': 'build-your-own',
                                                      'url_path': 'electronics/computers/build-your-own.html'},
        ('catalog_category.info', (27, u'2', )): {'all_children': '27',
                                                      'available_sort_by': None,
                                                      'category_id': '27',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:36:22',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Build Your Own',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/27',
                                                      'path_in_store': None,
                                                      'position': '1',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:48:15',
                                                      'url_key': 'build-your-own',
                                                      'url_path': 'electronics/computers/build-your-own.html'},
        ('catalog_category.info', (27, u'3', )): {'all_children': '27',
                                                      'available_sort_by': None,
                                                      'category_id': '27',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:36:22',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '0',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Build Your Own',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/27',
                                                      'path_in_store': None,
                                                      'position': '1',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-07 23:48:15',
                                                      'url_key': 'build-your-own',
                                                      'url_path': 'electronics/computers/build-your-own.html'},
        ('catalog_category.info', (28, )): {'all_children': '28',
                                                      'available_sort_by': None,
                                                      'category_id': '28',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:39:10',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Laptops',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/28',
                                                      'path_in_store': None,
                                                      'position': '2',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-08 13:02:59',
                                                      'url_key': 'laptops',
                                                      'url_path': 'electronics/computers/laptops.html'},
        ('catalog_category.info', (28, u'2', )): {'all_children': '28',
                                                      'available_sort_by': None,
                                                      'category_id': '28',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:39:10',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Laptops',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/28',
                                                      'path_in_store': None,
                                                      'position': '2',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-08 13:02:59',
                                                      'url_key': 'laptops',
                                                      'url_path': 'electronics/computers/laptops.html'},
        ('catalog_category.info', (28, u'3', )): {'all_children': '28',
                                                      'available_sort_by': None,
                                                      'category_id': '28',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:39:10',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Laptops',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/28',
                                                      'path_in_store': None,
                                                      'position': '2',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-08-08 13:02:59',
                                                      'url_key': 'laptops',
                                                      'url_path': 'electronics/computers/laptops.html'},
        ('catalog_category.info', (29, )): {'all_children': '29',
                                                      'available_sort_by': None,
                                                      'category_id': '29',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:39:54',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Hard Drives',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/29',
                                                      'path_in_store': None,
                                                      'position': '3',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:39:54',
                                                      'url_key': 'hard-drives',
                                                      'url_path': 'electronics/computers/hard-drives.html'},
        ('catalog_category.info', (29, u'2', )): {'all_children': '29',
                                                      'available_sort_by': None,
                                                      'category_id': '29',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:39:54',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Hard Drives',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/29',
                                                      'path_in_store': None,
                                                      'position': '3',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:39:54',
                                                      'url_key': 'hard-drives',
                                                      'url_path': 'electronics/computers/hard-drives.html'},
        ('catalog_category.info', (29, u'3', )): {'all_children': '29',
                                                      'available_sort_by': None,
                                                      'category_id': '29',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:39:54',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Hard Drives',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/29',
                                                      'path_in_store': None,
                                                      'position': '3',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:39:54',
                                                      'url_key': 'hard-drives',
                                                      'url_path': 'electronics/computers/hard-drives.html'},
        ('catalog_category.info', (30, )): {'all_children': '30',
                                                      'available_sort_by': None,
                                                      'category_id': '30',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:41:11',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Monitors',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/30',
                                                      'path_in_store': None,
                                                      'position': '4',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:41:11',
                                                      'url_key': 'monitors',
                                                      'url_path': 'electronics/computers/monitors.html'},
        ('catalog_category.info', (30, u'2', )): {'all_children': '30',
                                                      'available_sort_by': None,
                                                      'category_id': '30',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:41:11',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Monitors',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/30',
                                                      'path_in_store': None,
                                                      'position': '4',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:41:11',
                                                      'url_key': 'monitors',
                                                      'url_path': 'electronics/computers/monitors.html'},
        ('catalog_category.info', (30, u'3', )): {'all_children': '30',
                                                      'available_sort_by': None,
                                                      'category_id': '30',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:41:11',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Monitors',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/30',
                                                      'path_in_store': None,
                                                      'position': '4',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:41:11',
                                                      'url_key': 'monitors',
                                                      'url_path': 'electronics/computers/monitors.html'},
        ('catalog_category.info', (31, )): {'all_children': '31',
                                                      'available_sort_by': None,
                                                      'category_id': '31',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:41:56',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'RAM / Memory',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/31',
                                                      'path_in_store': None,
                                                      'position': '5',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:41:56',
                                                      'url_key': 'ram-memory',
                                                      'url_path': 'electronics/computers/ram-memory.html'},
        ('catalog_category.info', (31, u'2', )): {'all_children': '31',
                                                      'available_sort_by': None,
                                                      'category_id': '31',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:41:56',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'RAM / Memory',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/31',
                                                      'path_in_store': None,
                                                      'position': '5',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:41:56',
                                                      'url_key': 'ram-memory',
                                                      'url_path': 'electronics/computers/ram-memory.html'},
        ('catalog_category.info', (31, u'3', )): {'all_children': '31',
                                                      'available_sort_by': None,
                                                      'category_id': '31',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:41:56',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'RAM / Memory',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/31',
                                                      'path_in_store': None,
                                                      'position': '5',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:41:56',
                                                      'url_key': 'ram-memory',
                                                      'url_path': 'electronics/computers/ram-memory.html'},
        ('catalog_category.info', (32, )): {'all_children': '32',
                                                      'available_sort_by': None,
                                                      'category_id': '32',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:42:57',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Cases',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/32',
                                                      'path_in_store': None,
                                                      'position': '6',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:42:57',
                                                      'url_key': 'cases',
                                                      'url_path': 'electronics/computers/cases.html'},
        ('catalog_category.info', (32, u'2', )): {'all_children': '32',
                                                      'available_sort_by': None,
                                                      'category_id': '32',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:42:57',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Cases',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/32',
                                                      'path_in_store': None,
                                                      'position': '6',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:42:57',
                                                      'url_key': 'cases',
                                                      'url_path': 'electronics/computers/cases.html'},
        ('catalog_category.info', (32, u'3', )): {'all_children': '32',
                                                      'available_sort_by': None,
                                                      'category_id': '32',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:42:57',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Cases',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/32',
                                                      'path_in_store': None,
                                                      'position': '6',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:42:57',
                                                      'url_key': 'cases',
                                                      'url_path': 'electronics/computers/cases.html'},
        ('catalog_category.info', (33, )): {'all_children': '33',
                                                      'available_sort_by': None,
                                                      'category_id': '33',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:43:25',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Processors',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/33',
                                                      'path_in_store': None,
                                                      'position': '7',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:43:25',
                                                      'url_key': 'processors',
                                                      'url_path': 'electronics/computers/processors.html'},
        ('catalog_category.info', (33, u'2', )): {'all_children': '33',
                                                      'available_sort_by': None,
                                                      'category_id': '33',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:43:25',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Processors',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/33',
                                                      'path_in_store': None,
                                                      'position': '7',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:43:25',
                                                      'url_key': 'processors',
                                                      'url_path': 'electronics/computers/processors.html'},
        ('catalog_category.info', (33, u'3', )): {'all_children': '33',
                                                      'available_sort_by': None,
                                                      'category_id': '33',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:43:25',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Processors',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/33',
                                                      'path_in_store': None,
                                                      'position': '7',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:43:25',
                                                      'url_key': 'processors',
                                                      'url_path': 'electronics/computers/processors.html'},
        ('catalog_category.info', (34, )): {'all_children': '34',
                                                      'available_sort_by': None,
                                                      'category_id': '34',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:44:17',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Peripherals',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/34',
                                                      'path_in_store': None,
                                                      'position': '8',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:44:17',
                                                      'url_key': 'peripherals',
                                                      'url_path': 'electronics/computers/peripherals.html'},
        ('catalog_category.info', (34, u'2', )): {'all_children': '34',
                                                      'available_sort_by': None,
                                                      'category_id': '34',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:44:17',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Peripherals',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/34',
                                                      'path_in_store': None,
                                                      'position': '8',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:44:17',
                                                      'url_key': 'peripherals',
                                                      'url_path': 'electronics/computers/peripherals.html'},
        ('catalog_category.info', (34, u'3', )): {'all_children': '34',
                                                      'available_sort_by': None,
                                                      'category_id': '34',
                                                      'children': '',
                                                      'created_at': '2008-07-25 00:44:17',
                                                      'custom_apply_to_products': '1',
                                                      'custom_design': '',
                                                      'custom_design_from': None,
                                                      'custom_design_to': None,
                                                      'custom_layout_update': '',
                                                      'custom_use_parent_settings': '1',
                                                      'default_sort_by': None,
                                                      'description': '',
                                                      'display_mode': 'PRODUCTS',
                                                      'filter_price_range': None,
                                                      'image': None,
                                                      'include_in_menu': '1',
                                                      'increment_id': None,
                                                      'is_active': '1',
                                                      'is_anchor': '1',
                                                      'landing_page': None,
                                                      'level': '4',
                                                      'meta_description': '',
                                                      'meta_keywords': '',
                                                      'meta_title': '',
                                                      'name': 'Peripherals',
                                                      'page_layout': '',
                                                      'parent_id': 15,
                                                      'path': '1/3/13/15/34',
                                                      'path_in_store': None,
                                                      'position': '8',
                                                      'thumbnail': None,
                                                      'updated_at': '2008-07-25 00:44:17',
                                                      'url_key': 'peripherals',
                                                      'url_path': 'electronics/computers/peripherals.html'},
        ('catalog_category.tree', ()): {'category_id': '1',
                                                  'children': [{'category_id': '3',
                                                                'children': [{'category_id': '10',
                                                                              'children': [{'category_id': '22',
                                                                                            'children': [],
                                                                                            'is_active': '1',
                                                                                            'level': '3',
                                                                                            'name': 'Living Room',
                                                                                            'parent_id': '10',
                                                                                            'position': '22'},
                                                                                           {'category_id': '23',
                                                                                            'children': [],
                                                                                            'is_active': '1',
                                                                                            'level': '3',
                                                                                            'name': 'Bedroom',
                                                                                            'parent_id': '10',
                                                                                            'position': '23'}],
                                                                              'is_active': '1',
                                                                              'level': '2',
                                                                              'name': 'Furniture',
                                                                              'parent_id': '3',
                                                                              'position': '10'},
                                                                             {'category_id': '13',
                                                                              'children': [{'category_id': '8',
                                                                                            'children': [],
                                                                                            'is_active': '1',
                                                                                            'level': '3',
                                                                                            'name': 'Cell Phones',
                                                                                            'parent_id': '13',
                                                                                            'position': '8'},
                                                                                           {'category_id': '12',
                                                                                            'children': [{'category_id': '25',
                                                                                                          'children': [],
                                                                                                          'is_active': '1',
                                                                                                          'level': '4',
                                                                                                          'name': 'Accessories',
                                                                                                          'parent_id': '12',
                                                                                                          'position': '25'},
                                                                                                         {'category_id': '26',
                                                                                                          'children': [],
                                                                                                          'is_active': '1',
                                                                                                          'level': '4',
                                                                                                          'name': 'Digital Cameras',
                                                                                                          'parent_id': '12',
                                                                                                          'position': '26'}],
                                                                                            'is_active': '1',
                                                                                            'level': '3',
                                                                                            'name': 'Cameras',
                                                                                            'parent_id': '13',
                                                                                            'position': '12'},
                                                                                           {'category_id': '15',
                                                                                            'children': [{'category_id': '27',
                                                                                                          'children': [],
                                                                                                          'is_active': '1',
                                                                                                          'level': '4',
                                                                                                          'name': 'Build Your Own',
                                                                                                          'parent_id': '15',
                                                                                                          'position': '1'},
                                                                                                         {'category_id': '28',
                                                                                                          'children': [],
                                                                                                          'is_active': '1',
                                                                                                          'level': '4',
                                                                                                          'name': 'Laptops',
                                                                                                          'parent_id': '15',
                                                                                                          'position': '2'},
                                                                                                         {'category_id': '29',
                                                                                                          'children': [],
                                                                                                          'is_active': '1',
                                                                                                          'level': '4',
                                                                                                          'name': 'Hard Drives',
                                                                                                          'parent_id': '13',
                                                                                                          'position': '3'},
                                                                                                         {'category_id': '30',
                                                                                                          'children': [],
                                                                                                          'is_active': '1',
                                                                                                          'level': '4',
                                                                                                          'name': 'Monitors',
                                                                                                          'parent_id': '13',
                                                                                                          'position': '4'},
                                                                                                         {'category_id': '31',
                                                                                                          'children': [],
                                                                                                          'is_active': '1',
                                                                                                          'level': '4',
                                                                                                          'name': 'RAM / Memory',
                                                                                                          'parent_id': '13',
                                                                                                          'position': '5'},
                                                                                                         {'category_id': '32',
                                                                                                          'children': [],
                                                                                                          'is_active': '1',
                                                                                                          'level': '4',
                                                                                                          'name': 'Cases',
                                                                                                          'parent_id': '13',
                                                                                                          'position': '6'},
                                                                                                         {'category_id': '33',
                                                                                                          'children': [],
                                                                                                          'is_active': '1',
                                                                                                          'level': '4',
                                                                                                          'name': 'Processors',
                                                                                                          'parent_id': '13',
                                                                                                          'position': '7'},
                                                                                                         {'category_id': '34',
                                                                                                          'children': [],
                                                                                                          'is_active': '1',
                                                                                                          'level': '4',
                                                                                                          'name': 'Peripherals',
                                                                                                          'parent_id': '13',
                                                                                                          'position': '8'}],
                                                                                            'is_active': '1',
                                                                                            'level': '3',
                                                                                            'name': 'Computers',
                                                                                            'parent_id': '13',
                                                                                            'position': '15'}],
                                                                              'is_active': '1',
                                                                              'level': '2',
                                                                              'name': 'Electronics',
                                                                              'parent_id': '3',
                                                                              'position': '13'},
                                                                             {'category_id': '18',
                                                                              'children': [{'category_id': '4',
                                                                                            'children': [],
                                                                                            'is_active': '1',
                                                                                            'level': '3',
                                                                                            'name': 'Shirts',
                                                                                            'parent_id': '18',
                                                                                            'position': '4'},
                                                                                           {'category_id': '5',
                                                                                            'children': [{'category_id': '16',
                                                                                                          'children': [],
                                                                                                          'is_active': '1',
                                                                                                          'level': '4',
                                                                                                          'name': 'Mens',
                                                                                                          'parent_id': '5',
                                                                                                          'position': '16'},
                                                                                                         {'category_id': '17',
                                                                                                          'children': [],
                                                                                                          'is_active': '1',
                                                                                                          'level': '4',
                                                                                                          'name': 'Womens',
                                                                                                          'parent_id': '5',
                                                                                                          'position': '17'}],
                                                                                            'is_active': '1',
                                                                                            'level': '3',
                                                                                            'name': 'Shoes',
                                                                                            'parent_id': '18',
                                                                                            'position': '5'},
                                                                                           {'category_id': '19',
                                                                                            'children': [],
                                                                                            'is_active': '1',
                                                                                            'level': '3',
                                                                                            'name': 'Hoodies',
                                                                                            'parent_id': '18',
                                                                                            'position': '19'},
                                                                                           {'category_id': '24',
                                                                                            'children': [],
                                                                                            'is_active': '0',
                                                                                            'level': '3',
                                                                                            'name': 'Pants',
                                                                                            'parent_id': '18',
                                                                                            'position': '24'}],
                                                                              'is_active': '1',
                                                                              'level': '2',
                                                                              'name': 'Apparel',
                                                                              'parent_id': '3',
                                                                              'position': '18'},
                                                                             {'category_id': '20',
                                                                              'children': [],
                                                                              'is_active': '0',
                                                                              'level': '2',
                                                                              'name': 'Household Items',
                                                                              'parent_id': '3',
                                                                              'position': '20'}],
                                                                'is_active': '1',
                                                                'level': '1',
                                                                'name': 'Root Catalog',
                                                                'parent_id': '1',
                                                                'position': '3'}],
                                                  'is_active': '1',
                                                  'level': '0',
                                                  'name': 'Root',
                                                  'parent_id': '0',
                                                  'position': '1'},
        ('ol_catalog_product.info', (16, None, None, 'id')): {'activation_information': 'Conditional $250 Equipment Discount Included: Your price paid includes an equipment discount of $250 that has been provided to you in exchange for either activating a new, non-substitute line of service or renewing an existing line of service with AT&T and your agreement that for the 181-day period following such activation or renewal you will: (1) pay your balance due to AT&T each month and otherwise maintain your account in good standing; (2) not disconnect this AT&T line of service; (3) not transfer this equipment to another AT&T line of service; (4) not change your AT&T service rate plan to a lower monthly service rate--this includes canceling or removing required PDA, BlackBerry, or smartphone features after your product has shipped; (5) not use this line of service to replace an existing account with AT&T. If these conditions are not met, you hereby authorize Magento to charge your credit card $250 as reimbursement of this equipment discount without need for further approval.',
                                                           'categories': ['8'],
                                                           'color': '24',
                                                           'cost': '20.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-23 13:03:05',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'The Nokia 2610 is an easy to use device that combines multiple messaging options including email, instant messaging, and more. You can even download MP3 ringtones, graphics, and games straight to the phone, or surf the Internet with Cingular\'s MEdia Net service. It\'s the perfect complement to Cingular service for those even remotely interested in mobile Web capabilities in an affordable handset.<br><br>\r\n\r\n<b>Design</b><br>\r\nCompact and stylish, the 2610 features a candybar design sporting a bright 128 x 128 pixel display capable of displaying over 65,000 colors. Most of the phone\'s features and on-screen menus are controlled by a center toggle on the control pad. A standard hands-free headphone jack is provided, as are volume control keys, and there\'s even a "Go-To" button that can be assigned by the user for quick access to favorite applications. Lastly, the included speakerphone allows you to talk handsfree, and because the phone sports an internal antenna, there\'s nothing to snag or break off.\r\n\r\n',
                                                           'dimension': '4.1 x 1.7 x 0.7 inches ',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class"disc">\r\n<li>Integrated camera with video recorder to capture those special moments<br></li>\r\n<li>Enriched data connections for complete mobile access via Email, MMS, and MEdia Net<br></li>\r\n<li> Personalize with downloadable MP3 and polyphonic Ring tones, Games, and Graphics<br></li>\r\n<li>Use AIM, Yahoo! and MSN Messenger to stay in touch on the go<br></li>\r\n<li>Mobile Internet browser and email</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '20',
                                                           'meta_description': 'Offering advanced media and calling features without breaking the bank, The Nokia 2610 is an easy to use',
                                                           'meta_keyword': 'Nokia 2610, cell, phone, ',
                                                           'meta_title': 'Nokia 2610',
                                                           'minimal_price': '149.9900',
                                                           'model': '2610',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Nokia 2610 Phone',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '149.9900',
                                                           'product_id': '16',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '38',
                                                           'short_description': 'The words "entry level" no longer mean "low-end," especially when it comes to the Nokia 2610. Offering advanced media and calling features without breaking the bank',
                                                           'sku': 'n2610',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:50:04',
                                                           'url_key': 'nokia-2610-phone',
                                                           'url_path': 'nokia-2610-phone.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '3.2000'},
        ('ol_catalog_product.info', (16, u'2', None, 'id')): {'activation_information': 'Conditional $250 Equipment Discount Included: Your price paid includes an equipment discount of $250 that has been provided to you in exchange for either activating a new, non-substitute line of service or renewing an existing line of service with AT&T and your agreement that for the 181-day period following such activation or renewal you will: (1) pay your balance due to AT&T each month and otherwise maintain your account in good standing; (2) not disconnect this AT&T line of service; (3) not transfer this equipment to another AT&T line of service; (4) not change your AT&T service rate plan to a lower monthly service rate--this includes canceling or removing required PDA, BlackBerry, or smartphone features after your product has shipped; (5) not use this line of service to replace an existing account with AT&T. If these conditions are not met, you hereby authorize Magento to charge your credit card $250 as reimbursement of this equipment discount without need for further approval.',
                                                           'categories': ['8'],
                                                           'color': '24',
                                                           'cost': '20.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-23 13:03:05',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'The Nokia 2610 is an easy to use device that combines multiple messaging options including email, instant messaging, and more. You can even download MP3 ringtones, graphics, and games straight to the phone, or surf the Internet with Cingular\'s MEdia Net service. It\'s the perfect complement to Cingular service for those even remotely interested in mobile Web capabilities in an affordable handset.<br><br>\r\n\r\n<b>Design</b><br>\r\nCompact and stylish, the 2610 features a candybar design sporting a bright 128 x 128 pixel display capable of displaying over 65,000 colors. Most of the phone\'s features and on-screen menus are controlled by a center toggle on the control pad. A standard hands-free headphone jack is provided, as are volume control keys, and there\'s even a "Go-To" button that can be assigned by the user for quick access to favorite applications. Lastly, the included speakerphone allows you to talk handsfree, and because the phone sports an internal antenna, there\'s nothing to snag or break off.\r\n\r\n',
                                                           'dimension': '4.1 x 1.7 x 0.7 inches ',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class"disc">\r\n<li>Integrated camera with video recorder to capture those special moments<br></li>\r\n<li>Enriched data connections for complete mobile access via Email, MMS, and MEdia Net<br></li>\r\n<li> Personalize with downloadable MP3 and polyphonic Ring tones, Games, and Graphics<br></li>\r\n<li>Use AIM, Yahoo! and MSN Messenger to stay in touch on the go<br></li>\r\n<li>Mobile Internet browser and email</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '20',
                                                           'meta_description': 'Offering advanced media and calling features without breaking the bank, The Nokia 2610 is an easy to use',
                                                           'meta_keyword': 'Nokia 2610, cell, phone, ',
                                                           'meta_title': 'Nokia 2610',
                                                           'minimal_price': '149.9900',
                                                           'model': '2610',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Nokia 2610 Phone',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '149.9900',
                                                           'product_id': '16',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '38',
                                                           'short_description': 'The words "entry level" no longer mean "low-end," especially when it comes to the Nokia 2610. Offering advanced media and calling features without breaking the bank',
                                                           'sku': 'n2610',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:50:04',
                                                           'url_key': 'nokia-2610-phone',
                                                           'url_path': 'nokia-2610-phone.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '3.2000'},
        ('ol_catalog_product.info', (16, u'3', None, 'id')): {'activation_information': 'Conditional $250 Equipment Discount Included: Your price paid includes an equipment discount of $250 that has been provided to you in exchange for either activating a new, non-substitute line of service or renewing an existing line of service with AT&T and your agreement that for the 181-day period following such activation or renewal you will: (1) pay your balance due to AT&T each month and otherwise maintain your account in good standing; (2) not disconnect this AT&T line of service; (3) not transfer this equipment to another AT&T line of service; (4) not change your AT&T service rate plan to a lower monthly service rate--this includes canceling or removing required PDA, BlackBerry, or smartphone features after your product has shipped; (5) not use this line of service to replace an existing account with AT&T. If these conditions are not met, you hereby authorize Magento to charge your credit card $250 as reimbursement of this equipment discount without need for further approval.',
                                                           'categories': ['8'],
                                                           'color': '24',
                                                           'cost': '20.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-23 13:03:05',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'The Nokia 2610 is an easy to use device that combines multiple messaging options including email, instant messaging, and more. You can even download MP3 ringtones, graphics, and games straight to the phone, or surf the Internet with Cingular\'s MEdia Net service. It\'s the perfect complement to Cingular service for those even remotely interested in mobile Web capabilities in an affordable handset.<br><br>\r\n\r\n<b>Design</b><br>\r\nCompact and stylish, the 2610 features a candybar design sporting a bright 128 x 128 pixel display capable of displaying over 65,000 colors. Most of the phone\'s features and on-screen menus are controlled by a center toggle on the control pad. A standard hands-free headphone jack is provided, as are volume control keys, and there\'s even a "Go-To" button that can be assigned by the user for quick access to favorite applications. Lastly, the included speakerphone allows you to talk handsfree, and because the phone sports an internal antenna, there\'s nothing to snag or break off.\r\n\r\n',
                                                           'dimension': '4.1 x 1.7 x 0.7 inches ',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class"disc">\r\n<li>Integrated camera with video recorder to capture those special moments<br></li>\r\n<li>Enriched data connections for complete mobile access via Email, MMS, and MEdia Net<br></li>\r\n<li> Personalize with downloadable MP3 and polyphonic Ring tones, Games, and Graphics<br></li>\r\n<li>Use AIM, Yahoo! and MSN Messenger to stay in touch on the go<br></li>\r\n<li>Mobile Internet browser and email</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '20',
                                                           'meta_description': 'Offering advanced media and calling features without breaking the bank, The Nokia 2610 is an easy to use',
                                                           'meta_keyword': 'Nokia 2610, cell, phone, ',
                                                           'meta_title': 'Nokia 2610',
                                                           'minimal_price': '149.9900',
                                                           'model': '2610',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Nokia 2610 Phone',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '149.9900',
                                                           'product_id': '16',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '38',
                                                           'short_description': 'The words "entry level" no longer mean "low-end," especially when it comes to the Nokia 2610. Offering advanced media and calling features without breaking the bank',
                                                           'sku': 'n2610',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:50:04',
                                                           'url_key': 'nokia-2610-phone',
                                                           'url_path': 'nokia-2610-phone.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '3.2000'},
        ('ol_catalog_product.info', (17, None, None, 'id')): {'activation_information': 'CONDITIONAL $250 Equipment Discount Included: Your price paid includes an Equipment Discount of $250 that has been provided to you in exchange for activating a new, non-substitute line of service with T-Mobile and your agreement that for the 181-day period following such activation you will (1) pay your balance due to T-Mobile each month and otherwise maintain your account in good standing, (2) not disconnect this T-Mobile line of service, (3) not transfer this equipment to another T-Mobile line of service, (4) not change your T-Mobile service rate plan to a lower monthly service rate--this includes canceling or removing required PDA, BlackBerry, or smartphone features after your product has shipped, (5) not use this line of service to replace an existing account with T-Mobile. If these conditions are not met, you hereby authorize Magento.com to charge your credit card $250 as reimbursement of this Equipment Discount without need for further approval.',
                                                           'categories': ['8'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-23 15:40:26',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': " Like the BlackBerry 7105t, the BlackBerry 8100 Pearl is \r\nThe BlackBerry 8100 Pearl sports a large 240 x 260 screen that supports over 65,000 colors-- plenty of real estate to view your e-mails, Web browser content, messaging sessions, and attachments. The venerable BlackBerry trackwheel has been replaced on this model with an innovative four-way trackball placed below the screen. On the rear of the handheld, you'll find a 1.3-megapixel camera and a self portrait mirror. The handheld's microSD memory card slot is located inside the device, behind the battery. There's also a standard 2.5mm headset jack that can be used with the included headset, as well as a mini-USB port for data connectivity.",
                                                           'dimension': '4.2 x 2 x 0.6 inches ',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc">\r\n<li> 1.3 mega pixel camera to capture those special moments<br></li>\r\n<li> MP3 player lets you listen to your favorite music on the go<br></li>\r\n<li>Menu and escape keys on the front of the device for easier access<br></li>\r\n<li> Bluetooth technology lets you experience hands free and wire free features<br></li>\r\n<li>Package Contents: phone,AC adapter,software CD,headset,USB cable,sim- card,get started poster,reference guide<br></li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '21',
                                                           'meta_description': 'BlackBerry 8100 Pearl sports a large 240 x 260 screen that supports over 65,000 colors-- plenty of real estate to view your e-mails, Web browser content, messaging sessions, and attachments.',
                                                           'meta_keyword': 'Blackberry, 8100, pearl, cell, phone',
                                                           'meta_title': 'BlackBerry 8100 Pearl',
                                                           'minimal_price': '349.9900',
                                                           'model': '8100',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'BlackBerry 8100 Pearl',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '349.9900',
                                                           'product_id': '17',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '38',
                                                           'short_description': "The BlackBerry 8100 Pearl is a departure from the form factor of previous BlackBerry devices. This BlackBerry handset is far more phone-like, and RIM's engineers have managed to fit a QWERTY keyboard onto the handset's slim frame.",
                                                           'sku': 'bb8100',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:50:23',
                                                           'url_key': 'blackberry-8100-pearl',
                                                           'url_path': 'blackberry-8100-pearl.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '15.2000'},
        ('ol_catalog_product.info', (17, u'2', None, 'id')): {'activation_information': 'CONDITIONAL $250 Equipment Discount Included: Your price paid includes an Equipment Discount of $250 that has been provided to you in exchange for activating a new, non-substitute line of service with T-Mobile and your agreement that for the 181-day period following such activation you will (1) pay your balance due to T-Mobile each month and otherwise maintain your account in good standing, (2) not disconnect this T-Mobile line of service, (3) not transfer this equipment to another T-Mobile line of service, (4) not change your T-Mobile service rate plan to a lower monthly service rate--this includes canceling or removing required PDA, BlackBerry, or smartphone features after your product has shipped, (5) not use this line of service to replace an existing account with T-Mobile. If these conditions are not met, you hereby authorize Magento.com to charge your credit card $250 as reimbursement of this Equipment Discount without need for further approval.',
                                                           'categories': ['8'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-23 15:40:26',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': " Like the BlackBerry 7105t, the BlackBerry 8100 Pearl is \r\nThe BlackBerry 8100 Pearl sports a large 240 x 260 screen that supports over 65,000 colors-- plenty of real estate to view your e-mails, Web browser content, messaging sessions, and attachments. The venerable BlackBerry trackwheel has been replaced on this model with an innovative four-way trackball placed below the screen. On the rear of the handheld, you'll find a 1.3-megapixel camera and a self portrait mirror. The handheld's microSD memory card slot is located inside the device, behind the battery. There's also a standard 2.5mm headset jack that can be used with the included headset, as well as a mini-USB port for data connectivity.",
                                                           'dimension': '4.2 x 2 x 0.6 inches ',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc">\r\n<li> 1.3 mega pixel camera to capture those special moments<br></li>\r\n<li> MP3 player lets you listen to your favorite music on the go<br></li>\r\n<li>Menu and escape keys on the front of the device for easier access<br></li>\r\n<li> Bluetooth technology lets you experience hands free and wire free features<br></li>\r\n<li>Package Contents: phone,AC adapter,software CD,headset,USB cable,sim- card,get started poster,reference guide<br></li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '21',
                                                           'meta_description': 'BlackBerry 8100 Pearl sports a large 240 x 260 screen that supports over 65,000 colors-- plenty of real estate to view your e-mails, Web browser content, messaging sessions, and attachments.',
                                                           'meta_keyword': 'Blackberry, 8100, pearl, cell, phone',
                                                           'meta_title': 'BlackBerry 8100 Pearl',
                                                           'minimal_price': '349.9900',
                                                           'model': '8100',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'BlackBerry 8100 Pearl',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '349.9900',
                                                           'product_id': '17',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '38',
                                                           'short_description': "The BlackBerry 8100 Pearl is a departure from the form factor of previous BlackBerry devices. This BlackBerry handset is far more phone-like, and RIM's engineers have managed to fit a QWERTY keyboard onto the handset's slim frame.",
                                                           'sku': 'bb8100',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:50:23',
                                                           'url_key': 'blackberry-8100-pearl',
                                                           'url_path': 'blackberry-8100-pearl.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '15.2000'},
        ('ol_catalog_product.info', (17, u'3', None, 'id')): {'activation_information': 'CONDITIONAL $250 Equipment Discount Included: Your price paid includes an Equipment Discount of $250 that has been provided to you in exchange for activating a new, non-substitute line of service with T-Mobile and your agreement that for the 181-day period following such activation you will (1) pay your balance due to T-Mobile each month and otherwise maintain your account in good standing, (2) not disconnect this T-Mobile line of service, (3) not transfer this equipment to another T-Mobile line of service, (4) not change your T-Mobile service rate plan to a lower monthly service rate--this includes canceling or removing required PDA, BlackBerry, or smartphone features after your product has shipped, (5) not use this line of service to replace an existing account with T-Mobile. If these conditions are not met, you hereby authorize Magento.com to charge your credit card $250 as reimbursement of this Equipment Discount without need for further approval.',
                                                           'categories': ['8'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-23 15:40:26',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': " Like the BlackBerry 7105t, the BlackBerry 8100 Pearl is \r\nThe BlackBerry 8100 Pearl sports a large 240 x 260 screen that supports over 65,000 colors-- plenty of real estate to view your e-mails, Web browser content, messaging sessions, and attachments. The venerable BlackBerry trackwheel has been replaced on this model with an innovative four-way trackball placed below the screen. On the rear of the handheld, you'll find a 1.3-megapixel camera and a self portrait mirror. The handheld's microSD memory card slot is located inside the device, behind the battery. There's also a standard 2.5mm headset jack that can be used with the included headset, as well as a mini-USB port for data connectivity.",
                                                           'dimension': '4.2 x 2 x 0.6 inches ',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc">\r\n<li> 1.3 mega pixel camera to capture those special moments<br></li>\r\n<li> MP3 player lets you listen to your favorite music on the go<br></li>\r\n<li>Menu and escape keys on the front of the device for easier access<br></li>\r\n<li> Bluetooth technology lets you experience hands free and wire free features<br></li>\r\n<li>Package Contents: phone,AC adapter,software CD,headset,USB cable,sim- card,get started poster,reference guide<br></li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '21',
                                                           'meta_description': 'BlackBerry 8100 Pearl sports a large 240 x 260 screen that supports over 65,000 colors-- plenty of real estate to view your e-mails, Web browser content, messaging sessions, and attachments.',
                                                           'meta_keyword': 'Blackberry, 8100, pearl, cell, phone',
                                                           'meta_title': 'BlackBerry 8100 Pearl',
                                                           'minimal_price': '349.9900',
                                                           'model': '8100',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'BlackBerry 8100 Pearl',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '349.9900',
                                                           'product_id': '17',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '38',
                                                           'short_description': "The BlackBerry 8100 Pearl is a departure from the form factor of previous BlackBerry devices. This BlackBerry handset is far more phone-like, and RIM's engineers have managed to fit a QWERTY keyboard onto the handset's slim frame.",
                                                           'sku': 'bb8100',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:50:23',
                                                           'url_key': 'blackberry-8100-pearl',
                                                           'url_path': 'blackberry-8100-pearl.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '15.2000'},
        ('ol_catalog_product.info', (18, None, None, 'id')): {'activation_information': 'Conditional $250 Equipment Discount Included: Your price paid includes an equipment discount of $250 that has been provided to you in exchange for either activating a new, non-substitute line of service or renewing an existing line of service with AT&T and your agreement that for the 181-day period following such activation or renewal you will: (1) pay your balance due to AT&T each month and otherwise maintain your account in good standing; (2) not disconnect this AT&T line of service; (3) not transfer this equipment to another AT&T line of service; (4) not change your AT&T service rate plan to a lower monthly service rate--this includes canceling or removing required PDA, BlackBerry, or smartphone features after your product has shipped; (5) not use this line of service to replace an existing account with AT&T. If these conditions are not met, you hereby authorize Magento.com to charge your credit card $250 as reimbursement of this equipment discount without need for further approval.',
                                                           'categories': ['8'],
                                                           'color': '24',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-23 15:47:44',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "The W810i's screen sports 176 x 220 pixel resolution with support for 262,000 colors. Quick access buttons below the screen make it easy to control the phone's Walkman music features, while a five-way center button controls most of the phone's menus and features.",
                                                           'dimension': ' 3.5 x 1.8 x 1 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': u'<ul>\r\n<ul class="disc">\r\n \r\n<li>Disc2Phone\u2122 music copying software is supplied in the W810 kit and it\u2019s easy to copy songs from your favorite CDs, and PC music folders<br></li>\r\n<li>The built-in W810 2 megapixel digital camera with autofus takes excellent photos and when you need to catch some action, W810 has video too<br></li>\r\n<li>Sharing images and other phone content is easy. Use Bluetooth\u2122, or Multimedia messaging when you want to send images and video<br></li>\r\n<li> Wherever you are, you have high speed access to the internet with EDGE technology<br></li>\r\n<li> A full-function email client in your W810 gives you access to your inbox wherever you go</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '2',
                                                           'meta_description': 'The W810i follows a long tradition of beautifully designed and crafted phones from Sony Ericsson. The same candy-bar style that graced the W800 is here, as is the horizontally-oriented camera unit on the back of the phone, allowing you to hold the phone j',
                                                           'meta_keyword': 'Sony, Ericsson ,W810i, cell, phone',
                                                           'meta_title': 'Sony Ericsson W810i',
                                                           'minimal_price': '399.9900',
                                                           'model': 'W810i',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Sony Ericsson W810i',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '399.9900',
                                                           'product_id': '18',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '38',
                                                           'short_description': 'The W810i follows a long tradition of beautifully designed and crafted phones from Sony Ericsson. The same candy-bar style that graced the W800 is here.',
                                                           'sku': 'sw810i',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:50:56',
                                                           'url_key': 'sony-ericsson-w810i',
                                                           'url_path': 'sony-ericsson-w810i.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '13.6000'},
        ('ol_catalog_product.info', (18, u'2', None, 'id')): {'activation_information': 'Conditional $250 Equipment Discount Included: Your price paid includes an equipment discount of $250 that has been provided to you in exchange for either activating a new, non-substitute line of service or renewing an existing line of service with AT&T and your agreement that for the 181-day period following such activation or renewal you will: (1) pay your balance due to AT&T each month and otherwise maintain your account in good standing; (2) not disconnect this AT&T line of service; (3) not transfer this equipment to another AT&T line of service; (4) not change your AT&T service rate plan to a lower monthly service rate--this includes canceling or removing required PDA, BlackBerry, or smartphone features after your product has shipped; (5) not use this line of service to replace an existing account with AT&T. If these conditions are not met, you hereby authorize Magento.com to charge your credit card $250 as reimbursement of this equipment discount without need for further approval.',
                                                           'categories': ['8'],
                                                           'color': '24',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-23 15:47:44',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "The W810i's screen sports 176 x 220 pixel resolution with support for 262,000 colors. Quick access buttons below the screen make it easy to control the phone's Walkman music features, while a five-way center button controls most of the phone's menus and features.",
                                                           'dimension': ' 3.5 x 1.8 x 1 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': u'<ul>\r\n<ul class="disc">\r\n \r\n<li>Disc2Phone\u2122 music copying software is supplied in the W810 kit and it\u2019s easy to copy songs from your favorite CDs, and PC music folders<br></li>\r\n<li>The built-in W810 2 megapixel digital camera with autofus takes excellent photos and when you need to catch some action, W810 has video too<br></li>\r\n<li>Sharing images and other phone content is easy. Use Bluetooth\u2122, or Multimedia messaging when you want to send images and video<br></li>\r\n<li> Wherever you are, you have high speed access to the internet with EDGE technology<br></li>\r\n<li> A full-function email client in your W810 gives you access to your inbox wherever you go</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '2',
                                                           'meta_description': 'The W810i follows a long tradition of beautifully designed and crafted phones from Sony Ericsson. The same candy-bar style that graced the W800 is here, as is the horizontally-oriented camera unit on the back of the phone, allowing you to hold the phone j',
                                                           'meta_keyword': 'Sony, Ericsson ,W810i, cell, phone',
                                                           'meta_title': 'Sony Ericsson W810i',
                                                           'minimal_price': '399.9900',
                                                           'model': 'W810i',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Sony Ericsson W810i',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '399.9900',
                                                           'product_id': '18',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '38',
                                                           'short_description': 'The W810i follows a long tradition of beautifully designed and crafted phones from Sony Ericsson. The same candy-bar style that graced the W800 is here.',
                                                           'sku': 'sw810i',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:50:56',
                                                           'url_key': 'sony-ericsson-w810i',
                                                           'url_path': 'sony-ericsson-w810i.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '13.6000'},
        ('ol_catalog_product.info', (18, u'3', None, 'id')): {'activation_information': 'Conditional $250 Equipment Discount Included: Your price paid includes an equipment discount of $250 that has been provided to you in exchange for either activating a new, non-substitute line of service or renewing an existing line of service with AT&T and your agreement that for the 181-day period following such activation or renewal you will: (1) pay your balance due to AT&T each month and otherwise maintain your account in good standing; (2) not disconnect this AT&T line of service; (3) not transfer this equipment to another AT&T line of service; (4) not change your AT&T service rate plan to a lower monthly service rate--this includes canceling or removing required PDA, BlackBerry, or smartphone features after your product has shipped; (5) not use this line of service to replace an existing account with AT&T. If these conditions are not met, you hereby authorize Magento.com to charge your credit card $250 as reimbursement of this equipment discount without need for further approval.',
                                                           'categories': ['8'],
                                                           'color': '24',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-23 15:47:44',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "The W810i's screen sports 176 x 220 pixel resolution with support for 262,000 colors. Quick access buttons below the screen make it easy to control the phone's Walkman music features, while a five-way center button controls most of the phone's menus and features.",
                                                           'dimension': ' 3.5 x 1.8 x 1 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': u'<ul>\r\n<ul class="disc">\r\n \r\n<li>Disc2Phone\u2122 music copying software is supplied in the W810 kit and it\u2019s easy to copy songs from your favorite CDs, and PC music folders<br></li>\r\n<li>The built-in W810 2 megapixel digital camera with autofus takes excellent photos and when you need to catch some action, W810 has video too<br></li>\r\n<li>Sharing images and other phone content is easy. Use Bluetooth\u2122, or Multimedia messaging when you want to send images and video<br></li>\r\n<li> Wherever you are, you have high speed access to the internet with EDGE technology<br></li>\r\n<li> A full-function email client in your W810 gives you access to your inbox wherever you go</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '2',
                                                           'meta_description': 'The W810i follows a long tradition of beautifully designed and crafted phones from Sony Ericsson. The same candy-bar style that graced the W800 is here, as is the horizontally-oriented camera unit on the back of the phone, allowing you to hold the phone j',
                                                           'meta_keyword': 'Sony, Ericsson ,W810i, cell, phone',
                                                           'meta_title': 'Sony Ericsson W810i',
                                                           'minimal_price': '399.9900',
                                                           'model': 'W810i',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Sony Ericsson W810i',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '399.9900',
                                                           'product_id': '18',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '38',
                                                           'short_description': 'The W810i follows a long tradition of beautifully designed and crafted phones from Sony Ericsson. The same candy-bar style that graced the W800 is here.',
                                                           'sku': 'sw810i',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:50:56',
                                                           'url_key': 'sony-ericsson-w810i',
                                                           'url_path': 'sony-ericsson-w810i.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '13.6000'},
        ('ol_catalog_product.info', (19, None, None, 'id')): {'activation_information': 'Conditional $250 Equipment Discount Included: Your price paid includes an equipment discount of $250 that has been provided to you in exchange for either activating a new, non-substitute line of service or renewing an existing line of service with AT&T and your agreement that for the 181-day period following such activation or renewal you will: (1) pay your balance due to AT&T each month and otherwise maintain your account in good standing; (2) not disconnect this AT&T line of service; (3) not transfer this equipment to another AT&T line of service; (4) not change your AT&T service rate plan to a lower monthly service rate--this includes canceling or removing required PDA, BlackBerry, or smartphone features after your product has shipped; (5) not use this line of service to replace an existing account with AT&T. If these conditions are not met, you hereby authorize Magento.com to charge your credit card $250 as reimbursement of this equipment discount without need for further approval.',
                                                           'categories': ['8'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-23 15:55:29',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': " The design of the 8525 is clean and uncluttered, with just a few buttons for mail, Internet Explorer, and contextual menus. Meanwhile, call answer and end buttons surround a five-way toggle that allows you to navigate and control the Windows Mobile interface. As mentioned, a full QWERTY keyboard cleverly slides out from underneath the screen. This allows you to hold the device horizontally, and the screen is automatically placed in landscape mode when you're using the keyboard. A side scroll wheel is conveniently tucked away on the side, making navigation when accessing the music player and other various applications a cinch when needed. A mini-SD memory expansion card slot is provided, as is an infrared port and support for a stereo Bluetooth headset. A mini-USB port is also included for wired data transfers and charging.",
                                                           'dimension': '4.4 x 2.4 x 0.9 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc">\r\n<li>tri-band UMTS/HSDPA; quad-band GSM/GPRS/EDGE for global use<br></li>\r\n<li>Windows Mobile 5.0 with Messaging & Security Feature Pack<br></li>\r\n<li>sliding QWERTY keyboard with improved keypad design and improved backlight for easier use in low light conditions<br></li>\r\n<li>128MB ROM / 64MB RAM; ~51MB user available memory<br></li>\r\n<li>2.0 mega-pixel camera with video capabilities</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '101',
                                                           'meta_description': 'nder the hood, the 8525 features 128MB of embedded memory and 64MB RAM, running on a 400 MHz Samsung processor. Up front, the 240 x 320 LCD touch-screen supports over 65,000 colors, while the rear of the device houses a 2.0 megapixel camera. The design of',
                                                           'meta_keyword': 'At&t, 8525, cell, phone',
                                                           'meta_title': 'AT&T 8525 PDA Phone',
                                                           'minimal_price': '199.9900',
                                                           'model': '8525 PDA',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'AT&T 8525 PDA',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '199.9900',
                                                           'product_id': '19',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '38',
                                                           'short_description': 'Under the hood, the 8525 features 128MB of embedded memory and 64MB RAM, running on a 400 MHz Samsung processor. Up front, the 240 x 320 LCD touch-screen supports over 65,000 colors, while the rear of the device houses a 2.0 megapixel camera.',
                                                           'sku': '8525PDA',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:51:11',
                                                           'url_key': 'atandt-8525-pda',
                                                           'url_path': 'atandt-8525-pda.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '30.0000'},
        ('ol_catalog_product.info', (19, u'2', None, 'id')): {'activation_information': 'Conditional $250 Equipment Discount Included: Your price paid includes an equipment discount of $250 that has been provided to you in exchange for either activating a new, non-substitute line of service or renewing an existing line of service with AT&T and your agreement that for the 181-day period following such activation or renewal you will: (1) pay your balance due to AT&T each month and otherwise maintain your account in good standing; (2) not disconnect this AT&T line of service; (3) not transfer this equipment to another AT&T line of service; (4) not change your AT&T service rate plan to a lower monthly service rate--this includes canceling or removing required PDA, BlackBerry, or smartphone features after your product has shipped; (5) not use this line of service to replace an existing account with AT&T. If these conditions are not met, you hereby authorize Magento.com to charge your credit card $250 as reimbursement of this equipment discount without need for further approval.',
                                                           'categories': ['8'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-23 15:55:29',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': " The design of the 8525 is clean and uncluttered, with just a few buttons for mail, Internet Explorer, and contextual menus. Meanwhile, call answer and end buttons surround a five-way toggle that allows you to navigate and control the Windows Mobile interface. As mentioned, a full QWERTY keyboard cleverly slides out from underneath the screen. This allows you to hold the device horizontally, and the screen is automatically placed in landscape mode when you're using the keyboard. A side scroll wheel is conveniently tucked away on the side, making navigation when accessing the music player and other various applications a cinch when needed. A mini-SD memory expansion card slot is provided, as is an infrared port and support for a stereo Bluetooth headset. A mini-USB port is also included for wired data transfers and charging.",
                                                           'dimension': '4.4 x 2.4 x 0.9 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc">\r\n<li>tri-band UMTS/HSDPA; quad-band GSM/GPRS/EDGE for global use<br></li>\r\n<li>Windows Mobile 5.0 with Messaging & Security Feature Pack<br></li>\r\n<li>sliding QWERTY keyboard with improved keypad design and improved backlight for easier use in low light conditions<br></li>\r\n<li>128MB ROM / 64MB RAM; ~51MB user available memory<br></li>\r\n<li>2.0 mega-pixel camera with video capabilities</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '101',
                                                           'meta_description': 'nder the hood, the 8525 features 128MB of embedded memory and 64MB RAM, running on a 400 MHz Samsung processor. Up front, the 240 x 320 LCD touch-screen supports over 65,000 colors, while the rear of the device houses a 2.0 megapixel camera. The design of',
                                                           'meta_keyword': 'At&t, 8525, cell, phone',
                                                           'meta_title': 'AT&T 8525 PDA Phone',
                                                           'minimal_price': '199.9900',
                                                           'model': '8525 PDA',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'AT&T 8525 PDA',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '199.9900',
                                                           'product_id': '19',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '38',
                                                           'short_description': 'Under the hood, the 8525 features 128MB of embedded memory and 64MB RAM, running on a 400 MHz Samsung processor. Up front, the 240 x 320 LCD touch-screen supports over 65,000 colors, while the rear of the device houses a 2.0 megapixel camera.',
                                                           'sku': '8525PDA',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:51:11',
                                                           'url_key': 'atandt-8525-pda',
                                                           'url_path': 'atandt-8525-pda.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '30.0000'},
        ('ol_catalog_product.info', (19, u'3', None, 'id')): {'activation_information': 'Conditional $250 Equipment Discount Included: Your price paid includes an equipment discount of $250 that has been provided to you in exchange for either activating a new, non-substitute line of service or renewing an existing line of service with AT&T and your agreement that for the 181-day period following such activation or renewal you will: (1) pay your balance due to AT&T each month and otherwise maintain your account in good standing; (2) not disconnect this AT&T line of service; (3) not transfer this equipment to another AT&T line of service; (4) not change your AT&T service rate plan to a lower monthly service rate--this includes canceling or removing required PDA, BlackBerry, or smartphone features after your product has shipped; (5) not use this line of service to replace an existing account with AT&T. If these conditions are not met, you hereby authorize Magento.com to charge your credit card $250 as reimbursement of this equipment discount without need for further approval.',
                                                           'categories': ['8'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-23 15:55:29',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': " The design of the 8525 is clean and uncluttered, with just a few buttons for mail, Internet Explorer, and contextual menus. Meanwhile, call answer and end buttons surround a five-way toggle that allows you to navigate and control the Windows Mobile interface. As mentioned, a full QWERTY keyboard cleverly slides out from underneath the screen. This allows you to hold the device horizontally, and the screen is automatically placed in landscape mode when you're using the keyboard. A side scroll wheel is conveniently tucked away on the side, making navigation when accessing the music player and other various applications a cinch when needed. A mini-SD memory expansion card slot is provided, as is an infrared port and support for a stereo Bluetooth headset. A mini-USB port is also included for wired data transfers and charging.",
                                                           'dimension': '4.4 x 2.4 x 0.9 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc">\r\n<li>tri-band UMTS/HSDPA; quad-band GSM/GPRS/EDGE for global use<br></li>\r\n<li>Windows Mobile 5.0 with Messaging & Security Feature Pack<br></li>\r\n<li>sliding QWERTY keyboard with improved keypad design and improved backlight for easier use in low light conditions<br></li>\r\n<li>128MB ROM / 64MB RAM; ~51MB user available memory<br></li>\r\n<li>2.0 mega-pixel camera with video capabilities</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '101',
                                                           'meta_description': 'nder the hood, the 8525 features 128MB of embedded memory and 64MB RAM, running on a 400 MHz Samsung processor. Up front, the 240 x 320 LCD touch-screen supports over 65,000 colors, while the rear of the device houses a 2.0 megapixel camera. The design of',
                                                           'meta_keyword': 'At&t, 8525, cell, phone',
                                                           'meta_title': 'AT&T 8525 PDA Phone',
                                                           'minimal_price': '199.9900',
                                                           'model': '8525 PDA',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'AT&T 8525 PDA',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '199.9900',
                                                           'product_id': '19',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '38',
                                                           'short_description': 'Under the hood, the 8525 features 128MB of embedded memory and 64MB RAM, running on a 400 MHz Samsung processor. Up front, the 240 x 320 LCD touch-screen supports over 65,000 colors, while the rear of the device houses a 2.0 megapixel camera.',
                                                           'sku': '8525PDA',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:51:11',
                                                           'url_key': 'atandt-8525-pda',
                                                           'url_path': 'atandt-8525-pda.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '30.0000'},
        ('ol_catalog_product.info', (20, None, None, 'id')): {'activation_information': 'CONDITIONAL $250 Equipment Discount Included: Your price paid includes an equipment discount of $250 that has been provided to you in exchange for activating a new, non-substitute line of service with Sprint and your agreement that for the 181-day period following such activation you will (1) pay your balance due to Sprint each month and otherwise maintain your account in good standing, (2) not disconnect this Sprint line of service, (3) not transfer this equipment to another Sprint line of service, (4) not change your Sprint service rate plan to a lower monthly service rate--this includes canceling or removing required PDA, BlackBerry, or smartphone features after your product has shipped, and (5) not use this line of service to replace an existing account with Sprint. If these conditions are not met, you hereby authorize Magento.com to charge your credit card $250 as reimbursement of this equipment discount without need for further approval.',
                                                           'categories': ['8'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-23 18:06:42',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'New services supported by both the MM-A900m include the newly announced Sprint Music StoreSM, which allows users to immediately buy and download complete songs directly to their phone; 30 channels of live and on demand video and audio from Sprint TVSM and On Demand, a personalized resource guide to news, traffic, weather, sports and entertainment. The MM-A900m offers great-looking design with the ability to download a rich selection of content directly to the phone. Features like external music-navigation keys make these phones both functional and attractive. These handsets are sure to be at the top of many wish lists.',
                                                           'dimension': '3.9 x 2 x 0.6 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': u'<ul>\r\n<ul class="disc">\r\n<li>Bluetooth Wireless Technology: Built-in radio technology allows fast, secure transmission between your phone and accessories without cables or wires. Bluetooth wireless accessories are sold separately.<br></li>\r\n<li>Mass Storage Area: Store pictures, videos, voice memos and music within the internal memory of the phone.<br></li>\r\n<li>Streaming Music Enabled: Stream music to your phone with Music Choice\xae. Select from Pop, Rock, Hip Hop, and R&B plus exclusive video clips, performances, and artist interviews.<br></li>\r\n</ul>\r\n   ',
                                                           'is_recurring': None,
                                                           'manufacturer': '3',
                                                           'meta_description': 'New services supported by both the MM-A900m include the newly announced Sprint Music StoreSM, which allows users to immediately buy and download complete songs directly to their phone',
                                                           'meta_keyword': 'Samsung, MM-A900M, cell, phone',
                                                           'meta_title': 'Samsung MM-A900M Ace Phone',
                                                           'minimal_price': '150.0000',
                                                           'model': 'MM-A900M',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Samsung MM-A900M Ace',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '150.0000',
                                                           'product_id': '20',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '38',
                                                           'short_description': 'The MM-A900m offers great-looking design with the ability to download a rich selection of content directly to the phone. ',
                                                           'sku': 'MM-A900M',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:51:27',
                                                           'url_key': 'samsung-mm-a900m-ace',
                                                           'url_path': 'samsung-mm-a900m-ace.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (20, u'2', None, 'id')): {'activation_information': 'CONDITIONAL $250 Equipment Discount Included: Your price paid includes an equipment discount of $250 that has been provided to you in exchange for activating a new, non-substitute line of service with Sprint and your agreement that for the 181-day period following such activation you will (1) pay your balance due to Sprint each month and otherwise maintain your account in good standing, (2) not disconnect this Sprint line of service, (3) not transfer this equipment to another Sprint line of service, (4) not change your Sprint service rate plan to a lower monthly service rate--this includes canceling or removing required PDA, BlackBerry, or smartphone features after your product has shipped, and (5) not use this line of service to replace an existing account with Sprint. If these conditions are not met, you hereby authorize Magento.com to charge your credit card $250 as reimbursement of this equipment discount without need for further approval.',
                                                           'categories': ['8'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-23 18:06:42',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'New services supported by both the MM-A900m include the newly announced Sprint Music StoreSM, which allows users to immediately buy and download complete songs directly to their phone; 30 channels of live and on demand video and audio from Sprint TVSM and On Demand, a personalized resource guide to news, traffic, weather, sports and entertainment. The MM-A900m offers great-looking design with the ability to download a rich selection of content directly to the phone. Features like external music-navigation keys make these phones both functional and attractive. These handsets are sure to be at the top of many wish lists.',
                                                           'dimension': '3.9 x 2 x 0.6 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': u'<ul>\r\n<ul class="disc">\r\n<li>Bluetooth Wireless Technology: Built-in radio technology allows fast, secure transmission between your phone and accessories without cables or wires. Bluetooth wireless accessories are sold separately.<br></li>\r\n<li>Mass Storage Area: Store pictures, videos, voice memos and music within the internal memory of the phone.<br></li>\r\n<li>Streaming Music Enabled: Stream music to your phone with Music Choice\xae. Select from Pop, Rock, Hip Hop, and R&B plus exclusive video clips, performances, and artist interviews.<br></li>\r\n</ul>\r\n   ',
                                                           'is_recurring': None,
                                                           'manufacturer': '3',
                                                           'meta_description': 'New services supported by both the MM-A900m include the newly announced Sprint Music StoreSM, which allows users to immediately buy and download complete songs directly to their phone',
                                                           'meta_keyword': 'Samsung, MM-A900M, cell, phone',
                                                           'meta_title': 'Samsung MM-A900M Ace Phone',
                                                           'minimal_price': '150.0000',
                                                           'model': 'MM-A900M',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Samsung MM-A900M Ace',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '150.0000',
                                                           'product_id': '20',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '38',
                                                           'short_description': 'The MM-A900m offers great-looking design with the ability to download a rich selection of content directly to the phone. ',
                                                           'sku': 'MM-A900M',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:51:27',
                                                           'url_key': 'samsung-mm-a900m-ace',
                                                           'url_path': 'samsung-mm-a900m-ace.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (20, u'3', None, 'id')): {'activation_information': 'CONDITIONAL $250 Equipment Discount Included: Your price paid includes an equipment discount of $250 that has been provided to you in exchange for activating a new, non-substitute line of service with Sprint and your agreement that for the 181-day period following such activation you will (1) pay your balance due to Sprint each month and otherwise maintain your account in good standing, (2) not disconnect this Sprint line of service, (3) not transfer this equipment to another Sprint line of service, (4) not change your Sprint service rate plan to a lower monthly service rate--this includes canceling or removing required PDA, BlackBerry, or smartphone features after your product has shipped, and (5) not use this line of service to replace an existing account with Sprint. If these conditions are not met, you hereby authorize Magento.com to charge your credit card $250 as reimbursement of this equipment discount without need for further approval.',
                                                           'categories': ['8'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-23 18:06:42',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'New services supported by both the MM-A900m include the newly announced Sprint Music StoreSM, which allows users to immediately buy and download complete songs directly to their phone; 30 channels of live and on demand video and audio from Sprint TVSM and On Demand, a personalized resource guide to news, traffic, weather, sports and entertainment. The MM-A900m offers great-looking design with the ability to download a rich selection of content directly to the phone. Features like external music-navigation keys make these phones both functional and attractive. These handsets are sure to be at the top of many wish lists.',
                                                           'dimension': '3.9 x 2 x 0.6 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': u'<ul>\r\n<ul class="disc">\r\n<li>Bluetooth Wireless Technology: Built-in radio technology allows fast, secure transmission between your phone and accessories without cables or wires. Bluetooth wireless accessories are sold separately.<br></li>\r\n<li>Mass Storage Area: Store pictures, videos, voice memos and music within the internal memory of the phone.<br></li>\r\n<li>Streaming Music Enabled: Stream music to your phone with Music Choice\xae. Select from Pop, Rock, Hip Hop, and R&B plus exclusive video clips, performances, and artist interviews.<br></li>\r\n</ul>\r\n   ',
                                                           'is_recurring': None,
                                                           'manufacturer': '3',
                                                           'meta_description': 'New services supported by both the MM-A900m include the newly announced Sprint Music StoreSM, which allows users to immediately buy and download complete songs directly to their phone',
                                                           'meta_keyword': 'Samsung, MM-A900M, cell, phone',
                                                           'meta_title': 'Samsung MM-A900M Ace Phone',
                                                           'minimal_price': '150.0000',
                                                           'model': 'MM-A900M',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Samsung MM-A900M Ace',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '150.0000',
                                                           'product_id': '20',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '38',
                                                           'short_description': 'The MM-A900m offers great-looking design with the ability to download a rich selection of content directly to the phone. ',
                                                           'sku': 'MM-A900M',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:51:27',
                                                           'url_key': 'samsung-mm-a900m-ace',
                                                           'url_path': 'samsung-mm-a900m-ace.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (25, None, None, 'id')): {'categories': ['15',
                                                                          '28'],
                                                           'color': '23',
                                                           'computer_manufacturers': '77',
                                                           'cost': '1299.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 14:28:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "This, combined with myriad other engineering leaps, boosts performance up to four times higher than the PowerBook G4. With this awesome power, it's a breeze to render complex 3D models, enjoy smooth playback of HD video, or host a four-way video conference.Intel Core Duo is the first chip built using Intel's groundbreaking 65-nanometer process - resulting in transistors so small, you could fit a hundred inside a single human cell. With smaller distances for electrons to travel, and two processors designed to share resources and conserve power, Intel Core Duo achieves higher levels of performance as it uses fewer watts. Which is what makes it possible to design a super-powerful MacBook Pro that's only one inch thin.When Mac technology makes something easy, it's hardly news. So here's more non-news for MacBook Pro owners: software just works. If you see the Universal logo on a new application, that means it will run on Intel- and PowerPC-based Mac computers. For most existing applications, you simply do what you've always done: double-click them. Thanks to the Rosetta technology in Mac OS X, they look and feel just like they did before.",
                                                           'dimension': '19.5 x 7.6 x 19.5 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'hardrive': '100 GB 5400 rpm Serial ATA hard drive',
                                                           'has_options': '1',
                                                           'image_label': None,
                                                           'in_depth': u' <ul>\r\n<ul class="disc">\r\n<li>2.0 GHz Intel Core Duo processor with 2 MB shared L2 Cache<br></li>\r\n<li>1 GB (single SODIMM) 667 MHz DDR2 SDRAM (PC2-5300); 100 GB 5400 rpm Serial ATA hard drive; slot-load SuperDrive (DVD\xb1RW/CD-RW)<br></li>\r\n<li>One FireWire 400, two USB 2.0 ports, and ExpressCard/34 slot; no FireWire 800 slots<br></li>\r\n<li>Built-in 10/100/1000BASE-T (Gigabit); built-in 54 Mbps AirPort Extreme (802.11g); built-in Bluetooth 2.0+EDR<br></li>\r\n<li>15.4-inch TFT widescreen display with 1440 x 900 resolution</li>',
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'memory': '1 GB (single SODIMM) 667 MHz DDR2 SDRAM (PC2-5300)',
                                                           'meta_description': 'Apple MacBook Pro MA464LL/A 15.4" Notebook PC (2.0 GHz Intel Core Duo, 1 GB RAM, 100 GB Hard Drive, SuperDrive)',
                                                           'meta_keyword': 'Apple MacBook Pro MA464LL/A 15.4" Notebook PC (2.0 GHz Intel Core Duo, 1 GB RAM, 100 GB Hard Drive, SuperDrive) ',
                                                           'meta_title': 'Apple MacBook Pro MA464LL/A 15.4" Notebook PC (2.0 GHz Intel Core Duo, 1 GB RAM, 100 GB Hard Drive, SuperDrive)',
                                                           'minimal_price': '2299.9900',
                                                           'model': 'MA464LL/A',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Apple MacBook Pro MA464LL/A 15.4" Notebook PC',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container1',
                                                           'page_layout': None,
                                                           'price': '2299.9900',
                                                           'processor': '2.0 GHz Intel Core Duo processor with 2 MB shared L2 Cache',
                                                           'product_id': '25',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'screensize': '15.4-inch TFT widescreen display with 1440 x 900 resolution',
                                                           'set': '39',
                                                           'short_description': "You've seen improvements in notebook performance before - but never on this scale. The Intel Core Duo powering MacBook Pro is actually two processors built into a single chip.",
                                                           'sku': 'MA464LL/A',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-07-28 21:27:34',
                                                           'url_key': 'apple-macbook-pro-ma464ll-a-15-4-notebook-pc-2-0-ghz-intel-core-duo-1-gb-ram-100-gb-hard-drive-superdrive',
                                                           'url_path': 'apple-macbook-pro-ma464ll-a-15-4-notebook-pc-2-0-ghz-intel-core-duo-1-gb-ram-100-gb-hard-drive-superdrive.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '10.6000'},
        ('ol_catalog_product.info', (25, u'2', None, 'id')): {'categories': ['15',
                                                                          '28'],
                                                           'color': '23',
                                                           'computer_manufacturers': '77',
                                                           'cost': '1299.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 14:28:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "This, combined with myriad other engineering leaps, boosts performance up to four times higher than the PowerBook G4. With this awesome power, it's a breeze to render complex 3D models, enjoy smooth playback of HD video, or host a four-way video conference.Intel Core Duo is the first chip built using Intel's groundbreaking 65-nanometer process - resulting in transistors so small, you could fit a hundred inside a single human cell. With smaller distances for electrons to travel, and two processors designed to share resources and conserve power, Intel Core Duo achieves higher levels of performance as it uses fewer watts. Which is what makes it possible to design a super-powerful MacBook Pro that's only one inch thin.When Mac technology makes something easy, it's hardly news. So here's more non-news for MacBook Pro owners: software just works. If you see the Universal logo on a new application, that means it will run on Intel- and PowerPC-based Mac computers. For most existing applications, you simply do what you've always done: double-click them. Thanks to the Rosetta technology in Mac OS X, they look and feel just like they did before.",
                                                           'dimension': '19.5 x 7.6 x 19.5 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'hardrive': '100 GB 5400 rpm Serial ATA hard drive',
                                                           'has_options': '1',
                                                           'image_label': None,
                                                           'in_depth': u' <ul>\r\n<ul class="disc">\r\n<li>2.0 GHz Intel Core Duo processor with 2 MB shared L2 Cache<br></li>\r\n<li>1 GB (single SODIMM) 667 MHz DDR2 SDRAM (PC2-5300); 100 GB 5400 rpm Serial ATA hard drive; slot-load SuperDrive (DVD\xb1RW/CD-RW)<br></li>\r\n<li>One FireWire 400, two USB 2.0 ports, and ExpressCard/34 slot; no FireWire 800 slots<br></li>\r\n<li>Built-in 10/100/1000BASE-T (Gigabit); built-in 54 Mbps AirPort Extreme (802.11g); built-in Bluetooth 2.0+EDR<br></li>\r\n<li>15.4-inch TFT widescreen display with 1440 x 900 resolution</li>',
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'memory': '1 GB (single SODIMM) 667 MHz DDR2 SDRAM (PC2-5300)',
                                                           'meta_description': 'Apple MacBook Pro MA464LL/A 15.4" Notebook PC (2.0 GHz Intel Core Duo, 1 GB RAM, 100 GB Hard Drive, SuperDrive)',
                                                           'meta_keyword': 'Apple MacBook Pro MA464LL/A 15.4" Notebook PC (2.0 GHz Intel Core Duo, 1 GB RAM, 100 GB Hard Drive, SuperDrive) ',
                                                           'meta_title': 'Apple MacBook Pro MA464LL/A 15.4" Notebook PC (2.0 GHz Intel Core Duo, 1 GB RAM, 100 GB Hard Drive, SuperDrive)',
                                                           'minimal_price': '2299.9900',
                                                           'model': 'MA464LL/A',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Apple MacBook Pro MA464LL/A 15.4" Notebook PC',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container1',
                                                           'page_layout': None,
                                                           'price': '2299.9900',
                                                           'processor': '2.0 GHz Intel Core Duo processor with 2 MB shared L2 Cache',
                                                           'product_id': '25',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'screensize': '15.4-inch TFT widescreen display with 1440 x 900 resolution',
                                                           'set': '39',
                                                           'short_description': "You've seen improvements in notebook performance before - but never on this scale. The Intel Core Duo powering MacBook Pro is actually two processors built into a single chip.",
                                                           'sku': 'MA464LL/A',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-07-28 21:27:34',
                                                           'url_key': 'apple-macbook-pro-ma464ll-a-15-4-notebook-pc-2-0-ghz-intel-core-duo-1-gb-ram-100-gb-hard-drive-superdrive',
                                                           'url_path': 'apple-macbook-pro-ma464ll-a-15-4-notebook-pc-2-0-ghz-intel-core-duo-1-gb-ram-100-gb-hard-drive-superdrive.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '10.6000'},
        ('ol_catalog_product.info', (25, u'3', None, 'id')): {'categories': ['15',
                                                                          '28'],
                                                           'color': '23',
                                                           'computer_manufacturers': '77',
                                                           'cost': '1299.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 14:28:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "This, combined with myriad other engineering leaps, boosts performance up to four times higher than the PowerBook G4. With this awesome power, it's a breeze to render complex 3D models, enjoy smooth playback of HD video, or host a four-way video conference.Intel Core Duo is the first chip built using Intel's groundbreaking 65-nanometer process - resulting in transistors so small, you could fit a hundred inside a single human cell. With smaller distances for electrons to travel, and two processors designed to share resources and conserve power, Intel Core Duo achieves higher levels of performance as it uses fewer watts. Which is what makes it possible to design a super-powerful MacBook Pro that's only one inch thin.When Mac technology makes something easy, it's hardly news. So here's more non-news for MacBook Pro owners: software just works. If you see the Universal logo on a new application, that means it will run on Intel- and PowerPC-based Mac computers. For most existing applications, you simply do what you've always done: double-click them. Thanks to the Rosetta technology in Mac OS X, they look and feel just like they did before.",
                                                           'dimension': '19.5 x 7.6 x 19.5 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'hardrive': '100 GB 5400 rpm Serial ATA hard drive',
                                                           'has_options': '1',
                                                           'image_label': None,
                                                           'in_depth': u' <ul>\r\n<ul class="disc">\r\n<li>2.0 GHz Intel Core Duo processor with 2 MB shared L2 Cache<br></li>\r\n<li>1 GB (single SODIMM) 667 MHz DDR2 SDRAM (PC2-5300); 100 GB 5400 rpm Serial ATA hard drive; slot-load SuperDrive (DVD\xb1RW/CD-RW)<br></li>\r\n<li>One FireWire 400, two USB 2.0 ports, and ExpressCard/34 slot; no FireWire 800 slots<br></li>\r\n<li>Built-in 10/100/1000BASE-T (Gigabit); built-in 54 Mbps AirPort Extreme (802.11g); built-in Bluetooth 2.0+EDR<br></li>\r\n<li>15.4-inch TFT widescreen display with 1440 x 900 resolution</li>',
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'memory': '1 GB (single SODIMM) 667 MHz DDR2 SDRAM (PC2-5300)',
                                                           'meta_description': 'Apple MacBook Pro MA464LL/A 15.4" Notebook PC (2.0 GHz Intel Core Duo, 1 GB RAM, 100 GB Hard Drive, SuperDrive)',
                                                           'meta_keyword': 'Apple MacBook Pro MA464LL/A 15.4" Notebook PC (2.0 GHz Intel Core Duo, 1 GB RAM, 100 GB Hard Drive, SuperDrive) ',
                                                           'meta_title': 'Apple MacBook Pro MA464LL/A 15.4" Notebook PC (2.0 GHz Intel Core Duo, 1 GB RAM, 100 GB Hard Drive, SuperDrive)',
                                                           'minimal_price': '2299.9900',
                                                           'model': 'MA464LL/A',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Apple MacBook Pro MA464LL/A 15.4" Notebook PC',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container1',
                                                           'page_layout': None,
                                                           'price': '2299.9900',
                                                           'processor': '2.0 GHz Intel Core Duo processor with 2 MB shared L2 Cache',
                                                           'product_id': '25',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'screensize': '15.4-inch TFT widescreen display with 1440 x 900 resolution',
                                                           'set': '39',
                                                           'short_description': "You've seen improvements in notebook performance before - but never on this scale. The Intel Core Duo powering MacBook Pro is actually two processors built into a single chip.",
                                                           'sku': 'MA464LL/A',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-07-28 21:27:34',
                                                           'url_key': 'apple-macbook-pro-ma464ll-a-15-4-notebook-pc-2-0-ghz-intel-core-duo-1-gb-ram-100-gb-hard-drive-superdrive',
                                                           'url_path': 'apple-macbook-pro-ma464ll-a-15-4-notebook-pc-2-0-ghz-intel-core-duo-1-gb-ram-100-gb-hard-drive-superdrive.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '10.6000'},
        ('ol_catalog_product.info', (26, None, None, 'id')): {'categories': ['15',
                                                                          '28'],
                                                           'color': '24',
                                                           'computer_manufacturers': '79',
                                                           'cost': '999.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 14:35:16',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': ' Acer has flawlessly designed the Ferrari 3200, instilling it with exceptional performance, brilliant graphics, and lightning-fast connectivity. This exclusive edition is another striking symbol of cooperation between Acer and Ferrari -- two progressive companies with proud heritages built on passion, innovation, power and success.',
                                                           'dimension': '',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'hardrive': '80 gig Western Digital',
                                                           'has_options': '1',
                                                           'image_label': None,
                                                           'in_depth': ' <ul>\r\n<ul class="disc">\r\n<li>Mobile AMD Athlon 64 2800+<br></li>\r\n<li>1MB L2 Cache<br></li>\r\n<li>512MB of PC2700 DDR333 SDRAM<br></li>\r\n<li>2 RAM Slots (0 open - upgrading requires chip removal)<br></li>\r\n<li>RAM is upgradeable to 2GB</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'memory': '512MB of PC2700 DDR333 SDRAM',
                                                           'meta_description': 'Acer Ferrari 3200 Notebook Computer PC',
                                                           'meta_keyword': 'Acer Ferrari 3200 Notebook Computer PC ',
                                                           'meta_title': 'Acer Ferrari 3200 Notebook Computer PC',
                                                           'minimal_price': '1799.9900',
                                                           'model': 'LX.FR206.001',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Acer Ferrari 3200 Notebook Computer PC',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '1799.9900',
                                                           'processor': 'Mobile AMD Athlon 64 2800+',
                                                           'product_id': '26',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'screensize': '15-inch, 200-nit, high-brightness TFT LCD screen ',
                                                           'set': '39',
                                                           'short_description': 'This exclusive edition is another striking symbol of cooperation between Acer and Ferrari -- two progressive companies with proud heritages built on passion, innovation, power and success',
                                                           'sku': 'LX.FR206.001',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-05 07:14:52',
                                                           'url_key': 'acer-ferrari-3200-notebook-computer-pc',
                                                           'url_path': 'acer-ferrari-3200-notebook-computer-pc.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '11.4000'},
        ('ol_catalog_product.info', (26, u'2', None, 'id')): {'categories': ['15',
                                                                          '28'],
                                                           'color': '24',
                                                           'computer_manufacturers': '79',
                                                           'cost': '999.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 14:35:16',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': ' Acer has flawlessly designed the Ferrari 3200, instilling it with exceptional performance, brilliant graphics, and lightning-fast connectivity. This exclusive edition is another striking symbol of cooperation between Acer and Ferrari -- two progressive companies with proud heritages built on passion, innovation, power and success.',
                                                           'dimension': '',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'hardrive': '80 gig Western Digital',
                                                           'has_options': '1',
                                                           'image_label': None,
                                                           'in_depth': ' <ul>\r\n<ul class="disc">\r\n<li>Mobile AMD Athlon 64 2800+<br></li>\r\n<li>1MB L2 Cache<br></li>\r\n<li>512MB of PC2700 DDR333 SDRAM<br></li>\r\n<li>2 RAM Slots (0 open - upgrading requires chip removal)<br></li>\r\n<li>RAM is upgradeable to 2GB</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'memory': '512MB of PC2700 DDR333 SDRAM',
                                                           'meta_description': 'Acer Ferrari 3200 Notebook Computer PC',
                                                           'meta_keyword': 'Acer Ferrari 3200 Notebook Computer PC ',
                                                           'meta_title': 'Acer Ferrari 3200 Notebook Computer PC',
                                                           'minimal_price': '1799.9900',
                                                           'model': 'LX.FR206.001',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Acer Ferrari 3200 Notebook Computer PC',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '1799.9900',
                                                           'processor': 'Mobile AMD Athlon 64 2800+',
                                                           'product_id': '26',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'screensize': '15-inch, 200-nit, high-brightness TFT LCD screen ',
                                                           'set': '39',
                                                           'short_description': 'This exclusive edition is another striking symbol of cooperation between Acer and Ferrari -- two progressive companies with proud heritages built on passion, innovation, power and success',
                                                           'sku': 'LX.FR206.001',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-05 07:14:52',
                                                           'url_key': 'acer-ferrari-3200-notebook-computer-pc',
                                                           'url_path': 'acer-ferrari-3200-notebook-computer-pc.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '11.4000'},
        ('ol_catalog_product.info', (26, u'3', None, 'id')): {'categories': ['15',
                                                                          '28'],
                                                           'color': '24',
                                                           'computer_manufacturers': '79',
                                                           'cost': '999.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 14:35:16',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': ' Acer has flawlessly designed the Ferrari 3200, instilling it with exceptional performance, brilliant graphics, and lightning-fast connectivity. This exclusive edition is another striking symbol of cooperation between Acer and Ferrari -- two progressive companies with proud heritages built on passion, innovation, power and success.',
                                                           'dimension': '',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'hardrive': '80 gig Western Digital',
                                                           'has_options': '1',
                                                           'image_label': None,
                                                           'in_depth': ' <ul>\r\n<ul class="disc">\r\n<li>Mobile AMD Athlon 64 2800+<br></li>\r\n<li>1MB L2 Cache<br></li>\r\n<li>512MB of PC2700 DDR333 SDRAM<br></li>\r\n<li>2 RAM Slots (0 open - upgrading requires chip removal)<br></li>\r\n<li>RAM is upgradeable to 2GB</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'memory': '512MB of PC2700 DDR333 SDRAM',
                                                           'meta_description': 'Acer Ferrari 3200 Notebook Computer PC',
                                                           'meta_keyword': 'Acer Ferrari 3200 Notebook Computer PC ',
                                                           'meta_title': 'Acer Ferrari 3200 Notebook Computer PC',
                                                           'minimal_price': '1799.9900',
                                                           'model': 'LX.FR206.001',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Acer Ferrari 3200 Notebook Computer PC',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '1799.9900',
                                                           'processor': 'Mobile AMD Athlon 64 2800+',
                                                           'product_id': '26',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'screensize': '15-inch, 200-nit, high-brightness TFT LCD screen ',
                                                           'set': '39',
                                                           'short_description': 'This exclusive edition is another striking symbol of cooperation between Acer and Ferrari -- two progressive companies with proud heritages built on passion, innovation, power and success',
                                                           'sku': 'LX.FR206.001',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-05 07:14:52',
                                                           'url_key': 'acer-ferrari-3200-notebook-computer-pc',
                                                           'url_path': 'acer-ferrari-3200-notebook-computer-pc.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '11.4000'},
        ('ol_catalog_product.info', (27, None, None, 'id')): {'categories': [],
                                                           'color': '24',
                                                           'computer_manufacturers': '76',
                                                           'cost': '899.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 14:41:56',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': ' Weighing in at just an amazing 2.84 pounds and offering a sleek, durable carbon-fiber case in charcoal black. And with 4 to 10 hours of standard battery life, it has the stamina to power you through your most demanding applications. With the integrated wireless WAN, you can access the national Sprint Mobile Broadband service to extend your wireless coverage beyond LAN access networks and hotspots, giving you the freedom to go farther, do more, and stay connected.\r\n\r\n',
                                                           'dimension': '10.7 x 1.23 x 7.7 inches (WxHxD)',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'hardrive': '100 GB Hard Drive',
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': ' <ul>\r\n<ul class="disc">\r\n<li>Processor: The Ultra Low Voltage Intel Core Solo U1500 processor offers a 1.33 GHz speed paired with a fast 533 MHz front-side bus and large 2 MB L2 cache. (An L2, or secondary, cache temporarily stores data; and a larger L2 cache can help speed up your system\'s performance. The FSB carries data between the CPU and RAM, and a faster front-side bus will deliver better overall performance.) The Core Solo processor delivers enhanced performance for today\'s demanding applications such as CAD tools, 3-D and 2-D modeling, video editing, digital music, digital photography and gaming. And Intel\'s Smart Cache technology enables smarter, more efficient cache and bus design for enhanced performance, responsiveness and power savings.</li>\r\n</ul>\r\n\r\n   ',
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'memory': '2 GB RAM',
                                                           'meta_description': u'Sony VAIO VGN-TXN27N/B 11.1" Notebook PC (Intel Core Solo Processor U1500, 2 GB RAM, 100 GB Hard Drive, DVD\xb1RW Drive, Vista Business) Charcoal Black',
                                                           'meta_keyword': 'Sony, VAIO, VGN-TXN27N/B , Notebook, PC, Intel, 2 GB RAM, Laptop',
                                                           'meta_title': u'Sony VAIO VGN-TXN27N/B 11.1" Notebook PC (Intel Core Solo Processor U1500, 2 GB RAM, 100 GB Hard Drive, DVD\xb1RW Drive, Vista Business) Charcoal Black',
                                                           'minimal_price': '2699.9900',
                                                           'model': 'VGN-TXN27N/B',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Sony VAIO VGN-TXN27N/B 11.1" Notebook PC',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '2699.9900',
                                                           'processor': 'Intel Core Solo Processor U1500',
                                                           'product_id': '27',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'screensize': '9 inches',
                                                           'set': '39',
                                                           'short_description': "Take a load off your shoulders when you're racing for your plane with the sleekly designed and ultra-portable Sony Vaio VGN-TXN27N/B notebook PC.",
                                                           'sku': 'VGN-TXN27N/B',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-06 05:12:24',
                                                           'url_key': 'sony-vaio-vgn-txn27n-b-11-1-notebook-pc',
                                                           'url_path': 'sony-vaio-vgn-txn27n-b-11-1-notebook-pc.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '2.8000'},
        ('ol_catalog_product.info', (27, u'2', None, 'id')): {'categories': [],
                                                           'color': '24',
                                                           'computer_manufacturers': '76',
                                                           'cost': '899.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 14:41:56',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': ' Weighing in at just an amazing 2.84 pounds and offering a sleek, durable carbon-fiber case in charcoal black. And with 4 to 10 hours of standard battery life, it has the stamina to power you through your most demanding applications. With the integrated wireless WAN, you can access the national Sprint Mobile Broadband service to extend your wireless coverage beyond LAN access networks and hotspots, giving you the freedom to go farther, do more, and stay connected.\r\n\r\n',
                                                           'dimension': '10.7 x 1.23 x 7.7 inches (WxHxD)',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'hardrive': '100 GB Hard Drive',
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': ' <ul>\r\n<ul class="disc">\r\n<li>Processor: The Ultra Low Voltage Intel Core Solo U1500 processor offers a 1.33 GHz speed paired with a fast 533 MHz front-side bus and large 2 MB L2 cache. (An L2, or secondary, cache temporarily stores data; and a larger L2 cache can help speed up your system\'s performance. The FSB carries data between the CPU and RAM, and a faster front-side bus will deliver better overall performance.) The Core Solo processor delivers enhanced performance for today\'s demanding applications such as CAD tools, 3-D and 2-D modeling, video editing, digital music, digital photography and gaming. And Intel\'s Smart Cache technology enables smarter, more efficient cache and bus design for enhanced performance, responsiveness and power savings.</li>\r\n</ul>\r\n\r\n   ',
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'memory': '2 GB RAM',
                                                           'meta_description': u'Sony VAIO VGN-TXN27N/B 11.1" Notebook PC (Intel Core Solo Processor U1500, 2 GB RAM, 100 GB Hard Drive, DVD\xb1RW Drive, Vista Business) Charcoal Black',
                                                           'meta_keyword': 'Sony, VAIO, VGN-TXN27N/B , Notebook, PC, Intel, 2 GB RAM, Laptop',
                                                           'meta_title': u'Sony VAIO VGN-TXN27N/B 11.1" Notebook PC (Intel Core Solo Processor U1500, 2 GB RAM, 100 GB Hard Drive, DVD\xb1RW Drive, Vista Business) Charcoal Black',
                                                           'minimal_price': '2699.9900',
                                                           'model': 'VGN-TXN27N/B',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Sony VAIO VGN-TXN27N/B 11.1" Notebook PC',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '2699.9900',
                                                           'processor': 'Intel Core Solo Processor U1500',
                                                           'product_id': '27',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'screensize': '9 inches',
                                                           'set': '39',
                                                           'short_description': "Take a load off your shoulders when you're racing for your plane with the sleekly designed and ultra-portable Sony Vaio VGN-TXN27N/B notebook PC.",
                                                           'sku': 'VGN-TXN27N/B',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-06 05:12:24',
                                                           'url_key': 'sony-vaio-vgn-txn27n-b-11-1-notebook-pc',
                                                           'url_path': 'sony-vaio-vgn-txn27n-b-11-1-notebook-pc.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '2.8000'},
        ('ol_catalog_product.info', (27, u'3', None, 'id')): {'categories': [],
                                                           'color': '24',
                                                           'computer_manufacturers': '76',
                                                           'cost': '899.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 14:41:56',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': ' Weighing in at just an amazing 2.84 pounds and offering a sleek, durable carbon-fiber case in charcoal black. And with 4 to 10 hours of standard battery life, it has the stamina to power you through your most demanding applications. With the integrated wireless WAN, you can access the national Sprint Mobile Broadband service to extend your wireless coverage beyond LAN access networks and hotspots, giving you the freedom to go farther, do more, and stay connected.\r\n\r\n',
                                                           'dimension': '10.7 x 1.23 x 7.7 inches (WxHxD)',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'hardrive': '100 GB Hard Drive',
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': ' <ul>\r\n<ul class="disc">\r\n<li>Processor: The Ultra Low Voltage Intel Core Solo U1500 processor offers a 1.33 GHz speed paired with a fast 533 MHz front-side bus and large 2 MB L2 cache. (An L2, or secondary, cache temporarily stores data; and a larger L2 cache can help speed up your system\'s performance. The FSB carries data between the CPU and RAM, and a faster front-side bus will deliver better overall performance.) The Core Solo processor delivers enhanced performance for today\'s demanding applications such as CAD tools, 3-D and 2-D modeling, video editing, digital music, digital photography and gaming. And Intel\'s Smart Cache technology enables smarter, more efficient cache and bus design for enhanced performance, responsiveness and power savings.</li>\r\n</ul>\r\n\r\n   ',
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'memory': '2 GB RAM',
                                                           'meta_description': u'Sony VAIO VGN-TXN27N/B 11.1" Notebook PC (Intel Core Solo Processor U1500, 2 GB RAM, 100 GB Hard Drive, DVD\xb1RW Drive, Vista Business) Charcoal Black',
                                                           'meta_keyword': 'Sony, VAIO, VGN-TXN27N/B , Notebook, PC, Intel, 2 GB RAM, Laptop',
                                                           'meta_title': u'Sony VAIO VGN-TXN27N/B 11.1" Notebook PC (Intel Core Solo Processor U1500, 2 GB RAM, 100 GB Hard Drive, DVD\xb1RW Drive, Vista Business) Charcoal Black',
                                                           'minimal_price': '2699.9900',
                                                           'model': 'VGN-TXN27N/B',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Sony VAIO VGN-TXN27N/B 11.1" Notebook PC',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '2699.9900',
                                                           'processor': 'Intel Core Solo Processor U1500',
                                                           'product_id': '27',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'screensize': '9 inches',
                                                           'set': '39',
                                                           'short_description': "Take a load off your shoulders when you're racing for your plane with the sleekly designed and ultra-portable Sony Vaio VGN-TXN27N/B notebook PC.",
                                                           'sku': 'VGN-TXN27N/B',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-06 05:12:24',
                                                           'url_key': 'sony-vaio-vgn-txn27n-b-11-1-notebook-pc',
                                                           'url_path': 'sony-vaio-vgn-txn27n-b-11-1-notebook-pc.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '2.8000'},
        ('ol_catalog_product.info', (28, None, None, 'id')): {'categories': ['15',
                                                                          '28'],
                                                           'color': '24',
                                                           'computer_manufacturers': '74',
                                                           'cost': '899.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 14:47:57',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "Easily mobile at just 6 pounds, the Toshiba Satellite A135-S4527 makes it easy to get your work done with a large, bright 15.4-inch widescreen LCD. The XGA-resolution screen (1280 x 800) permits side-by-side viewing of documents for increased productivity. It's also great for using as a media center, with Toshiba's unique Express Media Player enabling you to bypass the system and access CDs and DVDs with a touch of button. This affordable notebook PC is powered by Intel's 1.73 GHz Core Duo T2080 processor, which provides an optimized, multithreaded architecture for improved gaming and multitasking performance and efficient power consumption. It also offers a 120 GB hard drive, 1 GB of installed RAM (2 GB maximum), dual-layer/multi-format DVD drive that also burns CDs, integrated 54g wireless connectivity, and Intel GMA 950 video card with up to 256 MB of shared video RAM.\r\n\r\n",
                                                           'dimension': '17 x 7 x 13 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'hardrive': '60 GB hard drive',
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': ' <ul>\r\n<ul class="disc">\r\n<li>Processor: The Intel Core Duo T2080 processor is built with the Mobile Intel 945PM Express chipset, and it has a 1.73 GHz processor speed, fast 533 MHz front-side bus (FSB), and 1 MB L2 cache. (An L2, or secondary, cache temporarily stores data; and a larger L2 cache can help speed up your system\'s performance. The FSB carries data between the CPU and RAM, and a faster front-side bus will deliver better overall performance.)</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'memory': '1 GB RAM',
                                                           'meta_description': 'Toshiba M285-E 14" Convertible Notebook PC (Intel Core Duo Processor T2300E, 1 GB RAM, 60',
                                                           'meta_keyword': 'Toshiba, notebook, laptop, intel, ',
                                                           'meta_title': 'Toshiba Satellite A135-S4527 155.4" Notebook PC (Intel Pentium Dual Core Processor T2080, 1 GB RAM, 120 GB Hard Drive, SuperMulti DVD Drive, Vista Premium)',
                                                           'minimal_price': '1599.9900',
                                                           'model': 'M285-E',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Toshiba M285-E 14"',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '1599.9900',
                                                           'processor': '1.66 GHz Intel Core Duo T2300E processor',
                                                           'product_id': '28',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'screensize': '14-inch screen ',
                                                           'set': '39',
                                                           'short_description': 'Get the competitive edge with the Gateway M285-E. This widescreen Convertible Notebook functions as both a conventional notebook and a tablet.',
                                                           'sku': 'M285-E',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:51:44',
                                                           'url_key': 'toshiba-satellite-a135-s4527-155-4-notebook-pc-intel-pentium-dual-core-processor-t2080-1-gb-ram-120-gb-hard-drive-supermulti-dvd-drive-vista-premium',
                                                           'url_path': 'toshiba-satellite-a135-s4527-155-4-notebook-pc-intel-pentium-dual-core-processor-t2080-1-gb-ram-120-gb-hard-drive-supermulti-dvd-drive-vista-premium.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '10.0000'},
        ('ol_catalog_product.info', (28, u'2', None, 'id')): {'categories': ['15',
                                                                          '28'],
                                                           'color': '24',
                                                           'computer_manufacturers': '74',
                                                           'cost': '899.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 14:47:57',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "Easily mobile at just 6 pounds, the Toshiba Satellite A135-S4527 makes it easy to get your work done with a large, bright 15.4-inch widescreen LCD. The XGA-resolution screen (1280 x 800) permits side-by-side viewing of documents for increased productivity. It's also great for using as a media center, with Toshiba's unique Express Media Player enabling you to bypass the system and access CDs and DVDs with a touch of button. This affordable notebook PC is powered by Intel's 1.73 GHz Core Duo T2080 processor, which provides an optimized, multithreaded architecture for improved gaming and multitasking performance and efficient power consumption. It also offers a 120 GB hard drive, 1 GB of installed RAM (2 GB maximum), dual-layer/multi-format DVD drive that also burns CDs, integrated 54g wireless connectivity, and Intel GMA 950 video card with up to 256 MB of shared video RAM.\r\n\r\n",
                                                           'dimension': '17 x 7 x 13 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'hardrive': '60 GB hard drive',
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': ' <ul>\r\n<ul class="disc">\r\n<li>Processor: The Intel Core Duo T2080 processor is built with the Mobile Intel 945PM Express chipset, and it has a 1.73 GHz processor speed, fast 533 MHz front-side bus (FSB), and 1 MB L2 cache. (An L2, or secondary, cache temporarily stores data; and a larger L2 cache can help speed up your system\'s performance. The FSB carries data between the CPU and RAM, and a faster front-side bus will deliver better overall performance.)</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'memory': '1 GB RAM',
                                                           'meta_description': 'Toshiba M285-E 14" Convertible Notebook PC (Intel Core Duo Processor T2300E, 1 GB RAM, 60',
                                                           'meta_keyword': 'Toshiba, notebook, laptop, intel, ',
                                                           'meta_title': 'Toshiba Satellite A135-S4527 155.4" Notebook PC (Intel Pentium Dual Core Processor T2080, 1 GB RAM, 120 GB Hard Drive, SuperMulti DVD Drive, Vista Premium)',
                                                           'minimal_price': '1599.9900',
                                                           'model': 'M285-E',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Toshiba M285-E 14"',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '1599.9900',
                                                           'processor': '1.66 GHz Intel Core Duo T2300E processor',
                                                           'product_id': '28',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'screensize': '14-inch screen ',
                                                           'set': '39',
                                                           'short_description': 'Get the competitive edge with the Gateway M285-E. This widescreen Convertible Notebook functions as both a conventional notebook and a tablet.',
                                                           'sku': 'M285-E',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:51:44',
                                                           'url_key': 'toshiba-satellite-a135-s4527-155-4-notebook-pc-intel-pentium-dual-core-processor-t2080-1-gb-ram-120-gb-hard-drive-supermulti-dvd-drive-vista-premium',
                                                           'url_path': 'toshiba-satellite-a135-s4527-155-4-notebook-pc-intel-pentium-dual-core-processor-t2080-1-gb-ram-120-gb-hard-drive-supermulti-dvd-drive-vista-premium.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '10.0000'},
        ('ol_catalog_product.info', (28, u'3', None, 'id')): {'categories': ['15',
                                                                          '28'],
                                                           'color': '24',
                                                           'computer_manufacturers': '74',
                                                           'cost': '899.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 14:47:57',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "Easily mobile at just 6 pounds, the Toshiba Satellite A135-S4527 makes it easy to get your work done with a large, bright 15.4-inch widescreen LCD. The XGA-resolution screen (1280 x 800) permits side-by-side viewing of documents for increased productivity. It's also great for using as a media center, with Toshiba's unique Express Media Player enabling you to bypass the system and access CDs and DVDs with a touch of button. This affordable notebook PC is powered by Intel's 1.73 GHz Core Duo T2080 processor, which provides an optimized, multithreaded architecture for improved gaming and multitasking performance and efficient power consumption. It also offers a 120 GB hard drive, 1 GB of installed RAM (2 GB maximum), dual-layer/multi-format DVD drive that also burns CDs, integrated 54g wireless connectivity, and Intel GMA 950 video card with up to 256 MB of shared video RAM.\r\n\r\n",
                                                           'dimension': '17 x 7 x 13 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'hardrive': '60 GB hard drive',
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': ' <ul>\r\n<ul class="disc">\r\n<li>Processor: The Intel Core Duo T2080 processor is built with the Mobile Intel 945PM Express chipset, and it has a 1.73 GHz processor speed, fast 533 MHz front-side bus (FSB), and 1 MB L2 cache. (An L2, or secondary, cache temporarily stores data; and a larger L2 cache can help speed up your system\'s performance. The FSB carries data between the CPU and RAM, and a faster front-side bus will deliver better overall performance.)</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'memory': '1 GB RAM',
                                                           'meta_description': 'Toshiba M285-E 14" Convertible Notebook PC (Intel Core Duo Processor T2300E, 1 GB RAM, 60',
                                                           'meta_keyword': 'Toshiba, notebook, laptop, intel, ',
                                                           'meta_title': 'Toshiba Satellite A135-S4527 155.4" Notebook PC (Intel Pentium Dual Core Processor T2080, 1 GB RAM, 120 GB Hard Drive, SuperMulti DVD Drive, Vista Premium)',
                                                           'minimal_price': '1599.9900',
                                                           'model': 'M285-E',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Toshiba M285-E 14"',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '1599.9900',
                                                           'processor': '1.66 GHz Intel Core Duo T2300E processor',
                                                           'product_id': '28',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'screensize': '14-inch screen ',
                                                           'set': '39',
                                                           'short_description': 'Get the competitive edge with the Gateway M285-E. This widescreen Convertible Notebook functions as both a conventional notebook and a tablet.',
                                                           'sku': 'M285-E',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:51:44',
                                                           'url_key': 'toshiba-satellite-a135-s4527-155-4-notebook-pc-intel-pentium-dual-core-processor-t2080-1-gb-ram-120-gb-hard-drive-supermulti-dvd-drive-vista-premium',
                                                           'url_path': 'toshiba-satellite-a135-s4527-155-4-notebook-pc-intel-pentium-dual-core-processor-t2080-1-gb-ram-120-gb-hard-drive-supermulti-dvd-drive-vista-premium.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '10.0000'},
        ('ol_catalog_product.info', (29, None, None, 'id')): {'categories': [],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '29',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '46',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_3',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:51:34',
                                                           'url_key': 'cn-clogs-beach-garden-clog-3',
                                                           'url_path': 'cn-clogs-beach-garden-clog-3.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (29, u'2', None, 'id')): {'categories': [],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '29',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '46',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_3',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:51:34',
                                                           'url_key': 'cn-clogs-beach-garden-clog-3',
                                                           'url_path': 'cn-clogs-beach-garden-clog-3.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (29, u'3', None, 'id')): {'categories': [],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '29',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '46',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_3',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:51:34',
                                                           'url_key': 'cn-clogs-beach-garden-clog-3',
                                                           'url_path': 'cn-clogs-beach-garden-clog-3.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (30, None, None, 'id')): {'categories': ['16'],
                                                           'color': '61',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:00:49',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': u'The ASICS\xae GEL-Kayano\xae XII running shoe delivers the ultimate blend of cushioning and support. Biomorphic Fit\u2122 upper offers enhanced upper fit and comfort while decreasing the potential for irritation. Solyte midsole material is lighter than standard EVA and SpEVA\xae combined with improved cushioning and durability. Impact Guidance System (I.G.S.\xae) uses linked componentry to encourage optimal gait while allowing for natural foot movement from heel strike to toe off. DuoMax\xae support system helps ensure that the shoe maintains proper support for the foot during the critical transition from heel strike to toe off. Space Trusstic\xae System creates a pocket between the Trusstic\xae System device and the midsole, allowing for greater midsole deformation and more efficient foot function. GEL\xae Cushioning System provides maximum rearfoot and forefoot shock attenuation. Wt. 12.6 oz.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '# I.G.S.?: Allows for natural foot movement from heel strike to toe-off\r\n# DuoMax? Support System: Maintains proper support for the foot during the critical transition from heel strike to toe-off\r\n# Space Trusstic System?: Allows for greater midsole deformation and more efficient foot function\r\n# GEL? Cushioning System: Provides maximum rearfoot/forefoot shock attenuation\r\n# Biomorphic Fit Upper: Provides enhanced upper fit and comfort while limiting irritation',
                                                           'is_recurring': None,
                                                           'manufacturer': '64',
                                                           'meta_description': u"ASICS\xae Men's GEL-Kayano\xae XII",
                                                           'meta_keyword': u"ASICS\xae Men's GEL-Kayano\xae XII ",
                                                           'meta_title': u"ASICS\xae Men's GEL-Kayano\xae XII",
                                                           'minimal_price': '134.9900',
                                                           'model': 'B000CP1M00',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': u"ASICS\xae Men's GEL-Kayano\xae XII",
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '134.9900',
                                                           'product_id': '30',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '41',
                                                           'shoe_type': '49',
                                                           'short_description': u'The ASICS\xae GEL-Kayano\xae XII running shoe delivers the ultimate blend of cushioning and support. Biomorphic Fit\u2122 upper offers enhanced upper fit and comfort while decreasing the potential for irritation. ',
                                                           'sku': 'asc_8',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-07-31 17:23:28',
                                                           'url_key': 'asics-men-s-gel-kayano-xii-8',
                                                           'url_path': 'asics-men-s-gel-kayano-xii-8.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '3.0000'},
        ('ol_catalog_product.info', (30, u'2', None, 'id')): {'categories': ['16'],
                                                           'color': '61',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:00:49',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': u'The ASICS\xae GEL-Kayano\xae XII running shoe delivers the ultimate blend of cushioning and support. Biomorphic Fit\u2122 upper offers enhanced upper fit and comfort while decreasing the potential for irritation. Solyte midsole material is lighter than standard EVA and SpEVA\xae combined with improved cushioning and durability. Impact Guidance System (I.G.S.\xae) uses linked componentry to encourage optimal gait while allowing for natural foot movement from heel strike to toe off. DuoMax\xae support system helps ensure that the shoe maintains proper support for the foot during the critical transition from heel strike to toe off. Space Trusstic\xae System creates a pocket between the Trusstic\xae System device and the midsole, allowing for greater midsole deformation and more efficient foot function. GEL\xae Cushioning System provides maximum rearfoot and forefoot shock attenuation. Wt. 12.6 oz.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '# I.G.S.?: Allows for natural foot movement from heel strike to toe-off\r\n# DuoMax? Support System: Maintains proper support for the foot during the critical transition from heel strike to toe-off\r\n# Space Trusstic System?: Allows for greater midsole deformation and more efficient foot function\r\n# GEL? Cushioning System: Provides maximum rearfoot/forefoot shock attenuation\r\n# Biomorphic Fit Upper: Provides enhanced upper fit and comfort while limiting irritation',
                                                           'is_recurring': None,
                                                           'manufacturer': '64',
                                                           'meta_description': u"ASICS\xae Men's GEL-Kayano\xae XII",
                                                           'meta_keyword': u"ASICS\xae Men's GEL-Kayano\xae XII ",
                                                           'meta_title': u"ASICS\xae Men's GEL-Kayano\xae XII",
                                                           'minimal_price': '134.9900',
                                                           'model': 'B000CP1M00',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': u"ASICS\xae Men's GEL-Kayano\xae XII",
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '134.9900',
                                                           'product_id': '30',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '41',
                                                           'shoe_type': '49',
                                                           'short_description': u'The ASICS\xae GEL-Kayano\xae XII running shoe delivers the ultimate blend of cushioning and support. Biomorphic Fit\u2122 upper offers enhanced upper fit and comfort while decreasing the potential for irritation. ',
                                                           'sku': 'asc_8',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-07-31 17:23:28',
                                                           'url_key': 'asics-men-s-gel-kayano-xii-8',
                                                           'url_path': 'asics-men-s-gel-kayano-xii-8.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '3.0000'},
        ('ol_catalog_product.info', (30, u'3', None, 'id')): {'categories': ['16'],
                                                           'color': '61',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:00:49',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': u'The ASICS\xae GEL-Kayano\xae XII running shoe delivers the ultimate blend of cushioning and support. Biomorphic Fit\u2122 upper offers enhanced upper fit and comfort while decreasing the potential for irritation. Solyte midsole material is lighter than standard EVA and SpEVA\xae combined with improved cushioning and durability. Impact Guidance System (I.G.S.\xae) uses linked componentry to encourage optimal gait while allowing for natural foot movement from heel strike to toe off. DuoMax\xae support system helps ensure that the shoe maintains proper support for the foot during the critical transition from heel strike to toe off. Space Trusstic\xae System creates a pocket between the Trusstic\xae System device and the midsole, allowing for greater midsole deformation and more efficient foot function. GEL\xae Cushioning System provides maximum rearfoot and forefoot shock attenuation. Wt. 12.6 oz.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '# I.G.S.?: Allows for natural foot movement from heel strike to toe-off\r\n# DuoMax? Support System: Maintains proper support for the foot during the critical transition from heel strike to toe-off\r\n# Space Trusstic System?: Allows for greater midsole deformation and more efficient foot function\r\n# GEL? Cushioning System: Provides maximum rearfoot/forefoot shock attenuation\r\n# Biomorphic Fit Upper: Provides enhanced upper fit and comfort while limiting irritation',
                                                           'is_recurring': None,
                                                           'manufacturer': '64',
                                                           'meta_description': u"ASICS\xae Men's GEL-Kayano\xae XII",
                                                           'meta_keyword': u"ASICS\xae Men's GEL-Kayano\xae XII ",
                                                           'meta_title': u"ASICS\xae Men's GEL-Kayano\xae XII",
                                                           'minimal_price': '134.9900',
                                                           'model': 'B000CP1M00',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': u"ASICS\xae Men's GEL-Kayano\xae XII",
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '134.9900',
                                                           'product_id': '30',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '41',
                                                           'shoe_type': '49',
                                                           'short_description': u'The ASICS\xae GEL-Kayano\xae XII running shoe delivers the ultimate blend of cushioning and support. Biomorphic Fit\u2122 upper offers enhanced upper fit and comfort while decreasing the potential for irritation. ',
                                                           'sku': 'asc_8',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-07-31 17:23:28',
                                                           'url_key': 'asics-men-s-gel-kayano-xii-8',
                                                           'url_path': 'asics-men-s-gel-kayano-xii-8.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '3.0000'},
        ('ol_catalog_product.info', (31, None, None, 'id')): {'categories': ['17'],
                                                           'color': '26',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:05:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "Nothing will turn his head faster than you wearing the sexy Pryme pump from Steven by Steve Madden. This daring pump has a pretty patent leather upper with light shirring, a double stitch detail surrounding the collar, and a vampy almond shaped toe. It also features smooth linings, a fully cushioned insole, a sexy covered stiletto heel, and a lightly textured dress leather outsole. Any way you wear the Pryme, you're certain to catch a lot of attention.",
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'A prime example of chic style. Patent leather upper. Round toe. 3-1/2 inch covered heel. Flex leather sole. Imported. ',
                                                           'is_recurring': None,
                                                           'manufacturer': '62',
                                                           'meta_description': 'Steven by Steve Madden Pryme Pump',
                                                           'meta_keyword': 'Steven by Steve Madden Pryme Pump',
                                                           'meta_title': 'Steven by Steve Madden Pryme Pump',
                                                           'minimal_price': '69.9900',
                                                           'model': 'B000NOGIKY',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Steven by Steve Madden Pryme Pump',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '69.9900',
                                                           'product_id': '31',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '45',
                                                           'shoe_type': '51',
                                                           'short_description': 'Nothing will turn his head faster than you wearing the sexy Pryme pump from Steven by Steve Madden. This daring pump has a pretty patent leather upper with light shirring, a double stitch detail surrounding the collar, and a vampy almond shaped toe',
                                                           'sku': 'steve_4',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:02:40',
                                                           'url_key': 'steven-by-steve-madden-pryme-pump-4',
                                                           'url_path': 'steven-by-steve-madden-pryme-pump-4.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (31, u'2', None, 'id')): {'categories': ['17'],
                                                           'color': '26',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:05:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "Nothing will turn his head faster than you wearing the sexy Pryme pump from Steven by Steve Madden. This daring pump has a pretty patent leather upper with light shirring, a double stitch detail surrounding the collar, and a vampy almond shaped toe. It also features smooth linings, a fully cushioned insole, a sexy covered stiletto heel, and a lightly textured dress leather outsole. Any way you wear the Pryme, you're certain to catch a lot of attention.",
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'A prime example of chic style. Patent leather upper. Round toe. 3-1/2 inch covered heel. Flex leather sole. Imported. ',
                                                           'is_recurring': None,
                                                           'manufacturer': '62',
                                                           'meta_description': 'Steven by Steve Madden Pryme Pump',
                                                           'meta_keyword': 'Steven by Steve Madden Pryme Pump',
                                                           'meta_title': 'Steven by Steve Madden Pryme Pump',
                                                           'minimal_price': '69.9900',
                                                           'model': 'B000NOGIKY',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Steven by Steve Madden Pryme Pump',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '69.9900',
                                                           'product_id': '31',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '45',
                                                           'shoe_type': '51',
                                                           'short_description': 'Nothing will turn his head faster than you wearing the sexy Pryme pump from Steven by Steve Madden. This daring pump has a pretty patent leather upper with light shirring, a double stitch detail surrounding the collar, and a vampy almond shaped toe',
                                                           'sku': 'steve_4',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:02:40',
                                                           'url_key': 'steven-by-steve-madden-pryme-pump-4',
                                                           'url_path': 'steven-by-steve-madden-pryme-pump-4.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (31, u'3', None, 'id')): {'categories': ['17'],
                                                           'color': '26',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:05:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "Nothing will turn his head faster than you wearing the sexy Pryme pump from Steven by Steve Madden. This daring pump has a pretty patent leather upper with light shirring, a double stitch detail surrounding the collar, and a vampy almond shaped toe. It also features smooth linings, a fully cushioned insole, a sexy covered stiletto heel, and a lightly textured dress leather outsole. Any way you wear the Pryme, you're certain to catch a lot of attention.",
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'A prime example of chic style. Patent leather upper. Round toe. 3-1/2 inch covered heel. Flex leather sole. Imported. ',
                                                           'is_recurring': None,
                                                           'manufacturer': '62',
                                                           'meta_description': 'Steven by Steve Madden Pryme Pump',
                                                           'meta_keyword': 'Steven by Steve Madden Pryme Pump',
                                                           'meta_title': 'Steven by Steve Madden Pryme Pump',
                                                           'minimal_price': '69.9900',
                                                           'model': 'B000NOGIKY',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Steven by Steve Madden Pryme Pump',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '69.9900',
                                                           'product_id': '31',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '45',
                                                           'shoe_type': '51',
                                                           'short_description': 'Nothing will turn his head faster than you wearing the sexy Pryme pump from Steven by Steve Madden. This daring pump has a pretty patent leather upper with light shirring, a double stitch detail surrounding the collar, and a vampy almond shaped toe',
                                                           'sku': 'steve_4',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:02:40',
                                                           'url_key': 'steven-by-steve-madden-pryme-pump-4',
                                                           'url_path': 'steven-by-steve-madden-pryme-pump-4.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (32, None, None, 'id')): {'categories': ['17'],
                                                           'color': '26',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:12:54',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "The Lucero pump from Nine West may just leave him at a loss for words. This flirty pump has a leather upper, a pretty almond-shaped toe with a slight V-cut vamp, leather linings, and a cushioned insole for long-wearing comfort. The stiletto heel radiates a subtle hint of sensuality, so sass up your jean and t-shirt look or nighttime attire with this hot pump and you'll be absolutely unforgettable.",
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'The perfect pump will suit any ensemble. Leather upper. 3-3/4 inch stacked heel. Man-made sole. Imported. ',
                                                           'is_recurring': None,
                                                           'manufacturer': '105',
                                                           'meta_description': "Nine West Women's Lucero Pump",
                                                           'meta_keyword': "Nine West Women's Lucero Pump ",
                                                           'meta_title': "Nine West Women's Lucero Pump",
                                                           'minimal_price': '89.9900',
                                                           'model': 'B000LJQVF8',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': "Nine West Women's Lucero Pump",
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '89.9900',
                                                           'product_id': '32',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '46',
                                                           'shoe_type': '51',
                                                           'short_description': 'The Lucero pump from Nine West may just leave him at a loss for words. This flirty pump has a leather upper, a pretty almond-shaped toe with a slight V-cut vamp',
                                                           'sku': 'nine_3',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-07-31 18:06:25',
                                                           'url_key': 'nine-west-women-s-lucero-pump-3',
                                                           'url_path': 'nine-west-women-s-lucero-pump-3.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (32, u'2', None, 'id')): {'categories': ['17'],
                                                           'color': '26',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:12:54',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "The Lucero pump from Nine West may just leave him at a loss for words. This flirty pump has a leather upper, a pretty almond-shaped toe with a slight V-cut vamp, leather linings, and a cushioned insole for long-wearing comfort. The stiletto heel radiates a subtle hint of sensuality, so sass up your jean and t-shirt look or nighttime attire with this hot pump and you'll be absolutely unforgettable.",
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'The perfect pump will suit any ensemble. Leather upper. 3-3/4 inch stacked heel. Man-made sole. Imported. ',
                                                           'is_recurring': None,
                                                           'manufacturer': '105',
                                                           'meta_description': "Nine West Women's Lucero Pump",
                                                           'meta_keyword': "Nine West Women's Lucero Pump ",
                                                           'meta_title': "Nine West Women's Lucero Pump",
                                                           'minimal_price': '89.9900',
                                                           'model': 'B000LJQVF8',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': "Nine West Women's Lucero Pump",
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '89.9900',
                                                           'product_id': '32',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '46',
                                                           'shoe_type': '51',
                                                           'short_description': 'The Lucero pump from Nine West may just leave him at a loss for words. This flirty pump has a leather upper, a pretty almond-shaped toe with a slight V-cut vamp',
                                                           'sku': 'nine_3',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-07-31 18:06:25',
                                                           'url_key': 'nine-west-women-s-lucero-pump-3',
                                                           'url_path': 'nine-west-women-s-lucero-pump-3.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (32, u'3', None, 'id')): {'categories': ['17'],
                                                           'color': '26',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:12:54',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "The Lucero pump from Nine West may just leave him at a loss for words. This flirty pump has a leather upper, a pretty almond-shaped toe with a slight V-cut vamp, leather linings, and a cushioned insole for long-wearing comfort. The stiletto heel radiates a subtle hint of sensuality, so sass up your jean and t-shirt look or nighttime attire with this hot pump and you'll be absolutely unforgettable.",
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'The perfect pump will suit any ensemble. Leather upper. 3-3/4 inch stacked heel. Man-made sole. Imported. ',
                                                           'is_recurring': None,
                                                           'manufacturer': '105',
                                                           'meta_description': "Nine West Women's Lucero Pump",
                                                           'meta_keyword': "Nine West Women's Lucero Pump ",
                                                           'meta_title': "Nine West Women's Lucero Pump",
                                                           'minimal_price': '89.9900',
                                                           'model': 'B000LJQVF8',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': "Nine West Women's Lucero Pump",
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '89.9900',
                                                           'product_id': '32',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '46',
                                                           'shoe_type': '51',
                                                           'short_description': 'The Lucero pump from Nine West may just leave him at a loss for words. This flirty pump has a leather upper, a pretty almond-shaped toe with a slight V-cut vamp',
                                                           'sku': 'nine_3',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-07-31 18:06:25',
                                                           'url_key': 'nine-west-women-s-lucero-pump-3',
                                                           'url_path': 'nine-west-women-s-lucero-pump-3.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (33, None, None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:21:42',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "Featuring a wide toe box and delivering optimum support, the sporty Golf Flexor golf shoe is a stylish cleat that you'll love wearing on and off the links. The contrasting embossed snakeskin panels attract interest, while the laid back lace-up style keeps things simple. And thanks to the one-year waterproof guarantee, you can trust these shoes to keep you in the game, even when conditions are less than perfect.",
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': "Featuring a wide toe box and delivering optimum support, the sporty Golf Flexor golf shoe is a stylish cleat that you'll love wearing on and off the links. The contrasting embossed snakeskin panels attract interest, while the laid back lace-up style keeps things simple. And thanks to the one-year waterproof guarantee, you can trust these shoes to keep you in the game, even when conditions are less than perfect.",
                                                           'is_recurring': None,
                                                           'manufacturer': '104',
                                                           'meta_description': 'ECCO Womens Golf Flexor Golf Shoe',
                                                           'meta_keyword': 'ECCO Womens Golf Flexor Golf Shoe',
                                                           'meta_title': 'ECCO Womens Golf Flexor Golf Shoe',
                                                           'minimal_price': '159.9900',
                                                           'model': 'B000NPOA1M',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'ECCO Womens Golf Flexor Golf Shoe',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '159.9900',
                                                           'product_id': '33',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '46',
                                                           'shoe_type': '47',
                                                           'short_description': "Featuring a wide toe box and delivering optimum support, the sporty Golf Flexor golf shoe is a stylish cleat that you'll love wearing on and off the links.",
                                                           'sku': 'ecco_3',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:04:49',
                                                           'url_key': 'ecco-womens-golf-flexor-golf-shoe-3',
                                                           'url_path': 'ecco-womens-golf-flexor-golf-shoe-3.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '4.0000'},
        ('ol_catalog_product.info', (33, u'2', None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:21:42',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "Featuring a wide toe box and delivering optimum support, the sporty Golf Flexor golf shoe is a stylish cleat that you'll love wearing on and off the links. The contrasting embossed snakeskin panels attract interest, while the laid back lace-up style keeps things simple. And thanks to the one-year waterproof guarantee, you can trust these shoes to keep you in the game, even when conditions are less than perfect.",
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': "Featuring a wide toe box and delivering optimum support, the sporty Golf Flexor golf shoe is a stylish cleat that you'll love wearing on and off the links. The contrasting embossed snakeskin panels attract interest, while the laid back lace-up style keeps things simple. And thanks to the one-year waterproof guarantee, you can trust these shoes to keep you in the game, even when conditions are less than perfect.",
                                                           'is_recurring': None,
                                                           'manufacturer': '104',
                                                           'meta_description': 'ECCO Womens Golf Flexor Golf Shoe',
                                                           'meta_keyword': 'ECCO Womens Golf Flexor Golf Shoe',
                                                           'meta_title': 'ECCO Womens Golf Flexor Golf Shoe',
                                                           'minimal_price': '159.9900',
                                                           'model': 'B000NPOA1M',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'ECCO Womens Golf Flexor Golf Shoe',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '159.9900',
                                                           'product_id': '33',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '46',
                                                           'shoe_type': '47',
                                                           'short_description': "Featuring a wide toe box and delivering optimum support, the sporty Golf Flexor golf shoe is a stylish cleat that you'll love wearing on and off the links.",
                                                           'sku': 'ecco_3',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:04:49',
                                                           'url_key': 'ecco-womens-golf-flexor-golf-shoe-3',
                                                           'url_path': 'ecco-womens-golf-flexor-golf-shoe-3.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '4.0000'},
        ('ol_catalog_product.info', (33, u'3', None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:21:42',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "Featuring a wide toe box and delivering optimum support, the sporty Golf Flexor golf shoe is a stylish cleat that you'll love wearing on and off the links. The contrasting embossed snakeskin panels attract interest, while the laid back lace-up style keeps things simple. And thanks to the one-year waterproof guarantee, you can trust these shoes to keep you in the game, even when conditions are less than perfect.",
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': "Featuring a wide toe box and delivering optimum support, the sporty Golf Flexor golf shoe is a stylish cleat that you'll love wearing on and off the links. The contrasting embossed snakeskin panels attract interest, while the laid back lace-up style keeps things simple. And thanks to the one-year waterproof guarantee, you can trust these shoes to keep you in the game, even when conditions are less than perfect.",
                                                           'is_recurring': None,
                                                           'manufacturer': '104',
                                                           'meta_description': 'ECCO Womens Golf Flexor Golf Shoe',
                                                           'meta_keyword': 'ECCO Womens Golf Flexor Golf Shoe',
                                                           'meta_title': 'ECCO Womens Golf Flexor Golf Shoe',
                                                           'minimal_price': '159.9900',
                                                           'model': 'B000NPOA1M',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'ECCO Womens Golf Flexor Golf Shoe',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '159.9900',
                                                           'product_id': '33',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '46',
                                                           'shoe_type': '47',
                                                           'short_description': "Featuring a wide toe box and delivering optimum support, the sporty Golf Flexor golf shoe is a stylish cleat that you'll love wearing on and off the links.",
                                                           'sku': 'ecco_3',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:04:49',
                                                           'url_key': 'ecco-womens-golf-flexor-golf-shoe-3',
                                                           'url_path': 'ecco-womens-golf-flexor-golf-shoe-3.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '4.0000'},
        ('ol_catalog_product.info', (34, None, None, 'id')): {'categories': ['16'],
                                                           'color': '24',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:27:04',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'High fashion and classic good looks converge in this suave slip on from Kenneth Cole. Smooth leather upper in a dress slip on style, with a stitched and covered seam moc-inspired square toe, quarter panel curved overlays and flared tongue with side elastic panels for a comfortable, secure fit. Smooth leather lining, cushioned leather topped insole. Dress midsole with a beveled edge, 1 inch capped dress heel. Flat traction outsole.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'The handsome style of the Con-Verge slip-on from Kenneth Cole New York is larger than life. This sharp shoe has a semi-polished smooth leather upper, a squared off stitched apron toe, and dual-goring for easy on/off accessibility. It also features soft leather linings, a cushioned insole, and a paneled rubber outsole for a sturdy step. The Con-Verge is a perfect companion to your business and special occasion wardrobes.',
                                                           'is_recurring': None,
                                                           'manufacturer': '103',
                                                           'meta_description': "Kenneth Cole New York Men's Con-verge Slip-on",
                                                           'meta_keyword': "Kenneth Cole New York Men's Con-verge Slip-on",
                                                           'meta_title': "Kenneth Cole New York Men's Con-verge Slip-on",
                                                           'minimal_price': '160.9900',
                                                           'model': 'B000IKC6AY',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': "Kenneth Cole New York Men's Con-verge Slip-on",
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '160.9900',
                                                           'product_id': '34',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '41',
                                                           'shoe_type': '52',
                                                           'short_description': 'High fashion and classic good looks converge in this suave slip on from Kenneth Cole. Smooth leather upper in a dress slip on style, with a stitched and covered seam moc-inspired square toe, quarter panel curved overlays and flared tongue',
                                                           'sku': 'ken_8',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:58:35',
                                                           'url_key': 'kenneth-cole-new-york-men-s-con-verge-slip-on-8',
                                                           'url_path': 'kenneth-cole-new-york-men-s-con-verge-slip-on-8.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (34, u'2', None, 'id')): {'categories': ['16'],
                                                           'color': '24',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:27:04',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'High fashion and classic good looks converge in this suave slip on from Kenneth Cole. Smooth leather upper in a dress slip on style, with a stitched and covered seam moc-inspired square toe, quarter panel curved overlays and flared tongue with side elastic panels for a comfortable, secure fit. Smooth leather lining, cushioned leather topped insole. Dress midsole with a beveled edge, 1 inch capped dress heel. Flat traction outsole.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'The handsome style of the Con-Verge slip-on from Kenneth Cole New York is larger than life. This sharp shoe has a semi-polished smooth leather upper, a squared off stitched apron toe, and dual-goring for easy on/off accessibility. It also features soft leather linings, a cushioned insole, and a paneled rubber outsole for a sturdy step. The Con-Verge is a perfect companion to your business and special occasion wardrobes.',
                                                           'is_recurring': None,
                                                           'manufacturer': '103',
                                                           'meta_description': "Kenneth Cole New York Men's Con-verge Slip-on",
                                                           'meta_keyword': "Kenneth Cole New York Men's Con-verge Slip-on",
                                                           'meta_title': "Kenneth Cole New York Men's Con-verge Slip-on",
                                                           'minimal_price': '160.9900',
                                                           'model': 'B000IKC6AY',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': "Kenneth Cole New York Men's Con-verge Slip-on",
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '160.9900',
                                                           'product_id': '34',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '41',
                                                           'shoe_type': '52',
                                                           'short_description': 'High fashion and classic good looks converge in this suave slip on from Kenneth Cole. Smooth leather upper in a dress slip on style, with a stitched and covered seam moc-inspired square toe, quarter panel curved overlays and flared tongue',
                                                           'sku': 'ken_8',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:58:35',
                                                           'url_key': 'kenneth-cole-new-york-men-s-con-verge-slip-on-8',
                                                           'url_path': 'kenneth-cole-new-york-men-s-con-verge-slip-on-8.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (34, u'3', None, 'id')): {'categories': ['16'],
                                                           'color': '24',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:27:04',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'High fashion and classic good looks converge in this suave slip on from Kenneth Cole. Smooth leather upper in a dress slip on style, with a stitched and covered seam moc-inspired square toe, quarter panel curved overlays and flared tongue with side elastic panels for a comfortable, secure fit. Smooth leather lining, cushioned leather topped insole. Dress midsole with a beveled edge, 1 inch capped dress heel. Flat traction outsole.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'The handsome style of the Con-Verge slip-on from Kenneth Cole New York is larger than life. This sharp shoe has a semi-polished smooth leather upper, a squared off stitched apron toe, and dual-goring for easy on/off accessibility. It also features soft leather linings, a cushioned insole, and a paneled rubber outsole for a sturdy step. The Con-Verge is a perfect companion to your business and special occasion wardrobes.',
                                                           'is_recurring': None,
                                                           'manufacturer': '103',
                                                           'meta_description': "Kenneth Cole New York Men's Con-verge Slip-on",
                                                           'meta_keyword': "Kenneth Cole New York Men's Con-verge Slip-on",
                                                           'meta_title': "Kenneth Cole New York Men's Con-verge Slip-on",
                                                           'minimal_price': '160.9900',
                                                           'model': 'B000IKC6AY',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': "Kenneth Cole New York Men's Con-verge Slip-on",
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '160.9900',
                                                           'product_id': '34',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '41',
                                                           'shoe_type': '52',
                                                           'short_description': 'High fashion and classic good looks converge in this suave slip on from Kenneth Cole. Smooth leather upper in a dress slip on style, with a stitched and covered seam moc-inspired square toe, quarter panel curved overlays and flared tongue',
                                                           'sku': 'ken_8',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:58:35',
                                                           'url_key': 'kenneth-cole-new-york-men-s-con-verge-slip-on-8',
                                                           'url_path': 'kenneth-cole-new-york-men-s-con-verge-slip-on-8.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (35, None, None, 'id')): {'categories': ['4'],
                                                           'color': '22',
                                                           'cost': '2.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:49:30',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': '# 6.1 oz. 100% preshrunk heavyweight cotton \r\n# Shoulder-to-shoulder taping\r\n# Double-needle sleeves and bottom hem',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Coalesce: Functioning On Impatience T-Shirt',
                                                           'meta_keyword': 'Coalesce: Functioning On Impatience T-Shirt',
                                                           'meta_title': 'Coalesce: Functioning On Impatience T-Shirt',
                                                           'minimal_price': '15.0000',
                                                           'model': 'Impatience',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Coalesce: Functioning On Impatience T-Shirt',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.0000',
                                                           'product_id': '35',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '41',
                                                           'shirt_size': '100',
                                                           'short_description': '# 6.1 oz. 100% preshrunk heavyweight cotton \r\n# Shoulder-to-shoulder taping\r\n# Double-needle sleeves and bottom hem',
                                                           'sku': 'coal_sm',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-07-31 17:36:42',
                                                           'url_key': 'coalesce-functioning-on-impatience-t-shirt-small',
                                                           'url_path': 'coalesce-functioning-on-impatience-t-shirt-small.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '0.5000'},
        ('ol_catalog_product.info', (35, u'2', None, 'id')): {'categories': ['4'],
                                                           'color': '22',
                                                           'cost': '2.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:49:30',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': '# 6.1 oz. 100% preshrunk heavyweight cotton \r\n# Shoulder-to-shoulder taping\r\n# Double-needle sleeves and bottom hem',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Coalesce: Functioning On Impatience T-Shirt',
                                                           'meta_keyword': 'Coalesce: Functioning On Impatience T-Shirt',
                                                           'meta_title': 'Coalesce: Functioning On Impatience T-Shirt',
                                                           'minimal_price': '15.0000',
                                                           'model': 'Impatience',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Coalesce: Functioning On Impatience T-Shirt',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.0000',
                                                           'product_id': '35',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '41',
                                                           'shirt_size': '100',
                                                           'short_description': '# 6.1 oz. 100% preshrunk heavyweight cotton \r\n# Shoulder-to-shoulder taping\r\n# Double-needle sleeves and bottom hem',
                                                           'sku': 'coal_sm',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-07-31 17:36:42',
                                                           'url_key': 'coalesce-functioning-on-impatience-t-shirt-small',
                                                           'url_path': 'coalesce-functioning-on-impatience-t-shirt-small.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '0.5000'},
        ('ol_catalog_product.info', (35, u'3', None, 'id')): {'categories': ['4'],
                                                           'color': '22',
                                                           'cost': '2.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:49:30',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': '# 6.1 oz. 100% preshrunk heavyweight cotton \r\n# Shoulder-to-shoulder taping\r\n# Double-needle sleeves and bottom hem',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Coalesce: Functioning On Impatience T-Shirt',
                                                           'meta_keyword': 'Coalesce: Functioning On Impatience T-Shirt',
                                                           'meta_title': 'Coalesce: Functioning On Impatience T-Shirt',
                                                           'minimal_price': '15.0000',
                                                           'model': 'Impatience',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Coalesce: Functioning On Impatience T-Shirt',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.0000',
                                                           'product_id': '35',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '41',
                                                           'shirt_size': '100',
                                                           'short_description': '# 6.1 oz. 100% preshrunk heavyweight cotton \r\n# Shoulder-to-shoulder taping\r\n# Double-needle sleeves and bottom hem',
                                                           'sku': 'coal_sm',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-07-31 17:36:42',
                                                           'url_key': 'coalesce-functioning-on-impatience-t-shirt-small',
                                                           'url_path': 'coalesce-functioning-on-impatience-t-shirt-small.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '0.5000'},
        ('ol_catalog_product.info', (36, None, None, 'id')): {'categories': ['4'],
                                                           'color': '60',
                                                           'cost': '2.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:53:06',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "We bought these with the intention of making shirts for our family reunion, only to come back the next day to find each and every one of them had been tagged by The Bear.  Oh well -- can't argue with art.  Now you can make your grandparents proud by wearing an original piece of graf work to YOUR family reunion!",
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Ink Eater: Krylon Bombear Destroyed Tee',
                                                           'meta_keyword': 'Ink Eater: Krylon Bombear Destroyed Tee',
                                                           'meta_title': 'Ink Eater: Krylon Bombear Destroyed Tee',
                                                           'minimal_price': '22.0000',
                                                           'model': 'Ink Eater:',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Ink Eater: Krylon Bombear Destroyed Tee',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '22.0000',
                                                           'product_id': '36',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '41',
                                                           'shirt_size': '100',
                                                           'short_description': "We bought these with the intention of making shirts for our family reunion, only to come back the next day to find each and every one of them had been tagged by The Bear.  Oh well -- can't argue with art.  Now you can make your grandparents proud by wearing an original piece of graf work to YOUR family reunion!",
                                                           'sku': 'ink_sm',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:49:48',
                                                           'url_key': 'ink-eater-krylon-bombear-destroyed-tee-sm',
                                                           'url_path': 'ink-eater-krylon-bombear-destroyed-tee-sm.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '0.5000'},
        ('ol_catalog_product.info', (36, u'2', None, 'id')): {'categories': ['4'],
                                                           'color': '60',
                                                           'cost': '2.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:53:06',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "We bought these with the intention of making shirts for our family reunion, only to come back the next day to find each and every one of them had been tagged by The Bear.  Oh well -- can't argue with art.  Now you can make your grandparents proud by wearing an original piece of graf work to YOUR family reunion!",
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Ink Eater: Krylon Bombear Destroyed Tee',
                                                           'meta_keyword': 'Ink Eater: Krylon Bombear Destroyed Tee',
                                                           'meta_title': 'Ink Eater: Krylon Bombear Destroyed Tee',
                                                           'minimal_price': '22.0000',
                                                           'model': 'Ink Eater:',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Ink Eater: Krylon Bombear Destroyed Tee',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '22.0000',
                                                           'product_id': '36',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '41',
                                                           'shirt_size': '100',
                                                           'short_description': "We bought these with the intention of making shirts for our family reunion, only to come back the next day to find each and every one of them had been tagged by The Bear.  Oh well -- can't argue with art.  Now you can make your grandparents proud by wearing an original piece of graf work to YOUR family reunion!",
                                                           'sku': 'ink_sm',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:49:48',
                                                           'url_key': 'ink-eater-krylon-bombear-destroyed-tee-sm',
                                                           'url_path': 'ink-eater-krylon-bombear-destroyed-tee-sm.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '0.5000'},
        ('ol_catalog_product.info', (36, u'3', None, 'id')): {'categories': ['4'],
                                                           'color': '60',
                                                           'cost': '2.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:53:06',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "We bought these with the intention of making shirts for our family reunion, only to come back the next day to find each and every one of them had been tagged by The Bear.  Oh well -- can't argue with art.  Now you can make your grandparents proud by wearing an original piece of graf work to YOUR family reunion!",
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Ink Eater: Krylon Bombear Destroyed Tee',
                                                           'meta_keyword': 'Ink Eater: Krylon Bombear Destroyed Tee',
                                                           'meta_title': 'Ink Eater: Krylon Bombear Destroyed Tee',
                                                           'minimal_price': '22.0000',
                                                           'model': 'Ink Eater:',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Ink Eater: Krylon Bombear Destroyed Tee',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '22.0000',
                                                           'product_id': '36',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '41',
                                                           'shirt_size': '100',
                                                           'short_description': "We bought these with the intention of making shirts for our family reunion, only to come back the next day to find each and every one of them had been tagged by The Bear.  Oh well -- can't argue with art.  Now you can make your grandparents proud by wearing an original piece of graf work to YOUR family reunion!",
                                                           'sku': 'ink_sm',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:49:48',
                                                           'url_key': 'ink-eater-krylon-bombear-destroyed-tee-sm',
                                                           'url_path': 'ink-eater-krylon-bombear-destroyed-tee-sm.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '0.5000'},
        ('ol_catalog_product.info', (37, None, None, 'id')): {'categories': ['4'],
                                                           'color': '60',
                                                           'cost': '2.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:59:39',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': '# 6.1 oz. 100% preshrunk heavyweight cotton \r\n# Double-needle sleeves and bottom hem',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'The Only Children: Paisley T-Shirt',
                                                           'meta_keyword': 'The Only Children: Paisley T-Shirt',
                                                           'meta_title': 'The Only Children: Paisley T-Shirt',
                                                           'minimal_price': '15.0000',
                                                           'model': 'The Only Children: Paisley T-Shirt',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'The Only Children: Paisley T-Shirt',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.0000',
                                                           'product_id': '37',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '41',
                                                           'shirt_size': '100',
                                                           'short_description': 'Printed on American Apparel Classic style 5495 California cotton T shirst.   ',
                                                           'sku': 'oc_sm',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:47:47',
                                                           'url_key': 'the-only-children-paisley-t-shirt-sm',
                                                           'url_path': 'the-only-children-paisley-t-shirt-sm.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '0.4400'},
        ('ol_catalog_product.info', (37, u'2', None, 'id')): {'categories': ['4'],
                                                           'color': '60',
                                                           'cost': '2.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:59:39',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': '# 6.1 oz. 100% preshrunk heavyweight cotton \r\n# Double-needle sleeves and bottom hem',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'The Only Children: Paisley T-Shirt',
                                                           'meta_keyword': 'The Only Children: Paisley T-Shirt',
                                                           'meta_title': 'The Only Children: Paisley T-Shirt',
                                                           'minimal_price': '15.0000',
                                                           'model': 'The Only Children: Paisley T-Shirt',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'The Only Children: Paisley T-Shirt',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.0000',
                                                           'product_id': '37',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '41',
                                                           'shirt_size': '100',
                                                           'short_description': 'Printed on American Apparel Classic style 5495 California cotton T shirst.   ',
                                                           'sku': 'oc_sm',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:47:47',
                                                           'url_key': 'the-only-children-paisley-t-shirt-sm',
                                                           'url_path': 'the-only-children-paisley-t-shirt-sm.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '0.4400'},
        ('ol_catalog_product.info', (37, u'3', None, 'id')): {'categories': ['4'],
                                                           'color': '60',
                                                           'cost': '2.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 19:59:39',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': '# 6.1 oz. 100% preshrunk heavyweight cotton \r\n# Double-needle sleeves and bottom hem',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'The Only Children: Paisley T-Shirt',
                                                           'meta_keyword': 'The Only Children: Paisley T-Shirt',
                                                           'meta_title': 'The Only Children: Paisley T-Shirt',
                                                           'minimal_price': '15.0000',
                                                           'model': 'The Only Children: Paisley T-Shirt',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'The Only Children: Paisley T-Shirt',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.0000',
                                                           'product_id': '37',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '41',
                                                           'shirt_size': '100',
                                                           'short_description': 'Printed on American Apparel Classic style 5495 California cotton T shirst.   ',
                                                           'sku': 'oc_sm',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:47:47',
                                                           'url_key': 'the-only-children-paisley-t-shirt-sm',
                                                           'url_path': 'the-only-children-paisley-t-shirt-sm.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '0.4400'},
        ('ol_catalog_product.info', (38, None, None, 'id')): {'categories': ['4'],
                                                           'color': '26',
                                                           'cost': '2.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 20:02:08',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': '# 6.1 oz. 100% preshrunk heavyweight cotton \r\n# Shoulder-to-shoulder taping\r\n# Double-needle sleeves and bottom hem',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Zolof The Rock And Roll Destroyer: LOL Cat T-shirt',
                                                           'meta_keyword': 'Zolof The Rock And Roll Destroyer: LOL Cat T-shirt',
                                                           'meta_title': 'Zolof The Rock And Roll Destroyer: LOL Cat T-shirt',
                                                           'minimal_price': '13.5000',
                                                           'model': 'Zolof The Rock And Roll Destroyer: LOL Cat T-shirt',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Zolof The Rock And Roll Destroyer: LOL Cat T-shirt',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '13.5000',
                                                           'product_id': '38',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '41',
                                                           'shirt_size': '100',
                                                           'short_description': 'Printed on American Apparel Classic style 5495 California t-shirts.  ',
                                                           'sku': 'zol_r_sm',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:39:57',
                                                           'url_key': 'zolof-the-rock-and-roll-destroyer-lol-cat-t-shirt-r-sm',
                                                           'url_path': 'zolof-the-rock-and-roll-destroyer-lol-cat-t-shirt-r-sm.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '0.4400'},
        ('ol_catalog_product.info', (38, u'2', None, 'id')): {'categories': ['4'],
                                                           'color': '26',
                                                           'cost': '2.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 20:02:08',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': '# 6.1 oz. 100% preshrunk heavyweight cotton \r\n# Shoulder-to-shoulder taping\r\n# Double-needle sleeves and bottom hem',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Zolof The Rock And Roll Destroyer: LOL Cat T-shirt',
                                                           'meta_keyword': 'Zolof The Rock And Roll Destroyer: LOL Cat T-shirt',
                                                           'meta_title': 'Zolof The Rock And Roll Destroyer: LOL Cat T-shirt',
                                                           'minimal_price': '13.5000',
                                                           'model': 'Zolof The Rock And Roll Destroyer: LOL Cat T-shirt',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Zolof The Rock And Roll Destroyer: LOL Cat T-shirt',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '13.5000',
                                                           'product_id': '38',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '41',
                                                           'shirt_size': '100',
                                                           'short_description': 'Printed on American Apparel Classic style 5495 California t-shirts.  ',
                                                           'sku': 'zol_r_sm',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:39:57',
                                                           'url_key': 'zolof-the-rock-and-roll-destroyer-lol-cat-t-shirt-r-sm',
                                                           'url_path': 'zolof-the-rock-and-roll-destroyer-lol-cat-t-shirt-r-sm.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '0.4400'},
        ('ol_catalog_product.info', (38, u'3', None, 'id')): {'categories': ['4'],
                                                           'color': '26',
                                                           'cost': '2.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 20:02:08',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': '# 6.1 oz. 100% preshrunk heavyweight cotton \r\n# Shoulder-to-shoulder taping\r\n# Double-needle sleeves and bottom hem',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Zolof The Rock And Roll Destroyer: LOL Cat T-shirt',
                                                           'meta_keyword': 'Zolof The Rock And Roll Destroyer: LOL Cat T-shirt',
                                                           'meta_title': 'Zolof The Rock And Roll Destroyer: LOL Cat T-shirt',
                                                           'minimal_price': '13.5000',
                                                           'model': 'Zolof The Rock And Roll Destroyer: LOL Cat T-shirt',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Zolof The Rock And Roll Destroyer: LOL Cat T-shirt',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '13.5000',
                                                           'product_id': '38',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '41',
                                                           'shirt_size': '100',
                                                           'short_description': 'Printed on American Apparel Classic style 5495 California t-shirts.  ',
                                                           'sku': 'zol_r_sm',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:39:57',
                                                           'url_key': 'zolof-the-rock-and-roll-destroyer-lol-cat-t-shirt-r-sm',
                                                           'url_path': 'zolof-the-rock-and-roll-destroyer-lol-cat-t-shirt-r-sm.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '0.4400'},
        ('ol_catalog_product.info', (39, None, None, 'id')): {'categories': ['19'],
                                                           'color': '22',
                                                           'cost': '5.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 20:07:02',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Printed on American Apparel Classic style 5495 California Fleece Pull-Over Hoodies.  Sizing info is available here. ',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'The Get Up Kids: Band Camp Pullover Hoodie',
                                                           'meta_keyword': 'The Get Up Kids: Band Camp Pullover Hoodie',
                                                           'meta_title': 'The Get Up Kids: Band Camp Pullover Hoodie',
                                                           'minimal_price': None,
                                                           'model': 'The Get Up Kids: Band Camp Pullover Hoodie',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'The Get Up Kids: Band Camp Pullover Hoodie',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '30.0000',
                                                           'product_id': '39',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '41',
                                                           'shirt_size': '99',
                                                           'short_description': 'Printed on American Apparel Classic style 5495 California Fleece Pull-Over Hoodies.  ',
                                                           'sku': '4fasd5f5',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-06-24 23:45:44',
                                                           'url_key': 'the-get-up-kids-band-camp-pullover-hoodie',
                                                           'url_path': 'the-get-up-kids-band-camp-pullover-hoodie.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '1.7500'},
        ('ol_catalog_product.info', (39, u'2', None, 'id')): {'categories': ['19'],
                                                           'color': '22',
                                                           'cost': '5.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 20:07:02',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Printed on American Apparel Classic style 5495 California Fleece Pull-Over Hoodies.  Sizing info is available here. ',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'The Get Up Kids: Band Camp Pullover Hoodie',
                                                           'meta_keyword': 'The Get Up Kids: Band Camp Pullover Hoodie',
                                                           'meta_title': 'The Get Up Kids: Band Camp Pullover Hoodie',
                                                           'minimal_price': None,
                                                           'model': 'The Get Up Kids: Band Camp Pullover Hoodie',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'The Get Up Kids: Band Camp Pullover Hoodie',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '30.0000',
                                                           'product_id': '39',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '41',
                                                           'shirt_size': '99',
                                                           'short_description': 'Printed on American Apparel Classic style 5495 California Fleece Pull-Over Hoodies.  ',
                                                           'sku': '4fasd5f5',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-06-24 23:45:44',
                                                           'url_key': 'the-get-up-kids-band-camp-pullover-hoodie',
                                                           'url_path': 'the-get-up-kids-band-camp-pullover-hoodie.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '1.7500'},
        ('ol_catalog_product.info', (39, u'3', None, 'id')): {'categories': ['19'],
                                                           'color': '22',
                                                           'cost': '5.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 20:07:02',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Printed on American Apparel Classic style 5495 California Fleece Pull-Over Hoodies.  Sizing info is available here. ',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'The Get Up Kids: Band Camp Pullover Hoodie',
                                                           'meta_keyword': 'The Get Up Kids: Band Camp Pullover Hoodie',
                                                           'meta_title': 'The Get Up Kids: Band Camp Pullover Hoodie',
                                                           'minimal_price': None,
                                                           'model': 'The Get Up Kids: Band Camp Pullover Hoodie',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'The Get Up Kids: Band Camp Pullover Hoodie',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '30.0000',
                                                           'product_id': '39',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '41',
                                                           'shirt_size': '99',
                                                           'short_description': 'Printed on American Apparel Classic style 5495 California Fleece Pull-Over Hoodies.  ',
                                                           'sku': '4fasd5f5',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-06-24 23:45:44',
                                                           'url_key': 'the-get-up-kids-band-camp-pullover-hoodie',
                                                           'url_path': 'the-get-up-kids-band-camp-pullover-hoodie.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '1.7500'},
        ('ol_catalog_product.info', (41, None, None, 'id')): {'categories': ['23'],
                                                           'color': '59',
                                                           'cost': '100.0000',
                                                           'country_of_manufacture': None,
                                                           'country_orgin': 'Thailand',
                                                           'created_at': '2007-08-27 10:43:59',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Features include inset panel sides and for spacious drawers and two wicker baskets. 41"Wx18"Dx36"H.',
                                                           'dimension': '21"W x 44"L x 35.5"H',
                                                           'enable_googlecheckout': None,
                                                           'finish': 'Asian Beechwood',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Our Akio dresser has a solid hardwood frame.  Features include inset panel sides and for spacious drawers and two wicker baskets.',
                                                           'meta_keyword': 'Hardwood, drawers, wicker, asian, beechwood',
                                                           'meta_title': 'Akio Dresser',
                                                           'minimal_price': '399.9900',
                                                           'model': '384822',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Akio Dresser',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '399.9900',
                                                           'product_id': '41',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'room': '71',
                                                           'set': '42',
                                                           'short_description': 'Our Akio dresser has a solid hardwood frame.  ',
                                                           'sku': '384822',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-07-29 22:28:43',
                                                           'url_key': 'akio-dresser',
                                                           'url_path': 'akio-dresser.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '128.9700'},
        ('ol_catalog_product.info', (41, u'2', None, 'id')): {'categories': ['23'],
                                                           'color': '59',
                                                           'cost': '100.0000',
                                                           'country_of_manufacture': None,
                                                           'country_orgin': 'Thailand',
                                                           'created_at': '2007-08-27 10:43:59',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Features include inset panel sides and for spacious drawers and two wicker baskets. 41"Wx18"Dx36"H.',
                                                           'dimension': '21"W x 44"L x 35.5"H',
                                                           'enable_googlecheckout': None,
                                                           'finish': 'Asian Beechwood',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Our Akio dresser has a solid hardwood frame.  Features include inset panel sides and for spacious drawers and two wicker baskets.',
                                                           'meta_keyword': 'Hardwood, drawers, wicker, asian, beechwood',
                                                           'meta_title': 'Akio Dresser',
                                                           'minimal_price': '399.9900',
                                                           'model': '384822',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Akio Dresser',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '399.9900',
                                                           'product_id': '41',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'room': '71',
                                                           'set': '42',
                                                           'short_description': 'Our Akio dresser has a solid hardwood frame.  ',
                                                           'sku': '384822',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-07-29 22:28:43',
                                                           'url_key': 'akio-dresser',
                                                           'url_path': 'akio-dresser.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '128.9700'},
        ('ol_catalog_product.info', (41, u'3', None, 'id')): {'categories': ['23'],
                                                           'color': '59',
                                                           'cost': '100.0000',
                                                           'country_of_manufacture': None,
                                                           'country_orgin': 'Thailand',
                                                           'created_at': '2007-08-27 10:43:59',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Features include inset panel sides and for spacious drawers and two wicker baskets. 41"Wx18"Dx36"H.',
                                                           'dimension': '21"W x 44"L x 35.5"H',
                                                           'enable_googlecheckout': None,
                                                           'finish': 'Asian Beechwood',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Our Akio dresser has a solid hardwood frame.  Features include inset panel sides and for spacious drawers and two wicker baskets.',
                                                           'meta_keyword': 'Hardwood, drawers, wicker, asian, beechwood',
                                                           'meta_title': 'Akio Dresser',
                                                           'minimal_price': '399.9900',
                                                           'model': '384822',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Akio Dresser',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '399.9900',
                                                           'product_id': '41',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'room': '71',
                                                           'set': '42',
                                                           'short_description': 'Our Akio dresser has a solid hardwood frame.  ',
                                                           'sku': '384822',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-07-29 22:28:43',
                                                           'url_key': 'akio-dresser',
                                                           'url_path': 'akio-dresser.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '128.9700'},
        ('ol_catalog_product.info', (42, None, None, 'id')): {'categories': ['23'],
                                                           'color': '59',
                                                           'cost': '800.0000',
                                                           'country_of_manufacture': None,
                                                           'country_orgin': 'Thailand',
                                                           'created_at': '2007-08-27 10:50:01',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Entirely handcrafted of solid Bamboo. Designed for use with a mattress alone, it includes a sturdy, padded wood platform for comfort and proper mattress support.',
                                                           'dimension': '62"W x 84"L x 8"H',
                                                           'enable_googlecheckout': None,
                                                           'finish': 'Bamboo',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Our Barcelona platform bed captures the spirit and drama of late 20th century design with a variety of subtle details.',
                                                           'meta_keyword': 'bamboo, barcelona, platform, bed',
                                                           'meta_title': 'Barcelona Bamboo Platform Bed',
                                                           'minimal_price': '2299.0000',
                                                           'model': 'bar1234',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Barcelona Bamboo Platform Bed',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '2299.0000',
                                                           'product_id': '42',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'room': '71',
                                                           'set': '42',
                                                           'short_description': 'Our Barcelona platform bed captures the spirit and drama of late 20th century design with a variety of subtle details.',
                                                           'sku': 'bar1234',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-06-24 23:59:46',
                                                           'url_key': 'barcelona-bamboo-platform-bed',
                                                           'url_path': 'barcelona-bamboo-platform-bed.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '150.0000'},
        ('ol_catalog_product.info', (42, u'2', None, 'id')): {'categories': ['23'],
                                                           'color': '59',
                                                           'cost': '800.0000',
                                                           'country_of_manufacture': None,
                                                           'country_orgin': 'Thailand',
                                                           'created_at': '2007-08-27 10:50:01',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Entirely handcrafted of solid Bamboo. Designed for use with a mattress alone, it includes a sturdy, padded wood platform for comfort and proper mattress support.',
                                                           'dimension': '62"W x 84"L x 8"H',
                                                           'enable_googlecheckout': None,
                                                           'finish': 'Bamboo',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Our Barcelona platform bed captures the spirit and drama of late 20th century design with a variety of subtle details.',
                                                           'meta_keyword': 'bamboo, barcelona, platform, bed',
                                                           'meta_title': 'Barcelona Bamboo Platform Bed',
                                                           'minimal_price': '2299.0000',
                                                           'model': 'bar1234',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Barcelona Bamboo Platform Bed',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '2299.0000',
                                                           'product_id': '42',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'room': '71',
                                                           'set': '42',
                                                           'short_description': 'Our Barcelona platform bed captures the spirit and drama of late 20th century design with a variety of subtle details.',
                                                           'sku': 'bar1234',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-06-24 23:59:46',
                                                           'url_key': 'barcelona-bamboo-platform-bed',
                                                           'url_path': 'barcelona-bamboo-platform-bed.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '150.0000'},
        ('ol_catalog_product.info', (42, u'3', None, 'id')): {'categories': ['23'],
                                                           'color': '59',
                                                           'cost': '800.0000',
                                                           'country_of_manufacture': None,
                                                           'country_orgin': 'Thailand',
                                                           'created_at': '2007-08-27 10:50:01',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Entirely handcrafted of solid Bamboo. Designed for use with a mattress alone, it includes a sturdy, padded wood platform for comfort and proper mattress support.',
                                                           'dimension': '62"W x 84"L x 8"H',
                                                           'enable_googlecheckout': None,
                                                           'finish': 'Bamboo',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Our Barcelona platform bed captures the spirit and drama of late 20th century design with a variety of subtle details.',
                                                           'meta_keyword': 'bamboo, barcelona, platform, bed',
                                                           'meta_title': 'Barcelona Bamboo Platform Bed',
                                                           'minimal_price': '2299.0000',
                                                           'model': 'bar1234',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Barcelona Bamboo Platform Bed',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '2299.0000',
                                                           'product_id': '42',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'room': '71',
                                                           'set': '42',
                                                           'short_description': 'Our Barcelona platform bed captures the spirit and drama of late 20th century design with a variety of subtle details.',
                                                           'sku': 'bar1234',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-06-24 23:59:46',
                                                           'url_key': 'barcelona-bamboo-platform-bed',
                                                           'url_path': 'barcelona-bamboo-platform-bed.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '150.0000'},
        ('ol_catalog_product.info', (44, None, None, 'id')): {'categories': ['26'],
                                                           'color': '24',
                                                           'cost': '200.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 13:06:05',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "The Canon EOS Digital Rebel camera now has a new, faster, even smaller big brother. Sibling rivalries aside, the 8.0-megapixel Canon EOS Digital Rebel XT SLR adds resolution, speed, extra creative control, and enhanced comfort in the hand to one of the smallest and lightest digital cameras in its class. Even with its advancements in ergonomic design and technology, this easy-to-use EOS digital camera is compatible with all of Canon's EF lenses, including the EF-S lenses.",
                                                           'dimension': '5 x 3.7 x 2.5 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc"> \r\n\r\n<li>8.0-megapixel CMOS sensor captures enough detail for photo-quality 16 x 22-inch prints<br></li>\r\n<li>Includes Canon\'s EF-S 18-55mm, f3.5-5.6 zoom lens<br></li>\r\n<li>DIGIC II Image Processor provides fast, accurate image processing; captures images at a rate of up to 3 frames per second<br></li>\r\n<li>Fast start-up time--.2 seconds<br></li>\r\n<li>Powered by rechargeable Lithium-ion battery (included, with charger)</li>\r\n</ul>\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '34',
                                                           'megapixels': '90',
                                                           'meta_description': 'Canon Digital Rebel XT 8MP Digital SLR Camera with EF-S 18-55mm f3.5-5.6 Lens (Black)',
                                                           'meta_keyword': 'canon, slr, camera, 8, digital',
                                                           'meta_title': 'Canon Digital Rebel XT 8MP Digital SLR Camera with EF-S 18-55mm f3.5-5.6 Lens (Black)',
                                                           'minimal_price': '449.0000',
                                                           'model': 'Rebel XT ',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Canon Digital Rebel XT 8MP Digital SLR Camera',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '550.0000',
                                                           'product_id': '44',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '44',
                                                           'short_description': ' Canon EOS Digital Rebel XT SLR adds resolution, speed, extra creative control, and enhanced comfort in the hand to one of the smallest and lightest digital cameras in its class. ',
                                                           'sku': 'Rebel XT',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [{'all_groups': '1',
                                                                           'cust_group': 32000,
                                                                           'price': '449.0000',
                                                                           'price_id': '1',
                                                                           'price_qty': '2.0000',
                                                                           'website_id': '0',
                                                                           'website_price': '449.0000'}],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-06-24 22:50:46',
                                                           'url_key': 'canon-digital-rebel-xt-8mp-digital-slr-camera-with-ef-s-18-55mm-f3-5-5-6-lens-black',
                                                           'url_path': 'canon-digital-rebel-xt-8mp-digital-slr-camera-with-ef-s-18-55mm-f3-5-5-6-lens-black.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '4.0000'},
        ('ol_catalog_product.info', (44, u'2', None, 'id')): {'categories': ['26'],
                                                           'color': '24',
                                                           'cost': '200.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 13:06:05',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "The Canon EOS Digital Rebel camera now has a new, faster, even smaller big brother. Sibling rivalries aside, the 8.0-megapixel Canon EOS Digital Rebel XT SLR adds resolution, speed, extra creative control, and enhanced comfort in the hand to one of the smallest and lightest digital cameras in its class. Even with its advancements in ergonomic design and technology, this easy-to-use EOS digital camera is compatible with all of Canon's EF lenses, including the EF-S lenses.",
                                                           'dimension': '5 x 3.7 x 2.5 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc"> \r\n\r\n<li>8.0-megapixel CMOS sensor captures enough detail for photo-quality 16 x 22-inch prints<br></li>\r\n<li>Includes Canon\'s EF-S 18-55mm, f3.5-5.6 zoom lens<br></li>\r\n<li>DIGIC II Image Processor provides fast, accurate image processing; captures images at a rate of up to 3 frames per second<br></li>\r\n<li>Fast start-up time--.2 seconds<br></li>\r\n<li>Powered by rechargeable Lithium-ion battery (included, with charger)</li>\r\n</ul>\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '34',
                                                           'megapixels': '90',
                                                           'meta_description': 'Canon Digital Rebel XT 8MP Digital SLR Camera with EF-S 18-55mm f3.5-5.6 Lens (Black)',
                                                           'meta_keyword': 'canon, slr, camera, 8, digital',
                                                           'meta_title': 'Canon Digital Rebel XT 8MP Digital SLR Camera with EF-S 18-55mm f3.5-5.6 Lens (Black)',
                                                           'minimal_price': '449.0000',
                                                           'model': 'Rebel XT ',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Canon Digital Rebel XT 8MP Digital SLR Camera',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '550.0000',
                                                           'product_id': '44',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '44',
                                                           'short_description': ' Canon EOS Digital Rebel XT SLR adds resolution, speed, extra creative control, and enhanced comfort in the hand to one of the smallest and lightest digital cameras in its class. ',
                                                           'sku': 'Rebel XT',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [{'all_groups': '1',
                                                                           'cust_group': 32000,
                                                                           'price': '449.0000',
                                                                           'price_id': '1',
                                                                           'price_qty': '2.0000',
                                                                           'website_id': '0',
                                                                           'website_price': '449.0000'}],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-06-24 22:50:46',
                                                           'url_key': 'canon-digital-rebel-xt-8mp-digital-slr-camera-with-ef-s-18-55mm-f3-5-5-6-lens-black',
                                                           'url_path': 'canon-digital-rebel-xt-8mp-digital-slr-camera-with-ef-s-18-55mm-f3-5-5-6-lens-black.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '4.0000'},
        ('ol_catalog_product.info', (44, u'3', None, 'id')): {'categories': ['26'],
                                                           'color': '24',
                                                           'cost': '200.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 13:06:05',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "The Canon EOS Digital Rebel camera now has a new, faster, even smaller big brother. Sibling rivalries aside, the 8.0-megapixel Canon EOS Digital Rebel XT SLR adds resolution, speed, extra creative control, and enhanced comfort in the hand to one of the smallest and lightest digital cameras in its class. Even with its advancements in ergonomic design and technology, this easy-to-use EOS digital camera is compatible with all of Canon's EF lenses, including the EF-S lenses.",
                                                           'dimension': '5 x 3.7 x 2.5 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc"> \r\n\r\n<li>8.0-megapixel CMOS sensor captures enough detail for photo-quality 16 x 22-inch prints<br></li>\r\n<li>Includes Canon\'s EF-S 18-55mm, f3.5-5.6 zoom lens<br></li>\r\n<li>DIGIC II Image Processor provides fast, accurate image processing; captures images at a rate of up to 3 frames per second<br></li>\r\n<li>Fast start-up time--.2 seconds<br></li>\r\n<li>Powered by rechargeable Lithium-ion battery (included, with charger)</li>\r\n</ul>\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '34',
                                                           'megapixels': '90',
                                                           'meta_description': 'Canon Digital Rebel XT 8MP Digital SLR Camera with EF-S 18-55mm f3.5-5.6 Lens (Black)',
                                                           'meta_keyword': 'canon, slr, camera, 8, digital',
                                                           'meta_title': 'Canon Digital Rebel XT 8MP Digital SLR Camera with EF-S 18-55mm f3.5-5.6 Lens (Black)',
                                                           'minimal_price': '449.0000',
                                                           'model': 'Rebel XT ',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Canon Digital Rebel XT 8MP Digital SLR Camera',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '550.0000',
                                                           'product_id': '44',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '44',
                                                           'short_description': ' Canon EOS Digital Rebel XT SLR adds resolution, speed, extra creative control, and enhanced comfort in the hand to one of the smallest and lightest digital cameras in its class. ',
                                                           'sku': 'Rebel XT',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [{'all_groups': '1',
                                                                           'cust_group': 32000,
                                                                           'price': '449.0000',
                                                                           'price_id': '1',
                                                                           'price_qty': '2.0000',
                                                                           'website_id': '0',
                                                                           'website_price': '449.0000'}],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-06-24 22:50:46',
                                                           'url_key': 'canon-digital-rebel-xt-8mp-digital-slr-camera-with-ef-s-18-55mm-f3-5-5-6-lens-black',
                                                           'url_path': 'canon-digital-rebel-xt-8mp-digital-slr-camera-with-ef-s-18-55mm-f3-5-5-6-lens-black.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '4.0000'},
        ('ol_catalog_product.info', (45, None, None, 'id')): {'categories': ['26'],
                                                           'color': '23',
                                                           'cost': '20.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 13:18:56',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "The Argus QC-2185 Quick Click 5MP digital camera offers all the basic features you need in a compact and stylish digital camera. This unit is easy to use, and is perfect for those who want a completely portable option for taking good pictures, without having to empty their wallet.\r\n\r\nThe Argus QC-2185 features a clear and bright 1.1-inch CSTN (color super-twist nematic) LCD display that makes it easy to frame the perfect picture. Thanks to its USB 1.1 connection compatibility, this digital camera lets you quickly download pictures to your Mac or PC, and can also function as a handy web camera. The QC-2185 includes eight megabytes of internal SDRAM memory, with the ability to expand camera memory via a built-in SD (secure digital) storage card slot for easy storage and transfer of your pictures. This unit also includes a built-in auto flash with a three to seven foot range, and comes with ArcSoft PhotoImpression's photo editing software which makes it easy for you to edit, crop, adjust and improve all your best pictures to make them even better.\r\n",
                                                           'dimension': '2.75 inches x 1.5 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc".  \r\n<li>5 megapixel digital camera with a 1600 x 1200 resolution and an f2.8 aperture</li>\r\n<li> Clear and bright 1.1-inch CSTN LCD display makes it easy to frame the perfect picture</li>\r\n<li>USB 1.1 connection compatibility lets you quickly download pictures to your Mac or PC, and function as a web camera</li>\r\n<li>Runs on 3 AAA batteries, and requires; Windows OS 98 or higher, at least 32 MB of RAM and 125 MB of hard disk space, and an available USB port</li>\r\n<li>Weighs 3.4 ounces, measures 3.6 x 2.4 x 1.1 inches (W x H x D), and is backed by a 1-year manufacturer\'s warranty</li>\r\n</ul>\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '32',
                                                           'megapixels': '93',
                                                           'meta_description': 'Argus QC-2185 Quick Click 2MP Digital Camera',
                                                           'meta_keyword': 'Argus, QC-2185, digital, camera, 2MP',
                                                           'meta_title': 'Argus QC-2185 Quick Click 2MP Digital Camera',
                                                           'minimal_price': '37.4900',
                                                           'model': 'QC-2185',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': ' Argus QC-2185 Quick Click 5MP Digital Camera',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '37.4900',
                                                           'product_id': '45',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '44',
                                                           'short_description': 'The Argus QC-2185 Quick Click 5MP digital camera offers all the basic features you need in a compact and stylish digital camera. This unit is easy to use, and is perfect for those who want a completely portable option for taking good pictures, without having to empty their wallet.',
                                                           'sku': 'QC-2185',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:52:48',
                                                           'url_key': 'argus-qc-2185-quick-click-5mp-digital-camera',
                                                           'url_path': 'argus-qc-2185-quick-click-5mp-digital-camera.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (45, u'2', None, 'id')): {'categories': ['26'],
                                                           'color': '23',
                                                           'cost': '20.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 13:18:56',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "The Argus QC-2185 Quick Click 5MP digital camera offers all the basic features you need in a compact and stylish digital camera. This unit is easy to use, and is perfect for those who want a completely portable option for taking good pictures, without having to empty their wallet.\r\n\r\nThe Argus QC-2185 features a clear and bright 1.1-inch CSTN (color super-twist nematic) LCD display that makes it easy to frame the perfect picture. Thanks to its USB 1.1 connection compatibility, this digital camera lets you quickly download pictures to your Mac or PC, and can also function as a handy web camera. The QC-2185 includes eight megabytes of internal SDRAM memory, with the ability to expand camera memory via a built-in SD (secure digital) storage card slot for easy storage and transfer of your pictures. This unit also includes a built-in auto flash with a three to seven foot range, and comes with ArcSoft PhotoImpression's photo editing software which makes it easy for you to edit, crop, adjust and improve all your best pictures to make them even better.\r\n",
                                                           'dimension': '2.75 inches x 1.5 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc".  \r\n<li>5 megapixel digital camera with a 1600 x 1200 resolution and an f2.8 aperture</li>\r\n<li> Clear and bright 1.1-inch CSTN LCD display makes it easy to frame the perfect picture</li>\r\n<li>USB 1.1 connection compatibility lets you quickly download pictures to your Mac or PC, and function as a web camera</li>\r\n<li>Runs on 3 AAA batteries, and requires; Windows OS 98 or higher, at least 32 MB of RAM and 125 MB of hard disk space, and an available USB port</li>\r\n<li>Weighs 3.4 ounces, measures 3.6 x 2.4 x 1.1 inches (W x H x D), and is backed by a 1-year manufacturer\'s warranty</li>\r\n</ul>\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '32',
                                                           'megapixels': '93',
                                                           'meta_description': 'Argus QC-2185 Quick Click 2MP Digital Camera',
                                                           'meta_keyword': 'Argus, QC-2185, digital, camera, 2MP',
                                                           'meta_title': 'Argus QC-2185 Quick Click 2MP Digital Camera',
                                                           'minimal_price': '37.4900',
                                                           'model': 'QC-2185',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': ' Argus QC-2185 Quick Click 5MP Digital Camera',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '37.4900',
                                                           'product_id': '45',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '44',
                                                           'short_description': 'The Argus QC-2185 Quick Click 5MP digital camera offers all the basic features you need in a compact and stylish digital camera. This unit is easy to use, and is perfect for those who want a completely portable option for taking good pictures, without having to empty their wallet.',
                                                           'sku': 'QC-2185',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:52:48',
                                                           'url_key': 'argus-qc-2185-quick-click-5mp-digital-camera',
                                                           'url_path': 'argus-qc-2185-quick-click-5mp-digital-camera.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (45, u'3', None, 'id')): {'categories': ['26'],
                                                           'color': '23',
                                                           'cost': '20.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 13:18:56',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "The Argus QC-2185 Quick Click 5MP digital camera offers all the basic features you need in a compact and stylish digital camera. This unit is easy to use, and is perfect for those who want a completely portable option for taking good pictures, without having to empty their wallet.\r\n\r\nThe Argus QC-2185 features a clear and bright 1.1-inch CSTN (color super-twist nematic) LCD display that makes it easy to frame the perfect picture. Thanks to its USB 1.1 connection compatibility, this digital camera lets you quickly download pictures to your Mac or PC, and can also function as a handy web camera. The QC-2185 includes eight megabytes of internal SDRAM memory, with the ability to expand camera memory via a built-in SD (secure digital) storage card slot for easy storage and transfer of your pictures. This unit also includes a built-in auto flash with a three to seven foot range, and comes with ArcSoft PhotoImpression's photo editing software which makes it easy for you to edit, crop, adjust and improve all your best pictures to make them even better.\r\n",
                                                           'dimension': '2.75 inches x 1.5 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc".  \r\n<li>5 megapixel digital camera with a 1600 x 1200 resolution and an f2.8 aperture</li>\r\n<li> Clear and bright 1.1-inch CSTN LCD display makes it easy to frame the perfect picture</li>\r\n<li>USB 1.1 connection compatibility lets you quickly download pictures to your Mac or PC, and function as a web camera</li>\r\n<li>Runs on 3 AAA batteries, and requires; Windows OS 98 or higher, at least 32 MB of RAM and 125 MB of hard disk space, and an available USB port</li>\r\n<li>Weighs 3.4 ounces, measures 3.6 x 2.4 x 1.1 inches (W x H x D), and is backed by a 1-year manufacturer\'s warranty</li>\r\n</ul>\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '32',
                                                           'megapixels': '93',
                                                           'meta_description': 'Argus QC-2185 Quick Click 2MP Digital Camera',
                                                           'meta_keyword': 'Argus, QC-2185, digital, camera, 2MP',
                                                           'meta_title': 'Argus QC-2185 Quick Click 2MP Digital Camera',
                                                           'minimal_price': '37.4900',
                                                           'model': 'QC-2185',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': ' Argus QC-2185 Quick Click 5MP Digital Camera',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '37.4900',
                                                           'product_id': '45',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '44',
                                                           'short_description': 'The Argus QC-2185 Quick Click 5MP digital camera offers all the basic features you need in a compact and stylish digital camera. This unit is easy to use, and is perfect for those who want a completely portable option for taking good pictures, without having to empty their wallet.',
                                                           'sku': 'QC-2185',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:52:48',
                                                           'url_key': 'argus-qc-2185-quick-click-5mp-digital-camera',
                                                           'url_path': 'argus-qc-2185-quick-click-5mp-digital-camera.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (46, None, None, 'id')): {'categories': ['12',
                                                                          '26'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 13:23:34',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "Olympus continues to innovate with the launch of the Stylus 750 digital camera, a technically sophisticated point-and-shoot camera offering a number of pioneering technologies such as Dual Image Stabilization, Bright Capture Technology, and TruePic Turbo, as well as a powerful 5x optical zoom that tucks away into a streamlined metal, all-weather body design. The camera is distinguished by a number of premium features, including:\r\n\r\n    * An advanced combination of the mechanical CCD-shift Image Stabilization and Digital Image Stabilization work together to ensure the clearest pictures possible in any situation;\r\n    * A 5x optical zoom lens with a newly developed lens element to maintain a small compact size;\r\n    * A 2.5-inch LCD and Bright Capture Technology dramatically improve composition, capture and review of images in low-light situations;\r\n    * Olympus' exclusive TruePic Turbo Image Processing engine is coupled with a 7.1-megapixel image sensor to produce crisp, high-quality p",
                                                           'dimension': '3.8 x 2.1 x 1 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc">\r\n\r\n<li>7.1-megapixel CCD captures enough detail for photo-quality 15 x 20-inch prints<br></li>\r\n<li>5x image-stabilized optical zoom; 2.5-inch LCD display<br></li>\r\n<li>Compact, all-weather body measures 3.8 x 2.1 x 0.96 inches<br></li>\r\n<li>Bright Capture technology; 27 selectable shooting modes; built-in Help guide<br></li>\r\n<li>Stores images on xD Picture Cards; powered by Li-Ion battery (battery and charger included)</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '33',
                                                           'megapixels': '91',
                                                           'meta_description': 'Olympus Stylus 750 7.1MP Digital Camera with Digital Image Stabilized 5x Optical Zoom and CCD Shift Stabilization (Silver)',
                                                           'meta_keyword': 'Olympus, stylus, 750, 7MP, digital, camera, zoom',
                                                           'meta_title': 'Olympus Stylus 750 7.1MP Digital Camera with Digital Image Stabilized 5x Optical Zoom and CCD Shift Stabilization (Silver)',
                                                           'minimal_price': '161.9400',
                                                           'model': '750',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': ' Olympus Stylus 750 7.1MP Digital Camera',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '161.9400',
                                                           'product_id': '46',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '44',
                                                           'short_description': 'A technically sophisticated point-and-shoot camera offering a number of pioneering technologies such as Dual Image Stabilization, Bright Capture Technology, and TruePic Turbo, as well as a powerful 5x optical zoom.',
                                                           'sku': '750',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:57:57',
                                                           'url_key': 'olympus-stylus-750-7-1mp-digital-camera',
                                                           'url_path': 'olympus-stylus-750-7-1mp-digital-camera.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (46, u'2', None, 'id')): {'categories': ['12',
                                                                          '26'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 13:23:34',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "Olympus continues to innovate with the launch of the Stylus 750 digital camera, a technically sophisticated point-and-shoot camera offering a number of pioneering technologies such as Dual Image Stabilization, Bright Capture Technology, and TruePic Turbo, as well as a powerful 5x optical zoom that tucks away into a streamlined metal, all-weather body design. The camera is distinguished by a number of premium features, including:\r\n\r\n    * An advanced combination of the mechanical CCD-shift Image Stabilization and Digital Image Stabilization work together to ensure the clearest pictures possible in any situation;\r\n    * A 5x optical zoom lens with a newly developed lens element to maintain a small compact size;\r\n    * A 2.5-inch LCD and Bright Capture Technology dramatically improve composition, capture and review of images in low-light situations;\r\n    * Olympus' exclusive TruePic Turbo Image Processing engine is coupled with a 7.1-megapixel image sensor to produce crisp, high-quality p",
                                                           'dimension': '3.8 x 2.1 x 1 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc">\r\n\r\n<li>7.1-megapixel CCD captures enough detail for photo-quality 15 x 20-inch prints<br></li>\r\n<li>5x image-stabilized optical zoom; 2.5-inch LCD display<br></li>\r\n<li>Compact, all-weather body measures 3.8 x 2.1 x 0.96 inches<br></li>\r\n<li>Bright Capture technology; 27 selectable shooting modes; built-in Help guide<br></li>\r\n<li>Stores images on xD Picture Cards; powered by Li-Ion battery (battery and charger included)</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '33',
                                                           'megapixels': '91',
                                                           'meta_description': 'Olympus Stylus 750 7.1MP Digital Camera with Digital Image Stabilized 5x Optical Zoom and CCD Shift Stabilization (Silver)',
                                                           'meta_keyword': 'Olympus, stylus, 750, 7MP, digital, camera, zoom',
                                                           'meta_title': 'Olympus Stylus 750 7.1MP Digital Camera with Digital Image Stabilized 5x Optical Zoom and CCD Shift Stabilization (Silver)',
                                                           'minimal_price': '161.9400',
                                                           'model': '750',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': ' Olympus Stylus 750 7.1MP Digital Camera',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '161.9400',
                                                           'product_id': '46',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '44',
                                                           'short_description': 'A technically sophisticated point-and-shoot camera offering a number of pioneering technologies such as Dual Image Stabilization, Bright Capture Technology, and TruePic Turbo, as well as a powerful 5x optical zoom.',
                                                           'sku': '750',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:57:57',
                                                           'url_key': 'olympus-stylus-750-7-1mp-digital-camera',
                                                           'url_path': 'olympus-stylus-750-7-1mp-digital-camera.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (46, u'3', None, 'id')): {'categories': ['12',
                                                                          '26'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 13:23:34',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "Olympus continues to innovate with the launch of the Stylus 750 digital camera, a technically sophisticated point-and-shoot camera offering a number of pioneering technologies such as Dual Image Stabilization, Bright Capture Technology, and TruePic Turbo, as well as a powerful 5x optical zoom that tucks away into a streamlined metal, all-weather body design. The camera is distinguished by a number of premium features, including:\r\n\r\n    * An advanced combination of the mechanical CCD-shift Image Stabilization and Digital Image Stabilization work together to ensure the clearest pictures possible in any situation;\r\n    * A 5x optical zoom lens with a newly developed lens element to maintain a small compact size;\r\n    * A 2.5-inch LCD and Bright Capture Technology dramatically improve composition, capture and review of images in low-light situations;\r\n    * Olympus' exclusive TruePic Turbo Image Processing engine is coupled with a 7.1-megapixel image sensor to produce crisp, high-quality p",
                                                           'dimension': '3.8 x 2.1 x 1 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc">\r\n\r\n<li>7.1-megapixel CCD captures enough detail for photo-quality 15 x 20-inch prints<br></li>\r\n<li>5x image-stabilized optical zoom; 2.5-inch LCD display<br></li>\r\n<li>Compact, all-weather body measures 3.8 x 2.1 x 0.96 inches<br></li>\r\n<li>Bright Capture technology; 27 selectable shooting modes; built-in Help guide<br></li>\r\n<li>Stores images on xD Picture Cards; powered by Li-Ion battery (battery and charger included)</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '33',
                                                           'megapixels': '91',
                                                           'meta_description': 'Olympus Stylus 750 7.1MP Digital Camera with Digital Image Stabilized 5x Optical Zoom and CCD Shift Stabilization (Silver)',
                                                           'meta_keyword': 'Olympus, stylus, 750, 7MP, digital, camera, zoom',
                                                           'meta_title': 'Olympus Stylus 750 7.1MP Digital Camera with Digital Image Stabilized 5x Optical Zoom and CCD Shift Stabilization (Silver)',
                                                           'minimal_price': '161.9400',
                                                           'model': '750',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': ' Olympus Stylus 750 7.1MP Digital Camera',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '161.9400',
                                                           'product_id': '46',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '44',
                                                           'short_description': 'A technically sophisticated point-and-shoot camera offering a number of pioneering technologies such as Dual Image Stabilization, Bright Capture Technology, and TruePic Turbo, as well as a powerful 5x optical zoom.',
                                                           'sku': '750',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:57:57',
                                                           'url_key': 'olympus-stylus-750-7-1mp-digital-camera',
                                                           'url_path': 'olympus-stylus-750-7-1mp-digital-camera.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (47, None, None, 'id')): {'categories': ['26'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 13:27:14',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Replacing the highly popular PowerShot A620, the PowerShot A630 features a rotating 2.5-inch vari-angle LCD, 4x optical zoom lens, and a vast array of creative shooting modes.<br>\r\n\r\nThe PowerShot A630 packs a vast array of advanced features into a remarkably compact space<br><br>\r\n\r\n',
                                                           'dimension': '4.3 x 2.6 x 1.9 inches ',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc">\r\n<li>8-megapixel CCD captures enough detail for photo-quality 16 x 22-inch prints<br></li>\r\n<li>4x optical zoom; 2.5-inch vari-angle LCD display<br></li>\r\n<li>ISO range up to ISO 800 for less blur in low light while hand-holding<br></li>\r\n<li>3:2 guide masks LCD to display 4 x 6-inch print size; 16:9 format option for still images<br></li>\r\n<li>Stores images on SD cards; powered by 4 AA-size batteries</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '34',
                                                           'megapixels': '90',
                                                           'meta_description': 'Canon PowerShot A630 8MP Digital Camera with 4x Optical Zoom',
                                                           'meta_keyword': 'canon, powershot, A630, digital, camera, optical, zoom',
                                                           'meta_title': 'Canon PowerShot A630 8MP Digital Camera with 4x Optical Zoom',
                                                           'minimal_price': '329.9900',
                                                           'model': 'A630 ',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Canon PowerShot A630 8MP Digital Camera with 4x Optical Zoom',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '329.9900',
                                                           'product_id': '47',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '44',
                                                           'short_description': 'Replacing the highly popular PowerShot A620, the PowerShot A630 features a rotating 2.5-inch vari-angle LCD, 4x optical zoom lens, and a vast array of creative shooting modes.',
                                                           'sku': 'A630',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:58:14',
                                                           'url_key': 'canon-powershot-a630-8mp-digital-camera-with-4x-optical-zoom',
                                                           'url_path': 'canon-powershot-a630-8mp-digital-camera-with-4x-optical-zoom.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '3.0000'},
        ('ol_catalog_product.info', (47, u'2', None, 'id')): {'categories': ['26'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 13:27:14',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Replacing the highly popular PowerShot A620, the PowerShot A630 features a rotating 2.5-inch vari-angle LCD, 4x optical zoom lens, and a vast array of creative shooting modes.<br>\r\n\r\nThe PowerShot A630 packs a vast array of advanced features into a remarkably compact space<br><br>\r\n\r\n',
                                                           'dimension': '4.3 x 2.6 x 1.9 inches ',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc">\r\n<li>8-megapixel CCD captures enough detail for photo-quality 16 x 22-inch prints<br></li>\r\n<li>4x optical zoom; 2.5-inch vari-angle LCD display<br></li>\r\n<li>ISO range up to ISO 800 for less blur in low light while hand-holding<br></li>\r\n<li>3:2 guide masks LCD to display 4 x 6-inch print size; 16:9 format option for still images<br></li>\r\n<li>Stores images on SD cards; powered by 4 AA-size batteries</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '34',
                                                           'megapixels': '90',
                                                           'meta_description': 'Canon PowerShot A630 8MP Digital Camera with 4x Optical Zoom',
                                                           'meta_keyword': 'canon, powershot, A630, digital, camera, optical, zoom',
                                                           'meta_title': 'Canon PowerShot A630 8MP Digital Camera with 4x Optical Zoom',
                                                           'minimal_price': '329.9900',
                                                           'model': 'A630 ',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Canon PowerShot A630 8MP Digital Camera with 4x Optical Zoom',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '329.9900',
                                                           'product_id': '47',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '44',
                                                           'short_description': 'Replacing the highly popular PowerShot A620, the PowerShot A630 features a rotating 2.5-inch vari-angle LCD, 4x optical zoom lens, and a vast array of creative shooting modes.',
                                                           'sku': 'A630',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:58:14',
                                                           'url_key': 'canon-powershot-a630-8mp-digital-camera-with-4x-optical-zoom',
                                                           'url_path': 'canon-powershot-a630-8mp-digital-camera-with-4x-optical-zoom.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '3.0000'},
        ('ol_catalog_product.info', (47, u'3', None, 'id')): {'categories': ['26'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 13:27:14',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Replacing the highly popular PowerShot A620, the PowerShot A630 features a rotating 2.5-inch vari-angle LCD, 4x optical zoom lens, and a vast array of creative shooting modes.<br>\r\n\r\nThe PowerShot A630 packs a vast array of advanced features into a remarkably compact space<br><br>\r\n\r\n',
                                                           'dimension': '4.3 x 2.6 x 1.9 inches ',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc">\r\n<li>8-megapixel CCD captures enough detail for photo-quality 16 x 22-inch prints<br></li>\r\n<li>4x optical zoom; 2.5-inch vari-angle LCD display<br></li>\r\n<li>ISO range up to ISO 800 for less blur in low light while hand-holding<br></li>\r\n<li>3:2 guide masks LCD to display 4 x 6-inch print size; 16:9 format option for still images<br></li>\r\n<li>Stores images on SD cards; powered by 4 AA-size batteries</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '34',
                                                           'megapixels': '90',
                                                           'meta_description': 'Canon PowerShot A630 8MP Digital Camera with 4x Optical Zoom',
                                                           'meta_keyword': 'canon, powershot, A630, digital, camera, optical, zoom',
                                                           'meta_title': 'Canon PowerShot A630 8MP Digital Camera with 4x Optical Zoom',
                                                           'minimal_price': '329.9900',
                                                           'model': 'A630 ',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Canon PowerShot A630 8MP Digital Camera with 4x Optical Zoom',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '329.9900',
                                                           'product_id': '47',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '44',
                                                           'short_description': 'Replacing the highly popular PowerShot A620, the PowerShot A630 features a rotating 2.5-inch vari-angle LCD, 4x optical zoom lens, and a vast array of creative shooting modes.',
                                                           'sku': 'A630',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:58:14',
                                                           'url_key': 'canon-powershot-a630-8mp-digital-camera-with-4x-optical-zoom',
                                                           'url_path': 'canon-powershot-a630-8mp-digital-camera-with-4x-optical-zoom.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '3.0000'},
        ('ol_catalog_product.info', (48, None, None, 'id')): {'categories': ['26'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 13:32:20',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "Small on size. Big on value. Kodak's newest C-Series digital camera, the C530, sports awesome features--such as 5.0-megapixel CCD resolution, on-camera image cropping, and an on-camera Share button--at a very affordable price.",
                                                           'dimension': ' 4 x 6 x 9 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc">   \r\n\r\n<li>5.0-megapixel CCD captures enough detail for photo-quality 13 x 17-inch prints<br></li>\r\n<li>1.5-inch LCD display<br></li>\r\n<li>Continuous QVGA video<br></li>\r\n<li>Auto scene mode and three color modes; in-camera cropping<br></li>\r\n<li>Powered by AA size batteries; stores images on SD memory cards (includes 16 MB internal memory)</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '31',
                                                           'megapixels': '93',
                                                           'meta_description': 'Kodak EasyShare C530 5MP Digital Camera',
                                                           'meta_keyword': 'kodak, eayshare, c530, 5MP, digital, camera',
                                                           'meta_title': 'Kodak EasyShare C530 5MP Digital Camera',
                                                           'minimal_price': '199.9900',
                                                           'model': 'C530 ',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Kodak EasyShare C530 5MP Digital Camera',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '199.9900',
                                                           'product_id': '48',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '44',
                                                           'short_description': "Small on size. Big on value. Kodak's newest C-Series digital camera, the C530, sports awesome features",
                                                           'sku': 'C530',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:58:41',
                                                           'url_key': 'kodak-easyshare-c530-5mp-digital-camera',
                                                           'url_path': 'kodak-easyshare-c530-5mp-digital-camera.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (48, u'2', None, 'id')): {'categories': ['26'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 13:32:20',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "Small on size. Big on value. Kodak's newest C-Series digital camera, the C530, sports awesome features--such as 5.0-megapixel CCD resolution, on-camera image cropping, and an on-camera Share button--at a very affordable price.",
                                                           'dimension': ' 4 x 6 x 9 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc">   \r\n\r\n<li>5.0-megapixel CCD captures enough detail for photo-quality 13 x 17-inch prints<br></li>\r\n<li>1.5-inch LCD display<br></li>\r\n<li>Continuous QVGA video<br></li>\r\n<li>Auto scene mode and three color modes; in-camera cropping<br></li>\r\n<li>Powered by AA size batteries; stores images on SD memory cards (includes 16 MB internal memory)</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '31',
                                                           'megapixels': '93',
                                                           'meta_description': 'Kodak EasyShare C530 5MP Digital Camera',
                                                           'meta_keyword': 'kodak, eayshare, c530, 5MP, digital, camera',
                                                           'meta_title': 'Kodak EasyShare C530 5MP Digital Camera',
                                                           'minimal_price': '199.9900',
                                                           'model': 'C530 ',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Kodak EasyShare C530 5MP Digital Camera',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '199.9900',
                                                           'product_id': '48',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '44',
                                                           'short_description': "Small on size. Big on value. Kodak's newest C-Series digital camera, the C530, sports awesome features",
                                                           'sku': 'C530',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:58:41',
                                                           'url_key': 'kodak-easyshare-c530-5mp-digital-camera',
                                                           'url_path': 'kodak-easyshare-c530-5mp-digital-camera.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (48, u'3', None, 'id')): {'categories': ['26'],
                                                           'color': '23',
                                                           'cost': '29.9900',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 13:32:20',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "Small on size. Big on value. Kodak's newest C-Series digital camera, the C530, sports awesome features--such as 5.0-megapixel CCD resolution, on-camera image cropping, and an on-camera Share button--at a very affordable price.",
                                                           'dimension': ' 4 x 6 x 9 inches',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc">   \r\n\r\n<li>5.0-megapixel CCD captures enough detail for photo-quality 13 x 17-inch prints<br></li>\r\n<li>1.5-inch LCD display<br></li>\r\n<li>Continuous QVGA video<br></li>\r\n<li>Auto scene mode and three color modes; in-camera cropping<br></li>\r\n<li>Powered by AA size batteries; stores images on SD memory cards (includes 16 MB internal memory)</li>\r\n</ul>',
                                                           'is_recurring': None,
                                                           'manufacturer': '31',
                                                           'megapixels': '93',
                                                           'meta_description': 'Kodak EasyShare C530 5MP Digital Camera',
                                                           'meta_keyword': 'kodak, eayshare, c530, 5MP, digital, camera',
                                                           'meta_title': 'Kodak EasyShare C530 5MP Digital Camera',
                                                           'minimal_price': '199.9900',
                                                           'model': 'C530 ',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Kodak EasyShare C530 5MP Digital Camera',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '199.9900',
                                                           'product_id': '48',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '44',
                                                           'short_description': "Small on size. Big on value. Kodak's newest C-Series digital camera, the C530, sports awesome features",
                                                           'sku': 'C530',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:58:41',
                                                           'url_key': 'kodak-easyshare-c530-5mp-digital-camera',
                                                           'url_path': 'kodak-easyshare-c530-5mp-digital-camera.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (49, None, None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '49',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '40',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_9',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:50',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-9',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-9.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (49, u'2', None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '49',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '40',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_9',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:50',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-9',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-9.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (49, u'3', None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '49',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '40',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_9',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:50',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-9',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-9.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (51, None, None, 'id')): {'categories': ['22'],
                                                           'color': '26',
                                                           'cost': '50.0000',
                                                           'country_of_manufacture': None,
                                                           'country_orgin': 'Italy',
                                                           'created_at': '2007-08-28 16:25:46',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'The Magento ottoman will impress with its style while it delivers on quality. This piece of living room furniture is built to last with durable solid wood framing, generous padding and plush stain-resistant microfiber upholstery.',
                                                           'dimension': '',
                                                           'enable_googlecheckout': None,
                                                           'finish': 'Microfiber',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Ottoman',
                                                           'meta_keyword': 'Ottoman',
                                                           'meta_title': 'Ottoman',
                                                           'minimal_price': '299.9900',
                                                           'model': 'magotto',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Ottoman',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '299.9900',
                                                           'product_id': '51',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'room': '72',
                                                           'set': '42',
                                                           'short_description': 'With durable solid wood framing, generous padding and plush stain-resistant microfiber upholstery.',
                                                           'sku': '1111',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:59:04',
                                                           'url_key': 'ottoman',
                                                           'url_path': 'ottoman.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '20.0000'},
        ('ol_catalog_product.info', (51, u'2', None, 'id')): {'categories': ['22'],
                                                           'color': '26',
                                                           'cost': '50.0000',
                                                           'country_of_manufacture': None,
                                                           'country_orgin': 'Italy',
                                                           'created_at': '2007-08-28 16:25:46',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'The Magento ottoman will impress with its style while it delivers on quality. This piece of living room furniture is built to last with durable solid wood framing, generous padding and plush stain-resistant microfiber upholstery.',
                                                           'dimension': '',
                                                           'enable_googlecheckout': None,
                                                           'finish': 'Microfiber',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Ottoman',
                                                           'meta_keyword': 'Ottoman',
                                                           'meta_title': 'Ottoman',
                                                           'minimal_price': '299.9900',
                                                           'model': 'magotto',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Ottoman',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '299.9900',
                                                           'product_id': '51',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'room': '72',
                                                           'set': '42',
                                                           'short_description': 'With durable solid wood framing, generous padding and plush stain-resistant microfiber upholstery.',
                                                           'sku': '1111',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:59:04',
                                                           'url_key': 'ottoman',
                                                           'url_path': 'ottoman.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '20.0000'},
        ('ol_catalog_product.info', (51, u'3', None, 'id')): {'categories': ['22'],
                                                           'color': '26',
                                                           'cost': '50.0000',
                                                           'country_of_manufacture': None,
                                                           'country_orgin': 'Italy',
                                                           'created_at': '2007-08-28 16:25:46',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'The Magento ottoman will impress with its style while it delivers on quality. This piece of living room furniture is built to last with durable solid wood framing, generous padding and plush stain-resistant microfiber upholstery.',
                                                           'dimension': '',
                                                           'enable_googlecheckout': None,
                                                           'finish': 'Microfiber',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Ottoman',
                                                           'meta_keyword': 'Ottoman',
                                                           'meta_title': 'Ottoman',
                                                           'minimal_price': '299.9900',
                                                           'model': 'magotto',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Ottoman',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '299.9900',
                                                           'product_id': '51',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'room': '72',
                                                           'set': '42',
                                                           'short_description': 'With durable solid wood framing, generous padding and plush stain-resistant microfiber upholstery.',
                                                           'sku': '1111',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:59:04',
                                                           'url_key': 'ottoman',
                                                           'url_path': 'ottoman.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '20.0000'},
        ('ol_catalog_product.info', (52, None, None, 'id')): {'categories': ['22'],
                                                           'color': '26',
                                                           'cost': '50.0000',
                                                           'country_of_manufacture': None,
                                                           'country_orgin': 'Italy',
                                                           'created_at': '2007-08-28 16:29:24',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'This Magento chair features a fun, futuristic design, with fluid curves and gentle angles that follow the shape of the body to enhance ultimate relaxation. It combines a hint of nostalgia with the up-to-date sensibility and function of modern chairs. It is in soft, velvety microfiber.',
                                                           'dimension': '',
                                                           'enable_googlecheckout': None,
                                                           'finish': 'Microfiber',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Chair',
                                                           'meta_keyword': 'Chair',
                                                           'meta_title': 'Chair',
                                                           'minimal_price': '129.9900',
                                                           'model': '1112',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Chair',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '129.9900',
                                                           'product_id': '52',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'room': '72',
                                                           'set': '42',
                                                           'short_description': 'Combining a hint of nostalgia with the up-to-date sensibility and function of modern chairs. It is in soft, velvety microfiber.',
                                                           'sku': '1112',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:59:17',
                                                           'url_key': 'chair',
                                                           'url_path': 'chair.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '50.0000'},
        ('ol_catalog_product.info', (52, u'2', None, 'id')): {'categories': ['22'],
                                                           'color': '26',
                                                           'cost': '50.0000',
                                                           'country_of_manufacture': None,
                                                           'country_orgin': 'Italy',
                                                           'created_at': '2007-08-28 16:29:24',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'This Magento chair features a fun, futuristic design, with fluid curves and gentle angles that follow the shape of the body to enhance ultimate relaxation. It combines a hint of nostalgia with the up-to-date sensibility and function of modern chairs. It is in soft, velvety microfiber.',
                                                           'dimension': '',
                                                           'enable_googlecheckout': None,
                                                           'finish': 'Microfiber',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Chair',
                                                           'meta_keyword': 'Chair',
                                                           'meta_title': 'Chair',
                                                           'minimal_price': '129.9900',
                                                           'model': '1112',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Chair',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '129.9900',
                                                           'product_id': '52',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'room': '72',
                                                           'set': '42',
                                                           'short_description': 'Combining a hint of nostalgia with the up-to-date sensibility and function of modern chairs. It is in soft, velvety microfiber.',
                                                           'sku': '1112',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:59:17',
                                                           'url_key': 'chair',
                                                           'url_path': 'chair.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '50.0000'},
        ('ol_catalog_product.info', (52, u'3', None, 'id')): {'categories': ['22'],
                                                           'color': '26',
                                                           'cost': '50.0000',
                                                           'country_of_manufacture': None,
                                                           'country_orgin': 'Italy',
                                                           'created_at': '2007-08-28 16:29:24',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'This Magento chair features a fun, futuristic design, with fluid curves and gentle angles that follow the shape of the body to enhance ultimate relaxation. It combines a hint of nostalgia with the up-to-date sensibility and function of modern chairs. It is in soft, velvety microfiber.',
                                                           'dimension': '',
                                                           'enable_googlecheckout': None,
                                                           'finish': 'Microfiber',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Chair',
                                                           'meta_keyword': 'Chair',
                                                           'meta_title': 'Chair',
                                                           'minimal_price': '129.9900',
                                                           'model': '1112',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Chair',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '129.9900',
                                                           'product_id': '52',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'room': '72',
                                                           'set': '42',
                                                           'short_description': 'Combining a hint of nostalgia with the up-to-date sensibility and function of modern chairs. It is in soft, velvety microfiber.',
                                                           'sku': '1112',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:59:17',
                                                           'url_key': 'chair',
                                                           'url_path': 'chair.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '50.0000'},
        ('ol_catalog_product.info', (53, None, None, 'id')): {'categories': ['22'],
                                                           'color': '26',
                                                           'cost': '200.0000',
                                                           'country_of_manufacture': None,
                                                           'country_orgin': 'Italy',
                                                           'created_at': '2007-08-28 16:32:24',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Inspired by the classic camelback sofa, Magento offers comfort and style in a low maintenance package.  For a sleek, simple and stylish piece, look no further than the Magento sofa - or sofabed!',
                                                           'dimension': '',
                                                           'enable_googlecheckout': None,
                                                           'finish': 'Microfiber',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Couch',
                                                           'meta_keyword': 'Couch',
                                                           'meta_title': 'Couch',
                                                           'minimal_price': '599.9900',
                                                           'model': '1113',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Couch',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '599.9900',
                                                           'product_id': '53',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'room': '72',
                                                           'set': '42',
                                                           'short_description': 'For a sleek, simple and stylish piece, look no further than the Magento sofa - or sofabed!',
                                                           'sku': '1113',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:59:40',
                                                           'url_key': 'couch',
                                                           'url_path': 'couch.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '200.0000'},
        ('ol_catalog_product.info', (53, u'2', None, 'id')): {'categories': ['22'],
                                                           'color': '26',
                                                           'cost': '200.0000',
                                                           'country_of_manufacture': None,
                                                           'country_orgin': 'Italy',
                                                           'created_at': '2007-08-28 16:32:24',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Inspired by the classic camelback sofa, Magento offers comfort and style in a low maintenance package.  For a sleek, simple and stylish piece, look no further than the Magento sofa - or sofabed!',
                                                           'dimension': '',
                                                           'enable_googlecheckout': None,
                                                           'finish': 'Microfiber',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Couch',
                                                           'meta_keyword': 'Couch',
                                                           'meta_title': 'Couch',
                                                           'minimal_price': '599.9900',
                                                           'model': '1113',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Couch',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '599.9900',
                                                           'product_id': '53',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'room': '72',
                                                           'set': '42',
                                                           'short_description': 'For a sleek, simple and stylish piece, look no further than the Magento sofa - or sofabed!',
                                                           'sku': '1113',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:59:40',
                                                           'url_key': 'couch',
                                                           'url_path': 'couch.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '200.0000'},
        ('ol_catalog_product.info', (53, u'3', None, 'id')): {'categories': ['22'],
                                                           'color': '26',
                                                           'cost': '200.0000',
                                                           'country_of_manufacture': None,
                                                           'country_orgin': 'Italy',
                                                           'created_at': '2007-08-28 16:32:24',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Inspired by the classic camelback sofa, Magento offers comfort and style in a low maintenance package.  For a sleek, simple and stylish piece, look no further than the Magento sofa - or sofabed!',
                                                           'dimension': '',
                                                           'enable_googlecheckout': None,
                                                           'finish': 'Microfiber',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'is_recurring': None,
                                                           'manufacturer': None,
                                                           'meta_description': 'Couch',
                                                           'meta_keyword': 'Couch',
                                                           'meta_title': 'Couch',
                                                           'minimal_price': '599.9900',
                                                           'model': '1113',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Couch',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '599.9900',
                                                           'product_id': '53',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'room': '72',
                                                           'set': '42',
                                                           'short_description': 'For a sleek, simple and stylish piece, look no further than the Magento sofa - or sofabed!',
                                                           'sku': '1113',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 14:59:40',
                                                           'url_key': 'couch',
                                                           'url_path': 'couch.html',
                                                           'visibility': '4',
                                                           'websites': ['1'],
                                                           'weight': '200.0000'},
        ('ol_catalog_product.info', (54, None, None, 'id')): {'categories': ['22'],
                                                           'country_of_manufacture': None,
                                                           'country_orgin': 'Italy',
                                                           'created_at': '2007-08-28 16:38:54',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': "The perfect furniture set for the living room!  Love red?  You'll love these pieces of handmade modern furniture!",
                                                           'dimension': '',
                                                           'enable_googlecheckout': None,
                                                           'finish': 'Microfiber',
                                                           'gift_message_available': '',
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'meta_description': 'Magento Red Furniture Set',
                                                           'meta_keyword': 'Magento, Red, Furniture, Set, ottoman, couch, chair',
                                                           'meta_title': 'Magento Red Furniture Set',
                                                           'model': 'RFS',
                                                           'name': 'Magento Red Furniture Set',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'product_id': '54',
                                                           'required_options': '0',
                                                           'room': '72',
                                                           'set': '42',
                                                           'short_description': "Love red?  You'll love these pieces of handmade modern furniture!",
                                                           'sku': '1114',
                                                           'small_image_label': None,
                                                           'status': '1',
                                                           'thumbnail_label': None,
                                                           'type': 'grouped',
                                                           'type_id': 'grouped',
                                                           'updated_at': '2008-08-08 15:00:22',
                                                           'url_key': 'magento-red-furniture-set',
                                                           'url_path': 'magento-red-furniture-set.html',
                                                           'visibility': '4',
                                                           'websites': ['1']},
        ('ol_catalog_product.info', (74, None, None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '74',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '46',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_3',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 13:19:48',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-3',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-3.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (74, u'2', None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '74',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '46',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_3',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 13:19:48',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-3',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-3.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (74, u'3', None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '74',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '46',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_3',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 13:19:48',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-3',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-3.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (75, None, None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '75',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '45',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_4',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:18',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-4',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-4.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (75, u'2', None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '75',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '45',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_4',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:18',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-4',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-4.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (75, u'3', None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '75',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '45',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_4',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:18',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-4',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-4.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (79, None, None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '79',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '44',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_5',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:11',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-5',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-5.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (79, u'2', None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '79',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '44',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_5',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:11',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-5',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-5.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (79, u'3', None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '79',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '44',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_5',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:11',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-5',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-5.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (80, None, None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '80',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '43',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_6',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:25',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-6',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-6.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (80, u'2', None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '80',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '43',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_6',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:25',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-6',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-6.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (80, u'3', None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '80',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '43',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_6',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:25',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-6',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-6.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (81, None, None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '81',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '42',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_7',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:32',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-7',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-7.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (81, u'2', None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '81',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '42',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_7',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:32',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-7',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-7.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (81, u'3', None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '81',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '42',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_7',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:32',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-7',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-7.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (82, None, None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '82',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '41',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_8',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:44',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-8',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-8.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (82, u'2', None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '82',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '41',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_8',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:44',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-8',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-8.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (82, u'3', None, 'id')): {'categories': ['17'],
                                                           'color': '59',
                                                           'cost': '10.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-28 15:09:50',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': 'Womens Premier Leather Single Layer Narrow Strap - ',
                                                           'is_recurring': None,
                                                           'manufacturer': '102',
                                                           'meta_description': 'Anashria Womens Premier Leather Sandal',
                                                           'meta_keyword': 'womens, sandal, leather, anashria, ',
                                                           'meta_title': 'Anashria Womens Premier Leather Sandal',
                                                           'minimal_price': '41.9500',
                                                           'model': 'B000KJ43SG',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'Anashria Womens Premier Leather Sandal',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '41.9500',
                                                           'product_id': '82',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '41',
                                                           'shoe_type': '97',
                                                           'short_description': 'Womens Premier Leather Single Layer Narrow Strap - NEW Colors Available - Womens Style - Genuine Top Grain Premier Leather - Rich Color Tones - Straps lined with 2000 lb test nylon - Guaranteed for the Life of the Sole - Non-slip sole - Note: Rainbow is in the process of unveiling a new toe post tag that is much smaller than the original tag.',
                                                           'sku': 'ana_8',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 01:07:44',
                                                           'url_key': 'anashria-womens-premier-leather-sandal-8',
                                                           'url_path': 'anashria-womens-premier-leather-sandal-8.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '2.0000'},
        ('ol_catalog_product.info', (83, None, None, 'id')): {'categories': ['16',
                                                                          '17'],
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-29 10:32:52',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '1',
                                                           'image_label': None,
                                                           'in_depth': '<ul>\r\n<ul class="disc">\r\n<li>Made of EVA foam<br></li>\r\n<li>Heel strap keeps shoe on foot<br></li>\r\n<li>Non-marking, slip-resistant outsole<br></li>\r\n<li> Weigh just 6-10 ounces<br></li>\r\n',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'cn, clogs, outdoor, shoes, sandals, comfortable',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '13.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container1',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '83',
                                                           'required_options': '1',
                                                           'set': '40',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'configurable',
                                                           'type_id': 'configurable',
                                                           'updated_at': '2008-08-08 15:00:07',
                                                           'url_key': 'cn-clogs-beach-garden-clog',
                                                           'url_path': 'cn-clogs-beach-garden-clog.html',
                                                           'visibility': '4',
                                                           'websites': ['1']},
        ('ol_catalog_product.info', (84, None, None, 'id')): {'categories': ['16',
                                                                          '17'],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '84',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '45',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_4',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:53:37',
                                                           'url_key': 'cn-clogs-beach-garden-clog-4',
                                                           'url_path': 'cn-clogs-beach-garden-clog-4.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (84, u'2', None, 'id')): {'categories': ['16',
                                                                          '17'],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '84',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '45',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_4',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:53:37',
                                                           'url_key': 'cn-clogs-beach-garden-clog-4',
                                                           'url_path': 'cn-clogs-beach-garden-clog-4.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (84, u'3', None, 'id')): {'categories': ['16',
                                                                          '17'],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '84',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '45',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_4',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:53:37',
                                                           'url_key': 'cn-clogs-beach-garden-clog-4',
                                                           'url_path': 'cn-clogs-beach-garden-clog-4.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (85, None, None, 'id')): {'categories': ['16',
                                                                          '17'],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '85',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '44',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_5',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:53:55',
                                                           'url_key': 'cn-clogs-beach-garden-clog-5',
                                                           'url_path': 'cn-clogs-beach-garden-clog-5.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (85, u'2', None, 'id')): {'categories': ['16',
                                                                          '17'],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '85',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '44',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_5',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:53:55',
                                                           'url_key': 'cn-clogs-beach-garden-clog-5',
                                                           'url_path': 'cn-clogs-beach-garden-clog-5.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (85, u'3', None, 'id')): {'categories': ['16',
                                                                          '17'],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '85',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '44',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_5',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:53:55',
                                                           'url_key': 'cn-clogs-beach-garden-clog-5',
                                                           'url_path': 'cn-clogs-beach-garden-clog-5.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (86, None, None, 'id')): {'categories': ['16',
                                                                          '17'],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '86',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '43',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_6',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:53:50',
                                                           'url_key': 'cn-clogs-beach-garden-clog-6',
                                                           'url_path': 'cn-clogs-beach-garden-clog-6.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (86, u'2', None, 'id')): {'categories': ['16',
                                                                          '17'],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '86',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '43',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_6',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:53:50',
                                                           'url_key': 'cn-clogs-beach-garden-clog-6',
                                                           'url_path': 'cn-clogs-beach-garden-clog-6.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (86, u'3', None, 'id')): {'categories': ['16',
                                                                          '17'],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '86',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '43',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_6',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:53:50',
                                                           'url_key': 'cn-clogs-beach-garden-clog-6',
                                                           'url_path': 'cn-clogs-beach-garden-clog-6.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (87, None, None, 'id')): {'categories': ['16',
                                                                          '17'],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '87',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '42',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_7',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:54:00',
                                                           'url_key': 'cn-clogs-beach-garden-clog-7',
                                                           'url_path': 'cn-clogs-beach-garden-clog-7.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (87, u'2', None, 'id')): {'categories': ['16',
                                                                          '17'],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '87',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '42',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_7',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:54:00',
                                                           'url_key': 'cn-clogs-beach-garden-clog-7',
                                                           'url_path': 'cn-clogs-beach-garden-clog-7.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (87, u'3', None, 'id')): {'categories': ['16',
                                                                          '17'],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '35',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '87',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '42',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_7',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:54:00',
                                                           'url_key': 'cn-clogs-beach-garden-clog-7',
                                                           'url_path': 'cn-clogs-beach-garden-clog-7.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (88, None, None, 'id')): {'categories': ['16',
                                                                          '17'],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '88',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '41',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_m8',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:54:10',
                                                           'url_key': 'cn-clogs-beach-garden-clog-8',
                                                           'url_path': 'cn-clogs-beach-garden-clog-8.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (88, u'2', None, 'id')): {'categories': ['16',
                                                                          '17'],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
                                                           'options_container': 'container2',
                                                           'page_layout': None,
                                                           'price': '15.9900',
                                                           'product_id': '88',
                                                           'recurring_profile': None,
                                                           'required_options': '0',
                                                           'set': '40',
                                                           'shoe_size': '41',
                                                           'shoe_type': '97',
                                                           'short_description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear',
                                                           'sku': 'cn_m8',
                                                           'small_image_label': None,
                                                           'special_from_date': None,
                                                           'special_price': None,
                                                           'special_to_date': None,
                                                           'status': '1',
                                                           'tax_class_id': '2',
                                                           'thumbnail_label': None,
                                                           'tier_price': [],
                                                           'type': 'simple',
                                                           'type_id': 'simple',
                                                           'updated_at': '2008-08-08 00:54:10',
                                                           'url_key': 'cn-clogs-beach-garden-clog-8',
                                                           'url_path': 'cn-clogs-beach-garden-clog-8.html',
                                                           'visibility': '1',
                                                           'websites': ['1'],
                                                           'weight': '1.0000'},
        ('ol_catalog_product.info', (88, u'3', None, 'id')): {'categories': ['16',
                                                                          '17'],
                                                           'color': '25',
                                                           'cost': '1.0000',
                                                           'country_of_manufacture': None,
                                                           'created_at': '2007-08-24 18:53:19',
                                                           'custom_design': '',
                                                           'custom_design_from': None,
                                                           'custom_design_to': None,
                                                           'custom_layout_update': '',
                                                           'description': 'Comfortable and fun to wear these clogs are the latest trend in fashion footwear. Wear them either at the beach, in your garden, at the mall or just about anywhere you would want to be comfortable.',
                                                           'enable_googlecheckout': None,
                                                           'gender': '36',
                                                           'gift_message_available': '',
                                                           'group_price': [],
                                                           'has_options': '0',
                                                           'image_label': None,
                                                           'in_depth': '    * Made of EVA foam\r\n    * Heel strap keeps shoe on foot\r\n    * Non-marking, slip-resistant outsole\r\n    * Weigh just 6-10 ounces\r\n\r\n',
                                                           'is_recurring': None,
                                                           'manufacturer': '63',
                                                           'meta_description': 'CN Clogs Beach/Garden Clog',
                                                           'meta_keyword': 'CN Clogs Beach/Garden Clog ',
                                                           'meta_title': 'CN Clogs Beach/Garden Clog',
                                                           'minimal_price': '15.9900',
                                                           'model': 'B000JI2N0I',
                                                           'msrp': None,
                                                           'msrp_display_actual_price_type': None,
                                                           'msrp_enabled': None,
                                                           'name': 'CN Clogs Beach/Garden Clog',
                                                           'news_from_date': None,
                                                           'news_to_date': None,
                                                           'old_id': None,
    