from odoo import _
from odoo.exceptions import ValidationError
from odoo.tests.common import TransactionCase


class TestModelNonConformity(TransactionCase):
    def setUp(self):
        """
        Sets some enviroment
        """
        super().setUp()

        self.nc_model = self.env["mgmtsystem.nonconformity"]
        self.partner_model = self.env["res.partner"]

        self.nc = self.nc_model.search([])[0]
        self.partner = self.partner_model.search([("child_ids", "!=", False)])[0]

        self.nc["partner_id"] = self.partner
        self.nc["qty_checked"] = 100
        self.nc["qty_noncompliant"] = 50

    def test_nc(self):
        """
        Test NC changes
        """
        self.nc["qty_noncompliant"] = 150
        self.nc._onchange_qty_noncompliant()
        self.assertEqual(self.nc["qty_noncompliant"] == self.nc["qty_checked"], True)
        self.nc["qty_noncompliant"] = 50
        self.nc._onchange_qty_noncompliant()
        self.assertEqual(self.nc["qty_checked"] == 150, True)

        self.nc["qty_noncompliant"] = 150
        self.nc["qty_checked"] = 50
        self.nc._onchange_qty_checked()
        self.assertEqual(self.nc["qty_noncompliant"] == self.nc["qty_checked"], True)
        self.nc["qty_checked"] = 200
        self.nc._onchange_qty_checked()
        self.assertEqual(self.nc["qty_noncompliant"] == 50, True)

    def test_nc_email(self):
        """
        Test NC partner email
        """
        partner = self.nc.partner_id
        partner_child = partner["child_ids"][0]
        partner_child.type = "quality"
        partner_child.email = "quality@example.com"
        self.nc.partner_id = partner.id
        self.assertEqual(True, self.nc.action_nc_sent())

        test_module = True
        with self.assertRaises(ValidationError) as e:
            self.assertEqual(True, self.nc.action_nc_sent(test_module))
        self.assertIn(
            _(
                "The partner's contacts quality type isn't available.\n "
                "Check if module mgmtsystem_nonconformity_partner is installed."
            ),
            str(e.exception),
        )

        partner_child.type = "quality"
        partner_child.email = ""
        with self.assertRaises(ValidationError) as e:
            self.assertEqual(True, self.nc.action_nc_sent())
        self.assertIn(
            _(
                "The partner's quality contact email "
                "is required in order to send the message."
            ),
            str(e.exception),
        )
