# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

__NAMESPACE__ = "http://www.portalfiscal.inf.br/mdfe"


class Aereo(models.AbstractModel):
    "Informações do modal Aéreo"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.aereo"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Aereo"

    mdfe30_nac = fields.Char(
        string="Marca da Nacionalidade da aeronave", xsd_required=True
    )

    mdfe30_matr = fields.Char(
        string="Marca de Matrícula da aeronave", xsd_required=True
    )

    mdfe30_nVoo = fields.Char(
        string="Número do Voo",
        xsd_required=True,
        help=(
            "Número do Voo\nFormato = AB1234, sendo AB a designação da empresa"
            " e 1234 o número do voo. Quando não for possível incluir as "
            "marcas de nacionalidade e matrícula sem hífen."
        ),
    )

    mdfe30_cAerEmb = fields.Char(
        string="Aeródromo de Embarque",
        xsd_required=True,
        help=(
            "Aeródromo de Embarque\nO código de três letras IATA do aeroporto "
            "de partida deverá ser incluído como primeira anotação. Quando não"
            " for possível, utilizar a sigla OACI."
        ),
    )

    mdfe30_cAerDes = fields.Char(
        string="Aeródromo de Destino",
        xsd_required=True,
        help=(
            "Aeródromo de Destino\nO código de três letras IATA do aeroporto "
            "de destino deverá ser incluído como primeira anotação. Quando não"
            " for possível, utilizar a sigla OACI."
        ),
    )

    mdfe30_dVoo = fields.Date(
        string="Data do Voo",
        xsd_required=True,
        xsd_type="TData",
        help="Data do Voo\nFormato AAAA-MM-DD",
    )
