# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models
from .ev_pagto_oper_mdfe_v3_00 import (
    COMP_TPCOMP,
    INFPAG_INDPAG,
)
from .tipos_geral_mdfe_v3_00 import TUF

__NAMESPACE__ = "http://www.portalfiscal.inf.br/mdfe"

"Tipo do Vale Pedagio"
DISP_TPVALEPED = [
    ("01", "TAG"),
    ("02", "Cupom"),
    ("03", "Cartão"),
]

"""Indicador de operação de transporte de alto desempenho
    Operação de transporte com utilização de veículos de frotas dedicadas ou
    fidelizadas.
    Preencher com “1” para indicar operação de transporte de alto desempenho,
    demais casos não informar a tag"""
INFPAG_INDALTODESEMP = [
    ("1", "1"),
]

"Tipo Proprietário ou possuidor"
PROP_TPPROP = [
    ("0", "TAC Agregado"),
    ("1", "TAC Independente"),
    ("2", "Outros."),
]

"""Categoria de Combinação Veicular
    Preencher com:
    02 Veículo Comercial 2 eixos;0
    4 Veículo Comercial 3 eixos;
    06 Veículo Comercial 4 eixos;0
    7 Veículo Comercial 5 eixos; 0
    8 Veículo Comercial 6 eixos;
    10 Veículo Comercial 7 eixos;
    11 Veículo Comercial 8 eixos;
    12 Veículo Comercial 9 eixos;
    13 Veículo Comercial 10 eixos;
    14 Veículo Comercial Acima de 10 eixos;"""
VALEPED_CATEGCOMBVEIC = [
    ("02", "02"),
    ("04", "04"),
    ("06", "06"),
    ("07", "07"),
    ("08", "08"),
    ("10", "10"),
    ("11", "11"),
    ("12", "12"),
    ("13", "13"),
    ("14", "14"),
]

"Tipo de Carroceria"
VEICREBOQUE_TPCAR = [
    ("00", "não aplicável"),
    ("01", "Aberta"),
    ("02", "Fechada/Baú"),
    ("03", "Granelera"),
    ("04", "Porta Container"),
    ("05", "Sider"),
]

"Tipo de Carroceria"
VEICTRACAO_TPCAR = [
    ("00", "não aplicável"),
    ("01", "Aberta"),
    ("02", "Fechada/Baú"),
    ("03", "Granelera"),
    ("04", "Porta Container"),
    ("05", "Sider"),
]

"Tipo de Rodado"
VEICTRACAO_TPROD = [
    ("01", "Truck"),
    ("02", "Toco"),
    ("03", "Cavalo Mecânico"),
    ("04", "VAN"),
    ("05", "Utilitário"),
    ("06", "Outros."),
]


class Rodo(models.AbstractModel):
    "Informações do modal Rodoviário"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.rodo"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Rodo"

    mdfe30_infANTT = fields.Many2one(
        comodel_name="mdfe.30.infantt",
        string="Grupo de informações",
        help="Grupo de informações para Agência Reguladora",
    )

    mdfe30_veicTracao = fields.Many2one(
        comodel_name="mdfe.30.veictracao",
        string="Dados do Veículo com a Tração",
        xsd_required=True,
    )

    mdfe30_veicReboque = fields.One2many(
        "mdfe.30.veicreboque", "mdfe30_veicReboque_rodo_id", string="Dados dos reboques"
    )

    mdfe30_codAgPorto = fields.Char(string="Código de Agendamento no porto")

    mdfe30_lacRodo = fields.One2many(
        "mdfe.30.lacrodo", "mdfe30_lacRodo_rodo_id", string="Lacres"
    )


class InfAntt(models.AbstractModel):
    "Grupo de informações para Agência Reguladora"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infantt"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Rodo.InfAntt"

    mdfe30_RNTRC = fields.Char(
        string="Registro Nacional",
        xsd_type="TRNTRC",
        help=(
            "Registro Nacional de Transportadores Rodoviários de "
            "Carga\nRegistro obrigatório do emitente do MDF-e junto à ANTT "
            "para exercer a atividade de transportador rodoviário de cargas "
            "por conta de terceiros e mediante remuneração."
        ),
    )

    mdfe30_infCIOT = fields.One2many(
        "mdfe.30.infciot", "mdfe30_infCIOT_infANTT_id", string="Dados do CIOT"
    )

    mdfe30_valePed = fields.Many2one(
        comodel_name="mdfe.30.valeped",
        string="Informações de Vale Pedágio",
        help=(
            "Informações de Vale Pedágio\nOutras informações sobre Vale-"
            "Pedágio obrigatório que não tenham campos específicos devem ser "
            "informadas no campo de observações gerais de uso livre pelo "
            "contribuinte, visando atender as determinações legais vigentes."
        ),
    )

    mdfe30_infContratante = fields.One2many(
        "mdfe.30.infcontratante",
        "mdfe30_infContratante_infANTT_id",
        string="Grupo de informações dos contratantes",
        help=("Grupo de informações dos contratantes do serviço de transporte"),
    )

    mdfe30_infPag = fields.One2many(
        "mdfe.30.rodo_infpag",
        "mdfe30_infPag_infANTT_id",
        string="Informações do Pagamento do Frete",
    )


class InfCiot(models.AbstractModel):
    "Dados do CIOT"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infciot"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Rodo.InfAntt.InfCiot"

    mdfe30_infCIOT_infANTT_id = fields.Many2one(
        comodel_name="mdfe.30.infantt", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_CIOT = fields.Char(
        string="Código Identificador da Operação",
        xsd_required=True,
        help=(
            "Código Identificador da Operação de Transporte\nTambém Conhecido "
            "como conta frete"
        ),
    )

    mdfe30_CPF = fields.Char(
        string="Número do CPF responsável pela geração",
        choice="infciot",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help=(
            "Número do CPF responsável pela geração do CIOT\nInformar os zeros"
            " não significativos."
        ),
    )

    mdfe30_CNPJ = fields.Char(
        string="Número do CNPJ responsável pela geração",
        choice="infciot",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ responsável pela geração do CIOT\nInformar os "
            "zeros não significativos."
        ),
    )


class ValePed(models.AbstractModel):
    """Informações de Vale Pedágio
    Outras informações sobre Vale-Pedágio obrigatório que não tenham campos
    específicos devem ser informadas no campo de observações gerais de uso
    livre pelo contribuinte, visando atender as determinações legais
    vigentes."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.valeped"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Rodo.InfAntt.ValePed"

    mdfe30_disp = fields.One2many(
        "mdfe.30.disp",
        "mdfe30_disp_valePed_id",
        string="Informações dos dispositivos",
        help="Informações dos dispositivos do Vale Pedágio",
    )

    mdfe30_categCombVeic = fields.Selection(
        VALEPED_CATEGCOMBVEIC,
        string="Categoria de Combinação Veicular",
        help=(
            "Categoria de Combinação Veicular\nPreencher com:\n\n02 Veículo "
            "Comercial 2 eixos;0\n4 Veículo Comercial 3 eixos;\n06 Veículo "
            "Comercial 4 eixos;0\n7 Veículo Comercial 5 eixos; 0\n8 Veículo "
            "Comercial 6 eixos;\n10 Veículo Comercial 7 eixos;\n11 Veículo "
            "Comercial 8 eixos;\n12 Veículo Comercial 9 eixos;\n13 Veículo "
            "Comercial 10 eixos;\n14 Veículo Comercial Acima de 10 eixos;"
        ),
    )


class Disp(models.AbstractModel):
    "Informações dos dispositivos do Vale Pedágio"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.disp"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Rodo.InfAntt.ValePed.Disp"

    mdfe30_disp_valePed_id = fields.Many2one(
        comodel_name="mdfe.30.valeped", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_CNPJForn = fields.Char(
        string="CNPJ da empresa fornecedora",
        xsd_required=True,
        help=(
            "CNPJ da empresa fornecedora do Vale-Pedágio\n- CNPJ da Empresa "
            "Fornecedora do Vale-Pedágio, ou seja, empresa que fornece ao "
            "Responsável pelo Pagamento do Vale-Pedágio os dispositivos do "
            "Vale-Pedágio.\n\t\t\t\t\t\t\t\t\t- Informar os zeros não "
            "significativos."
        ),
    )

    mdfe30_CNPJPg = fields.Char(
        string="CNPJ do responsável pelo pagamento",
        choice="disp",
        xsd_type="TCnpjOpc",
        help=(
            "CNPJ do responsável pelo pagamento do Vale-Pedágio\n- responsável"
            " pelo pagamento do Vale Pedágio. Informar somente quando o "
            "responsável não for o emitente do MDF-e.\n\t\t\t\t\t\t\t\t\t- "
            "Informar os zeros não significativos."
        ),
    )

    mdfe30_CPFPg = fields.Char(
        string="CPFPg",
        choice="disp",
        xsd_type="TCpf",
        help=(
            "CNPJ do responsável pelo pagamento do Vale-Pedágio\nInformar os "
            "zeros não significativos."
        ),
    )

    mdfe30_nCompra = fields.Char(
        string="Número do comprovante de compra",
        help=(
            "Número do comprovante de compra\nNúmero de ordem do comprovante "
            "de compra do Vale-Pedágio fornecido para cada veículo ou "
            "combinação veicular, por viagem."
        ),
    )

    mdfe30_vValePed = fields.Monetary(
        string="Valor do Vale-Pedagio",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor do Vale-Pedagio\nValor do Vale-Pedágio obrigatório "
            "necessário à livre circulação, desde a origem da operação de "
            "transporte até o destino, do transportador contratado."
        ),
    )

    mdfe30_tpValePed = fields.Selection(
        DISP_TPVALEPED,
        string="Tipo do Vale Pedagio",
        help="Tipo do Vale Pedagio\n01 - TAG; 02 - Cupom; 03 - Cartão",
    )


class InfContratante(models.AbstractModel):
    "Grupo de informações dos contratantes do serviço de transporte"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infcontratante"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Rodo.InfAntt.InfContratante"

    mdfe30_infContratante_infANTT_id = fields.Many2one(
        comodel_name="mdfe.30.infantt", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_xNome = fields.Char(string="Razão social ou Nome do contratante")

    mdfe30_CPF = fields.Char(
        string="Número do CPF do contratante do serviço",
        choice="infcontratante",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help=(
            "Número do CPF do contratante do serviço\nInformar os zeros não "
            "significativos."
        ),
    )

    mdfe30_CNPJ = fields.Char(
        string="Número do CNPJ do contratante do serviço",
        choice="infcontratante",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ do contratante do serviço\nInformar os zeros não "
            "significativos."
        ),
    )

    mdfe30_idEstrangeiro = fields.Char(
        string="Identificador do contratante em caso",
        choice="infcontratante",
        xsd_choice_required=True,
        help=("Identificador do contratante em caso de contratante estrangeiro"),
    )


class RodoInfPag(models.AbstractModel):
    "Informações do Pagamento do Frete"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.rodo_infpag"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Rodo.InfAntt.InfPag"

    mdfe30_infPag_infANTT_id = fields.Many2one(
        comodel_name="mdfe.30.infantt", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_xNome = fields.Char(
        string="Razão social ou Nome do respnsável",
        help="Razão social ou Nome do respnsável pelo pagamento",
    )

    mdfe30_CPF = fields.Char(
        string="Número do CPF do responsável pelo pgto",
        choice="infpag",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help=(
            "Número do CPF do responsável pelo pgto\nInformar os zeros não "
            "significativos."
        ),
    )

    mdfe30_CNPJ = fields.Char(
        string="Número do CNPJ do responsável pelo pgto",
        choice="infpag",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ do responsável pelo pgto\nInformar os zeros não "
            "significativos."
        ),
    )

    mdfe30_idEstrangeiro = fields.Char(
        string="Identificador do responsável pelo pgto",
        choice="infpag",
        xsd_choice_required=True,
        help=("Identificador do responsável pelo pgto em caso de ser estrangeiro"),
    )

    mdfe30_comp = fields.One2many(
        "mdfe.30.rodo_comp",
        "mdfe30_Comp_infPag_id",
        string="Componentes do Pagamentoi do Frete",
    )

    mdfe30_vContrato = fields.Monetary(
        string="Valor Total do Contrato",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    mdfe30_indAltoDesemp = fields.Selection(
        INFPAG_INDALTODESEMP,
        string="Indicador de operação de transporte",
        help=(
            "Indicador de operação de transporte de alto desempenho\nOperação "
            "de transporte com utilização de veículos de frotas dedicadas ou "
            "fidelizadas.\nPreencher com “1” para indicar operação de "
            "transporte de alto desempenho, demais casos não informar a tag"
        ),
    )

    mdfe30_indPag = fields.Selection(
        INFPAG_INDPAG,
        string="Indicador da Forma",
        xsd_required=True,
        help=(
            "Indicador da Forma de Pagamento:0-Pagamento à Vista;1-Pagamento à"
            " Prazo;"
        ),
    )

    mdfe30_vAdiant = fields.Monetary(
        string="Valor do Adiantamento",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="Valor do Adiantamento (usar apenas em pagamento à Prazo",
    )

    mdfe30_infPrazo = fields.One2many(
        "mdfe.30.rodo_infprazo",
        "mdfe30_infPrazo_infPag_id",
        string="Informações do pagamento a prazo",
        help=(
            "Informações do pagamento a prazo.\nInformar somente se indPag for"
            " à Prazo"
        ),
    )

    mdfe30_infBanc = fields.Many2one(
        comodel_name="mdfe.30.rodo_infbanc",
        string="Informações bancárias",
        xsd_required=True,
    )


class RodoComp(models.AbstractModel):
    "Componentes do Pagamentoi do Frete"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.rodo_comp"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Rodo.InfAntt.InfPag.Comp"

    mdfe30_Comp_infPag_id = fields.Many2one(
        comodel_name="mdfe.30.rodo_infpag", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_tpComp = fields.Selection(
        COMP_TPCOMP,
        string="Tipo do Componente",
        xsd_required=True,
        help=(
            "Tipo do Componente\nPreencher com: 01 - Vale Pedágio; \n02 - "
            "Impostos, taxas e contribuições; \n03 - Despesas (bancárias, "
            "meios de pagamento, outras)\n; 99 - Outros"
        ),
    )

    mdfe30_vComp = fields.Monetary(
        string="Valor do componente",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    mdfe30_xComp = fields.Char(string="Descrição do componente do tipo Outros")


class RodoInfPrazo(models.AbstractModel):
    """Informações do pagamento a prazo.
    Informar somente se indPag for à Prazo"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.rodo_infprazo"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Rodo.InfAntt.InfPag.InfPrazo"

    mdfe30_infPrazo_infPag_id = fields.Many2one(
        comodel_name="mdfe.30.rodo_infpag", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_nParcela = fields.Char(string="Número da Parcela", xsd_required=True)

    mdfe30_dVenc = fields.Date(
        string="Data de vencimento da Parcela",
        xsd_required=True,
        xsd_type="TData",
        help="Data de vencimento da Parcela (AAAA-MM-DD)",
    )

    mdfe30_vParcela = fields.Monetary(
        string="Valor da Parcela",
        xsd_required=True,
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )


class RodoInfBanc(models.AbstractModel):
    "Informações bancárias"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.rodo_infbanc"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Rodo.InfAntt.InfPag.InfBanc"

    mdfe30_codBanco = fields.Char(
        string="Número do banco", choice="infbanc", xsd_choice_required=True
    )

    mdfe30_codAgencia = fields.Char(
        string="Número da agência bancária", choice="infbanc", xsd_choice_required=True
    )

    mdfe30_CNPJIPEF = fields.Char(
        string="Número do CNPJ da Instituição",
        choice="infbanc",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ da Instituição de Pagamento Eletrônico do "
            "Frete\nInformar os zeros não significativos."
        ),
    )

    mdfe30_PIX = fields.Char(
        string="Chave PIX",
        choice="infbanc",
        xsd_choice_required=True,
        help=(
            "Chave PIX\nInformar a chave PIX para recebimento do frete. \nPode"
            " ser email, CPF/ CNPJ (somente numeros), Telefone com a seguinte "
            "formatação (+5599999999999) ou a chave aleatória gerada pela "
            "instituição."
        ),
    )


class VeicTracao(models.AbstractModel):
    "Dados do Veículo com a Tração"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.veictracao"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Rodo.VeicTracao"

    mdfe30_cInt = fields.Char(string="Código interno do veículo")

    mdfe30_placa = fields.Char(string="Placa do veículo", xsd_required=True)

    mdfe30_RENAVAM = fields.Char(string="RENAVAM do veículo")

    mdfe30_tara = fields.Char(string="Tara em KG", xsd_required=True)

    mdfe30_capKG = fields.Char(string="Capacidade em KG")

    mdfe30_capM3 = fields.Char(string="Capacidade em M3")

    mdfe30_prop = fields.Many2one(
        comodel_name="mdfe.30.veictracao_prop",
        string="Proprietário ou possuidor do Veículo",
        help=(
            "Proprietário ou possuidor do Veículo.\nSó preenchido quando o "
            "veículo não pertencer à empresa emitente do MDF-e"
        ),
    )

    mdfe30_condutor = fields.One2many(
        "mdfe.30.rodo_condutor",
        "mdfe30_condutor_veicTracao_id",
        string="Informações do(s) Condutor(es)",
        help="Informações do(s) Condutor(es) do veículo",
    )

    mdfe30_tpRod = fields.Selection(
        VEICTRACAO_TPROD,
        string="Tipo de Rodado",
        xsd_required=True,
        help=(
            "Tipo de Rodado\nPreencher com:\n\t\t\t\t\t\t\t\t\t01 - "
            "Truck;\n\t\t\t\t\t\t\t\t\t02 - Toco;\n\t\t\t\t\t\t\t\t\t03 - "
            "Cavalo Mecânico;\n\t\t\t\t\t\t\t\t\t04 - "
            "VAN;\n\t\t\t\t\t\t\t\t\t05 - Utilitário;\n\t\t\t\t\t\t\t\t\t06 - "
            "Outros."
        ),
    )

    mdfe30_tpCar = fields.Selection(
        VEICTRACAO_TPCAR,
        string="Tipo de Carroceria",
        xsd_required=True,
        help=(
            "Tipo de Carroceria\nPreencher com:\n\t\t\t\t\t\t\t\t\t00 - não "
            "aplicável;\n\t\t\t\t\t\t\t\t\t01 - Aberta;\n\t\t\t\t\t\t\t\t\t02 "
            "- Fechada/Baú;\n\t\t\t\t\t\t\t\t\t03 - "
            "Granelera;\n\t\t\t\t\t\t\t\t\t04 - Porta "
            "Container;\n\t\t\t\t\t\t\t\t\t05 - Sider"
        ),
    )

    mdfe30_UF = fields.Selection(
        TUF,
        string="UF em que veículo está licenciado",
        xsd_type="TUf",
        help=(
            "UF em que veículo está licenciado\nSigla da UF de licenciamento "
            "do veículo."
        ),
    )


class VeicTracaoProp(models.AbstractModel):
    """Proprietário ou possuidor do Veículo.
    Só preenchido quando o veículo não pertencer à empresa emitente do MDF-e"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.veictracao_prop"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Rodo.VeicTracao.Prop"

    mdfe30_CPF = fields.Char(
        string="Número do CPF",
        choice="prop",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="Número do CPF\nInformar os zeros não significativos.",
    )

    mdfe30_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="prop",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help="Número do CNPJ\nInformar os zeros não significativos.",
    )

    mdfe30_RNTRC = fields.Char(
        string="Registro Nacional",
        xsd_required=True,
        xsd_type="TRNTRC",
        help=(
            "Registro Nacional dos Transportadores Rodoviários de "
            "Carga\nRegistro obrigatório do proprietário, co-proprietário ou "
            "arrendatário do veículo junto à ANTT para exercer a atividade de "
            "transportador rodoviário de cargas por conta de terceiros e "
            "mediante remuneração."
        ),
    )

    mdfe30_xNome = fields.Char(
        string="Razão Social ou Nome do proprietário", xsd_required=True
    )

    mdfe30_IE = fields.Char(string="Inscrição Estadual")

    mdfe30_UF = fields.Selection(TUF, string="UF", xsd_type="TUf")

    mdfe30_tpProp = fields.Selection(
        PROP_TPPROP,
        string="Tipo Proprietário ou possuidor",
        xsd_required=True,
        help=(
            "Tipo Proprietário ou possuidor\nPreencher "
            "com:\n\t\t\t\t\t\t\t\t\t\t\t\t0-TAC "
            "Agregado;\n\t\t\t\t\t\t\t\t\t\t\t\t1-TAC Independente; "
            "\n\t\t\t\t\t\t\t\t\t\t\t\t2 – Outros."
        ),
    )


class RodoCondutor(models.AbstractModel):
    "Informações do(s) Condutor(es) do veículo"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.rodo_condutor"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Rodo.VeicTracao.Condutor"

    mdfe30_condutor_veicTracao_id = fields.Many2one(
        comodel_name="mdfe.30.veictracao", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_xNome = fields.Char(string="Nome do Condutor", xsd_required=True)

    mdfe30_CPF = fields.Char(
        string="CPF do Condutor", xsd_required=True, xsd_type="TCpf"
    )


class VeicReboque(models.AbstractModel):
    "Dados dos reboques"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.veicreboque"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Rodo.VeicReboque"

    mdfe30_veicReboque_rodo_id = fields.Many2one(
        comodel_name="mdfe.30.rodo", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_cInt = fields.Char(string="Código interno do veículo")

    mdfe30_placa = fields.Char(string="Placa do veículo", xsd_required=True)

    mdfe30_RENAVAM = fields.Char(string="RENAVAM do veículo")

    mdfe30_tara = fields.Char(string="Tara em KG", xsd_required=True)

    mdfe30_capKG = fields.Char(string="Capacidade em KG", xsd_required=True)

    mdfe30_capM3 = fields.Char(string="Capacidade em M3")

    mdfe30_prop = fields.Many2one(
        comodel_name="mdfe.30.veicreboque_prop",
        string="Proprietários ou possuidor do Veículo",
        help=(
            "Proprietários ou possuidor do Veículo.\nSó preenchido quando o "
            "veículo não pertencer à empresa emitente do MDF-e"
        ),
    )

    mdfe30_tpCar = fields.Selection(
        VEICREBOQUE_TPCAR,
        string="Tipo de Carroceria",
        xsd_required=True,
        help=(
            "Tipo de Carroceria\nPreencher com:\n\t\t\t\t\t\t\t\t\t00 - não "
            "aplicável;\n\t\t\t\t\t\t\t\t\t01 - Aberta;\n\t\t\t\t\t\t\t\t\t02 "
            "- Fechada/Baú;\n\t\t\t\t\t\t\t\t\t03 - "
            "Granelera;\n\t\t\t\t\t\t\t\t\t04 - Porta "
            "Container;\n\t\t\t\t\t\t\t\t\t05 - Sider"
        ),
    )

    mdfe30_UF = fields.Selection(
        TUF,
        string="UF em que veículo está licenciado",
        xsd_type="TUf",
        help=(
            "UF em que veículo está licenciado\nSigla da UF de licenciamento "
            "do veículo."
        ),
    )


class VeicReboqueProp(models.AbstractModel):
    """Proprietário ou possuidor do Veículo.
    Só preenchido quando o veículo não pertencer à empresa emitente do MDF-e"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.veicreboque_prop"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Rodo.VeicReboque.Prop"

    mdfe30_CPF = fields.Char(
        string="Número do CPF",
        choice="prop",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="Número do CPF\nInformar os zeros não significativos.",
    )

    mdfe30_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="prop",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help="Número do CNPJ\nInformar os zeros não significativos.",
    )

    mdfe30_RNTRC = fields.Char(
        string="Registro Nacional",
        xsd_required=True,
        xsd_type="TRNTRC",
        help=(
            "Registro Nacional dos Transportadores Rodoviários de "
            "Carga\nRegistro obrigatório do proprietário, co-proprietário ou "
            "arrendatário do veículo junto à ANTT para exercer a atividade de "
            "transportador rodoviário de cargas por conta de terceiros e "
            "mediante remuneração."
        ),
    )

    mdfe30_xNome = fields.Char(
        string="Razão Social ou Nome do proprietário", xsd_required=True
    )

    mdfe30_IE = fields.Char(string="Inscrição Estadual")

    mdfe30_UF = fields.Selection(TUF, string="UF", xsd_type="TUf")

    mdfe30_tpProp = fields.Selection(
        PROP_TPPROP,
        string="Tipo Proprietário ou possuidor",
        xsd_required=True,
        help=(
            "Tipo Proprietário ou possuidor\nPreencher "
            "com:\n\t\t\t\t\t\t\t\t\t\t\t\t0-TAC "
            "Agregado;\n\t\t\t\t\t\t\t\t\t\t\t\t1-TAC Independente;  "
            "\n\t\t\t\t\t\t\t\t\t\t\t\t2 – Outros."
        ),
    )


class LacRodo(models.AbstractModel):
    "Lacres"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.lacrodo"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Rodo.LacRodo"

    mdfe30_lacRodo_rodo_id = fields.Many2one(
        comodel_name="mdfe.30.rodo", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_nLacre = fields.Char(string="Número do Lacre", xsd_required=True)
