# -*- coding: utf-8 -*-
##############################################################################
#
#    Author: Dave Lasley <dave@laslabs.com>
#    Copyright: 2015 LasLabs, Inc.
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from openerp import fields, models


class MedicalMedicamentAttributeAbstract(models.AbstractModel):
    _name = 'medical.medicament.attribute.abstract'
    name = fields.Char(
        help="Full Name of Attribute"
    )
    code = fields.Char(
        help="Short Code of Attribute"
    )
    _sql_constraints = [
        ('code_uniq', 'UNIQUE(code)', 'Attribute code must be unique.'),
        ('name_uniq', 'UNIQUE(name)', 'Attribute name must be unique.'),
    ]
