# @ 2020 KMEE INFORMATICA LTDA - www.kmee.com.br -
#   Gabriel Cardoso de Faria <gabriel.cardoso@kmee.com.br>
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl.html).

import logging
import os
from datetime import datetime

from xmldiff import main

from odoo.tests.common import TransactionCase
from odoo.tools import config

from odoo.addons import l10n_br_nfe
from odoo.addons.spec_driven_model import hooks

_logger = logging.getLogger(__name__)


class TestNFeExport(TransactionCase):
    def setUp(self, nfe_list):
        super(TestNFeExport, self).setUp()
        hooks.register_hook(
            self.env,
            "l10n_br_nfe",
            "odoo.addons.l10n_br_nfe_spec.models.v4_0.leiaute_nfe_v4_00",
        )
        self.nfe_list = nfe_list
        for nfe_data in self.nfe_list:
            nfe = self.env.ref(nfe_data["record_ref"])
            nfe_data["nfe"] = nfe
            self.prepare_test_nfe(nfe)

    def prepare_test_nfe(self, nfe):
        """
        Performs actions necessary to prepare an NFe of the demo data to
        perform the tests
        """
        if nfe.state != "em_digitacao":  # 2nd test run
            nfe.action_document_back2draft()

        for line in nfe.line_ids:
            line._onchange_product_id_fiscal()
            line._onchange_fiscal_operation_id()
            line._onchange_fiscal_operation_line_id()

        nfe._compute_amount()
        financial_vals = nfe._prepare_amount_financial(
            "0", "01", nfe.amount_financial_total
        )
        nfe.nfe40_detPag = [(5, 0, 0), (0, 0, financial_vals)]
        nfe.action_document_confirm()
        nfe.document_date = datetime.strptime(
            "2020-01-01T11:00:00", "%Y-%m-%dT%H:%M:%S"
        )
        nfe.date_in_out = datetime.strptime("2020-01-01T11:00:00", "%Y-%m-%dT%H:%M:%S")
        nfe.nfe40_cNF = "06277716"
        nfe.with_context(lang="pt_BR")._document_export()

    def serialize_xml(self, nfe_data):
        for nfe in self.nfe_list:
            nfe = nfe_data["nfe"]
            xml_path = os.path.join(
                l10n_br_nfe.__path__[0],
                "tests",
                "nfe",
                "v4_00",
                "leiauteNFe",
                nfe_data["xml_file"],
            )
            output = os.path.join(
                config["data_dir"],
                "filestore",
                self.cr.dbname,
                nfe.send_file_id.store_fname,
            )
            _logger.info("XML file saved at %s" % (output,))
            nfe.company_id.country_id.name = "Brazil"  # clean mess
            diff = main.diff_files(output, xml_path)
            return diff
