# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

from .leiaute_cons_sit_nfe_v4_00 import TprotNfe
from .tipos_basico_v4_00 import (
    TAMB,
    TCODUFIBGE,
    TMOD,
    TUF,
    TUFEMI,
)

__NAMESPACE__ = "http://www.portalfiscal.inf.br/nfe"

"Código de Situação Tributária do COFINS"
COFINSALIQ_CST = [
    (
        "01",
        "Operação Tributável - Base de Cálculo = Valor da Operação Alíquota Normal (Cumulativo/Não Cumulativo)",
    ),
    (
        "02",
        "Operação Tributável - Base de Calculo = Valor da Operação (Alíquota Diferenciada)",
    ),
]

"Código de Situação Tributária do COFINS"
COFINSNT_CST = [
    ("04", "Operação Tributável - Tributação Monofásica - (Alíquota Zero)"),
    ("05", "Operação Tributável (ST)"),
    ("06", "Operação Tributável - Alíquota Zero"),
    ("07", "Operação Isenta da contribuição"),
    ("08", "Operação Sem Incidência da contribuição"),
    ("09", "Operação com suspensão da contribuição"),
]

"Código de Situação Tributária do COFINS"
COFINSOUTR_CST = [
    ("49", "Outras Operações de Saída"),
    (
        "50",
        "Operação com Direito a Crédito - Vinculada Exclusivamente a Receita Tributada no Mercado Interno",
    ),
    (
        "51",
        "Operação com Direito a Crédito – Vinculada Exclusivamente a Receita Não Tributada no Mercado Interno",
    ),
    (
        "52",
        "Operação com Direito a Crédito - Vinculada Exclusivamente a Receita de Exportação",
    ),
    (
        "53",
        "Operação com Direito a Crédito - Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno",
    ),
    (
        "54",
        "Operação com Direito a Crédito - Vinculada a Receitas Tributadas no Mercado Interno e de Exportação",
    ),
    (
        "55",
        "Operação com Direito a Crédito - Vinculada a Receitas Não-Tributadas no Mercado Interno e de Exportação",
    ),
    (
        "56",
        "Operação com Direito a Crédito - Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno, e de Exportação",
    ),
    (
        "60",
        "Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a Receita Tributada no Mercado Interno",
    ),
    (
        "61",
        "Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a Receita Não-Tributada no Mercado Interno",
    ),
    (
        "62",
        "Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a Receita de Exportação",
    ),
    (
        "63",
        "Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno",
    ),
    (
        "64",
        "Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas no Mercado Interno e de Exportação",
    ),
    (
        "65",
        "Crédito Presumido - Operação de Aquisição Vinculada a Receitas Não-Tributadas no Mercado Interno e de Exportação",
    ),
    (
        "66",
        "Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno, e de Exportação",
    ),
    ("67", "Crédito Presumido - Outras Operações"),
    ("70", "Operação de Aquisição sem Direito a Crédito"),
    ("71", "Operação de Aquisição com Isenção"),
    ("72", "Operação de Aquisição com Suspensão"),
    ("73", "Operação de Aquisição a Alíquota Zero"),
    ("74", "Operação de Aquisição sem Incidência da Contribuição"),
    ("75", "Operação de Aquisição por Substituição Tributária"),
    ("98", "Outras Operações de Entrada"),
    ("99", "Outras Operações."),
]

"Código de Situação Tributária do COFINS"
COFINSQTDE_CST = [
    (
        "03",
        "Operação Tributável - Base de Calculo = Quantidade Vendida x Alíquota por Unidade de Produto",
    ),
]

"Indica se o valor da COFINS ST compõe o valor total da NFe"
COFINSST_INDSOMACOFINSST = [
    ("0", "0"),
    ("1", "1"),
]

"Forma de Importação quanto a intermediação"
DI_TPINTERMEDIO = [
    ("1", "por conta propria"),
    ("2", "por conta e ordem"),
    ("3", "encomenda"),
]

"""Via de transporte internacional informada na DI ou na Declaração Única
    de Importação"""
DI_TPVIATRANSP = [
    ("1", "Maritima"),
    ("2", "Fluvial"),
    ("3", "Lacustre"),
    ("4", "Aerea"),
    ("5", "Postal"),
    ("6", "Ferroviaria"),
    ("7", "Rodoviaria"),
    ("8", "Conduto"),
    ("9", "Meios Proprios"),
    ("10", "Entrada/Saida Ficta"),
    ("11", "Courier"),
    ("12", "Em maos"),
    ("13", "Por reboque."),
]

"Tributção pelo ICMS"
ICMS00_CST = [
    ("00", "Tributada integralmente"),
]

"Modalidade de determinação da BC do ICMS"
ICMS00_MODBC = [
    ("0", "Margem Valor Agregado (%)"),
    ("1", "Pauta (valor)"),
    ("2", "Preço Tabelado Máximo (valor)"),
    ("3", "Valor da Operação."),
]

"""Tributção pelo ICMS
    02= Tributação monofásica própria sobre combustíveis;"""
ICMS02_CST = [
    ("02", "02"),
]

"CST"
ICMS10_CST = [
    ("10", "Tributada e com cobrança do ICMS por substituição tributária"),
]

"Modalidade de determinação da BC do ICMS"
ICMS10_MODBC = [
    ("0", "Margem Valor Agregado (%)"),
    ("1", "Pauta (valor)"),
    ("2", "Preço Tabelado Máximo (valor)"),
    ("3", "Valor da Operação."),
]

"Modalidade de determinação da BC do ICMS ST"
ICMS10_MODBCST = [
    ("0", "Preço tabelado ou máximo  sugerido"),
    ("1", "Lista Negativa (valor)"),
    ("2", "Lista Positiva (valor)"),
    ("3", "Lista Neutra (valor)"),
    ("4", "Margem Valor Agregado (%)"),
    ("5", "Pauta (valor)"),
    ("6", "Valor da Operação"),
]

"Motivo da desoneração do ICMS-ST"
ICMS10_MOTDESICMSST = [
    ("3", "Uso na agropecuária"),
    ("9", "Outros"),
    ("12", "Fomento agropecuário."),
]

"""Tributção pelo ICMS
    15= Tributação monofásica própria e com responsabilidade pela retenção sobre
    combustíveis;"""
ICMS15_CST = [
    ("15", "15"),
]

"""Motivo da redução do adrem
    1= Transporte coletivo de passageiros; 9=Outros;"""
ICMS15_MOTREDADREM = [
    ("1", "1"),
    ("9", "9"),
]

"Tributção pelo ICMS"
ICMS20_CST = [
    ("20", "Com redução de base de cálculo"),
]

"""Indica se o valor do ICMS desonerado (vICMSDeson) deduz do valor do item
    (vProd):
    0=Valor do ICMS desonerado (vICMSDeson) não deduz do valor do item (vProd) /
    total da NF-e;
    1=Valor do ICMS desonerado (vICMSDeson) deduz do valor do item (vProd) / total
    da NF-e."""
ICMS20_INDDEDUZDESON = [
    ("0", "0"),
    ("1", "1"),
]

"Modalidade de determinação da BC do ICMS"
ICMS20_MODBC = [
    ("0", "Margem Valor Agregado (%)"),
    ("1", "Pauta (valor)"),
    ("2", "Preço Tabelado Máximo (valor)"),
    ("3", "Valor da Operação."),
]

"Motivo da desoneração do ICMS"
ICMS20_MOTDESICMS = [
    ("3", "Uso na agropecuária"),
    ("9", "Outros"),
    ("12", "Fomento agropecuário"),
]

"Tributção pelo ICMS"
ICMS30_CST = [
    (
        "30",
        "Isenta ou não tributada e com cobrança do ICMS por substituição tributária",
    ),
]

"""Indica se o valor do ICMS desonerado (vICMSDeson) deduz do valor do item
    (vProd):
    0=Valor do ICMS desonerado (vICMSDeson) não deduz do valor do item (vProd) /
    total da NF-e;
    1=Valor do ICMS desonerado (vICMSDeson) deduz do valor do item (vProd) / total
    da NF-e."""
ICMS30_INDDEDUZDESON = [
    ("0", "0"),
    ("1", "1"),
]

"Modalidade de determinação da BC do ICMS ST"
ICMS30_MODBCST = [
    ("0", "Preço tabelado ou máximo  sugerido"),
    ("1", "Lista Negativa (valor)"),
    ("2", "Lista Positiva (valor)"),
    ("3", "Lista Neutra (valor)"),
    ("4", "Margem Valor Agregado (%)"),
    ("5", "Pauta (valor)."),
    ("6", "Valor da Operação"),
]

"Motivo da desoneração do ICMS"
ICMS30_MOTDESICMS = [
    ("6", "Utilitários Motocicleta AÁrea Livre"),
    ("7", "SUFRAMA"),
    ("9", "Outros"),
]

"Tributação pelo ICMS"
ICMS40_CST = [
    ("40", "Isenta "),
    ("41", "Não tributada "),
    ("50", "Suspensão "),
]

"""Indica se o valor do ICMS desonerado (vICMSDeson) deduz do valor do item
    (vProd):
    0=Valor do ICMS desonerado (vICMSDeson) não deduz do valor do item (vProd) /
    total da NF-e;
    1=Valor do ICMS desonerado (vICMSDeson) deduz do valor do item (vProd) / total
    da NF-e."""
ICMS40_INDDEDUZDESON = [
    ("0", "0"),
    ("1", "1"),
]

"""Este campo será preenchido quando o campo anterior estiver preenchido"""
ICMS40_MOTDESICMS = [
    ("1", " Deficiente não condutor"),
    ("3", "Produtor Agropecuário"),
    ("4", "Frotista/Locadora"),
    ("5", "Diplomático/Consular"),
    ("6", "Olimpíadas Rio 2016"),
    ("7", "SUFRAMA"),
    ("8", "Venda a órgão Público"),
    ("9", "Outros"),
    ("10", " Deficiente Condutor"),
    ("11", " Deficiente não condutor"),
    ("16", "Olimpíadas Rio 2016"),
    ("90", "Solicitado pelo Fisco"),
]

"Tributação pelo ICMS"
ICMS51_CST = [
    ("51", "Tributação com Diferimento"),
]

"Modalidade de determinação da BC do ICMS"
ICMS51_MODBC = [
    ("0", "Margem Valor Agregado (%)"),
    ("1", "Pauta (valor)"),
    ("2", "Preço Tabelado Máximo (valor)"),
    ("3", "Valor da Operação."),
]

"""Tributção pelo ICMS
    53= Tributação monofásica sobre combustíveis com recolhimento diferido;"""
ICMS53_CST = [
    ("53", "53"),
]

"Tributação pelo ICMS"
ICMS60_CST = [
    ("60", "ICMS cobrado anteriormente por substituição tributária"),
]

"""Tributção pelo ICMS
    61= Tributação monofásica sobre combustíveis cobrada anteriormente"""
ICMS61_CST = [
    ("61", "61"),
]

"Tributção pelo ICMS"
ICMS70_CST = [
    (
        "70",
        "Com redução de base de cálculo e cobrança do ICMS por substituição tributária",
    ),
]

"""Indica se o valor do ICMS desonerado (vICMSDeson) deduz do valor do item
    (vProd):
    0=Valor do ICMS desonerado (vICMSDeson) não deduz do valor do item (vProd) /
    total da NF-e;
    1=Valor do ICMS desonerado (vICMSDeson) deduz do valor do item (vProd) / total
    da NF-e."""
ICMS70_INDDEDUZDESON = [
    ("0", "0"),
    ("1", "1"),
]

"Modalidade de determinação da BC do ICMS"
ICMS70_MODBC = [
    ("0", "Margem Valor Agregado (%)"),
    ("1", "Pauta (valor)"),
    ("2", "Preço Tabelado Máximo (valor)"),
    ("3", "Valor da Operação."),
]

"Modalidade de determinação da BC do ICMS ST"
ICMS70_MODBCST = [
    ("0", "Preço tabelado ou máximo  sugerido"),
    ("1", "Lista Negativa (valor)"),
    ("2", "Lista Positiva (valor)"),
    ("3", "Lista Neutra (valor)"),
    ("4", "Margem Valor Agregado (%)"),
    ("5", "Pauta (valor)"),
    ("6", "Valor da Operação."),
]

"Motivo da desoneração do ICMS"
ICMS70_MOTDESICMS = [
    ("3", "Uso na agropecuária"),
    ("9", "Outros"),
    ("12", "Fomento agropecuário"),
]

"Motivo da desoneração do ICMS-ST"
ICMS70_MOTDESICMSST = [
    ("3", "Uso na agropecuária"),
    ("9", "Outros"),
    ("12", "Fomento agropecuário."),
]

"Tributção pelo ICMS"
ICMS90_CST = [
    ("90", "Outras"),
]

"""Indica se o valor do ICMS desonerado (vICMSDeson) deduz do valor do item
    (vProd):
    0=Valor do ICMS desonerado (vICMSDeson) não deduz do valor do item (vProd) /
    total da NF-e;
    1=Valor do ICMS desonerado (vICMSDeson) deduz do valor do item (vProd) / total
    da NF-e."""
ICMS90_INDDEDUZDESON = [
    ("0", "0"),
    ("1", "1"),
]

"Modalidade de determinação da BC do ICMS"
ICMS90_MODBC = [
    ("0", "Margem Valor Agregado (%)"),
    ("1", "Pauta (valor)"),
    ("2", "Preço Tabelado Máximo (valor)"),
    ("3", "Valor da Operação."),
]

"Modalidade de determinação da BC do ICMS ST"
ICMS90_MODBCST = [
    ("0", "Preço tabelado ou máximo  sugerido"),
    ("1", "Lista Negativa (valor)"),
    ("2", "Lista Positiva (valor)"),
    ("3", "Lista Neutra (valor)"),
    ("4", "Margem Valor Agregado (%)"),
    ("5", "Pauta (valor)"),
    ("6", "Valor da Operação."),
]

"Motivo da desoneração do ICMS"
ICMS90_MOTDESICMS = [
    ("3", "Uso na agropecuária"),
    ("9", "Outros"),
    ("12", "Fomento agropecuário"),
]

"Motivo da desoneração do ICMS-ST"
ICMS90_MOTDESICMSST = [
    ("3", "Uso na agropecuária"),
    ("9", "Outros"),
    ("12", "Fomento agropecuário."),
]

"Tributação pelo ICMS"
ICMSPART_CST = [
    ("10", "Tributada e com cobrança do ICMS por substituição tributária"),
    ("90", "Outros."),
]

"Modalidade de determinação da BC do ICMS"
ICMSPART_MODBC = [
    ("0", "Margem Valor Agregado (%)"),
    ("1", "Pauta (valor)"),
    ("2", "Preço Tabelado Máximo (valor)"),
    ("3", "Valor da Operação."),
]

"Modalidade de determinação da BC do ICMS ST"
ICMSPART_MODBCST = [
    ("0", "Preço tabelado ou máximo  sugerido"),
    ("1", "Lista Negativa (valor)"),
    ("2", "Lista Positiva (valor)"),
    ("3", "Lista Neutra (valor)"),
    ("4", "Margem Valor Agregado (%)"),
    ("5", "Pauta (valor)."),
    ("6", "Valor da Operação"),
]

"CSOSN"
ICMSSN101_CSOSN = [
    (
        "101",
        " Tributada pelo Simples Nacional com permissão de crédito. (v.2.0)",
    ),
]

"CSOSN"
ICMSSN102_CSOSN = [
    ("102", " Tributada pelo Simples Nacional sem permissão de crédito. "),
    (
        "103",
        "Isenção do ICMS  no Simples Nacional para faixa de receita bruta.",
    ),
    ("300", "Imune."),
    ("400", "Não tributda pelo Simples Nacional (v.2.0) (v.2.0)"),
]

"CSOSN"
ICMSSN201_CSOSN = [
    (
        "201",
        " Tributada pelo Simples Nacional com permissão de crédito e com cobrança do ICMS por Substituição Tributária (v.2.0)",
    ),
]

"Modalidade de determinação da BC do ICMS ST"
ICMSSN201_MODBCST = [
    ("0", "Preço tabelado ou máximo  sugerido"),
    ("1", "Lista Negativa (valor)"),
    ("2", "Lista Positiva (valor)"),
    ("3", "Lista Neutra (valor)"),
    ("4", "Margem Valor Agregado (%)"),
    ("5", "Pauta (valor). (v2.0)"),
    ("6", "Valor da Operação"),
]

"CSOSN"
ICMSSN202_CSOSN = [
    (
        "202",
        " Tributada pelo Simples Nacional sem permissão de crédito e com cobrança do ICMS por Substituição Tributária",
    ),
    (
        "203",
        "  Isenção do ICMS nos Simples Nacional para faixa de receita bruta e com cobrança do ICMS por Substituição Tributária (v.2.0)",
    ),
]

"Modalidade de determinação da BC do ICMS ST"
ICMSSN202_MODBCST = [
    ("0", "Preço tabelado ou máximo  sugerido"),
    ("1", "Lista Negativa (valor)"),
    ("2", "Lista Positiva (valor)"),
    ("3", "Lista Neutra (valor)"),
    ("4", "Margem Valor Agregado (%)"),
    ("5", "Pauta (valor). (v2.0)"),
    ("6", "Valor da Operação"),
]

"CSOSN"
ICMSSN500_CSOSN = [
    (
        "500",
        "ICMS cobrado anterirmente por substituição tributária (substituído) ou por antecipação",
    ),
]

"Tributação pelo ICMS"
ICMSSN900_CSOSN = [
    ("900", "Outros(v2.0)"),
]

"Modalidade de determinação da BC do ICMS"
ICMSSN900_MODBC = [
    ("0", "Margem Valor Agregado (%)"),
    ("1", "Pauta (valor)"),
    ("2", "Preço Tabelado Máximo (valor)"),
    ("3", "Valor da Operação."),
]

"Modalidade de determinação da BC do ICMS ST"
ICMSSN900_MODBCST = [
    ("0", "Preço tabelado ou máximo  sugerido"),
    ("1", "Lista Negativa (valor)"),
    ("2", "Lista Positiva (valor)"),
    ("3", "Lista Neutra (valor)"),
    ("4", "Margem Valor Agregado (%)"),
    ("5", "Pauta (valor)."),
    ("6", "Valor da Operação"),
]

"Tributção pelo ICMS"
ICMSST_CST = [
    ("41", "Não Tributado."),
    ("60", "Cobrado anteriormente por substituição tributária."),
]

"""Alíquota interestadual das UF envolvidas: - 4% alíquota interestadual
    para produtos importados; - 7% para os Estados de origem do Sul e
    Sudeste (exceto ES), destinado para os Estados do Norte e Nordeste ou
    ES; - 12% para os demais casos."""
ICMSUFDEST_PICMSINTER = [
    ("4.00", "4.00"),
    ("7.00", "7.00"),
    ("12.00", "12.00"),
]

"Código da Situação Tributária do IPI"
IPINT_CST = [
    ("01", "Entrada tributada com alíquota zero"),
    ("02", "Entrada isenta"),
    ("03", "Entrada não-tributada"),
    ("04", "Entrada imune"),
    ("05", "Entrada com suspensão"),
    ("51", "Saída tributada com alíquota zero"),
    ("52", "Saída isenta"),
    ("53", "Saída não-tributada"),
    ("54", "Saída imune"),
    ("55", "Saída com suspensão"),
]

"Código da Situação Tributária do IPI"
IPITRIB_CST = [
    ("00", "Entrada com recuperação de crédito"),
    ("49", "Outras entradas"),
    ("50", "Saída tributada"),
    ("99", "Outras saídas"),
]

"Exibilidade do ISS"
ISSQN_INDISS = [
    ("1", "Exigível"),
    ("2", "Não incidente"),
    ("3", "Isenção"),
    ("4", "Exportação"),
    ("5", "Imunidade"),
    ("6", "Exig.Susp. Judicial"),
    ("7", "Exig.Susp. ADM"),
]

"Indicador de Incentivo Fiscal. 1=Sim; 2=Não"
ISSQN_INDINCENTIVO = [
    ("1", "1"),
    ("2", "2"),
]

"Código do regime especial de tributação"
ISSQNTOT_CREGTRIB = [
    ("1", "1"),
    ("2", "2"),
    ("3", "3"),
    ("4", "4"),
    ("5", "5"),
    ("6", "6"),
]

"Código de Situação Tributária do PIS"
PISALIQ_CST = [
    (
        "01",
        "Operação Tributável - Base de Cálculo = Valor da Operação Alíquota Normal (Cumulativo/Não Cumulativo)",
    ),
    (
        "02",
        "Operação Tributável - Base de Calculo = Valor da Operação (Alíquota Diferenciada)",
    ),
]

"Código de Situação Tributária do PIS"
PISNT_CST = [
    ("04", "Operação Tributável - Tributação Monofásica - (Alíquota Zero)"),
    ("05", "Operação Tributável (ST)"),
    ("06", "Operação Tributável - Alíquota Zero"),
    ("07", "Operação Isenta da contribuição"),
    ("08", "Operação Sem Incidência da contribuição"),
    ("09", "Operação com suspensão da contribuição"),
]

"""Código de Situação Tributária do PIS.
    99 - Outras Operações."""
PISOUTR_CST = [
    ("49", "49"),
    ("50", "50"),
    ("51", "51"),
    ("52", "52"),
    ("53", "53"),
    ("54", "54"),
    ("55", "55"),
    ("56", "56"),
    ("60", "60"),
    ("61", "61"),
    ("62", "62"),
    ("63", "63"),
    ("64", "64"),
    ("65", "65"),
    ("66", "66"),
    ("67", "67"),
    ("70", "70"),
    ("71", "71"),
    ("72", "72"),
    ("73", "73"),
    ("74", "74"),
    ("75", "75"),
    ("98", "98"),
    ("99", "Outras Operações."),
]

"Código de Situação Tributária do PIS"
PISQTDE_CST = [
    (
        "03",
        "Operação Tributável - Base de Calculo = Quantidade Vendida x Alíquota por Unidade de Produto",
    ),
]

"Indica se o valor do PISST compõe o valor total da NF-e"
PISST_INDSOMAPISST = [
    ("0", "0"),
    ("1", "1"),
]

"Código do país"
TENDEREMI_CPAIS = [
    ("1058", "1058"),
]

"Nome do país"
TENDEREMI_XPAIS = [
    ("Brasil", "Brasil"),
    # ("BRASIL", "BRASIL"),
]

"Indicador de processamento síncrono. 0=NÃO; 1=SIM=Síncrono"
TENVINFE_INDSINC = [
    ("0", "0"),
    ("1", "1"),
]

"""Tipo Finalidade da NF-e (1=Normal; 2=Complementar; 3=Ajuste;
    4=Devolução/Retorno)"""
TFINNFE = [
    ("1", "1"),
    ("2", "2"),
    ("3", "3"),
    ("4", "4"),
]

"Tipo processo de emissão da NF-e"
TPROCEMI = [
    ("0", "0"),
    ("1", "1"),
    ("2", "2"),
    ("3", "3"),
]

"""Tipo Origem da mercadoria CST ICMS origem da mercadoria: 0-Nacional
    exceto as indicadas nos códigos 3, 4, 5 e 8;1-Estrangeira - Importação
    direta; 2-Estrangeira - Adquirida no mercado interno; 3-Nacional,
    conteudo superior 40% e inferior ou igual a 70%; 4-Nacional, processos
    produtivos básicos; 5-Nacional, conteudo inferior 40%; 6-Estrangeira -
    Importação direta, com similar nacional, lista CAMEX; 7-Estrangeira -
    mercado interno, sem simular,lista CAMEX;8-Nacional, Conteúdo de
    Importação superior a 70%."""
TORIG = [
    ("0", "0"),
    ("1", "1"),
    ("2", "2"),
    ("3", "3"),
    ("4", "4"),
    ("5", "5"),
    ("6", "6"),
    ("7", "7"),
    ("8", "8"),
]

"Indicador do tipo de arma de fogo"
ARMA_TPARMA = [
    ("0", "Uso permitido"),
    ("1", "Uso restrito)"),
]

"""Tipo de Integração do processo de pagamento com o sistema de automação
    da empresa"""
CARD_TPINTEGRA = [
    (
        "1",
        "Pagamento integrado com o sistema de automação da empresa (Ex.: equipamento TEF, Comércio Eletrônico, POS Integrado)",
    ),
    (
        "2",
        "Pagamento não integrado com o sistema de automação da empresa (Ex.: equipamento POS Simples).",
    ),
]

"Indicador da IE do destinatário"
DEST_INDIEDEST = [
    ("1", "Contribuinte ICMSpagamento à vista"),
    ("2", "Contribuinte isento de inscrição"),
    ("9", "Não Contribuinte"),
]

"Indicador da Forma de Pagamento"
DETPAG_INDPAG = [
    ("0", "Pagamento à Vista"),
    ("1", "Pagamento à Prazo"),
]

"Código de Regime Tributário"
EMIT_CRT = [
    ("1", "Simples Nacional"),
    ("2", "Simples Nacional – excesso de sublimite de receita bruta"),
    ("3", "Regime Normal."),
    ("4", "Simples Nacional - Microempreendedor individual - MEI"),
]

"Identificador de Local de destino da operação"
IDE_IDDEST = [
    ("1", "Interna"),
    ("2", "Interestadual"),
    ("3", "Exterior)"),
]

"Indica operação com consumidor final"
IDE_INDFINAL = [
    ("0", "Não"),
    ("1", "Consumidor Final)"),
]

"""Indicador de intermediador/marketplace
    0=Operação sem intermediador (em site ou plataforma própria)
    1=Operação em site ou plataforma de terceiros (intermediadores/marketplace)"""
IDE_INDINTERMED = [
    ("0", "0"),
    ("1", "1"),
]

"""Indicador de presença do comprador no estabelecimento comercial no
    momento da oepração"""
IDE_INDPRES = [
    ("0", "Não se aplica (ex.: Nota Fiscal complementar ou de ajuste"),
    ("1", "Operação presencial"),
    ("2", "Não presencial, internet"),
    ("3", "Não presencial, teleatendimento"),
    ("4", "NFC-e entrega em domicílio"),
    ("5", "Operação presencial, fora do estabelecimento"),
    ("9", "Não presencial, outros)"),
]

"Forma de emissão da NF-e"
IDE_TPEMIS = [
    ("1", "Normal"),
    ("2", "Contingência FS"),
    ("3", "Regime Especial NFF (NT 2021.002)"),
    ("4", "Contingência DPEC"),
    ("5", "Contingência FSDA"),
    ("6", "Contingência SVC - AN"),
    ("7", "Contingência SVC - RS"),
    ("9", "Contingência off-line NFC-e"),
]

"Formato de impressão do DANFE"
IDE_TPIMP = [
    ("0", "sem DANFE"),
    ("1", "DANFe Retrato"),
    ("2", "DANFe Paisagem"),
    ("3", "DANFe Simplificado"),
    ("4", "DANFe NFC-e"),
    ("5", "DANFe NFC-e em mensagem eletrônica)"),
]

"Tipo do Documento Fiscal"
IDE_TPNF = [
    ("0", "entrada"),
    ("1", "saída)"),
]

"Indicador de importação 0=Nacional; 1=Importado;"
ORIGCOMB_INDIMPORT = [
    ("0", "0"),
    ("1", "1"),
]

"Origem do processo, informar"
PROCREF_INDPROC = [
    ("0", "SEFAZ"),
    ("1", "Justiça Federal"),
    ("2", "Justiça Estadual"),
    ("3", "Secex/RFB"),
    ("4", "CONFAZ"),
    ("9", "Outros."),
]

"Tipo do ato concessório"
PROCREF_TPATO = [
    ("08", "Termo de Acordo"),
    ("10", "Regime Especial"),
    ("12", "Autorização específica"),
    ("14", "Ajuste SINIEF"),
    ("15", "Convênio ICMS."),
]

PROD_INDESCALA = [
    ("S", "S"),
    ("N", "N"),
]

"Este campo deverá ser preenchido"
PROD_INDTOT = [
    ("0", "o valor do item (vProd) não compõe o valor total da NF-e (vProd)"),
    ("1", "1"),
]

"""Código do modelo do Documento Fiscal
    Preencher com "2B", quando se tratar de Cupom Fiscal emitido por máquina
    registradora (não ECF), com "2C", quando se tratar de Cupom Fiscal PDV, ou
    "2D", quando se tratar de Cupom Fiscal (emitido por ECF)"""
REFECF_MOD = [
    ("2B", "2B"),
    ("2C", "2C"),
    ("2D", "2D"),
]

"""Código do modelo do Documento Fiscal - utilizar 04 para NF de produtor
    ou 01 para NF Avulsa"""
REFNFP_MOD = [
    ("01", "01"),
    ("04", "04"),
]

"""Código do modelo do Documento Fiscal. Utilizar 01 para NF modelo 1/1A e
    02 para NF modelo 02"""
REFNF_MOD = [
    ("01", "01"),
    ("02", "02"),
]

"Modalidade do frete"
TRANSP_MODFRETE = [
    ("0", " Contratação do Frete por conta do Remetente (CIF)"),
    ("1", " Contratação do Frete por conta do destinatário/remetente (FOB)"),
    ("2", " Contratação do Frete por conta de terceiros"),
    ("3", " Transporte próprio por conta do remetente"),
    ("4", " Transporte próprio por conta do destinatário"),
    ("9", " Sem Ocorrência de transporte."),
]

"Informa-se o veículo tem VIN"
VEICPROD_VIN = [
    ("R", "Remarcado"),
    ("N", "NormalVIN"),
]

"Condição do veículo"
VEICPROD_CONDVEIC = [
    ("1", "acabado"),
    ("2", "inacabado"),
    ("3", "semi-acabado)"),
]

"Tipo da Operação"
VEICPROD_TPOP = [
    ("0", "Outros)"),
    ("1", "Venda concessionária"),
    ("2", "Faturamento direto"),
    ("3", "Venda direta"),
]

"Restrição"
VEICPROD_TPREST = [
    ("0", "Não há"),
    ("1", "Alienação Fiduciária"),
    ("2", "Arrendamento Mercantil"),
    ("3", "Reserva de Domínio"),
    ("4", "Penhor de Veículos"),
    ("9", "outras."),
]


class TinfRespTec(models.AbstractModel):
    """Grupo de informações do responsável técnico pelo sistema de emissão de
    DF-e"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tinfresptec"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TinfRespTec"

    nfe40_CNPJ = fields.Char(
        string="CNPJ", xsd_required=True, xsd_type="TCnpjOpc"
    )

    nfe40_xContato = fields.Char(
        string="nome da pessoa a ser contatada",
        xsd_required=True,
        help=(
            "nome da pessoa a ser contatada na empresa desenvolvedora do "
            "sistema utilizado na emissão do documento fiscal eletrônico."
        ),
    )

    nfe40_email = fields.Char(
        string="e-mail da pessoa a ser contatada",
        xsd_required=True,
        help=(
            "e-mail da pessoa a ser contatada na empresa desenvolvedora do "
            "sistema."
        ),
    )

    nfe40_fone = fields.Char(
        string="telefone da pessoa a ser contatada",
        xsd_required=True,
        help=(
            "telefone da pessoa a ser contatada na empresa desenvolvedora do "
            "sistema. Preencher com o Código DDD + número do telefone."
        ),
    )

    nfe40_idCSRT = fields.Char(
        string="Identificador do CSRT utilizado",
        help="Identificador do CSRT utilizado para montar o hash do CSRT",
    )

    nfe40_hashCSRT = fields.Char(
        string="O hashCSRT é o resultado da função hash",
        help=(
            "O hashCSRT é o resultado da função hash (SHA-1 – Base64) do CSRT "
            "fornecido pelo fisco mais a Chave de Acesso da NFe."
        ),
    )


class TconsReciNfe(models.AbstractModel):
    """Tipo Pedido de Consulta do Recido do Lote de Notas Fiscais
    Eletrônicas"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tconsrecinfe"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TconsReciNfe"

    nfe40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    nfe40_nRec = fields.Char(
        string="Número do Recibo", xsd_required=True, xsd_type="TRec"
    )

    nfe40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerNFe"
    )


class TenderEmi(models.AbstractModel):
    """Tipo Dados do Endereço do Emitente // 24/10/08 - desmembrado / tamanho
    mínimo"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tenderemi"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TenderEmi"

    nfe40_xLgr = fields.Char(string="Logradouro", xsd_required=True)

    nfe40_nro = fields.Char(string="Número", xsd_required=True)

    nfe40_xCpl = fields.Char(string="Complemento")

    nfe40_xBairro = fields.Char(string="Bairro", xsd_required=True)

    nfe40_cMun = fields.Char(
        string="Código do município", xsd_required=True, xsd_type="TCodMunIBGE"
    )

    nfe40_xMun = fields.Char(string="Nome do município", xsd_required=True)

    nfe40_UF = fields.Selection(
        TUFEMI, string="Sigla da UF", xsd_required=True, xsd_type="TUfEmi"
    )

    nfe40_CEP = fields.Char(string="CEP - NT 2011/004", xsd_required=True)

    nfe40_cPais = fields.Selection(TENDEREMI_CPAIS, string="Código do país")

    nfe40_xPais = fields.Selection(TENDEREMI_XPAIS, string="Nome do país")

    nfe40_fone = fields.Char(
        string="Código DDD + número do telefone",
        help="Código DDD + número do telefone (v.2.0)",
    )


class Tendereco(models.AbstractModel):
    "Tipo Dados do Endereço // 24/10/08 - tamanho mínimo"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tendereco"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tendereco"

    nfe40_xLgr = fields.Char(string="Logradouro", xsd_required=True)

    nfe40_nro = fields.Char(string="Número", xsd_required=True)

    nfe40_xCpl = fields.Char(string="Complemento")

    nfe40_xBairro = fields.Char(string="Bairro", xsd_required=True)

    nfe40_cMun = fields.Char(
        string="Código do município",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do município (utilizar a tabela do IBGE), informar 9999999"
            " para operações com o exterior."
        ),
    )

    nfe40_xMun = fields.Char(
        string="Nome do município",
        xsd_required=True,
        help=(
            "Nome do município, informar EXTERIOR para operações com o "
            "exterior."
        ),
    )

    nfe40_UF = fields.Selection(
        TUF,
        string="Sigla da UF",
        xsd_required=True,
        xsd_type="TUf",
        help="Sigla da UF, informar EX para operações com o exterior.",
    )

    nfe40_CEP = fields.Char(string="CEP")

    nfe40_cPais = fields.Char(string="Código de Pais")

    nfe40_xPais = fields.Char(string="Nome do país")

    nfe40_fone = fields.Char(
        string="Telefone",
        help=(
            "Telefone, preencher com Código DDD + número do telefone , nas "
            "operações com exterior é permtido informar o código do país + "
            "código da localidade + número do telefone"
        ),
    )


class Tipi(models.AbstractModel):
    "Tipo: Dados do IPI"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tipi"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tipi"

    nfe40_CNPJProd = fields.Char(
        string="CNPJ do produtor da mercadoria",
        xsd_type="TCnpj",
        help=(
            "CNPJ do produtor da mercadoria, quando diferente do emitente. "
            "Somente para os casos de exportação direta ou indireta."
        ),
    )

    nfe40_cSelo = fields.Char(string="Código do selo de controle do IPI")

    nfe40_qSelo = fields.Char(string="Quantidade de selo de controle do IPI")

    nfe40_cEnq = fields.Char(
        string="Código de Enquadramento Legal do IPI",
        xsd_required=True,
        help=(
            "Código de Enquadramento Legal do IPI (tabela a ser criada pela "
            "RFB)"
        ),
    )

    nfe40_IPITrib = fields.Many2one(
        comodel_name="nfe.40.ipitrib",
        string="IPITrib",
        choice="tipi",
        xsd_choice_required=True,
    )

    nfe40_IPINT = fields.Many2one(
        comodel_name="nfe.40.ipint",
        string="IPINT",
        choice="tipi",
        xsd_choice_required=True,
    )


class Ipitrib(models.AbstractModel):
    _description = "IPITrib"
    _name = "nfe.40.ipitrib"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tipi.Ipitrib"

    nfe40_CST = fields.Selection(
        IPITRIB_CST,
        string="Código da Situação Tributária do IPI",
        xsd_required=True,
        help=(
            "Código da Situação Tributária do IPI:\n00-Entrada com recuperação"
            " de crédito\n49 - Outras entradas\n50-Saída tributada\n99-Outras "
            "saídas"
        ),
    )

    nfe40_vBC = fields.Monetary(
        string="Valor da BC do IPI",
        choice="ipitrib",
        xsd_choice_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_pIPI = fields.Float(
        string="Alíquota do IPI",
        choice="ipitrib",
        xsd_choice_required=True,
        xsd_type="TDec_0302a04",
        digits=(
            3,
            2,
        ),
    )

    nfe40_qUnid = fields.Float(
        string="Quantidade total na unidade padrão",
        choice="ipitrib",
        xsd_choice_required=True,
        xsd_type="TDec_1204v",
        digits=(
            12,
            4,
        ),
        help="Quantidade total na unidade padrão para tributação",
    )

    nfe40_vUnid = fields.Float(
        string="Valor por Unidade Tributável",
        choice="ipitrib",
        xsd_choice_required=True,
        xsd_type="TDec_1104",
        digits=(
            11,
            4,
        ),
        help=(
            "Valor por Unidade Tributável. Informar o valor do imposto Pauta "
            "por unidade de medida."
        ),
    )

    nfe40_vIPI = fields.Monetary(
        string="Valor do IPI",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class Ipint(models.AbstractModel):
    _description = "IPINT"
    _name = "nfe.40.ipint"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tipi.Ipint"

    nfe40_CST = fields.Selection(
        IPINT_CST,
        string="Código da Situação Tributária do IPI",
        xsd_required=True,
        help=(
            "Código da Situação Tributária do IPI:\n01-Entrada tributada com "
            "alíquota zero\n02-Entrada isenta\n03-Entrada não-"
            "tributada\n04-Entrada imune\n05-Entrada com suspensão\n51-Saída "
            "tributada com alíquota zero\n52-Saída isenta\n53-Saída não-"
            "tributada\n54-Saída imune\n55-Saída com suspensão"
        ),
    )


class Tlocal(models.AbstractModel):
    """Tipo Dados do Local de Retirada ou Entrega // 24/10/08 - tamanho mínimo
    // v2.0"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tlocal"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tlocal"

    nfe40_CNPJ = fields.Char(
        string="CNPJ",
        choice="tlocal",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
    )

    nfe40_CPF = fields.Char(
        string="CPF (v2.0)",
        choice="tlocal",
        xsd_choice_required=True,
        xsd_type="TCpf",
    )

    nfe40_xNome = fields.Char(
        string="Razão Social ou Nome",
        help="Razão Social ou Nome do Expedidor/Recebedor",
    )

    nfe40_xLgr = fields.Char(string="Logradouro", xsd_required=True)

    nfe40_nro = fields.Char(string="Número", xsd_required=True)

    nfe40_xCpl = fields.Char(string="Complemento")

    nfe40_xBairro = fields.Char(string="Bairro", xsd_required=True)

    nfe40_cMun = fields.Char(
        string="Código do município",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help="Código do município (utilizar a tabela do IBGE)",
    )

    nfe40_xMun = fields.Char(string="Nome do município", xsd_required=True)

    nfe40_UF = fields.Selection(
        TUF, string="Sigla da UF", xsd_required=True, xsd_type="TUf"
    )

    nfe40_CEP = fields.Char(string="CEP")

    nfe40_cPais = fields.Char(string="Código de Pais")

    nfe40_xPais = fields.Char(string="Nome do país")

    nfe40_fone = fields.Char(
        string="Telefone",
        help=(
            "Telefone, preencher com Código DDD + número do telefone , nas "
            "operações com exterior é permtido informar o código do país + "
            "código da localidade + número do telefone"
        ),
    )

    nfe40_email = fields.Char(
        string="e-mail do expedidor/Recebedor",
        help=(
            "e-mail do expedidor/Recebedor. O campo pode ser utilizado para "
            "informar o e-mail de recepção da NF-e indicada pelo expedidor"
        ),
    )

    nfe40_IE = fields.Char(string="Inscrição Estadual (v2.0)", xsd_type="TIe")


class TretConsReciNfe(models.AbstractModel):
    """Tipo Retorno do Pedido de Consulta do Recido do Lote de Notas Fiscais
    Eletrônicas"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tretconsrecinfe"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TretConsReciNfe"

    nfe40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    nfe40_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou a NF-e",
    )

    nfe40_nRec = fields.Char(
        string="Número do Recibo Consultado",
        xsd_required=True,
        xsd_type="TRec",
    )

    nfe40_cStat = fields.Char(
        string="Código do status da mensagem enviada",
        xsd_required=True,
        xsd_type="TStat",
    )

    nfe40_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do serviço solicitado.",
    )

    nfe40_cUF = fields.Selection(
        TCODUFIBGE,
        string="código da UF de atendimento",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    nfe40_dhRecbto = fields.Datetime(
        string="Data e hora de processamento",
        xsd_required=True,
        xsd_type="TDateTimeUTC",
        help=(
            "Data e hora de processamento, no formato AAAA-MM-DDTHH:MM:SSTZD. "
            "Em caso de Rejeição, com data e hora do recebimento do Lote de "
            "NF-e enviado."
        ),
    )

    nfe40_cMsg = fields.Char(
        string="Código da Mensagem (v2.0)",
        help=(
            "Código da Mensagem (v2.0) \nalterado para tamanho variavel 1-4. "
            "(NT2011/004)"
        ),
    )

    nfe40_xMsg = fields.Char(
        string="Mensagem da SEFAZ para o emissor",
        help="Mensagem da SEFAZ para o emissor. (v2.0)",
    )

    nfe40_protNFe = fields.One2many(
        "nfe.40.tprotnfe",
        "nfe40_protNFe_TRetConsReciNFe_id",
        string="Protocolo de status resultado",
        xsd_type="TProtNFe",
        help="Protocolo de status resultado do processamento da NF-e",
    )

    nfe40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerNFe"
    )


class TretEnviNfe(models.AbstractModel):
    "Tipo Retorno do Pedido de Autorização da Nota Fiscal Eletrônica"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tretenvinfe"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TretEnviNfe"

    nfe40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    nfe40_verAplic = fields.Char(
        string="Versão do Aplicativo que recebeu o Lote",
        xsd_required=True,
        xsd_type="TVerAplic",
    )

    nfe40_cStat = fields.Char(
        string="Código do status da mensagem enviada",
        xsd_required=True,
        xsd_type="TStat",
    )

    nfe40_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do serviço solicitado.",
    )

    nfe40_cUF = fields.Selection(
        TCODUFIBGE,
        string="código da UF de atendimento",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    nfe40_dhRecbto = fields.Datetime(
        string="Data e hora do recebimento",
        xsd_required=True,
        xsd_type="TDateTimeUTC",
        help=("Data e hora do recebimento, no formato AAAA-MM-DDTHH:MM:SSTZD"),
    )

    nfe40_infRec = fields.Many2one(
        comodel_name="nfe.40.infrec",
        string="Dados do Recibo do Lote",
        choice="tretenvinfe",
        xsd_choice_required=True,
    )

    nfe40_protNFe = fields.Many2one(
        comodel_name="nfe.40.tprotnfe",
        string="Protocolo de status resultado",
        choice="tretenvinfe",
        xsd_choice_required=True,
        xsd_type="TProtNFe",
        help=(
            "Protocolo de status resultado do processamento sincrono da NFC-e"
        ),
    )

    nfe40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerNFe"
    )


class InfRec(models.AbstractModel):
    "Dados do Recibo do Lote"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.infrec"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TretEnviNfe.InfRec"

    nfe40_nRec = fields.Char(
        string="Número do Recibo", xsd_required=True, xsd_type="TRec"
    )

    nfe40_tMed = fields.Char(
        string="Tempo médio de resposta do serviço",
        xsd_required=True,
        xsd_type="TMed",
        help=(
            "Tempo médio de resposta do serviço (em segundos) dos últimos 5 "
            "minutos"
        ),
    )


class Tveiculo(models.AbstractModel):
    "Tipo Dados do Veículo"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tveiculo"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tveiculo"

    nfe40_reboque_transp_id = fields.Many2one(
        comodel_name="nfe.40.transp", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_placa = fields.Char(
        string="Placa do veículo (NT2011/004)", xsd_required=True
    )

    nfe40_UF = fields.Selection(TUF, string="Sigla da UF", xsd_type="TUf")

    nfe40_RNTC = fields.Char(
        string="Registro Nacional de Transportador",
        help="Registro Nacional de Transportador de Carga (ANTT)",
    )


class Tnfe(models.AbstractModel):
    "Tipo Nota Fiscal Eletrônica"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tnfe"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe"

    nfe40_NFe_TEnviNFe_id = fields.Many2one(
        comodel_name="nfe.40.tenvinfe", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_infNFe = fields.Many2one(
        comodel_name="nfe.40.infnfe",
        string="Informações da Nota Fiscal eletrônica",
        xsd_required=True,
    )

    nfe40_infNFeSupl = fields.Many2one(
        comodel_name="nfe.40.infnfesupl",
        string="Informações suplementares Nota Fiscal",
    )


class InfNfe(models.AbstractModel):
    "Informações da Nota Fiscal eletrônica"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.infnfe"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe"

    nfe40_ide = fields.Many2one(
        comodel_name="nfe.40.ide",
        string="identificação da NF-e",
        xsd_required=True,
    )

    nfe40_emit = fields.Many2one(
        comodel_name="nfe.40.emit",
        string="Identificação do emitente",
        xsd_required=True,
    )

    nfe40_avulsa = fields.Many2one(
        comodel_name="nfe.40.avulsa",
        string="Emissão de avulsa",
        help="Emissão de avulsa, informar os dados do Fisco emitente",
    )

    nfe40_dest = fields.Many2one(
        comodel_name="nfe.40.dest", string="Identificação do Destinatário"
    )

    nfe40_retirada = fields.Many2one(
        comodel_name="nfe.40.tlocal",
        string="Identificação do Local de Retirada",
        xsd_type="TLocal",
        help=(
            "Identificação do Local de Retirada (informar apenas quando for "
            "diferente do endereço do remetente)"
        ),
    )

    nfe40_entrega = fields.Many2one(
        comodel_name="nfe.40.tlocal",
        string="Identificação do Local de Entrega",
        xsd_type="TLocal",
        help=(
            "Identificação do Local de Entrega (informar apenas quando for "
            "diferente do endereço do destinatário)"
        ),
    )

    nfe40_autXML = fields.One2many(
        "nfe.40.autxml",
        "nfe40_autXML_infNFe_id",
        string="Pessoas autorizadas para o download",
        help="Pessoas autorizadas para o download do XML da NF-e",
    )

    nfe40_det = fields.One2many(
        "nfe.40.det",
        "nfe40_det_infNFe_id",
        string="Dados dos detalhes da NF-e",
    )

    nfe40_total = fields.Many2one(
        comodel_name="nfe.40.total",
        string="Dados dos totais da NF-e",
        xsd_required=True,
    )

    nfe40_transp = fields.Many2one(
        comodel_name="nfe.40.transp",
        string="Dados dos transportes da NF-e",
        xsd_required=True,
    )

    nfe40_cobr = fields.Many2one(
        comodel_name="nfe.40.cobr", string="Dados da cobrança da NF-e"
    )

    nfe40_pag = fields.Many2one(
        comodel_name="nfe.40.pag",
        string="Dados de Pagamento",
        xsd_required=True,
        help=(
            "Dados de Pagamento. Obrigatório apenas para (NFC-e) NT 2012/004"
        ),
    )

    nfe40_infIntermed = fields.Many2one(
        comodel_name="nfe.40.infintermed",
        string="Grupo de Informações do Intermediador",
        help="Grupo de Informações do Intermediador da Transação",
    )

    nfe40_infAdic = fields.Many2one(
        comodel_name="nfe.40.infadic", string="Informações adicionais da NF-e"
    )

    nfe40_exporta = fields.Many2one(
        comodel_name="nfe.40.exporta", string="Informações de exportação"
    )

    nfe40_compra = fields.Many2one(
        comodel_name="nfe.40.compra",
        string="Informações de compras",
        help="Informações de compras  (Nota de Empenho, Pedido e Contrato)",
    )

    nfe40_cana = fields.Many2one(
        comodel_name="nfe.40.cana",
        string="Informações de registro aquisições",
        help="Informações de registro aquisições de cana",
    )

    nfe40_infRespTec = fields.Many2one(
        comodel_name="nfe.40.tinfresptec",
        string="Informações do Responsável Técnico",
        xsd_type="TInfRespTec",
        help="Informações do Responsável Técnico pela emissão do DF-e",
    )

    nfe40_infSolicNFF = fields.Many2one(
        comodel_name="nfe.40.infsolicnff",
        string="Grupo para informações da solicitação",
        help="Grupo para informações da solicitação da NFF",
    )

    nfe40_versao = fields.Char(
        string="Versão do leiaute (v4.00)",
        xsd_required=True,
        xsd_type="TVerNFe",
    )

    nfe40_Id = fields.Char(
        string="PL_005d - 11/08/09 - validação do Id", xsd_required=True
    )


class Ide(models.AbstractModel):
    "identificação da NF-e"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.ide"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Ide"

    nfe40_cUF = fields.Selection(
        TCODUFIBGE,
        string="Código da UF do emitente",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
        help=(
            "Código da UF do emitente do Documento Fiscal. Utilizar a Tabela "
            "do IBGE."
        ),
    )

    nfe40_cNF = fields.Char(
        string="Código numérico que compõe a Chave",
        xsd_required=True,
        help=(
            "Código numérico que compõe a Chave de Acesso. Número aleatório "
            "gerado pelo emitente para cada NF-e."
        ),
    )

    nfe40_natOp = fields.Char(
        string="Descrição da Natureza da Operação", xsd_required=True
    )

    nfe40_mod = fields.Selection(
        TMOD,
        string="Código do modelo do Documento Fiscal",
        xsd_required=True,
        xsd_type="TMod",
        help="Código do modelo do Documento Fiscal. 55 = NF-e; 65 = NFC-e.",
    )

    nfe40_serie = fields.Char(
        string="Série do Documento Fiscal",
        xsd_required=True,
        xsd_type="TSerie",
        help=(
            "Série do Documento Fiscal\nsérie normal 0-889\nAvulsa Fisco "
            "890-899\nSCAN 900-999"
        ),
    )

    nfe40_nNF = fields.Char(
        string="Número do Documento Fiscal", xsd_required=True, xsd_type="TNF"
    )

    nfe40_dhEmi = fields.Datetime(
        string="Data e Hora de emissão",
        xsd_required=True,
        xsd_type="TDateTimeUTC",
        help=(
            "Data e Hora de emissão do Documento Fiscal (AAAA-MM-"
            "DDThh:mm:ssTZD) ex.: 2012-09-01T13:00:00-03:00"
        ),
    )

    nfe40_dhSaiEnt = fields.Datetime(
        string="Data e Hora da saída ou de entrada",
        xsd_type="TDateTimeUTC",
        help=(
            "Data e Hora da saída ou de entrada da mercadoria / produto (AAAA-"
            "MM-DDTHH:mm:ssTZD)"
        ),
    )

    nfe40_tpNF = fields.Selection(
        IDE_TPNF,
        string="Tipo do Documento Fiscal",
        xsd_required=True,
        help="Tipo do Documento Fiscal (0 - entrada; 1 - saída)",
    )

    nfe40_idDest = fields.Selection(
        IDE_IDDEST,
        string="Identificador de Local de destino",
        xsd_required=True,
        help=(
            "Identificador de Local de destino da operação "
            "(1-Interna;2-Interestadual;3-Exterior)"
        ),
    )

    nfe40_cMunFG = fields.Char(
        string="Código do Município de Ocorrência",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do Município de Ocorrência do Fato Gerador (utilizar a "
            "tabela do IBGE)"
        ),
    )

    nfe40_tpImp = fields.Selection(
        IDE_TPIMP,
        string="Formato de impressão do DANFE",
        xsd_required=True,
        help=(
            "Formato de impressão do DANFE (0-sem DANFE;1-DANFe Retrato; "
            "2-DANFe Paisagem;3-DANFe "
            "Simplificado;\n\t\t\t\t\t\t\t\t\t\t\t4-DANFe NFC-e;5-DANFe NFC-e "
            "em mensagem eletrônica)"
        ),
    )

    nfe40_tpEmis = fields.Selection(
        IDE_TPEMIS,
        string="Forma de emissão da NF-e",
        xsd_required=True,
        help=(
            "Forma de emissão da NF-e\n1 - Normal;\n2 - Contingência FS\n3 - "
            "Regime Especial NFF (NT 2021.002)\n4 - Contingência DPEC\n5 - "
            "Contingência FSDA\n6 - Contingência SVC - AN\n7 - Contingência "
            "SVC - RS\n9 - Contingência off-line NFC-e"
        ),
    )

    nfe40_cDV = fields.Char(
        string="Digito Verificador da Chave de Acesso",
        xsd_required=True,
        help="Digito Verificador da Chave de Acesso da NF-e",
    )

    nfe40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    nfe40_finNFe = fields.Selection(
        TFINNFE,
        string="Finalidade da emissão da NF-e",
        xsd_required=True,
        xsd_type="TFinNFe",
        help=(
            "Finalidade da emissão da NF-e:\n1 - NFe normal\n2 - NFe "
            "complementar\n3 - NFe de ajuste\n4 - Devolução/Retorno"
        ),
    )

    nfe40_indFinal = fields.Selection(
        IDE_INDFINAL,
        string="Indica operação com consumidor final",
        xsd_required=True,
        help=(
            "Indica operação com consumidor final (0-Não;1-Consumidor Final)"
        ),
    )

    nfe40_indPres = fields.Selection(
        IDE_INDPRES,
        string="Indicador de presença do comprador",
        xsd_required=True,
        help=(
            "Indicador de presença do comprador no estabelecimento comercial "
            "no momento da oepração\n\t\t\t\t\t\t\t\t\t\t\t(0-Não se aplica "
            "(ex.: Nota Fiscal complementar ou de ajuste;1-Operação "
            "presencial;2-Não presencial, internet;3-Não presencial, "
            "teleatendimento;4-NFC-e entrega em domicílio;5-Operação "
            "presencial, fora do estabelecimento;9-Não presencial, outros)"
        ),
    )

    nfe40_indIntermed = fields.Selection(
        IDE_INDINTERMED,
        string="Indicador de intermediador/marketplace",
        help=(
            "Indicador de intermediador/marketplace "
            "\n\t\t\t\t\t\t\t\t\t\t\t0=Operação sem intermediador (em site ou "
            "plataforma própria) \n\t\t\t\t\t\t\t\t\t\t\t1=Operação em site ou"
            " plataforma de terceiros (intermediadores/marketplace)"
        ),
    )

    nfe40_procEmi = fields.Selection(
        TPROCEMI,
        string="Processo de emissão utilizado",
        xsd_required=True,
        xsd_type="TProcEmi",
        help=(
            "Processo de emissão utilizado com a seguinte codificação:\n0 - "
            "emissão de NF-e com aplicativo do contribuinte;\n1 - emissão de "
            "NF-e avulsa pelo Fisco;\n2 - emissão de NF-e avulsa, pelo "
            "contribuinte com seu certificado digital, através do site\ndo "
            "Fisco;\n3- emissão de NF-e pelo contribuinte com aplicativo "
            "fornecido pelo Fisco."
        ),
    )

    nfe40_verProc = fields.Char(
        string="versão do aplicativo utilizado",
        xsd_required=True,
        help="versão do aplicativo utilizado no processo de\nemissão",
    )

    nfe40_dhCont = fields.Datetime(
        string="data e hora de entrada",
        xsd_type="TDateTimeUTC",
        help=(
            "data e hora de entrada em contingência contingência no formato  "
            "(AAAA-MM-DDThh:mm:ssTZD) ex.: 2012-09-01T13:00:00-03:00."
        ),
    )

    nfe40_xJust = fields.Char(string="Justificativa da entrada")

    nfe40_NFref = fields.One2many(
        "nfe.40.nfref",
        "nfe40_NFref_ide_id",
        string="Grupo de infromações da NF referenciada",
    )


class Nfref(models.AbstractModel):
    "Grupo de infromações da NF referenciada"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.nfref"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Ide.Nfref"

    nfe40_NFref_ide_id = fields.Many2one(
        comodel_name="nfe.40.ide", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_refNFe = fields.Char(
        string="Chave de acesso das NF-e referenciadas",
        choice="nfref",
        xsd_choice_required=True,
        xsd_type="TChNFe",
        help=(
            "Chave de acesso das NF-e referenciadas. Chave de acesso compostas"
            " por Código da UF (tabela do IBGE) + AAMM da emissão + CNPJ do "
            "Emitente + modelo, série e número da NF-e Referenciada + Código "
            "Numérico + DV."
        ),
    )

    nfe40_refNFeSig = fields.Char(
        string="Referencia uma NF-e",
        choice="nfref",
        xsd_choice_required=True,
        xsd_type="TChNFe",
        help=(
            "Referencia uma NF-e (modelo 55) emitida anteriormente pela sua "
            "Chave de Acesso com código numérico zerado, permitindo manter o "
            "sigilo da NF-e referenciada."
        ),
    )

    nfe40_refNF = fields.Many2one(
        comodel_name="nfe.40.refnf",
        string="Dados da NF modelo 1/1A referenciada",
        choice="nfref",
        xsd_choice_required=True,
        help=(
            "Dados da NF modelo 1/1A referenciada ou NF modelo 2 referenciada"
        ),
    )

    nfe40_refNFP = fields.Many2one(
        comodel_name="nfe.40.refnfp",
        string="Grupo com as informações NF",
        choice="nfref",
        xsd_choice_required=True,
        help="Grupo com as informações NF de produtor referenciada",
    )

    nfe40_refCTe = fields.Char(
        string="Utilizar esta TAG para referenciar",
        choice="nfref",
        xsd_choice_required=True,
        xsd_type="TChNFe",
        help=(
            "Utilizar esta TAG para referenciar um CT-e emitido anteriormente,"
            " vinculada a NF-e atual"
        ),
    )

    nfe40_refECF = fields.Many2one(
        comodel_name="nfe.40.refecf",
        string="Grupo do Cupom Fiscal vinculado à NF-e",
        choice="nfref",
        xsd_choice_required=True,
    )


class RefNf(models.AbstractModel):
    "Dados da NF modelo 1/1A referenciada ou NF modelo 2 referenciada"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.refnf"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Ide.Nfref.RefNf"

    nfe40_cUF = fields.Selection(
        TCODUFIBGE,
        string="Código da UF do emitente",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
        help=(
            "Código da UF do emitente do Documento Fiscal. Utilizar a Tabela "
            "do IBGE."
        ),
    )

    nfe40_AAMM = fields.Char(string="AAMM da emissão", xsd_required=True)

    nfe40_CNPJ = fields.Char(
        string="CNPJ do emitente",
        xsd_required=True,
        xsd_type="TCnpj",
        help="CNPJ do emitente do documento fiscal referenciado",
    )

    nfe40_mod = fields.Selection(
        REFNF_MOD,
        string="Código do modelo do Documento Fiscal",
        xsd_required=True,
        help=(
            "Código do modelo do Documento Fiscal. Utilizar 01 para NF modelo "
            "1/1A e 02 para NF modelo 02"
        ),
    )

    nfe40_serie = fields.Char(
        string="Série do Documento Fiscal",
        xsd_required=True,
        xsd_type="TSerie",
        help="Série do Documento Fiscal, informar zero se inexistente",
    )

    nfe40_nNF = fields.Char(
        string="Número do Documento Fiscal", xsd_required=True, xsd_type="TNF"
    )


class RefNfp(models.AbstractModel):
    "Grupo com as informações NF de produtor referenciada"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.refnfp"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Ide.Nfref.RefNfp"

    nfe40_cUF = fields.Selection(
        TCODUFIBGE,
        string="Código da UF do emitente",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
        help=(
            "Código da UF do emitente do Documento FiscalUtilizar a Tabela do "
            "IBGE (Anexo IV - Tabela de UF, Município e País)"
        ),
    )

    nfe40_AAMM = fields.Char(
        string="AAMM da emissão da NF de produtor", xsd_required=True
    )

    nfe40_CNPJ = fields.Char(
        string="CNPJ do emitente da NF de produtor",
        choice="refnfp",
        xsd_choice_required=True,
        xsd_type="TCnpj",
    )

    nfe40_CPF = fields.Char(
        string="CPF do emitente da NF de produtor",
        choice="refnfp",
        xsd_choice_required=True,
        xsd_type="TCpf",
    )

    nfe40_IE = fields.Char(
        string="IE do emitente da NF de Produtor",
        xsd_required=True,
        xsd_type="TIeDest",
    )

    nfe40_mod = fields.Selection(
        REFNFP_MOD,
        string="Código do modelo do Documento Fiscal",
        xsd_required=True,
        help=(
            "Código do modelo do Documento Fiscal - utilizar 04 para NF de "
            "produtor  ou 01 para NF Avulsa"
        ),
    )

    nfe40_serie = fields.Char(
        string="Série do Documento Fiscal",
        xsd_required=True,
        xsd_type="TSerie",
        help="Série do Documento Fiscal, informar zero se inexistentesérie",
    )

    nfe40_nNF = fields.Char(
        string="Número do Documento Fiscal",
        xsd_required=True,
        xsd_type="TNF",
        help="Número do Documento Fiscal - 1 – 999999999",
    )


class RefEcf(models.AbstractModel):
    "Grupo do Cupom Fiscal vinculado à NF-e"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.refecf"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Ide.Nfref.RefEcf"

    nfe40_mod = fields.Selection(
        REFECF_MOD,
        string="Código do modelo do Documento Fiscal",
        xsd_required=True,
        help=(
            "Código do modelo do Documento Fiscal \nPreencher com '2B', quando"
            " se tratar de Cupom Fiscal emitido por máquina registradora (não "
            "ECF), com '2C', quando se tratar de Cupom Fiscal PDV, ou '2D', "
            "quando se tratar de Cupom Fiscal (emitido por ECF)"
        ),
    )

    nfe40_nECF = fields.Char(
        string="número de ordem seqüencial do ECF",
        xsd_required=True,
        help=(
            "número de ordem seqüencial do ECF que emitiu o Cupom Fiscal "
            "vinculado à NF-e"
        ),
    )

    nfe40_nCOO = fields.Char(
        string="Número do Contador de Ordem de Operação",
        xsd_required=True,
        help=(
            "Número do Contador de Ordem de Operação - COO vinculado à NF-e"
        ),
    )


class Emit(models.AbstractModel):
    "Identificação do emitente"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.emit"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Emit"

    nfe40_CNPJ = fields.Char(
        string="Número do CNPJ do emitente",
        choice="emit",
        xsd_choice_required=True,
        xsd_type="TCnpj",
    )

    nfe40_CPF = fields.Char(
        string="Número do CPF do emitente",
        choice="emit",
        xsd_choice_required=True,
        xsd_type="TCpf",
    )

    nfe40_xNome = fields.Char(
        string="Razão Social ou Nome do emitente", xsd_required=True
    )

    nfe40_xFant = fields.Char(string="Nome fantasia")

    nfe40_enderEmit = fields.Many2one(
        comodel_name="nfe.40.tenderemi",
        string="Endereço do emitente",
        xsd_required=True,
        xsd_type="TEnderEmi",
    )

    nfe40_IE = fields.Char(
        string="Inscrição Estadual do Emitente",
        xsd_required=True,
        xsd_type="TIe",
    )

    nfe40_IEST = fields.Char(
        string="Inscricao Estadual",
        xsd_type="TIeST",
        help="Inscricao Estadual do Substituto Tributário",
    )

    nfe40_IM = fields.Char(string="Inscrição Municipal")

    nfe40_CNAE = fields.Char(string="CNAE Fiscal")

    nfe40_CRT = fields.Selection(
        EMIT_CRT,
        string="Código de Regime Tributário",
        xsd_required=True,
        help=(
            "Código de Regime Tributário. \nEste campo será obrigatoriamente "
            "preenchido com:\n1 – Simples Nacional;\n2 – Simples Nacional – "
            "excesso de sublimite de receita bruta;\n3 – Regime Normal.\n4 - "
            "Simples Nacional - Microempreendedor individual - MEI"
        ),
    )


class Avulsa(models.AbstractModel):
    "Emissão de avulsa, informar os dados do Fisco emitente"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.avulsa"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Avulsa"

    nfe40_CNPJ = fields.Char(
        string="CNPJ do Órgão emissor", xsd_required=True, xsd_type="TCnpj"
    )

    nfe40_xOrgao = fields.Char(string="Órgão emitente", xsd_required=True)

    nfe40_matr = fields.Char(string="Matrícula do agente", xsd_required=True)

    nfe40_xAgente = fields.Char(string="Nome do agente", xsd_required=True)

    nfe40_fone = fields.Char(string="Telefone")

    nfe40_UF = fields.Selection(
        TUFEMI,
        string="Sigla da Unidade da Federação",
        xsd_required=True,
        xsd_type="TUfEmi",
    )

    nfe40_nDAR = fields.Char(
        string="Número do Documento de Arrecadação",
        help="Número do Documento de Arrecadação de Receita",
    )

    nfe40_dEmi = fields.Date(
        string="Data de emissão do DAR (AAAA-MM-DD)", xsd_type="TData"
    )

    nfe40_vDAR = fields.Monetary(
        string="Valor Total constante no DAR",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_repEmi = fields.Char(
        string="Repartição Fiscal emitente", xsd_required=True
    )

    nfe40_dPag = fields.Date(
        string="Data de pagamento do DAR",
        xsd_type="TData",
        help="Data de pagamento do DAR (AAAA-MM-DD)",
    )


class Dest(models.AbstractModel):
    "Identificação do Destinatário"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.dest"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Dest"

    nfe40_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="dest",
        xsd_choice_required=True,
        xsd_type="TCnpj",
    )

    nfe40_CPF = fields.Char(
        string="Número do CPF",
        choice="dest",
        xsd_choice_required=True,
        xsd_type="TCpf",
    )

    nfe40_idEstrangeiro = fields.Char(
        string="Identificador do destinatário",
        choice="dest",
        xsd_choice_required=True,
        help=(
            "Identificador do destinatário, em caso de comprador estrangeiro"
        ),
    )

    nfe40_xNome = fields.Char(string="Razão Social ou nome do destinatário")

    nfe40_enderDest = fields.Many2one(
        comodel_name="nfe.40.tendereco",
        string="Dados do endereço",
        xsd_type="TEndereco",
    )

    nfe40_indIEDest = fields.Selection(
        DEST_INDIEDEST,
        string="Indicador da IE do destinatário",
        xsd_required=True,
        help=(
            "Indicador da IE do destinatário:\n1 – Contribuinte ICMSpagamento "
            "à vista;\n2 – Contribuinte isento de inscrição;\n9 – Não "
            "Contribuinte"
        ),
    )

    nfe40_IE = fields.Char(
        string="Inscrição Estadual",
        xsd_type="TIeDestNaoIsento",
        help=(
            "Inscrição Estadual (obrigatório nas operações com contribuintes "
            "do ICMS)"
        ),
    )

    nfe40_ISUF = fields.Char(
        string="Inscrição na SUFRAMA",
        help=(
            "Inscrição na SUFRAMA (Obrigatório nas operações com as áreas com "
            "benefícios de incentivos fiscais sob controle da SUFRAMA) PL_005d"
            " - 11/08/09 - alterado para aceitar 8 ou 9 dígitos"
        ),
    )

    nfe40_IM = fields.Char(
        string="Inscrição Municipal do tomador",
        help="Inscrição Municipal do tomador do serviço",
    )

    nfe40_email = fields.Char(
        string="e-mail do destinatário",
        help=(
            "e-mail do destinatário. O campo pode ser utilizado para informar "
            "o e-mail\nde recepção da NF-e indicada pelo destinatário"
        ),
    )


class AutXml(models.AbstractModel):
    "Pessoas autorizadas para o download do XML da NF-e"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.autxml"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.AutXml"

    nfe40_autXML_infNFe_id = fields.Many2one(
        comodel_name="nfe.40.infnfe", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_CNPJ = fields.Char(
        string="CNPJ Autorizado",
        choice="autxml",
        xsd_choice_required=True,
        xsd_type="TCnpj",
    )

    nfe40_CPF = fields.Char(
        string="CPF Autorizado",
        choice="autxml",
        xsd_choice_required=True,
        xsd_type="TCpf",
    )


class Det(models.AbstractModel):
    "Dados dos detalhes da NF-e"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.det"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det"

    nfe40_det_infNFe_id = fields.Many2one(
        comodel_name="nfe.40.infnfe", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_prod = fields.Many2one(
        comodel_name="nfe.40.prod",
        string="Dados dos produtos e serviços da NF-e",
        xsd_required=True,
    )

    nfe40_imposto = fields.Many2one(
        comodel_name="nfe.40.imposto",
        string="Tributos incidentes nos produtos",
        xsd_required=True,
        help="Tributos incidentes nos produtos ou serviços da NF-e",
    )

    nfe40_impostoDevol = fields.Many2one(
        comodel_name="nfe.40.impostodevol", string="impostoDevol"
    )

    nfe40_infAdProd = fields.Char(
        string="Informações adicionais do produto",
        help=(
            "Informações adicionais do produto (norma referenciada, "
            "informações complementares, etc)"
        ),
    )

    nfe40_obsItem = fields.Many2one(
        comodel_name="nfe.40.obsitem",
        string="Grupo de observações de uso livre",
        help="Grupo de observações de uso livre (para o item da NF-e)",
    )

    nfe40_nItem = fields.Char(string="Número do item do NF", xsd_required=True)


class Prod(models.AbstractModel):
    "Dados dos produtos e serviços da NF-e"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.prod"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Prod"

    nfe40_cProd = fields.Char(
        string="Código do produto ou serviço",
        xsd_required=True,
        help=(
            "Código do produto ou serviço. Preencher com CFOP caso se trate de"
            " itens não relacionados com mercadorias/produto e que o "
            "contribuinte não possua codificação própria\nFormato ”CFOP9999”."
        ),
    )

    nfe40_cEAN = fields.Char(
        string="GTIN",
        xsd_required=True,
        help=(
            "GTIN (Global Trade Item Number) do produto, antigo código EAN ou "
            "código de barras"
        ),
    )

    nfe40_cBarra = fields.Char(
        string="Codigo de barras diferente",
        help="Codigo de barras diferente do padrão GTIN",
    )

    nfe40_xProd = fields.Char(
        string="Descrição do produto ou serviço", xsd_required=True
    )

    nfe40_NCM = fields.Char(
        string="Código NCM (8 posições)",
        xsd_required=True,
        help=(
            "Código NCM (8 posições), será permitida a informação do gênero "
            "(posição do capítulo do NCM) quando a operação não for de "
            "comércio exterior (importação/exportação) ou o produto não seja "
            "tributado pelo IPI. Em caso de item de serviço ou item que não "
            "tenham produto (Ex. transferência de crédito, crédito do ativo "
            "imobilizado, etc.), informar o código 00 (zeros) (v2.0)"
        ),
    )

    nfe40_NVE = fields.Char(
        string="Nomenclatura de Valor aduaneio",
        help="Nomenclatura de Valor aduaneio e Estatístico",
    )

    nfe40_CEST = fields.Char(
        string="Codigo especificador",
        help=(
            "Codigo especificador da Substuicao Tributaria - CEST, que "
            "identifica a mercadoria sujeita aos regimes de  substituicao "
            "tributária e de antecipação do recolhimento  do imposto"
        ),
    )

    nfe40_indEscala = fields.Selection(PROD_INDESCALA, string="indEscala")

    nfe40_CNPJFab = fields.Char(
        string="CNPJ do Fabricante da Mercadoria",
        xsd_type="TCnpj",
        help=(
            "CNPJ do Fabricante da Mercadoria, obrigatório para produto em "
            "escala NÃO relevante."
        ),
    )

    nfe40_cBenef = fields.Char(string="cBenef")

    nfe40_gCred = fields.One2many(
        "nfe.40.gcred",
        "nfe40_gCred_prod_id",
        string="Grupo de informações sobre",
        help="Grupo de informações sobre o CréditoPresumido",
    )

    nfe40_EXTIPI = fields.Char(string="Código EX TIPI (3 posições)")

    nfe40_CFOP = fields.Char(string="Cfop", xsd_required=True)

    nfe40_uCom = fields.Char(string="Unidade comercial", xsd_required=True)

    nfe40_qCom = fields.Float(
        string="Quantidade Comercial do produto",
        xsd_required=True,
        xsd_type="TDec_1104v",
        digits=(
            11,
            4,
        ),
        help=(
            "Quantidade Comercial  do produto, alterado para aceitar de 0 a 4 "
            "casas decimais e 11 inteiros."
        ),
    )

    nfe40_vUnCom = fields.Float(
        string="Valor unitário de comercialização",
        xsd_required=True,
        xsd_type="TDec_1110v",
        digits=(
            11,
            10,
        ),
        help=(
            "Valor unitário de comercialização  - alterado para aceitar 0 a 10"
            " casas decimais e 11 inteiros"
        ),
    )

    nfe40_vProd = fields.Monetary(
        string="Valor bruto do produto ou serviço",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_cEANTrib = fields.Char(
        string="GTIN (cEANTrib)",
        xsd_required=True,
        help=(
            "GTIN (Global Trade Item Number) da unidade tributável, antigo "
            "código EAN ou código de barras"
        ),
    )

    nfe40_cBarraTrib = fields.Char(
        string="Código de barras",
        help=(
            "Código de barras da unidade tributável diferente do padrão GTIN"
        ),
    )

    nfe40_uTrib = fields.Char(string="Unidade Tributável", xsd_required=True)

    nfe40_qTrib = fields.Float(
        string="Quantidade Tributável",
        xsd_required=True,
        xsd_type="TDec_1104v",
        digits=(
            11,
            4,
        ),
        help=(
            "Quantidade Tributável - alterado para aceitar de 0 a 4 casas "
            "decimais e 11 inteiros"
        ),
    )

    nfe40_vUnTrib = fields.Float(
        string="Valor unitário de tributação",
        xsd_required=True,
        xsd_type="TDec_1110v",
        digits=(
            11,
            10,
        ),
        help=(
            "Valor unitário de tributação - - alterado para aceitar 0 a 10 "
            "casas decimais e 11 inteiros"
        ),
    )

    nfe40_vFrete = fields.Monetary(
        string="Valor Total do Frete",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vSeg = fields.Monetary(
        string="Valor Total do Seguro",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vDesc = fields.Monetary(
        string="Valor do Desconto",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vOutro = fields.Monetary(
        string="Outras despesas acessórias",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_indTot = fields.Selection(
        PROD_INDTOT,
        string="Este campo deverá ser preenchido",
        xsd_required=True,
        help=(
            "Este campo deverá ser preenchido com:\n 0 – o valor do item "
            "(vProd) não compõe o valor total da NF-e (vProd)\n 1  – o valor "
            "do item (vProd) compõe o valor total da NF-e (vProd)"
        ),
    )

    nfe40_DI = fields.One2many(
        "nfe.40.di",
        "nfe40_DI_prod_id",
        string="Delcaração de Importação",
        help="Delcaração de Importação\n(NT 2011/004)",
    )

    nfe40_detExport = fields.One2many(
        "nfe.40.detexport",
        "nfe40_detExport_prod_id",
        string="Detalhe da exportação",
    )

    nfe40_xPed = fields.Char(
        string="pedido de compra",
        help=(
            "pedido de compra - Informação de interesse do emissor para "
            "controle do B2B."
        ),
    )

    nfe40_nItemPed = fields.Char(
        string="Número do Item do Pedido de Compra",
        help=(
            "Número do Item do Pedido de Compra - Identificação do número do "
            "item do pedido de Compra"
        ),
    )

    nfe40_nFCI = fields.Char(
        string="Número de controle da FCI",
        xsd_type="TGuid",
        help="Número de controle da FCI - Ficha de Conteúdo de Importação.",
    )

    nfe40_rastro = fields.One2many(
        "nfe.40.rastro", "nfe40_rastro_prod_id", string="rastro"
    )

    nfe40_infProdNFF = fields.Many2one(
        comodel_name="nfe.40.infprodnff",
        string="Informações mais detalhadas do produto",
        help="Informações mais detalhadas do produto (usada na NFF)",
    )

    nfe40_infProdEmb = fields.Many2one(
        comodel_name="nfe.40.infprodemb",
        string="infProdEmb",
        help="Informações mais detalhadas do produto (usada na NFF)",
    )

    nfe40_veicProd = fields.Many2one(
        comodel_name="nfe.40.veicprod", string="Veículos novos", choice="prod"
    )

    nfe40_med = fields.Many2one(
        comodel_name="nfe.40.med",
        string="grupo do detalhamento de Medicamentos",
        choice="prod",
        help=(
            "grupo do detalhamento de Medicamentos e de matérias-primas "
            "farmacêuticas"
        ),
    )

    nfe40_arma = fields.One2many(
        "nfe.40.arma", "nfe40_arma_prod_id", string="Armamentos", choice="prod"
    )

    nfe40_comb = fields.Many2one(
        comodel_name="nfe.40.comb",
        string="Informar apenas para operações",
        choice="prod",
        help="Informar apenas para operações com combustíveis líquidos",
    )

    nfe40_nRECOPI = fields.Char(string="Número do RECOPI", choice="prod")


class GCred(models.AbstractModel):
    "Grupo de informações sobre o CréditoPresumido"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.gcred"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Prod.GCred"

    nfe40_gCred_prod_id = fields.Many2one(
        comodel_name="nfe.40.prod", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_cCredPresumido = fields.Char(
        string="Código de Benefício Fiscal",
        xsd_required=True,
        help=(
            "Código de Benefício Fiscal de Crédito Presumido na UF aplicado ao"
            " item"
        ),
    )

    nfe40_pCredPresumido = fields.Float(
        string="Percentual do Crédito Presumido",
        xsd_required=True,
        xsd_type="TDec_0302a04",
        digits=(
            3,
            2,
        ),
    )

    nfe40_vCredPresumido = fields.Monetary(
        string="Valor do Crédito Presumido",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class Di(models.AbstractModel):
    """Delcaração de Importação
    (NT 2011/004)"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.di"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Prod.Di"

    nfe40_DI_prod_id = fields.Many2one(
        comodel_name="nfe.40.prod", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_nDI = fields.Char(
        string="Número do Documento de Importação",
        xsd_required=True,
        help=(
            "Número do Documento de Importação (DI, DSI, DIRE, DUImp) "
            "(NT2011/004)"
        ),
    )

    nfe40_dDI = fields.Date(
        string="Data de registro da DI/DSI/DA",
        xsd_required=True,
        xsd_type="TData",
        help="Data de registro da DI/DSI/DA (AAAA-MM-DD)",
    )

    nfe40_xLocDesemb = fields.Char(
        string="Local do desembaraço aduaneiro", xsd_required=True
    )

    nfe40_UFDesemb = fields.Selection(
        TUFEMI,
        string="UF onde ocorreu o desembaraço aduaneiro",
        xsd_required=True,
        xsd_type="TUfEmi",
    )

    nfe40_dDesemb = fields.Date(
        string="Data do desembaraço aduaneiro",
        xsd_required=True,
        xsd_type="TData",
        help="Data do desembaraço aduaneiro (AAAA-MM-DD)",
    )

    nfe40_tpViaTransp = fields.Selection(
        DI_TPVIATRANSP,
        string="Via",
        xsd_required=True,
        help=(
            "Via de transporte internacional informada na DI ou na Declaração "
            "Única de Importação (DUImp):\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1"
            "-Maritima;2-Fluvial;3-Lacustre;4-Aerea;5-Postal;6-Ferroviaria;7-"
            "Rodoviaria;8-Conduto;9-Meios Proprios;10-Entrada/Saida "
            "Ficta;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t11-Courier;12-Em "
            "maos;13-Por reboque."
        ),
    )

    nfe40_vAFRMM = fields.Monetary(
        string="Valor Adicional ao frete para renovação",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="Valor Adicional ao frete para renovação de marinha mercante",
    )

    nfe40_tpIntermedio = fields.Selection(
        DI_TPINTERMEDIO,
        string="Forma de Importação quanto",
        xsd_required=True,
        help=(
            "Forma de Importação quanto a intermediação "
            "\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1-por conta propria;2-por "
            "conta e ordem;3-encomenda"
        ),
    )

    nfe40_CNPJ = fields.Char(
        string="CNPJ do adquirente ou do encomendante",
        choice="di",
        xsd_type="TCnpj",
    )

    nfe40_CPF = fields.Char(
        string="CPF do adquirente ou do encomendante",
        choice="di",
        xsd_type="TCpf",
    )

    nfe40_UFTerceiro = fields.Selection(
        TUFEMI,
        string="Sigla da UF do adquirente",
        xsd_type="TUfEmi",
        help="Sigla da UF do adquirente ou do encomendante",
    )

    nfe40_cExportador = fields.Char(
        string="Código do exportador",
        xsd_required=True,
        help=(
            "Código do exportador (usado nos sistemas internos de informação "
            "do emitente da NF-e)"
        ),
    )

    nfe40_adi = fields.One2many(
        "nfe.40.adi", "nfe40_adi_DI_id", string="Adições (NT 2011/004)"
    )


class Adi(models.AbstractModel):
    "Adições (NT 2011/004)"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.adi"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Prod.Di.Adi"

    nfe40_adi_DI_id = fields.Many2one(
        comodel_name="nfe.40.di", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_nAdicao = fields.Char(string="Número da Adição")

    nfe40_nSeqAdic = fields.Char(
        string="Número seqüencial do item", xsd_required=True
    )

    nfe40_cFabricante = fields.Char(
        string="Código do fabricante estrangeiro",
        xsd_required=True,
        help=(
            "Código do fabricante estrangeiro (usado nos sistemas internos de "
            "informação do emitente da NF-e)"
        ),
    )

    nfe40_vDescDI = fields.Monetary(
        string="Valor do desconto do item",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_nDraw = fields.Char(string="Número do ato concessório de Drawback")


class DetExport(models.AbstractModel):
    "Detalhe da exportação"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.detexport"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Prod.DetExport"

    nfe40_detExport_prod_id = fields.Many2one(
        comodel_name="nfe.40.prod", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_nDraw = fields.Char(string="Número do ato concessório de Drawback")

    nfe40_exportInd = fields.Many2one(
        comodel_name="nfe.40.exportind", string="Exportação indireta"
    )


class ExportInd(models.AbstractModel):
    "Exportação indireta"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.exportind"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Prod.DetExport.ExportInd"

    nfe40_nRE = fields.Char(string="Registro de exportação", xsd_required=True)

    nfe40_chNFe = fields.Char(
        string="Chave de acesso da NF-e recebida",
        xsd_required=True,
        xsd_type="TChNFe",
        help="Chave de acesso da NF-e recebida para exportação",
    )

    nfe40_qExport = fields.Float(
        string="Quantidade",
        xsd_required=True,
        xsd_type="TDec_1104v",
        digits=(
            11,
            4,
        ),
        help="Quantidade do item efetivamente exportado",
    )


class Rastro(models.AbstractModel):
    _description = "rastro"
    _name = "nfe.40.rastro"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Prod.Rastro"

    nfe40_rastro_prod_id = fields.Many2one(
        comodel_name="nfe.40.prod", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_nLote = fields.Char(
        string="Número do lote do produto", xsd_required=True
    )

    nfe40_qLote = fields.Float(
        string="Quantidade de produto no lote",
        xsd_required=True,
        xsd_type="TDec_0803v",
        digits=(
            8,
            3,
        ),
    )

    nfe40_dFab = fields.Date(
        string="Data de fabricação/produção",
        xsd_required=True,
        xsd_type="TData",
        help="Data de fabricação/produção. Formato 'AAAA-MM-DD'.",
    )

    nfe40_dVal = fields.Date(
        string="Data de validade",
        xsd_required=True,
        xsd_type="TData",
        help=(
            "Data de validade. Informar o último dia do mês caso a validade "
            "não especifique o dia. Formato 'AAAA-MM-DD'."
        ),
    )

    nfe40_cAgreg = fields.Char(string="cAgreg")


class InfProdNff(models.AbstractModel):
    "Informações mais detalhadas do produto (usada na NFF)"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.infprodnff"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Prod.InfProdNff"

    nfe40_cProdFisco = fields.Char(
        string="Código Fiscal do Produto", xsd_required=True
    )

    nfe40_cOperNFF = fields.Char(
        string="Código da operação selecionada na NFF",
        xsd_required=True,
        help="Código da operação selecionada na NFF e relacionada ao item",
    )


class InfProdEmb(models.AbstractModel):
    "Informações mais detalhadas do produto (usada na NFF)"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.infprodemb"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Prod.InfProdEmb"

    nfe40_xEmb = fields.Char(string="Embalagem do produto", xsd_required=True)

    nfe40_qVolEmb = fields.Float(
        string="Volume do produto na embalagem",
        xsd_required=True,
        xsd_type="TDec_0803v",
        digits=(
            8,
            3,
        ),
    )

    nfe40_uEmb = fields.Char(
        string="Unidade de Medida da Embalagem", xsd_required=True
    )


class VeicProd(models.AbstractModel):
    "Veículos novos"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.veicprod"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Prod.VeicProd"

    nfe40_tpOp = fields.Selection(
        VEICPROD_TPOP,
        string="Tipo da Operação",
        xsd_required=True,
        help=(
            "Tipo da Operação (1 - Venda concessionária; 2 - Faturamento "
            "direto; 3 - Venda direta; 0 - Outros)"
        ),
    )

    nfe40_chassi = fields.Char(
        string="Chassi do veículo - VIN",
        xsd_required=True,
        help="Chassi do veículo - VIN (código-identificação-veículo)",
    )

    nfe40_cCor = fields.Char(
        string="Cor do veículo",
        xsd_required=True,
        help="Cor do veículo (código de cada montadora)",
    )

    nfe40_xCor = fields.Char(string="Descrição da cor", xsd_required=True)

    nfe40_pot = fields.Char(
        string="Potência máxima do motor do veículo",
        xsd_required=True,
        help=(
            "Potência máxima do motor do veículo em cavalo vapor (CV). "
            "(potência-veículo)"
        ),
    )

    nfe40_cilin = fields.Char(
        string="Capacidade voluntária do motor expressa",
        xsd_required=True,
        help=(
            "Capacidade voluntária do motor expressa em centímetros cúbicos "
            "(CC). (cilindradas)"
        ),
    )

    nfe40_pesoL = fields.Char(string="Peso líquido", xsd_required=True)

    nfe40_pesoB = fields.Char(string="Peso bruto", xsd_required=True)

    nfe40_nSerie = fields.Char(string="Serial (série)", xsd_required=True)

    nfe40_tpComb = fields.Char(
        string="Tipo de combustível-Tabela RENAVAM",
        xsd_required=True,
        help=(
            "Tipo de combustível-Tabela RENAVAM: 01-Álcool; 02-Gasolina; "
            "03-Diesel; 16-Álcool/Gas.; 17-Gas./Álcool/GNV; "
            "18-Gasolina/Elétrico"
        ),
    )

    nfe40_nMotor = fields.Char(string="Número do motor", xsd_required=True)

    nfe40_CMT = fields.Char(
        string="CMT-Capacidade Máxima de Tração",
        xsd_required=True,
        help=(
            "CMT-Capacidade Máxima de Tração - em Toneladas 4 casas decimais"
        ),
    )

    nfe40_dist = fields.Char(string="Distância entre eixos", xsd_required=True)

    nfe40_anoMod = fields.Char(
        string="Ano Modelo de Fabricação", xsd_required=True
    )

    nfe40_anoFab = fields.Char(string="Ano de Fabricação", xsd_required=True)

    nfe40_tpPint = fields.Char(string="Tipo de pintura", xsd_required=True)

    nfe40_tpVeic = fields.Char(
        string="Tipo de veículo",
        xsd_required=True,
        help="Tipo de veículo (utilizar tabela RENAVAM)",
    )

    nfe40_espVeic = fields.Char(
        string="Espécie de veículo",
        xsd_required=True,
        help="Espécie de veículo (utilizar tabela RENAVAM)",
    )

    nfe40_VIN = fields.Selection(
        VEICPROD_VIN,
        string="Informa-se o veículo tem VIN",
        xsd_required=True,
        help=(
            "Informa-se o veículo tem VIN (chassi) remarcado.\nR-Remarcado\nN-"
            "NormalVIN"
        ),
    )

    nfe40_condVeic = fields.Selection(
        VEICPROD_CONDVEIC,
        string="Condição do veículo",
        xsd_required=True,
        help=(
            "Condição do veículo (1 - acabado; 2 - inacabado; 3 - semi-"
            "acabado)"
        ),
    )

    nfe40_cMod = fields.Char(
        string="Código Marca Modelo",
        xsd_required=True,
        help="Código Marca Modelo (utilizar tabela RENAVAM)",
    )

    nfe40_cCorDENATRAN = fields.Char(
        string="Código da Cor Segundo as regras",
        xsd_required=True,
        help=(
            "Código da Cor Segundo as regras de pré-cadastro do DENATRAN: "
            "01-AMARELO;02-AZUL;03-BEGE;04-BRANCA;05-CINZA;06-DOURADA;07-GRENA"
            " \n08-LARANJA;09-MARROM;10-PRATA;11-PRETA;12-ROSA;13-ROXA;14-"
            "VERDE;15-VERMELHA;16-FANTASIA"
        ),
    )

    nfe40_lota = fields.Char(
        string="Quantidade máxima de permitida",
        xsd_required=True,
        help=(
            "Quantidade máxima de permitida de passageiros sentados, inclusive"
            " motorista."
        ),
    )

    nfe40_tpRest = fields.Selection(
        VEICPROD_TPREST,
        string="Restrição",
        xsd_required=True,
        help=(
            "Restrição\n0 - Não há;\n1 - Alienação Fiduciária;\n2 - "
            "Arrendamento Mercantil;\n3 - Reserva de Domínio;\n4 - Penhor de "
            "Veículos;\n9 - outras."
        ),
    )


class Med(models.AbstractModel):
    """grupo do detalhamento de Medicamentos e de matérias-primas
    farmacêuticas"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.med"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Prod.Med"

    nfe40_cProdANVISA = fields.Char(
        string="Utilizar o número do registro ANVISA",
        xsd_required=True,
        help=(
            "Utilizar o número do registro ANVISA  ou preencher com o literal "
            "“ISENTO”, no caso de medicamento isento de registro na ANVISA."
        ),
    )

    nfe40_xMotivoIsencao = fields.Char(
        string="Obs",
        help=(
            "Obs.: Para medicamento isento de registro na ANVISA, informar o "
            "número da decisão que o isenta, como por exemplo o número da "
            "Resolução da Diretoria Colegiada da ANVISA (RDC)."
        ),
    )

    nfe40_vPMC = fields.Monetary(
        string="Preço Máximo ao Consumidor",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class Arma(models.AbstractModel):
    "Armamentos"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.arma"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Prod.Arma"

    nfe40_arma_prod_id = fields.Many2one(
        comodel_name="nfe.40.prod", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_tpArma = fields.Selection(
        ARMA_TPARMA,
        string="Indicador do tipo de arma de fogo",
        xsd_required=True,
        help=(
            "Indicador do tipo de arma de fogo (0 - Uso permitido; 1 - Uso "
            "restrito)"
        ),
    )

    nfe40_nSerie = fields.Char(
        string="Número de série da arma", xsd_required=True
    )

    nfe40_nCano = fields.Char(
        string="Número de série do cano", xsd_required=True
    )

    nfe40_descr = fields.Char(
        string="Descrição completa da arma",
        xsd_required=True,
        help=(
            "Descrição completa da arma, compreendendo: calibre, marca, "
            "capacidade, tipo de funcionamento, comprimento e demais elementos"
            " que permitam a sua perfeita identificação."
        ),
    )


class Comb(models.AbstractModel):
    "Informar apenas para operações com combustíveis líquidos"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.comb"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Prod.Comb"

    nfe40_cProdANP = fields.Char(
        string="Código de produto da ANP",
        xsd_required=True,
        help=(
            "Código de produto da ANP. codificação de produtos do SIMP "
            "(http://www.anp.gov.br)"
        ),
    )

    nfe40_descANP = fields.Char(
        string="Descrição do Produto conforme ANP",
        xsd_required=True,
        help=(
            "Descrição do Produto conforme ANP. Utilizar a descrição de "
            "produtos do Sistema de Informações de Movimentação de Produtos - "
            "SIMP (http://www.anp.gov.br/simp/)."
        ),
    )

    nfe40_pGLP = fields.Float(
        string="Percentual do GLP derivado do petróleo",
        xsd_type="TDec_0302a04Max100",
        digits=(
            3,
            2,
        ),
        help=(
            "Percentual do GLP derivado do petróleo no produto GLP "
            "(cProdANP=210203001). Informar em número decimal o percentual do "
            "GLP derivado de petróleo no produto GLP. Valores 0 a 100."
        ),
    )

    nfe40_pGNn = fields.Float(
        string="Percentual de gás natural nacional",
        xsd_type="TDec_0302a04Max100",
        digits=(
            3,
            2,
        ),
        help=(
            "Percentual de gás natural nacional - GLGNn para o produto GLP "
            "(cProdANP=210203001). Informar em número decimal o percentual do "
            "Gás Natural Nacional - GLGNn para o produto GLP. Valores de 0 a "
            "100."
        ),
    )

    nfe40_pGNi = fields.Float(
        string="Percentual",
        xsd_type="TDec_0302a04Max100",
        digits=(
            3,
            2,
        ),
        help=(
            "Percentual de gás natural importado GLGNi para o produto GLP "
            "(cProdANP=210203001). Informar em número deciaml o percentual do "
            "Gás Natural Importado - GLGNi para o produto GLP. Valores de 0 a "
            "100."
        ),
    )

    nfe40_vPart = fields.Monetary(
        string="Valor de partida",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor de partida (cProdANP=210203001). Deve ser informado neste "
            "campo o valor por quilograma sem ICMS."
        ),
    )

    nfe40_CODIF = fields.Char(
        string="Código de autorização / registro",
        help=(
            "Código de autorização / registro do CODIF. Informar apenas quando"
            " a UF utilizar o CODIF (Sistema de Controle do \t\t\tDiferimento "
            "do Imposto nas Operações com AEAC - Álcool Etílico Anidro "
            "Combustível)."
        ),
    )

    nfe40_qTemp = fields.Float(
        string="Quantidade de combustível",
        xsd_type="TDec_1204temperatura",
        digits=(
            12,
            4,
        ),
        help=(
            "Quantidade de combustível\nfaturada à temperatura "
            "ambiente.\nInformar quando a quantidade\nfaturada informada no "
            "campo\nqCom (I10) tiver sido ajustada para\numa temperatura "
            "diferente da\nambiente."
        ),
    )

    nfe40_UFCons = fields.Selection(
        TUF, string="Sigla da UF de Consumo", xsd_required=True, xsd_type="TUf"
    )

    nfe40_CIDE = fields.Many2one(
        comodel_name="nfe.40.cide", string="CIDE Combustíveis"
    )

    nfe40_encerrante = fields.Many2one(
        comodel_name="nfe.40.encerrante",
        string="Informações do grupo de 'encerrante'",
    )

    nfe40_pBio = fields.Float(
        string="Percentual do índice de mistura",
        xsd_type="TDec_03v00a04Max100Opc",
        digits=(
            3,
            0,
        ),
        help=(
            "Percentual do índice de mistura do Biodiesel (B100) no Óleo "
            "Diesel B instituído pelo órgão regulamentador"
        ),
    )

    nfe40_origComb = fields.One2many(
        "nfe.40.origcomb",
        "nfe40_origComb_comb_id",
        string="Grupo indicador da origem do combustível",
    )


class Cide(models.AbstractModel):
    "CIDE Combustíveis"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.cide"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Prod.Comb.Cide"

    nfe40_qBCProd = fields.Float(
        string="BC do CIDE",
        xsd_required=True,
        xsd_type="TDec_1204v",
        digits=(
            12,
            4,
        ),
        help="BC do CIDE ( Quantidade comercializada)",
    )

    nfe40_vAliqProd = fields.Float(
        string="Alíquota do CIDE (em reais)",
        xsd_required=True,
        xsd_type="TDec_1104",
        digits=(
            11,
            4,
        ),
        help="Alíquota do CIDE  (em reais)",
    )

    nfe40_vCIDE = fields.Monetary(
        string="Valor do CIDE",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class Encerrante(models.AbstractModel):
    """Informações do grupo de "encerrante" """

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.encerrante"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Prod.Comb.Encerrante"

    nfe40_nBico = fields.Char(
        string="Numero de identificação",
        xsd_required=True,
        help="Numero de identificação do Bico utilizado no abastecimento",
    )

    nfe40_nBomba = fields.Char(
        string="Numero de identificação da bomba",
        help=(
            "Numero de identificação da bomba ao qual o bico está interligado"
        ),
    )

    nfe40_nTanque = fields.Char(
        string="Numero de identificação do tanque",
        xsd_required=True,
        help=(
            "Numero de identificação do tanque ao qual o bico está interligado"
        ),
    )

    nfe40_vEncIni = fields.Float(
        string="Valor do Encerrante no ínicio",
        xsd_required=True,
        xsd_type="TDec_1203",
        digits=(
            12,
            3,
        ),
        help="Valor do Encerrante no ínicio do abastecimento",
    )

    nfe40_vEncFin = fields.Float(
        string="Valor do Encerrante no final",
        xsd_required=True,
        xsd_type="TDec_1203",
        digits=(
            12,
            3,
        ),
        help="Valor do Encerrante no final do abastecimento",
    )


class OrigComb(models.AbstractModel):
    "Grupo indicador da origem do combustível"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.origcomb"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Prod.Comb.OrigComb"

    nfe40_origComb_comb_id = fields.Many2one(
        comodel_name="nfe.40.comb", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_indImport = fields.Selection(
        ORIGCOMB_INDIMPORT,
        string="Indicador",
        xsd_required=True,
        help="Indicador de importação 0=Nacional; 1=Importado;",
    )

    nfe40_cUFOrig = fields.Selection(
        TCODUFIBGE,
        string="UF de origem do produtor ou do importado",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    nfe40_pOrig = fields.Float(
        string="Percentual originário para a UF",
        xsd_required=True,
        xsd_type="TDec_03v00a04Max100Opc",
        digits=(
            3,
            0,
        ),
    )


class Imposto(models.AbstractModel):
    "Tributos incidentes nos produtos ou serviços da NF-e"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.imposto"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto"

    nfe40_vTotTrib = fields.Monetary(
        string="Valor estimado total",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor estimado total de impostos federais, estaduais e municipais"
        ),
    )

    nfe40_ICMS = fields.Many2one(
        comodel_name="nfe.40.icms",
        string="Dados do ICMS Normal e ST",
        choice="imposto",
        xsd_choice_required=True,
    )

    nfe40_IPI = fields.Many2one(
        comodel_name="nfe.40.tipi",
        string="IPI",
        choice="imposto",
        xsd_choice_required=True,
        xsd_type="TIpi",
    )

    nfe40_II = fields.Many2one(
        comodel_name="nfe.40.ii",
        string="Dados do Imposto de Importação",
        choice="imposto",
        xsd_choice_required=True,
    )

    nfe40_ISSQN = fields.Many2one(
        comodel_name="nfe.40.issqn",
        string="ISSQN",
        choice="imposto",
        xsd_choice_required=True,
    )

    nfe40_PIS = fields.Many2one(
        comodel_name="nfe.40.pis", string="Dados do PIS"
    )

    nfe40_PISST = fields.Many2one(
        comodel_name="nfe.40.pisst",
        string="Dados do PIS Substituição Tributária",
    )

    nfe40_COFINS = fields.Many2one(
        comodel_name="nfe.40.cofins", string="Dados do COFINS"
    )

    nfe40_COFINSST = fields.Many2one(
        comodel_name="nfe.40.cofinsst",
        string="Dados do COFINS (COFINSST)",
        help="Dados do COFINS da\nSubstituição Tributaria;",
    )

    nfe40_ICMSUFDest = fields.Many2one(
        comodel_name="nfe.40.icmsufdest",
        string="Grupo a ser informado",
        help=(
            "Grupo a ser informado nas vendas interestarduais para consumidor "
            "final, não contribuinte de ICMS"
        ),
    )


class Pis(models.AbstractModel):
    "Dados do PIS"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.pis"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Pis"

    nfe40_PISAliq = fields.Many2one(
        comodel_name="nfe.40.pisaliq",
        string="Código de Situação Tributária do PIS",
        choice="pis",
        xsd_choice_required=True,
        help=(
            "Código de Situação Tributária do PIS.\n 01 – Operação Tributável "
            "- Base de Cálculo = Valor da Operação Alíquota Normal "
            "(Cumulativo/Não Cumulativo);\n02 - Operação Tributável - Base de "
            "Calculo = Valor da Operação (Alíquota Diferenciada);"
        ),
    )

    nfe40_PISQtde = fields.Many2one(
        comodel_name="nfe.40.pisqtde",
        string="PISQtde",
        choice="pis",
        xsd_choice_required=True,
        help=(
            "Código de Situação Tributária do PIS.\n03 - Operação Tributável -"
            " Base de Calculo = Quantidade Vendida x Alíquota por Unidade de "
            "Produto;"
        ),
    )

    nfe40_PISNT = fields.Many2one(
        comodel_name="nfe.40.pisnt",
        string="PISNT",
        choice="pis",
        xsd_choice_required=True,
        help=(
            "Código de Situação Tributária do PIS.\n04 - Operação Tributável -"
            " Tributação Monofásica - (Alíquota Zero);\n06 - Operação "
            "Tributável - Alíquota Zero;\n07 - Operação Isenta da "
            "contribuição;\n08 - Operação Sem Incidência da contribuição;\n09 "
            "- Operação com suspensão da contribuição;"
        ),
    )

    nfe40_PISOutr = fields.Many2one(
        comodel_name="nfe.40.pisoutr",
        string="PISOutr",
        choice="pis",
        xsd_choice_required=True,
        help=("Código de Situação Tributária do PIS.\n99 - Outras Operações."),
    )


class Pisaliq(models.AbstractModel):
    """Código de Situação Tributária do PIS.
    01 – Operação Tributável - Base de Cálculo = Valor da Operação Alíquota Normal
    (Cumulativo/Não Cumulativo);
    02 - Operação Tributável - Base de Calculo = Valor da Operação (Alíquota
    Diferenciada);"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.pisaliq"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Pis.Pisaliq"

    nfe40_CST = fields.Selection(
        PISALIQ_CST,
        string="Código de Situação Tributária do PIS",
        xsd_required=True,
        help=(
            "Código de Situação Tributária do PIS.\n 01 – Operação Tributável "
            "- Base de Cálculo = Valor da Operação Alíquota Normal "
            "(Cumulativo/Não Cumulativo);\n02 - Operação Tributável - Base de "
            "Calculo = Valor da Operação (Alíquota Diferenciada);"
        ),
    )

    nfe40_vBC = fields.Monetary(
        string="Valor da BC do PIS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_pPIS = fields.Float(
        string="Alíquota do PIS (em percentual)",
        xsd_required=True,
        xsd_type="TDec_0302a04",
        digits=(
            3,
            2,
        ),
    )

    nfe40_vPIS = fields.Monetary(
        string="Valor do PIS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class Pisqtde(models.AbstractModel):
    """Código de Situação Tributária do PIS.
    03 - Operação Tributável - Base de Calculo = Quantidade Vendida x Alíquota por
    Unidade de Produto;"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.pisqtde"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Pis.Pisqtde"

    nfe40_CST = fields.Selection(
        PISQTDE_CST,
        string="Código de Situação Tributária do PIS",
        xsd_required=True,
        help=(
            "Código de Situação Tributária do PIS.\n03 - Operação Tributável -"
            " Base de Calculo = Quantidade Vendida x Alíquota por Unidade de "
            "Produto;"
        ),
    )

    nfe40_qBCProd = fields.Float(
        string="Quantidade Vendida (NT2011/004)",
        xsd_required=True,
        xsd_type="TDec_1204v",
        digits=(
            12,
            4,
        ),
        help="Quantidade Vendida  (NT2011/004)",
    )

    nfe40_vAliqProd = fields.Float(
        string="Alíquota do PIS (em reais)",
        xsd_required=True,
        xsd_type="TDec_1104v",
        digits=(
            11,
            4,
        ),
        help="Alíquota do PIS (em reais) (NT2011/004)",
    )

    nfe40_vPIS = fields.Monetary(
        string="Valor do PIS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class Pisnt(models.AbstractModel):
    """Código de Situação Tributária do PIS.
    04 - Operação Tributável - Tributação Monofásica - (Alíquota Zero);
    06 - Operação Tributável - Alíquota Zero;
    07 - Operação Isenta da contribuição;
    08 - Operação Sem Incidência da contribuição;
    09 - Operação com suspensão da contribuição;"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.pisnt"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Pis.Pisnt"

    nfe40_CST = fields.Selection(
        PISNT_CST,
        string="Código de Situação Tributária do PIS",
        xsd_required=True,
        help=(
            "Código de Situação Tributária do PIS.\n04 - Operação Tributável -"
            " Tributação Monofásica - (Alíquota Zero);\n05 - Operação "
            "Tributável (ST);\n06 - Operação Tributável - Alíquota Zero;\n07 -"
            " Operação Isenta da contribuição;\n08 - Operação Sem Incidência "
            "da contribuição;\n09 - Operação com suspensão da contribuição;"
        ),
    )


class Pisoutr(models.AbstractModel):
    """Código de Situação Tributária do PIS.
    99 - Outras Operações."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.pisoutr"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Pis.Pisoutr"

    nfe40_CST = fields.Selection(
        PISOUTR_CST,
        string="Código de Situação Tributária do PIS",
        xsd_required=True,
        help=("Código de Situação Tributária do PIS.\n99 - Outras Operações."),
    )

    nfe40_vBC = fields.Monetary(
        string="Valor da BC do PIS",
        choice="pisoutr",
        xsd_choice_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_pPIS = fields.Float(
        string="Alíquota do PIS (em percentual)",
        choice="pisoutr",
        xsd_choice_required=True,
        xsd_type="TDec_0302a04",
        digits=(
            3,
            2,
        ),
    )

    nfe40_qBCProd = fields.Float(
        string="Quantidade Vendida (NT2011/004)",
        choice="pisoutr",
        xsd_choice_required=True,
        xsd_type="TDec_1204v",
        digits=(
            12,
            4,
        ),
    )

    nfe40_vAliqProd = fields.Float(
        string="Alíquota do PIS (em reais)",
        choice="pisoutr",
        xsd_choice_required=True,
        xsd_type="TDec_1104v",
        digits=(
            11,
            4,
        ),
        help="Alíquota do PIS (em reais) (NT2011/004)",
    )

    nfe40_vPIS = fields.Monetary(
        string="Valor do PIS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class Pisst(models.AbstractModel):
    "Dados do PIS Substituição Tributária"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.pisst"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Pisst"

    nfe40_vBC = fields.Monetary(
        string="Valor da BC do PIS ST",
        choice="pisst",
        xsd_choice_required=True,
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_pPIS = fields.Float(
        string="Alíquota do PIS ST (em percentual)",
        choice="pisst",
        xsd_choice_required=True,
        xsd_type="TDec_0302a04",
        digits=(
            3,
            2,
        ),
    )

    nfe40_qBCProd = fields.Float(
        string="Quantidade Vendida",
        choice="pisst",
        xsd_choice_required=True,
        xsd_type="TDec_1204",
        digits=(
            12,
            4,
        ),
    )

    nfe40_vAliqProd = fields.Float(
        string="Alíquota do PIS ST (em reais)",
        choice="pisst",
        xsd_choice_required=True,
        xsd_type="TDec_1104",
        digits=(
            11,
            4,
        ),
    )

    nfe40_vPIS = fields.Monetary(
        string="Valor do PIS ST",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_indSomaPISST = fields.Selection(
        PISST_INDSOMAPISST,
        string="Indica se o valor do PISST compõe",
        help="Indica se o valor do PISST compõe o valor total da NF-e",
    )


class Cofins(models.AbstractModel):
    "Dados do COFINS"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.cofins"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Cofins"

    nfe40_COFINSAliq = fields.Many2one(
        comodel_name="nfe.40.cofinsaliq",
        string="Código de Situação Tributária do COFINS",
        choice="cofins",
        xsd_choice_required=True,
        help=(
            "Código de Situação Tributária do COFINS.\n 01 – Operação "
            "Tributável - Base de Cálculo = Valor da Operação Alíquota Normal "
            "(Cumulativo/Não Cumulativo);\n02 - Operação Tributável - Base de "
            "Calculo = Valor da Operação (Alíquota Diferenciada);"
        ),
    )

    nfe40_COFINSQtde = fields.Many2one(
        comodel_name="nfe.40.cofinsqtde",
        string="COFINSQtde",
        choice="cofins",
        xsd_choice_required=True,
        help=(
            "Código de Situação Tributária do COFINS.\n03 - Operação "
            "Tributável - Base de Calculo = Quantidade Vendida x Alíquota por "
            "Unidade de Produto;"
        ),
    )

    nfe40_COFINSNT = fields.Many2one(
        comodel_name="nfe.40.cofinsnt",
        string="COFINSNT",
        choice="cofins",
        xsd_choice_required=True,
        help=(
            "Código de Situação Tributária do COFINS:\n04 - Operação "
            "Tributável - Tributação Monofásica - (Alíquota Zero);\n06 - "
            "Operação Tributável - Alíquota Zero;\n07 - Operação Isenta da "
            "contribuição;\n08 - Operação Sem Incidência da contribuição;\n09 "
            "- Operação com suspensão da contribuição;"
        ),
    )

    nfe40_COFINSOutr = fields.Many2one(
        comodel_name="nfe.40.cofinsoutr",
        string="COFINSOutr",
        choice="cofins",
        xsd_choice_required=True,
        help=(
            "Código de Situação Tributária do COFINS:\n49 - Outras Operações "
            "de Saída\n50 - Operação com Direito a Crédito - Vinculada "
            "Exclusivamente a Receita Tributada no Mercado Interno\n51 - "
            "Operação com Direito a Crédito – Vinculada Exclusivamente a "
            "Receita Não Tributada no Mercado Interno\n52 - Operação com "
            "Direito a Crédito - Vinculada Exclusivamente a Receita de "
            "Exportação\n53 - Operação com Direito a Crédito - Vinculada a "
            "Receitas Tributadas e Não-Tributadas no Mercado Interno\n54 - "
            "Operação com Direito a Crédito - Vinculada a Receitas Tributadas "
            "no Mercado Interno e de Exportação\n55 - Operação com Direito a "
            "Crédito - Vinculada a Receitas Não-Tributadas no Mercado Interno "
            "e de Exportação\n56 - Operação com Direito a Crédito - Vinculada "
            "a Receitas Tributadas e Não-Tributadas no Mercado Interno, e de "
            "Exportação\n60 - Crédito Presumido - Operação de Aquisição "
            "Vinculada Exclusivamente a Receita Tributada no Mercado "
            "Interno\n61 - Crédito Presumido - Operação de Aquisição Vinculada"
            " Exclusivamente a Receita Não-Tributada no Mercado Interno\n62 - "
            "Crédito Presumido - Operação de Aquisição Vinculada "
            "Exclusivamente a Receita de Exportação\n63 - Crédito Presumido - "
            "Operação de Aquisição Vinculada a Receitas Tributadas e Não-"
            "Tributadas no Mercado Interno\n64 - Crédito Presumido - Operação "
            "de Aquisição Vinculada a Receitas Tributadas no Mercado Interno e"
            " de Exportação\n65 - Crédito Presumido - Operação de Aquisição "
            "Vinculada a Receitas Não-Tributadas no Mercado Interno e de "
            "Exportação\n66 - Crédito Presumido - Operação de Aquisição "
            "Vinculada a Receitas Tributadas e Não-Tributadas no Mercado "
            "Interno, e de Exportação\n67 - Crédito Presumido - Outras "
            "Operações\n70 - Operação de Aquisição sem Direito a Crédito\n71 -"
            " Operação de Aquisição com Isenção\n72 - Operação de Aquisição "
            "com Suspensão\n73 - Operação de Aquisição a Alíquota Zero\n74 - "
            "Operação de Aquisição sem Incidência da Contribuição\n75 - "
            "Operação de Aquisição por Substituição Tributária\n98 - Outras "
            "Operações de Entrada\n99 - Outras Operações."
        ),
    )


class Cofinsaliq(models.AbstractModel):
    """Código de Situação Tributária do COFINS.
    01 – Operação Tributável - Base de Cálculo = Valor da Operação Alíquota Normal
    (Cumulativo/Não Cumulativo);
    02 - Operação Tributável - Base de Calculo = Valor da Operação (Alíquota
    Diferenciada);"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.cofinsaliq"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Cofins.Cofinsaliq"

    nfe40_CST = fields.Selection(
        COFINSALIQ_CST,
        string="Código de Situação Tributária do COFINS",
        xsd_required=True,
        help=(
            "Código de Situação Tributária do COFINS.\n 01 – Operação "
            "Tributável - Base de Cálculo = Valor da Operação Alíquota Normal "
            "(Cumulativo/Não Cumulativo);\n02 - Operação Tributável - Base de "
            "Calculo = Valor da Operação (Alíquota Diferenciada);"
        ),
    )

    nfe40_vBC = fields.Monetary(
        string="Valor da BC do COFINS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_pCOFINS = fields.Float(
        string="Alíquota do COFINS (em percentual)",
        xsd_required=True,
        xsd_type="TDec_0302a04",
        digits=(
            3,
            2,
        ),
    )

    nfe40_vCOFINS = fields.Monetary(
        string="Valor do COFINS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class Cofinsqtde(models.AbstractModel):
    """Código de Situação Tributária do COFINS.
    03 - Operação Tributável - Base de Calculo = Quantidade Vendida x Alíquota por
    Unidade de Produto;"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.cofinsqtde"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Cofins.Cofinsqtde"

    nfe40_CST = fields.Selection(
        COFINSQTDE_CST,
        string="Código de Situação Tributária do COFINS",
        xsd_required=True,
        help=(
            "Código de Situação Tributária do COFINS.\n03 - Operação "
            "Tributável - Base de Calculo = Quantidade Vendida x Alíquota por "
            "Unidade de Produto;"
        ),
    )

    nfe40_qBCProd = fields.Float(
        string="Quantidade Vendida (NT2011/004)",
        xsd_required=True,
        xsd_type="TDec_1204v",
        digits=(
            12,
            4,
        ),
    )

    nfe40_vAliqProd = fields.Float(
        string="Alíquota do COFINS (em reais)",
        xsd_required=True,
        xsd_type="TDec_1104v",
        digits=(
            11,
            4,
        ),
        help="Alíquota do COFINS (em reais) (NT2011/004)",
    )

    nfe40_vCOFINS = fields.Monetary(
        string="Valor do COFINS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class Cofinsnt(models.AbstractModel):
    """Código de Situação Tributária do COFINS:
    04 - Operação Tributável - Tributação Monofásica - (Alíquota Zero);
    06 - Operação Tributável - Alíquota Zero;
    07 - Operação Isenta da contribuição;
    08 - Operação Sem Incidência da contribuição;
    09 - Operação com suspensão da contribuição;"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.cofinsnt"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Cofins.Cofinsnt"

    nfe40_CST = fields.Selection(
        COFINSNT_CST,
        string="Código de Situação Tributária do COFINS",
        xsd_required=True,
        help=(
            "Código de Situação Tributária do COFINS:\n04 - Operação "
            "Tributável - Tributação Monofásica - (Alíquota Zero);\n05 - "
            "Operação Tributável (ST);\n06 - Operação Tributável - Alíquota "
            "Zero;\n07 - Operação Isenta da contribuição;\n08 - Operação Sem "
            "Incidência da contribuição;\n09 - Operação com suspensão da "
            "contribuição;"
        ),
    )


class Cofinsoutr(models.AbstractModel):
    """Código de Situação Tributária do COFINS:
    49 - Outras Operações de Saída
    50 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita
    Tributada no Mercado Interno
    51 - Operação com Direito a Crédito – Vinculada Exclusivamente a Receita Não
    Tributada no Mercado Interno
    52 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita de
    Exportação
    53 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas e Não-
    Tributadas no Mercado Interno
    54 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas no
    Mercado Interno e de Exportação
    55 - Operação com Direito a Crédito - Vinculada a Receitas Não-Tributadas no
    Mercado Interno e de Exportação
    56 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas e Não-
    Tributadas no Mercado Interno, e de Exportação
    60 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a
    Receita Tributada no Mercado Interno
    61 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a
    Receita Não-Tributada no Mercado Interno
    62 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a
    Receita de Exportação
    63 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas
    e Não-Tributadas no Mercado Interno
    64 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas
    no Mercado Interno e de Exportação
    65 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Não-
    Tributadas no Mercado Interno e de Exportação
    66 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas
    e Não-Tributadas no Mercado Interno, e de Exportação
    67 - Crédito Presumido - Outras Operações
    70 - Operação de Aquisição sem Direito a Crédito
    71 - Operação de Aquisição com Isenção
    72 - Operação de Aquisição com Suspensão
    73 - Operação de Aquisição a Alíquota Zero
    74 - Operação de Aquisição sem Incidência da Contribuição
    75 - Operação de Aquisição por Substituição Tributária
    98 - Outras Operações de Entrada
    99 - Outras Operações."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.cofinsoutr"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Cofins.Cofinsoutr"

    nfe40_CST = fields.Selection(
        COFINSOUTR_CST,
        string="Código de Situação Tributária do COFINS",
        xsd_required=True,
        help=(
            "Código de Situação Tributária do COFINS:\n49 - Outras Operações "
            "de Saída\n50 - Operação com Direito a Crédito - Vinculada "
            "Exclusivamente a Receita Tributada no Mercado Interno\n51 - "
            "Operação com Direito a Crédito – Vinculada Exclusivamente a "
            "Receita Não Tributada no Mercado Interno\n52 - Operação com "
            "Direito a Crédito - Vinculada Exclusivamente a Receita de "
            "Exportação\n53 - Operação com Direito a Crédito - Vinculada a "
            "Receitas Tributadas e Não-Tributadas no Mercado Interno\n54 - "
            "Operação com Direito a Crédito - Vinculada a Receitas Tributadas "
            "no Mercado Interno e de Exportação\n55 - Operação com Direito a "
            "Crédito - Vinculada a Receitas Não-Tributadas no Mercado Interno "
            "e de Exportação\n56 - Operação com Direito a Crédito - Vinculada "
            "a Receitas Tributadas e Não-Tributadas no Mercado Interno, e de "
            "Exportação\n60 - Crédito Presumido - Operação de Aquisição "
            "Vinculada Exclusivamente a Receita Tributada no Mercado "
            "Interno\n61 - Crédito Presumido - Operação de Aquisição Vinculada"
            " Exclusivamente a Receita Não-Tributada no Mercado Interno\n62 - "
            "Crédito Presumido - Operação de Aquisição Vinculada "
            "Exclusivamente a Receita de Exportação\n63 - Crédito Presumido - "
            "Operação de Aquisição Vinculada a Receitas Tributadas e Não-"
            "Tributadas no Mercado Interno\n64 - Crédito Presumido - Operação "
            "de Aquisição Vinculada a Receitas Tributadas no Mercado Interno e"
            " de Exportação\n65 - Crédito Presumido - Operação de Aquisição "
            "Vinculada a Receitas Não-Tributadas no Mercado Interno e de "
            "Exportação\n66 - Crédito Presumido - Operação de Aquisição "
            "Vinculada a Receitas Tributadas e Não-Tributadas no Mercado "
            "Interno, e de Exportação\n67 - Crédito Presumido - Outras "
            "Operações\n70 - Operação de Aquisição sem Direito a Crédito\n71 -"
            " Operação de Aquisição com Isenção\n72 - Operação de Aquisição "
            "com Suspensão\n73 - Operação de Aquisição a Alíquota Zero\n74 - "
            "Operação de Aquisição sem Incidência da Contribuição\n75 - "
            "Operação de Aquisição por Substituição Tributária\n98 - Outras "
            "Operações de Entrada\n99 - Outras Operações."
        ),
    )

    nfe40_vBC = fields.Monetary(
        string="Valor da BC do COFINS",
        choice="cofinsoutr",
        xsd_choice_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_pCOFINS = fields.Float(
        string="Alíquota do COFINS (em percentual)",
        choice="cofinsoutr",
        xsd_choice_required=True,
        xsd_type="TDec_0302a04",
        digits=(
            3,
            2,
        ),
    )

    nfe40_qBCProd = fields.Float(
        string="Quantidade Vendida (NT2011/004)",
        choice="cofinsoutr",
        xsd_choice_required=True,
        xsd_type="TDec_1204v",
        digits=(
            12,
            4,
        ),
    )

    nfe40_vAliqProd = fields.Float(
        string="Alíquota do COFINS (em reais)",
        choice="cofinsoutr",
        xsd_choice_required=True,
        xsd_type="TDec_1104v",
        digits=(
            11,
            4,
        ),
        help="Alíquota do COFINS (em reais) (NT2011/004)",
    )

    nfe40_vCOFINS = fields.Monetary(
        string="Valor do COFINS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class Cofinsst(models.AbstractModel):
    """Dados do COFINS da
    Substituição Tributaria;"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.cofinsst"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Cofinsst"

    nfe40_vBC = fields.Monetary(
        string="Valor da BC do COFINS ST",
        choice="cofinsst",
        xsd_choice_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_pCOFINS = fields.Float(
        string="Alíquota do COFINS ST(em percentual)",
        choice="cofinsst",
        xsd_choice_required=True,
        xsd_type="TDec_0302a04",
        digits=(
            3,
            2,
        ),
    )

    nfe40_qBCProd = fields.Float(
        string="Quantidade Vendida",
        choice="cofinsst",
        xsd_choice_required=True,
        xsd_type="TDec_1204",
        digits=(
            12,
            4,
        ),
    )

    nfe40_vAliqProd = fields.Float(
        string="Alíquota do COFINS ST(em reais)",
        choice="cofinsst",
        xsd_choice_required=True,
        xsd_type="TDec_1104",
        digits=(
            11,
            4,
        ),
    )

    nfe40_vCOFINS = fields.Monetary(
        string="Valor do COFINS ST",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_indSomaCOFINSST = fields.Selection(
        COFINSST_INDSOMACOFINSST,
        string="Indica se o valor da COFINS ST compõe",
        help="Indica se o valor da COFINS ST compõe o valor total da NFe",
    )


class Icmsufdest(models.AbstractModel):
    """Grupo a ser informado nas vendas interestarduais para consumidor final,
    não contribuinte de ICMS"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.icmsufdest"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Icmsufdest"

    nfe40_vBCUFDest = fields.Monetary(
        string="Valor da Base de Cálculo do ICMS na UF",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="Valor da Base de Cálculo do ICMS na UF do destinatário.",
    )

    nfe40_vBCFCPUFDest = fields.Monetary(
        string="Valor da Base de Cálculo do FCP na UF",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="Valor da Base de Cálculo do FCP na UF do destinatário.",
    )

    nfe40_pFCPUFDest = fields.Float(
        string="Percentual adicional inserido",
        xsd_type="TDec_0302a04",
        digits=(
            3,
            2,
        ),
        help=(
            "Percentual adicional inserido na alíquota interna da UF de "
            "destino, relativo ao Fundo de Combate à Pobreza (FCP) naquela UF."
        ),
    )

    nfe40_pICMSUFDest = fields.Float(
        string="Alíquota adotada nas operações internas",
        xsd_required=True,
        xsd_type="TDec_0302a04",
        digits=(
            3,
            2,
        ),
        help=(
            "Alíquota adotada nas operações internas na UF do destinatário "
            "para o produto / mercadoria."
        ),
    )

    nfe40_pICMSInter = fields.Selection(
        ICMSUFDEST_PICMSINTER,
        string="Alíquota interestadual",
        xsd_required=True,
        help=(
            "Alíquota interestadual das UF envolvidas: - 4% alíquota "
            "interestadual para produtos importados; - 7% para os Estados de "
            "origem do Sul e Sudeste (exceto ES), destinado para os Estados do"
            " Norte e Nordeste  ou ES; - 12% para os demais casos."
        ),
    )

    nfe40_pICMSInterPart = fields.Float(
        string="Percentual de partilha para a UF",
        xsd_required=True,
        xsd_type="TDec_0302a04",
        digits=(
            3,
            2,
        ),
        help=(
            "Percentual de partilha para a UF do destinatário: - 40% em 2016; "
            "- 60% em 2017; - 80% em 2018; - 100% a partir de 2019."
        ),
    )

    nfe40_vFCPUFDest = fields.Monetary(
        string="Valor do ICMS relativo ao Fundo",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor do ICMS relativo ao Fundo de Combate à Pobreza (FCP) da UF "
            "de destino."
        ),
    )

    nfe40_vICMSUFDest = fields.Monetary(
        string="Valor do ICMS de partilha para a UF",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="Valor do ICMS de partilha para a UF do destinatário.",
    )

    nfe40_vICMSUFRemet = fields.Monetary(
        string="vICMSUFRemet",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor do ICMS de partilha para a UF do remetente. Nota: A partir "
            "de 2019, este valor será zero."
        ),
    )


class Icms(models.AbstractModel):
    "Dados do ICMS Normal e ST"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.icms"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Icms"

    nfe40_ICMSPart = fields.Many2one(
        comodel_name="nfe.40.icmspart",
        string="Partilha do ICMS entre a UF de origem",
        choice="icms",
        xsd_choice_required=True,
        help=(
            "Partilha do ICMS entre a UF de origem e UF de destino ou a UF "
            "definida na legislação\nOperação interestadual para consumidor "
            "final com partilha do ICMS  devido na operação entre a UF de "
            "origem e a UF do destinatário ou ou a UF definida na legislação. "
            "(Ex. UF da concessionária de entrega do  veículos)"
        ),
    )

    nfe40_ICMSST = fields.Many2one(
        comodel_name="nfe.40.icmsst",
        string="Grupo de informação",
        choice="icms",
        xsd_choice_required=True,
        help=(
            "Grupo de informação do ICMSST devido para a UF de destino, nas "
            "operações interestaduais de produtos que tiveram retenção "
            "antecipada de ICMS por ST na UF do remetente. Repasse via "
            "Substituto Tributário."
        ),
    )


class Icmspart(models.AbstractModel):
    """Partilha do ICMS entre a UF de origem e UF de destino ou a UF definida
    na legislação
    Operação interestadual para consumidor final com partilha do ICMS devido na
    operação entre a UF de origem e a UF do destinatário ou ou a UF definida na
    legislação. (Ex. UF da concessionária de entrega do veículos)"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.icmspart"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Icms.Icmspart"

    nfe40_orig = fields.Selection(
        TORIG,
        string="origem da mercadoria: 0 - Nacional",
        xsd_required=True,
        xsd_type="Torig",
        help=(
            "origem da mercadoria: 0 - Nacional \n1 - Estrangeira - Importação"
            " direta \n2 - Estrangeira - Adquirida no mercado interno"
        ),
    )

    nfe40_CST = fields.Selection(
        ICMSPART_CST,
        string="Tributação pelo ICMS",
        xsd_required=True,
        help=(
            "Tributação pelo ICMS \n10 - Tributada e com cobrança do ICMS por "
            "substituição tributária;\n90 – Outros."
        ),
    )

    nfe40_modBC = fields.Selection(
        ICMSPART_MODBC,
        string="Modalidade de determinação da BC",
        xsd_required=True,
        help=(
            "Modalidade de determinação da BC do ICMS: \n0 - Margem Valor "
            "Agregado (%);\n1 - Pauta (valor);\n2 - Preço Tabelado Máximo "
            "(valor);\n3 - Valor da Operação."
        ),
    )

    nfe40_vBC = fields.Monetary(
        string="Valor da BC do ICMS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_pRedBC = fields.Float(
        string="Percentual de redução da BC",
        xsd_type="TDec_0302a04Opc",
        digits=(
            3,
            2,
        ),
    )

    nfe40_pICMS = fields.Float(
        string="Alíquota do ICMS",
        xsd_required=True,
        xsd_type="TDec_0302a04",
        digits=(
            3,
            2,
        ),
    )

    nfe40_vICMS = fields.Monetary(
        string="Valor do ICMS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_modBCST = fields.Selection(
        ICMSPART_MODBCST,
        string="modBCST",
        xsd_required=True,
        help=(
            "Modalidade de determinação da BC do ICMS ST:\n0 – Preço tabelado "
            "ou máximo  sugerido;\n1 - Lista Negativa (valor);\n2 - Lista "
            "Positiva (valor);\n3 - Lista Neutra (valor);\n4 - Margem Valor "
            "Agregado (%);\n5 - Pauta (valor).\n6 - Valor da Operação"
        ),
    )

    nfe40_pMVAST = fields.Float(
        string="Percentual da Margem",
        xsd_type="TDec_0302a04Opc",
        digits=(
            3,
            2,
        ),
        help="Percentual da Margem de Valor Adicionado ICMS ST",
    )

    nfe40_pRedBCST = fields.Float(
        string="Percentual de redução da BC ICMS ST",
        xsd_type="TDec_0302a04Opc",
        digits=(
            3,
            2,
        ),
    )

    nfe40_vBCST = fields.Monetary(
        string="Valor da BC do ICMS ST",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_pICMSST = fields.Float(
        string="Alíquota do ICMS ST",
        xsd_required=True,
        xsd_type="TDec_0302a04",
        digits=(
            3,
            2,
        ),
    )

    nfe40_vICMSST = fields.Monetary(
        string="Valor do ICMS ST",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vBCFCPST = fields.Monetary(
        string="Valor da Base de cálculo do FCP retido",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor da Base de cálculo do FCP retido por substituicao "
            "tributaria."
        ),
    )

    nfe40_pFCPST = fields.Float(
        string="Percentual de FCP retido",
        xsd_type="TDec_0302a04Opc",
        digits=(
            3,
            2,
        ),
        help="Percentual de FCP retido por substituição tributária.",
    )

    nfe40_vFCPST = fields.Monetary(
        string="Valor do FCP retido",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="Valor do FCP retido por substituição tributária.",
    )

    nfe40_pBCOp = fields.Float(
        string="Percentual para determinação do valor",
        xsd_required=True,
        xsd_type="TDec_0302a04Opc",
        digits=(
            3,
            2,
        ),
        help=(
            "Percentual para determinação do valor  da Base de Cálculo da "
            "operação própria."
        ),
    )

    nfe40_UFST = fields.Selection(
        TUF,
        string="Sigla da UF para qual é devido o ICMS ST",
        xsd_required=True,
        xsd_type="TUf",
        help="Sigla da UF para qual é devido o ICMS ST da operação.",
    )


class Icmsst(models.AbstractModel):
    """Grupo de informação do ICMSST devido para a UF de destino, nas operações
    interestaduais de produtos que tiveram retenção antecipada de ICMS por
    ST na UF do remetente. Repasse via Substituto Tributário."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.icmsst"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Icms.Icmsst"

    nfe40_orig = fields.Selection(
        TORIG,
        string="origem da mercadoria: 0 - Nacional",
        xsd_required=True,
        xsd_type="Torig",
        help=(
            "origem da mercadoria: 0 - Nacional \n1 - Estrangeira - Importação"
            " direta \n2 - Estrangeira - Adquirida no mercado interno"
        ),
    )

    nfe40_CST = fields.Selection(
        ICMSST_CST,
        string="Tributção pelo ICMS",
        xsd_required=True,
        help=(
            "Tributção pelo ICMS\n41-Não Tributado.\n60-Cobrado anteriormente "
            "por substituição tributária."
        ),
    )

    nfe40_vBCSTRet = fields.Monetary(
        string="valor da BC do ICMS ST retido",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="valor da BC do ICMS ST retido na UF remetente",
    )

    nfe40_pST = fields.Float(
        string="Aliquota suportada pelo consumidor final",
        xsd_type="TDec_0302a04Opc",
        digits=(
            3,
            2,
        ),
    )

    nfe40_vICMSSubstituto = fields.Monetary(
        string="Valor do ICMS Próprio",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor do ICMS Próprio do Substituto cobrado em operação anterior"
        ),
    )

    nfe40_vICMSSTRet = fields.Monetary(
        string="valor do ICMS ST retido na UF remetente",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="valor do ICMS ST retido na UF remetente (iv2.0))",
    )

    nfe40_vBCFCPSTRet = fields.Monetary(
        string="valor da Base de Cálculo",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="valor da Base de Cálculo do FCP retido anteriormente por ST.",
    )

    nfe40_pFCPSTRet = fields.Float(
        string="Percentual relativo ao Fundo de Combate",
        xsd_type="TDec_0302a04Opc",
        digits=(
            3,
            2,
        ),
        help=(
            "Percentual relativo ao Fundo de Combate à Pobreza (FCP) retido "
            "por substituição tributária."
        ),
    )

    nfe40_vFCPSTRet = fields.Monetary(
        string="Valor do ICMS relativo ao Fundo",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor do ICMS relativo ao Fundo de Combate à Pobreza (FCP) retido"
            " por substituição tributária."
        ),
    )

    nfe40_vBCSTDest = fields.Monetary(
        string="valor da BC do ICMS ST da UF destino",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vICMSSTDest = fields.Monetary(
        string="vICMSSTDest",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="valor da BC do ICMS ST da UF destino (v2.0)",
    )

    nfe40_pRedBCEfet = fields.Float(
        string="Percentual de redução da base",
        xsd_type="TDec_0302a04Opc",
        digits=(
            3,
            2,
        ),
        help="Percentual de redução da base de cálculo efetiva.",
    )

    nfe40_vBCEfet = fields.Monetary(
        string="Valor da base de cálculo efetiva",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_pICMSEfet = fields.Float(
        string="Alíquota do ICMS efetivo",
        xsd_type="TDec_0302a04Opc",
        digits=(
            3,
            2,
        ),
    )

    nfe40_vICMSEfet = fields.Monetary(
        string="Valor do ICMS efetivo",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class Ii(models.AbstractModel):
    "Dados do Imposto de Importação"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.ii"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Ii"

    nfe40_vBC = fields.Monetary(
        string="Base da BC do Imposto de Importação",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vDespAdu = fields.Monetary(
        string="Valor das despesas aduaneiras",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vII = fields.Monetary(
        string="Valor do Imposto de Importação",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vIOF = fields.Monetary(
        string="Valor",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="Valor do Imposto sobre Operações Financeiras",
    )


class Issqn(models.AbstractModel):
    "ISSQN"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.issqn"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.Imposto.Issqn"

    nfe40_vBC = fields.Monetary(
        string="Valor da BC do ISSQN",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vAliq = fields.Monetary(
        string="Alíquota do ISSQN",
        xsd_required=True,
        xsd_type="TDec_0302a04",
        currency_field="brl_currency_id",
    )

    nfe40_vISSQN = fields.Monetary(
        string="Valor da do ISSQN",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_cMunFG = fields.Char(
        string="município de ocorrência do fato gerador",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "município de ocorrência do fato gerador do ISSQN. Utilizar a "
            "Tabela do IBGE (Anexo VII - Tabela de UF, Município e País). "
            "“Atenção, não vincular com os campos B12, C10 ou E10” v2.0"
        ),
    )

    nfe40_cListServ = fields.Char(
        string="Item da lista de serviços da LC 116/03",
        xsd_required=True,
        xsd_type="TCListServ",
        help=(
            "Item da lista de serviços da LC 116/03 em que se classifica o "
            "serviço."
        ),
    )

    nfe40_vDeducao = fields.Monetary(
        string="Valor dedução para redução da base",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
        help="Valor dedução para redução da base de cálculo",
    )

    nfe40_vOutro = fields.Monetary(
        string="Valor outras retenções",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vDescIncond = fields.Monetary(
        string="Valor desconto incondicionado",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vDescCond = fields.Monetary(
        string="Valor desconto condicionado",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vISSRet = fields.Monetary(
        string="Valor Retenção ISS",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_indISS = fields.Selection(
        ISSQN_INDISS,
        string="Exibilidade",
        xsd_required=True,
        help=(
            "Exibilidade do ISS:1-Exigível;2-Não "
            "incidente;3-Isenção;4-Exportação;5-Imunidade;6-Exig.Susp. "
            "Judicial;7-Exig.Susp. ADM"
        ),
    )

    nfe40_cServico = fields.Char(
        string="Código do serviço prestado dentro",
        help="Código do serviço prestado dentro do município",
    )

    nfe40_cMun = fields.Char(
        string="Código do Município de Incidência",
        xsd_type="TCodMunIBGE",
        help="Código do Município de Incidência do Imposto",
    )

    nfe40_cPais = fields.Char(string="Código de Pais")

    nfe40_nProcesso = fields.Char(
        string="Número do Processo administrativo",
        help=(
            "Número do Processo administrativo ou judicial de suspenção do "
            "processo"
        ),
    )

    nfe40_indIncentivo = fields.Selection(
        ISSQN_INDINCENTIVO,
        string="Indicador de Incentivo Fiscal",
        xsd_required=True,
        help="Indicador de Incentivo Fiscal. 1=Sim; 2=Não",
    )


class ImpostoDevol(models.AbstractModel):
    _description = "impostoDevol"
    _name = "nfe.40.impostodevol"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.ImpostoDevol"

    nfe40_pDevol = fields.Float(
        string="Percentual de mercadoria devolvida",
        xsd_required=True,
        xsd_type="TDec_0302Max100",
        digits=(
            3,
            2,
        ),
    )

    nfe40_IPI = fields.Many2one(
        comodel_name="nfe.40.ipi",
        string="Informação de IPI devolvido",
        xsd_required=True,
    )


class Ipi(models.AbstractModel):
    _description = "IPI"
    _name = "nfe.40.ipi"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.ImpostoDevol.Ipi"

    nfe40_vIPIDevol = fields.Monetary(
        string="Valor do IPI devolvido",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class ObsItem(models.AbstractModel):
    "Grupo de observações de uso livre (para o item da NF-e)"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.obsitem"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.ObsItem"

    nfe40_obsCont = fields.Many2one(
        comodel_name="nfe.40.det_obscont",
        string="Grupo de observações de uso livre",
        help="Grupo de observações de uso livre (para o item da NF-e)",
    )

    nfe40_obsFisco = fields.Many2one(
        comodel_name="nfe.40.det_obsfisco",
        string="obsFisco",
        help="Grupo de observações de uso livre (para o item da NF-e)",
    )


class DetObsCont(models.AbstractModel):
    "Grupo de observações de uso livre (para o item da NF-e)"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.det_obscont"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.ObsItem.ObsCont"

    nfe40_xTexto = fields.Char(string="xTexto", xsd_required=True)

    nfe40_xCampo = fields.Char(string="xCampo", xsd_required=True)


class DetObsFisco(models.AbstractModel):
    "Grupo de observações de uso livre (para o item da NF-e)"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.det_obsfisco"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Det.ObsItem.ObsFisco"

    nfe40_xTexto = fields.Char(string="xTexto", xsd_required=True)

    nfe40_xCampo = fields.Char(string="xCampo", xsd_required=True)


class Total(models.AbstractModel):
    "Dados dos totais da NF-e"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.total"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Total"

    nfe40_ICMSTot = fields.Many2one(
        comodel_name="nfe.40.icmstot",
        string="Totais referentes ao ICMS",
        xsd_required=True,
    )

    nfe40_ISSQNtot = fields.Many2one(
        comodel_name="nfe.40.issqntot", string="Totais referentes ao ISSQN"
    )

    nfe40_retTrib = fields.Many2one(
        comodel_name="nfe.40.rettrib", string="Retenção de Tributos Federais"
    )


class Icmstot(models.AbstractModel):
    "Totais referentes ao ICMS"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.icmstot"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Total.Icmstot"

    nfe40_vBC = fields.Monetary(
        string="BC do ICMS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vICMS = fields.Monetary(
        string="Valor Total do ICMS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vICMSDeson = fields.Monetary(
        string="Valor Total do ICMS desonerado",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vFCPUFDest = fields.Monetary(
        string="Valor total do ICMS relativo ao Fundo",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor total do ICMS relativo ao Fundo de Combate à Pobreza (FCP) "
            "para a UF de destino."
        ),
    )

    nfe40_vICMSUFDest = fields.Monetary(
        string="Valor total do ICMS de partilha",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="Valor total do ICMS de partilha para a UF do destinatário",
    )

    nfe40_vICMSUFRemet = fields.Monetary(
        string="vICMSUFRemet",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="Valor total do ICMS de partilha para a UF do remetente",
    )

    nfe40_vFCP = fields.Monetary(
        string="Valor Total do FCP",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="Valor Total do FCP (Fundo de Combate à Pobreza).",
    )

    nfe40_vBCST = fields.Monetary(
        string="BC do ICMS ST",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vST = fields.Monetary(
        string="Valor Total do ICMS ST",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vFCPST = fields.Monetary(
        string="Valor Total do FCP (vFCPST)",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor Total do FCP (Fundo de Combate à Pobreza) retido por "
            "substituição tributária."
        ),
    )

    nfe40_vFCPSTRet = fields.Monetary(
        string="Valor Total do FCP (vFCPSTRet)",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor Total do FCP (Fundo de Combate à Pobreza) retido "
            "anteriormente por substituição tributária."
        ),
    )

    nfe40_qBCMono = fields.Monetary(
        string="Valor total da quantidade tributada",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor total da quantidade tributada do ICMS monofásico próprio"
        ),
    )

    nfe40_vICMSMono = fields.Monetary(
        string="Valor total do ICMS monofásico próprio",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_qBCMonoReten = fields.Monetary(
        string="qBCMonoReten",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor total da quantidade tributada do ICMS monofásico sujeito a "
            "retenção"
        ),
    )

    nfe40_vICMSMonoReten = fields.Monetary(
        string="Valor total do ICMS monofásico sujeito",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="Valor total do ICMS monofásico sujeito a retenção",
    )

    nfe40_qBCMonoRet = fields.Monetary(
        string="qBCMonoRet",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor total da quantidade tributada do ICMS monofásico retido "
            "anteriormente"
        ),
    )

    nfe40_vICMSMonoRet = fields.Monetary(
        string="Valor",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="Valor do ICMS monofásico retido anteriormente",
    )

    nfe40_vProd = fields.Monetary(
        string="Valor Total dos produtos e serviços",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vFrete = fields.Monetary(
        string="Valor Total do Frete",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vSeg = fields.Monetary(
        string="Valor Total do Seguro",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vDesc = fields.Monetary(
        string="Valor Total do Desconto",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vII = fields.Monetary(
        string="Valor Total do II",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vIPI = fields.Monetary(
        string="Valor Total do IPI",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vIPIDevol = fields.Monetary(
        string="Valor Total do IPI devolvido",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor Total do IPI devolvido. Deve ser informado quando "
            "preenchido o Grupo Tributos Devolvidos na emissão de nota "
            "finNFe=4 (devolução) nas operações com não contribuintes do IPI. "
            "Corresponde ao total da soma dos campos id: UA04."
        ),
    )

    nfe40_vPIS = fields.Monetary(
        string="Valor do PIS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vCOFINS = fields.Monetary(
        string="Valor do COFINS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vOutro = fields.Monetary(
        string="Outras Despesas acessórias",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vNF = fields.Monetary(
        string="Valor Total da NF-e",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vTotTrib = fields.Monetary(
        string="Valor estimado total",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor estimado total de impostos federais, estaduais e municipais"
        ),
    )


class Issqntot(models.AbstractModel):
    "Totais referentes ao ISSQN"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.issqntot"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Total.Issqntot"

    nfe40_vServ = fields.Monetary(
        string="Valor Total",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
        help=(
            "Valor Total dos Serviços sob não-incidência ou não tributados "
            "pelo ICMS"
        ),
    )

    nfe40_vBC = fields.Monetary(
        string="Base de Cálculo do ISS",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vISS = fields.Monetary(
        string="Valor Total do ISS",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vPIS = fields.Monetary(
        string="Valor do PIS sobre serviços",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vCOFINS = fields.Monetary(
        string="Valor do COFINS sobre serviços",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_dCompet = fields.Date(
        string="Data da prestação do serviço",
        xsd_required=True,
        xsd_type="TData",
        help="Data da prestação do serviço  (AAAA-MM-DD)",
    )

    nfe40_vDeducao = fields.Monetary(
        string="Valor dedução para redução da base",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
        help="Valor dedução para redução da base de cálculo",
    )

    nfe40_vOutro = fields.Monetary(
        string="Valor outras retenções",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vDescIncond = fields.Monetary(
        string="Valor desconto incondicionado",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vDescCond = fields.Monetary(
        string="Valor desconto condicionado",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vISSRet = fields.Monetary(
        string="Valor Total Retenção ISS",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_cRegTrib = fields.Selection(
        ISSQNTOT_CREGTRIB, string="Código do regime especial de tributação"
    )


class RetTrib(models.AbstractModel):
    "Retenção de Tributos Federais"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.rettrib"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Total.RetTrib"

    nfe40_vRetPIS = fields.Monetary(
        string="Valor Retido de PIS",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vRetCOFINS = fields.Monetary(
        string="Valor Retido de COFINS",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vRetCSLL = fields.Monetary(
        string="Valor Retido de CSLL",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vBCIRRF = fields.Monetary(
        string="Base de Cálculo do IRRF",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vIRRF = fields.Monetary(
        string="Valor Retido de IRRF",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    nfe40_vBCRetPrev = fields.Monetary(
        string="Base de Cálculo da Retenção",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
        help="Base de Cálculo da Retenção da Previdêncica Social",
    )

    nfe40_vRetPrev = fields.Monetary(
        string="Valor da Retenção da Previdêncica Social",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )


class Transp(models.AbstractModel):
    "Dados dos transportes da NF-e"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.transp"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Transp"

    nfe40_modFrete = fields.Selection(
        TRANSP_MODFRETE,
        string="Modalidade do frete",
        xsd_required=True,
        help=(
            "Modalidade do frete\n0- Contratação do Frete por conta do "
            "Remetente (CIF);\n1- Contratação do Frete por conta do "
            "destinatário/remetente (FOB);\n2- Contratação do Frete por conta "
            "de terceiros;\n3- Transporte próprio por conta do remetente;\n4- "
            "Transporte próprio por conta do destinatário;\n9- Sem Ocorrência "
            "de transporte."
        ),
    )

    nfe40_transporta = fields.Many2one(
        comodel_name="nfe.40.transporta", string="Dados do transportador"
    )

    nfe40_retTransp = fields.Many2one(
        comodel_name="nfe.40.rettransp",
        string="Dados da retenção ICMS do Transporte",
        help="Dados da retenção  ICMS do Transporte",
    )

    nfe40_veicTransp = fields.Many2one(
        comodel_name="nfe.40.tveiculo",
        string="Dados do veículo",
        choice="transp",
        xsd_type="TVeiculo",
    )

    nfe40_reboque = fields.One2many(
        "nfe.40.tveiculo",
        "nfe40_reboque_transp_id",
        string="Dados do reboque/Dolly (v2.0)",
        choice="transp",
        xsd_type="TVeiculo",
    )

    nfe40_vagao = fields.Char(
        string="Identificação do vagão (v2.0)",
        choice="transp",
        xsd_choice_required=True,
    )

    nfe40_balsa = fields.Char(
        string="Identificação da balsa (v2.0)",
        choice="transp",
        xsd_choice_required=True,
    )

    nfe40_vol = fields.One2many(
        "nfe.40.vol", "nfe40_vol_transp_id", string="Dados dos volumes"
    )


class Transporta(models.AbstractModel):
    "Dados do transportador"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.transporta"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Transp.Transporta"

    nfe40_CNPJ = fields.Char(
        string="CNPJ do transportador", choice="transporta", xsd_type="TCnpj"
    )

    nfe40_CPF = fields.Char(
        string="CPF do transportador", choice="transporta", xsd_type="TCpf"
    )

    nfe40_xNome = fields.Char(string="Razão Social ou nome do transportador")

    nfe40_IE = fields.Char(
        string="Inscrição Estadual (v2.0)", xsd_type="TIeDest"
    )

    nfe40_xEnder = fields.Char(string="Endereço completo")

    nfe40_xMun = fields.Char(string="Nome do munícipio")

    nfe40_UF = fields.Selection(TUF, string="Sigla da UF", xsd_type="TUf")


class RetTransp(models.AbstractModel):
    "Dados da retenção ICMS do Transporte"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.rettransp"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Transp.RetTransp"

    nfe40_vServ = fields.Monetary(
        string="Valor do Serviço",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vBCRet = fields.Monetary(
        string="BC da Retenção do ICMS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_pICMSRet = fields.Float(
        string="Alíquota da Retenção",
        xsd_required=True,
        xsd_type="TDec_0302a04",
        digits=(
            3,
            2,
        ),
    )

    nfe40_vICMSRet = fields.Monetary(
        string="Valor do ICMS Retido",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_CFOP = fields.Char(
        string="Código Fiscal de Operações e Prestações", xsd_required=True
    )

    nfe40_cMunFG = fields.Char(
        string="Código do Município de Ocorrência",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do Município de Ocorrência do Fato Gerador (utilizar a "
            "tabela do IBGE)"
        ),
    )


class Vol(models.AbstractModel):
    "Dados dos volumes"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.vol"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Transp.Vol"

    nfe40_vol_transp_id = fields.Many2one(
        comodel_name="nfe.40.transp", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_qVol = fields.Char(string="Quantidade de volumes transportados")

    nfe40_esp = fields.Char(string="Espécie dos volumes transportados")

    nfe40_marca = fields.Char(string="Marca dos volumes transportados")

    nfe40_nVol = fields.Char(string="Numeração dos volumes transportados")

    nfe40_pesoL = fields.Float(
        string="Peso líquido (em kg)",
        xsd_type="TDec_1203",
        digits=(
            12,
            3,
        ),
    )

    nfe40_pesoB = fields.Float(
        string="Peso bruto (em kg)",
        xsd_type="TDec_1203",
        digits=(
            12,
            3,
        ),
    )

    nfe40_lacres = fields.One2many(
        "nfe.40.lacres", "nfe40_lacres_vol_id", string="lacres"
    )


class Lacres(models.AbstractModel):
    _description = "lacres"
    _name = "nfe.40.lacres"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Transp.Vol.Lacres"

    nfe40_lacres_vol_id = fields.Many2one(
        comodel_name="nfe.40.vol", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_nLacre = fields.Char(string="Número dos Lacres", xsd_required=True)


class Cobr(models.AbstractModel):
    "Dados da cobrança da NF-e"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.cobr"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Cobr"

    nfe40_fat = fields.Many2one(
        comodel_name="nfe.40.fat", string="Dados da fatura"
    )

    nfe40_dup = fields.One2many(
        "nfe.40.dup",
        "nfe40_dup_cobr_id",
        string="Dados das duplicatas NT 2011/004",
    )


class Fat(models.AbstractModel):
    "Dados da fatura"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.fat"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Cobr.Fat"

    nfe40_nFat = fields.Char(string="Número da fatura")

    nfe40_vOrig = fields.Monetary(
        string="Valor original da fatura",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vDesc = fields.Monetary(
        string="Valor do desconto da fatura",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vLiq = fields.Monetary(
        string="Valor líquido da fatura",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class Dup(models.AbstractModel):
    "Dados das duplicatas NT 2011/004"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.dup"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Cobr.Dup"

    nfe40_dup_cobr_id = fields.Many2one(
        comodel_name="nfe.40.cobr", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_nDup = fields.Char(string="Número da duplicata")

    nfe40_dVenc = fields.Date(
        string="Data de vencimento da duplicata",
        xsd_type="TData",
        help="Data de vencimento da duplicata (AAAA-MM-DD)",
    )

    nfe40_vDup = fields.Monetary(
        string="Valor da duplicata",
        xsd_required=True,
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )


class Pag(models.AbstractModel):
    "Dados de Pagamento. Obrigatório apenas para (NFC-e) NT 2012/004"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.pag"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Pag"

    nfe40_detPag = fields.One2many(
        "nfe.40.detpag",
        "nfe40_detPag_pag_id",
        string="Grupo de detalhamento da forma",
        help="Grupo de detalhamento da forma de pagamento.",
    )

    nfe40_vTroco = fields.Monetary(
        string="Valor do Troco",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class DetPag(models.AbstractModel):
    "Grupo de detalhamento da forma de pagamento."

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.detpag"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Pag.DetPag"

    nfe40_detPag_pag_id = fields.Many2one(
        comodel_name="nfe.40.pag", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_indPag = fields.Selection(
        DETPAG_INDPAG,
        string="Indicador da Forma",
        help=(
            "Indicador da Forma de Pagamento:0-Pagamento à Vista;1-Pagamento à"
            " Prazo;"
        ),
    )

    nfe40_tPag = fields.Char(string="Forma de Pagamento", xsd_required=True)

    nfe40_xPag = fields.Char(string="Descrição do Meio de Pagamento")

    nfe40_vPag = fields.Monetary(
        string="Valor do Pagamento",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor do Pagamento. Esta tag poderá ser omitida quando a tag "
            "tPag=90 (Sem Pagamento), caso contrário deverá ser preenchida."
        ),
    )

    nfe40_dPag = fields.Date(string="Data do Pagamento", xsd_type="TData")

    nfe40_CNPJPag = fields.Char(
        string="CNPJ transacional do pagamento",
        xsd_type="TCnpj",
        help=(
            "CNPJ transacional do pagamento - Preencher informando o CNPJ do "
            "estabelecimento onde o pagamento foi "
            "processado/transacionado/recebido quando a emissão do documento "
            "fiscal ocorrer em estabelecimento distinto"
        ),
    )

    nfe40_UFPag = fields.Selection(
        TUFEMI,
        string="UF do CNPJ do estabelecimento onde",
        xsd_type="TUfEmi",
        help=(
            "UF do CNPJ do estabelecimento onde o pagamento foi "
            "processado/transacionado/recebido."
        ),
    )

    nfe40_card = fields.Many2one(
        comodel_name="nfe.40.card",
        string="Grupo de Cartões, PIX",
        help=(
            "Grupo de Cartões, PIX, Boletos e outros Pagamentos Eletrônicos"
        ),
    )


class Card(models.AbstractModel):
    "Grupo de Cartões, PIX, Boletos e outros Pagamentos Eletrônicos"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.card"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Pag.DetPag.Card"

    nfe40_tpIntegra = fields.Selection(
        CARD_TPINTEGRA,
        string="Tipo de Integração do processo",
        xsd_required=True,
        help=(
            "Tipo de Integração do processo de pagamento com o sistema de "
            "automação da empresa:\n1 - Pagamento integrado com o sistema de "
            "automação da empresa (Ex.: equipamento TEF, Comércio Eletrônico, "
            "POS Integrado);\n2 - Pagamento não integrado com o sistema de "
            "automação da empresa (Ex.: equipamento POS Simples)."
        ),
    )

    nfe40_CNPJ = fields.Char(
        string="CNPJ da instituição de pagamento", xsd_type="TCnpj"
    )

    nfe40_tBand = fields.Char(string="Bandeira da operadora de cartão")

    nfe40_cAut = fields.Char(
        string="Número de autorização da operação",
        help=(
            "Número de autorização da operação com cartões, PIX, boletos e "
            "outros pagamentos eletrônicos"
        ),
    )

    nfe40_CNPJReceb = fields.Char(
        string="CNPJ do beneficiário do pagamento", xsd_type="TCnpj"
    )

    nfe40_idTermPag = fields.Char(
        string="Identificador do terminal de pagamento"
    )


class InfIntermed(models.AbstractModel):
    "Grupo de Informações do Intermediador da Transação"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.infintermed"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.InfIntermed"

    nfe40_CNPJ = fields.Char(
        string="CNPJ do Intermediador da Transação",
        xsd_required=True,
        xsd_type="TCnpj",
        help=(
            "CNPJ do Intermediador da Transação (agenciador, plataforma de "
            "delivery, marketplace e similar) de serviços e de negócios."
        ),
    )

    nfe40_idCadIntTran = fields.Char(
        string="Identificador cadastrado",
        xsd_required=True,
        help="Identificador cadastrado no intermediador",
    )


class InfAdic(models.AbstractModel):
    "Informações adicionais da NF-e"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.infadic"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.InfAdic"

    nfe40_infAdFisco = fields.Char(
        string="Informações adicionais de interesse",
        help="Informações adicionais de interesse do Fisco (v2.0)",
    )

    nfe40_infCpl = fields.Char(
        string="Informações complementares de interesse",
        help="Informações complementares de interesse do Contribuinte",
    )

    nfe40_obsCont = fields.One2many(
        "nfe.40.infadic_obscont",
        "nfe40_obsCont_infAdic_id",
        string="Campo de uso livre do contribuinte",
        help=(
            "Campo de uso livre do contribuinte\ninformar o nome do campo no "
            "atributo xCampo\ne o conteúdo do campo no xTexto"
        ),
    )

    nfe40_obsFisco = fields.One2many(
        "nfe.40.infadic_obsfisco",
        "nfe40_obsFisco_infAdic_id",
        string="Campo de uso exclusivo do Fisco",
        help=(
            "Campo de uso exclusivo do Fisco\ninformar o nome do campo no "
            "atributo xCampo\ne o conteúdo do campo no xTexto"
        ),
    )

    nfe40_procRef = fields.One2many(
        "nfe.40.procref",
        "nfe40_procRef_infAdic_id",
        string="Grupo de informações",
        help="Grupo de informações do  processo referenciado",
    )


class InfAdicObsCont(models.AbstractModel):
    "Grupo de observações de uso livre (para o item da NF-e)"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.infadic_obscont"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.InfAdic.ObsCont"

    nfe40_obsCont_infAdic_id = fields.Many2one(
        comodel_name="nfe.40.infadic", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_xTexto = fields.Char(string="xTexto", xsd_required=True)

    nfe40_xCampo = fields.Char(string="xCampo", xsd_required=True)


class InfAdicObsFisco(models.AbstractModel):
    "Grupo de observações de uso livre (para o item da NF-e)"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.infadic_obsfisco"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.InfAdic.ObsFisco"

    nfe40_obsFisco_infAdic_id = fields.Many2one(
        comodel_name="nfe.40.infadic", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_xTexto = fields.Char(string="xTexto", xsd_required=True)

    nfe40_xCampo = fields.Char(string="xCampo", xsd_required=True)


class ProcRef(models.AbstractModel):
    "Grupo de informações do processo referenciado"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.procref"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.InfAdic.ProcRef"

    nfe40_procRef_infAdic_id = fields.Many2one(
        comodel_name="nfe.40.infadic", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_nProc = fields.Char(
        string="Indentificador do processo ou ato",
        xsd_required=True,
        help="Indentificador do processo ou ato\nconcessório",
    )

    nfe40_indProc = fields.Selection(
        PROCREF_INDPROC,
        string="Origem do processo, informar",
        xsd_required=True,
        help=(
            "Origem do processo, informar com:\n0 - SEFAZ;\n1 - Justiça "
            "Federal;\n2 - Justiça Estadual;\n3 - Secex/RFB;\n4 - CONFAZ;\n9 -"
            " Outros."
        ),
    )

    nfe40_tpAto = fields.Selection(
        PROCREF_TPATO,
        string="Tipo do ato concessório",
        help=(
            "Tipo do ato concessório\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tPara origem "
            "do Processo na SEFAZ (indProc=0), informar o\ntipo de ato "
            "concessório:\n08 - Termo de Acordo;\n10 - Regime Especial;\n12 - "
            "Autorização específica;\n14 - Ajuste SINIEF;\n15 - Convênio ICMS."
        ),
    )


class Exporta(models.AbstractModel):
    "Informações de exportação"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.exporta"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Exporta"

    nfe40_UFSaidaPais = fields.Selection(
        TUFEMI,
        string="Sigla da UF de Embarque",
        xsd_required=True,
        xsd_type="TUfEmi",
        help="Sigla da UF de Embarque ou de transposição de fronteira",
    )

    nfe40_xLocExporta = fields.Char(
        string="Local de Embarque ou de transposição",
        xsd_required=True,
        help="Local de Embarque ou de transposição de fronteira",
    )

    nfe40_xLocDespacho = fields.Char(string="Descrição do local de despacho")


class Compra(models.AbstractModel):
    "Informações de compras (Nota de Empenho, Pedido e Contrato)"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.compra"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Compra"

    nfe40_xNEmp = fields.Char(
        string="Informação da Nota de Empenho",
        help=(
            "Informação da Nota de Empenho de compras públicas (NT2011/004)"
        ),
    )

    nfe40_xPed = fields.Char(string="Informação do pedido")

    nfe40_xCont = fields.Char(string="Informação do contrato")


class Cana(models.AbstractModel):
    "Informações de registro aquisições de cana"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.cana"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Cana"

    nfe40_safra = fields.Char(
        string="Identificação da safra", xsd_required=True
    )

    nfe40_ref = fields.Char(
        string="Mês e Ano de Referência",
        xsd_required=True,
        help="Mês e Ano de Referência, formato: MM/AAAA",
    )

    nfe40_forDia = fields.One2many(
        "nfe.40.fordia", "nfe40_forDia_cana_id", string="Fornecimentos diários"
    )

    nfe40_qTotMes = fields.Float(
        string="Total do mês",
        xsd_required=True,
        xsd_type="TDec_1110v",
        digits=(
            11,
            10,
        ),
    )

    nfe40_qTotAnt = fields.Float(
        string="Total Anterior",
        xsd_required=True,
        xsd_type="TDec_1110v",
        digits=(
            11,
            10,
        ),
    )

    nfe40_qTotGer = fields.Float(
        string="Total Geral",
        xsd_required=True,
        xsd_type="TDec_1110v",
        digits=(
            11,
            10,
        ),
    )

    nfe40_deduc = fields.One2many(
        "nfe.40.deduc",
        "nfe40_deduc_cana_id",
        string="Deduções - Taxas e Contribuições",
    )

    nfe40_vFor = fields.Monetary(
        string="Valor dos fornecimentos",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="Valor  dos fornecimentos",
    )

    nfe40_vTotDed = fields.Monetary(
        string="Valor Total das Deduções",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    nfe40_vLiqFor = fields.Monetary(
        string="Valor Líquido dos fornecimentos",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class ForDia(models.AbstractModel):
    "Fornecimentos diários"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.fordia"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Cana.ForDia"

    nfe40_forDia_cana_id = fields.Many2one(
        comodel_name="nfe.40.cana", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_qtde = fields.Float(
        string="Quantidade em quilogramas",
        xsd_required=True,
        xsd_type="TDec_1110v",
        digits=(
            11,
            10,
        ),
        help="Quantidade em quilogramas - peso líquido",
    )

    nfe40_dia = fields.Char(string="Número do dia", xsd_required=True)


class Deduc(models.AbstractModel):
    "Deduções - Taxas e Contribuições"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.deduc"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.Cana.Deduc"

    nfe40_deduc_cana_id = fields.Many2one(
        comodel_name="nfe.40.cana", xsd_implicit=True, ondelete="cascade"
    )
    nfe40_xDed = fields.Char(string="Descrição da Dedução", xsd_required=True)

    nfe40_vDed = fields.Monetary(
        string="valor da dedução",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class InfSolicNff(models.AbstractModel):
    "Grupo para informações da solicitação da NFF"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.infsolicnff"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfe.InfSolicNff"

    nfe40_xSolic = fields.Char(
        string="Solicitação do pedido de emissão da NFF", xsd_required=True
    )


class InfNfeSupl(models.AbstractModel):
    "Informações suplementares Nota Fiscal"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.infnfesupl"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tnfe.InfNfeSupl"

    nfe40_qrCode = fields.Char(
        string="Texto com o QR-Code impresso",
        xsd_required=True,
        help="Texto com o QR-Code impresso no DANFE NFC-e",
    )

    nfe40_urlChave = fields.Char(
        string="URL da 'Consulta por chave de acesso",
        xsd_required=True,
        help=(
            "URL da 'Consulta por chave de acesso da NFC-e'. A mesma URL que "
            "deve estar informada no DANFE NFC-e para consulta por chave de "
            "acesso."
        ),
    )


class TenviNfe(models.AbstractModel):
    "Tipo Pedido de Concessão de Autorização da Nota Fiscal Eletrônica"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tenvinfe"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TenviNfe"

    nfe40_idLote = fields.Char(
        string="idLote", xsd_required=True, xsd_type="TIdLote"
    )

    nfe40_indSinc = fields.Selection(
        TENVINFE_INDSINC,
        string="Indicador de processamento síncrono",
        xsd_required=True,
        help="Indicador de processamento síncrono. 0=NÃO; 1=SIM=Síncrono",
    )

    nfe40_NFe = fields.One2many(
        "nfe.40.tnfe", "nfe40_NFe_TEnviNFe_id", string="NFe", xsd_type="TNFe"
    )

    nfe40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerNFe"
    )


class TnfeProc(models.AbstractModel):
    "Tipo da NF-e processada"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tnfeproc"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TnfeProc"

    nfe40_NFe = fields.Many2one(
        comodel_name="nfe.40.tnfe",
        string="NFe",
        xsd_required=True,
        xsd_type="TNFe",
    )

    nfe40_protNFe = fields.Many2one(
        comodel_name="nfe.40.tprotnfe",
        string="protNFe",
        xsd_required=True,
        xsd_type="TProtNFe",
    )

    nfe40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerNFe"
    )
