# Copyright 2020 - TODAY, Marcel Savegnago - Escodoo
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl

from datetime import datetime, timedelta

from odoo.tests import SavepointCase


class TestHREmployeePPE(SavepointCase):
    @classmethod
    def setUpClass(cls):
        super(TestHREmployeePPE, cls).setUpClass()
        cls.hr_employee_ppe = cls.env["hr.employee.ppe"]
        cls.hr_employee_ppe_equipment = cls.env["hr.employee.ppe.equipment"]
        cls.hr_employee_ppe1 = cls.env.ref("hr_employee_ppe.hr_employee_ppe1")
        cls.hr_employee_ppe2 = cls.env.ref("hr_employee_ppe.hr_employee_ppe2")

    def test_hr_employee_ppe(self):
        self.hr_employee_ppe1._compute_status()
        self.assertEqual(self.hr_employee_ppe1.status, "expired")

        self.hr_employee_ppe1.status = "valid"
        self.env["hr.employee.ppe"].cron_ppe_expiry_verification()
        self.assertEqual(self.hr_employee_ppe1.status, 'expired')

        self.hr_employee_ppe1.end_date = (datetime.now() + timedelta(days=1)).strftime(
            "%Y-%m-%d"
        )
        self.hr_employee_ppe1._compute_status()
        self.assertEqual(self.hr_employee_ppe1.status, "valid")

        self.hr_employee_ppe2._compute_status()
        self.assertEqual(self.hr_employee_ppe2.status, "valid")

        self.hr_employee_ppe1._compute_name()
        self.assertEqual(self.hr_employee_ppe1.name,
                         "Mask for COVID-19 to Abigail Peterson")
        self.assertEqual(self.hr_employee_ppe1.expire, True)

    def test_hr_employee_ppe_multi(self):
        employee = self.env.ref('hr.employee_hne')
        today = datetime.now().strftime('%Y-%m-%d')
        tomorrow = (datetime.now() + timedelta(days=1)).strftime('%Y-%m-%d')
        employee.write({
            'ppe_ids': [
                (0, 0, {
                    'ppe_id': self.hr_employee_ppe1.id,
                    'start_date': today,
                    'end_date': tomorrow,
                }),
                (0, 0, {
                    'ppe_id': self.hr_employee_ppe2.id,
                    'start_date': today,
                    'end_date': tomorrow,
                }),
            ],
        })
