# -*- encoding: utf-8 -*-
##############################################################################
#
#    Point Of Sale - Store Draft Orders Module for Odoo
#    Copyright (C) 2013-Today GRAP (http://www.grap.coop)
#    @author Julien WESTE
#    @author Sylvain LE GAL (https://twitter.com/legalsylvain)
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from openerp import fields, models


class PosConfig(models.Model):
    _inherit = 'pos.config'

    # Column Section
    allow_store_draft_order = fields.Boolean(
        string='Allow to Store Draft Orders', help="If you check this field,"
        "  users will have the possibility to let some PoS orders in a draft"
        " state, and allow the customer to paid later.\n"
        "Order in a draft state will not generate entries during the close"
        " of the session.")
