# -*- coding: utf-8 -*-
#
#
#    Author: Guewen Baconnier
#    Copyright 2012 Camptocamp SA
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#

from osv import osv, fields


class product_template(osv.osv):

    _inherit = 'product.template'

    _columns = {
        'special_type': fields.selection([('discount', 'Global Discount'),
                                          ('advance', 'Advance'),
                                          ('delivery', 'Delivery Costs'),
                                          ('', '')],
                                         string='Special Type',
                                         help='Special products will not be '
                                              'displayed on invoices printed '
                                              'reports but will be summed in '
                                              'the totals.'),
    }

product_template()
