# coding: utf-8
# © 2015 David BEAL @ Akretion
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl.html).

from odoo import api, models, _


# generated by print ''.join([str(ord(x)) for x in 'project_model_to_task'])
UNIQUE_ACTION_ID = (
    1121141111061019911695109111100101108951161119511697115107)


class IrValues(models.Model):
    _inherit = 'ir.values'

    @api.model
    def get_actions(self, action_slot, model, res_id=False):
        """ Add an action to all Model objects of the ERP """
        res = super(IrValues, self).get_actions(
            action_slot, model, res_id=res_id)
        for value in res:
            if value[0] == UNIQUE_ACTION_ID:
                # prevent to add multiple times the same action
                return res
        available_models = [
            x[0] for x in self.env['project.task']._authorised_models()]
        if action_slot == 'client_action_multi' and model in available_models:
            action = self.set_task_action(model, res_id=res_id)
            if action:
                value = (UNIQUE_ACTION_ID, 'project_model_to_task', action)
                res.insert(0, value)
        return res

    @api.model
    def set_task_action(self, model, res_id=False):
        action = self.env.ref('project_model_to_task.task_from_elsewhere')
        return {
            'id': action.id,
            'name': _('Create a related task'),
            'res_model': u'project.task',
            'src_model': model,
            'type': u'ir.actions.act_window',
            'target': 'current',
        }
