# -*- coding: utf-8 -*-
# © 2016 Akretion (Alexis de Lattre <alexis.delattre@akretion.com>)
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl.html).

from openerp import models, api
import logging

logger = logging.getLogger(__name__)


class Report(models.Model):
    _inherit = "report"

    @api.model
    def get_pdf(self, docids, report_name, html=None, data=None):
        """We go through that method when the PDF is generated for the 1st
        time and also when it is read from the attachment.
        This method is specific to QWeb"""
        purchases = self.env["purchase.order"].browse(docids)
        pdf_content = super(Report, self).get_pdf(
            purchases, report_name, html=html, data=data
        )
        purchase_reports = [
            "purchase.report_purchaseorder",
            "purchase.report_purchasequotation",
        ]
        if (
            report_name in purchase_reports
            and len(docids) == 1
            and not self.env.context.get("no_embedded_ubl_xml")
        ):
            pdf_content = purchases[0].embed_ubl_xml_in_pdf(pdf_content=pdf_content)
        return pdf_content
