/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.colorspace;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.function.FunctionType0;
import java.awt.color.ColorSpace;
import java.io.IOException;

public class CalRGBColor
extends ColorSpace {
    private static final float[] vonKriesM = new float[]{0.40024f, -0.2263f, 0.0f, 0.7076f, 1.16532f, 0.0f, -0.08081f, 0.0457f, 0.91822f};
    private static final float[] vonKriesMinv = new float[]{1.859936f, 0.361191f, 0.0f, -1.129382f, 0.638812f, 0.0f, 0.219897f, -6.0E-6f, 1.089064f};
    private static final float[] xyzToSRGB = new float[]{3.24071f, -0.969258f, 0.0556352f, -1.53726f, 1.87599f, -0.203996f, -0.498571f, 0.0415557f, 1.05707f};
    private static final float[] xyzToRGB = new float[]{2.04148f, -0.969258f, 0.0134455f, -0.564977f, 1.87599f, -0.118373f, -0.344713f, 0.0415557f, 1.01527f};
    float[] scale;
    float[] max;
    float[] white = new float[]{1.0f, 1.0f, 1.0f};
    float[] black = new float[]{0.0f, 0.0f, 0.0f};
    float[] matrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    float[] gamma = new float[]{1.0f, 1.0f, 1.0f};
    static ColorSpace rgbCS = ColorSpace.getInstance(1000);
    static ColorSpace cieCS = ColorSpace.getInstance(1001);

    public CalRGBColor(PDFObject pDFObject) throws IOException {
        super(1000, 3);
        int n;
        PDFObject pDFObject2 = pDFObject.getDictRef("WhitePoint");
        if (pDFObject2 != null) {
            for (n = 0; n < 3; ++n) {
                this.white[n] = pDFObject2.getAt(n).getFloatValue();
            }
        }
        if ((pDFObject2 = pDFObject.getDictRef("BlackPoint")) != null) {
            for (n = 0; n < 3; ++n) {
                this.black[n] = pDFObject2.getAt(n).getFloatValue();
            }
        }
        if ((pDFObject2 = pDFObject.getDictRef("Gamma")) != null) {
            for (n = 0; n < 3; ++n) {
                this.gamma[n] = pDFObject2.getAt(n).getFloatValue();
            }
        }
        if ((pDFObject2 = pDFObject.getDictRef("Matrix")) != null) {
            for (n = 0; n < 9; ++n) {
                this.matrix[n] = pDFObject2.getAt(n).getFloatValue();
            }
        }
        float[] fArray = rgbCS.toCIEXYZ(new float[]{1.0f, 1.0f, 1.0f});
        float[] fArray2 = this.matrixMult(this.white, vonKriesM, 3);
        float[] fArray3 = this.matrixMult(fArray, vonKriesM, 3);
        this.scale = new float[]{fArray3[0] / fArray2[0], 0.0f, 0.0f, 0.0f, fArray3[1] / fArray2[1], 0.0f, 0.0f, 0.0f, fArray3[2] / fArray2[2]};
        this.scale = this.matrixMult(vonKriesM, this.scale, 3);
        this.scale = this.matrixMult(this.scale, vonKriesMinv, 3);
        this.max = this.matrixMult(this.white, this.scale, 3);
        this.max = this.ciexyzToSRGB(this.max);
    }

    @Override
    public int getNumComponents() {
        return 3;
    }

    @Override
    public float[] toRGB(float[] fArray) {
        if (fArray.length == 3) {
            float f = (float)Math.pow(fArray[0], this.gamma[0]);
            float f2 = (float)Math.pow(fArray[1], this.gamma[1]);
            float f3 = (float)Math.pow(fArray[2], this.gamma[2]);
            float[] fArray2 = new float[]{this.matrix[0] * f + this.matrix[3] * f2 + this.matrix[6] * f3, this.matrix[1] * f + this.matrix[4] * f2 + this.matrix[7] * f3, this.matrix[2] * f + this.matrix[5] * f2 + this.matrix[8] * f3};
            fArray2 = this.matrixMult(fArray2, this.scale, 3);
            float[] fArray3 = this.ciexyzToSRGB(fArray2);
            for (int i = 0; i < fArray3.length; ++i) {
                fArray3[i] = FunctionType0.interpolate(fArray3[i], 0.0f, this.max[i], 0.0f, 1.0f);
                if (!((double)fArray3[i] > 1.0)) continue;
                fArray3[i] = 1.0f;
            }
            return fArray3;
        }
        return this.black;
    }

    private float[] ciexyzToSRGB(float[] fArray) {
        float[] fArray2 = this.matrixMult(fArray, xyzToSRGB, 3);
        for (int i = 0; i < fArray2.length; ++i) {
            if ((double)fArray2[i] < 0.0) {
                fArray2[i] = 0.0f;
            } else if ((double)fArray2[i] > 1.0) {
                fArray2[i] = 1.0f;
            }
            if ((double)fArray2[i] < 0.003928) {
                int n = i;
                fArray2[n] = (float)((double)fArray2[n] * 12.92);
                continue;
            }
            fArray2[i] = (float)(Math.pow(fArray2[i], 0.4166666666666667) * 1.055 - 0.055);
        }
        return fArray2;
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        return new float[3];
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        return new float[3];
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        return new float[3];
    }

    float[] matrixMult(float[] fArray, float[] fArray2, int n) {
        int n2 = fArray.length / n;
        int n3 = fArray2.length / n;
        float[] fArray3 = new float[n2 * n3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n; ++k) {
                    int n4 = i * n3 + j;
                    fArray3[n4] = fArray3[n4] + fArray[i * n + k] * fArray2[k * n3 + j];
                }
            }
        }
        return fArray3;
    }
}

