/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decrypt;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.decrypt.CryptFilterDecrypter;
import com.sun.pdfview.decrypt.EncryptionUnsupportedByPlatformException;
import com.sun.pdfview.decrypt.EncryptionUnsupportedByProductException;
import com.sun.pdfview.decrypt.IdentityDecrypter;
import com.sun.pdfview.decrypt.PDFAuthenticationFailureException;
import com.sun.pdfview.decrypt.PDFDecrypter;
import com.sun.pdfview.decrypt.PDFPassword;
import com.sun.pdfview.decrypt.StandardDecrypter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class PDFDecrypterFactory {
    public static final String CF_IDENTITY = "Identity";
    private static final int DEFAULT_KEY_LENGTH = 40;

    public static PDFDecrypter createDecryptor(PDFObject pDFObject, PDFObject pDFObject2, PDFPassword pDFPassword) throws IOException, EncryptionUnsupportedByPlatformException, EncryptionUnsupportedByProductException, PDFAuthenticationFailureException {
        pDFPassword = PDFPassword.nonNullPassword(pDFPassword);
        if (pDFObject == null) {
            return IdentityDecrypter.getInstance();
        }
        PDFObject pDFObject3 = pDFObject.getDictRef("Filter");
        if (pDFObject3 != null && "Standard".equals(pDFObject3.getStringValue())) {
            int n;
            PDFObject pDFObject4 = pDFObject.getDictRef("V");
            int n2 = n = pDFObject4 != null ? pDFObject4.getIntValue() : 0;
            if (n == 1 || n == 2) {
                PDFObject pDFObject5 = pDFObject.getDictRef("Length");
                Integer n3 = pDFObject5 != null ? Integer.valueOf(pDFObject5.getIntValue()) : null;
                return PDFDecrypterFactory.createStandardDecrypter(pDFObject, pDFObject2, pDFPassword, n3, false, StandardDecrypter.EncryptionAlgorithm.RC4);
            }
            if (n == 4) {
                return PDFDecrypterFactory.createCryptFilterDecrypter(pDFObject, pDFObject2, pDFPassword, n);
            }
            throw new EncryptionUnsupportedByPlatformException("Unsupported encryption version: " + n);
        }
        if (pDFObject3 == null) {
            throw new PDFParseException("No Filter specified in Encrypt dictionary");
        }
        throw new EncryptionUnsupportedByPlatformException("Unsupported encryption Filter: " + pDFObject3 + "; only Standard is supported.");
    }

    private static PDFDecrypter createCryptFilterDecrypter(PDFObject pDFObject, PDFObject pDFObject2, PDFPassword pDFPassword, int n) throws PDFAuthenticationFailureException, IOException, EncryptionUnsupportedByPlatformException, EncryptionUnsupportedByProductException {
        Object object;
        PDFObject pDFObject3;
        Object object2;
        Object object3;
        assert (n >= 4) : "crypt filter decrypter not supported for standard encryption prior to version 4";
        boolean bl = true;
        PDFObject pDFObject4 = pDFObject.getDictRef("EncryptMetadata");
        if (pDFObject4 != null && pDFObject4.getType() == 1) {
            bl = pDFObject4.getBooleanValue();
        }
        HashMap<String, PDFDecrypter> hashMap = new HashMap<String, PDFDecrypter>();
        PDFObject pDFObject5 = pDFObject.getDictRef("CF");
        if (pDFObject5 == null) {
            throw new PDFParseException("No CF value present in Encrypt dict for V4 encryption");
        }
        Iterator iterator = pDFObject5.getDictKeys();
        while (iterator.hasNext()) {
            PDFDecrypter pDFDecrypter;
            String string;
            object3 = (String)iterator.next();
            object2 = pDFObject5.getDictRef((String)object3);
            pDFObject3 = ((PDFObject)object2).getDictRef("Length");
            object = pDFObject3 != null ? Integer.valueOf(pDFObject3.getIntValue() * 8) : null;
            PDFObject pDFObject6 = ((PDFObject)object2).getDictRef("CFM");
            String string2 = string = pDFObject6 != null ? pDFObject6.getStringValue() : "None";
            if ("None".equals(string)) {
                pDFDecrypter = IdentityDecrypter.getInstance();
            } else if ("V2".equals(string)) {
                pDFDecrypter = PDFDecrypterFactory.createStandardDecrypter(pDFObject, pDFObject2, pDFPassword, (Integer)object, bl, StandardDecrypter.EncryptionAlgorithm.RC4);
            } else if ("AESV2".equals(string)) {
                pDFDecrypter = PDFDecrypterFactory.createStandardDecrypter(pDFObject, pDFObject2, pDFPassword, (Integer)object, bl, StandardDecrypter.EncryptionAlgorithm.AESV2);
            } else {
                throw new UnsupportedOperationException("Unknown CryptFilter method: " + string);
            }
            hashMap.put((String)object3, pDFDecrypter);
        }
        hashMap.put(CF_IDENTITY, IdentityDecrypter.getInstance());
        object3 = pDFObject.getDictRef("StmF");
        object2 = object3 != null ? ((PDFObject)object3).getStringValue() : CF_IDENTITY;
        pDFObject3 = pDFObject.getDictRef("StrF");
        object = pDFObject3 != null ? pDFObject3.getStringValue() : CF_IDENTITY;
        return new CryptFilterDecrypter(hashMap, (String)object2, (String)object);
    }

    private static PDFDecrypter createStandardDecrypter(PDFObject pDFObject, PDFObject pDFObject2, PDFPassword pDFPassword, Integer n, boolean bl, StandardDecrypter.EncryptionAlgorithm encryptionAlgorithm) throws PDFAuthenticationFailureException, IOException, EncryptionUnsupportedByPlatformException, EncryptionUnsupportedByProductException {
        PDFObject pDFObject3;
        if (n == null) {
            n = 40;
        }
        if ((pDFObject3 = pDFObject.getDictRef("R")) == null) {
            throw new PDFParseException("No R entry present in Encrypt dictionary");
        }
        int n2 = pDFObject3.getIntValue();
        if (n2 < 2 || n2 > 4) {
            throw new EncryptionUnsupportedByPlatformException("Unsupported Standard security handler revision; R=" + n2);
        }
        PDFObject pDFObject4 = pDFObject.getDictRef("O");
        if (pDFObject4 == null) {
            throw new PDFParseException("No O entry present in Encrypt dictionary");
        }
        byte[] byArray = pDFObject4.getStream();
        if (byArray.length != 32) {
            throw new PDFParseException("Expected owner key O value of 32 bytes; found " + byArray.length);
        }
        PDFObject pDFObject5 = pDFObject.getDictRef("U");
        if (pDFObject5 == null) {
            throw new PDFParseException("No U entry present in Encrypt dictionary");
        }
        byte[] byArray2 = pDFObject5.getStream();
        if (byArray2.length != 32) {
            throw new PDFParseException("Expected user key U value of 32 bytes; found " + byArray.length);
        }
        PDFObject pDFObject6 = pDFObject.getDictRef("P");
        if (pDFObject6 == null) {
            throw new PDFParseException("Required P entry in Encrypt dictionary not found");
        }
        return new StandardDecrypter(encryptionAlgorithm, pDFObject2, n, n2, byArray, byArray2, pDFObject6.getIntValue(), bl, pDFPassword);
    }
}

