/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.NameTable;
import com.sun.pdfview.font.ttf.TrueTypeTable;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class TrueTypeFont {
    private int type;
    private SortedMap<String, Object> tables;

    public TrueTypeFont(int n) {
        this.type = n;
        this.tables = Collections.synchronizedSortedMap(new TreeMap());
    }

    public static TrueTypeFont parseFont(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        return TrueTypeFont.parseFont(byteBuffer);
    }

    public static TrueTypeFont parseFont(ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        short s = byteBuffer.getShort();
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        short s4 = byteBuffer.getShort();
        TrueTypeFont trueTypeFont = new TrueTypeFont(n);
        TrueTypeFont.parseDirectories(byteBuffer, s, trueTypeFont);
        return trueTypeFont;
    }

    public Collection<String> getNames() {
        NameTable nameTable = (NameTable)this.getTable("name");
        if (nameTable != null) {
            return nameTable.getNames();
        }
        return Collections.emptyList();
    }

    public int getType() {
        return this.type;
    }

    public void addTable(String string, ByteBuffer byteBuffer) {
        this.tables.put(string, byteBuffer);
    }

    public void addTable(String string, TrueTypeTable trueTypeTable) {
        this.tables.put(string, trueTypeTable);
    }

    public TrueTypeTable getTable(String string) {
        Object v = this.tables.get(string);
        TrueTypeTable trueTypeTable = null;
        if (v instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)v;
            trueTypeTable = TrueTypeTable.createTable(this, string, byteBuffer);
            this.addTable(string, trueTypeTable);
        } else {
            trueTypeTable = (TrueTypeTable)v;
        }
        return trueTypeTable;
    }

    public void removeTable(String string) {
        this.tables.remove(string);
    }

    public short getNumTables() {
        return (short)this.tables.size();
    }

    public short getSearchRange() {
        double d = Math.floor(Math.log(this.getNumTables()) / Math.log(2.0));
        double d2 = Math.pow(2.0, d);
        return (short)(16.0 * d2);
    }

    public short getEntrySelector() {
        double d = Math.floor(Math.log(this.getNumTables()) / Math.log(2.0));
        double d2 = Math.pow(2.0, d);
        return (short)(Math.log(d2) / Math.log(2.0));
    }

    public short getRangeShift() {
        double d = Math.floor(Math.log(this.getNumTables()) / Math.log(2.0));
        double d2 = Math.pow(2.0, d);
        return (short)(d2 * 16.0 - (double)this.getSearchRange());
    }

    public byte[] writeFont() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getLength());
        byteBuffer.putInt(this.getType());
        byteBuffer.putShort(this.getNumTables());
        byteBuffer.putShort(this.getSearchRange());
        byteBuffer.putShort(this.getEntrySelector());
        byteBuffer.putShort(this.getRangeShift());
        int n = 12 + this.getNumTables() * 16;
        for (String string : this.tables.keySet()) {
            int n2 = TrueTypeTable.stringToTag(string);
            ByteBuffer byteBuffer2 = null;
            Object v = this.tables.get(string);
            byteBuffer2 = v instanceof TrueTypeTable ? ((TrueTypeTable)v).getData() : (ByteBuffer)v;
            int n3 = byteBuffer2.remaining();
            byteBuffer.putInt(n2);
            byteBuffer.putInt(TrueTypeFont.calculateChecksum(string, byteBuffer2));
            byteBuffer.putInt(n);
            byteBuffer.putInt(n3);
            byteBuffer.mark();
            byteBuffer.position(n);
            byteBuffer.put(byteBuffer2);
            byteBuffer2.flip();
            byteBuffer.reset();
            n += n3;
            while (n % 4 > 0) {
                ++n;
            }
        }
        byteBuffer.position(n);
        byteBuffer.flip();
        this.updateChecksumAdj(byteBuffer);
        return byteBuffer.array();
    }

    private static int calculateChecksum(String string, ByteBuffer byteBuffer) {
        int n = 0;
        byteBuffer.mark();
        if (string.equals("head")) {
            n += byteBuffer.getInt();
            n += byteBuffer.getInt();
            byteBuffer.getInt();
        }
        int n2 = (byteBuffer.remaining() + 3) / 4;
        while (n2-- > 0) {
            if (byteBuffer.remaining() > 3) {
                n += byteBuffer.getInt();
                continue;
            }
            byte by = byteBuffer.remaining() > 0 ? byteBuffer.get() : (byte)0;
            byte by2 = byteBuffer.remaining() > 0 ? byteBuffer.get() : (byte)0;
            byte by3 = byteBuffer.remaining() > 0 ? byteBuffer.get() : (byte)0;
            n += (0xFF & by) << 24 | (0xFF & by2) << 16 | (0xFF & by3) << 8;
        }
        byteBuffer.reset();
        return n;
    }

    private static void parseDirectories(ByteBuffer byteBuffer, int n, TrueTypeFont trueTypeFont) {
        for (int i = 0; i < n; ++i) {
            int n2 = byteBuffer.getInt();
            String string = TrueTypeTable.tagToString(n2);
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            int n5 = byteBuffer.getInt();
            byteBuffer.mark();
            byteBuffer.position(n4);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.limit(n5);
            int n6 = TrueTypeFont.calculateChecksum(string, byteBuffer2);
            if (n6 == n3) {
                trueTypeFont.addTable(string, byteBuffer2);
            } else {
                trueTypeFont.addTable(string, byteBuffer2);
            }
            byteBuffer.reset();
        }
    }

    private int getLength() {
        int n = 12 + this.getNumTables() * 16;
        for (Object object : this.tables.values()) {
            n = object instanceof TrueTypeTable ? (n += ((TrueTypeTable)object).getLength()) : (n += ((ByteBuffer)object).remaining());
            if (n % 4 == 0) continue;
            n += 4 - n % 4;
        }
        return n;
    }

    private void updateChecksumAdj(ByteBuffer byteBuffer) {
        int n = TrueTypeFont.calculateChecksum("", byteBuffer);
        int n2 = -1313820742 - n;
        int n3 = 12 + this.getNumTables() * 16;
        for (String string : this.tables.keySet()) {
            if (string.equals("head")) {
                byteBuffer.putInt(n3 + 8, n2);
                return;
            }
            Object v = this.tables.get(string);
            n3 = v instanceof TrueTypeTable ? (n3 += ((TrueTypeTable)v).getLength()) : (n3 += ((ByteBuffer)v).remaining());
            if (n3 % 4 == 0) continue;
            n3 += 4 - n3 % 4;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        System.out.println("Type         : " + this.getType());
        System.out.println("NumTables    : " + this.getNumTables());
        System.out.println("SearchRange  : " + this.getSearchRange());
        System.out.println("EntrySelector: " + this.getEntrySelector());
        System.out.println("RangeShift   : " + this.getRangeShift());
        for (Map.Entry<String, Object> entry : this.tables.entrySet()) {
            TrueTypeTable trueTypeTable = null;
            trueTypeTable = entry.getValue() instanceof ByteBuffer ? this.getTable(entry.getKey()) : (TrueTypeTable)entry.getValue();
            System.out.println(trueTypeTable);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: ");
            System.out.println("    TrueTypeParser <filename>");
            System.exit(-1);
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(stringArray[0], "r");
            int n = (int)randomAccessFile.length();
            byte[] byArray = new byte[n];
            randomAccessFile.readFully(byArray);
            TrueTypeFont trueTypeFont = TrueTypeFont.parseFont(byArray);
            System.out.println(trueTypeFont);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(trueTypeFont.writeFont());
            Font font = Font.createFont(0, byteArrayInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

