/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.handlers;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.external.ImageHelper;
import org.jpedal.io.JAIHelper;
import org.jpedal.utils.LogWriter;

public class DefaultImageHelper
implements ImageHelper {
    public DefaultImageHelper() {
        ImageIO.setUseCache(false);
    }

    @Override
    public void write(BufferedImage image, String type, String file_name) throws Exception {
        if (!type.equals("jpg") && JAIHelper.isJAIused()) {
            JAIHelper.confirmJAIOnClasspath();
            JAI.create((String)"filestore", (RenderedImage)image, (Object)file_name, (Object)type);
        } else {
            if (GenericColorSpace.fasterPNG) {
                BufferedImage indexedImage = new BufferedImage(image.getWidth(), image.getHeight(), 13);
                Graphics2D g = indexedImage.createGraphics();
                g.drawImage((Image)image, 0, 0, null);
                image = indexedImage;
            }
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(file_name)));
            ImageIO.write((RenderedImage)image, type, bos);
            bos.flush();
            bos.close();
        }
    }

    @Override
    public BufferedImage read(String file_name) {
        boolean isLoaded = false;
        BufferedImage image = null;
        if (JAIHelper.isJAIused()) {
            try {
                image = JAI.create((String)"fileload", (Object)file_name).getAsBufferedImage();
                isLoaded = true;
            }
            catch (Exception e) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
                isLoaded = false;
            }
            catch (Error err) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Error: " + err.getMessage());
                }
                throw new RuntimeException("Error " + err + " loading " + file_name + " with JAI");
            }
        }
        if (!isLoaded) {
            try {
                image = ImageIO.read(new File(file_name));
            }
            catch (IOException e) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            catch (Error err) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Error: " + err.getMessage());
                }
                throw new RuntimeException("Error " + err + " loading " + file_name + " with ImageIO");
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Raster readRasterFromJPeg(byte[] data) throws IOException {
        Raster ras = null;
        ImageReader iir = null;
        ImageInputStream iin = null;
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            ImageReader o;
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
            while (iterator.hasNext() && !(iir = (o = iterator.next())).canReadRaster()) {
            }
            ImageIO.setUseCache(false);
            iin = ImageIO.createImageInputStream(in);
            iir.setInput(iin, true);
            ras = iir.readRaster(0, null);
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Unable to find JAI jars on classpath");
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (iin != null) {
                iin.flush();
                iin.close();
            }
            if (iir != null) {
                iir.dispose();
            }
        }
        return ras;
    }

    @Override
    public BufferedImage read(byte[] data) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ImageIO.setUseCache(false);
        return ImageIO.read(bis);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DefaultImageHelper []");
        return builder.toString();
    }
}

