/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.TrueType;
import org.jpedal.fonts.Type1C;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1GlyphFactory;
import org.jpedal.fonts.glyph.T1Glyphs;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Hhea;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.fonts.tt.conversion.CFFFixer;
import org.jpedal.fonts.tt.conversion.CFFWriter;
import org.jpedal.fonts.tt.conversion.CMAPWriter;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.FontWriter;
import org.jpedal.fonts.tt.conversion.HeadWriter;
import org.jpedal.fonts.tt.conversion.HheaWriter;
import org.jpedal.fonts.tt.conversion.HmtxWriter;
import org.jpedal.fonts.tt.conversion.LocaWriter;
import org.jpedal.fonts.tt.conversion.MAXPWriter;
import org.jpedal.fonts.tt.conversion.NameWriter;
import org.jpedal.fonts.tt.conversion.OS2Writer;
import org.jpedal.fonts.tt.conversion.PostWriter;
import org.jpedal.utils.LogWriter;

public class PS2OTFFontWriter
extends FontWriter {
    private static final long serialVersionUID = 3332020682301464589L;
    byte[] cff;
    byte[] cmap = null;
    PdfFont pdfFont;
    PdfFont originalFont;
    PdfJavaGlyphs glyphs;
    int minCharCode;
    int maxCharCode;
    private int xAvgCharWidth = 0;
    private double xMaxExtent = Double.MIN_VALUE;
    private double minRightSideBearing = Double.MAX_VALUE;
    private double minLeftSideBearing = Double.MAX_VALUE;
    private double advanceWidthMax = Double.MIN_VALUE;
    private double lowestDescender = -1.0;
    private double highestAscender = 1.0;
    private float[] fontBBox = new float[4];
    private double emSquareSize = 1000.0;
    private int[] advanceWidths;
    private int[] lsbs = null;
    private HashMap<String, Integer> widthMap;
    private String[] glyphList = null;
    FontFile2 orginTTTables = null;

    public PS2OTFFontWriter(PdfFont originalFont, byte[] rawFontData, String fileType, HashMap<String, Integer> widths) throws Exception {
        boolean is1C = fileType.equals("cff");
        this.name = originalFont.getBaseFontName();
        this.widthMap = widths;
        String[] tablesUsed = new String[]{"CFF ", "OS/2", "cmap", "head", "hhea", "hmtx", "maxp", "name", "post"};
        if (fileType.equals("ttf")) {
            this.subType = 11;
            this.glyphs = originalFont.getGlyphData();
            this.pdfFont = new TrueType(rawFontData, this.glyphs);
            this.orginTTTables = new FontFile2(rawFontData);
            tablesUsed = new String[]{"OS/2", "cmap", "cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "name", "post", "prep"};
            for (int i = 0; i < tablesUsed.length; ++i) {
                this.IDtoTable.put(tablesUsed[i], i);
            }
        } else {
            this.glyphs = new T1Glyphs(false, is1C);
            this.pdfFont = new Type1C(rawFontData, this.glyphs, is1C);
        }
        this.glyphCount = this.glyphs.getGlyphCount();
        this.originalFont = originalFont;
        this.cff = rawFontData;
        this.tableList = new ArrayList();
        this.numTables = tablesUsed.length;
        int floor = 1;
        while (floor * 2 <= this.numTables) {
            floor *= 2;
        }
        this.searchRange = floor * 16;
        this.entrySelector = 0;
        while (Math.pow(2.0, this.entrySelector) < (double)floor) {
            ++this.entrySelector;
        }
        this.rangeShift = this.numTables * 16 - this.searchRange;
        this.tableList.addAll(Arrays.asList(tablesUsed).subList(0, this.numTables));
        this.checksums = new int[this.tableCount][1];
        this.tables = new int[this.tableCount][1];
        this.tableLength = new int[this.tableCount][1];
        this.type = 1;
    }

    @Override
    void readTables() {
        int totalWidth = 0;
        this.advanceWidths = new int[this.glyphCount];
        if (this.widthMap != null) {
            for (int i = 0; i < this.glyphCount; ++i) {
                Integer w = this.pdfFont.isCIDFont() ? this.widthMap.get(this.glyphs.getCharGlyph(i + 1)) : this.widthMap.get(this.glyphs.getIndexForCharString(i + 1));
                if (w != null) {
                    this.advanceWidths[i] = w;
                } else if (this.pdfFont.is1C()) {
                    Integer num;
                    int fd = 0;
                    if (((Type1C)this.pdfFont).getFDSelect() != null) {
                        fd = ((Type1C)this.pdfFont).getFDSelect()[i];
                    }
                    if ((num = this.widthMap.get("JPedalDefaultWidth" + fd)) != null) {
                        this.advanceWidths[i] = num;
                    }
                }
                this.advanceWidthMax = this.advanceWidthMax > (double)this.advanceWidths[i] ? this.advanceWidthMax : (double)this.advanceWidths[i];
                totalWidth += this.advanceWidths[i];
            }
        }
        if (this.glyphCount > 0) {
            this.xAvgCharWidth = (int)((double)totalWidth / (double)this.glyphCount);
        }
        double maxX = Double.MIN_VALUE;
        int iterationCount = this.glyphCount;
        if (this.originalFont.getCIDToGIDMap() != null && this.originalFont.getCIDToGIDMap().length < iterationCount) {
            iterationCount = this.originalFont.getCIDToGIDMap().length;
        }
        for (int i = 0; i < iterationCount && i < 256; ++i) {
            PdfGlyph glyph = this.glyphs.getEmbeddedGlyph(new T1GlyphFactory(), this.pdfFont.getMappedChar(i, false), new float[][]{{1.0f, 0.0f}, {0.0f, 1.0f}}, i, this.pdfFont.getGlyphValue(i), this.pdfFont.getWidth(i), this.pdfFont.getMappedChar(i, false));
            if (glyph == null || glyph.getShape() == null) continue;
            Rectangle2D area = glyph.getShape().getBounds2D();
            double lsb = area.getMinX();
            double rsb = (double)this.advanceWidths[i] - area.getMaxX();
            double extent = area.getMinX() + area.getWidth();
            this.minLeftSideBearing = this.minLeftSideBearing < lsb ? this.minLeftSideBearing : lsb;
            this.minRightSideBearing = this.minRightSideBearing < rsb ? this.minRightSideBearing : rsb;
            this.xMaxExtent = this.xMaxExtent > extent ? this.xMaxExtent : extent;
            this.lowestDescender = this.lowestDescender < area.getMinY() ? this.lowestDescender : area.getMinY();
            this.highestAscender = this.highestAscender > area.getMaxY() ? this.highestAscender : area.getMaxY();
            maxX = maxX > area.getMaxX() ? maxX : area.getMaxX();
        }
        this.fontBBox = this.originalFont.is1C() ? this.pdfFont.FontBBox : this.originalFont.getFontBounds();
        this.minLeftSideBearing = this.minLeftSideBearing < (double)this.fontBBox[0] ? this.minLeftSideBearing : (double)this.fontBBox[0];
        this.lowestDescender = this.lowestDescender < (double)this.fontBBox[1] ? this.lowestDescender : (double)this.fontBBox[1];
        maxX = maxX > (double)this.fontBBox[2] ? maxX : (double)this.fontBBox[2];
        this.highestAscender = this.highestAscender > (double)this.fontBBox[3] ? this.highestAscender : (double)this.fontBBox[3];
        this.fontBBox = new float[]{(float)this.minLeftSideBearing, (float)this.lowestDescender, (float)maxX, (float)this.highestAscender};
    }

    @Override
    public byte[] getTableBytes(int tableID) {
        byte[] fontData;
        block36: {
            fontData = new byte[]{};
            FontTableWriter tableWriter = null;
            switch (tableID) {
                case 16: {
                    if (this.pdfFont.is1C()) {
                        fontData = new CFFFixer(this.cff).getBytes();
                        break;
                    }
                    tableWriter = new CFFWriter(this.glyphs, this.name);
                    CFFWriter cffWriter = (CFFWriter)tableWriter;
                    this.glyphList = cffWriter.getGlyphList();
                    this.advanceWidths = cffWriter.getWidths();
                    this.lsbs = cffWriter.getBearings();
                    this.fontBBox = cffWriter.getBBox();
                    this.emSquareSize = cffWriter.getEmSquareSize();
                    this.highestAscender = this.fontBBox[3];
                    this.lowestDescender = this.fontBBox[1];
                    this.advanceWidthMax = 0.0;
                    int totalWidth = 0;
                    for (int i = 0; i < this.advanceWidths.length; ++i) {
                        this.advanceWidthMax = this.advanceWidthMax > (double)this.advanceWidths[i] ? this.advanceWidthMax : (double)this.advanceWidths[i];
                        totalWidth += this.advanceWidths[i];
                        this.minLeftSideBearing = this.minLeftSideBearing < (double)this.lsbs[i] ? this.minLeftSideBearing : (double)this.lsbs[i];
                    }
                    if (this.glyphCount <= 0) break;
                    this.xAvgCharWidth = (int)((double)totalWidth / (double)this.glyphCount);
                    break;
                }
                case 0: {
                    if (this.subType == 11) {
                        fontData = this.orginTTTables.getTableBytes(0);
                        break;
                    }
                    tableWriter = new HeadWriter(this.fontBBox);
                    break;
                }
                case 2: {
                    if (this.subType == 11) {
                        tableWriter = new CMAPWriter(this.name, this.pdfFont, this.originalFont, this.glyphs, this.glyphList);
                        break;
                    }
                    tableWriter = new CMAPWriter(this.name, this.pdfFont, this.originalFont, this.glyphs, this.glyphList);
                    this.minCharCode = tableWriter.getIntValue(0);
                    this.maxCharCode = tableWriter.getIntValue(1);
                    break;
                }
                case 4: {
                    fontData = this.orginTTTables.getTableBytes(4);
                    break;
                }
                case 5: {
                    if (this.subType == 11) {
                        TTGlyphs ttGlyphs = (TTGlyphs)this.glyphs;
                        Hmtx hmtx = (Hmtx)ttGlyphs.getTable(6);
                        Hhea hhea = (Hhea)ttGlyphs.getTable(5);
                        boolean changed = false;
                        int localAdvanceWidthMax = hhea.getIntValue(4);
                        if (localAdvanceWidthMax == 0) {
                            for (int z = 0; z < this.glyphs.getGlyphCount(); ++z) {
                                int temp = (int)hmtx.getUnscaledWidth(z);
                                localAdvanceWidthMax = temp > localAdvanceWidthMax ? temp : localAdvanceWidthMax;
                            }
                            if (localAdvanceWidthMax != hhea.getIntValue(4)) {
                                changed = true;
                            }
                        }
                        if (changed) {
                            tableWriter = new HheaWriter(this.glyphs, hhea.getIntValue(7), hhea.getIntValue(6), hhea.getIntValue(6), localAdvanceWidthMax, hhea.getIntValue(2), hhea.getIntValue(1));
                            break;
                        }
                        fontData = this.orginTTTables.getTableBytes(5);
                        break;
                    }
                    tableWriter = new HheaWriter(this.glyphs, this.xMaxExtent, this.minRightSideBearing, this.minLeftSideBearing, this.advanceWidthMax, this.lowestDescender, this.highestAscender);
                    break;
                }
                case 6: {
                    if (this.subType == 11) {
                        fontData = this.orginTTTables.getTableBytes(6);
                        break;
                    }
                    tableWriter = new HmtxWriter(this.glyphs, this.advanceWidths, this.lsbs);
                    break;
                }
                case 3: {
                    if (this.subType == 11) {
                        fontData = this.orginTTTables.getTableBytes(3);
                        break;
                    }
                    tableWriter = new LocaWriter(this.name, this.pdfFont, this.originalFont, this.glyphs, this.glyphList);
                    break;
                }
                case 13: {
                    byte[] data;
                    if (this.subType == 11) {
                        data = this.orginTTTables.getTableBytes(13);
                        if (data.length > 0) {
                            fontData = data;
                            break;
                        }
                        tableWriter = new OS2Writer(this.originalFont, this.glyphs, this.xAvgCharWidth, this.minCharCode, this.maxCharCode, this.fontBBox, this.emSquareSize);
                        break;
                    }
                    tableWriter = new OS2Writer(this.originalFont, this.glyphs, this.xAvgCharWidth, this.minCharCode, this.maxCharCode, this.fontBBox, this.emSquareSize);
                    break;
                }
                case 1: {
                    if (this.subType == 11) {
                        fontData = this.orginTTTables.getTableBytes(1);
                        break;
                    }
                    tableWriter = new MAXPWriter(this.glyphs);
                    break;
                }
                case 7: {
                    if (this.subType == 11) {
                        tableWriter = new NameWriter(this.pdfFont, this.glyphs, this.name);
                        break;
                    }
                    tableWriter = new NameWriter(this.pdfFont, this.glyphs, this.name);
                    break;
                }
                case 8: {
                    byte[] data;
                    if (this.subType == 11) {
                        data = this.orginTTTables.getTableBytes(8);
                        if (data.length > 0) {
                            fontData = data;
                            break;
                        }
                        tableWriter = new PostWriter();
                        break;
                    }
                    tableWriter = new PostWriter();
                    break;
                }
                case 14: {
                    fontData = this.orginTTTables.getTableBytes(14);
                    if (fontData.length != 0) break;
                    fontData = new byte[]{FontWriter.setNextUint8(0)};
                    break;
                }
                case 9: {
                    fontData = this.orginTTTables.getTableBytes(9);
                    if (fontData.length != 0) break;
                    fontData = FontWriter.setNextUint16(0);
                    break;
                }
                case 10: {
                    fontData = this.orginTTTables.getTableBytes(10);
                    if (fontData.length != 0) break;
                    fontData = new byte[]{FontWriter.setNextUint8(0)};
                    break;
                }
            }
            if (tableWriter != null) {
                try {
                    fontData = tableWriter.writeTable();
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block36;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        return fontData;
    }
}

