/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.grouping;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.SearchListener;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_String;

public class PdfGroupingAlgorithms {
    private boolean includeHTMLtags = false;
    public static final int USER_DEFINED_LIST_ONLY = 0;
    public static final int SURROUND_BY_ANY_PUNCTUATION = 1;
    private static String SystemSeparator = System.getProperty("line.separator");
    private boolean[] isUsed;
    private float[] f_x1;
    private float[] f_x2;
    private float[] f_y1;
    private float[] f_y2;
    private boolean[] hadSpace;
    private String[] f_colorTag;
    private int[] writingMode;
    private int[] moveType;
    private int[] fontSize;
    private float[] spaceWidth;
    private StringBuilder[] content;
    private int[] textLength;
    private PdfData pdf_data;
    PdfPageData pageData;
    private boolean isXHTML = true;
    private int nextSlot;
    private Vector_Int lineBreaks = new Vector_Int();
    private Vector_Object lines;
    private Vector_Int lineY2;
    private static final String MARKER = PdfData.marker;
    public static char MARKER2 = MARKER.charAt(0);
    private int max_rows = 0;
    private int master = 0;
    private boolean colorExtracted = false;
    private int[] line_order;
    private static final int increment = 100;
    public static boolean useUnrotatedCoords;
    private float[] endPoints;
    private boolean includeTease;
    private String[] teasers;
    private List multipleTermTeasers = new ArrayList();
    private boolean usingMultipleTerms = false;
    private boolean isXMLExtraction = true;
    private int linkedSearchAreas = -101;

    public PdfGroupingAlgorithms(PdfData pdf_data, PdfPageData pageData, boolean isXMLExtraction) {
        this.pdf_data = pdf_data;
        this.pageData = pageData;
        this.isXMLExtraction = isXMLExtraction;
        this.colorExtracted = pdf_data.isColorExtracted();
    }

    public static void setSeparator(String sep) {
        SystemSeparator = sep;
    }

    private static final String getLineDownSeparator(StringBuilder rawLine1, StringBuilder rawLine2, boolean isXMLExtraction) {
        StringBuilder line2;
        StringBuilder line1;
        String returnValue = " ";
        boolean hasUnderline = false;
        if (isXMLExtraction) {
            line1 = Strip.stripXML(rawLine1, isXMLExtraction);
            line2 = Strip.stripXML(rawLine2, isXMLExtraction);
        } else {
            line1 = Strip.trim(rawLine1);
            line2 = Strip.trim(rawLine2);
        }
        int line1Len = line1.length();
        int line2Len = line2.length();
        if (line1Len > 1 && line2Len > 1) {
            char line1Char2 = line1.charAt(line1Len - 1);
            char line1Char1 = line1.charAt(line1Len - 2);
            char line2Char1 = line2.charAt(0);
            char line2Char2 = line2.charAt(1);
            String hyphen_values = "";
            if (hyphen_values.indexOf(line1Char2) != -1) {
                returnValue = "";
                if (line1Char1 == ':') {
                    returnValue = "\n";
                }
                if (line1Char2 == ' ') {
                    returnValue = " ";
                }
            } else if ((line1Char1 == '.' | line1Char2 == '.') & (Character.isUpperCase(line2Char1) | line2Char1 == '&' | Character.isUpperCase(line2Char2) | line2Char2 == '&')) {
                returnValue = isXMLExtraction ? "<p></p>\n" : "\n";
            }
        }
        if (hasUnderline) {
            returnValue = isXMLExtraction ? returnValue + "<p></p>\n" : returnValue + '\n';
        }
        return returnValue;
    }

    private final void cleanupShadowsAndDrownedObjects(boolean avoidSpaces) {
        int[] items = this.getUnusedFragments();
        int count = items.length;
        for (int p = 0; p < count; ++p) {
            int c = items[p];
            if (this.isUsed[c]) continue;
            float midX = (this.f_x1[c] + this.f_x2[c]) / 2.0f;
            float midY = (this.f_y1[c] + this.f_y2[c]) / 2.0f;
            for (int p2 = p + 1; p2 < count; ++p2) {
                String separator;
                boolean b_in_a;
                float diff;
                int n = items[p2];
                if (this.isUsed[n] || this.isUsed[c]) continue;
                float fontDiff = this.fontSize[n] - this.fontSize[c];
                if (fontDiff < 0.0f) {
                    fontDiff = -fontDiff;
                }
                if ((diff = this.f_x2[n] - this.f_x1[n] - (this.f_x2[c] - this.f_x1[c])) < 0.0f) {
                    diff = -diff;
                }
                if (fontDiff == 0.0f && midX > this.f_x1[n] && midX < this.f_x2[n] && diff < 10.0f && midY < this.f_y1[n] && midY > this.f_y2[n]) {
                    this.isUsed[n] = true;
                    continue;
                }
                boolean a_in_b = this.f_x1[n] > this.f_x1[c] && this.f_x2[n] < this.f_x2[c] && this.f_y1[n] < this.f_y1[c] && this.f_y2[n] > this.f_y2[c];
                boolean bl = b_in_a = this.f_x1[c] > this.f_x1[n] && this.f_x2[c] < this.f_x2[n] && this.f_y1[c] < this.f_y1[n] && this.f_y2[c] > this.f_y2[n];
                if (!a_in_b && !b_in_a) continue;
                if (this.f_y2[c] > this.f_y2[n]) {
                    separator = PdfGroupingAlgorithms.getLineDownSeparator(this.content[c], this.content[n], this.isXMLExtraction);
                    if (!avoidSpaces || separator.indexOf(32) == -1) {
                        this.merge(c, n, separator, true);
                    }
                } else {
                    separator = PdfGroupingAlgorithms.getLineDownSeparator(this.content[n], this.content[c], this.isXMLExtraction);
                    if (!avoidSpaces || separator.indexOf(32) == -1) {
                        this.merge(n, c, separator, true);
                    }
                }
                midX = (this.f_x1[c] + this.f_x2[c]) / 2.0f;
                midY = (this.f_y1[c] + this.f_y2[c]) / 2.0f;
            }
        }
    }

    private final String isGapASpace(int c, int l, float actualGap, boolean addMultiplespaceXMLTag, int writingMode) {
        int spaceCount;
        String sep = "";
        float gapA = this.spaceWidth[c] * (float)this.fontSize[c];
        float gapB = this.spaceWidth[l] * (float)this.fontSize[l];
        float gap = gapA > gapB ? gapB : gapA;
        if ((gap = actualGap / (gap / 1000.0f)) > 0.51f && gap < 1.0f) {
            gap = 1.0f;
        }
        if ((spaceCount = (int)gap) > 0) {
            sep = " ";
        }
        if (spaceCount > 1 && addMultiplespaceXMLTag && writingMode == 0) {
            sep = " <SpaceCount space=\"" + spaceCount + "\" />";
        }
        return sep;
    }

    private final void merge(int m, int c, String separator, boolean moveFont) {
        if (this.f_x1[m] > this.f_x1[c]) {
            this.f_x1[m] = this.f_x1[c];
        }
        if (this.f_y1[m] < this.f_y1[c]) {
            this.f_y1[m] = this.f_y1[c];
        }
        if (this.f_x2[m] < this.f_x2[c]) {
            this.f_x2[m] = this.f_x2[c];
        }
        if (this.f_y2[m] > this.f_y2[c]) {
            this.f_y2[m] = this.f_y2[c];
        }
        if (this.isXMLExtraction) {
            String test = Fonts.fe;
            if (this.colorExtracted) {
                test = Fonts.fe + "</color>";
            }
            if (moveFont && this.content[m].toString().lastIndexOf(test) != -1) {
                String master = this.content[m].toString();
                this.content[m] = new StringBuilder(master.substring(0, master.lastIndexOf(test)));
                this.content[m].append(separator);
                this.content[m].append(master.substring(master.lastIndexOf(test)));
            } else {
                this.content[m].append(separator);
            }
            if (this.textLength[c] > 1 && this.content[m].toString().endsWith(" ")) {
                this.content[m].deleteCharAt(this.content[m].lastIndexOf(" "));
            }
            this.fontSize[m] = this.fontSize[c];
            if (this.content[c].indexOf("<color") != -1 && this.content[m].indexOf("<color") != -1 && this.content[c].toString().startsWith(this.content[m].substring(this.content[m].lastIndexOf("<color"), this.content[m].indexOf(">", this.content[m].lastIndexOf("<color")))) && this.content[m].lastIndexOf("</color>") + 7 == this.content[m].lastIndexOf(">")) {
                this.content[c].replace(this.content[c].indexOf("<color"), this.content[c].indexOf(">") + 1, "");
                this.content[m].replace(this.content[m].lastIndexOf("</color>"), this.content[m].lastIndexOf("</color>") + 8, "");
            }
            if (this.content[c].indexOf("<font") != -1 && this.content[m].indexOf("<font") != -1 && this.content[c].toString().startsWith(this.content[m].substring(this.content[m].lastIndexOf("<font"), this.content[m].indexOf(">", this.content[m].lastIndexOf("<font")))) && this.content[m].lastIndexOf("</font>") + 6 == this.content[m].lastIndexOf(">")) {
                this.content[c].replace(this.content[c].indexOf("<font"), this.content[c].indexOf(">") + 1, "");
                this.content[m].replace(this.content[m].lastIndexOf("</font>"), this.content[m].lastIndexOf("</font>") + 7, "");
            }
            this.content[m] = this.content[m].append((CharSequence)this.content[c]);
            this.textLength[m] = this.textLength[m] + this.textLength[c];
            this.isUsed[c] = true;
            this.content[c] = null;
        } else {
            this.fontSize[m] = this.fontSize[c];
            this.content[m] = this.content[m].append(separator).append((CharSequence)this.content[c]);
            this.textLength[m] = this.textLength[m] + this.textLength[c];
            this.isUsed[c] = true;
            this.content[c] = null;
        }
    }

    private final void removeEncoding() {
        int[] items;
        for (int item : items = this.getUnusedFragments()) {
            int current = item;
            if (this.isUsed[current]) continue;
            this.content[current] = this.removeHiddenMarkers(current);
        }
    }

    private final void copyToArrays() {
        this.colorExtracted = this.pdf_data.isColorExtracted();
        int count = this.pdf_data.getRawTextElementCount();
        this.isUsed = new boolean[count];
        this.fontSize = new int[count];
        this.writingMode = new int[count];
        this.spaceWidth = new float[count];
        this.content = new StringBuilder[count];
        this.textLength = new int[count];
        this.f_x1 = new float[count];
        this.f_colorTag = new String[count];
        this.f_x2 = new float[count];
        this.f_y1 = new float[count];
        this.f_y2 = new float[count];
        this.moveType = new int[count];
        for (int i = 0; i < count; ++i) {
            this.content[i] = new StringBuilder(this.pdf_data.contents[i]);
            this.fontSize[i] = this.pdf_data.f_end_font_size[i];
            this.writingMode[i] = this.pdf_data.f_writingMode[i];
            this.f_x1[i] = this.pdf_data.f_x1[i];
            this.f_colorTag[i] = this.pdf_data.colorTag[i];
            this.f_x2[i] = this.pdf_data.f_x2[i];
            this.f_y1[i] = this.pdf_data.f_y1[i];
            this.f_y2[i] = this.pdf_data.f_y2[i];
            this.moveType[i] = this.pdf_data.move_command[i];
            this.spaceWidth[i] = this.pdf_data.space_width[i];
            this.textLength[i] = this.pdf_data.text_length[i];
        }
    }

    private int[] getUnusedFragments() {
        int total_fragments = this.isUsed.length;
        int ii = 0;
        int[] temp_index = new int[total_fragments];
        for (int i = 0; i < total_fragments; ++i) {
            if (this.isUsed[i]) continue;
            temp_index[ii] = i;
            ++ii;
        }
        int[] items = new int[ii];
        System.arraycopy(temp_index, 0, items, 0, ii);
        return items;
    }

    private StringBuilder removeHiddenMarkers(int c) {
        if (this.content[c].indexOf(MARKER) == -1) {
            return this.content[c];
        }
        StringTokenizer tokens = new StringTokenizer(this.content[c].toString(), MARKER, true);
        StringBuilder processedData = new StringBuilder();
        while (tokens.hasMoreTokens()) {
            String temp = tokens.nextToken();
            if (temp.equals(MARKER)) {
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                processedData = processedData.append(tokens.nextToken());
                continue;
            }
            processedData = processedData.append(temp);
        }
        return processedData;
    }

    public void setIncludeHTML(boolean value) {
        this.includeHTMLtags = value;
    }

    public static String removeHiddenMarkers(String contents) {
        if (contents == null) {
            return null;
        }
        if (!contents.contains(MARKER)) {
            return contents;
        }
        StringTokenizer tokens = new StringTokenizer(contents, MARKER, true);
        String temp_token = null;
        StringBuilder processed_data = new StringBuilder();
        boolean pushBackByOne = false;
        while (tokens.hasMoreTokens()) {
            if (!pushBackByOne) {
                temp_token = tokens.nextToken();
            } else {
                pushBackByOne = false;
            }
            if (MARKER.equals(temp_token)) {
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                String next = tokens.nextToken();
                if (next.equals(MARKER)) {
                    pushBackByOne = true;
                    continue;
                }
                processed_data = processed_data.append(next);
                continue;
            }
            processed_data = processed_data.append(temp_token);
        }
        return processed_data.toString();
    }

    private void findVerticalLines(float minX, float minY, float maxX, float maxY, int currentWritingMode) throws PdfException {
        HashMap<Integer, Integer> xLines = new HashMap<Integer, Integer>();
        int most_frequent = 0;
        int count = this.pdf_data.getRawTextElementCount();
        for (int i = 0; i < count; ++i) {
            float y2;
            float y1;
            float x2;
            float x1;
            float currentX = 0.0f;
            String raw = this.pdf_data.contents[i];
            if (currentWritingMode == 0) {
                x1 = this.f_x1[i];
                x2 = this.f_x2[i];
                y1 = this.f_y1[i];
                y2 = this.f_y2[i];
            } else if (currentWritingMode == 1) {
                x2 = this.f_x1[i];
                x1 = this.f_x2[i];
                y1 = this.f_y1[i];
                y2 = this.f_y2[i];
            } else if (currentWritingMode == 3) {
                x1 = this.f_y1[i];
                x2 = this.f_y2[i];
                y1 = this.f_x2[i];
                y2 = this.f_x1[i];
            } else if (currentWritingMode == 2) {
                x1 = this.f_y2[i];
                x2 = this.f_y1[i];
                y2 = this.f_x1[i];
                y1 = this.f_x2[i];
            } else {
                throw new PdfException("Illegal value " + currentWritingMode + "for currentWritingMode");
            }
            if (!((double)x1 > (double)minX - 0.5) || !((double)x2 < (double)maxX + 0.5) || !((double)y2 > (double)minY - 0.5) || !((double)y1 < (double)maxY + 0.5)) continue;
            StringTokenizer tokens = new StringTokenizer(raw, MARKER, true);
            String lastValue = "";
            while (tokens.hasMoreTokens()) {
                String value = tokens.nextToken();
                if (!value.equals(MARKER)) continue;
                value = tokens.nextToken();
                if (value.length() > 0) {
                    float lastX = currentX;
                    currentX = Float.parseFloat(value);
                    try {
                        if (lastValue.length() == 0 || lastValue.indexOf(32) != -1) {
                            Integer intX = (int)currentX;
                            Object currentValue = xLines.get(intX);
                            if (currentValue == null) {
                                xLines.put(intX, 1);
                            } else {
                                int countReached = (Integer)currentValue;
                                if (++countReached > most_frequent) {
                                    most_frequent = countReached;
                                }
                                xLines.put(intX, countReached);
                            }
                            int middle = (int)(lastX + (currentX - lastX) / 2.0f);
                            if (lastX != 0.0f) {
                                intX = middle;
                                currentValue = xLines.get(intX);
                                if (currentValue == null) {
                                    xLines.put(intX, 1);
                                } else {
                                    int count_reached = (Integer)currentValue;
                                    if (++count_reached > most_frequent) {
                                        most_frequent = count_reached;
                                    }
                                    xLines.put(intX, count_reached);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        LogWriter.writeLog("Exception " + e + " stripping x values");
                    }
                }
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                lastValue = value = tokens.nextToken();
            }
        }
        Iterator keys = xLines.keySet().iterator();
        int minimum_needed = most_frequent / 2;
        while (keys.hasNext()) {
            Integer current_key = (Integer)keys.next();
            int current_count = (Integer)xLines.get(current_key);
            if (current_count <= minimum_needed) continue;
            this.lineBreaks.addElement(current_key);
        }
    }

    private void copyToArrays(float minX, float minY, float maxX, float maxY, boolean keepFont, boolean breakOnSpace, boolean findLines, String punctuation, boolean isWordlist) throws PdfException {
        boolean debugSplit = false;
        int count = this.pdf_data.getRawTextElementCount() + 100;
        this.f_x1 = new float[count];
        this.f_colorTag = new String[count];
        this.hadSpace = new boolean[count];
        this.f_x2 = new float[count];
        this.f_y1 = new float[count];
        this.f_y2 = new float[count];
        this.spaceWidth = new float[count];
        this.content = new StringBuilder[count];
        this.fontSize = new int[count];
        this.textLength = new int[count];
        this.writingMode = new int[count];
        this.isUsed = new boolean[count];
        this.moveType = new int[count];
        boolean linesScanned = false;
        count -= 100;
        String char_width = "";
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            float max;
            float min;
            float last_pt;
            float pt;
            float character_spacing = this.pdf_data.f_character_spacing[i];
            String raw = this.pdf_data.contents[i];
            float x1 = this.pdf_data.f_x1[i];
            String currentColor = this.pdf_data.colorTag[i];
            float x2 = this.pdf_data.f_x2[i];
            float y1 = this.pdf_data.f_y1[i];
            float y2 = this.pdf_data.f_y2[i];
            int text_length = this.pdf_data.text_length[i];
            int mode = this.pdf_data.f_writingMode[i];
            int moveType = this.pdf_data.move_command[i];
            boolean accepted = false;
            if ((mode == 0 || mode == 1) && y2 > minY && y1 < maxY && x1 < maxX && x2 > minX) {
                accepted = true;
            } else if ((mode == 3 || mode == 2) && x1 > minX && x2 < maxX && y1 > minY && y2 < maxY) {
                accepted = true;
            }
            if (!accepted) continue;
            if (!linesScanned && findLines) {
                this.findVerticalLines(minX, minY, maxX, maxY, mode);
                linesScanned = true;
            }
            if (mode == 0 || mode == 1) {
                pt = x1;
                last_pt = x1;
                min = minX;
                max = maxX;
            } else {
                pt = y2;
                last_pt = y2;
                min = minY;
                max = maxY;
            }
            float linePos = -1.0f;
            char[] line = raw.toCharArray();
            int end = line.length;
            int pointer = 0;
            String textValue = "";
            if (!raw.contains(MARKER)) {
                text = new StringBuilder(raw);
            }
            boolean isFirstValue = true;
            boolean breakPointset = false;
            while (pointer < end) {
                String value;
                do {
                    int startPointer;
                    if (line[pointer] != MARKER2) {
                        startPointer = pointer;
                        while (pointer < end && line[pointer] != MARKER2) {
                            ++pointer;
                        }
                        value = raw.substring(startPointer, pointer);
                    } else {
                        while (pointer < end && line[pointer] != MARKER2) {
                            ++pointer;
                        }
                        startPointer = ++pointer;
                        while (pointer < end && line[pointer] != MARKER2) {
                            ++pointer;
                        }
                        String pt_reached = raw.substring(startPointer, pointer);
                        startPointer = ++pointer;
                        while (pointer < end && line[pointer] != MARKER2) {
                            ++pointer;
                        }
                        char_width = raw.substring(startPointer, pointer);
                        startPointer = ++pointer;
                        while (pointer < end && line[pointer] != MARKER2) {
                            ++pointer;
                        }
                        textValue = value = raw.substring(startPointer, pointer);
                        if (pt_reached.length() > 0) {
                            last_pt = pt;
                            pt = Float.parseFloat(pt_reached);
                            if (breakPointset) {
                                if (mode == 0) {
                                    x1 = pt;
                                } else if (mode == 1) {
                                    x2 = pt;
                                } else if (mode == 3) {
                                    y2 = pt;
                                } else if (mode == 2) {
                                    y1 = pt;
                                }
                                breakPointset = false;
                            }
                        }
                        if (this.isXMLExtraction && last_pt < min && pt > min && !value.startsWith(Fonts.fb)) {
                            value = Fonts.getActiveFontTag(raw, "") + value;
                        }
                    }
                    if (pt > min & pt < max) {
                        if (mode != 0) break;
                        if ((x1 < min || x1 > max) && pt >= min) {
                            x1 = pt;
                            break;
                        }
                        if (mode != 1) break;
                        if ((x2 > max || x2 < min) && pt <= max) {
                            x2 = pt;
                            break;
                        }
                        if (mode != 3) break;
                        if ((y2 < min || y2 > max) && pt >= min) {
                            y2 = pt;
                            break;
                        }
                        if (mode != 2 || !(y1 < min) && !(y1 > max) || !(pt <= min)) break;
                        y1 = pt;
                        break;
                    }
                    value = "";
                    textValue = "";
                } while (pointer < end);
                if (isFirstValue) {
                    isFirstValue = false;
                    if (this.isXMLExtraction && keepFont && !value.startsWith(Fonts.fb) && !value.startsWith("<color ")) {
                        text.append(Fonts.getActiveFontTag(text.toString(), raw));
                    }
                }
                boolean is_broken = false;
                if (findLines && character_spacing > 0.0f && text.toString().endsWith(" ")) {
                    int counts = this.lineBreaks.size();
                    for (int jj = 0; jj < counts; ++jj) {
                        int test_x = this.lineBreaks.elementAt(jj);
                        if (!(last_pt < (float)test_x & pt > (float)test_x)) continue;
                        jj = counts;
                        is_broken = true;
                    }
                }
                boolean endsWithPunctuation = PdfGroupingAlgorithms.checkForPunctuation(textValue, punctuation);
                if (is_broken) {
                    float Nx1 = x1;
                    float Nx2 = x2;
                    float Ny1 = y1;
                    float Ny2 = y2;
                    if (mode == 0) {
                        Nx2 = last_pt + Float.parseFloat(char_width);
                    } else if (mode == 1) {
                        Nx1 = last_pt + Float.parseFloat(char_width);
                    } else if (mode == 3) {
                        Ny1 = last_pt + Float.parseFloat(char_width);
                    } else if (mode == 2) {
                        Ny2 = last_pt + Float.parseFloat(char_width);
                    }
                    this.addFragment(moveType, i, text, Nx1, Nx2, Ny1, Ny2, text_length, keepFont, currentColor, isWordlist);
                    text = new StringBuilder(Fonts.getActiveFontTag(text.toString(), raw));
                    text.append(value);
                    if (mode == 0) {
                        x1 = pt;
                        continue;
                    }
                    if (mode == 1) {
                        x2 = pt;
                        continue;
                    }
                    if (mode == 3) {
                        y2 = pt;
                        continue;
                    }
                    if (mode != 2) continue;
                    y1 = pt;
                    continue;
                }
                if (endsWithPunctuation | (breakOnSpace && (textValue.indexOf(32) != -1 || value.endsWith(" "))) | textValue.contains("   ")) {
                    int ptr;
                    if (textValue.length() > 1 && textValue.indexOf(32) != -1 && (ptr = textValue.indexOf(32)) > 0) {
                        pt += (float)ptr * (Float.parseFloat(char_width) / (float)textValue.length());
                    }
                    if (!endsWithPunctuation) {
                        text.append(value.trim());
                    }
                    if (mode == 0) {
                        this.addFragment(moveType, i, text, x1, pt, y1, y2, text_length, keepFont, currentColor, isWordlist);
                    } else if (mode == 1) {
                        this.addFragment(moveType, i, text, pt, x2, y1, y2, text_length, keepFont, currentColor, isWordlist);
                    } else if (mode == 3) {
                        this.addFragment(moveType, i, text, x1, x2, pt, y2, text_length, keepFont, currentColor, isWordlist);
                    } else if (mode == 2) {
                        this.addFragment(moveType, i, text, x1, x2, y1, pt, text_length, keepFont, currentColor, isWordlist);
                    }
                    if (char_width.length() > 0) {
                        ptr = 0;
                        if (textValue.indexOf(32) != -1) {
                            ptr = textValue.indexOf(32);
                        }
                        if (isWordlist) {
                            int len = textValue.length();
                            while (ptr < len && textValue.charAt(ptr) == ' ') {
                                ++ptr;
                            }
                        }
                        pt = ptr > 0 ? (pt += (float)ptr * Float.parseFloat(char_width)) : (pt += Float.parseFloat(char_width));
                        breakPointset = ptr > 0;
                    }
                    if (breakOnSpace & this.nextSlot > 0) {
                        this.hadSpace[this.nextSlot - 1] = true;
                    }
                    text = new StringBuilder(Fonts.getActiveFontTag(text.toString(), raw));
                    if (mode == 0) {
                        x1 = pt;
                        continue;
                    }
                    if (mode == 1) {
                        x2 = pt;
                        continue;
                    }
                    if (mode == 3) {
                        y2 = pt;
                        continue;
                    }
                    if (mode != 2) continue;
                    y1 = pt;
                    continue;
                }
                if (linePos != -1.0f & pt > linePos) {
                    if (mode == 0) {
                        this.addFragment(moveType, i, text, x1, linePos, y1, y2, text_length, keepFont, currentColor, isWordlist);
                    } else if (mode == 1) {
                        this.addFragment(moveType, i, text, linePos, x2, y1, y2, text_length, keepFont, currentColor, isWordlist);
                    } else if (mode == 3) {
                        this.addFragment(moveType, i, text, x1, x2, linePos, y2, text_length, keepFont, currentColor, isWordlist);
                    } else if (mode == 2) {
                        this.addFragment(moveType, i, text, x1, x2, y1, linePos, text_length, keepFont, currentColor, isWordlist);
                    }
                    text = new StringBuilder(Fonts.getActiveFontTag(text.toString(), raw));
                    text.append(value);
                    if (mode == 0) {
                        x1 = linePos;
                    } else if (mode == 1) {
                        x2 = linePos;
                    } else if (mode == 3) {
                        y2 = linePos;
                    } else if (mode == 2) {
                        y1 = linePos;
                    }
                    linePos = -1.0f;
                    continue;
                }
                if (this.isXMLExtraction && value.endsWith(' ' + Fonts.fe)) {
                    value = Fonts.fe;
                    textValue = "";
                    if (mode == 0) {
                        x2 = last_pt;
                    } else if (mode == 1) {
                        x1 = last_pt;
                    } else if (mode == 3) {
                        y1 = last_pt;
                    } else if (mode == 2) {
                        y2 = last_pt;
                    }
                }
                text.append(value);
            }
            if (keepFont && this.isXMLExtraction && !text.toString().endsWith(Fonts.fe) && !text.toString().endsWith("</color>")) {
                text.append(Fonts.fe);
            }
            if (mode == 0 || mode == 1) {
                if (x1 < x2) {
                    this.addFragment(moveType, i, text, x1, x2, y1, y2, text_length, keepFont, currentColor, isWordlist);
                }
            } else if ((mode == 3 || mode == 2) && y1 > y2) {
                this.addFragment(moveType, i, text, x1, x2, y1, y2, text_length, keepFont, currentColor, isWordlist);
            }
            text = new StringBuilder();
        }
        this.isUsed = new boolean[this.nextSlot];
    }

    private static boolean checkForPunctuation(String textValue, String punctuation) {
        if (punctuation == null) {
            return false;
        }
        boolean endsWithPunctuation = false;
        int textLength = textValue.length();
        int ii = textLength - 1;
        if (textLength > 0) {
            char testChar = textValue.charAt(ii);
            boolean inTag = testChar == '>';
            while ((inTag | testChar == ' ') & ii > 0) {
                if (testChar == '<') {
                    inTag = false;
                }
                if ((testChar = textValue.charAt(--ii)) != '>') continue;
                inTag = true;
            }
            if (testChar == ';') {
                endsWithPunctuation = true;
                --ii;
                while (ii > -1) {
                    testChar = textValue.charAt(ii);
                    if (testChar == '&' || testChar == '#') {
                        endsWithPunctuation = false;
                        ii = 0;
                    }
                    if (ii != 0 && testChar != ' ' && Character.isLetterOrDigit(testChar)) {
                        --ii;
                        continue;
                    }
                    break;
                }
            } else if (punctuation.indexOf(testChar) != -1) {
                endsWithPunctuation = true;
            }
        }
        return endsWithPunctuation;
    }

    private void addFragment(int moveType, int index, StringBuilder contentss, float x1, float x2, float y1, float y2, int text_len, boolean keepFontTokens, String currentColorTag, boolean isWordlist) {
        StringBuilder current_text = contentss;
        String str = current_text.toString();
        if (isWordlist) {
            if (str.contains("&#")) {
                current_text = Strip.stripAmpHash(current_text);
            }
            if (this.isXMLExtraction && (str.contains("&lt;") || str.contains("&gt;"))) {
                current_text = Strip.stripXMLArrows(current_text, true);
            } else if (!(this.isXMLExtraction || str.indexOf(60) == -1 && str.indexOf(62) == -1)) {
                current_text = Strip.stripArrows(current_text);
            }
        }
        if (this.getFirstChar(current_text) != -1) {
            if (!keepFontTokens) {
                current_text = Strip.stripXML(current_text, this.isXMLExtraction);
            } else if (this.isXMLExtraction) {
                if (this.pdf_data.isColorExtracted() && !current_text.toString().endsWith("</color>")) {
                    if (!current_text.toString().endsWith(Fonts.fe)) {
                        current_text = current_text.append(Fonts.fe);
                    }
                    current_text = current_text.append("</color>");
                } else if (!this.pdf_data.isColorExtracted() && !current_text.toString().endsWith(Fonts.fe)) {
                    current_text = current_text.append(Fonts.fe);
                }
            }
            int count = this.f_x1.length;
            if (this.nextSlot < count) {
                this.f_x1[this.nextSlot] = x1;
                this.f_colorTag[this.nextSlot] = currentColorTag;
                this.f_x2[this.nextSlot] = x2;
                this.f_y1[this.nextSlot] = y1;
                this.f_y2[this.nextSlot] = y2;
                this.moveType[this.nextSlot] = moveType;
                this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[index];
                this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[index];
                this.textLength[this.nextSlot] = text_len;
                this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[index];
                this.content[this.nextSlot] = current_text;
                ++this.nextSlot;
            } else {
                float[] t_x1 = new float[count += 100];
                String[] t_colorTag = new String[count];
                float[] t_x2 = new float[count];
                float[] t_y1 = new float[count];
                float[] t_y2 = new float[count];
                float[] t_spaceWidth = new float[count];
                StringBuilder[] t_content = new StringBuilder[count];
                int[] t_font_size = new int[count];
                int[] t_text_len = new int[count];
                int[] t_writingMode = new int[count];
                int[] t_moveType = new int[count];
                boolean[] t_isUsed = new boolean[count];
                boolean[] t_hadSpace = new boolean[count];
                for (int i = 0; i < count - 100; ++i) {
                    t_x1[i] = this.f_x1[i];
                    t_colorTag[i] = this.f_colorTag[i];
                    t_x2[i] = this.f_x2[i];
                    t_y1[i] = this.f_y1[i];
                    t_y2[i] = this.f_y2[i];
                    t_hadSpace[i] = this.hadSpace[i];
                    t_spaceWidth[i] = this.spaceWidth[i];
                    t_content[i] = this.content[i];
                    t_font_size[i] = this.fontSize[i];
                    t_writingMode[i] = this.writingMode[i];
                    t_text_len[i] = this.textLength[i];
                    t_isUsed[i] = this.isUsed[i];
                    t_moveType[i] = this.moveType[i];
                }
                this.f_x1 = t_x1;
                this.f_colorTag = t_colorTag;
                this.hadSpace = t_hadSpace;
                this.f_x2 = t_x2;
                this.f_y1 = t_y1;
                this.f_y2 = t_y2;
                this.isUsed = t_isUsed;
                this.fontSize = t_font_size;
                this.writingMode = t_writingMode;
                this.textLength = t_text_len;
                this.spaceWidth = t_spaceWidth;
                this.content = t_content;
                this.moveType = t_moveType;
                this.f_x1[this.nextSlot] = x1;
                this.f_colorTag[this.nextSlot] = currentColorTag;
                this.f_x2[this.nextSlot] = x2;
                this.f_y1[this.nextSlot] = y1;
                this.f_y2[this.nextSlot] = y2;
                this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[index];
                this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[index];
                t_text_len[this.nextSlot] = text_len;
                this.content[this.nextSlot] = current_text;
                this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[index];
                this.moveType[this.nextSlot] = moveType;
                ++this.nextSlot;
            }
        }
    }

    private void mergeTableRows(int border_width) {
        String separator = "</tr>\n<tr>";
        if (!this.isXHTML) {
            separator = "\n";
        }
        this.master = ((Vector_Int)this.lines.elementAt(this.line_order[0])).elementAt(0);
        for (int rr = 1; rr < this.max_rows; ++rr) {
            int item = ((Vector_Int)this.lines.elementAt(this.line_order[rr])).elementAt(0);
            if (this.content[this.master] == null) {
                this.master = item;
                continue;
            }
            if (this.content[item] == null) continue;
            this.merge(this.master, item, separator, false);
        }
        if (this.isXHTML) {
            if (border_width == 0) {
                this.content[this.master].insert(0, "<TABLE>\n<tr>");
                this.content[this.master].append("</tr>\n</TABLE>\n");
            } else {
                StringBuilder startTag = new StringBuilder("<TABLE border='");
                startTag.append(String.valueOf(border_width));
                startTag.append("'>\n<tr>");
                startTag.append((CharSequence)this.content[this.master]);
                this.content[this.master] = startTag;
                this.content[this.master].append("</tr>\n</TABLE>\n");
            }
        }
    }

    private final int[] getsortedUnusedFragments(boolean sortOnX, boolean use_y1) {
        int total_fragments = this.isUsed.length;
        int ii = 0;
        int[] sorted_temp_index = new int[total_fragments];
        for (int i = 0; i < total_fragments; ++i) {
            if (this.isUsed[i]) continue;
            sorted_temp_index[ii] = i;
            ++ii;
        }
        int[] unsorted_items = new int[ii];
        int[] sorted_temp_x1 = new int[ii];
        int[] sorted_temp_y1 = new int[ii];
        int[] sorted_temp_y2 = new int[ii];
        for (int pointer = 0; pointer < ii; ++pointer) {
            int i;
            unsorted_items[pointer] = i = sorted_temp_index[pointer];
            sorted_temp_x1[pointer] = (int)this.f_x1[i];
            sorted_temp_y1[pointer] = (int)this.f_y1[i];
            sorted_temp_y2[pointer] = (int)this.f_y2[i];
        }
        int[] sorted_items = !sortOnX ? (use_y1 ? Sorts.quicksort(sorted_temp_y1, sorted_temp_x1, unsorted_items) : Sorts.quicksort(sorted_temp_y2, sorted_temp_x1, unsorted_items)) : Sorts.quicksort(sorted_temp_x1, sorted_temp_y1, unsorted_items);
        return sorted_items;
    }

    private void createTableRows(boolean keep_alignment_information, boolean keep_width_information, int currentWritingMode) throws PdfException {
        int item;
        boolean all_done;
        int i;
        float[] f_x2;
        float[] f_x1;
        if (currentWritingMode == 0) {
            f_x1 = this.f_x1;
            f_x2 = this.f_x2;
        } else if (currentWritingMode == 1) {
            f_x2 = this.f_x1;
            f_x1 = this.f_x2;
        } else if (currentWritingMode == 3) {
            f_x1 = this.f_y2;
            f_x2 = this.f_y1;
        } else if (currentWritingMode == 2) {
            f_x1 = this.f_y1;
            f_x2 = this.f_y2;
            int maxX = 0;
            for (float aF_x1 : f_x1) {
                if (!((float)maxX < aF_x1)) continue;
                maxX = (int)aF_x1;
            }
            ++maxX;
            for (int ii = 0; ii < f_x2.length; ++ii) {
                f_x1[ii] = (float)maxX - f_x1[ii];
                f_x2[ii] = (float)maxX - f_x2[ii];
            }
        } else {
            throw new PdfException("Illegal value " + currentWritingMode + "for currentWritingMode");
        }
        int itemsInTable = 0;
        int items_added = 0;
        int[] currentItem = new int[this.max_rows];
        Vector_Int[] rowContents = new Vector_Int[this.max_rows];
        Vector_String alignments = new Vector_String();
        Vector_Float widths = new Vector_Float();
        Vector_Float cell_x1 = new Vector_Float();
        String separator = "";
        String empty_cell = "&nbsp;";
        if (!this.isXHTML) {
            separator = "\",\"";
            empty_cell = "";
        }
        int[] itemCount = new int[this.max_rows];
        for (i = 0; i < this.max_rows; ++i) {
            itemCount[i] = ((Vector_Int)this.lines.elementAt(i)).size() - 1;
            itemsInTable += itemCount[i];
            currentItem[i] = 0;
            rowContents[i] = new Vector_Int(20);
        }
        do {
            float c_x2;
            float c_x1;
            float current_x1;
            float x1 = 9999.0f;
            float min_x2 = 9999.0f;
            float next_x1 = 9999.0f;
            float items_in_column = 0.0f;
            all_done = true;
            float total_x1 = 0.0f;
            float total_x2 = 0.0f;
            float left_gap = 0.0f;
            String alignment = "center";
            if (items_added >= itemsInTable) continue;
            for (i = 0; i < this.max_rows; ++i) {
                if (itemCount[i] <= currentItem[i]) continue;
                item = ((Vector_Int)this.lines.elementAt(i)).elementAt(currentItem[i]);
                current_x1 = f_x1[item];
                float current_x2 = f_x2[item];
                if (current_x1 < x1) {
                    x1 = current_x1;
                }
                if (!(current_x2 < min_x2)) continue;
                min_x2 = current_x2;
            }
            cell_x1.addElement(x1);
            float x2 = min_x2;
            for (i = 0; i < this.max_rows; ++i) {
                item = ((Vector_Int)this.lines.elementAt(i)).elementAt(currentItem[i]);
                c_x1 = f_x1[item];
                if (c_x1 >= x1 & c_x1 < min_x2 & (c_x2 = f_x2[item]) > x2) {
                    x2 = c_x2;
                }
                if (currentItem[i] >= itemCount[i] || !((current_x1 = f_x1[item = ((Vector_Int)this.lines.elementAt(i)).elementAt(currentItem[i] + 1)]) > min_x2 & current_x1 < next_x1)) continue;
                next_x1 = current_x1;
            }
            if (x1 != x2) {
                if (next_x1 == 9999.0f) {
                    next_x1 = x2;
                }
                for (i = 0; i < this.max_rows; ++i) {
                    item = ((Vector_Int)this.lines.elementAt(i)).elementAt(currentItem[i]);
                    c_x1 = f_x1[item];
                    if (!(c_x1 >= x1 & c_x1 < min_x2 & (c_x2 = f_x2[item]) <= next_x1)) continue;
                    total_x1 += c_x1;
                    total_x2 += c_x2;
                    items_in_column += 1.0f;
                }
                if (i == 0) {
                    left_gap = x1;
                }
                float right_gap = next_x1 == -1.0f ? 0.0f : (float)((int)((next_x1 - x2) / 2.0f));
                int width = (int)(x2 - x1 + right_gap + left_gap);
                left_gap = right_gap;
                widths.addElement(width);
                float x1_diff = total_x1 / items_in_column - x1;
                float x2_diff = x2 - total_x2 / items_in_column;
                if (x1_diff < 1.0f) {
                    alignment = "left";
                } else if (x2_diff < 1.0f) {
                    alignment = "right";
                }
                alignments.addElement(alignment);
                for (i = 0; i < this.max_rows; ++i) {
                    this.master = ((Vector_Int)this.lines.elementAt(i)).elementAt(0);
                    if (itemCount[i] > currentItem[i]) {
                        item = ((Vector_Int)this.lines.elementAt(i)).elementAt(currentItem[i]);
                        c_x1 = f_x1[item];
                        c_x2 = f_x2[item];
                        all_done = false;
                    } else {
                        item = -1;
                        c_x1 = -1.0f;
                        c_x2 = -1.0f;
                    }
                    if (item == -1 & items_added <= itemsInTable) {
                        rowContents[i].addElement(-1);
                        continue;
                    }
                    if (c_x1 >= x1 & c_x1 < x2) {
                        rowContents[i].addElement(item);
                        int n = i;
                        currentItem[n] = currentItem[n] + 1;
                        ++items_added;
                        continue;
                    }
                    if (!(c_x1 > x2)) continue;
                    rowContents[i].addElement(-1);
                }
            }
            break;
        } while (!all_done);
        for (int row = 0; row < this.max_rows; ++row) {
            StringBuilder line_content = new StringBuilder(100);
            int count = rowContents[row].size() - 1;
            this.master = ((Vector_Int)this.lines.elementAt(row)).elementAt(0);
            for (i = 0; i < count; ++i) {
                item = rowContents[row].elementAt(i);
                if (this.isXHTML) {
                    float current_width = widths.elementAt(i);
                    String current_alignment = alignments.elementAt(i);
                    int colspan = 1;
                    int pointer = i + 1;
                    if (item != -1) {
                        int test;
                        while (!((test = rowContents[row].elementAt(i + 1)) != -1 | count == i + 1) && !(itemCount[row] > 1 & cell_x1.elementAt(i + 1) > f_x2[item])) {
                            --count;
                            rowContents[row].removeElementAt(i + 1);
                            ++colspan;
                            current_width += widths.elementAt(pointer);
                            ++pointer;
                        }
                    }
                    line_content.append("<td");
                    if (keep_alignment_information) {
                        line_content.append(" align='");
                        line_content.append(current_alignment);
                        line_content.append('\'');
                        if (colspan > 1) {
                            line_content.append(" colspan='").append(colspan).append('\'');
                        }
                    }
                    if (keep_width_information) {
                        line_content.append(" width='").append((int)current_width).append('\'');
                    }
                    line_content.append(" nowrap>");
                    if (item == -1) {
                        line_content.append(empty_cell);
                    } else {
                        line_content.append((CharSequence)this.content[item]);
                    }
                    line_content.append("</td>");
                } else if (item == -1) {
                    line_content.append("\"\",");
                } else {
                    line_content.append('\"');
                    line_content.append((CharSequence)this.content[item]);
                    line_content.append("\",");
                }
                if (item == -1 || this.master == item) continue;
                this.merge(this.master, item, separator, false);
            }
            this.content[this.master] = line_content;
        }
    }

    private void createLinesInTable(int itemCount, int[] items, boolean addSpaceXMLTag, int mode) throws PdfException {
        float[] f_y2;
        float[] f_y1;
        float[] f_x2;
        float[] f_x1;
        if (mode == 1) {
            items = PdfGroupingAlgorithms.reverse(items);
        }
        switch (mode) {
            case 0: {
                f_x1 = this.f_x1;
                f_x2 = this.f_x2;
                f_y1 = this.f_y1;
                f_y2 = this.f_y2;
                break;
            }
            case 1: {
                f_x2 = this.f_x1;
                f_x1 = this.f_x2;
                f_y1 = this.f_y1;
                f_y2 = this.f_y2;
                break;
            }
            case 3: {
                f_x1 = this.f_y1;
                f_x2 = this.f_y2;
                f_y1 = this.f_x2;
                f_y2 = this.f_x1;
                break;
            }
            case 2: {
                f_x1 = this.f_y2;
                f_x2 = this.f_y1;
                f_y2 = this.f_x1;
                f_y1 = this.f_x2;
                items = this.getsortedUnusedFragments(false, true);
                items = PdfGroupingAlgorithms.reverse(items);
                break;
            }
            default: {
                throw new PdfException("Illegal value " + mode + "for currentWritingMode");
            }
        }
        for (int j = 0; j < itemCount; ++j) {
            int c = items[j];
            int id = -1;
            int last = c;
            float smallest_gap = -1.0f;
            if (this.isUsed[c] || this.writingMode[c] != mode) continue;
            Vector_Int current_line = new Vector_Int(20);
            current_line.addElement(c);
            this.lineY2.addElement((int)f_y2[c]);
            while (true) {
                for (int ii = 0; ii < itemCount; ++ii) {
                    float yMidPt;
                    int i = items[ii];
                    if (this.isUsed[i] || i == c || this.writingMode[c] != mode || !(f_x1[i] > f_x1[c] && mode != 2) && (!(f_x1[i] < f_x1[c]) || mode != 2)) continue;
                    float gap = f_x1[i] - f_x2[c];
                    if (mode == 1 || mode == 2) {
                        gap = -gap;
                    }
                    if (gap < 0.0f && gap > -2.0f) {
                        gap = 0.0f;
                    }
                    if (!((yMidPt = (f_y1[i] + f_y2[i]) / 2.0f) < f_y1[c]) || !(yMidPt > f_y2[c]) || !(smallest_gap < 0.0f) && !(gap < smallest_gap)) continue;
                    smallest_gap = gap;
                    id = i;
                }
                if (id == -1) break;
                float t = f_x1[id] - f_x2[last];
                float possSpace = f_x1[id] - f_x2[c];
                float av_char1 = 1.5f * ((f_x2[id] - f_x1[id]) / (float)this.textLength[id]);
                float av_char2 = 1.5f * ((f_x2[last] - f_x1[last]) / (float)this.textLength[last]);
                if (mode == 1 || mode == 2) {
                    possSpace = -possSpace;
                    t = -t;
                    av_char1 = -av_char1;
                    av_char2 = -av_char2;
                }
                if (t < av_char1 && t < av_char2) {
                    this.merge(last, id, this.isGapASpace(id, last, possSpace, addSpaceXMLTag, mode), true);
                } else {
                    current_line.addElement(id);
                    last = id;
                }
                this.isUsed[id] = true;
                id = -1;
                smallest_gap = 1000000.0f;
            }
            this.lines.addElement(current_line);
            ++this.max_rows;
        }
    }

    public final Map extractTextAsTable(int x1, int y1, int x2, int y2, int pageNumber, boolean isCSV, boolean keepFontInfo, boolean keepWidthInfo, boolean keepAlignmentInfo, int borderWidth) throws PdfException {
        int[] v = PdfGroupingAlgorithms.validateCoordinates(x1, y1, x2, y2);
        x1 = v[0];
        y1 = v[1];
        x2 = v[2];
        y2 = v[3];
        HashMap<String, String> table_content = new HashMap<String, String>();
        LogWriter.writeLog("extracting Text As Table");
        this.isXHTML = !isCSV;
        this.lines = new Vector_Object(20);
        this.lineY2 = new Vector_Int(20);
        this.max_rows = 0;
        this.copyToArrays(x1, y2, x2, y1, keepFontInfo, false, true, null, false);
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] items = this.getsortedUnusedFragments(true, false);
        int item_count = items.length;
        if (item_count == 0) {
            return table_content;
        }
        int writingMode = this.getWritingMode(items, item_count);
        String message = "Table Merging algorithm being applied " + item_count + " items";
        LogWriter.writeLog(message);
        if (item_count > 1) {
            this.createLinesInTable(item_count, items, this.isXHTML, writingMode);
            int dx = 1;
            if (writingMode == 0 || writingMode == 2) {
                dx = -1;
            }
            this.line_order = new int[this.max_rows];
            int[] line_y = new int[this.max_rows];
            for (int i = 0; i < this.max_rows; ++i) {
                line_y[i] = dx * this.lineY2.elementAt(i);
                this.line_order[i] = i;
            }
            this.line_order = Sorts.quicksort(line_y, this.line_order);
            this.createTableRows(keepAlignmentInfo, keepWidthInfo, writingMode);
            this.mergeTableRows(borderWidth);
        }
        this.content[this.master] = this.cleanup(this.content[this.master]);
        String processed_value = this.content[this.master].toString();
        if (processed_value != null) {
            if (!isCSV) {
                processed_value = Fonts.cleanupTokens(processed_value);
            }
            table_content.put("content", processed_value);
            table_content.put("x1", String.valueOf(x1));
            table_content.put("x2", String.valueOf(x2));
            table_content.put("y1", String.valueOf(y1));
            table_content.put("y2", String.valueOf(y2));
        }
        return table_content;
    }

    private static int[] validateCoordinates(int x1, int y1, int x2, int y2) {
        if (x1 > x2 | y1 < y2) {
            int temp;
            if (x1 > x2) {
                temp = x1;
                x1 = x2;
                x2 = temp;
                LogWriter.writeLog("x1 > x2, coordinates were swapped to validate");
            }
            if (y1 < y2) {
                temp = y1;
                y1 = y2;
                y2 = temp;
                LogWriter.writeLog("y1 < y2, coordinates were swapped to validate");
            }
        }
        return new int[]{x1, y1, x2, y2};
    }

    public final List extractTextAsWordlist(int x1, int y1, int x2, int y2, int page_number, boolean breakFragments, String punctuation) throws PdfException {
        int[] v = PdfGroupingAlgorithms.validateCoordinates(x1, y1, x2, y2);
        x1 = v[0];
        y1 = v[1];
        x2 = v[2];
        y2 = v[3];
        if (breakFragments) {
            this.copyToArrays(x1, y2, x2, y1, true, true, false, punctuation, true);
        } else {
            this.copyToArrays();
        }
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(true);
        int[] items = this.getsortedUnusedFragments(true, false);
        int count = items.length;
        if (count == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int writingMode = this.getWritingMode(items, count);
        this.createLines(count, items, writingMode, true, false, false);
        float[] f_x1 = null;
        float[] f_x2 = null;
        float[] f_y1 = null;
        float[] f_y2 = null;
        if (useUnrotatedCoords || writingMode == 0) {
            f_x1 = this.f_x1;
            f_x2 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (writingMode == 1) {
            f_x2 = this.f_x1;
            f_x1 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (writingMode == 3) {
            f_x1 = this.f_y2;
            f_x2 = this.f_y1;
            f_y1 = this.f_x2;
            f_y2 = this.f_x1;
        } else if (writingMode == 2) {
            f_x1 = this.f_y1;
            f_x2 = this.f_y2;
            f_y2 = this.f_x1;
            f_y1 = this.f_x2;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null) continue;
            if (this.colorExtracted && this.isXMLExtraction) {
                if (!this.content[i].toString().toLowerCase().startsWith("<color ")) {
                    this.content[i].insert(0, this.f_colorTag[this.master]);
                }
                if (!this.content[i].toString().toLowerCase().endsWith("</color>")) {
                    this.content[i].append("</color>");
                }
            }
            if (this.isXMLExtraction) {
                values.add(this.content[i].toString());
            } else {
                values.add(Strip.convertToText(this.content[i].toString(), this.isXMLExtraction));
            }
            if (!useUnrotatedCoords && writingMode == 2) {
                values.add(String.valueOf(f_x1[i]));
                values.add(String.valueOf(f_y1[i]));
                values.add(String.valueOf(f_x2[i]));
                values.add(String.valueOf(f_y2[i]));
                continue;
            }
            if (!useUnrotatedCoords && writingMode == 3) {
                values.add(String.valueOf(f_x1[i]));
                values.add(String.valueOf(f_y2[i]));
                values.add(String.valueOf(f_x2[i]));
                values.add(String.valueOf(f_y1[i]));
                continue;
            }
            values.add(String.valueOf(f_x1[i]));
            values.add(String.valueOf(f_y1[i]));
            values.add(String.valueOf(f_x2[i]));
            values.add(String.valueOf(f_y2[i]));
        }
        LogWriter.writeLog("Text extraction as wordlist completed");
        return values;
    }

    private void reset() {
        this.isXHTML = true;
        this.nextSlot = 0;
        this.lineBreaks = new Vector_Int();
        this.max_rows = 0;
        this.master = 0;
        this.colorExtracted = false;
    }

    public final String extractTextInRectangle(int x1, int y1, int x2, int y2, int page_number, boolean estimateParagraphs, boolean breakFragments) throws PdfException {
        this.reset();
        if (breakFragments && !this.pdf_data.IsEmbedded()) {
            throw new PdfException("[PDF] Request to breakfragments and width not added. Please add call to init(true) of PdfDecoder to your code.");
        }
        int[] v = PdfGroupingAlgorithms.validateCoordinates(x1, y1, x2, y2);
        x1 = v[0];
        y1 = v[1];
        x2 = v[2];
        y2 = v[3];
        if (breakFragments) {
            this.copyToArrays(x1, y2, x2, y1, this.isXMLExtraction, false, false, null, false);
        } else {
            this.copyToArrays();
        }
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] items = this.getsortedUnusedFragments(true, false);
        int count = items.length;
        if (count == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int writingMode = this.getWritingMode(items, count);
        this.createLines(count, items, writingMode, false, this.isXMLExtraction, false);
        int master = this.mergeLinesTogether(writingMode, estimateParagraphs, x1, x2, y1, y2);
        if (this.isXMLExtraction) {
            this.content[master] = new StringBuilder(Fonts.cleanupTokens(this.content[master].toString()));
            this.content[master].insert(0, "<p>");
            this.content[master].append("</p>");
        }
        LogWriter.writeLog("Text extraction completed");
        return this.cleanup(this.content[master]).toString();
    }

    private StringBuilder cleanup(StringBuilder buffer) {
        if (buffer == null) {
            return buffer;
        }
        if (this.isXMLExtraction) {
            String buf = buffer.toString();
            buf = buf.replaceAll("&#", "XX#");
            buf = buf.replaceAll("&lt", "XXlt");
            buf = buf.replaceAll("&gt", "XXgt");
            buf = buf.replaceAll("&", "&amp;");
            buf = buf.replaceAll("XX#", "&#");
            buf = buf.replaceAll("XXlt", "&lt");
            buf = buf.replaceAll("XXgt", "&gt");
            boolean removeInvalidXMLValues = true;
            if (removeInvalidXMLValues) {
                int i;
                HashMap<String, String> asciiMappings = new HashMap<String, String>();
                for (i = 1; i <= 8; ++i) {
                    asciiMappings.put("&#" + i + ';', "");
                }
                for (i = 11; i <= 12; ++i) {
                    asciiMappings.put("&#" + i + ';', "");
                }
                for (i = 14; i <= 31; ++i) {
                    asciiMappings.put("&#" + i + ';', "");
                }
                for (Object o : asciiMappings.keySet()) {
                    String character = (String)o;
                    String mappedCharacter = (String)asciiMappings.get(character);
                    buf = buf.replace(character, mappedCharacter);
                }
            }
            buffer = new StringBuilder(buf);
        }
        return buffer;
    }

    private int getWritingMode(int[] items, int count) {
        int orientation = this.writingMode[items[0]];
        if (orientation == 0 || orientation == 1) {
            return orientation;
        }
        for (int j = 1; j < count; ++j) {
            int c = items[j];
            if (this.isUsed[c] || this.writingMode[c] != 0 && this.writingMode[c] != 1) continue;
            orientation = this.writingMode[c];
            j = count;
            LogWriter.writeLog("Text of multiple orientations found. Only horizontal text used.");
        }
        return orientation;
    }

    private int mergeLinesTogether(int currentWritingMode, boolean estimateParagraphs, int x1, int x2, int y1, int y2) throws PdfException {
        int middlePage;
        int[] indices;
        float[] f_y2;
        float[] f_y1;
        float[] f_x2;
        float[] f_x1;
        if (currentWritingMode == 0) {
            f_x1 = this.f_x1;
            f_x2 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
            indices = this.getsortedUnusedFragments(false, true);
            middlePage = (x1 + x2) / 2;
        } else if (currentWritingMode == 1) {
            f_x2 = this.f_x1;
            f_x1 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
            indices = this.getsortedUnusedFragments(false, true);
            middlePage = (x1 + x2) / 2;
        } else if (currentWritingMode == 3) {
            f_x1 = this.f_y1;
            f_x2 = this.f_y2;
            f_y1 = this.f_x2;
            f_y2 = this.f_x1;
            indices = this.getsortedUnusedFragments(true, true);
            indices = PdfGroupingAlgorithms.reverse(indices);
            middlePage = (y1 + y2) / 2;
        } else if (currentWritingMode == 2) {
            f_x1 = this.f_y2;
            f_x2 = this.f_y1;
            f_y2 = this.f_x2;
            f_y1 = this.f_x1;
            indices = this.getsortedUnusedFragments(true, true);
            middlePage = (y1 + y2) / 2;
        } else {
            throw new PdfException("Illegal value " + currentWritingMode + "for currentWritingMode");
        }
        int quarter = middlePage / 2;
        int count = indices.length;
        int master = indices[count - 1];
        boolean debug = false;
        for (int i = count - 2; i > -1; --i) {
            int child = indices[i];
            String separator = "";
            int ClastChar = this.getLastChar(this.content[child]);
            if (ClastChar == -1) continue;
            this.addAlignmentFormatting(estimateParagraphs, middlePage, f_x1, f_x2, quarter, child);
            String lineSpace = "</p>" + SystemSeparator + "<p>";
            if (this.isXMLExtraction) {
                lineSpace = SystemSeparator;
            }
            float gap = f_y2[master] - f_y1[child];
            float line_height = f_y1[child] - f_y2[child];
            if (currentWritingMode == 3) {
                gap = -gap;
                line_height = -line_height;
            }
            if (gap > line_height & line_height > 0.0f) {
                while (gap > line_height) {
                    separator = separator + lineSpace;
                    gap -= line_height;
                }
                separator = this.isXMLExtraction ? separator + "</p>" + SystemSeparator + "<p>" : SystemSeparator;
            } else if (estimateParagraphs) {
                int CFirstChar = this.getFirstChar(this.content[child]);
                int MlastChar = this.getLastChar(this.content[master]);
                if ((MlastChar == 46 || MlastChar == 34) && CFirstChar >= 65 && CFirstChar <= 90) {
                    separator = this.isXMLExtraction ? "</p>" + SystemSeparator + "<p>" : SystemSeparator;
                }
            } else if (this.isXMLExtraction) {
                this.content[child].insert(0, "</p>" + SystemSeparator + "<p>");
            } else {
                this.content[master].append(SystemSeparator);
            }
            this.merge(master, child, separator, false);
        }
        return master;
    }

    private int getFirstChar(StringBuilder buffer) {
        int i = -1;
        boolean inTag = false;
        int count = buffer.length();
        int openChar = 32;
        for (int ptr = 0; ptr < count; ++ptr) {
            char nextChar = buffer.charAt(ptr);
            if (!inTag && (nextChar == '<' || this.isXMLExtraction && nextChar == '&')) {
                inTag = true;
                openChar = nextChar;
                if (openChar == 38) {
                    if (ptr + 1 == count) {
                        i = 38;
                        ptr = count;
                    } else {
                        char c = buffer.charAt(ptr + 1);
                        if (c != '#' && c != 'g' && c != 'l') {
                            i = 38;
                            ptr = count;
                        }
                    }
                }
            }
            if (!inTag && nextChar != ' ') {
                i = nextChar;
                ptr = count;
            }
            if (inTag && openChar == 38 && nextChar == ' ') {
                i = openChar;
                ptr = count;
                continue;
            }
            if (!inTag || nextChar != '>' && (!this.isXMLExtraction || openChar != 38 || nextChar != ';')) continue;
            if (nextChar == ';' && openChar == 38 && ptr > 2 & buffer.charAt(ptr - 1) == 't') {
                if (buffer.charAt(ptr - 2) == 'l') {
                    i = 60;
                    ptr = count;
                } else if (buffer.charAt(ptr - 2) == 'g') {
                    i = 62;
                    ptr = count;
                }
            }
            inTag = false;
        }
        return i;
    }

    private int getLastChar(StringBuilder buffer) {
        int i = -1;
        boolean inTag = false;
        int count = buffer.length();
        int size = count--;
        int openChar = 32;
        while (count > -1) {
            char nextChar = buffer.charAt(count);
            if (inTag && openChar == 59 && nextChar == ';') {
                i = 59;
                count = -1;
            }
            if (!inTag && (nextChar == '>' || this.isXMLExtraction && nextChar == ';')) {
                inTag = true;
                int lastTokenStart = buffer.lastIndexOf("</");
                if (lastTokenStart == -1) {
                    inTag = false;
                } else {
                    for (int ptr = lastTokenStart; ptr < count; ++ptr) {
                        char charToTest = buffer.charAt(ptr);
                        if (charToTest != ' ' && charToTest != '>') continue;
                        inTag = false;
                        ptr = count;
                    }
                }
                if (inTag) {
                    openChar = nextChar;
                } else {
                    i = nextChar;
                    count = -1;
                }
            }
            if (!inTag && nextChar != ' ') {
                i = nextChar;
                count = -1;
            }
            if (nextChar == '<' || this.isXMLExtraction && openChar == 59 && nextChar == '&') {
                inTag = false;
                if (nextChar == '&' && count + 3 < size & buffer.charAt(count + 2) == 't' && buffer.charAt(count + 3) == ';') {
                    if (buffer.charAt(count + 1) == 'l') {
                        i = 60;
                        count = -1;
                    } else if (buffer.charAt(count + 1) == 'g') {
                        i = 62;
                        count = -1;
                    }
                }
            }
            if (inTag && openChar == 59 && nextChar == ' ') {
                count = -1;
                i = 59;
            }
            --count;
        }
        return i;
    }

    private static int[] reverse(int[] indices) {
        int count = indices.length;
        int[] newIndex = new int[count];
        for (int i = 0; i < count; ++i) {
            newIndex[i] = indices[count - i - 1];
        }
        return newIndex;
    }

    private void addAlignmentFormatting(boolean estimateParagraphs, int middlePage, float[] f_x1, float[] f_x2, int quarter, int child) {
        float left_gap = (float)middlePage - f_x1[child];
        float right_gap = f_x2[child] - (float)middlePage;
        if (!estimateParagraphs && this.isXMLExtraction && left_gap > 0.0f && right_gap > 0.0f && f_x1[child] > (float)quarter && f_x1[child] < (float)(middlePage + quarter)) {
            float ratio = left_gap / right_gap;
            if (ratio > 1.0f) {
                ratio = 1.0f / ratio;
            }
            if ((double)ratio > 0.95) {
                this.content[child] = new StringBuilder(Fonts.cleanupTokens(this.content[child].toString()));
                this.content[child].insert(0, "<center>");
                this.content[child].append("</center>\n");
            } else if (right_gap < 10.0f & left_gap > 30.0f) {
                this.content[child] = new StringBuilder(Fonts.cleanupTokens(this.content[child].toString()));
                this.content[child].insert(0, "<right>");
                this.content[child].append("</right>\n");
            }
        }
    }

    private void createLines(int count, int[] items, int mode, boolean breakOnSpace, boolean addMultiplespaceXMLTag, boolean sameLineOnly) throws PdfException {
        float[] f_y2;
        float[] f_y1;
        float[] f_x2;
        float[] f_x1;
        boolean debug = false;
        if (mode == 1 || mode == 2) {
            items = PdfGroupingAlgorithms.reverse(items);
        }
        if (mode == 0) {
            f_x1 = this.f_x1;
            f_x2 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (mode == 1) {
            f_x2 = this.f_x1;
            f_x1 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (mode == 3) {
            f_x1 = this.f_y1;
            f_x2 = this.f_y2;
            f_y1 = this.f_x2;
            f_y2 = this.f_x1;
        } else if (mode == 2) {
            f_x1 = this.f_y2;
            f_x2 = this.f_y1;
            f_y2 = this.f_x1;
            f_y1 = this.f_x2;
        } else {
            throw new PdfException("Illegal value " + mode + "for currentWritingMode");
        }
        block0: for (int j = 0; j < count; ++j) {
            int id = -1;
            int c = items[j];
            float smallest_gap = -1.0f;
            if (this.isUsed[c] || this.writingMode[c] != mode) continue;
            while (true) {
                for (int j2 = 0; j2 < count; ++j2) {
                    float yMidPt;
                    int fontSizeChange;
                    int lineGap;
                    int topLineDifference;
                    int i = items[j2];
                    if (this.isUsed[i]) continue;
                    int baseLineDifference = (int)(f_y2[i] - f_y2[c]);
                    if (baseLineDifference < 0) {
                        baseLineDifference = -baseLineDifference;
                    }
                    if ((topLineDifference = (int)(f_y1[i] - f_y1[c])) < 0) {
                        topLineDifference = -topLineDifference;
                    }
                    if ((lineGap = (int)(f_x1[i] - f_x2[c])) > (int)(f_x1[c] - f_x2[i])) {
                        lineGap = (int)(f_x1[c] - f_x2[i]);
                    }
                    if ((fontSizeChange = this.fontSize[c] - this.fontSize[i]) < 0) {
                        fontSizeChange = -fontSizeChange;
                    }
                    if (sameLineOnly && lineGap > this.fontSize[c] && lineGap > 0 || sameLineOnly && baseLineDifference > 1 && lineGap > 2 * this.fontSize[c] && this.fontSize[c] == this.fontSize[i] || sameLineOnly && baseLineDifference > 3 || sameLineOnly && fontSizeChange > 2 || i == c || !(f_x1[i] > f_x1[c] && mode != 2) && (!(f_x1[i] < f_x1[c]) || mode != 2 || this.writingMode[c] != mode || fontSizeChange > 2 && (fontSizeChange <= 2 || topLineDifference >= 3))) continue;
                    float gap = f_x1[i] - f_x2[c];
                    if (mode == 1 || mode == 2) {
                        gap = -gap;
                    }
                    if (gap < 0.0f && gap > -2.0f) {
                        gap = 0.0f;
                    }
                    if (!((yMidPt = (f_y1[i] + f_y2[i]) / 2.0f) < f_y1[c]) || !(yMidPt > f_y2[c]) || !(smallest_gap < 0.0f) && !(gap < smallest_gap)) continue;
                    smallest_gap = gap;
                    id = i;
                }
                if (id == -1) continue block0;
                float possSpace = f_x1[id] - f_x2[c];
                if (mode == 1 || mode == 2) {
                    possSpace = -possSpace;
                } else if (mode == 3) {
                    possSpace = f_x2[id] - f_x1[c];
                }
                String separator = this.isGapASpace(c, id, possSpace, addMultiplespaceXMLTag, mode);
                if (breakOnSpace && this.hadSpace != null && (this.hadSpace[c] || separator.startsWith(" "))) continue block0;
                this.merge(c, id, separator, true);
                id = -1;
                smallest_gap = 1000000.0f;
            }
        }
    }

    public SortedMap findMultipleTermsInRectangleWithMatchingTeasers(int x1, int y1, int x2, int y2, int rotation, int page_number, String[] terms, int searchType, SearchListener listener) throws PdfException {
        this.usingMultipleTerms = true;
        this.multipleTermTeasers.clear();
        this.teasers = null;
        boolean origIncludeTease = this.includeTease;
        this.includeTease = true;
        List highlights = this.findMultipleTermsInRectangle(x1, y1, x2, y2, page_number, terms, searchType, listener);
        TreeMap highlightsWithTeasers = new TreeMap(new ResultsComparator(rotation));
        for (int i = 0; i < highlights.size(); ++i) {
            highlightsWithTeasers.put(highlights.get(i), this.multipleTermTeasers.get(i));
        }
        this.usingMultipleTerms = false;
        this.includeTease = origIncludeTease;
        return highlightsWithTeasers;
    }

    public List findMultipleTermsInRectangle(int x1, int y1, int x2, int y2, int rotation, int page_number, String[] terms, boolean orderResults, int searchType, SearchListener listener) throws PdfException {
        this.usingMultipleTerms = true;
        this.multipleTermTeasers.clear();
        this.teasers = null;
        List highlights = this.findMultipleTermsInRectangle(x1, y1, x2, y2, page_number, terms, searchType, listener);
        if (orderResults) {
            Collections.sort(highlights, new ResultsComparator(rotation));
        }
        this.usingMultipleTerms = false;
        return highlights;
    }

    private List findMultipleTermsInRectangle(int x1, int y1, int x2, int y2, int page_number, String[] terms, int searchType, SearchListener listener) throws PdfException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String term : terms) {
            if (listener != null && listener.isCanceled()) break;
            float[] co_ords = this.findText(new Rectangle(x1, y1, x2, y2), page_number, new String[]{term}, searchType);
            if (co_ords == null) continue;
            int count = co_ords.length;
            for (int ii = 0; ii < count; ii += 5) {
                int wx1 = (int)co_ords[ii];
                int wy1 = (int)co_ords[ii + 1];
                int wx2 = (int)co_ords[ii + 2];
                int wy2 = (int)co_ords[ii + 3];
                Rectangle rectangle = new Rectangle(wx1, wy2, wx2 - wx1, wy1 - wy2);
                int seperator = (int)co_ords[ii + 4];
                if (seperator == this.linkedSearchAreas) {
                    Vector_Rectangle vr = new Vector_Rectangle();
                    vr.addElement(rectangle);
                    while (seperator == this.linkedSearchAreas) {
                        wx1 = (int)co_ords[ii += 5];
                        wy1 = (int)co_ords[ii + 1];
                        wx2 = (int)co_ords[ii + 2];
                        wy2 = (int)co_ords[ii + 3];
                        seperator = (int)co_ords[ii + 4];
                        rectangle = new Rectangle(wx1, wy2, wx2 - wx1, wy1 - wy2);
                        vr.addElement(rectangle);
                    }
                    vr.trim();
                    list.add(vr.get());
                    continue;
                }
                list.add(rectangle);
            }
        }
        return list;
    }

    public final float[] findText(Rectangle searchArea, int page_number, String[] terms, int searchType) throws PdfException {
        if (terms == null) {
            return new float[0];
        }
        boolean firstOccuranceOnly = false;
        boolean wholeWordsOnly = false;
        boolean foundFirst = false;
        boolean useRegEx = false;
        Vector_Float resultCoords = new Vector_Float(0);
        Vector_String resultTeasers = new Vector_String(0);
        this.copyToArrays();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] items = this.getsortedUnusedFragments(true, false);
        int l2r = 0;
        int r2l = 0;
        int t2b = 0;
        int b2t = 0;
        block6: for (int i = 0; i != items.length; ++i) {
            switch (this.writingMode[items[i]]) {
                case 0: {
                    ++l2r;
                    continue block6;
                }
                case 1: {
                    ++r2l;
                    continue block6;
                }
                case 2: {
                    ++t2b;
                    continue block6;
                }
                case 3: {
                    ++b2t;
                }
            }
        }
        int[] unsorted = new int[]{l2r, r2l, t2b, b2t};
        int[] sorted = new int[]{l2r, r2l, t2b, b2t};
        int[] writingModes = new int[]{-1, -1, -1, -1};
        Arrays.sort(sorted);
        for (int i = 0; i != unsorted.length; ++i) {
            for (int j = 0; j < sorted.length; ++j) {
                if (unsorted[i] != sorted[j]) continue;
                int pos = j - 3;
                if (pos < 0) {
                    pos = -pos;
                }
                if (writingModes[pos] != -1) continue;
                writingModes[pos] = i;
                j = sorted.length;
            }
        }
        for (int u = 0; u != writingModes.length; ++u) {
            int writingMode = writingModes[u];
            if (unsorted[writingMode] == 0) continue;
            this.createLines(items.length, items, writingMode, true, false, true);
            int options = 0;
            if ((searchType & 2) != 2) {
                options |= 2;
            }
            if ((searchType & 4) == 4) {
                firstOccuranceOnly = true;
            }
            if ((searchType & 1) == 1) {
                wholeWordsOnly = true;
            }
            if ((searchType & 8) == 8) {
                options = options | 8 | 0x20;
            }
            if ((searchType & 0x20) == 32) {
                useRegEx = true;
            }
            float[] f_y1 = this.f_y1;
            float[] f_y2 = this.f_y2;
            boolean valuesSwapped = false;
            if (writingMode == 0) {
                f_y1 = this.f_y1;
                f_y2 = this.f_y2;
            } else if (writingMode == 1) {
                f_y1 = this.f_y1;
                f_y2 = this.f_y2;
            } else if (writingMode == 3) {
                f_y1 = this.f_x2;
                f_y2 = this.f_x1;
                valuesSwapped = true;
            } else if (writingMode == 2) {
                f_y2 = this.f_x1;
                f_y1 = this.f_x2;
                valuesSwapped = true;
            }
            String plain = "";
            String raw = "";
            for (int i = 0; i != this.content.length; ++i) {
                if (this.content[i] == null || writingMode != this.writingMode[i]) continue;
                raw = raw + this.content[i] + "\n";
                plain = plain + this.content[i] + "\n";
            }
            raw = PdfGroupingAlgorithms.removeDuplicateSpaces(raw);
            plain = PdfGroupingAlgorithms.removeDuplicateSpaces(plain);
            raw = Strip.stripXML(raw, this.isXMLExtraction).toString();
            plain = PdfGroupingAlgorithms.removeHiddenMarkers(plain);
            plain = Strip.stripXML(plain, this.isXMLExtraction).toString();
            String[] searchText = new String[]{plain};
            String[] coordsText = new String[]{raw};
            block11: for (int j = 0; j != terms.length; ++j) {
                String searchValue = terms[j];
                String sep = " ";
                if ((searchType & 8) == 8) {
                    sep = "[ \\\\n]";
                }
                if (!useRegEx) {
                    searchValue = "\\Q" + searchValue + "\\E";
                    sep = "\\\\E" + sep + "\\\\Q";
                }
                if (!sep.equals(" ")) {
                    searchValue = searchValue.replaceAll(" ", sep);
                }
                if (wholeWordsOnly) {
                    searchValue = "\\b" + searchValue + "\\b";
                }
                Pattern searchTerm = Pattern.compile(searchValue, options);
                Pattern teaserTerm = Pattern.compile("(?:\\S+\\s)?\\S*(?:\\S+\\s)?\\S*" + searchValue + "\\S*(?:\\s\\S+)?\\S*(?:\\s\\S+)?", options);
                for (int i = 0; i != searchText.length; ++i) {
                    String plainText = searchText[i];
                    String coordText = coordsText[i];
                    if (plainText == null) continue;
                    Matcher termFinder = searchTerm.matcher(plainText);
                    Matcher teaserFinder = teaserTerm.matcher(plainText);
                    boolean needToFindTeaser = true;
                    while (termFinder.find()) {
                        Point resultStart = null;
                        String foundTerm = termFinder.group();
                        int termStarts = termFinder.start();
                        int termEnds = termFinder.end() - 1;
                        if (this.includeTease) {
                            String teaser = foundTerm;
                            if (this.includeHTMLtags) {
                                teaser = "<b>" + teaser + "</b>";
                            }
                            boolean itemFound = false;
                            if (needToFindTeaser) {
                                itemFound = teaserFinder.find();
                            }
                            if (itemFound) {
                                if (teaserFinder.start() < termStarts && teaserFinder.end() > termEnds) {
                                    teaser = teaserFinder.group();
                                    if (this.includeHTMLtags) {
                                        int teaseStarts = termStarts - teaserFinder.start();
                                        int teaseEnds = termEnds - teaserFinder.start() + 1;
                                        teaser = teaser.substring(0, teaseStarts) + "<b>" + teaser.substring(teaseStarts, teaseEnds) + "</b>" + teaser.substring(teaseEnds, teaser.length());
                                    }
                                    needToFindTeaser = true;
                                } else {
                                    needToFindTeaser = false;
                                }
                            }
                            resultTeasers.addElement(teaser);
                        }
                        int pointInLine = -1;
                        int lineCounter = 0;
                        while (this.content[lineCounter] == null || writingMode != this.writingMode[lineCounter]) {
                            ++lineCounter;
                        }
                        boolean startFound = false;
                        boolean endFound = false;
                        for (int pointer = 1; pointer < coordText.length(); ++pointer) {
                            int startPointer = pointer;
                            while (pointer < coordText.length() && coordText.charAt(pointer) != MARKER2) {
                                ++pointer;
                            }
                            float currentX = Float.parseFloat(coordText.substring(startPointer, pointer));
                            startPointer = ++pointer;
                            while (pointer < coordText.length() && coordText.charAt(pointer) != MARKER2) {
                                ++pointer;
                            }
                            float width = Float.parseFloat(coordText.substring(startPointer, pointer));
                            startPointer = ++pointer;
                            while (pointer < coordText.length() && coordText.charAt(pointer) != MARKER2) {
                                ++pointer;
                            }
                            String text = coordText.substring(startPointer, pointer);
                            if (!startFound && (pointInLine += text.length()) >= termStarts) {
                                resultStart = new Point((int)currentX, (int)f_y1[lineCounter]);
                                startFound = true;
                            }
                            if (!endFound && pointInLine >= termEnds) {
                                if (valuesSwapped) {
                                    if (writingMode == 3) {
                                        resultCoords.addElement((int)f_y2[lineCounter]);
                                        resultCoords.addElement((float)((int)currentX) + width);
                                        resultCoords.addElement(resultStart.y);
                                        resultCoords.addElement(resultStart.x);
                                        resultCoords.addElement(0.0f);
                                    } else {
                                        resultCoords.addElement((int)f_y2[lineCounter]);
                                        resultCoords.addElement(resultStart.x);
                                        resultCoords.addElement(resultStart.y);
                                        resultCoords.addElement((float)((int)currentX) + width);
                                        resultCoords.addElement(0.0f);
                                    }
                                } else {
                                    resultCoords.addElement(resultStart.x);
                                    resultCoords.addElement(resultStart.y);
                                    resultCoords.addElement(currentX + width);
                                    resultCoords.addElement(f_y2[lineCounter]);
                                    resultCoords.addElement(0.0f);
                                }
                                endFound = true;
                            }
                            if (startFound && !endFound && text.contains("\n")) {
                                if (valuesSwapped) {
                                    if (writingMode == 3) {
                                        resultCoords.addElement((int)f_y2[lineCounter]);
                                        resultCoords.addElement((float)((int)currentX) + width);
                                        resultCoords.addElement(resultStart.y);
                                        resultCoords.addElement(resultStart.x);
                                        resultCoords.addElement(this.linkedSearchAreas);
                                    } else {
                                        resultCoords.addElement((int)f_y2[lineCounter]);
                                        resultCoords.addElement(resultStart.x);
                                        resultCoords.addElement(resultStart.y);
                                        resultCoords.addElement((float)((int)currentX) + width);
                                        resultCoords.addElement(this.linkedSearchAreas);
                                    }
                                } else {
                                    resultCoords.addElement(resultStart.x);
                                    resultCoords.addElement(resultStart.y);
                                    resultCoords.addElement(currentX + width);
                                    resultCoords.addElement(f_y2[lineCounter]);
                                    resultCoords.addElement(this.linkedSearchAreas);
                                }
                                startFound = false;
                                termStarts = pointInLine;
                            }
                            if (!text.contains("\n")) continue;
                            ++lineCounter;
                            while (lineCounter < this.content.length && (this.content[lineCounter] == null || writingMode != this.writingMode[lineCounter])) {
                                ++lineCounter;
                            }
                        }
                        if (!firstOccuranceOnly) continue;
                        foundFirst = true;
                        break;
                    }
                    if (firstOccuranceOnly && foundFirst) continue block11;
                }
            }
            resultCoords.trim();
            if (!this.includeTease) continue;
            resultTeasers.trim();
            if (this.usingMultipleTerms) {
                for (int i = 0; i != resultTeasers.size(); ++i) {
                    this.multipleTermTeasers.add(resultTeasers.elementAt(i));
                }
                continue;
            }
            this.teasers = resultTeasers.get();
        }
        return resultCoords.get();
    }

    private static String removeDuplicateSpaces(String textValue) {
        if (textValue.contains("  ")) {
            textValue = textValue.replace("  ", " ");
        }
        return textValue;
    }

    public float[] getEndPoints() {
        return this.endPoints;
    }

    public String[] getTeasers() {
        return this.teasers;
    }

    public void generateTeasers() {
        this.includeTease = true;
    }

    static class ResultsComparator
    implements Comparator {
        private int rotation;

        public ResultsComparator(int rotation) {
            this.rotation = rotation;
        }

        public int compare(Object o1, Object o2) {
            Rectangle[] ra1 = o1 instanceof Rectangle[] ? (Rectangle[])o1 : new Rectangle[]{(Rectangle)o1};
            Rectangle[] ra2 = o2 instanceof Rectangle[] ? (Rectangle[])o2 : new Rectangle[]{(Rectangle)o2};
            for (int i = 0; i != ra1.length; ++i) {
                for (int j = 0; j != ra2.length; ++j) {
                    Rectangle r1 = ra1[i];
                    Rectangle r2 = ra2[j];
                    switch (this.rotation) {
                        case 0: {
                            if (r1.y == r2.y) {
                                if (r1.x > r2.x) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (r1.y > r2.y) {
                                return -1;
                            }
                            return 1;
                        }
                        case 90: {
                            if (r1.x == r2.x) {
                                if (r1.y > r2.y) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (r1.x > r2.x) {
                                return 1;
                            }
                            return -1;
                        }
                        case 180: {
                            if (r1.y == r2.y) {
                                if (r1.x > r2.x) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (r1.y > r2.y) {
                                return -1;
                            }
                            return 1;
                        }
                        case 270: {
                            if (r1.x == r2.x) {
                                if (r1.y > r2.y) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (r1.x < r2.x) {
                                return 1;
                            }
                            return -1;
                        }
                    }
                }
            }
            return -1;
        }
    }
}

