/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jpedal.constants.PDFflags;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.SetSecurity;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.ObjectCloneFactory;

public class DecryptionFactory {
    private Map cachedObjects = new HashMap();
    private boolean extractionIsAllowed = true;
    private boolean isInitialised = false;
    private boolean isMetaDataEncypted = true;
    private boolean isPasswordSupplied = false;
    private boolean stringsEncoded = false;
    private boolean isEncrypted = false;
    private byte[] encryptionKey = null;
    private int rev = 0;
    private int P = 0;
    private byte[] O = null;
    private byte[] U = null;
    private byte[] OE = null;
    private byte[] Perms = null;
    private byte[] UE = null;
    Cipher cipher = null;
    private boolean isAES = false;
    private PdfObject StmFObj;
    private PdfObject StrFObj;
    private static boolean alwaysReinitCipher = false;
    private final String[] pad = new String[]{"28", "BF", "4E", "5E", "4E", "75", "8A", "41", "64", "00", "4E", "56", "FF", "FA", "01", "08", "2E", "2E", "00", "B6", "D0", "68", "3E", "80", "2F", "0C", "A9", "FE", "64", "53", "69", "7A"};
    private boolean isAESIdentity = false;
    private int keyLength = 5;
    private boolean isFileViewable = true;
    private int passwordStatus = 0;
    private byte[] ID = null;
    private byte[] encryptionPassword = null;
    private Certificate certificate;
    private Key key;

    public DecryptionFactory(byte[] ID, byte[] encryptionPassword) {
        this.ID = ID;
        this.encryptionPassword = encryptionPassword;
    }

    public DecryptionFactory(byte[] id, Certificate certificate, PrivateKey key) {
        this.ID = id;
        this.certificate = certificate;
        this.key = key;
    }

    private boolean testPassword() throws PdfSecurityException {
        int count = 32;
        byte[] rawValue = new byte[32];
        for (int i = 0; i < 32; ++i) {
            rawValue[i] = (byte)Integer.parseInt(this.pad[i], 16);
        }
        byte[] encrypted = ObjectCloneFactory.cloneArray(rawValue);
        if (this.rev == 2) {
            this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
            encrypted = this.decrypt(encrypted, "", true, null, false, false);
        } else if (this.rev >= 3) {
            MessageDigest md;
            byte[] originalKey;
            int keyLength;
            block9: {
                int lenKey;
                keyLength = this.keyLength;
                if (this.rev == 4 && this.StmFObj != null && (lenKey = this.StmFObj.getInt(1043816557)) != -1) {
                    keyLength = lenKey;
                }
                count = 16;
                this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
                originalKey = ObjectCloneFactory.cloneArray(this.encryptionKey);
                md = null;
                try {
                    md = MessageDigest.getInstance("MD5");
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block9;
                    LogWriter.writeLog("Exception " + e + " with digest");
                }
            }
            md.update(encrypted);
            byte[] keyValue = md.digest(this.ID);
            keyValue = this.decrypt(keyValue, "", true, null, true, false);
            byte[] nextKey = new byte[keyLength];
            for (int i = 1; i <= 19; ++i) {
                for (int j = 0; j < keyLength; ++j) {
                    nextKey[j] = (byte)(originalKey[j] ^ i);
                }
                this.encryptionKey = nextKey;
                keyValue = this.decrypt(keyValue, "", true, null, true, false);
            }
            this.encryptionKey = originalKey;
            encrypted = new byte[32];
            System.arraycopy(keyValue, 0, encrypted, 0, 16);
            System.arraycopy(rawValue, 0, encrypted, 16, 16);
        }
        return DecryptionFactory.compareKeys(this.U, encrypted, count);
    }

    private static boolean compareKeys(byte[] U, byte[] encrypted, int count) {
        boolean match = true;
        for (int i = 0; i < count; ++i) {
            if (U[i] == encrypted[i]) continue;
            match = false;
            i = U.length;
        }
        return match;
    }

    private void computeEncryptionKey() throws PdfSecurityException {
        byte[] key = this.getPaddedKey(this.encryptionPassword);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            this.encryptionKey = md.digest(key);
            if (this.rev >= 3) {
                for (int ii = 0; ii < 50; ++ii) {
                    this.encryptionKey = md.digest(this.encryptionKey);
                }
            }
        }
        catch (Exception e) {
            throw new PdfSecurityException("Exception " + e + " generating encryption key");
        }
    }

    private boolean testOwnerPassword() throws PdfSecurityException {
        byte[] originalPassword = this.encryptionPassword;
        byte[] userPasswd = new byte[this.keyLength];
        byte[] inputValue = ObjectCloneFactory.cloneArray(this.O);
        this.computeEncryptionKey();
        byte[] originalKey = ObjectCloneFactory.cloneArray(this.encryptionKey);
        if (this.rev == 2) {
            userPasswd = this.decrypt(ObjectCloneFactory.cloneArray(this.O), "", false, null, false, false);
        } else if (this.rev >= 3) {
            int lenKey;
            int keyLength = this.keyLength;
            if (this.rev == 4 && this.StmFObj != null && (lenKey = this.StmFObj.getInt(1043816557)) != -1) {
                keyLength = lenKey;
            }
            userPasswd = inputValue;
            byte[] nextKey = new byte[keyLength];
            for (int i = 19; i >= 0; --i) {
                for (int j = 0; j < keyLength; ++j) {
                    nextKey[j] = (byte)(originalKey[j] ^ i);
                }
                this.encryptionKey = nextKey;
                userPasswd = this.decrypt(userPasswd, "", false, null, true, false);
            }
        }
        this.encryptionPassword = userPasswd;
        this.computeEncryptionKey();
        boolean isMatch = this.testPassword();
        if (!isMatch) {
            this.encryptionPassword = originalPassword;
            this.computeEncryptionKey();
        }
        return isMatch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyAccess() throws PdfSecurityException {
        boolean isUserPassword;
        boolean isOwnerPassword;
        block13: {
            this.isPasswordSupplied = false;
            this.extractionIsAllowed = false;
            this.passwordStatus = 0;
            isOwnerPassword = false;
            isUserPassword = false;
            if (this.rev < 5) {
                isOwnerPassword = this.testOwnerPassword();
                isUserPassword = this.testPassword();
            } else {
                try {
                    isOwnerPassword = DecryptionFactory.compareKeys(this.O, this.getV5Key(true, 32), 32);
                    if (isOwnerPassword) {
                        this.encryptionKey = DecryptionFactory.v5Decrypt(this.OE, this.getV5Key(true, 32));
                    } else {
                        isUserPassword = DecryptionFactory.compareKeys(this.U, this.getV5Key(false, 32), 32);
                        if (isUserPassword) {
                            this.encryptionKey = DecryptionFactory.v5Decrypt(this.UE, this.getV5Key(false, 40));
                        }
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    if (!LogWriter.isOutput()) break block13;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        if (isOwnerPassword) {
            this.passwordStatus = 2;
        }
        if (isUserPassword) {
            ++this.passwordStatus;
        }
        if (!isOwnerPassword) {
            if (!isUserPassword) throw new PdfSecurityException("No valid password supplied");
            if (this.encryptionPassword != null && this.encryptionPassword.length > 0 && LogWriter.isOutput()) {
                LogWriter.writeLog("Correct user password supplied ");
            }
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            if ((this.P & 0x10) != 16) return;
            this.extractionIsAllowed = true;
            return;
        } else {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Correct owner password supplied");
            }
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            this.extractionIsAllowed = true;
        }
    }

    private static byte[] v5Decrypt(byte[] rawValue, byte[] key) throws PdfSecurityException {
        int ELength = rawValue.length;
        byte[] returnKey = new byte[ELength];
        try {
            int nextBlockSize;
            CBCBlockCipher cbc = new CBCBlockCipher(new AESFastEngine());
            cbc.init(false, new KeyParameter(key));
            for (int i = 0; i < ELength; i += nextBlockSize) {
                cbc.processBlock(rawValue, i, returnKey, i);
                nextBlockSize = cbc.getBlockSize();
            }
        }
        catch (Exception e) {
            throw new PdfSecurityException("Exception " + e.getMessage() + " with v5 encoding");
        }
        return returnKey;
    }

    private byte[] getV5Key(boolean isOwner, int offset) throws NoSuchAlgorithmException {
        int passwordLength;
        byte[] password = this.encryptionPassword;
        if (password == null) {
            password = new byte[]{};
        }
        if ((passwordLength = password.length) > 127) {
            passwordLength = 127;
        }
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(password, 0, passwordLength);
        if (isOwner) {
            md.update(this.O, offset, 8);
            md.update(this.U, 0, 48);
        } else {
            md.update(this.U, offset, 8);
        }
        return md.digest();
    }

    private byte[] getPaddedKey(byte[] password) {
        byte[] key = new byte[32];
        int passwordLength = 0;
        if (password != null && (passwordLength = password.length) > 32) {
            passwordLength = 32;
        }
        if (this.encryptionPassword != null) {
            System.arraycopy(this.encryptionPassword, 0, key, 0, passwordLength);
        }
        for (int ii = passwordLength; ii < 32; ++ii) {
            key[ii] = (byte)Integer.parseInt(this.pad[ii - passwordLength], 16);
        }
        return key;
    }

    private byte[] calculateKey(byte[] O, int P, byte[] ID) throws PdfSecurityException {
        byte[] keyValue;
        byte[] key = this.getPaddedKey(this.encryptionPassword);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(key);
            md.update(O);
            md.update(new byte[]{(byte)(P & 0xFF), (byte)(P >> 8 & 0xFF), (byte)(P >> 16 & 0xFF), (byte)(P >> 24 & 0xFF)});
            if (ID != null) {
                md.update(ID);
            }
            if (this.rev == 4 && !this.isMetaDataEncypted) {
                md.update(new byte[]{-1, -1, -1, -1});
            }
            byte[] digest = new byte[this.keyLength];
            System.arraycopy(md.digest(), 0, digest, 0, this.keyLength);
            if (this.rev >= 3) {
                for (int i = 0; i < 50; ++i) {
                    System.arraycopy(md.digest(digest), 0, digest, 0, this.keyLength);
                }
            }
            keyValue = new byte[this.keyLength];
            System.arraycopy(digest, 0, keyValue, 0, this.keyLength);
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            throw new PdfSecurityException("Exception " + e + " generating encryption key");
        }
        byte[] returnKey = new byte[this.keyLength];
        System.arraycopy(keyValue, 0, returnKey, 0, this.keyLength);
        return returnKey;
    }

    public void readEncryptionObject(PdfObject encyptionObj) throws PdfSecurityException {
        this.stringsEncoded = false;
        this.isMetaDataEncypted = true;
        this.StmFObj = null;
        this.StrFObj = null;
        this.isAES = false;
        if (!this.isInitialised) {
            this.isInitialised = true;
            SetSecurity.init();
        }
        int v = encyptionObj.getInt(38);
        PdfArrayIterator filters = encyptionObj.getMixedArray(1011108731);
        int firstValue = 1467315058;
        if (filters != null && filters.hasMoreTokens()) {
            firstValue = filters.getNextValueAsConstant(false);
        }
        if (v == 3) {
            throw new PdfSecurityException("Unsupported Custom Adobe Encryption method");
        }
        if (v > 4 && firstValue != 1467315058) {
            throw new PdfSecurityException("Unsupported Encryption method");
        }
        int newLength = encyptionObj.getInt(1043816557) >> 3;
        if (newLength != -1) {
            this.keyLength = newLength;
        }
        this.rev = encyptionObj.getInt(34);
        this.P = encyptionObj.getInt(32);
        this.O = encyptionObj.getTextStreamValueAsByte(31);
        this.U = encyptionObj.getTextStreamValueAsByte(37);
        this.OE = encyptionObj.getTextStreamValueAsByte(7957);
        this.UE = encyptionObj.getTextStreamValueAsByte(9493);
        this.Perms = encyptionObj.getTextStreamValueAsByte(893533539);
        if (v >= 4) {
            String CFkey;
            PdfKeyPairsIterator keyPairs;
            this.isAES = true;
            PdfObject CF = encyptionObj.getDictionary(4886);
            if (v == 4) {
                this.isMetaDataEncypted = encyptionObj.getBoolean(-1815804199);
            }
            this.isAESIdentity = false;
            String key = encyptionObj.getName(591675926);
            if (key != null) {
                this.isAESIdentity = key.equals("Identity");
                this.stringsEncoded = true;
                keyPairs = CF.getKeyPairsIterator();
                while (keyPairs.hasMorePairs()) {
                    CFkey = keyPairs.getNextKeyAsString();
                    if (CFkey.equals(key)) {
                        this.StrFObj = keyPairs.getNextValueAsDictionary();
                    }
                    keyPairs.nextPair();
                }
            }
            if ((key = encyptionObj.getName(591674646)) != null) {
                this.isAESIdentity = key.equals("Identity");
                keyPairs = CF.getKeyPairsIterator();
                while (keyPairs.hasMorePairs()) {
                    CFkey = keyPairs.getNextKeyAsString();
                    if (CFkey.equals(key)) {
                        this.StmFObj = keyPairs.getNextValueAsDictionary();
                    }
                    keyPairs.nextPair();
                }
            }
        }
        this.isEncrypted = true;
        this.isFileViewable = false;
        if (LogWriter.isOutput()) {
            LogWriter.writeLog("File has encryption settings");
        }
        if (firstValue == 1467315058) {
            try {
                this.verifyAccess();
            }
            catch (PdfSecurityException e) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("File requires password");
                }
            }
        } else if (this.certificate != null) {
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            this.extractionIsAllowed = true;
            this.passwordStatus = 2;
        }
        if (this.rev == 5) {
            this.Perms = DecryptionFactory.v5Decrypt(this.Perms, this.encryptionKey);
            this.isMetaDataEncypted = this.Perms[8] == 84;
            this.P = this.Perms[0] & 0xFF | (this.Perms[1] & 0xFF) << 8 | (this.Perms[2] & 0xFF) << 16 | (this.Perms[2] & 0xFF) << 24;
        }
    }

    private void setPasswordFromCertificate(PdfObject AESObj) {
        block5: {
            byte[] envelopedData;
            byte[][] recipients = AESObj.getStringArray(1752671921);
            if (recipients != null && (envelopedData = SetSecurity.extractCertificateData(recipients, this.certificate, this.key)) != null) {
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA-1");
                    md.update(envelopedData, 0, 20);
                    for (byte[] recipient : recipients) {
                        md.update(recipient);
                    }
                    if (!this.isMetaDataEncypted) {
                        md.update(new byte[]{-1, -1, -1, -1});
                    }
                    this.encryptionKey = md.digest();
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block5;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
    }

    public byte[] decrypt(byte[] data, String ref, boolean isEncryption, String cacheName, boolean alwaysUseRC4, boolean isString) throws PdfSecurityException {
        if (this.getBooleanValue(101) || isEncryption) {
            byte[] AESData;
            boolean isAES;
            BufferedInputStream bis;
            BufferedOutputStream streamCache;
            block36: {
                streamCache = null;
                bis = null;
                isAES = false;
                AESData = null;
                if (cacheName != null) {
                    try {
                        if (data == null) {
                            AESData = new byte[16];
                            FileInputStream fis = new FileInputStream(cacheName);
                            fis.read(AESData);
                            fis.close();
                        }
                        File tempFile2 = File.createTempFile("jpedal", ".raw", new File(ObjectStore.temp_dir));
                        this.cachedObjects.put(tempFile2.getAbsolutePath(), "x");
                        ObjectStore.copy(cacheName, tempFile2.getAbsolutePath());
                        File rawFile = new File(cacheName);
                        rawFile.delete();
                        streamCache = new BufferedOutputStream(new FileOutputStream(cacheName));
                        bis = new BufferedInputStream(new FileInputStream(tempFile2));
                    }
                    catch (IOException e1) {
                        if (!LogWriter.isOutput()) break block36;
                        LogWriter.writeLog("Exception " + e1 + " in decrypt");
                    }
                }
            }
            int keyLength = this.keyLength;
            String algorithm = "RC4";
            String keyType = "RC4";
            IvParameterSpec ivSpec = null;
            PdfObject AESObj = !isString ? this.StmFObj : this.StrFObj;
            if (this.certificate != null) {
                this.setPasswordFromCertificate(AESObj);
                AESObj.setIntNumber(1043816557, 16);
            }
            if (!alwaysUseRC4 && AESObj == null && this.isAESIdentity) {
                return data;
            }
            if (AESObj != null) {
                String cryptName;
                int AESLength = AESObj.getInt(1043816557);
                if (AESLength != -1) {
                    keyLength = AESLength;
                }
                if ((cryptName = AESObj.getName(1250845)) != null && !alwaysUseRC4 && (cryptName.equals("AESV2") || cryptName.equals("AESV3"))) {
                    this.cipher = null;
                    algorithm = "AES/CBC/PKCS5Padding";
                    keyType = "AES";
                    isAES = true;
                    byte[] iv = new byte[16];
                    if (AESData != null) {
                        System.arraycopy(AESData, 0, iv, 0, 16);
                    } else {
                        System.arraycopy(data, 0, iv, 0, 16);
                    }
                    ivSpec = new IvParameterSpec(iv);
                    if (data == null) {
                        try {
                            bis.skip(16L);
                        }
                        catch (IOException e) {
                            if (LogWriter.isOutput()) {
                                LogWriter.writeLog("Exception: " + e.getMessage());
                            }
                        }
                    } else {
                        int origLen = data.length;
                        int newLen = origLen - 16;
                        byte[] newData = new byte[newLen];
                        System.arraycopy(data, 16, newData, 0, newLen);
                        data = newData;
                        int diff = data.length & 0xF;
                        int newLength = data.length;
                        if (diff > 0) {
                            newLength = newLength + 16 - diff;
                            newData = new byte[newLength];
                            System.arraycopy(data, 0, newData, 0, data.length);
                            data = newData;
                        }
                    }
                }
            }
            byte[] currentKey = new byte[keyLength];
            if (ref.length() > 0) {
                currentKey = new byte[keyLength + 5];
            }
            System.arraycopy(this.encryptionKey, 0, currentKey, 0, keyLength);
            try {
                byte[] finalKey;
                if (this.rev == 5) {
                    finalKey = new byte[32];
                    System.arraycopy(currentKey, 0, finalKey, 0, finalKey.length);
                } else {
                    if (ref.length() > 0) {
                        int pointer = ref.indexOf(32);
                        int pointer2 = ref.indexOf(32, pointer + 1);
                        int obj = Integer.parseInt(ref.substring(0, pointer));
                        int gen = Integer.parseInt(ref.substring(pointer + 1, pointer2));
                        currentKey[keyLength] = (byte)(obj & 0xFF);
                        currentKey[keyLength + 1] = (byte)(obj >> 8 & 0xFF);
                        currentKey[keyLength + 2] = (byte)(obj >> 16 & 0xFF);
                        currentKey[keyLength + 3] = (byte)(gen & 0xFF);
                        currentKey[keyLength + 4] = (byte)(gen >> 8 & 0xFF);
                    }
                    finalKey = new byte[Math.min(currentKey.length, 16)];
                    if (ref.length() > 0) {
                        MessageDigest currentDigest = MessageDigest.getInstance("MD5");
                        currentDigest.update(currentKey);
                        if (isAES && keyLength >= 16) {
                            byte[] salt = new byte[]{115, 65, 108, 84};
                            currentDigest.update(salt);
                        }
                        System.arraycopy(currentDigest.digest(), 0, finalKey, 0, finalKey.length);
                    } else {
                        System.arraycopy(currentKey, 0, finalKey, 0, finalKey.length);
                    }
                }
                if (this.cipher == null) {
                    this.cipher = Cipher.getInstance(algorithm);
                }
                SecretKeySpec testKey = new SecretKeySpec(finalKey, keyType);
                if (isEncryption) {
                    this.cipher.init(1, testKey);
                } else if (ivSpec == null) {
                    this.cipher.init(2, testKey);
                } else {
                    this.cipher.init(2, (Key)testKey, ivSpec);
                }
                if (streamCache != null) {
                    int nextByte;
                    CipherInputStream cis = new CipherInputStream(bis, this.cipher);
                    while ((nextByte = cis.read()) != -1) {
                        streamCache.write(nextByte);
                    }
                    cis.close();
                    streamCache.close();
                    bis.close();
                }
                if (data != null) {
                    data = this.cipher.doFinal(data);
                }
            }
            catch (Exception e) {
                throw new PdfSecurityException("Exception " + e + " decrypting content");
            }
        }
        if (alwaysReinitCipher) {
            this.cipher = null;
        }
        return data;
    }

    public boolean getBooleanValue(int key) {
        switch (key) {
            case 100: {
                return this.isFileViewable;
            }
            case 101: {
                return this.isEncrypted;
            }
            case 102: {
                return this.isMetaDataEncypted;
            }
            case 103: {
                return this.extractionIsAllowed;
            }
            case 104: {
                return this.isPasswordSupplied;
            }
        }
        return false;
    }

    public byte[] decryptString(byte[] newString, String objectRef) throws PdfSecurityException {
        block3: {
            try {
                if (!this.isAES || this.stringsEncoded || this.isMetaDataEncypted) {
                    newString = this.decrypt(newString, objectRef, false, null, false, true);
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Unable to decrypt string in Object " + objectRef + ' ' + new String(newString));
            }
        }
        return newString;
    }

    public int getPDFflag(Integer flag) {
        if (flag.equals(PDFflags.USER_ACCESS_PERMISSIONS)) {
            return this.P;
        }
        if (flag.equals(PDFflags.VALID_PASSWORD_SUPPLIED)) {
            return this.passwordStatus;
        }
        return -1;
    }

    public void reset(byte[] encryptionPassword) {
        this.encryptionPassword = encryptionPassword;
        this.cipher = null;
    }

    public void flush() {
        if (this.cachedObjects != null) {
            for (Object o : this.cachedObjects.keySet()) {
                String fileName = (String)o;
                File file = new File(fileName);
                file.delete();
                if (!LogWriter.isOutput() || !file.exists()) continue;
                LogWriter.writeLog("Unable to delete temp file " + fileName);
            }
        }
    }

    public void dispose() {
        this.cachedObjects = null;
    }

    public boolean hasPassword() {
        return this.O != null || this.U != null;
    }

    static {
        String flag = System.getProperty("org.jpedal.cipher.reinit");
        if (flag != null && flag.toLowerCase().equals("true")) {
            alwaysReinitCipher = true;
        }
    }
}

