/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import org.jpedal.utils.StringUtils;

class MyTokenizer {
    private final byte[] content;
    private int currentCharPointer;
    private final int stringLength;

    public MyTokenizer(String line) {
        this.content = StringUtils.toBytes(line);
        this.stringLength = this.content.length;
    }

    private char getChar(int pointer) {
        int number = this.content[pointer] & 0xFF;
        return (char)number;
    }

    public final String nextToken() {
        StringBuilder tokenValue = new StringBuilder();
        boolean hasChars = false;
        char nextChar = this.getChar(this.currentCharPointer);
        ++this.currentCharPointer;
        while (true) {
            if (nextChar != ' ') {
                tokenValue.append(nextChar);
                hasChars = true;
            }
            if ((nextChar == ' ' && hasChars) | this.currentCharPointer == this.stringLength) break;
            nextChar = this.getChar(this.currentCharPointer);
            ++this.currentCharPointer;
        }
        return tokenValue.toString();
    }

    public int countTokens() {
        int tokenCount = 1;
        int count = this.stringLength - 1;
        for (int i = 1; i < count; ++i) {
            if (this.content[i] != 32 || this.content[i - 1] == 32) continue;
            ++tokenCount;
        }
        return tokenCount;
    }
}

