/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.structuredtext;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class StructuredContentHandler {
    private boolean addCoordinates = false;
    private Map markedContentProperties;
    private int markedContentLevel = 0;
    private StringBuffer markedContentSequence;
    private static final boolean debug = false;
    private boolean contentExtracted = false;
    private String currentKey;
    private Map keys;
    private Map values;
    private Map dictionaries;
    PdfObjectReader currentPdfFile;
    boolean buildDirectly = false;
    Document doc;
    Element root;
    private float x1;
    private float y1;
    private float x2;
    private float y2;

    public StructuredContentHandler(Object markedContent) {
        if (markedContent instanceof Map) {
            this.buildDirectly = false;
            this.values = (Map)markedContent;
        } else {
            this.buildDirectly = true;
            this.doc = (Document)markedContent;
            this.root = this.doc.createElement("TaggedPDF-doc");
            this.doc.appendChild(this.root);
        }
        this.markedContentProperties = new HashMap();
        this.markedContentLevel = 0;
        this.markedContentSequence = new StringBuffer();
        this.currentKey = "";
        this.keys = new HashMap();
        this.dictionaries = new HashMap();
    }

    public void MP() {
    }

    public void DP(PdfObject BDCobj) {
    }

    public void BDC(PdfObject BDCobj) {
        int MCID;
        if (this.markedContentLevel == 0) {
            this.markedContentSequence = new StringBuffer();
        }
        ++this.markedContentLevel;
        if (this.buildDirectly) {
            BDCobj.setIntNumber(487790868, -1);
        }
        if ((MCID = BDCobj.getInt(487790868)) != -1) {
            this.keys.put(this.markedContentLevel, String.valueOf(MCID));
        }
        this.dictionaries.put(String.valueOf(this.markedContentLevel), BDCobj);
    }

    public void BMC(String op) {
        if (op.startsWith("/")) {
            op = op.substring(1);
        }
        if (this.markedContentLevel == 0) {
            this.markedContentSequence = new StringBuffer();
        }
        this.markedContentProperties.put(this.markedContentLevel, op);
        ++this.markedContentLevel;
        this.keys.put(this.markedContentLevel, op);
        if (this.buildDirectly && op != null) {
            Element newRoot = (Element)this.root.getElementsByTagName(op).item(0);
            if (newRoot == null) {
                newRoot = this.doc.createElement(op);
                this.root.appendChild(newRoot);
            }
            this.root = newRoot;
        }
    }

    public void EMC() {
        this.contentExtracted = true;
        this.currentKey = (String)this.keys.get(this.markedContentLevel);
        if (this.currentKey == null) {
            this.currentKey = String.valueOf(this.markedContentLevel);
        }
        if (this.buildDirectly) {
            Map metadata;
            boolean isBMC;
            PdfObject BDCobj = (PdfObject)this.dictionaries.get(this.currentKey);
            boolean bl = isBMC = BDCobj == null;
            if (BDCobj != null && (metadata = BDCobj.getOtherDictionaries()) != null) {
                for (Object key : metadata.keySet()) {
                    this.root.setAttribute(key.toString(), metadata.get(key).toString());
                    this.root.setAttribute("x1", String.valueOf((int)this.x1));
                    this.root.setAttribute("y1", String.valueOf((int)this.y1));
                    this.root.setAttribute("x2", String.valueOf((int)this.x2));
                    this.root.setAttribute("y2", String.valueOf((int)this.y2));
                }
            }
            if (isBMC) {
                if (this.currentKey != null) {
                    Node oldRoot;
                    Text child = this.doc.createTextNode(StructuredContentHandler.stripEscapeChars(this.markedContentSequence.toString()));
                    this.root.appendChild(child);
                    if (this.addCoordinates) {
                        this.root.setAttribute("x1", String.valueOf((int)this.x1));
                        this.root.setAttribute("y1", String.valueOf((int)this.y1));
                        this.root.setAttribute("x2", String.valueOf((int)this.x2));
                        this.root.setAttribute("y2", String.valueOf((int)this.y2));
                    }
                    if ((oldRoot = this.root.getParentNode()) instanceof Element) {
                        this.root = (Element)oldRoot;
                    }
                }
            } else {
                String S = "p";
                if (S == null) {
                    S = "p";
                }
                Element tag = this.doc.createElement(S);
                this.root.appendChild(tag);
                if (this.addCoordinates) {
                    tag.setAttribute("x1", String.valueOf((int)this.x1));
                    tag.setAttribute("y1", String.valueOf((int)this.y1));
                    tag.setAttribute("x2", String.valueOf((int)this.x2));
                    tag.setAttribute("y2", String.valueOf((int)this.y2));
                }
                Text child = this.doc.createTextNode(this.markedContentSequence.toString());
                tag.appendChild(child);
            }
            this.markedContentSequence = new StringBuffer();
        } else {
            String ContentSequence = this.markedContentSequence.toString();
            PdfObject BDCobj = (PdfObject)this.dictionaries.get(String.valueOf(this.markedContentLevel));
            int MCID = -1;
            if (BDCobj != null) {
                MCID = BDCobj.getInt(487790868);
            }
            if (MCID != -1) {
                this.values.put(String.valueOf(MCID), ContentSequence);
                this.markedContentSequence = new StringBuffer();
            }
            this.dictionaries.remove(String.valueOf(this.markedContentLevel));
        }
        if (this.markedContentLevel > 0) {
            --this.markedContentLevel;
        }
    }

    public void setText(StringBuffer current_value, float x1, float y1, float x2, float y2) {
        if (this.markedContentSequence.length() == 0) {
            this.markedContentSequence = current_value;
            if (this.markedContentSequence.length() > 0 && this.markedContentSequence.charAt(0) == ' ') {
                this.markedContentSequence.deleteCharAt(0);
            }
        } else {
            int len;
            int c = 32;
            int c2 = 32;
            if (current_value.length() > 0) {
                c = current_value.charAt(0);
            }
            if ((len = this.markedContentSequence.length() - 1) > 0) {
                c2 = this.markedContentSequence.charAt(len);
            }
            if (c2 != 45 && c != 45 && c != 46) {
                this.markedContentSequence.append(' ');
            }
            this.markedContentSequence.append(current_value);
        }
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    private static String stripEscapeChars(Object dict) {
        int lastC = 32;
        StringBuilder str = new StringBuilder((String)dict);
        int length = str.length();
        for (int ii = 0; ii < length; ++ii) {
            char c = str.charAt(ii);
            if (c == '\\' && lastC != 92) {
                str.deleteCharAt(ii);
                --length;
            }
            lastC = c;
        }
        return str.toString();
    }

    public boolean hasContent() {
        return this.contentExtracted;
    }
}

