/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.blends;

import com.idrsolutions.pdf.color.blends.BMContext;

class Multiply
extends BMContext {
    Multiply(float alpha) {
        super(alpha);
    }

    @Override
    int[] blend(int[] src, int[] dst) {
        int[] ndst = new int[4];
        if (src[0] == 0 && src[1] == 0 && src[2] == 0 && src[3] < 10) {
            ndst = dst;
            dst[3] = 255;
        } else if (dst[0] == 0 && dst[1] == 0 && dst[2] == 0 && dst[3] == 0) {
            ndst = src;
            ndst[3] = (dst[3] + src[3]) / 2;
        } else if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255 && dst[3] == 255) {
            ndst = src;
            src[3] = 255;
        } else {
            for (int a = 0; a < src.length; ++a) {
                int result = dst[a] * src[a] >> 8;
                if (result >= 256) continue;
                ndst[a] = result;
            }
            ndst[3] = dst[3];
        }
        return ndst;
    }
}

