/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import java.util.BitSet;

public class BitReader {
    private int p;
    private final int totalBitLen;
    private BitSet bitset;
    private byte[] data;
    private final boolean hasSmallBits;

    public BitReader(byte[] data, boolean hasSmallBits) {
        this.hasSmallBits = hasSmallBits;
        this.totalBitLen = data.length * 8;
        if (this.hasSmallBits) {
            this.bitset = new BitSet(this.totalBitLen);
            int c = 0;
            for (int i = 0; i < data.length; ++i) {
                byte b = data[i];
                for (int j = 7; j >= 0; --j) {
                    boolean isOn = (b >> j & 1) == 1;
                    this.bitset.set(c, isOn);
                    ++c;
                }
            }
        } else {
            this.data = data;
        }
    }

    private int readBits(int lenToRead) {
        int retVal = 0;
        if (this.hasSmallBits) {
            BitSet smallSet = this.bitset.get(this.p, this.p + lenToRead);
            for (int i = 0; i < lenToRead; ++i) {
                if (smallSet.get(i)) {
                    retVal = retVal << 1 | 1;
                    continue;
                }
                retVal <<= 1;
            }
            this.p += lenToRead;
        } else {
            int len = lenToRead / 8;
            for (int i = 0; i < len; ++i) {
                retVal <<= 8;
                retVal |= this.data[this.p / 8] & 0xFF;
                this.p += 8;
            }
        }
        return retVal;
    }

    public int getPositive(int bitLen) {
        return this.readBits(bitLen);
    }

    public float getFloat(int bitLen) {
        int value = this.readBits(bitLen);
        byte[] temp = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        float number = 0.0f;
        switch (bitLen) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                number = (float)(temp[3] & 0xFF) / 256.0f;
                break;
            }
            case 16: {
                number = (float)(temp[2] & 0xFF) / 256.0f;
                number += (float)(temp[3] & 0xFF) / 65536.0f;
                break;
            }
            case 24: {
                number = (float)(temp[1] & 0xFF) / 256.0f;
                number += (float)(temp[2] & 0xFF) / 65536.0f;
                number += (float)(temp[3] & 0xFF) / 1.6777216E7f;
                break;
            }
            case 32: {
                number = (float)(temp[0] & 0xFF) / 256.0f;
                number += (float)(temp[1] & 0xFF) / 65536.0f;
                number += (float)(temp[2] & 0xFF) / 1.6777216E7f;
                number += (float)(temp[3] & 0xFF) / 4.2949673E9f;
            }
        }
        return number;
    }

    public int getPointer() {
        return this.p;
    }

    public int getTotalBitLen() {
        return this.totalBitLen;
    }
}

