/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.PDFObject;
import java.io.IOException;

public class NameTree {
    private PDFObject root;

    public NameTree(PDFObject pDFObject) {
        this.root = pDFObject;
    }

    public PDFObject find(String string) throws IOException {
        return this.find(this.root, string);
    }

    private PDFObject find(PDFObject pDFObject, String string) throws IOException {
        PDFObject pDFObject2 = pDFObject.getDictRef("Names");
        if (pDFObject2 != null) {
            return this.findInArray(pDFObject2.getArray(), string);
        }
        PDFObject pDFObject3 = pDFObject.getDictRef("Kids");
        if (pDFObject3 != null) {
            PDFObject[] pDFObjectArray = pDFObject3.getArray();
            for (int i = 0; i < pDFObjectArray.length; ++i) {
                PDFObject pDFObject4 = pDFObjectArray[i].getDictRef("Limits");
                if (pDFObject4 == null) continue;
                String string2 = pDFObject4.getAt(0).getStringValue();
                String string3 = pDFObject4.getAt(1).getStringValue();
                if (string.compareTo(string2) < 0 || string.compareTo(string3) > 0) continue;
                return this.find(pDFObjectArray[i], string);
            }
        }
        return null;
    }

    private PDFObject findInArray(PDFObject[] pDFObjectArray, String string) throws IOException {
        int n = 0;
        int n2 = pDFObjectArray.length / 2;
        while (n2 >= n && n >= 0 && n2 < pDFObjectArray.length) {
            int n3 = n + (n2 - n) / 2;
            String string2 = pDFObjectArray[n3 * 2].getStringValue();
            int n4 = string.compareTo(string2);
            if (n4 == 0) {
                return pDFObjectArray[n3 * 2 + 1];
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 >= 0) continue;
            n2 = n3 - 1;
        }
        return null;
    }
}

