/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.BaseWatchable;
import com.sun.pdfview.ImageInfo;
import com.sun.pdfview.PDFCmd;
import com.sun.pdfview.PDFImage;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFPaint;
import com.sun.pdfview.PDFParseException;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class PDFRenderer
extends BaseWatchable
implements Runnable {
    private PDFPage page;
    private int currentCommand;
    private WeakReference imageRef;
    private Graphics2D g;
    private GraphicsState state;
    private Stack<GraphicsState> stack;
    private Rectangle2D globalDirtyRegion;
    private List<ImageObserver> observers;
    private GeneralPath lastShape;
    private ImageInfo imageinfo;
    private long then = 0L;
    private Rectangle2D unupdatedRegion;
    public static final long UPDATE_DURATION = 200L;
    public static final float NOPHASE = -1000.0f;
    public static final float NOWIDTH = -1000.0f;
    public static final float NOLIMIT = -1000.0f;
    public static final int NOCAP = -1000;
    public static final float[] NODASH = null;
    public static final int NOJOIN = -1000;

    public PDFRenderer(PDFPage pDFPage, ImageInfo imageInfo, BufferedImage bufferedImage) {
        this.page = pDFPage;
        this.imageinfo = imageInfo;
        this.imageRef = new WeakReference<BufferedImage>(bufferedImage);
        this.observers = new ArrayList<ImageObserver>();
    }

    public PDFRenderer(PDFPage pDFPage, Graphics2D graphics2D, Rectangle rectangle, Rectangle2D rectangle2D, Color color) {
        this.page = pDFPage;
        this.g = graphics2D;
        this.imageinfo = new ImageInfo(rectangle.width, rectangle.height, rectangle2D, color);
        graphics2D.translate(rectangle.x, rectangle.y);
        this.observers = new ArrayList<ImageObserver>();
    }

    private void setupRendering(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        if (this.imageinfo.bgColor != null) {
            graphics2D.setColor(this.imageinfo.bgColor);
            graphics2D.fillRect(0, 0, this.imageinfo.width, this.imageinfo.height);
        }
        graphics2D.setColor(Color.BLACK);
        AffineTransform affineTransform = this.getInitialTransform();
        graphics2D.transform(affineTransform);
        this.state = new GraphicsState();
        this.state.cliprgn = null;
        this.state.stroke = new BasicStroke();
        this.state.fillPaint = this.state.strokePaint = PDFPaint.getColorPaint(Color.black);
        this.state.fillAlpha = AlphaComposite.getInstance(2);
        this.state.strokeAlpha = AlphaComposite.getInstance(2);
        this.state.xform = graphics2D.getTransform();
        this.stack = new Stack();
        this.currentCommand = 0;
    }

    public void push() {
        this.state.cliprgn = this.g.getClip();
        this.stack.push(this.state);
        this.state = (GraphicsState)this.state.clone();
    }

    public void pop() {
        this.state = this.stack.pop();
        this.setTransform(this.state.xform);
        this.setClip(this.state.cliprgn);
    }

    public Rectangle2D stroke(GeneralPath generalPath) {
        this.g.setComposite(this.state.strokeAlpha);
        generalPath = new GeneralPath(this.autoAdjustStrokeWidth(this.g, this.state.stroke).createStrokedShape(generalPath));
        return this.state.strokePaint.fill(this, this.g, generalPath);
    }

    private BasicStroke autoAdjustStrokeWidth(Graphics2D graphics2D, BasicStroke basicStroke) {
        AffineTransform affineTransform = new AffineTransform(graphics2D.getTransform());
        float f = basicStroke.getLineWidth() * (float)affineTransform.getScaleX();
        BasicStroke basicStroke2 = basicStroke;
        if (f < 1.0f) {
            f = affineTransform.getScaleX() > 0.01 ? 1.0f / (float)affineTransform.getScaleX() : 1.0f;
            basicStroke2 = new BasicStroke(f, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
        }
        return basicStroke2;
    }

    public void draw(GeneralPath generalPath, BasicStroke basicStroke) {
        this.g.setComposite(this.state.fillAlpha);
        this.g.setPaint(this.state.fillPaint.getPaint());
        this.g.setStroke(this.autoAdjustStrokeWidth(this.g, basicStroke));
        this.g.draw(generalPath);
    }

    public Rectangle2D fill(GeneralPath generalPath) {
        this.g.setComposite(this.state.fillAlpha);
        return this.state.fillPaint.fill(this, this.g, generalPath);
    }

    public Rectangle2D drawImage(PDFImage pDFImage) {
        AffineTransform affineTransform = new AffineTransform(1.0f / (float)pDFImage.getWidth(), 0.0f, 0.0f, -1.0f / (float)pDFImage.getHeight(), 0.0f, 1.0f);
        BufferedImage bufferedImage = pDFImage.getImage();
        if (bufferedImage == null) {
            return new Rectangle2D.Double();
        }
        if (pDFImage.isImageMask()) {
            bufferedImage = this.getMaskedImage(bufferedImage);
        }
        this.g.setComposite(AlphaComposite.getInstance(3));
        if (!this.g.drawImage(bufferedImage, affineTransform, null)) {
            System.out.println("Image not completed!");
        }
        AffineTransform affineTransform2 = new AffineTransform(this.g.getTransform());
        affineTransform2.concatenate(affineTransform);
        double d = bufferedImage.getMinX();
        double d2 = bufferedImage.getMinY();
        double[] dArray = new double[]{d, d2, d + (double)bufferedImage.getWidth(), d2 + (double)bufferedImage.getHeight()};
        affineTransform2.transform(dArray, 0, dArray, 0, 2);
        return new Rectangle2D.Double(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
    }

    public void clip(GeneralPath generalPath) {
        this.g.clip(generalPath);
    }

    private void setClip(Shape shape) {
        this.state.cliprgn = shape;
        this.g.setClip(null);
        this.g.clip(shape);
    }

    public AffineTransform getTransform() {
        return this.state.xform;
    }

    public void transform(AffineTransform affineTransform) {
        this.state.xform.concatenate(affineTransform);
        this.g.setTransform(this.state.xform);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.state.xform = affineTransform;
        this.g.setTransform(this.state.xform);
    }

    public AffineTransform getInitialTransform() {
        return this.page.getInitialTransform(this.imageinfo.width, this.imageinfo.height, this.imageinfo.clip);
    }

    public void setStrokeParts(float f, int n, int n2, float f2, float[] fArray, float f3) {
        if (f == -1000.0f) {
            f = this.state.stroke.getLineWidth();
        }
        if (n == -1000) {
            n = this.state.stroke.getEndCap();
        }
        if (n2 == -1000) {
            n2 = this.state.stroke.getLineJoin();
        }
        if (f2 == -1000.0f) {
            f2 = this.state.stroke.getMiterLimit();
        }
        if (f3 == -1000.0f) {
            fArray = this.state.stroke.getDashArray();
            f3 = this.state.stroke.getDashPhase();
        }
        if (fArray != null && fArray.length == 0) {
            fArray = null;
        }
        this.state.stroke = f3 == -1000.0f ? new BasicStroke(f, n, n2, f2) : new BasicStroke(f, n, n2, f2, fArray, f3);
    }

    public BasicStroke getStroke() {
        return this.state.stroke;
    }

    public void setStroke(BasicStroke basicStroke) {
        this.state.stroke = basicStroke;
    }

    public void setStrokePaint(PDFPaint pDFPaint) {
        this.state.strokePaint = pDFPaint;
    }

    public void setFillPaint(PDFPaint pDFPaint) {
        this.state.fillPaint = pDFPaint;
    }

    public void setStrokeAlpha(float f) {
        this.state.strokeAlpha = AlphaComposite.getInstance(3, f);
    }

    public void setFillAlpha(float f) {
        this.state.fillAlpha = AlphaComposite.getInstance(3, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(ImageObserver imageObserver) {
        if (imageObserver == null) {
            return;
        }
        Image image = (Image)this.imageRef.get();
        if (this.rendererFinished()) {
            imageObserver.imageUpdate(image, 32, 0, 0, this.imageinfo.width, this.imageinfo.height);
            return;
        }
        List<ImageObserver> list = this.observers;
        synchronized (list) {
            this.observers.add(imageObserver);
        }
        if (this.globalDirtyRegion != null) {
            imageObserver.imageUpdate(image, 8, (int)this.globalDirtyRegion.getMinX(), (int)this.globalDirtyRegion.getMinY(), (int)this.globalDirtyRegion.getWidth(), (int)this.globalDirtyRegion.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(ImageObserver imageObserver) {
        List<ImageObserver> list = this.observers;
        synchronized (list) {
            this.observers.remove(imageObserver);
        }
    }

    public void setLastShape(GeneralPath generalPath) {
        this.lastShape = generalPath;
    }

    public GeneralPath getLastShape() {
        return this.lastShape;
    }

    @Override
    public void setup() {
        Graphics2D graphics2D = null;
        if (this.imageRef != null) {
            BufferedImage bufferedImage = (BufferedImage)this.imageRef.get();
            if (bufferedImage != null) {
                graphics2D = bufferedImage.createGraphics();
            }
        } else {
            graphics2D = this.g;
        }
        if (graphics2D != null) {
            this.setupRendering(graphics2D);
        }
    }

    @Override
    public int iterate() throws Exception {
        PDFCmd pDFCmd;
        if (this.page == null) {
            return 6;
        }
        BufferedImage bufferedImage = null;
        if (this.imageRef != null) {
            bufferedImage = (BufferedImage)this.imageRef.get();
            if (bufferedImage == null) {
                System.out.println("Image went away.  Stopping");
                return 5;
            }
            this.g = bufferedImage.createGraphics();
        }
        if (this.currentCommand >= this.page.getCommandCount()) {
            if (this.page.isFinished()) {
                return 6;
            }
            return 3;
        }
        if ((pDFCmd = this.page.getCommand(this.currentCommand++)) == null) {
            throw new PDFParseException("Command not found!");
        }
        Rectangle2D rectangle2D = pDFCmd.execute(this);
        this.globalDirtyRegion = this.addDirtyRegion(rectangle2D, this.globalDirtyRegion);
        this.unupdatedRegion = this.addDirtyRegion(rectangle2D, this.unupdatedRegion);
        long l = System.currentTimeMillis();
        if (l > this.then || this.rendererFinished()) {
            this.notifyObservers(bufferedImage, this.unupdatedRegion);
            this.unupdatedRegion = null;
            this.then = l + 200L;
        }
        if (this.imageRef != null) {
            this.g = null;
        }
        return 4;
    }

    @Override
    public void cleanup() {
        this.page = null;
        this.state = null;
        this.stack = null;
        this.globalDirtyRegion = null;
        this.lastShape = null;
        this.observers.clear();
    }

    private Rectangle2D addDirtyRegion(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (rectangle2D == null) {
            return rectangle2D2;
        }
        if (rectangle2D2 == null) {
            return rectangle2D;
        }
        Rectangle2D.union(rectangle2D2, rectangle2D, rectangle2D2);
        return rectangle2D2;
    }

    private boolean rendererFinished() {
        if (this.page == null) {
            return true;
        }
        return this.page.isFinished() && this.currentCommand == this.page.getCommandCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObservers(BufferedImage bufferedImage, Rectangle2D rectangle2D) {
        int n;
        int n2;
        int n3;
        int n4;
        if (bufferedImage == null) {
            return;
        }
        int n5 = 0;
        if (rectangle2D == null && !this.rendererFinished() || this.observers == null || this.observers.size() == 0) {
            return;
        }
        if (rectangle2D != null) {
            n4 = (int)Math.floor(rectangle2D.getMinX());
            n3 = (int)Math.floor(rectangle2D.getMinY());
            n2 = (int)Math.ceil(rectangle2D.getWidth());
            n = (int)Math.ceil(rectangle2D.getHeight());
            if (n2 < 0) {
                n4 += n2;
                n2 = -n2;
            }
            if (n < 0) {
                n3 += n;
                n = -n;
            }
            n5 = 0;
        } else {
            n4 = 0;
            n3 = 0;
            n2 = this.imageinfo.width;
            n = this.imageinfo.height;
        }
        if (this.rendererFinished()) {
            n5 |= 0x20;
            this.g = null;
        } else {
            n5 |= 8;
        }
        List<ImageObserver> list = this.observers;
        synchronized (list) {
            Iterator<ImageObserver> iterator = this.observers.iterator();
            while (iterator.hasNext()) {
                ImageObserver imageObserver = iterator.next();
                boolean bl = imageObserver.imageUpdate(bufferedImage, n5, n4, n3, n2, n);
                if (bl) continue;
                iterator.remove();
            }
        }
    }

    private BufferedImage getMaskedImage(BufferedImage bufferedImage) {
        Paint paint = this.state.fillPaint.getPaint();
        if (!(paint instanceof Color)) {
            return bufferedImage;
        }
        Color color = (Color)paint;
        int n = color.getAlpha() << 24;
        n |= color.getRed() << 16;
        n |= color.getGreen() << 8;
        n |= color.getBlue();
        int n2 = 0;
        int n3 = bufferedImage.getMinX();
        int n4 = bufferedImage.getMinY();
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n5, n6, 2);
        for (int i = 0; i < n6; ++i) {
            int[] nArray = new int[n5];
            int[] nArray2 = new int[nArray.length];
            bufferedImage.getRGB(n3, n4 + i, n5, 1, nArray, 0, n6);
            for (int j = 0; j < nArray.length; ++j) {
                nArray2[j] = nArray[j] == -16777216 ? n : n2;
            }
            bufferedImage2.setRGB(n3, n4 + i, n5, 1, nArray2, 0, n6);
        }
        return bufferedImage2;
    }

    class GraphicsState
    implements Cloneable {
        Shape cliprgn;
        BasicStroke stroke;
        PDFPaint strokePaint;
        PDFPaint fillPaint;
        AlphaComposite strokeAlpha;
        AlphaComposite fillAlpha;
        AffineTransform xform;

        GraphicsState() {
        }

        public Object clone() {
            GraphicsState graphicsState = new GraphicsState();
            graphicsState.cliprgn = null;
            graphicsState.strokePaint = this.strokePaint;
            graphicsState.fillPaint = this.fillPaint;
            graphicsState.strokeAlpha = this.strokeAlpha;
            graphicsState.fillAlpha = this.fillAlpha;
            graphicsState.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
            graphicsState.xform = (AffineTransform)this.xform.clone();
            return graphicsState;
        }
    }
}

