/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;

public class PdfSubByteSampleModel
extends SampleModel {
    private final int transferBytesPerPixel;
    private final int storageBitsPerPixel;
    private final int bitsPerLine;
    private final int bitsPerBand;
    private final int componentMask;
    private final int[] sampleSize;
    private final int ignoredBitsPerComponentPerByte;

    public PdfSubByteSampleModel(int n, int n2, int n3, int n4) {
        super(0, n, n2, n3);
        assert (n4 < 8) : "This is designed just for use with per-component sizes of less than 8 bits; you should probably use PixelInterleavedSampleModel";
        assert (n4 == 1 || n4 == 2 || n4 == 4) : "we don't want to grab components across byte boundaries";
        this.transferBytesPerPixel = (n3 * n4 + 7) / 8;
        this.storageBitsPerPixel = n3 * n4;
        this.bitsPerLine = 8 * ((this.storageBitsPerPixel * n + 7) / 8);
        this.bitsPerBand = n4;
        this.componentMask = (1 << this.bitsPerBand) - 1;
        this.sampleSize = new int[n3];
        for (int i = 0; i < this.sampleSize.length; ++i) {
            this.sampleSize[i] = n4;
        }
        this.ignoredBitsPerComponentPerByte = 8 - this.bitsPerBand;
    }

    @Override
    public int getNumDataElements() {
        return this.transferBytesPerPixel;
    }

    @Override
    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        byte[] byArray = object != null ? (byte[])object : new byte[this.numBands];
        int n3 = n2 * this.bitsPerLine + this.storageBitsPerPixel * n;
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)this.getComponent(dataBuffer, n3);
            n3 += this.bitsPerBand;
        }
        return byArray;
    }

    private int getComponent(DataBuffer dataBuffer, int n) {
        int n2 = n >> 3;
        int n3 = dataBuffer.getElem(n2);
        int n4 = n & 7;
        int n5 = this.ignoredBitsPerComponentPerByte - n4;
        return n3 >>> n5 & this.componentMask;
    }

    @Override
    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        return this.getComponent(dataBuffer, n2 * this.bitsPerLine + this.storageBitsPerPixel * n + this.bitsPerBand * n3);
    }

    @Override
    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public SampleModel createCompatibleSampleModel(int n, int n2) {
        throw new UnsupportedOperationException("Not required");
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] nArray) {
        throw new UnsupportedOperationException("Not required");
    }

    @Override
    public DataBuffer createDataBuffer() {
        throw new UnsupportedOperationException("Not required");
    }

    @Override
    public int[] getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public int getSampleSize(int n) {
        return this.bitsPerBand;
    }
}

