/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.colorspace;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPaint;
import com.sun.pdfview.colorspace.PDFColorSpace;
import java.awt.Color;
import java.io.IOException;

public class IndexedColor
extends PDFColorSpace {
    protected byte[] finalcolors;
    Color[] table;
    int count;
    int nchannels = 1;

    public IndexedColor(PDFColorSpace pDFColorSpace, int n, PDFObject pDFObject) throws IOException {
        super(null);
        this.count = ++n;
        byte[] byArray = pDFObject.getStream();
        this.nchannels = pDFColorSpace.getNumComponents();
        boolean bl = byArray.length / this.nchannels < n;
        this.finalcolors = new byte[3 * n];
        this.table = new Color[n];
        float[] fArray = new float[this.nchannels];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < fArray.length; ++j) {
                fArray[j] = n2 < byArray.length ? (float)(byArray[n2++] & 0xFF) / 255.0f : 1.0f;
            }
            this.table[i] = (Color)pDFColorSpace.getPaint(fArray).getPaint();
            this.finalcolors[n3++] = (byte)this.table[i].getRed();
            this.finalcolors[n3++] = (byte)this.table[i].getGreen();
            this.finalcolors[n3++] = (byte)this.table[i].getBlue();
        }
    }

    public IndexedColor(Color[] colorArray) throws IOException {
        super(null);
        this.count = colorArray.length;
        this.table = colorArray;
        this.finalcolors = new byte[3 * this.count];
        this.nchannels = 3;
        int n = 0;
        for (int i = 0; i < this.count; ++i) {
            this.finalcolors[n++] = (byte)colorArray[i].getRed();
            this.finalcolors[n++] = (byte)colorArray[i].getGreen();
            this.finalcolors[n++] = (byte)colorArray[i].getBlue();
        }
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getColorComponents() {
        return this.finalcolors;
    }

    @Override
    public int getNumComponents() {
        return 1;
    }

    @Override
    public PDFPaint getPaint(float[] fArray) {
        return PDFPaint.getPaint(this.table[(int)fArray[0]]);
    }
}

