/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public class ASCIIHexDecode {
    private ByteBuffer buf;

    private ASCIIHexDecode(ByteBuffer byteBuffer) {
        this.buf = byteBuffer;
    }

    private int readHexDigit() throws PDFParseException {
        while (this.buf.remaining() > 0) {
            int n = this.buf.get();
            if (PDFFile.isWhiteSpace((char)n)) continue;
            if (n >= 48 && n <= 57) {
                n -= 48;
            } else if (n >= 97 && n <= 102) {
                n -= 87;
            } else if (n >= 65 && n <= 70) {
                n -= 55;
            } else if (n == 62) {
                n = -1;
            } else {
                throw new PDFParseException("Bad character " + n + "in ASCIIHex decode");
            }
            return n;
        }
        throw new PDFParseException("Short stream in ASCIIHex decode");
    }

    private ByteBuffer decode() throws PDFParseException {
        this.buf.rewind();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (true) {
            int n = this.readHexDigit();
            int n2 = this.readHexDigit();
            if (n == -1) break;
            if (n2 == -1) {
                byteArrayOutputStream.write((byte)(n << 4));
                break;
            }
            byteArrayOutputStream.write((byte)((n << 4) + n2));
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public static ByteBuffer decode(ByteBuffer byteBuffer, PDFObject pDFObject) throws PDFParseException {
        ASCIIHexDecode aSCIIHexDecode = new ASCIIHexDecode(byteBuffer);
        return aSCIIHexDecode.decode();
    }
}

