/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decrypt;

import com.sun.pdfview.Identity8BitCharsetEncoder;
import com.sun.pdfview.PDFDocCharsetEncoder;
import com.sun.pdfview.PDFStringUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PDFPassword {
    public static final PDFPassword EMPTY_PASSWORD = new PDFPassword(new byte[0]);
    private byte[] passwordBytes = null;
    private String passwordString = null;
    private static final PasswordByteGenerator[] PASSWORD_BYTE_GENERATORS = new PasswordByteGenerator[]{new PDFDocEncodingByteGenerator(null), new PDFDocEncodingByteGenerator((byte)0), new PDFDocEncodingByteGenerator((byte)63), new PasswordByteGenerator(){

        @Override
        public byte[] generateBytes(String string) {
            return PDFStringUtil.asBytes(string);
        }
    }, new IdentityEncodingByteGenerator(null), new IdentityEncodingByteGenerator((byte)0), new IdentityEncodingByteGenerator((byte)63)};

    public static PDFPassword nonNullPassword(PDFPassword pDFPassword) {
        return pDFPassword != null ? pDFPassword : EMPTY_PASSWORD;
    }

    public PDFPassword(byte[] byArray) {
        this.passwordBytes = byArray != null ? byArray : new byte[]{};
    }

    public PDFPassword(String string) {
        this.passwordString = string != null ? string : "";
    }

    List<byte[]> getPasswordBytes(boolean bl) {
        if (this.passwordBytes != null || this.passwordString == null) {
            return Collections.singletonList(this.passwordBytes);
        }
        if (this.isAlphaNum7BitString(this.passwordString)) {
            return Collections.singletonList(PDFStringUtil.asBytes(this.passwordString));
        }
        return PDFPassword.generatePossiblePasswordBytes(this.passwordString);
    }

    private static List<byte[]> generatePossiblePasswordBytes(String string) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (PasswordByteGenerator passwordByteGenerator : PASSWORD_BYTE_GENERATORS) {
            byte[] byArray = passwordByteGenerator.generateBytes(string);
            boolean bl = false;
            for (int i = 0; !bl && i < arrayList.size(); ++i) {
                if (!Arrays.equals((byte[])arrayList.get(i), byArray)) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList.add(byArray);
        }
        return arrayList;
    }

    private boolean isAlphaNum7BitString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '\u007f' && Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static class IdentityEncodingByteGenerator
    extends CharsetEncoderGenerator {
        private IdentityEncodingByteGenerator(Byte by) {
            super(by);
        }

        @Override
        protected CharsetEncoder createCharsetEncoder() {
            return new Identity8BitCharsetEncoder();
        }
    }

    private static class PDFDocEncodingByteGenerator
    extends CharsetEncoderGenerator {
        private PDFDocEncodingByteGenerator(Byte by) {
            super(by);
        }

        @Override
        protected CharsetEncoder createCharsetEncoder() {
            return new PDFDocCharsetEncoder();
        }
    }

    private static abstract class CharsetEncoderGenerator
    implements PasswordByteGenerator {
        private Byte replacementByte;

        protected CharsetEncoderGenerator(Byte by) {
            this.replacementByte = by;
        }

        @Override
        public byte[] generateBytes(String string) {
            CharsetEncoder charsetEncoder = this.createCharsetEncoder();
            if (this.replacementByte != null) {
                charsetEncoder.replaceWith(new byte[]{this.replacementByte});
                charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            } else {
                charsetEncoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
            }
            try {
                ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string));
                byte[] byArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray);
                return byArray;
            }
            catch (CharacterCodingException characterCodingException) {
                return null;
            }
        }

        protected abstract CharsetEncoder createCharsetEncoder();
    }

    private static interface PasswordByteGenerator {
        public byte[] generateBytes(String var1);
    }
}

