/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.font.BuiltinFont;
import com.sun.pdfview.font.CIDFontType2;
import com.sun.pdfview.font.PDFCMap;
import com.sun.pdfview.font.PDFFontDescriptor;
import com.sun.pdfview.font.PDFFontEncoding;
import com.sun.pdfview.font.PDFGlyph;
import com.sun.pdfview.font.TTFFont;
import com.sun.pdfview.font.Type0Font;
import com.sun.pdfview.font.Type1CFont;
import com.sun.pdfview.font.Type1Font;
import com.sun.pdfview.font.Type3Font;
import com.sun.pdfview.font.ttf.TrueTypeFont;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class PDFFont {
    private static final FilenameFilter TTF_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".ttf");
        }
    };
    private static Map<String, File> namedFontsToLocalTtfFiles = null;
    private String subtype;
    private String baseFont;
    private PDFFontEncoding encoding;
    private PDFFontDescriptor descriptor;
    private PDFCMap unicodeMap;
    private Map<Character, PDFGlyph> charCache;

    public static synchronized PDFFont getFont(PDFObject pDFObject, HashMap<String, PDFObject> hashMap) throws IOException {
        PDFFont pDFFont = (PDFFont)pDFObject.getCache();
        if (pDFFont != null) {
            return pDFFont;
        }
        String string = null;
        PDFFontEncoding pDFFontEncoding = null;
        PDFFontDescriptor pDFFontDescriptor = null;
        String string2 = pDFObject.getDictRef("Subtype").getStringValue();
        if (string2 == null) {
            string2 = pDFObject.getDictRef("S").getStringValue();
        }
        PDFObject pDFObject2 = pDFObject.getDictRef("BaseFont");
        PDFObject pDFObject3 = pDFObject.getDictRef("Encoding");
        PDFObject pDFObject4 = pDFObject.getDictRef("FontDescriptor");
        if (pDFObject2 != null) {
            string = pDFObject2.getStringValue();
        } else {
            pDFObject2 = pDFObject.getDictRef("Name");
            if (pDFObject2 != null) {
                string = pDFObject2.getStringValue();
            }
        }
        if (pDFObject3 != null) {
            pDFFontEncoding = new PDFFontEncoding(string2, pDFObject3);
        }
        pDFFontDescriptor = pDFObject4 != null ? new PDFFontDescriptor(pDFObject4) : new PDFFontDescriptor(string);
        if (string2.equals("Type0")) {
            pDFFont = new Type0Font(string, pDFObject, pDFFontDescriptor);
        } else if (string2.equals("Type1")) {
            pDFFont = pDFFontDescriptor == null ? new BuiltinFont(string, pDFObject) : (pDFFontDescriptor.getFontFile() != null ? new Type1Font(string, pDFObject, pDFFontDescriptor) : (pDFFontDescriptor.getFontFile3() != null ? new Type1CFont(string, pDFObject, pDFFontDescriptor) : new BuiltinFont(string, pDFObject, pDFFontDescriptor)));
        } else if (string2.equals("TrueType")) {
            File file;
            pDFFont = pDFFontDescriptor.getFontFile2() != null ? new TTFFont(string, pDFObject, pDFFontDescriptor) : ((file = PDFFont.findExternalTtf(string)) != null ? new TTFFont(string, pDFObject, pDFFontDescriptor, file) : new BuiltinFont(string, pDFObject, pDFFontDescriptor));
        } else if (string2.equals("Type3")) {
            pDFFont = new Type3Font(string, pDFObject, hashMap, pDFFontDescriptor);
        } else if (string2.equals("CIDFontType2")) {
            pDFFont = new CIDFontType2(string, pDFObject, pDFFontDescriptor);
        } else if (string2.equals("CIDFontType0")) {
            pDFFont = new CIDFontType2(string, pDFObject, pDFFontDescriptor);
        } else {
            throw new PDFParseException("Don't know how to handle a '" + string2 + "' font");
        }
        pDFFont.setSubtype(string2);
        pDFFont.setEncoding(pDFFontEncoding);
        pDFObject.setCache(pDFFont);
        return pDFFont;
    }

    private static File findExternalTtf(String string) {
        PDFFont.ensureNamedTtfFontFiles();
        return namedFontsToLocalTtfFiles.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void ensureNamedTtfFontFiles() {
        if (namedFontsToLocalTtfFiles == null) {
            namedFontsToLocalTtfFiles = new HashMap<String, File>();
            if (Boolean.getBoolean("PDFRenderer.avoidExternalTtf")) {
                return;
            }
            for (String string : PDFFont.getFontSearchPath()) {
                File file = new File(string);
                if (!file.exists()) continue;
                for (File file2 : file.listFiles(TTF_FILTER)) {
                    if (!file2.canRead()) continue;
                    try {
                        byte[] byArray;
                        try (RandomAccessFile randomAccessFile = null;){
                            randomAccessFile = new RandomAccessFile(file2, "r");
                            int n = (int)randomAccessFile.length();
                            byArray = new byte[n];
                            randomAccessFile.readFully(byArray);
                        }
                        TrueTypeFont trueTypeFont = TrueTypeFont.parseFont(byArray);
                        for (String string2 : trueTypeFont.getNames()) {
                            if (namedFontsToLocalTtfFiles.containsKey(string2)) continue;
                            namedFontsToLocalTtfFiles.put(string2, file2);
                        }
                    }
                    catch (Throwable throwable) {
                        System.err.println("Problem parsing " + file2);
                        throwable.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    private static String[] getFontSearchPath() {
        String string = System.getProperty("PDFRenderer.fontSearchPath");
        if (string != null) {
            return string.split(Pattern.quote(File.pathSeparator));
        }
        return PDFFont.getDefaultFontSearchPath();
    }

    private static String[] getDefaultFontSearchPath() {
        String string = null;
        try {
            string = System.getProperty("os.name");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null) {
            return new String[0];
        }
        String string2 = string = string != null ? string.toLowerCase() : "";
        if (string.startsWith("windows")) {
            String string3 = "C:/WINDOWS/Fonts";
            try {
                String string4 = System.getenv("WINDIR");
                if (string4 != null) {
                    string3 = string4 + "/Fonts/";
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return new String[]{string3};
        }
        if (string != null && string.startsWith("mac")) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("/Library/Fonts", "/Network/Library/Fonts", "/System/Library/Fonts", "/System Folder/Fonts"));
            try {
                arrayList.add(0, System.getProperty("user.home") + "/Library/Fonts");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return new String[0];
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String string) {
        this.subtype = string;
    }

    public String getBaseFont() {
        return this.baseFont;
    }

    public void setBaseFont(String string) {
        this.baseFont = string;
    }

    public PDFFontEncoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(PDFFontEncoding pDFFontEncoding) {
        this.encoding = pDFFontEncoding;
    }

    public PDFFontDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(PDFFontDescriptor pDFFontDescriptor) {
        this.descriptor = pDFFontDescriptor;
    }

    public PDFCMap getUnicodeMap() {
        return this.unicodeMap;
    }

    public void setUnicodeMap(PDFCMap pDFCMap) {
        this.unicodeMap = pDFCMap;
    }

    public List<PDFGlyph> getGlyphs(String string) {
        List<PDFGlyph> list = null;
        if (this.encoding != null) {
            list = this.encoding.getGlyphs(this, string);
        } else {
            char[] cArray = string.toCharArray();
            list = new ArrayList<PDFGlyph>(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                char c = (char)(cArray[i] & 0xFF);
                list.add(this.getCachedGlyph(c, null));
            }
        }
        return list;
    }

    public PDFGlyph getCachedGlyph(char c, String string) {
        PDFGlyph pDFGlyph;
        if (this.charCache == null) {
            this.charCache = new HashMap<Character, PDFGlyph>();
        }
        if ((pDFGlyph = this.charCache.get(new Character(c))) == null) {
            pDFGlyph = this.getGlyph(c, string);
            this.charCache.put(new Character(c), pDFGlyph);
        }
        return pDFGlyph;
    }

    protected PDFFont(String string, PDFFontDescriptor pDFFontDescriptor) {
        this.setBaseFont(string);
        this.setDescriptor(pDFFontDescriptor);
    }

    protected abstract PDFGlyph getGlyph(char var1, String var2);

    public String toString() {
        return this.getBaseFont();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PDFFont)) {
            return false;
        }
        return ((PDFFont)object).getBaseFont().equals(this.getBaseFont());
    }

    public int hashCode() {
        return this.getBaseFont().hashCode();
    }
}

