/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFObject;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

public class PDFFontDescriptor {
    public static final int FIXED_PITCH = 1;
    public static final int SERIF = 2;
    public static final int SYMBOLIC = 4;
    public static final int SCRIPT = 8;
    public static final int NONSYMBOLIC = 32;
    public static final int ITALIC = 64;
    public static final int ALLCAP = 65536;
    public static final int SMALLCAP = 131072;
    public static final int FORCEBOLD = 262144;
    private int ascent;
    private int capHeight;
    private int descent;
    private int flags;
    private String fontFamily;
    private String fontName;
    private String fontStretch;
    private int fontWeight;
    private int italicAngle;
    private int stemV;
    private int avgWidth = 0;
    private PDFObject fontFile;
    private PDFObject fontFile2;
    private PDFObject fontFile3;
    private int leading = 0;
    private int maxWidth = 0;
    private int missingWidth = 0;
    private int stemH = 0;
    private int xHeight = 0;
    private PDFObject charSet;
    private Rectangle2D fontBBox;

    public PDFFontDescriptor(String string) {
        this.setFontName(string);
    }

    public PDFFontDescriptor(PDFObject pDFObject) throws IOException {
        this.setAscent(pDFObject.getDictRef("Ascent").getIntValue());
        this.setCapHeight(pDFObject.getDictRef("CapHeight").getIntValue());
        this.setDescent(pDFObject.getDictRef("Descent").getIntValue());
        this.setFlags(pDFObject.getDictRef("Flags").getIntValue());
        this.setFontName(pDFObject.getDictRef("FontName").getStringValue());
        this.setItalicAngle(pDFObject.getDictRef("ItalicAngle").getIntValue());
        this.setStemV(pDFObject.getDictRef("StemV").getIntValue());
        this.setFontBBox(PDFFile.parseNormalisedRectangle(pDFObject.getDictRef("FontBBox")));
        if (pDFObject.getDictionary().containsKey("AvgWidth")) {
            this.setAvgWidth(pDFObject.getDictRef("AvgWidth").getIntValue());
        }
        if (pDFObject.getDictionary().containsKey("FontFile")) {
            this.setFontFile(pDFObject.getDictRef("FontFile"));
        }
        if (pDFObject.getDictionary().containsKey("FontFile2")) {
            this.setFontFile2(pDFObject.getDictRef("FontFile2"));
        }
        if (pDFObject.getDictionary().containsKey("FontFile3")) {
            this.setFontFile3(pDFObject.getDictRef("FontFile3"));
        }
        if (pDFObject.getDictionary().containsKey("Leading")) {
            this.setLeading(pDFObject.getDictRef("Leading").getIntValue());
        }
        if (pDFObject.getDictionary().containsKey("MaxWidth")) {
            this.setMaxWidth(pDFObject.getDictRef("MaxWidth").getIntValue());
        }
        if (pDFObject.getDictionary().containsKey("MissingWidth")) {
            this.setMissingWidth(pDFObject.getDictRef("MissingWidth").getIntValue());
        }
        if (pDFObject.getDictionary().containsKey("StemH")) {
            this.setStemH(pDFObject.getDictRef("StemH").getIntValue());
        }
        if (pDFObject.getDictionary().containsKey("XHeight")) {
            this.setXHeight(pDFObject.getDictRef("XHeight").getIntValue());
        }
        if (pDFObject.getDictionary().containsKey("CharSet")) {
            this.setCharSet(pDFObject.getDictRef("CharSet"));
        }
        if (pDFObject.getDictionary().containsKey("FontFamily")) {
            this.setFontFamily(pDFObject.getDictRef("FontFamily").getStringValue());
        }
        if (pDFObject.getDictionary().containsKey("FontWeight")) {
            this.setFontWeight(pDFObject.getDictRef("FontWeight").getIntValue());
        }
        if (pDFObject.getDictionary().containsKey("FontStretch")) {
            this.setFontStretch(pDFObject.getDictRef("FontStretch").getStringValue());
        }
    }

    public int getAscent() {
        return this.ascent;
    }

    public void setAscent(int n) {
        this.ascent = n;
    }

    public int getCapHeight() {
        return this.capHeight;
    }

    public void setCapHeight(int n) {
        this.capHeight = n;
    }

    public int getDescent() {
        return this.descent;
    }

    public void setDescent(int n) {
        this.descent = n;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String string) {
        this.fontFamily = string;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public String getFontStretch() {
        return this.fontStretch;
    }

    public void setFontStretch(String string) {
        this.fontStretch = string;
    }

    public int getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(int n) {
        this.fontWeight = n;
    }

    public int getItalicAngle() {
        return this.italicAngle;
    }

    public void setItalicAngle(int n) {
        this.italicAngle = n;
    }

    public int getStemV() {
        return this.stemV;
    }

    public void setStemV(int n) {
        this.stemV = n;
    }

    public int getAvgWidth() {
        return this.avgWidth;
    }

    public void setAvgWidth(int n) {
        this.avgWidth = n;
    }

    public PDFObject getFontFile() {
        return this.fontFile;
    }

    public void setFontFile(PDFObject pDFObject) {
        this.fontFile = pDFObject;
    }

    public PDFObject getFontFile2() {
        return this.fontFile2;
    }

    public void setFontFile2(PDFObject pDFObject) {
        this.fontFile2 = pDFObject;
    }

    public PDFObject getFontFile3() {
        return this.fontFile3;
    }

    public void setFontFile3(PDFObject pDFObject) {
        this.fontFile3 = pDFObject;
    }

    public int getLeading() {
        return this.leading;
    }

    public void setLeading(int n) {
        this.leading = n;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int n) {
        this.maxWidth = n;
    }

    public int getMissingWidth() {
        return this.missingWidth;
    }

    public void setMissingWidth(int n) {
        this.missingWidth = n;
    }

    public int getStemH() {
        return this.stemH;
    }

    public void setStemH(int n) {
        this.stemH = n;
    }

    public int getXHeight() {
        return this.xHeight;
    }

    public void setXHeight(int n) {
        this.xHeight = n;
    }

    public PDFObject getCharSet() {
        return this.charSet;
    }

    public void setCharSet(PDFObject pDFObject) {
        this.charSet = pDFObject;
    }

    public Rectangle2D getFontBBox() {
        return this.fontBBox;
    }

    public void setFontBBox(Rectangle2D rectangle2D) {
        this.fontBBox = rectangle2D;
    }
}

