/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class AdobeGlyphList {
    private static HashMap<String, int[]> glyphToUnicodes;
    private static HashMap<Integer, String> unicodeToGlyph;
    static Thread glyphLoaderThread;

    private AdobeGlyphList() {
        glyphToUnicodes = new HashMap(4500);
        unicodeToGlyph = new HashMap(4500);
        glyphLoaderThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> arrayList = new ArrayList<String>();
                InputStream inputStream = this.getClass().getResourceAsStream("/com/sun/pdfview/font/ttf/resource/glyphlist.txt");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = "";
                while (string != null) {
                    try {
                        arrayList.clear();
                        string = bufferedReader.readLine();
                        if (string == null) break;
                        if ((string = string.trim()).length() <= 0 || string.startsWith("#")) continue;
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                        String string2 = stringTokenizer.nextToken();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), " ");
                        while (stringTokenizer2.hasMoreTokens()) {
                            arrayList.add(stringTokenizer2.nextToken());
                        }
                        int[] nArray = new int[arrayList.size()];
                        for (int i = 0; i < arrayList.size(); ++i) {
                            nArray[i] = Integer.parseInt((String)arrayList.get(i), 16);
                            unicodeToGlyph.put(new Integer(nArray[i]), string2);
                        }
                        glyphToUnicodes.put(string2, nArray);
                    }
                    catch (IOException iOException) {
                        break;
                    }
                }
            }
        }, "Adobe Glyph Loader Thread");
        glyphLoaderThread.setDaemon(true);
        glyphLoaderThread.setPriority(1);
        glyphLoaderThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getUnicodeValues(String string) {
        while (glyphLoaderThread != null && glyphLoaderThread.isAlive()) {
            HashMap<String, int[]> hashMap = glyphToUnicodes;
            synchronized (hashMap) {
                try {
                    glyphToUnicodes.wait(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return glyphToUnicodes.get(string);
    }

    public static Integer getGlyphNameIndex(String string) {
        int[] nArray = AdobeGlyphList.getUnicodeValues(string);
        if (nArray == null) {
            return null;
        }
        return new Integer(nArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGlyphName(int n) {
        while (glyphLoaderThread != null && glyphLoaderThread.isAlive()) {
            HashMap<String, int[]> hashMap = glyphToUnicodes;
            synchronized (hashMap) {
                try {
                    glyphToUnicodes.wait(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return unicodeToGlyph.get(new Integer(n));
    }

    static {
        glyphLoaderThread = null;
        new AdobeGlyphList();
    }
}

