/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.CMapFormat0;
import com.sun.pdfview.font.ttf.CMapFormat4;
import com.sun.pdfview.font.ttf.CMapFormat6;
import java.nio.ByteBuffer;

public abstract class CMap {
    private short format;
    private short language;

    protected CMap(short s, short s2) {
        this.format = s;
        this.language = s2;
    }

    public static CMap createMap(short s, short s2) {
        CMap cMap = null;
        switch (s) {
            case 0: {
                cMap = new CMapFormat0(s2);
                break;
            }
            case 4: {
                cMap = new CMapFormat4(s2);
                break;
            }
            case 6: {
                cMap = new CMapFormat6(s2);
                break;
            }
            default: {
                System.out.println("Unsupport CMap format: " + s);
                return null;
            }
        }
        return cMap;
    }

    public static CMap getMap(ByteBuffer byteBuffer) {
        short s = byteBuffer.getShort();
        short s2 = byteBuffer.getShort();
        int n = 0xFFFF & s2;
        byteBuffer.limit(Math.min(n, byteBuffer.limit()));
        short s3 = byteBuffer.getShort();
        CMap cMap = CMap.createMap(s, s3);
        if (cMap == null) {
            return null;
        }
        cMap.setData(byteBuffer.limit(), byteBuffer);
        return cMap;
    }

    public short getFormat() {
        return this.format;
    }

    public short getLanguage() {
        return this.language;
    }

    public abstract void setData(int var1, ByteBuffer var2);

    public abstract ByteBuffer getData();

    public abstract short getLength();

    public abstract byte map(byte var1);

    public abstract char map(char var1);

    public abstract char reverseMap(short var1);

    public String toString() {
        String string = "        ";
        return string + " format: " + this.getFormat() + " length: " + this.getLength() + " language: " + this.getLanguage() + "\n";
    }
}

