/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.CMap;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class CMapFormat6
extends CMap {
    private short firstCode;
    private short entryCount;
    private short[] glyphIndexArray;
    private HashMap<Short, Short> glyphLookup = new HashMap();

    protected CMapFormat6(short s) {
        super((short)6, s);
    }

    @Override
    public short getLength() {
        short s = 10;
        s = (short)(s + this.entryCount * 2);
        return s;
    }

    @Override
    public byte map(byte by) {
        char c = this.map((char)by);
        if (c < '\uffffff80' || c > '\u007f') {
            return 0;
        }
        return (byte)c;
    }

    @Override
    public char map(char c) {
        if (c < this.firstCode || c > this.firstCode + this.entryCount) {
            return '\u0000';
        }
        return (char)this.glyphIndexArray[c - this.firstCode];
    }

    @Override
    public char reverseMap(short s) {
        Short s2 = this.glyphLookup.get(new Short(s));
        if (s2 == null) {
            return '\u0000';
        }
        return (char)s2.shortValue();
    }

    @Override
    public void setData(int n, ByteBuffer byteBuffer) {
        this.firstCode = byteBuffer.getShort();
        this.entryCount = byteBuffer.getShort();
        this.glyphIndexArray = new short[this.entryCount];
        for (int i = 0; i < this.glyphIndexArray.length; ++i) {
            this.glyphIndexArray[i] = byteBuffer.getShort();
            this.glyphLookup.put(new Short(this.glyphIndexArray[i]), new Short((short)(i + this.firstCode)));
        }
    }

    @Override
    public ByteBuffer getData() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getLength());
        byteBuffer.putShort(this.getFormat());
        byteBuffer.putShort(this.getLength());
        byteBuffer.putShort(this.getLanguage());
        byteBuffer.putShort(this.firstCode);
        byteBuffer.putShort(this.entryCount);
        for (int i = 0; i < this.glyphIndexArray.length; ++i) {
            byteBuffer.putShort(this.glyphIndexArray[i]);
        }
        byteBuffer.flip();
        return byteBuffer;
    }
}

