/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.HeadTable;
import com.sun.pdfview.font.ttf.MaxpTable;
import com.sun.pdfview.font.ttf.TrueTypeFont;
import com.sun.pdfview.font.ttf.TrueTypeTable;
import java.nio.ByteBuffer;

public class LocaTable
extends TrueTypeTable {
    private boolean isLong;
    private int[] offsets;

    protected LocaTable(TrueTypeFont trueTypeFont) {
        super(1819239265);
        MaxpTable maxpTable = (MaxpTable)trueTypeFont.getTable("maxp");
        int n = maxpTable.getNumGlyphs();
        HeadTable headTable = (HeadTable)trueTypeFont.getTable("head");
        short s = headTable.getIndexToLocFormat();
        this.isLong = s == 1;
        this.offsets = new int[n + 1];
    }

    public int getOffset(int n) {
        return this.offsets[n];
    }

    public int getSize(int n) {
        return this.offsets[n + 1] - this.offsets[n];
    }

    public boolean isLongFormat() {
        return this.isLong;
    }

    @Override
    public ByteBuffer getData() {
        int n = this.getLength();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        for (int i = 0; i < this.offsets.length; ++i) {
            if (this.isLongFormat()) {
                byteBuffer.putInt(this.offsets[i]);
                continue;
            }
            byteBuffer.putShort((short)(this.offsets[i] / 2));
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public void setData(ByteBuffer byteBuffer) {
        for (int i = 0; i < this.offsets.length; ++i) {
            this.offsets[i] = this.isLongFormat() ? byteBuffer.getInt() : 2 * (0xFFFF & byteBuffer.getShort());
        }
    }

    @Override
    public int getLength() {
        if (this.isLongFormat()) {
            return this.offsets.length * 4;
        }
        return this.offsets.length * 2;
    }
}

