/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.CmapTable;
import com.sun.pdfview.font.ttf.GlyfTable;
import com.sun.pdfview.font.ttf.HeadTable;
import com.sun.pdfview.font.ttf.HheaTable;
import com.sun.pdfview.font.ttf.HmtxTable;
import com.sun.pdfview.font.ttf.LocaTable;
import com.sun.pdfview.font.ttf.MaxpTable;
import com.sun.pdfview.font.ttf.NameTable;
import com.sun.pdfview.font.ttf.PostTable;
import com.sun.pdfview.font.ttf.TrueTypeFont;
import java.nio.ByteBuffer;

public class TrueTypeTable {
    public static final int CMAP_TABLE = 1668112752;
    public static final int GLYF_TABLE = 1735162214;
    public static final int HEAD_TABLE = 1751474532;
    public static final int HHEA_TABLE = 1751672161;
    public static final int HMTX_TABLE = 1752003704;
    public static final int MAXP_TABLE = 1835104368;
    public static final int NAME_TABLE = 1851878757;
    public static final int POST_TABLE = 1886352244;
    public static final int LOCA_TABLE = 1819239265;
    private int tag;
    private ByteBuffer data;

    protected TrueTypeTable(int n) {
        this.tag = n;
    }

    public static TrueTypeTable createTable(TrueTypeFont trueTypeFont, String string) {
        return TrueTypeTable.createTable(trueTypeFont, string, null);
    }

    public static TrueTypeTable createTable(TrueTypeFont trueTypeFont, String string, ByteBuffer byteBuffer) {
        TrueTypeTable trueTypeTable = null;
        int n = TrueTypeTable.stringToTag(string);
        switch (n) {
            case 1668112752: {
                trueTypeTable = new CmapTable();
                break;
            }
            case 1735162214: {
                trueTypeTable = new GlyfTable(trueTypeFont);
                break;
            }
            case 1751474532: {
                trueTypeTable = new HeadTable();
                break;
            }
            case 1751672161: {
                trueTypeTable = new HheaTable();
                break;
            }
            case 1752003704: {
                trueTypeTable = new HmtxTable(trueTypeFont);
                break;
            }
            case 1819239265: {
                trueTypeTable = new LocaTable(trueTypeFont);
                break;
            }
            case 1835104368: {
                trueTypeTable = new MaxpTable();
                break;
            }
            case 1851878757: {
                trueTypeTable = new NameTable();
                break;
            }
            case 1886352244: {
                trueTypeTable = new PostTable();
                break;
            }
            default: {
                trueTypeTable = new TrueTypeTable(n);
            }
        }
        if (byteBuffer != null) {
            trueTypeTable.setData(byteBuffer);
        }
        return trueTypeTable;
    }

    public int getTag() {
        return this.tag;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void setData(ByteBuffer byteBuffer) {
        this.data = byteBuffer;
    }

    public int getLength() {
        return this.getData().remaining();
    }

    public static String tagToString(int n) {
        char[] cArray = new char[]{(char)(0xFF & n >> 24), (char)(0xFF & n >> 16), (char)(0xFF & n >> 8), (char)(0xFF & n)};
        return new String(cArray);
    }

    public static int stringToTag(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length != 4) {
            throw new IllegalArgumentException("Bad tag length: " + string);
        }
        return cArray[0] << 24 | cArray[1] << 16 | cArray[2] << 8 | cArray[3];
    }

    public String toString() {
        String string = "    " + TrueTypeTable.tagToString(this.getTag()) + " Table.  Data is: ";
        string = this.getData() == null ? string + "not set" : string + "set";
        return string;
    }
}

