/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import javax.imageio.stream.ImageInputStream;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.jpedal.Display;
import org.jpedal.FileAccess;
import org.jpedal.PDFtoImageConvertor;
import org.jpedal.PageOffsets;
import org.jpedal.SingleDisplay;
import org.jpedal.SwingPainter;
import org.jpedal.examples.viewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.viewer.gui.swing.SwingMouseFunctionality;
import org.jpedal.examples.viewer.gui.swing.SwingMouseListener;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ColorHandler;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.external.ImageHelper;
import org.jpedal.external.JPedalHelper;
import org.jpedal.external.RenderChangeListener;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.PdfReader;
import org.jpedal.io.StatusBar;
import org.jpedal.linear.LinearParser;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.acroforms.rendering.DefaultAcroRenderer;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.outlines.OutlineData;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.structuredtext.MarkedContentGenerator;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.DecoderResults;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.SwingPrinter;
import org.jpedal.parser.XFAStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.SwingDisplay;
import org.jpedal.text.TextLines;
import org.jpedal.utils.DPIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.w3c.dom.Document;

public class PdfDecoder
extends JPanel {
    private static final long serialVersionUID = 9083244515021854449L;
    private static boolean newXFACode;
    public static final String version = "4.92b23-OS";
    public static final int TEXT = 1;
    public static final int RAWIMAGES = 2;
    public static final int FINALIMAGES = 4;
    protected static final int PAGEDATA = 8;
    public static final int RAWCOMMANDS = 16;
    public static final int CLIPPEDIMAGES = 32;
    public static final int TEXTCOLOR = 64;
    public static final int CMYKIMAGES = 128;
    public static final int XFORMMETADATA = 256;
    public static final int COLOR = 512;
    public static final int RENDERTEXT = 1;
    public static final int RENDERIMAGES = 2;
    public static final int REMOVE_RENDERSHAPES = 16;
    public static final int REMOVE_NOFORMS = 32;
    public static final int OCR_PDF = 32;
    public static final int NOTEXTPRINT = 0;
    public static final int TEXTGLYPHPRINT = 1;
    public static final int TEXTSTRINGPRINT = 2;
    public static final int STANDARDTEXTSTRINGPRINT = 3;
    public static final int SUBSTITUTE_FONT_USING_FILE_NAME = 1;
    public static final int SUBSTITUTE_FONT_USING_POSTSCRIPT_NAME = 2;
    public static final int SUBSTITUTE_FONT_USING_FAMILY_NAME = 3;
    public static final int SUBSTITUTE_FONT_USING_FULL_FONT_NAME = 4;
    public static final int SUBSTITUTE_FONT_USING_POSTSCRIPT_NAME_USE_FAMILY_NAME_IF_DUPLICATES = 5;
    public boolean generatingThumbnail = false;
    public static float javaVersion;
    public static float highlightComposite;
    public static boolean showMouseBox;
    public static int dpi;
    public static boolean embedWidthData;
    public static JPedalHelper Helper;
    DecoderOptions options = new DecoderOptions();
    SwingPainter swingPainter = new SwingPainter(this, this.options);
    public SwingPrinter swingPrinter = new SwingPrinter();
    FileAccess fileAcces = new FileAccess();
    LinearParser linearParser = new LinearParser();
    private DPIFactory scalingdpi = new DPIFactory();
    ExternalHandlers externalHandlers = new ExternalHandlers();
    public boolean useNewGraphicsMode = true;
    protected Display pages = null;
    protected AcroRenderer formRenderer;
    private PageOffsets currentOffset;
    protected boolean renderPage = false;
    protected int displayView = 1;
    private int scrollInterval = 10;
    protected int pageCount = 0;
    boolean isNewRotationSet = false;
    protected boolean isDecoding = false;
    public int pageNumber = 1;
    protected int alignment = 1;
    public int displayRotation = 0;
    protected AffineTransform displayScaling;
    private PdfPageData pageData = new PdfPageData();
    public int insetW = 0;
    public int insetH = 0;
    int x_size = 100;
    int y_size = 100;
    int max_y;
    int max_x;
    public float scaling = 1.0f;
    protected Border myBorder = null;
    public ObjectStore objectStoreRef = new ObjectStore(null);
    protected DynamicVectorRenderer currentDisplay = new SwingDisplay(1, this.objectStoreRef, false);
    protected boolean useAcceleration = true;
    public PdfObjectReader currentPdfFile;
    private boolean isBackgroundDecoding = false;
    private PdfImageData pdfImages = new PdfImageData();
    private PdfImageData pdfBackgroundImages = new PdfImageData();
    private PdfData pdfData;
    private PdfData pdfBackgroundData;
    private RefreshLayout viewListener = null;
    private Graphics2D g2 = null;
    private String fontsInFile = "";
    private String imagesInFile = "";
    private float multiplyer = 1.0f;
    private int extractionMode = 7;
    protected int renderMode = 7;
    PdfResources res = new PdfResources();
    protected StatusBar statusBar = null;
    boolean useHiResImageForDisplay = true;
    String filename;
    private int lastPageDecoded = -1;
    private boolean closeOnExit = true;
    public static boolean showErrorMessages;
    protected int specialMode = -1;
    private boolean isOpen = false;
    public int textPrint = 0;
    private int minimumCacheSize = -1;
    String decodeStatus = "";
    private DecoderResults resultsFromDecode = new DecoderResults();
    private Object customSwingHandle;
    private Object userExpressionEngine;
    private boolean generateGlyphOnRender;
    BufferedImage printImage = null;
    private Cursor defaultCursor = null;
    private TextLines textLines = new TextLines();

    public boolean isOpen() {
        return this.isOpen;
    }

    public Document getMarkedContent() {
        return new MarkedContentGenerator().getMarkedContentTree(this.res, this.pageData, this.currentPdfFile);
    }

    public void setPageData(PdfPageData pageData) {
        this.pageData = pageData;
    }

    public int getlastPageDecoded() {
        return this.lastPageDecoded;
    }

    public Iterator getPageInfo(int type) {
        return this.resultsFromDecode.getPageInfo(type);
    }

    public OutlineData getOutlineData() {
        return this.res.getOutlineData();
    }

    public boolean isLoadingLinearizedPDF() {
        return false;
    }

    protected void resetMultiPageForms(int page) {
        this.swingPainter.resetMultiPageForms(page, this, this.formRenderer, this.pages);
    }

    public void resetViewableArea() {
        this.swingPainter.resetViewableArea(this, this.pageData);
    }

    public AffineTransform setViewableArea(Rectangle viewport) throws PdfException {
        return this.swingPainter.setViewableArea(viewport, this, this.pageData);
    }

    public int getPageAlignment() {
        return this.alignment;
    }

    public static void init(boolean newEmbedWidthData) {
        embedWidthData = newEmbedWidthData;
    }

    public PdfDecoder(boolean newRender) {
        this.pages = new SingleDisplay(this);
        this.renderPage = newRender;
        this.startup();
        if (this.renderPage) {
            this.setLayout(null);
            this.setPreferredSize(new Dimension(100, 100));
        }
    }

    private void startup() {
        this.formRenderer = new DefaultAcroRenderer();
        this.formRenderer.resetHandler(null, this, 5);
        if (!FontMappings.fontsInitialised) {
            FontMappings.initFonts();
            FontMappings.fontsInitialised = true;
        }
    }

    public PdfDecoder() {
        this.pages = new SingleDisplay(this);
        this.renderPage = true;
        this.setLayout(null);
        this.startup();
        this.setPreferredSize(new Dimension(100, 100));
    }

    public static void disposeAllStatic() {
        StandardFonts.dispose();
        FontMappings.dispose();
    }

    public final void dispose() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.disposeObjects();
        } else {
            Runnable doPaintComponent = new Runnable(){

                @Override
                public void run() {
                    PdfDecoder.this.disposeObjects();
                }
            };
            SwingUtilities.invokeLater(doPaintComponent);
        }
    }

    private final void disposeObjects() {
        FontMappings.fontsInitialised = false;
        this.options.disposeObjects();
        if (this.viewListener != null) {
            this.viewListener.dispose();
        }
        if (this.pdfData != null) {
            this.pdfData.dispose();
        }
        this.pdfData = null;
        if (this.pages != null) {
            this.pages.dispose();
        }
        this.pages = null;
        FontMappings.defaultFont = null;
        if (this.currentDisplay != null) {
            this.currentDisplay.dispose();
        }
        this.currentDisplay = null;
        if (this.currentPdfFile != null) {
            this.currentPdfFile.dispose();
        }
        this.currentPdfFile = null;
        if (this.formRenderer != null) {
            this.formRenderer.dispose();
        }
        this.formRenderer = null;
    }

    public final void closePdfFile() {
        if (!this.isOpen) {
            return;
        }
        this.isOpen = false;
        this.waitForDecodingToFinish();
        this.linearParser.closePdfFile();
        this.displayScaling = null;
        this.lastPageDecoded = -1;
        if (this.pages != null) {
            this.pages.stopGeneratingPage();
        }
        this.pages.disableScreen();
        this.swingPrinter.clear();
        if (this.formRenderer != null) {
            this.formRenderer.openFile(this.pageCount);
            this.formRenderer.resetFormData(this.insetW, this.insetH, this.pageData, this.currentPdfFile, this.res.getPdfObject(1));
            this.formRenderer.removeDisplayComponentsFromScreen();
        }
        if (this.viewListener != null) {
            this.pages.flushPageCaches();
            this.removeComponentListener(this.viewListener);
            this.viewListener.dispose();
            this.viewListener = null;
        }
        if (this.currentPdfFile != null && this.closeOnExit) {
            this.currentPdfFile.closePdfFile();
            this.currentPdfFile = null;
        }
        this.pages.disableScreen();
        this.currentDisplay.flush();
        ObjectStore.flushPages();
        this.objectStoreRef.flush();
        this.pageCount = 0;
        this.res.flushObjects();
        this.setDisplayView(1, 2);
        if (SwingUtilities.isEventDispatchThread()) {
            this.validate();
        } else {
            Runnable doPaintComponent = new Runnable(){

                @Override
                public void run() {
                    PdfDecoder.this.validate();
                }
            };
            SwingUtilities.invokeLater(doPaintComponent);
        }
    }

    public final PdfData getPdfBackgroundData() {
        return this.pdfBackgroundData;
    }

    public final PdfData getPdfData() throws PdfException {
        if ((this.extractionMode & 1) == 0) {
            throw new PdfException("[PDF] Page data object requested will be empty as text extraction disabled. Enable with PdfDecoder method setExtractionMode(PdfDecoder.TEXT | other values");
        }
        return this.pdfData;
    }

    public final boolean hasOutline() {
        return this.res.hasOutline();
    }

    public final Document getOutlineAsXML() {
        return this.res.getOutlineAsXML(this.currentPdfFile, this.pageCount);
    }

    public final PdfPageData getPdfPageData() {
        return this.pageData;
    }

    public void setPagePrintRange(int start, int end) throws PdfException {
        this.swingPrinter.setPagePrintRange(start, end, this.pageCount);
    }

    public void setTextPrint(int textPrint) {
        this.textPrint = textPrint;
    }

    public void setJavaScriptUsed(boolean jsEnabled) {
        this.options.setJavaScriptUsed(jsEnabled);
    }

    public void useLogicalPrintOffset(int pagesPrinted) {
        this.swingPrinter.useLogicalPrintOffset(pagesPrinted);
    }

    public BufferedImage getPageAsImage(int pageIndex) throws PdfException {
        return this.getPageAsImage(pageIndex, false);
    }

    public BufferedImage getPageAsTransparentImage(int pageIndex) throws PdfException {
        return this.getPageAsImage(pageIndex, true);
    }

    private BufferedImage getPageAsImage(int pageIndex, boolean imageIsTransparent) throws PdfException {
        BufferedImage image = null;
        if (pageIndex > this.pageCount || pageIndex < 1) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Page " + pageIndex + " not in range");
            }
        } else {
            if (this.currentPdfFile == null) {
                throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
            }
            String currentPageOffset = this.currentPdfFile.getReferenceforPage(pageIndex);
            if (currentPageOffset != null) {
                PDFtoImageConvertor PDFtoImage;
                if (!this.generatingThumbnail) {
                    PDFtoImage = new PDFtoImageConvertor(this.multiplyer, this.options);
                    if (this.currentDisplay.getValue(18) == 2 || this.currentDisplay.getValue(18) == 3) {
                        PDFtoImage.setHTMLInvisibleTextHandler(this.currentDisplay);
                    }
                } else {
                    PDFtoImage = new PDFtoImageConvertor(1.0f, this.options);
                }
                image = PDFtoImage.convert(this.resultsFromDecode, this.displayRotation, this.res, this.displayView, this.externalHandlers, this.renderMode, this.pageData, this.formRenderer, this.scaling, this.currentPdfFile, pageIndex, imageIsTransparent, currentPageOffset);
                this.multiplyer = PDFtoImage.getMultiplyer();
                if (this.pages != null) {
                    this.formRenderer.getCompData().resetScaledLocation(this.pages.getOldScaling(), this.displayRotation, 0);
                }
            }
            if (!DecoderOptions.isRunningOnAIX && !imageIsTransparent && image != null) {
                image = ColorSpaceConvertor.convertToRGB(image);
            }
        }
        return image;
    }

    public float getHiResUpscaleFactor() {
        return this.multiplyer;
    }

    public final void flushObjectValues(boolean reinit) {
        if (this.pdfData != null) {
            this.pdfData.flushTextList(reinit);
        }
        if (this.pdfImages != null && reinit) {
            this.pdfImages.clearImageData();
        }
    }

    public final PdfImageData getPdfImageData() {
        return this.pdfImages;
    }

    public final PdfImageData getPdfBackgroundImageData() {
        return this.pdfBackgroundImages;
    }

    public final void setRenderMode(int mode) {
        this.renderMode = mode;
        this.extractionMode = mode;
    }

    public final void setExtractionMode(int mode) {
        this.extractionMode = mode;
    }

    public final PdfFileInformation getFileInformationData() {
        return this.res.getMetaData(this.currentPdfFile);
    }

    public final void setExtractionMode(int mode, float scaling) {
        block3: {
            boolean layersChanged;
            this.scaling = scaling;
            this.pageData.setScalingValue(scaling);
            this.extractionMode = mode;
            PdfLayerList layers = this.res.getPdfLayerList();
            if (layers != null && (layersChanged = layers.setZoom(scaling))) {
                try {
                    this.decodePage(-1);
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
    }

    @Deprecated
    public final void setExtractionMode(int mode, int imageDpi, float scaling) {
        block4: {
            boolean layersChanged;
            if (dpi % 72 != 0 && LogWriter.isOutput()) {
                LogWriter.writeLog("Dpi is not a factor of 72- this may cause problems");
            }
            dpi = imageDpi;
            this.scaling = scaling;
            this.pageData.setScalingValue(scaling);
            this.extractionMode = mode;
            PdfLayerList layers = this.res.getPdfLayerList();
            if (layers != null && (layersChanged = layers.setZoom(scaling))) {
                try {
                    this.decodePage(-1);
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block4;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
    }

    public DPIFactory getDPIFactory() {
        return this.scalingdpi;
    }

    public final void setPageParameters(float scaling, int pageNumber) {
        block13: {
            boolean layersChanged;
            PdfLayerList layers;
            this.pageNumber = pageNumber;
            this.multiplyer = 1.0f;
            if (this.displayView == 5 && scaling == -100.0f) {
                return;
            }
            if (scaling > 0.0f) {
                this.scaling = scaling;
            } else {
                scaling = this.scaling;
            }
            if (this.pages != null) {
                this.pages.setScaling(scaling);
            }
            if ((layers = this.res.getPdfLayerList()) != null && (layersChanged = layers.setZoom(this.scalingdpi.removeScaling(scaling)))) {
                try {
                    this.decodePage(-1);
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block13;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        this.pageData.setScalingValue(scaling);
        int mediaW = this.pageData.getMediaBoxWidth(pageNumber);
        this.max_y = this.pageData.getMediaBoxHeight(pageNumber);
        this.max_x = this.pageData.getMediaBoxWidth(pageNumber);
        int cropW = this.pageData.getCropBoxWidth(pageNumber);
        int cropH = this.pageData.getCropBoxHeight(pageNumber);
        this.x_size = (int)((float)cropW * scaling);
        this.y_size = (int)((float)cropH * scaling);
        if (!this.isNewRotationSet && this.displayView != 5) {
            this.displayRotation = this.pageData.getRotation(pageNumber);
        } else {
            this.isNewRotationSet = false;
        }
        this.currentDisplay.init(mediaW, this.max_y, this.displayRotation, this.options.getPageColor());
        if (this.currentDisplay.getType() != 4 && this.currentDisplay.getType() != 5 && this.currentDisplay.getType() != 6) {
            this.currentDisplay.setValue(1, this.options.getPageColor().getRGB());
            if (this.options.getTextColor() != null) {
                this.currentDisplay.setValue(2, this.options.getTextColor().getRGB());
                if (this.options.getChangeTextAndLine()) {
                    this.currentDisplay.setValue(3, 1);
                } else {
                    this.currentDisplay.setValue(3, 0);
                }
            }
        }
        this.swingPainter.setPageRotation(this.displayRotation, this.pageData);
        this.formRenderer.getCompData().setForceRedraw(true);
    }

    public final void setPageParameters(float scaling, int pageNumber, int newRotation) {
        this.isNewRotationSet = true;
        this.displayRotation = newRotation;
        if (this.displayView == 5) {
            this.pages.init(0.0f, 0, this.displayRotation, 0, null, false, null, 0, 0);
        } else {
            this.setPageParameters(scaling, pageNumber);
        }
    }

    public void setStatusBarObject(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    public void waitForDecodingToFinish() {
        while (this.isDecoding) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
                this.isDecoding = false;
            }
        }
    }

    public void updatePageNumberDisplayed(int page) {
        if (page != -1 && this.customSwingHandle != null) {
            ((GUIFactory)this.customSwingHandle).setPage(page);
        }
    }

    public DynamicVectorRenderer getDynamicRenderer() {
        return this.currentDisplay;
    }

    public DynamicVectorRenderer getDynamicRenderer(boolean reset) {
        DynamicVectorRenderer latestVersion = this.currentDisplay;
        if (reset) {
            this.currentDisplay = new SwingDisplay(0, this.objectStoreRef, false);
        }
        return latestVersion;
    }

    public void setPDFCursor(Cursor c) {
        if (SingleDisplay.allowChangeCursor) {
            this.setCursor(c);
        }
    }

    public void setDefaultCursor(Cursor c) {
        this.defaultCursor = c;
        if (SingleDisplay.allowChangeCursor) {
            this.setCursor(c);
        }
    }

    @Override
    public void setCursor(Cursor c) {
        if (SingleDisplay.allowChangeCursor) {
            if (c.getType() == 0 && this.defaultCursor != null) {
                super.setCursor(this.defaultCursor);
            } else {
                super.setCursor(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decodePage(int rawPage) throws PdfException {
        block40: {
            Object customDVR = this.externalHandlers.getExternalHandler(20);
            if (customDVR != null) {
                this.currentDisplay = (DynamicVectorRenderer)customDVR;
            }
            boolean isForm = false;
            boolean isDuplicate = false;
            if (rawPage == -1) {
                rawPage = this.lastPageDecoded;
                isDuplicate = true;
            }
            boolean isSamePage = false;
            if (rawPage == this.lastPageDecoded) {
                isSamePage = true;
            }
            int page = rawPage;
            if (this.isDecoding) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[PDF]WARNING - this file is being decoded already - use  waitForDecodingToFinish() to check");
                }
            } else {
                boolean isPageAvailable = this.isPageAvailable(rawPage);
                PdfObject pdfObject = this.linearParser.getLinearPageObject();
                if (!isPageAvailable) {
                    this.isDecoding = false;
                    return;
                }
                if (isPageAvailable && pdfObject != null) {
                    this.isDecoding = true;
                    this.readAllPageReferences(true, pdfObject, new HashMap(1000), new HashMap(1000), rawPage);
                }
                this.resultsFromDecode.resetTimeout();
                try {
                    this.isDecoding = true;
                    PdfLayerList layers = this.res.getPdfLayerList();
                    if (layers != null && layers.getChangesMade()) {
                        this.lastPageDecoded = -1;
                        layers.setChangesMade(false);
                        this.formRenderer.getCompData().setForceRedraw(true);
                        this.formRenderer.getCompData().setLayerData(layers);
                        this.formRenderer.getCompData().resetScaledLocation(this.scaling, this.displayRotation, (int)this.swingPainter.getIndent());
                    }
                    if (this.displayView != 1) {
                        this.isDecoding = false;
                        return;
                    }
                    this.lastPageDecoded = page;
                    this.decodeStatus = "";
                    this.swingPainter.setCursorBoxOnScreen(null, isSamePage, this.formRenderer);
                    this.currentDisplay.flush();
                    this.pages.refreshDisplay();
                    if (page > this.pageCount || page < 1) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("Page out of bounds");
                        }
                        this.isDecoding = false;
                        break block40;
                    }
                    Timer t = null;
                    if (this.statusBar != null) {
                        ProgressListener listener = new ProgressListener();
                        t = new Timer(150, listener);
                        t.start();
                    }
                    this.pageNumber = page;
                    String currentPageOffset = this.currentPdfFile.getReferenceforPage(page);
                    if (currentPageOffset != null && this.currentPdfFile == null) {
                        throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
                    }
                    if (pdfObject == null) {
                        pdfObject = new PageObject(currentPageOffset);
                        this.currentPdfFile.readObject(pdfObject);
                        this.currentPdfFile.checkParentForResources(pdfObject);
                    }
                    PdfStreamDecoder current = null;
                    if (pdfObject != null) {
                        byte[][] pageContents = pdfObject.getKeyArray(1216184967);
                        current = this.getFormRenderer().isXFA() && newXFACode ? new XFAStreamDecoder(this.currentPdfFile, this.useHiResImageForDisplay, this.res.getPdfLayerList(), this.getFormRenderer()) : new PdfStreamDecoder(this.currentPdfFile, this.useHiResImageForDisplay, this.res.getPdfLayerList());
                        current.setXMLExtraction(this.options.isXMLExtraction());
                        this.currentDisplay.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
                        this.currentDisplay.setPrintPage(page);
                        this.currentDisplay.setCustomColorHandler((ColorHandler)this.externalHandlers.getExternalHandler(19));
                        current.setParameters(true, this.renderPage, this.renderMode, this.extractionMode);
                        this.externalHandlers.addHandlers(current);
                        current.setObjectValue(-9, this.filename);
                        current.setIntValue(-10, page);
                        current.setObjectValue(-8, this.objectStoreRef);
                        current.setObjectValue(-3, this.statusBar);
                        current.setObjectValue(-18, this.pageData);
                        current.setObjectValue(23, this.currentDisplay);
                        if (pageContents != null) {
                            block41: {
                                this.res.setupResources(current, false, pdfObject.getDictionary(2004251818), this.pageNumber, this.currentPdfFile);
                                if (this.g2 != null) {
                                    current.setObjectValue(-7, this.g2);
                                }
                                this.currentDisplay.init(this.pageData.getMediaBoxWidth(this.pageNumber), this.pageData.getMediaBoxHeight(this.pageNumber), this.pageData.getRotation(this.pageNumber), this.options.getPageColor());
                                if (this.currentDisplay.getType() != 4 && this.currentDisplay.getType() != 5 && this.currentDisplay.getType() != 6 && this.options.getTextColor() != null) {
                                    this.currentDisplay.setValue(2, this.options.getTextColor().getRGB());
                                    if (this.options.getChangeTextAndLine()) {
                                        this.currentDisplay.setValue(3, 1);
                                    } else {
                                        this.currentDisplay.setValue(3, 0);
                                    }
                                    this.currentDisplay.setValue(4, this.options.getReplacementColorThreshold());
                                }
                                try {
                                    if (this.textLines != null) {
                                        this.textLines.setLineAreas(null);
                                    }
                                    current.decodePageContent(pdfObject);
                                    if (this.textLines != null && this.extractionMode > 0) {
                                        Vector_Rectangle vr = (Vector_Rectangle)current.getObjectValue(-21);
                                        vr.trim();
                                        Rectangle[] pageTextAreas = vr.get();
                                        Vector_Int vi = (Vector_Int)current.getObjectValue(22);
                                        vi.trim();
                                        int[] pageTextDirections = vi.get();
                                        for (int k = 0; k != pageTextAreas.length; ++k) {
                                            this.textLines.addToLineAreas(pageTextAreas[k], pageTextDirections[k], page);
                                        }
                                    }
                                }
                                catch (Error err) {
                                    this.decodeStatus = this.decodeStatus + "Error in decoding page " + err.toString();
                                }
                                catch (Exception e) {
                                    if (!e.getMessage().contains("JPeg 2000")) break block41;
                                    this.decodeStatus = this.decodeStatus + "Error in decoding page " + e.toString();
                                }
                            }
                            this.fontsInFile = (String)current.getObjectValue(373243460);
                            this.imagesInFile = (String)current.getObjectValue(1026635598);
                            this.pdfData = (PdfData)current.getObjectValue(-19);
                            this.pdfImages = (PdfImageData)current.getObjectValue(-20);
                            this.resultsFromDecode.update(current, true);
                        } else if (this.currentDisplay.getType() == 4 || this.currentDisplay.getType() == 5) {
                            int mediaW = this.pageData.getMediaBoxWidth(this.pageNumber);
                            int mediaH = this.pageData.getMediaBoxHeight(this.pageNumber);
                            int rotation = this.pageData.getRotation(this.pageNumber);
                            this.currentDisplay.init(mediaW, mediaH, rotation, this.options.getPageColor());
                        }
                    }
                    if (t != null) {
                        t.stop();
                        this.statusBar.setProgress(100);
                    }
                    if (this.renderPage && !isDuplicate && this.formRenderer != null && !this.formRenderer.ignoreForms() && this.formRenderer.hasFormsOnPage(page)) {
                        boolean runDirect = false;
                        if ((this.renderMode & 0x20) != 32) {
                            this.createFormComponents(page, current);
                        }
                        this.isDecoding = false;
                    }
                }
                finally {
                    if (!isForm) {
                        this.isDecoding = false;
                        if (this.statusBar != null) {
                            this.statusBar.percentageDone = 100.0f;
                        }
                    } else {
                        this.waitForDecodingToFinish();
                    }
                }
            }
        }
        if (TTGlyph.redecodePage) {
            TTGlyph.redecodePage = false;
            this.decodePage(rawPage);
        }
        this.currentDisplay.flagDecodingFinished();
    }

    public synchronized boolean isPageAvailable(int rawPage) {
        return this.linearParser.isPageAvailable(rawPage, this.currentPdfFile);
    }

    void createFormComponents(int page, PdfStreamDecoder current) {
        if (this.currentDisplay.getType() == 6) {
            return;
        }
        if (this.currentOffset != null) {
            this.formRenderer.getCompData().setPageValues(this.scaling, this.displayRotation, (int)this.swingPainter.getIndent(), 0, 0, 1, this.currentOffset.widestPageNR, this.currentOffset.widestPageR);
        }
        this.formRenderer.createDisplayComponentsForPage(page, current);
    }

    public void printAdditionalObjectsOverPage(int page, int[] type, Color[] colors, Object[] obj) throws PdfException {
        this.swingPrinter.printAdditionalObjectsOverPage(page, type, colors, obj);
    }

    public void printAdditionalObjectsOverAllPages(int[] type, Color[] colors, Object[] obj) throws PdfException {
        this.swingPrinter.printAdditionalObjectsOverAllPages(type, colors, obj);
    }

    public void useHiResScreenDisplay(boolean value) {
        this.useHiResImageForDisplay = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void decodePageInBackground(int i) {
        if (this.isDecoding) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("[PDF]WARNING - this file is being decoded already in foreground");
                LogWriter.writeLog("[PDF]Multiple access not recommended - use  waitForDecodingToFinish() to check");
            }
        } else if (this.isBackgroundDecoding) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("[PDF]WARNING - this file is being decoded already in background");
            }
        } else {
            try {
                this.isBackgroundDecoding = true;
                if (i > this.pageCount) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Page out of bounds");
                    }
                } else {
                    String currentPageOffset = this.currentPdfFile.getReferenceforPage(i);
                    if (currentPageOffset != null) {
                        if (this.currentPdfFile == null) {
                            throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
                        }
                        PageObject pdfObject = new PageObject(currentPageOffset);
                        this.currentPdfFile.readObject(pdfObject);
                        PdfObject Resources = ((PdfObject)pdfObject).getDictionary(2004251818);
                        if (pdfObject != null) {
                            ObjectStore backgroundObjectStoreRef = new ObjectStore((ImageHelper)this.externalHandlers.getExternalHandler(27));
                            PdfStreamDecoder backgroundDecoder = new PdfStreamDecoder(this.currentPdfFile);
                            backgroundDecoder.setParameters(true, false, 0, this.extractionMode);
                            backgroundDecoder.setXMLExtraction(this.options.isXMLExtraction());
                            this.externalHandlers.addHandlers(backgroundDecoder);
                            backgroundDecoder.setObjectValue(-9, this.filename);
                            backgroundDecoder.setObjectValue(-8, backgroundObjectStoreRef);
                            backgroundDecoder.setObjectValue(-18, this.pageData);
                            backgroundDecoder.setIntValue(-10, i);
                            this.res.setupResources(backgroundDecoder, false, Resources, this.pageNumber, this.currentPdfFile);
                            backgroundDecoder.decodePageContent(pdfObject);
                            this.pdfBackgroundData = (PdfData)backgroundDecoder.getObjectValue(-19);
                            this.pdfBackgroundImages = (PdfImageData)backgroundDecoder.getObjectValue(-20);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            finally {
                this.isBackgroundDecoding = false;
            }
        }
    }

    public final int getPageCount() {
        return this.pageCount;
    }

    public final boolean isEncrypted() {
        if (this.currentPdfFile != null) {
            PdfFileReader objectReader = this.currentPdfFile.getObjectReader();
            DecryptionFactory decryption = objectReader.getDecryptionObject();
            return decryption != null && decryption.getBooleanValue(101);
        }
        return false;
    }

    public final boolean isPasswordSupplied() {
        FileAccess fileAccess = (FileAccess)this.getJPedalObject(0x6F6A6AAF);
        return fileAccess.isPasswordSupplied(this.currentPdfFile);
    }

    public boolean isFileViewable() {
        FileAccess fileAccess = (FileAccess)this.getJPedalObject(0x6F6A6AAF);
        return fileAccess.isFileViewable(this.currentPdfFile);
    }

    public boolean isExtractionAllowed() {
        if (this.currentPdfFile != null) {
            PdfFileReader objectReader = this.currentPdfFile.getObjectReader();
            DecryptionFactory decryption = objectReader.getDecryptionObject();
            return decryption == null || decryption.getBooleanValue(103);
        }
        return false;
    }

    private void verifyAccess() {
        block3: {
            if (this.currentPdfFile != null) {
                try {
                    this.openPdfFile();
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception " + e + " opening file");
                }
            }
        }
    }

    public final void setEncryptionPassword(String password) throws PdfException {
        if (this.currentPdfFile == null) {
            throw new PdfException("Must open PdfDecoder file first");
        }
        this.currentPdfFile.getObjectReader().setPassword(password);
        this.verifyAccess();
    }

    public final void openPdfArray(byte[] data) throws PdfException {
        if (data == null) {
            throw new RuntimeException("Attempting to open null byte stream");
        }
        if (this.isOpen) {
            this.closePdfFile();
        }
        this.isOpen = false;
        this.res.flush();
        try {
            this.currentPdfFile = new PdfReader();
            this.currentPdfFile.openPdfFile(data);
            this.openPdfFile();
            this.objectStoreRef.storeFileName("r" + System.currentTimeMillis());
        }
        catch (Exception e) {
            throw new PdfException("[PDF] OpenPdfArray generated exception " + e.getMessage());
        }
    }

    public void openPdfFile(String filename, Certificate certificate, PrivateKey key) throws PdfException {
        this.fileAcces.setUserEncryption(certificate, key);
        this.openPdfFile(filename);
    }

    public final void openPdfFileFromStream(Object filename, String password) throws PdfException {
        ImageInputStream iis;
        this.closeOnExit = false;
        if (filename instanceof ImageInputStream) {
            iis = (ImageInputStream)filename;
            if (this.isOpen) {
                this.closePdfFile();
            }
        } else {
            throw new RuntimeException(filename + " not currently an option");
        }
        this.isOpen = false;
        this.displayScaling = null;
        this.filename = "ImageInputStream" + System.currentTimeMillis();
        this.res.flush();
        this.objectStoreRef.storeFileName(this.filename);
        this.currentPdfFile = new PdfReader(password);
        this.currentPdfFile.openPdfFile(iis);
        this.openPdfFile();
    }

    public final void openPdfFile(String filename) throws PdfException {
        if (this.isOpen && this.linearParser.linearizedBackgroundReaderer == null) {
            this.closePdfFile();
        }
        this.isOpen = false;
        this.displayScaling = null;
        this.filename = filename;
        this.res.flush();
        this.objectStoreRef.storeFileName(filename);
        this.currentPdfFile = this.fileAcces.getNewReader();
        this.currentPdfFile.openPdfFile(filename);
        this.openPdfFile();
    }

    public final void openPdfFile(String filename, String password) throws PdfException {
        if (this.isOpen) {
            this.closePdfFile();
        }
        this.isOpen = false;
        this.displayScaling = null;
        this.filename = filename;
        this.res.flush();
        this.objectStoreRef.storeFileName(filename);
        this.currentPdfFile = new PdfReader(password);
        this.currentPdfFile.openPdfFile(filename);
        this.openPdfFile();
    }

    public final boolean openPdfFileFromURL(String pdfUrl, boolean supportLinearized) throws PdfException {
        String rawFileName;
        InputStream is;
        block2: {
            is = null;
            rawFileName = null;
            try {
                URL url = new URL(pdfUrl);
                rawFileName = url.getPath().substring(url.getPath().lastIndexOf(47) + 1);
                is = url.openStream();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return this.readFile(supportLinearized, is, rawFileName, null);
    }

    public final boolean openPdfFileFromURL(String pdfUrl, boolean supportLinearized, String password) throws PdfException {
        String rawFileName;
        InputStream is;
        block2: {
            is = null;
            rawFileName = null;
            try {
                URL url = new URL(pdfUrl);
                rawFileName = url.getPath().substring(url.getPath().lastIndexOf(47) + 1);
                is = url.openStream();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return this.readFile(supportLinearized, is, rawFileName, password);
    }

    public final boolean openPdfFileFromInputStream(InputStream is, boolean supportLinearized) throws PdfException {
        String rawFileName = "inputstream" + System.currentTimeMillis() + '-' + this.objectStoreRef.getKey() + ".pdf";
        this.objectStoreRef.setFileToDeleteOnFlush(ObjectStore.temp_dir + rawFileName);
        this.objectStoreRef.setFileToDeleteOnFlush(rawFileName);
        return this.readFile(supportLinearized, is, rawFileName, null);
    }

    public final boolean openPdfFileFromInputStream(InputStream is, boolean supportLinearized, String password) throws PdfException {
        String rawFileName = "inputstream" + System.currentTimeMillis() + '-' + this.objectStoreRef.getKey() + ".pdf";
        this.objectStoreRef.setFileToDeleteOnFlush(ObjectStore.temp_dir + rawFileName);
        this.objectStoreRef.setFileToDeleteOnFlush(rawFileName);
        return this.readFile(supportLinearized, is, rawFileName, password);
    }

    private boolean readFile(boolean supportLinearized, InputStream is, String rawFileName, String password) throws PdfException {
        this.displayScaling = null;
        this.res.flush();
        this.currentPdfFile = password == null ? new PdfReader() : new PdfReader(password);
        if (is != null) {
            try {
                File tempURLFile;
                if (rawFileName.startsWith("inputstream")) {
                    tempURLFile = new File(ObjectStore.temp_dir + rawFileName);
                    this.filename = tempURLFile.getAbsolutePath();
                } else {
                    tempURLFile = ObjectStore.createTempFile(rawFileName);
                }
                int separatorIndex = tempURLFile.getName().lastIndexOf(46);
                String storeFilename = separatorIndex >= 0 ? tempURLFile.getName().substring(0, tempURLFile.getName().lastIndexOf(46)) : tempURLFile.getName();
                this.objectStoreRef.storeFileName(storeFilename);
                if (supportLinearized) {
                    byte[] linearBytes = this.linearParser.readLinearData(this.currentPdfFile, tempURLFile, is, this);
                    if (linearBytes != null) {
                        this.currentPdfFile.openPdfFile(linearBytes);
                        this.openPdfFile();
                        this.linearParser.linearizedBackgroundReaderer.start();
                        return true;
                    }
                } else {
                    this.currentPdfFile.openPdfFile(is);
                    this.openPdfFile();
                }
                if (supportLinearized) {
                    this.openPdfFile(tempURLFile.getAbsolutePath());
                    separatorIndex = tempURLFile.getName().lastIndexOf(46);
                    storeFilename = separatorIndex >= 0 ? tempURLFile.getName().substring(0, tempURLFile.getName().lastIndexOf(46)) : tempURLFile.getName();
                    this.objectStoreRef.storeFileName(storeFilename);
                }
            }
            catch (IOException e) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[PDF] Exception " + e + " opening URL ");
                }
                e.printStackTrace();
            }
        }
        return false;
    }

    private synchronized void openPdfFile() throws PdfException {
        this.pageNumber = 1;
        this.swingPainter.forceRedraw();
        try {
            this.isDecoding = true;
            this.pages.resetCachedValues();
            if (this.viewListener != null) {
                this.pages.flushPageCaches();
                this.removeComponentListener(this.viewListener);
                this.viewListener.dispose();
                this.viewListener = null;
            }
            this.currentPdfFile.getObjectReader().setCacheSize(this.minimumCacheSize);
            this.swingPrinter.lastPrintedPage = -1;
            this.swingPrinter.currentPrintDecoder = null;
            if (this.formRenderer != null) {
                this.formRenderer.getCompData().setRootDisplayComponent(this);
            }
            this.pageData = new PdfPageData();
            String pdfVersion = this.currentPdfFile.getObjectReader().getType();
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Pdf version : " + pdfVersion);
            }
            if (pdfVersion == null) {
                this.currentPdfFile = null;
                this.isDecoding = false;
                throw new PdfException("No version on first line ");
            }
            PdfObject pdfObject = null;
            int linearPageCount = -1;
            if (this.linearParser.hasLinearData()) {
                pdfObject = this.linearParser.readHintTable(pdfObject, this.currentPdfFile);
                linearPageCount = this.linearParser.getPageCount();
            } else {
                pdfObject = this.currentPdfFile.getObjectReader().readReferenceTable(null);
            }
            boolean ignoreRecursion = true;
            if (!this.isEncrypted() || this.isPasswordSupplied()) {
                PdfObject pageObj;
                int type;
                if (pdfObject != null) {
                    pdfObject.ignoreRecursion(true);
                    this.res.setValues(pdfObject, this.currentPdfFile);
                    PdfObject nameObj = pdfObject.getDictionary(826094945);
                    if (nameObj != null) {
                        this.currentPdfFile.readNames(nameObj, this.options.getJS(), false);
                    }
                }
                if ((type = pdfObject.getParameterConstant(608780341)) != 540096309 && (pageObj = pdfObject.getDictionary(825701731)) != null) {
                    pdfObject = new PageObject(pageObj.getObjectRefAsString());
                    this.currentPdfFile.readObject(pdfObject);
                    if (pdfObject.getParameterConstant(608780341) == -1) {
                        pdfObject = pageObj;
                    }
                }
                if (pdfObject != null) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Pages being read from " + pdfObject + ' ' + pdfObject.getObjectRefAsString());
                    }
                    this.pageNumber = 1;
                    if (this.formRenderer != null) {
                        this.formRenderer.resetAnnotData(this.insetW, this.insetH, this.pageData, 1, this.currentPdfFile, null);
                    }
                    int tempPageCount = this.readAllPageReferences(true, pdfObject, new HashMap(1000), new HashMap(1000), 1);
                    this.pageCount = linearPageCount > 0 ? linearPageCount : tempPageCount - 1;
                    this.pageNumber = 0;
                    if (this.pageCount == 0 && LogWriter.isOutput()) {
                        LogWriter.writeLog("No pages found");
                    }
                }
                if (this.formRenderer != null) {
                    this.formRenderer.openFile(this.pageCount);
                    this.formRenderer.resetFormData(this.insetW, this.insetH, this.pageData, this.currentPdfFile, this.res.getPdfObject(1));
                }
            }
            this.currentOffset = null;
            this.pages.disableScreen();
            this.pages.stopGeneratingPage();
            this.displayView = this.pageCount < 2 ? 1 : this.options.getPageMode();
            this.setDisplayView(this.displayView, this.alignment);
            this.isOpen = true;
        }
        catch (PdfException e) {
            this.isDecoding = false;
            this.isOpen = true;
            this.closePdfFile();
            this.isOpen = false;
            this.isDecoding = false;
            throw new PdfException(e.getMessage() + " opening file");
        }
        this.isDecoding = false;
    }

    public Object getJPedalObject(int id) {
        switch (id) {
            case 826881374: {
                return this.res.getPdfLayerList();
            }
            case 2004845231: {
                return this.linearParser.getLinearObject(this.isOpen, this.currentPdfFile);
            }
            case -1276915978: {
                return this.linearParser.linearizedBackgroundReaderer;
            }
            case 0x6F6A6AAF: {
                return this.fileAcces;
            }
        }
        return null;
    }

    public void setPageMode(int mode) {
        this.options.setPageMode(mode);
    }

    private int readAllPageReferences(boolean ignoreRecursion, PdfObject pdfObject, Map rotations, Map parents, int tempPageCount) {
        String currentPageOffset = pdfObject.getObjectRefAsString();
        boolean debug = false;
        int rotation = 0;
        int type = pdfObject.getParameterConstant(608780341);
        if (type == -1) {
            type = 825701731;
        }
        int rawRotation = pdfObject.getInt(1144088180);
        String parent = pdfObject.getStringKey(1110793845);
        if (rawRotation == -1) {
            while (parent != null && rawRotation == -1) {
                Object savedRotation;
                if (parent != null && (savedRotation = rotations.get(parent)) != null) {
                    rawRotation = (Integer)savedRotation;
                }
                if (rawRotation != -1) continue;
                parent = (String)parents.get(parent);
            }
            if (rawRotation != -1) {
                rotations.put(currentPageOffset, rawRotation);
                parents.put(currentPageOffset, parent);
            }
        } else {
            rotations.put(currentPageOffset, rawRotation);
            parents.put(currentPageOffset, parent);
        }
        if (rawRotation != -1) {
            rotation = rawRotation;
        }
        this.pageData.setPageRotation(rotation, tempPageCount);
        float[] mediaBox = pdfObject.getFloatArray(1313305473);
        float[] cropBox = pdfObject.getFloatArray(1076199815);
        if (mediaBox != null) {
            this.pageData.setMediaBox(mediaBox);
        }
        if (cropBox != null) {
            this.pageData.setCropBox(cropBox);
        }
        if (type == 825701731) {
            this.res.setPdfObject(2, pdfObject.getDictionary(2004251818));
            byte[][] kidList = pdfObject.getKeyArray(456733763);
            int kidCount = 0;
            if (kidList != null) {
                kidCount = kidList.length;
            }
            if (kidCount > 0) {
                for (int ii = 0; ii < kidCount; ++ii) {
                    PageObject nextObject = new PageObject(new String(kidList[ii]));
                    nextObject.ignoreRecursion(ignoreRecursion);
                    nextObject.ignoreStream(true);
                    this.currentPdfFile.readObject(nextObject);
                    tempPageCount = this.readAllPageReferences(ignoreRecursion, nextObject, rotations, parents, tempPageCount);
                }
            }
        } else if (type == 540096309) {
            this.currentPdfFile.setLookup(currentPageOffset, tempPageCount);
            this.pageData.checkSizeSet(tempPageCount);
            if (this.formRenderer != null) {
                byte[][] annotList = pdfObject.getKeyArray(1044338049);
                if (annotList != null && annotList.length == 1 && annotList[0] == null) {
                    annotList = null;
                }
                if (annotList != null) {
                    this.formRenderer.resetAnnotData(this.insetW, this.insetH, this.pageData, tempPageCount, this.currentPdfFile, annotList);
                }
            }
            ++tempPageCount;
        }
        return tempPageCount;
    }

    public boolean isXMLExtraction() {
        return this.options.isXMLExtraction();
    }

    public void useTextExtraction() {
        this.options.setXMLExtraction(false);
    }

    public void useXMLExtraction() {
        this.options.setXMLExtraction(true);
    }

    public void clearScreen() {
        this.currentDisplay.flush();
        this.pages.refreshDisplay();
    }

    public void setStreamCacheSize(int size) {
        this.minimumCacheSize = size;
    }

    public boolean hasEmbeddedFonts() {
        return this.resultsFromDecode.hasEmbeddedFonts();
    }

    public final boolean PDFContainsEmbeddedFonts() throws PdfException {
        boolean hasEmbeddedFonts = false;
        PdfStreamDecoder current = new PdfStreamDecoder(this.currentPdfFile);
        for (int page = 1; page < this.pageCount + 1; ++page) {
            String currentPageOffset = this.currentPdfFile.getReferenceforPage(page);
            if (currentPageOffset == null) continue;
            PageObject pdfObject = new PageObject(currentPageOffset);
            pdfObject.ignoreStream(true);
            this.currentPdfFile.readObject(pdfObject);
            byte[][] pageContents = ((PdfObject)pdfObject).getKeyArray(1216184967);
            if (pageContents == null) continue;
            this.res.setupResources(current, false, ((PdfObject)pdfObject).getDictionary(2004251818), this.pageNumber, this.currentPdfFile);
            hasEmbeddedFonts = current.getBooleanValue(-1);
            if (!hasEmbeddedFonts) continue;
            page = this.pageCount;
        }
        return hasEmbeddedFonts;
    }

    public int getPageFromObjectRef(String ref) {
        return this.currentPdfFile.convertObjectToPageNumber(ref);
    }

    public String getInfo(int type) {
        String returnValue;
        switch (type) {
            case 373243460: {
                if (this.fontsInFile == null) {
                    returnValue = "No fonts defined";
                    break;
                }
                returnValue = this.fontsInFile;
                break;
            }
            case 1026635598: {
                if (this.imagesInFile == null) {
                    returnValue = "No images defined as XObjects";
                    break;
                }
                returnValue = this.imagesInFile;
                break;
            }
            default: {
                returnValue = null;
            }
        }
        return returnValue;
    }

    public AcroRenderer getFormRenderer() {
        return this.formRenderer;
    }

    public boolean isPageSuccessful() {
        return this.swingPrinter.isPageSuccessful();
    }

    public String getPageDecodeReport() {
        return this.decodeStatus;
    }

    public String getPageFailureMessage() {
        return this.swingPrinter.getPageFailureMessage();
    }

    public BufferedImage getSelectedRectangleOnscreen(float t_x1, float t_y1, float t_x2, float t_y2, float scaling) {
        BufferedImage img = SwingPainter.getSelectedRectangleOnscreen(t_x1, t_y1, t_x2, t_y2, scaling, this.pageNumber, this.pageData, this.formRenderer, this.currentDisplay, this.currentPdfFile);
        this.formRenderer.getCompData().resetScaledLocation(this.pages.getOldScaling(), this.displayRotation, 0);
        return img;
    }

    public ObjectStore getObjectStore() {
        return this.objectStoreRef;
    }

    public void setObjectStore(ObjectStore newStore) {
        this.objectStoreRef = newStore;
    }

    public DecoderOptions getDecoderOptions() {
        return this.options;
    }

    public PdfGroupingAlgorithms getGroupingObject() throws PdfException {
        return this.options.getGroupingObject(this.lastPageDecoded, this.getPdfData(), this.pageData);
    }

    public PdfGroupingAlgorithms getBackgroundGroupingObject() {
        return this.options.getBackgroundGroupingObject(this.pdfBackgroundData, this.pageData);
    }

    public final String getPDFVersion() {
        if (this.currentPdfFile == null) {
            return "";
        }
        return this.currentPdfFile.getObjectReader().getType();
    }

    public void resetForNonPDFPage(int pageCount) {
        this.displayScaling = null;
        this.currentDisplay.setHiResImageForDisplayMode(false);
        this.fontsInFile = "";
        this.pageCount = pageCount;
        if (this.formRenderer != null) {
            this.formRenderer.removeDisplayComponentsFromScreen();
        }
        this.pageData = new PdfPageData();
    }

    public void setDisplayView(int displayView, int orientation) {
        boolean needsReset;
        this.alignment = orientation;
        if (this.pages != null) {
            this.pages.stopGeneratingPage();
        }
        boolean bl = needsReset = displayView != 1 || this.displayView != 1;
        if (needsReset && (this.displayView == 3 || displayView == 3)) {
            needsReset = false;
        }
        if (displayView != 1) {
            needsReset = true;
        }
        boolean hasChanged = displayView != this.displayView;
        int lastDisplayView = this.displayView;
        this.displayView = displayView;
        switch (displayView) {
            case 1: {
                if (this.pages != null && !hasChanged) break;
                this.pages = new SingleDisplay(this.pageNumber, this.pageCount, this.currentDisplay);
            }
        }
        if (this.viewListener != null) {
            this.removeComponentListener(this.viewListener);
            this.viewListener.dispose();
            this.viewListener = null;
        }
        if (this.currentOffset == null) {
            this.currentOffset = new PageOffsets(this.pageCount, this.pageData);
        }
        this.pages.setup(this.useAcceleration, this.currentOffset, this);
        this.pages.init(this.scaling, this.pageCount, this.displayRotation, this.pageNumber, this.currentDisplay, true, this.pageData, this.insetW, this.insetH);
        this.swingPainter.forceRedraw();
        this.pages.refreshDisplay();
        if (this.viewListener == null) {
            this.viewListener = new RefreshLayout();
            this.addComponentListener(this.viewListener);
        }
        if (this.pageNumber > 0) {
            if (hasChanged && displayView == 1) {
                try {
                    this.unsetScaling();
                    this.setPageParameters(this.scaling, this.pageNumber, this.displayRotation);
                    this.invalidate();
                    this.updateUI();
                    this.decodePage(this.pageNumber);
                }
                catch (Exception e) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
            } else if (displayView != 1 && displayView != 5) {
                throw new RuntimeException("Only SINGLE_PAGE is available in LGPL release");
            }
        }
    }

    public boolean hasAllImages() {
        return this.resultsFromDecode.getImagesProcessedFully();
    }

    public boolean getPageDecodeStatus(int status) {
        return this.resultsFromDecode.getPageDecodeStatus(status);
    }

    public String getPageDecodeStatusReport(int status) {
        return this.resultsFromDecode.getPageDecodeStatusReport(status);
    }

    public void setPrintAutoRotateAndCenter(boolean value) {
        this.swingPrinter.isPrintAutoRotateAndCenter = value;
    }

    public void setPrintCurrentView(boolean value) {
        this.swingPrinter.printOnlyVisible = value;
    }

    public void addExternalHandler(Object newHandler, int type) {
        switch (type) {
            case 3: {
                this.formRenderer.setFormFactory((FormFactory)newHandler);
                break;
            }
            case 4: {
                this.customSwingHandle = newHandler;
                break;
            }
            case 5: {
                if (this.formRenderer == null) break;
                this.formRenderer.resetHandler(newHandler, this, 5);
                break;
            }
            case 10: {
                if (this.formRenderer == null) break;
                this.formRenderer.getActionHandler().setMouseHandler((SwingMouseListener)newHandler);
                break;
            }
            case 26: {
                SwingMouseListener.setCustomMouseFunctions((SwingMouseFunctionality)newHandler);
                break;
            }
            case 8: {
                this.pages.setThumbnailPanel((GUIThumbnailPanel)newHandler);
                break;
            }
            default: {
                this.externalHandlers.addExternalHandler(newHandler, type);
            }
        }
    }

    public Object getExternalHandler(int type) {
        switch (type) {
            case 3: {
                return this.formRenderer.getFormFactory();
            }
            case 4: {
                return this.customSwingHandle;
            }
            case 16: {
                return this.pages;
            }
            case 17: {
                return this.currentOffset;
            }
        }
        return this.externalHandlers.getExternalHandler(type);
    }

    public void unsetScaling() {
        this.displayScaling = null;
    }

    public PdfObjectReader getIO() {
        return this.currentPdfFile;
    }

    public String getFileName() {
        return this.filename;
    }

    public boolean isForm() {
        return this.res.isForm();
    }

    public String getReferenceforPage(int page) {
        return this.currentPdfFile.getReferenceforPage(page);
    }

    public void setAllowDifferentPrintPageSizes(boolean allowDifferentPrintPageSizes) {
        this.swingPrinter.allowDifferentPrintPageSizes = allowDifferentPrintPageSizes;
    }

    public TextLines getTextLines() {
        return this.textLines;
    }

    public final void setInset(int width, int height) {
        this.insetW = width;
        this.insetH = height;
    }

    public void ensurePointIsVisible(Point p) {
        super.scrollRectToVisible(new Rectangle(p.x, this.y_size - p.y, this.scrollInterval, this.scrollInterval));
    }

    public void setPrintIndent(int oddPages, int evenPages) {
        this.swingPrinter.setPrintIndent(oddPages, evenPages);
    }

    public void setUserOffsets(int x, int y, int mode) {
        this.swingPainter.getDisplayOffsets().setUserOffsets(x, y, mode, this.externalHandlers, this);
    }

    public Point getUserOffsets(int mode) {
        return this.swingPainter.getDisplayOffsets().getUserOffsets(mode);
    }

    @Override
    public final Dimension getMaximumSize() {
        Dimension pageSize = null;
        if (this.displayView != 1) {
            pageSize = this.pages.getPageSize(this.displayView);
        }
        if (pageSize == null) {
            pageSize = this.displayRotation == 90 || this.displayRotation == 270 ? new Dimension(this.y_size + this.insetW + this.insetW, this.x_size + this.insetH + this.insetH) : new Dimension(this.x_size + this.insetW + this.insetW, this.y_size + this.insetH + this.insetH);
        }
        if (pageSize == null) {
            pageSize = this.getMinimumSize();
        }
        return pageSize;
    }

    @Override
    public final Dimension getMinimumSize() {
        return new Dimension(100 + this.insetW, 100 + this.insetH);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    public final void updateCursorBoxOnScreen(Rectangle newOutlineRectangle, Color outlineColor) {
        if (this.displayView != 1) {
            return;
        }
        this.swingPainter.updateCursorBoxOnScreen(newOutlineRectangle, outlineColor, this, this.pageNumber);
    }

    @Override
    public void paint(Graphics g) {
        try {
            super.paint(g);
            if (!this.isDecoding) {
                this.swingPainter.drawCursor(g, this.alignment);
            }
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            this.pages.flushPageCaches();
        }
        catch (Error err) {
            this.pages.flushPageCaches();
            this.pages.stopGeneratingPage();
            super.paint(g);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        final RenderChangeListener customRenderChangeListener = (RenderChangeListener)this.externalHandlers.getExternalHandler(21);
        if (customRenderChangeListener != null) {
            customRenderChangeListener.renderingStarted(this.pageNumber);
        }
        super.paintComponent(g);
        if (SwingUtilities.isEventDispatchThread()) {
            this.threadSafePaint(g);
            if (customRenderChangeListener != null) {
                customRenderChangeListener.renderingEnded(this.pageNumber);
            }
        } else {
            final Graphics g2 = g;
            final int page = this.pageNumber;
            Runnable doPaintComponent = new Runnable(){

                @Override
                public void run() {
                    PdfDecoder.this.threadSafePaint(g2);
                    if (customRenderChangeListener != null) {
                        customRenderChangeListener.renderingEnded(page);
                    }
                }
            };
            SwingUtilities.invokeLater(doPaintComponent);
        }
    }

    synchronized void threadSafePaint(Graphics g) {
        if (this.displayScaling == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (!this.isDecoding && this.renderPage) {
            this.swingPainter.paintPage(g2, this, this.pages, this.pageData, this.pageNumber, this.currentDisplay, this.displayView, this.displayRotation, this.insetW, this.insetH, this.textLines, this.myBorder, this.currentOffset, this.externalHandlers);
        } else {
            this.currentDisplay.setG2(g2);
            this.currentDisplay.paintBackground(null);
        }
    }

    public final int getPDFWidth() {
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            return this.y_size + this.insetW + this.insetW;
        }
        return this.x_size + this.insetW + this.insetW;
    }

    public final int getPDFHeight() {
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            return this.x_size + this.insetH + this.insetH;
        }
        return this.y_size + this.insetH + this.insetH;
    }

    public final void setPDFBorder(Border newBorder) {
        this.myBorder = newBorder;
    }

    public void setHardwareAccelerationforScreen(boolean useAcceleration) {
        this.useAcceleration = useAcceleration;
    }

    public int getScrollInterval() {
        return this.scrollInterval;
    }

    public void setScrollInterval(int scrollInterval) {
        this.scrollInterval = scrollInterval;
    }

    public int getDisplayView() {
        return this.displayView;
    }

    public void setPrintPageScalingMode(int pageScalingMode) {
        this.swingPrinter.setPrintPageScalingMode(pageScalingMode);
    }

    public void setUsePDFPaperSize(boolean usePDFPaperSize) {
        this.swingPrinter.usePDFPaperSize = usePDFPaperSize;
    }

    public float getScaling() {
        return this.scaling;
    }

    public int getInsetH() {
        return this.insetH;
    }

    public int getInsetW() {
        return this.insetW;
    }

    public Rectangle getCursorBoxOnScreen() {
        return this.swingPainter.getCursorBoxOnScreen();
    }

    public int getNumberOfPages() {
        return this.swingPrinter.getNumberOfPages(this.pageCount);
    }

    public PageFormat getPageFormat(int p) throws IndexOutOfBoundsException {
        return this.swingPrinter.getPageFormat(p, this.pageData, this.pageCount);
    }

    public void setCenterOnScaling(boolean center) {
        this.swingPrinter.setCenterOnScaling(center);
    }

    public void setPageFormat(int p, PageFormat pf) {
        this.swingPrinter.putPageFormat(p, pf);
    }

    public void setPageFormat(PageFormat pf) {
        this.swingPrinter.putPageFormat("standard", pf);
    }

    public void setPagePrintRange(SetOfIntegerSyntax range) throws PdfException {
        if (range == null) {
            throw new PdfException("[PDF] null page range entered");
        }
        this.swingPrinter.setPagePrintRange(range, this.pageCount);
    }

    public void setPrintPageMode(int mode) {
        this.swingPrinter.setPrintPageMode(mode);
    }

    public final void stopPrinting() {
        this.swingPrinter.stopPrinting();
    }

    public int getCurrentPrintPage() {
        return this.swingPrinter.getCurrentPrintPage();
    }

    public void resetCurrentPrintPage() {
        this.swingPrinter.currentPrintPage = 0;
        this.formRenderer.getCompData().resetAfterPrinting();
    }

    static {
        block12: {
            block11: {
                newXFACode = false;
                javaVersion = 0.0f;
                highlightComposite = 0.35f;
                showMouseBox = false;
                dpi = 72;
                embedWidthData = false;
                Helper = null;
                try {
                    String name = System.getProperty("os.name");
                    if (name.equals("Mac OS X")) {
                        DecoderOptions.isRunningOnMac = true;
                    } else if (name.startsWith("Windows")) {
                        DecoderOptions.isRunningOnWindows = true;
                    } else if (name.startsWith("AIX")) {
                        DecoderOptions.isRunningOnAIX = true;
                    } else if (name.equals("Linux")) {
                        DecoderOptions.isRunningOnLinux = true;
                    }
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block11;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            try {
                javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block12;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        showErrorMessages = false;
    }

    private class ProgressListener
    implements ActionListener {
        private ProgressListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PdfDecoder.this.statusBar.setProgress((int)PdfDecoder.this.statusBar.percentageDone);
        }
    }

    private class RefreshLayout
    extends ComponentAdapter
    implements Serializable {
        private static final long serialVersionUID = 5332414763142396868L;
        java.util.Timer t2 = null;

        private RefreshLayout() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.startTimer();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.startTimer();
        }

        private void startTimer() {
            if (this.t2 != null) {
                this.t2.cancel();
            }
            PageListener listener = new PageListener();
            this.t2 = new java.util.Timer();
            this.t2.schedule((TimerTask)listener, 500L);
        }

        public void dispose() {
            if (this.t2 != null) {
                this.t2.cancel();
            }
        }

        class PageListener
        extends TimerTask {
            PageListener() {
            }

            @Override
            public void run() {
                try {
                    if (PdfDecoder.this.pages != null) {
                        PdfDecoder.this.pages.stopGeneratingPage();
                        if (PdfDecoder.this.pageNumber < 1) {
                            PdfDecoder.this.pageNumber = 1;
                        }
                        if (PdfDecoder.this.pages != null) {
                            PdfDecoder.this.pages.decodeOtherPages(PdfDecoder.this.pageNumber, PdfDecoder.this.pageCount);
                        }
                    }
                }
                catch (Exception ee) {
                    LogWriter.writeLog("Exception in run() " + ee.getMessage());
                }
            }
        }
    }
}

