/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.border.Border;
import org.jpedal.Display;
import org.jpedal.PageOffsets;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.external.RenderChangeListener;
import org.jpedal.objects.PdfPageData;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;

public class SingleDisplay
implements Display {
    public static boolean allowChangeCursor = true;
    public static boolean default_turnoverOn = true;
    public boolean turnoverOn = default_turnoverOn;
    public static boolean default_separateCover = true;
    public boolean separateCover = default_separateCover;
    private int[] highlightedImage = null;
    BufferedImage previewImage = null;
    String previewText;
    boolean isGeneratingOtherPages = false;
    BufferedImage[] facingDragCachedImages = new BufferedImage[4];
    BufferedImage facingDragTempLeftImg;
    BufferedImage facingDragTempRightImg;
    int facingDragTempLeftNo;
    int facingDragTempRightNo;
    protected Map keyToFilename = new HashMap();
    Rectangle userAnnot = null;
    AffineTransform rawAf;
    Shape rawClip;
    DynamicVectorRenderer currentDisplay;
    boolean running = false;
    protected PageOffsets currentOffset;
    RenderChangeListener customRenderChangeListener;
    protected int volatileWidth;
    protected int volatileHeight;
    int startViewPage = 0;
    int endViewPage = 0;
    Map pagesDrawn = new HashMap();
    Map cachedPageViews = new WeakHashMap();
    Map currentPageViews = new HashMap();
    boolean screenNeedsRedrawing;
    PdfDecoder pdf;
    protected Vector_Int offsets = new Vector_Int(3);
    protected Map newPages = new HashMap();
    protected int currentXOffset = 0;
    protected int additionalPageCount = 0;
    float oldScaling = -1.0f;
    float oldRotation = -1.0f;
    float oldVolatileWidth = -1.0f;
    float oldVolatileHeight = -1.0f;
    int indent = 0;
    int[] xReached;
    int[] yReached;
    int[] pageW;
    int[] pageH;
    protected int[] pageOffsetH;
    protected int[] pageOffsetW;
    boolean[] isRotated;
    Map accleratedPagesAlreadyDrawn = new HashMap();
    boolean overRideAcceleration = false;
    private boolean message = false;
    int displayRotation;
    int displayView = 1;
    int lastDisplayRotation = 0;
    int insetW;
    int insetH;
    float scaling;
    float lastScaling;
    int pageNumber;
    int pageCount = 0;
    PdfPageData pageData = null;
    Graphics2D g2;
    Map areas;
    private int lastAreasPainted = -1;
    boolean useAcceleration = true;
    boolean isInitialised;
    int rx = 0;
    int ry = 0;
    int rw = 0;
    int rh = 0;
    private int crx;
    private int cry;
    private int crw;
    private int crh;
    AffineTransform current2 = null;
    Shape currentClip = null;
    protected Border myBorder;
    public static int CURRENT_BORDER_STYLE = 1;
    VolatileImage backBuffer = null;
    int topW;
    int topH;
    double cropX;
    double cropY;
    double cropW;
    double cropH;
    protected GUIThumbnailPanel thumbnails = null;

    public SingleDisplay(int pageNumber, int pageCount, DynamicVectorRenderer currentDisplay) {
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        this.pageNumber = pageNumber;
        this.pageCount = pageCount;
        this.currentDisplay = currentDisplay;
    }

    public SingleDisplay(PdfDecoder pdf) {
        this.pdf = pdf;
    }

    public static void setBorderStyle(int style) {
        CURRENT_BORDER_STYLE = style;
    }

    public static int getBorderStyle() {
        return CURRENT_BORDER_STYLE;
    }

    @Override
    public void setObjectValue(int type, Object newHandler) {
        switch (type) {
            case 21: {
                this.customRenderChangeListener = (RenderChangeListener)newHandler;
                break;
            }
            default: {
                throw new RuntimeException("setObjectValue does not take value " + type);
            }
        }
    }

    @Override
    public void clearAdditionalPages() {
        this.offsets.clear();
        this.newPages.clear();
        this.currentXOffset = 0;
        this.additionalPageCount = 0;
    }

    @Override
    public void addAdditionalPage(DynamicVectorRenderer dynamicRenderer, int pageWidth, int origPageWidth) {
        this.offsets.addElement(this.currentXOffset + origPageWidth);
        this.newPages.put(this.currentXOffset + origPageWidth, dynamicRenderer);
        ++this.additionalPageCount;
        this.currentXOffset += pageWidth;
        this.oldScaling = -this.oldScaling;
        this.refreshDisplay();
    }

    @Override
    public void dispose() {
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.keyToFilename.clear();
        this.currentOffset = null;
        this.areas = null;
        this.pageH = null;
        this.pageW = null;
        this.cachedPageViews = null;
        this.isRotated = null;
        this.backBuffer = null;
        this.accleratedPagesAlreadyDrawn = null;
    }

    protected void createBackBuffer() {
        block24: {
            boolean debugBackBuffer = false;
            if (this.backBuffer != null) {
                this.backBuffer.flush();
                this.backBuffer = null;
            }
            int width = 0;
            int height = 0;
            if (this.displayView == 1) {
                if (this.displayRotation == 90 | this.displayRotation == 270) {
                    width = this.volatileHeight + this.currentXOffset;
                    height = this.volatileWidth;
                } else {
                    width = this.volatileWidth + this.currentXOffset;
                    height = this.volatileHeight;
                }
            } else if (this.currentOffset != null) {
                int biggestFacingHeight = 0;
                if (this.displayView == 3 && this.pageW != null) {
                    int p2;
                    int p1;
                    if (this.separateCover) {
                        p1 = this.pageNumber;
                        if ((p1 & 1) == 1) {
                            --p1;
                        }
                        p2 = p1 + 1;
                    } else {
                        p1 = this.pageNumber;
                        if ((p1 & 1) == 0) {
                            --p1;
                        }
                        p2 = p1 + 1;
                    }
                    biggestFacingHeight = this.pageH[p1];
                    if (p2 < this.pageH.length && biggestFacingHeight < this.pageH[p2]) {
                        biggestFacingHeight = this.pageH[p2];
                    }
                }
                int gaps = this.currentOffset.gaps;
                int doubleGaps = this.currentOffset.doubleGaps;
                switch (this.displayView) {
                    case 3: {
                        int firstW = (this.displayRotation + this.pdf.getPdfPageData().getRotation(this.pageNumber)) % 180 == 90 ? this.pdf.getPdfPageData().getCropBoxHeight(this.pageNumber) : this.pdf.getPdfPageData().getCropBoxWidth(this.pageNumber);
                        int secondW = this.pageNumber + 1 > this.pageCount || this.pageNumber == 1 && this.pageCount != 2 ? firstW : ((this.displayRotation + this.pdf.getPdfPageData().getRotation(this.pageNumber + 1)) % 180 == 90 ? this.pdf.getPdfPageData().getCropBoxHeight(this.pageNumber + 1) : this.pdf.getPdfPageData().getCropBoxWidth(this.pageNumber + 1));
                        int totalW = firstW + secondW;
                        width = (int)((float)totalW * this.scaling) + 10;
                        height = biggestFacingHeight;
                        break;
                    }
                    case 2: {
                        if (this.displayRotation == 90 | this.displayRotation == 270) {
                            width = (int)((float)this.currentOffset.biggestHeight * this.scaling);
                            height = (int)((float)this.currentOffset.totalSingleWidth * this.scaling) + gaps + this.insetH;
                            break;
                        }
                        width = (int)((float)this.currentOffset.biggestWidth * this.scaling);
                        height = (int)((float)this.currentOffset.totalSingleHeight * this.scaling) + gaps + this.insetH;
                        break;
                    }
                    case 4: {
                        if (this.displayRotation == 90 | this.displayRotation == 270) {
                            width = (int)((float)this.currentOffset.doublePageHeight * this.scaling) + this.insetW * 2 + doubleGaps;
                            height = (int)((float)this.currentOffset.totalDoubleWidth * this.scaling) + doubleGaps + this.insetH;
                            break;
                        }
                        width = (int)((float)this.currentOffset.doublePageWidth * this.scaling) + this.insetW * 2;
                        height = (int)((float)this.currentOffset.totalDoubleHeight * this.scaling) + doubleGaps + this.insetH;
                    }
                }
            }
            try {
                if (height > 15000) {
                    this.volatileHeight = 0;
                    height = 0;
                    this.overRideAcceleration = true;
                }
                if (width > 0 && height > 0) {
                    this.backBuffer = this.pdf.createVolatileImage(width, height);
                    this.oldVolatileWidth = this.volatileWidth;
                    this.oldVolatileHeight = this.volatileHeight;
                    Graphics2D gg = (Graphics2D)this.backBuffer.getGraphics();
                    gg.setPaint(this.pdf.getBackground());
                    gg.fillRect(0, 0, width, height);
                }
            }
            catch (Error e) {
                this.overRideAcceleration = true;
                this.backBuffer = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!LogWriter.isOutput()) break block24;
                LogWriter.writeLog("Exception " + e + " is display mode");
            }
        }
        this.currentDisplay.setOptimsePainting(true);
    }

    @Override
    public boolean isAccelerated() {
        return this.useAcceleration && !this.overRideAcceleration;
    }

    @Override
    public void resetCachedValues() {
    }

    @Override
    public void stopGeneratingPage() {
        this.isGeneratingOtherPages = false;
        while (this.running) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                if (!LogWriter.isOutput()) continue;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    @Override
    public void disableScreen() {
        this.isInitialised = false;
        this.oldScaling = -1.0f;
    }

    boolean testAcceleratedRendering() {
        boolean canDrawAccelerated = false;
        if (this.oldScaling != this.scaling || this.oldRotation != (float)this.displayRotation || this.oldVolatileWidth != (float)this.volatileWidth || this.oldVolatileHeight != (float)this.volatileHeight) {
            this.backBuffer = null;
            this.overRideAcceleration = false;
        }
        if (!this.overRideAcceleration && this.backBuffer == null) {
            this.createBackBuffer();
            this.accleratedPagesAlreadyDrawn.clear();
        }
        if (this.backBuffer != null) {
            do {
                int valCode = 2;
                if (this.backBuffer != null) {
                    valCode = this.backBuffer.validate(this.pdf.getGraphicsConfiguration());
                }
                if (valCode != 1 && valCode == 2 && !this.overRideAcceleration) {
                    this.createBackBuffer();
                }
                if (this.backBuffer == null) continue;
                canDrawAccelerated = true;
            } while (this.backBuffer == null || this.backBuffer.contentsLost());
        }
        return canDrawAccelerated;
    }

    @Override
    public Dimension getPageSize(int displayView) {
        Dimension pageSize = null;
        int biggestFacingHeight = 0;
        int facingWidth = 0;
        if (displayView == 3 && this.pageW != null) {
            int p2;
            int p1;
            if (this.separateCover) {
                p1 = this.pageNumber;
                if ((p1 & 1) == 1) {
                    --p1;
                }
                p2 = p1 + 1;
            } else {
                p1 = this.pageNumber;
                if ((p1 & 1) == 0) {
                    --p1;
                }
                p2 = p1 + 1;
            }
            if (p1 == 0) {
                biggestFacingHeight = this.pageH[p2];
                facingWidth = this.pageW[p2] * 2;
            } else {
                biggestFacingHeight = this.pageH[p1];
                if (p2 < this.pageH.length) {
                    if (biggestFacingHeight < this.pageH[p2]) {
                        biggestFacingHeight = this.pageH[p2];
                    }
                    facingWidth = this.pageW[p1] + this.pageW[p2];
                } else {
                    facingWidth = this.pageW[p1] * 2;
                }
            }
        }
        int gaps = this.currentOffset.gaps;
        int doubleGaps = this.currentOffset.doubleGaps;
        switch (displayView) {
            case 3: {
                pageSize = new Dimension(facingWidth + this.insetW + this.insetW, biggestFacingHeight + this.insetH + this.insetH);
                break;
            }
            case 2: {
                if (this.displayRotation == 90 | this.displayRotation == 270) {
                    pageSize = new Dimension((int)((float)this.currentOffset.biggestHeight * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.totalSingleWidth * this.scaling + (float)gaps + (float)this.insetH + (float)this.insetH));
                    break;
                }
                pageSize = new Dimension((int)((float)this.currentOffset.biggestWidth * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.totalSingleHeight * this.scaling + (float)gaps + (float)this.insetH + (float)this.insetH));
                break;
            }
            case 4: {
                if (this.displayRotation == 90 | this.displayRotation == 270) {
                    if (this.pageCount == 2) {
                        pageSize = new Dimension((int)((float)this.currentOffset.doublePageHeight * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.biggestWidth * this.scaling + (float)gaps + (float)this.insetH + (float)this.insetH));
                        break;
                    }
                    pageSize = new Dimension((int)((float)this.currentOffset.doublePageHeight * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.totalDoubleWidth * this.scaling + (float)doubleGaps + (float)this.insetH + (float)this.insetH));
                    break;
                }
                pageSize = this.pageCount == 2 ? new Dimension((int)((float)this.currentOffset.doublePageWidth * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.biggestHeight * this.scaling + (float)gaps + (float)this.insetH + (float)this.insetH)) : new Dimension((int)((float)this.currentOffset.doublePageWidth * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.totalDoubleHeight * this.scaling + (float)doubleGaps + (float)this.insetH + (float)this.insetH));
            }
        }
        return pageSize;
    }

    public Rectangle getDisplayedRectangle() {
        Rectangle userAnnot = this.pdf.getVisibleRect();
        this.rx = userAnnot.x;
        this.ry = userAnnot.y;
        this.rw = userAnnot.width;
        this.rh = userAnnot.height;
        if (this.pdf.isShowing() && userAnnot.width == 0 || userAnnot.height == 0) {
            this.rx = 0;
            this.ry = 0;
            this.rw = this.pageData.getScaledCropBoxWidth(this.pageNumber);
            this.rh = this.pageData.getScaledCropBoxHeight(this.pageNumber);
            if (this.pageData.getRotation(this.pageNumber) % 180 != 0) {
                this.rh = this.pageData.getScaledCropBoxWidth(this.pageNumber);
                this.rw = this.pageData.getScaledCropBoxHeight(this.pageNumber);
            }
        }
        return userAnnot;
    }

    @Override
    public void drawBorder() {
        if (CURRENT_BORDER_STYLE == 1 && this.crw > 0 && this.crh > 0 && this.myBorder != null) {
            this.myBorder.paintBorder(this.pdf, this.g2, this.crx - 1, this.cry - 1, this.crw + 1, this.crh + 1);
        }
    }

    void setDisplacementOnG2(Graphics2D gBB) {
        float cX = (float)this.crx / this.scaling;
        float cY = (float)this.cry / this.scaling;
        if (this.displayRotation == 0 || this.displayView != 1) {
            gBB.translate(-cX, cY);
        } else if (this.displayRotation == 90) {
            gBB.translate(-cY, -cX);
        } else if (this.displayRotation == 180) {
            gBB.translate(cX, -cY);
        } else if (this.displayRotation == 270) {
            gBB.translate(cY, cX);
        }
    }

    @Override
    public void refreshDisplay() {
        this.screenNeedsRedrawing = true;
        this.accleratedPagesAlreadyDrawn.clear();
        this.overRideAcceleration = false;
    }

    @Override
    public void flushPageCaches() {
        this.currentPageViews.clear();
        this.cachedPageViews.clear();
    }

    @Override
    public void init(float scaling, int pageCount, int displayRotation, int pageNumber, DynamicVectorRenderer currentDisplay, boolean isInit, PdfPageData pageData, int insetW, int insetH) {
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        this.currentDisplay = currentDisplay;
        this.scaling = scaling;
        this.pageCount = pageCount;
        this.displayRotation = displayRotation;
        this.pageNumber = pageNumber;
        this.pageData = pageData;
        this.insetW = insetW;
        this.insetH = insetH;
        currentDisplay.setInset(insetW, insetH);
        pageData.setScalingValue(scaling);
        this.volatileWidth = pageData.getScaledCropBoxWidth(this.pageNumber);
        this.volatileHeight = pageData.getScaledCropBoxHeight(this.pageNumber);
        if (isInit) {
            this.setPageOffsets(this.pageNumber);
            this.isInitialised = true;
        }
        if (this.displayView == 3 && (isInit || this.lastDisplayRotation != displayRotation || this.lastScaling != scaling)) {
            for (int i = 0; i < 4; ++i) {
                this.facingDragCachedImages[i] = null;
            }
            this.pdf.setUserOffsets(0, 0, 995);
        }
        this.lastScaling = scaling;
    }

    @Override
    public void setPageOffsets(int pageNumber) {
        int i;
        if (this.displayView == 1) {
            this.xReached = null;
            this.yReached = null;
            if (this.pdf.getFormRenderer() != null) {
                this.pdf.getFormRenderer().getCompData().setPageDisplacements(this.xReached, this.yReached);
            }
            return;
        }
        this.xReached = new int[this.pageCount + 1];
        this.yReached = new int[this.pageCount + 1];
        this.pageW = new int[this.pageCount + 1];
        this.pageH = new int[this.pageCount + 1];
        this.pageOffsetW = new int[this.pageCount + 1];
        this.pageOffsetH = new int[this.pageCount + 1];
        this.isRotated = new boolean[this.pageCount + 1];
        int gap = 10;
        if (this.turnoverOn && this.pageCount != 2 && !this.pdf.getPdfPageData().hasMultipleSizes() && this.displayView == 3) {
            gap = 0;
        }
        int LmaxWidth = 0;
        int LmaxHeight = 0;
        int RmaxWidth = 0;
        int RmaxHeight = 0;
        for (i = 1; i < this.pageCount + 1; ++i) {
            this.pageW[i] = this.pageData.getScaledCropBoxWidth(i);
            this.pageH[i] = this.pageData.getScaledCropBoxHeight(i);
            int displayRotation = this.pageData.getRotation(i) + this.displayRotation;
            if (displayRotation >= 360) {
                displayRotation -= 360;
            }
            if (displayRotation == 90 || displayRotation == 270) {
                int tmp = this.pageW[i];
                this.pageW[i] = this.pageH[i];
                this.pageH[i] = tmp;
                this.isRotated[i] = true;
            }
            if ((i & 1) == 1) {
                if (this.pageW[i] > RmaxWidth) {
                    RmaxWidth = this.pageW[i];
                }
                if (this.pageH[i] <= RmaxHeight) continue;
                RmaxHeight = this.pageH[i];
                continue;
            }
            if (this.pageW[i] > LmaxWidth) {
                LmaxWidth = this.pageW[i];
            }
            if (this.pageH[i] <= LmaxHeight) continue;
            LmaxHeight = this.pageH[i];
        }
        for (i = 1; i < this.pageCount + 1; ++i) {
            int heightCorrection = 0;
            if (this.pageCount == 2 && (this.displayView == 3 || this.displayView == 4) || this.displayView == 3 && !this.separateCover) {
                if ((i & 1) == 1) {
                    this.xReached[i] = 0;
                    this.yReached[i] = 0;
                    continue;
                }
                this.xReached[i] = this.xReached[i - 1] + this.pageW[i - 1] + gap;
                this.yReached[i] = 0;
                if (i == 2 && this.pageData.getRotation(1) == 270) continue;
                this.pageOffsetW[2] = this.pageW[2] - this.pageW[1] + this.pageOffsetW[1];
                this.pageOffsetH[2] = this.pageH[2] - this.pageH[1] + this.pageOffsetH[1];
                continue;
            }
            if (i == 1) {
                if (this.displayView == 2) {
                    this.xReached[1] = 0;
                    this.yReached[1] = 0;
                    this.pageOffsetW[1] = 0;
                    this.pageOffsetH[1] = 0;
                    this.pageOffsetW[0] = gap;
                    this.pageOffsetH[0] = gap;
                    continue;
                }
                if (this.displayView == 4) {
                    this.pageOffsetW[0] = gap;
                    this.pageOffsetH[0] = gap;
                    this.pageOffsetW[1] = 0;
                    this.pageOffsetH[1] = 0;
                    this.xReached[1] = LmaxWidth + gap;
                    this.yReached[1] = 0;
                    continue;
                }
                if (this.displayView != 3) continue;
                this.xReached[1] = this.pageW[1] + gap;
                this.yReached[1] = 0;
                continue;
            }
            if (this.displayView == 4) {
                if (i < 2 || (this.pageData.getRotation(i) != 270 && this.pageData.getRotation(i) != 90 || this.pageData.getRotation(i - 1) == 270 && this.pageData.getRotation(i - 1) == 90) && (this.pageData.getRotation(i - 1) != 270 && this.pageData.getRotation(i - 1) != 90 || this.pageData.getRotation(i) == 270 && this.pageData.getRotation(i) == 90)) {
                    this.pageOffsetW[i] = this.pageW[i] - this.pageW[i - 1] + this.pageOffsetW[i - 1];
                    this.pageOffsetH[i] = this.pageH[i] - this.pageH[i - 1] + this.pageOffsetH[i - 1];
                }
                if ((i & 1) == 0) {
                    int temp;
                    if (i < this.pageCount) {
                        heightCorrection = (this.pageH[i + 1] - this.pageH[i]) / 2;
                    }
                    if (heightCorrection < 0) {
                        heightCorrection = 0;
                    }
                    if (i > 3 && (temp = (this.pageH[i - 2] - this.pageH[i - 1]) / 2) > 0) {
                        heightCorrection += temp;
                    }
                    this.yReached[i] = this.yReached[i - 1] + this.pageH[i - 1] + gap + heightCorrection;
                } else {
                    heightCorrection = (this.pageH[i - 1] - this.pageH[i]) / 2;
                    this.yReached[i] = this.yReached[i - 1] + heightCorrection;
                }
                if ((i & 1) == 0) {
                    this.xReached[i] = this.xReached[i] + (LmaxWidth - this.pageW[i]);
                    continue;
                }
                this.xReached[i] = this.xReached[i - 1] + this.pageW[i - 1] + gap;
                continue;
            }
            if (this.displayView == 2) {
                this.yReached[i] = this.yReached[i - 1] + this.pageH[i - 1] + gap;
                if (i >= 2 && ((this.pageData.getRotation(i) == 270 || this.pageData.getRotation(i) == 90) && (this.pageData.getRotation(i - 1) != 270 || this.pageData.getRotation(i - 1) != 90) || (this.pageData.getRotation(i - 1) == 270 || this.pageData.getRotation(i - 1) == 90) && (this.pageData.getRotation(i) != 270 || this.pageData.getRotation(i) != 90))) continue;
                this.pageOffsetW[i] = this.pageW[i] - this.pageW[i - 1] + this.pageOffsetW[i - 1];
                this.pageOffsetH[i] = this.pageH[i] - this.pageH[i - 1] + this.pageOffsetH[i - 1];
                continue;
            }
            if (this.displayView != 3) continue;
            if ((i & 1) == 1) {
                this.xReached[i] = this.xReached[i - 1] + this.pageW[i - 1] + gap;
                if (this.pageH[i] >= this.pageH[i - 1]) continue;
                this.yReached[i] = this.yReached[i] + (this.pageH[i - 1] - this.pageH[i]) / 2;
                continue;
            }
            this.xReached[i] = 0;
            if (i >= this.pageCount || this.pageH[i] >= this.pageH[i + 1]) continue;
            this.yReached[i] = this.yReached[i] + (this.pageH[i + 1] - this.pageH[i]) / 2;
        }
        if (this.pdf.getFormRenderer() != null) {
            this.pdf.getFormRenderer().getCompData().setPageDisplacements(this.xReached, this.yReached);
        }
    }

    @Override
    public void decodeOtherPages(int pageNumber, int pageCount) {
    }

    @Override
    public void completeForm(Graphics2D g2) {
        g2.drawLine(this.crx, this.cry, this.crx + this.crw, this.cry + this.crh);
        g2.drawLine(this.crx, this.crh + this.cry, this.crw + this.crx, this.cry);
    }

    @Override
    public void resetToDefaultClip() {
        if (this.current2 != null) {
            this.g2.setTransform(this.current2);
        }
        if (this.currentClip != null) {
            this.g2.setClip(this.currentClip);
        }
    }

    @Override
    public void initRenderer(Map areas, Graphics2D g2, Border myBorder, int indent) {
        this.rawAf = g2.getTransform();
        this.rawClip = g2.getClip();
        if (areas != null) {
            this.lastAreasPainted = -2;
        }
        this.areas = areas;
        this.g2 = g2;
        this.myBorder = myBorder;
        this.indent = indent;
        this.pagesDrawn.clear();
        this.setPageSize(this.pageNumber, this.scaling);
    }

    void setPageSize(int pageNumber, float scaling) {
        this.pageData.setScalingValue(scaling);
        this.topW = this.pageData.getScaledCropBoxWidth(pageNumber);
        this.topH = this.pageData.getScaledCropBoxHeight(pageNumber);
        double mediaH = this.pageData.getScaledMediaBoxHeight(pageNumber);
        this.cropX = this.pageData.getScaledCropBoxX(pageNumber);
        this.cropY = this.pageData.getScaledCropBoxY(pageNumber);
        this.cropW = this.topW;
        this.cropH = this.topH;
        if (this.displayView == 1) {
            this.crx = (int)((double)this.insetW + this.cropX);
            this.cry = (int)((double)this.insetH - this.cropY);
        } else {
            this.crx = this.insetW;
            this.cry = this.insetH;
        }
        int offsetY = (int)(mediaH - this.cropH);
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            this.crw = (int)this.cropH;
            this.crh = (int)this.cropW;
            int tmp = this.crx;
            this.crx = this.cry;
            this.cry = tmp;
            this.crx += offsetY;
        } else {
            this.crw = (int)this.cropW;
            this.crh = (int)this.cropH;
            this.cry += offsetY;
        }
        this.g2.translate(this.insetW - this.crx, this.insetH - this.cry);
        this.current2 = this.g2.getTransform();
        this.currentClip = this.g2.getClip();
        this.g2.clip(new Rectangle(this.crx, this.cry, (int)((float)this.crw + ((float)(this.insetW * this.additionalPageCount) + (float)this.currentXOffset * scaling)), this.crh));
    }

    Rectangle calcVisibleArea(int topY, int topX) {
        Rectangle userAnnot;
        int x = 0;
        int y = 0;
        this.getDisplayedRectangle();
        if (this.displayRotation != 270 && this.displayRotation != 180 && this.rx > this.insetW) {
            x = (int)((float)(this.rx - this.insetW) / this.scaling);
        }
        int w = (int)((float)(this.rw + this.insetW) / this.scaling);
        int h = topY;
        if (this.displayRotation == 0 || this.displayView != 1) {
            x = 0;
            if (this.rx >= this.insetW) {
                x = (int)((float)this.rx / this.scaling) - (int)((float)this.insetW / this.scaling);
            }
            h = (int)((float)(this.rh + this.insetH) / this.scaling);
            w = (int)((float)(this.rw - this.insetW) / this.scaling) + (int)((float)this.insetW / this.scaling);
            y = (int)((float)topY - (float)(this.ry + this.rh) / this.scaling);
        } else if (this.displayRotation == 90) {
            y = (int)((float)(this.rx - this.insetW) / this.scaling);
            h = (int)((float)(this.rw + this.insetW) / this.scaling);
            x = this.ry > this.insetW ? (int)((float)(this.ry - this.insetW) / this.scaling) : 0;
            w = (int)((float)this.rh / this.scaling);
        } else if (this.displayRotation == 270) {
            w = (int)((float)(this.rh + this.insetW) / this.scaling);
            x = topX - (int)((float)(this.ry + this.rh) / this.scaling);
            h = (int)((float)(this.rw + this.insetH) / this.scaling);
            y = topY - (int)((float)(this.rx + this.rw) / this.scaling);
            if (x < this.insetH) {
                x = 0;
                w += this.insetH;
            }
            if (y < this.insetW) {
                y = 0;
                h += this.insetW;
            }
        } else if (this.displayRotation == 180) {
            h = (int)((float)(this.rh + this.insetH) / this.scaling) + this.insetH;
            y = (int)((float)(this.ry - this.insetH) / this.scaling);
            w = (int)((float)(this.rw + this.insetW) / this.scaling);
            x = topX - (int)((float)(this.rx - this.insetW) / this.scaling);
            if ((x -= w) < 0 || x < this.insetH) {
                x = 0;
                w += this.insetH;
            }
            if (y < this.insetW) {
                y = 0;
                h += this.insetW;
            }
        }
        if (this.isAccelerated() || this.scaling >= 2.0f) {
            int dx1 = this.pageData.getScaledCropBoxX(this.pageNumber);
            int dy1 = this.pageData.getScaledCropBoxY(this.pageNumber);
            int gap = 2;
            userAnnot = dx1 != 0 || dy1 != 0 ? new Rectangle(x + (int)((float)dx1 / this.scaling), y + (int)((float)dy1 / this.scaling), w, h) : new Rectangle(x, y, w + (gap + gap), h + (gap + gap));
        } else {
            userAnnot = null;
        }
        if (this.displayView != 1 && this.message) {
            this.message = true;
            System.out.println("SingleDisplay fast scrolling");
            userAnnot = null;
        }
        return userAnnot;
    }

    @Override
    public Rectangle drawPage(AffineTransform viewScaling, AffineTransform displayScaling, int pageUsedForTransform) {
        Rectangle actualBox = null;
        if (displayScaling != null && this.currentDisplay != null) {
            if (this.scaling < 2.0f && this.oldScaling > 2.0f) {
                this.useAcceleration = true;
            }
            if (this.useAcceleration || this.areas != null) {
                int areasPainted = -1;
                if (this.areas != null) {
                    areasPainted = this.areas.size();
                }
                if ((this.lastAreasPainted != -2 || areasPainted != -1) && areasPainted != this.lastAreasPainted) {
                    this.screenNeedsRedrawing = true;
                    this.lastAreasPainted = areasPainted;
                }
            }
            boolean canDrawAccelerated = false;
            if (this.useAcceleration && !this.overRideAcceleration && this.scaling < 2.0f) {
                canDrawAccelerated = this.testAcceleratedRendering();
            } else {
                this.useAcceleration = false;
            }
            this.currentDisplay.setScalingValues(this.cropX, this.cropH + this.cropY, this.scaling);
            this.g2.transform(displayScaling);
            if (canDrawAccelerated) {
                Graphics2D gBB = (Graphics2D)this.backBuffer.getGraphics();
                if (this.screenNeedsRedrawing) {
                    this.currentDisplay.setG2(gBB);
                    this.currentDisplay.paintBackground(new Rectangle(0, 0, this.backBuffer.getWidth(), this.backBuffer.getHeight()));
                    this.currentDisplay.setOptimsePainting(true);
                    gBB.setTransform(displayScaling);
                    this.setDisplacementOnG2(gBB);
                    this.currentDisplay.setG2(gBB);
                    actualBox = this.areas != null ? this.currentDisplay.paint((Rectangle[])this.areas.get(this.pageNumber), viewScaling, this.userAnnot) : this.currentDisplay.paint(null, viewScaling, this.userAnnot);
                    this.screenNeedsRedrawing = false;
                }
                gBB.dispose();
                if (this.backBuffer != null) {
                    AffineTransform affBefore = this.g2.getTransform();
                    this.g2.setTransform(this.rawAf);
                    this.g2.drawImage(this.backBuffer, this.insetW, this.insetH, this.pdf);
                    this.g2.setTransform(affBefore);
                }
            } else {
                this.currentDisplay.setOptimsePainting(false);
                this.currentDisplay.setG2(this.g2);
                actualBox = this.areas != null ? this.currentDisplay.paint((Rectangle[])this.areas.get(this.pageNumber), viewScaling, this.userAnnot) : this.currentDisplay.paint(null, viewScaling, this.userAnnot);
            }
            this.oldScaling = this.scaling;
            this.oldRotation = this.displayRotation;
        }
        return actualBox;
    }

    @Override
    public int getXCordForPage(int page, float scaling) {
        if (scaling == -2.0f || scaling != -1.0f && scaling != this.oldScaling) {
            this.oldScaling = scaling;
            this.setPageOffsets(page);
        }
        return this.getXCordForPage(page);
    }

    @Override
    public int getYCordForPage(int page, float scaling) {
        if (scaling == -2.0f || scaling != -1.0f && scaling != this.oldScaling) {
            this.oldScaling = scaling;
            this.setPageOffsets(page);
        }
        return this.getYCordForPage(page);
    }

    @Override
    public void setup(boolean useAcceleration, PageOffsets currentOffset, PdfDecoder pdf) {
        this.useAcceleration = useAcceleration;
        this.currentOffset = currentOffset;
        this.pdf = pdf;
        this.overRideAcceleration = false;
    }

    @Override
    public int getXCordForPage(int page) {
        if (this.xReached != null) {
            return this.xReached[page] + this.insetW;
        }
        return this.insetW;
    }

    @Override
    public int getYCordForPage(int page) {
        if (this.yReached != null) {
            return this.yReached[page] + this.insetH;
        }
        return this.insetH;
    }

    @Override
    public int getStartPage() {
        return this.startViewPage;
    }

    @Override
    public int getEndPage() {
        return this.endViewPage;
    }

    @Override
    public void setThumbnailPanel(GUIThumbnailPanel thumbnails) {
        this.thumbnails = thumbnails;
    }

    @Override
    public void setScaling(float scaling) {
        this.scaling = scaling;
        if (this.pageData != null) {
            this.pageData.setScalingValue(scaling);
        }
    }

    @Override
    public void setAcceleration(boolean enable) {
        this.useAcceleration = enable;
    }

    @Override
    public int getWidthForPage(int pageNumber) {
        return this.pageW[pageNumber];
    }

    public void setPreviewThumbnail(BufferedImage previewImage, String previewText) {
        this.previewImage = previewImage;
        this.previewText = previewText;
    }

    @Override
    public void drawPreviewImage(Graphics2D g2, Rectangle visibleRect) {
        if (this.previewImage != null) {
            int iw = this.previewImage.getWidth();
            int ih = this.previewImage.getHeight();
            int textWidth = g2.getFontMetrics().stringWidth(this.previewText);
            int width = iw > textWidth ? iw : textWidth;
            int x = visibleRect.x + visibleRect.width - 40 - width;
            int y = (visibleRect.y + visibleRect.height - 20 - ih) / 2;
            Composite original = g2.getComposite();
            g2.setPaint(Color.BLACK);
            g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
            g2.fill(new RoundRectangle2D.Double(x - 10, y - 10, width + 20, ih + 35, 10.0, 10.0));
            g2.setComposite(original);
            g2.setPaint(Color.WHITE);
            g2.drawImage((Image)this.previewImage, x += (width - iw) / 2, y, null);
            int xOffset = (iw + 20 - textWidth) / 2;
            g2.drawString(this.previewText, x + xOffset - 10, y + ih + 15);
        }
    }

    @Override
    public void setHighlightedImage(int[] highlightedImage) {
        this.highlightedImage = highlightedImage;
    }

    @Override
    public boolean getBoolean(Display.BoolValue option) {
        switch (option) {
            case SEPARATE_COVER: {
                return this.separateCover;
            }
            case TURNOVER_ON: {
                return this.turnoverOn;
            }
        }
        return false;
    }

    @Override
    public void setBoolean(Display.BoolValue option, boolean value) {
        switch (option) {
            case SEPARATE_COVER: {
                this.separateCover = value;
                return;
            }
            case TURNOVER_ON: {
                this.turnoverOn = value;
                return;
            }
        }
    }

    @Override
    public float getOldScaling() {
        return this.oldScaling;
    }

    @Override
    public int[] getHighlightedImage() {
        return this.highlightedImage;
    }
}

