/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class DeviceCMYKColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = 4054062852632000027L;
    private float lastC = -1.0f;
    private float lastM = -1.0f;
    private float lastY = -1.0f;
    private float lastK = -1.0f;
    public static ColorSpace CMYK = null;

    @Override
    public void clearCache() {
        this.lastC = -1.0f;
    }

    private void initColorspace() {
        InputStream stream = null;
        try {
            String profile = System.getProperty("org.jpedal.CMYKprofile");
            if (profile == null) {
                stream = this.getClass().getResourceAsStream("/org/jpedal/res/cmm/cmyk.icm");
            } else {
                try {
                    stream = new FileInputStream(profile);
                }
                catch (Exception ee) {
                    throw new PdfException("PdfException attempting to use user profile " + profile + " Message=" + ee);
                }
            }
            ICC_Profile p = ICC_Profile.getInstance(stream);
            CMYK = new ICC_ColorSpace(p);
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + e);
            }
            throw new RuntimeException("Problem setting CMYK Colorspace with message " + e + " Possible cause file cmyk.icm corrupted");
        }
        finally {
            block16: {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        if (!LogWriter.isOutput()) break block16;
                        LogWriter.writeLog("Exception " + e);
                    }
                }
            }
        }
    }

    public DeviceCMYKColorSpace() {
        this.componentCount = 4;
        if (CMYK == null) {
            this.initColorspace();
        }
        this.cs = CMYK;
        this.value = 1498837125;
    }

    @Override
    public final void setColor(String[] number_values, int items) {
        float[] colValues = new float[items];
        for (int ii = 0; ii < items; ++ii) {
            colValues[ii] = Float.parseFloat(number_values[ii]);
        }
        this.setColor(colValues, items);
    }

    @Override
    public final void setColor(float[] operand, int length) {
        boolean newVersion = true;
        this.c = 1.0f;
        this.y = 1.0f;
        this.m = 1.0f;
        this.k = 1.0f;
        if (length > 3) {
            this.c = operand[0];
            this.m = operand[1];
            this.y = operand[2];
            this.k = operand[3];
        } else {
            if (length > 0) {
                this.c = operand[0];
            }
            if (length > 1) {
                this.m = operand[1];
            }
            if (length > 2) {
                this.y = operand[2];
            }
            if (length > 3) {
                this.k = operand[3];
            }
        }
        if (this.lastC != this.c || this.lastM != this.m || this.lastY != this.y || this.lastK != this.k) {
            this.rawValues = new float[4];
            this.rawValues[0] = this.c;
            this.rawValues[1] = this.m;
            this.rawValues[2] = this.y;
            this.rawValues[3] = this.k;
            if (!newVersion) {
                float b;
                float g;
                float r = this.c + this.k;
                if (r > 1.0f) {
                    r = 1.0f;
                }
                if ((g = this.m + this.k) > 1.0f) {
                    g = 1.0f;
                }
                if ((b = this.y + this.k) > 1.0f) {
                    b = 1.0f;
                }
                this.currentColor = new PdfColor((int)(255.0f * (1.0f - r)), (int)(255.0f * (1.0f - g)), (int)(255.0f * (1.0f - b)));
            } else if (this.c == 0.0f && this.y == 0.0f && this.m == 0.0f && this.k == 0.0f) {
                this.currentColor = new PdfColor(1.0f, 1.0f, 1.0f);
            } else {
                if ((double)this.c > 0.99) {
                    this.c = 1.0f;
                } else if ((double)this.c < 0.01) {
                    this.c = 0.0f;
                }
                if ((double)this.m > 0.99) {
                    this.m = 1.0f;
                } else if ((double)this.m < 0.01) {
                    this.m = 0.0f;
                }
                if ((double)this.y > 0.99) {
                    this.y = 1.0f;
                } else if ((double)this.y < 0.01) {
                    this.y = 0.0f;
                }
                if ((double)this.k > 0.99) {
                    this.k = 1.0f;
                } else if ((double)this.k < 0.01) {
                    this.k = 0.0f;
                }
                float[] rgb = null;
                if (rgb == null) {
                    float[] cmykValues = new float[]{this.c, this.m, this.y, this.k};
                    rgb = CMYK.toRGB(cmykValues);
                    for (int jj = 0; jj < 3; ++jj) {
                        if ((double)rgb[jj] > 0.99) {
                            rgb[jj] = 1.0f;
                            continue;
                        }
                        if (!((double)rgb[jj] < 0.01)) continue;
                        rgb[jj] = 0.0f;
                    }
                }
                this.currentColor = new PdfColor((float)rgb[0], (float)rgb[1], (float)rgb[2]);
            }
            this.lastC = this.c;
            this.lastM = this.m;
            this.lastY = this.y;
            this.lastK = this.k;
        }
    }

    @Override
    public final BufferedImage JPEGToRGBImage(byte[] data, int w, int h, float[] decodeArray, int pX, int pY, boolean arrayInverted, PdfObject XObject2) {
        return this.nonRGBJPEGToRGBImage(data, w, h, decodeArray, pX, pY);
    }

    @Override
    public BufferedImage JPEG2000ToRGBImage(byte[] data, int w, int h, float[] decodeArray, int pX, int pY) throws PdfException {
        BufferedImage image;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ImageReader iir = ImageIO.getImageReadersByFormatName("JPEG2000").next();
            ImageInputStream iin = ImageIO.createImageInputStream(in);
            iir.setInput(iin, true);
            byte[] index = this.getIndexedMap();
            if (index != null) {
                if (!this.isIndexConverted()) {
                    index = this.convertIndexToRGB(index);
                }
                RenderedImage renderimage = iir.readAsRenderedImage(0, iir.getDefaultReadParam());
                Raster ras = renderimage.getData();
                IndexColorModel cm = new IndexColorModel(8, index.length / 3, index, 0, false);
                image = new BufferedImage(cm, ras.createCompatibleWritableRaster(), false, null);
                image.setData(ras);
                image = DeviceCMYKColorSpace.cleanupImage(image, pX, pY, image.getType());
            } else {
                WritableRaster rgbRaster;
                image = iir.read(0);
                Raster ras = image.getRaster();
                if (decodeArray != null) {
                    if (decodeArray.length == 6 && decodeArray[0] == 1.0f && decodeArray[1] == 0.0f && decodeArray[2] == 1.0f && decodeArray[3] == 0.0f && decodeArray[4] == 1.0f && decodeArray[5] == 0.0f || decodeArray.length > 2 && decodeArray[0] == 1.0f && decodeArray[1] == 0.0f) {
                        DataBuffer buf = ras.getDataBuffer();
                        int count = buf.getSize();
                        for (int ii = 0; ii < count; ++ii) {
                            buf.setElem(ii, 255 - buf.getElem(ii));
                        }
                    } else if (decodeArray.length == 6 && decodeArray[0] == 0.0f && decodeArray[1] == 1.0f && decodeArray[2] == 0.0f && decodeArray[3] == 1.0f && decodeArray[4] == 0.0f && decodeArray[5] == 1.0f || decodeArray == null || decodeArray.length > 0) {
                        // empty if block
                    }
                }
                ras = DeviceCMYKColorSpace.cleanupRaster(ras, pX, pY, 4);
                w = ras.getWidth();
                h = ras.getHeight();
                if (image.getType() == 13) {
                    rgbRaster = ColorSpaceConvertor.createCompatibleWritableRaaster(image.getColorModel(), w, h);
                    CSToRGB = new ColorConvertOp(this.cs, image.getColorModel().getColorSpace(), ColorSpaces.hints);
                    image = new BufferedImage(w, h, image.getType());
                } else {
                    if (CSToRGB == null) {
                        DeviceCMYKColorSpace.initCMYKColorspace();
                    }
                    rgbRaster = ColorSpaceConvertor.createCompatibleWritableRaaster(rgbModel, w, h);
                    CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
                    CSToRGB.filter(ras, rgbRaster);
                    image = new BufferedImage(w, h, 1);
                }
                image.setData(rgbRaster);
            }
            iir.dispose();
            iin.close();
            in.close();
        }
        catch (Exception ee) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Problem reading JPEG 2000: " + ee);
            }
            ee.printStackTrace();
            throw new PdfException("Exception " + ee + " with JPEG2000 image - please ensure imageio.jar (see http://www.idrsolutions.com/additional-jars/) on classpath");
        }
        catch (Error ee2) {
            ee2.printStackTrace();
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Problem reading JPEG 2000 with error " + ee2);
            }
            throw new PdfException("Error with JPEG2000 image - please ensure imageio.jar (see http://www.idrsolutions.com/additional-jars/) on classpath");
        }
        return image;
    }

    @Override
    public final byte[] convertIndexToRGB(byte[] index) {
        this.isConverted = true;
        return this.convert4Index(index);
    }

    public static ColorSpace getColorSpaceInstance() {
        ColorSpace CMYK = new DeviceCMYKColorSpace().getColorSpace();
        String CMYKprofile = System.getProperty("org.jpedal.CMYKprofile");
        if (CMYKprofile != null) {
            try {
                CMYK = new ICC_ColorSpace(ICC_Profile.getInstance(new FileInputStream(CMYKprofile)));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create CMYK colorspace with  " + CMYKprofile + "\nPlease check Path and file valid or use built-in");
            }
        }
        return CMYK;
    }
}

