/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.javafx;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.jpedal.PdfDecoder;
import org.jpedal.fonts.FontMappings;
import org.jpedal.io.ObjectStore;
import org.jpedal.render.output.GenericFontMapper;
import org.jpedal.render.output.OutputDisplay;
import org.jpedal.render.output.javafx.FXMLDisplay;
import org.jpedal.render.output.javafx.JavaFXDisplay;
import org.jpedal.utils.LogWriter;

public class ExtractPagesAsJavaFX {
    private String user_dir;
    public static boolean outputMessages = false;
    String output_dir;
    String separator;
    PdfDecoder decode_pdf;
    private boolean useHiresImage;
    private String test_file;
    public static boolean isTest = false;
    private String password;
    private String firstPageName;
    private static boolean createTemplate = false;
    private static String saveTemplateFileName = "/Users/markee/Desktop/test.xml";
    private static boolean loadTemplate = false;
    private static String loadTemplateFileName;
    private boolean outputAsFXML;
    int end;
    int page;
    private boolean exitRequested;
    private int numPages;

    public ExtractPagesAsJavaFX() {
        this.user_dir = System.getProperty("user.dir");
        this.output_dir = null;
        this.separator = System.getProperty("file.separator");
        this.decode_pdf = null;
        this.useHiresImage = false;
        this.test_file = "/mnt/shared/sample_pdfs/general/World Factbook.pdf";
        this.password = "";
        this.firstPageName = null;
        this.outputAsFXML = false;
        this.numPages = -1;
        ExtractPagesAsJavaFX.init();
    }

    public ExtractPagesAsJavaFX(String[] args) {
        String name;
        block6: {
            this.user_dir = System.getProperty("user.dir");
            this.output_dir = null;
            this.separator = System.getProperty("file.separator");
            this.decode_pdf = null;
            this.useHiresImage = false;
            this.test_file = "/mnt/shared/sample_pdfs/general/World Factbook.pdf";
            this.password = "";
            this.firstPageName = null;
            this.outputAsFXML = false;
            this.numPages = -1;
            ExtractPagesAsJavaFX.init();
            String file_name = this.setParams(args);
            File pdf_file = new File(file_name);
            if (!pdf_file.exists()) {
                System.out.println("File " + pdf_file + " not found");
                System.out.println("May need full path");
                return;
            }
            if (System.getProperty("org.jpedal.pdf2javafx.outputAsFXML") != null && System.getProperty("org.jpedal.pdf2javafx.outputAsFXML").toLowerCase().equals("true")) {
                this.outputAsFXML = true;
            }
            this.extraction(file_name, this.output_dir);
            String pdfName = pdf_file.getName();
            name = System.getProperty("IsOnlineConverter") != null ? ExtractPagesAsJavaFX.getStrippedText(pdfName.substring(0, pdfName.length() - 4)) : ExtractPagesAsJavaFX.convertPDFName(pdfName.substring(0, pdfName.length() - 4), !this.outputAsFXML);
            ExtractPagesAsJavaFX.compile(this.output_dir, name);
            if (this.firstPageName == null) {
                this.firstPageName = "page";
                for (int i = 1; i < String.valueOf(this.numPages).length(); ++i) {
                    this.firstPageName = this.firstPageName + '0';
                }
                this.firstPageName = this.firstPageName + '1';
            }
            try {
                ExtractPagesAsJavaFX.mkJar(this.output_dir, name, this.firstPageName);
            }
            catch (IOException e) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        ExtractPagesAsJavaFX.tidyUpClassFiles(this.output_dir, name);
    }

    private static void tidyUpClassFiles(String dir, String name) {
        File directory = new File(dir, name);
        for (File f : directory.listFiles()) {
            if (!f.getAbsolutePath().endsWith(".class")) continue;
            f.delete();
        }
    }

    private static void mkJar(String dir, String name, String firstPageName) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, name + '/' + firstPageName);
        JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(dir + name + ".jar"), manifest);
        ExtractPagesAsJavaFX.add(new File(dir, name), target, dir);
        target.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void add(File source, JarOutputStream target, String dir) throws IOException {
        try (BufferedInputStream in = null;){
            int count;
            if (source.isDirectory()) {
                for (File nestedFile : source.listFiles()) {
                    ExtractPagesAsJavaFX.add(nestedFile, target, dir);
                }
                return;
            }
            JarEntry entry = new JarEntry(source.getPath().replace("\\", "/").replace((new File(dir).getPath() + "/").replace("\\", "/"), ""));
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            in = new BufferedInputStream(new FileInputStream(source));
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
            target.closeEntry();
        }
    }

    private static void compile(String outputDir, String pdfName) {
        block4: {
            File dir = new File(outputDir, pdfName);
            ArrayList<File> files = new ArrayList<File>();
            for (File f : dir.listFiles()) {
                if (!f.getAbsolutePath().endsWith(".java")) continue;
                files.add(f);
            }
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler == null) {
                throw new RuntimeException("Jar could not be created as Java version requires javac.");
            }
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            Iterable<? extends JavaFileObject> compilationUnits1 = fileManager.getJavaFileObjectsFromFiles(files);
            String[] compileOptions = System.getProperty("IsOnlineConverter") != null ? new String[]{"-encoding", "UTF-8", "-classpath", "../jfxrt.jar"} : new String[]{"-encoding", "UTF-8"};
            List<String> compilationOptionss = Arrays.asList(compileOptions);
            compiler.getTask(null, fileManager, null, compilationOptionss, null, compilationUnits1).call();
            try {
                fileManager.close();
            }
            catch (IOException e) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    private static void init() {
        loadTemplateFileName = System.getProperty("org.jpedal.loadXML");
        loadTemplate = loadTemplateFileName != null && new File(loadTemplateFileName).exists();
        saveTemplateFileName = System.getProperty("org.jpedal.saveXML");
        createTemplate = saveTemplateFileName != null;
    }

    public void extraction(String file_name, String output_dir) {
        this.output_dir = output_dir;
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        this.firstPageName = System.getProperty("org.jpedal.pdf2javafx.firstPageName");
        if (file_name.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(file_name, output_dir);
        } else {
            String[] files = null;
            if (!file_name.endsWith(this.separator)) {
                file_name = file_name + this.separator;
            }
            try {
                File inputFiles = new File(file_name);
                if (!inputFiles.isDirectory()) {
                    System.err.println(file_name + " is not a directory. Exiting program");
                } else {
                    files = inputFiles.list();
                }
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception trying to access file " + ee.getMessage());
            }
            if (files != null) {
                for (String file : files) {
                    if (!file.toLowerCase().endsWith(".pdf") || file.startsWith(".")) continue;
                    if (outputMessages) {
                        System.out.println(file_name + file);
                    }
                    this.decodeFile(file_name + file, output_dir);
                }
            }
        }
        if (outputMessages) {
            System.out.println("JavaFX created");
        }
    }

    private void decodeFile(String file_name, String output_dir) {
        String name = "demo";
        int pointer = file_name.lastIndexOf(this.separator);
        if (pointer == -1) {
            pointer = file_name.lastIndexOf(47);
        }
        if (pointer != -1) {
            name = file_name.substring(pointer + 1, file_name.length() - 4);
        } else if (!isTest && file_name.toLowerCase().endsWith(".pdf")) {
            name = file_name.substring(0, file_name.length() - 4);
        }
        name = ExtractPagesAsJavaFX.getStrippedText(name);
        try {
            this.decode_pdf = new PdfDecoder(true);
            if (!isTest) {
                FontMappings.setFontReplacements();
            }
            if (this.password != null) {
                this.decode_pdf.openPdfFile(file_name, this.password);
            } else {
                this.decode_pdf.openPdfFile(file_name);
            }
            this.numPages = this.decode_pdf.getPageCount();
        }
        catch (Exception e) {
            System.err.println("8.Exception " + e + " in pdf code in " + file_name);
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isFileViewable()) {
            if (!isTest) {
                throw new RuntimeException("Wrong password password used=>" + this.password + '<');
            }
        } else {
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() && !this.decode_pdf.isExtractionAllowed()) {
                throw new RuntimeException("Extraction not allowed");
            }
            if (!this.outputAsFXML) {
                if (System.getProperty("IsOnlineConverter") != null) {
                    this.extractPageAsJavaFX(file_name, output_dir + name + this.separator, name);
                } else {
                    this.extractPageAsJavaFX(file_name, output_dir + "FX" + name + this.separator, "FX" + name);
                }
            } else if (System.getProperty("IsOnlineConverter") != null) {
                this.extractPageAsJavaFX(file_name, output_dir + name + this.separator, name);
            } else {
                this.extractPageAsJavaFX(file_name, output_dir + "FXML" + name + this.separator, "FXML" + name);
            }
        }
        this.decode_pdf.closePdfFile();
    }

    public int getPageCount() {
        return this.end;
    }

    public int getPageReached() {
        return this.page;
    }

    public static String convertPDFName(String name, boolean isPDFtoFX) {
        if (isPDFtoFX) {
            return "FX" + ExtractPagesAsJavaFX.getStrippedText(name);
        }
        return "FXML" + ExtractPagesAsJavaFX.getStrippedText(name);
    }

    private void extractPageAsJavaFX(String file_name, String output_dir, String name) {
        File output_path;
        if (output_dir != null && !(output_path = new File(output_dir)).exists()) {
            output_path.mkdirs();
        }
        int start = 1;
        this.end = this.decode_pdf.getPageCount();
        if (this.end > 10 && isTest) {
            this.end = 10;
        }
        if (outputMessages) {
            System.out.println("JavaFX file will be in  " + output_dir);
        }
        try {
            String[] images;
            File iconDir;
            GenericFontMapper.setXMLTemplate(createTemplate);
            if (loadTemplate) {
                GenericFontMapper.loadCustomFontMappings(new FileInputStream(new File(loadTemplateFileName)));
            }
            if (!(iconDir = new File(output_dir + "/icons")).exists()) {
                iconDir.mkdirs();
            }
            for (String image : images = new String[]{"smstart.gif", "smback.gif", "smfback.gif", "smforward.gif", "smfforward.gif", "smend.gif", "logo.gif"}) {
                int length;
                InputStream is = this.getClass().getResourceAsStream("/org/jpedal/examples/javafx/icons/" + image);
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(iconDir + this.separator + image));
                byte[] buffer = new byte[65536];
                while ((length = is.read(buffer)) > 0) {
                    os.write(buffer, 0, length);
                }
                os.close();
                is.close();
            }
            this.page = start;
            while (this.page < this.end + 1) {
                String pageAsString = String.valueOf(this.page);
                if (this.firstPageName != null && this.page == start) {
                    pageAsString = this.firstPageName;
                } else {
                    String maxPageSize = String.valueOf(this.end);
                    int padding = maxPageSize.length() - pageAsString.length();
                    for (int ii = 0; ii < padding; ++ii) {
                        pageAsString = '0' + pageAsString;
                    }
                }
                if (outputMessages) {
                    System.out.println("Page " + pageAsString);
                }
                int cropX = this.decode_pdf.getPdfPageData().getCropBoxX(this.page);
                int cropY = this.decode_pdf.getPdfPageData().getCropBoxY(this.page);
                int cropW = this.decode_pdf.getPdfPageData().getCropBoxWidth(this.page);
                int cropH = this.decode_pdf.getPdfPageData().getCropBoxHeight(this.page);
                Rectangle cropBox = new Rectangle(0, 0, cropW, cropH);
                Point2D.Double midPoint = new Point2D.Double(cropW / 2 + cropX, cropH / 2 + cropY);
                OutputDisplay javaFXOutput = this.outputAsFXML ? new FXMLDisplay(this.page, midPoint, cropBox, false, 100, new ObjectStore(null)) : new JavaFXDisplay(this.page, midPoint, cropBox, false, 100, new ObjectStore(null));
                float scaling = 1.0f;
                javaFXOutput.setValue(2, (int)(scaling * 100.0f));
                javaFXOutput.writeCustom(11, this.decode_pdf.getPdfPageData());
                javaFXOutput.setValue(0, 0);
                javaFXOutput.setOutputDir(output_dir, name, pageAsString);
                this.decode_pdf.addExternalHandler(javaFXOutput, 20);
                javaFXOutput.setValue(22, start);
                javaFXOutput.setValue(23, this.end);
                javaFXOutput.setBooleanValue(8, true);
                javaFXOutput.setBooleanValue(16, true);
                this.decode_pdf.decodePage(this.page);
                this.decode_pdf.flushObjectValues(true);
                if (this.exitRequested) {
                    this.end = this.page;
                }
                ++this.page;
            }
        }
        catch (Exception e) {
            this.decode_pdf.closePdfFile();
            throw new RuntimeException("Exception " + e.getMessage() + " on File=" + file_name);
        }
        if (createTemplate) {
            GenericFontMapper.createXMLTemplate(saveTemplateFileName);
        }
    }

    public static void main(String[] args) {
        if (outputMessages) {
            System.out.println("Simple demo to extract JavaFX version of a page");
        }
        new ExtractPagesAsJavaFX(args);
    }

    private String setParams(String[] args) {
        String file_name = this.test_file;
        int len = args.length;
        if (len == 0) {
            ExtractPagesAsJavaFX.showCommandLineValues();
        } else if (len == 1) {
            file_name = args[0];
        } else if (len < 6) {
            file_name = args[0];
            for (int j = 1; j < args.length; ++j) {
                String value = args[j];
                if (value.endsWith("/") || value.endsWith("\\")) {
                    this.output_dir = value;
                    continue;
                }
                this.password = value;
            }
        }
        return file_name;
    }

    private static void showCommandLineValues() {
        System.out.println("Example takes 2 or 3 parameters");
        System.out.println("Value 1 is the file name or directory of PDF files to process");
        System.out.println("Value 2 is the pass to write out JavaFX and directories and must end with / or \\ character)");
        System.out.println("Value 3 (optional) password for PDF file");
        System.exit(0);
    }

    public String getOutputDir() {
        return this.output_dir;
    }

    public void stopConversion() {
        this.exitRequested = true;
    }

    protected static String getStrippedText(String input) {
        String output = "";
        char[] illegalCharacters = new char[]{'<', '>', '\\', ':', ';', '*', '^', '@', '?', '=', '[', ']', '`'};
        char minVal = '0';
        char maxVal = 'z';
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) < minVal || input.charAt(i) > maxVal) continue;
            boolean foundIllegal = false;
            for (char illegalCharacter : illegalCharacters) {
                if (input.charAt(i) != illegalCharacter) continue;
                foundIllegal = true;
                break;
            }
            if (foundIllegal) continue;
            output = output + input.charAt(i);
        }
        return output;
    }
}

