/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.RepaintManager;
import javax.swing.filechooser.FileFilter;
import org.jpedal.PdfDecoder;
import org.jpedal.SingleDisplay;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingMouseFunctionality;
import org.jpedal.exception.PdfException;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.Messages;

public class SwingMouseSelector
implements SwingMouseFunctionality {
    private PdfDecoder decode_pdf;
    private SwingGUI currentGUI;
    private Values commonValues;
    private Commands currentCommands;
    public static boolean activateMultipageHighlight = true;
    private int clickCount = 0;
    private long lastTime = -1L;
    private int pageMouseIsOver = -1;
    private int pageOfHighlight = -1;
    private boolean startHighlighting = false;
    public int id = -1;
    public int lastId = -1;
    private int old_m_x2 = -1;
    private int old_m_y2 = -1;
    boolean altIsDown = false;
    private JPopupMenu rightClick = new JPopupMenu();
    private boolean menuCreated = false;
    JMenuItem copy;
    JMenuItem selectAll;
    JMenuItem deselectall;
    JMenu extract;
    JMenuItem extractText;
    JMenuItem extractImage;
    ImageIcon snapshotIcon;
    JMenuItem snapShot;
    JMenuItem find;
    JMenuItem speakHighlighted;

    public SwingMouseSelector(PdfDecoder decode_pdf, SwingGUI currentGUI, Values commonValues, Commands currentCommands) {
        this.decode_pdf = decode_pdf;
        this.currentGUI = currentGUI;
        this.commonValues = commonValues;
        this.currentCommands = currentCommands;
    }

    public void updateRectangle() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.decode_pdf.getDisplayView() != 1 && !activateMultipageHighlight) return;
        long currentTime = new Date().getTime();
        if (this.lastTime + 500L < currentTime) {
            this.clickCount = 0;
        }
        this.lastTime = currentTime;
        if (event.getButton() == 1 || event.getButton() == 0) {
            if (this.clickCount != 4) {
                ++this.clickCount;
            }
            float scaling = this.currentGUI.getScaling();
            int inset = GUI.getPDFDisplayInset();
            int mouseX = (int)((float)(this.currentGUI.AdjustForAlignment(event.getX()) - inset) / scaling);
            int mouseY = (int)((float)this.decode_pdf.getPdfPageData().getCropBoxHeight(this.commonValues.getCurrentPage()) - (float)(event.getY() - inset) / scaling);
            Point mousePoint = this.getCoordsOnPage(event.getX(), event.getY(), this.commonValues.getCurrentPage());
            mouseX = (int)mousePoint.getX();
            mouseY = (int)mousePoint.getY();
            this.id = this.decode_pdf.getDisplayView() == 1 ? this.decode_pdf.getDynamicRenderer().isInsideImage(mouseX, mouseY) : -1;
            if (this.lastId != this.id && this.id != -1) {
                Rectangle imageArea = this.decode_pdf.getDynamicRenderer().getArea(this.id);
                if (imageArea != null) {
                    int h = imageArea.height;
                    int w = imageArea.width;
                    int x = imageArea.x;
                    int y = imageArea.y;
                    this.decode_pdf.getDynamicRenderer().setneedsHorizontalInvert(false);
                    this.decode_pdf.getDynamicRenderer().setneedsVerticalInvert(false);
                    if (w < 0) {
                        this.decode_pdf.getDynamicRenderer().setneedsHorizontalInvert(true);
                        w = -w;
                        x -= w;
                    }
                    if (h < 0) {
                        this.decode_pdf.getDynamicRenderer().setneedsVerticalInvert(true);
                        h = -h;
                        y -= h;
                    }
                    if (this.currentGUI.currentCommands.isImageExtractionAllowed()) {
                        this.currentCommands.pages.setHighlightedImage(new int[]{x, y, w, h});
                    }
                }
                this.lastId = this.id;
            } else {
                if (this.currentGUI.currentCommands.isImageExtractionAllowed()) {
                    this.currentCommands.pages.setHighlightedImage(null);
                }
                this.lastId = -1;
            }
            if (this.id != -1 || this.clickCount <= 1) return;
            switch (this.clickCount) {
                case 1: {
                    return;
                }
                case 2: {
                    Rectangle[] lines = this.decode_pdf.getTextLines().getLineAreas(this.pageMouseIsOver);
                    Rectangle point = new Rectangle(mouseX, mouseY, 1, 1);
                    if (lines == null) return;
                    for (int i = 0; i != lines.length; ++i) {
                        if (!lines[i].intersects(point)) continue;
                        this.decode_pdf.updateCursorBoxOnScreen(lines[i], DecoderOptions.highlightColor);
                        this.decode_pdf.getTextLines().addHighlights(new Rectangle[]{lines[i]}, false, this.pageMouseIsOver);
                    }
                    return;
                }
                case 3: {
                    Rectangle para = this.decode_pdf.getTextLines().setFoundParagraph(mouseX, mouseY, this.pageMouseIsOver);
                    if (para == null) return;
                    this.decode_pdf.updateCursorBoxOnScreen(para, DecoderOptions.highlightColor);
                    return;
                }
                case 4: {
                    this.currentGUI.currentCommands.executeCommand(26, null);
                }
            }
            return;
        }
        if (event.getButton() != 2 && event.getButton() != 3) return;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (!(this.decode_pdf.getDisplayView() != 1 && !activateMultipageHighlight || event.getButton() != 1 && event.getButton() != 0)) {
            this.decode_pdf.updateCursorBoxOnScreen(null, null);
            this.currentCommands.pages.setHighlightedImage(null);
            this.decode_pdf.getTextLines().clearHighlights();
            this.decode_pdf.grabFocus();
            Point values = this.getCoordsOnPage(event.getX(), event.getY(), this.commonValues.getCurrentPage());
            this.commonValues.m_x1 = (int)values.getX();
            this.commonValues.m_y1 = (int)values.getY();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.decode_pdf.getDisplayView() == 1 || activateMultipageHighlight) {
            if (event.getButton() == 1 || event.getButton() == 0) {
                if (this.startHighlighting) {
                    this.startHighlighting = false;
                }
                this.repaintArea(new Rectangle(this.commonValues.m_x1 - this.currentGUI.cropX, this.commonValues.m_y2 + this.currentGUI.cropY, this.commonValues.m_x2 - this.commonValues.m_x1 + this.currentGUI.cropX, this.commonValues.m_y1 - this.commonValues.m_y2 + this.currentGUI.cropY), this.currentGUI.mediaH);
                this.decode_pdf.repaint();
                if (this.currentCommands.extractingAsImage) {
                    this.decode_pdf.updateCursorBoxOnScreen(null, null);
                    this.decode_pdf.getTextLines().clearHighlights();
                    this.currentCommands.pages.setHighlightedImage(null);
                    this.decode_pdf.setCursor(Cursor.getPredefinedCursor(0));
                    this.currentGUI.currentCommands.extractSelectedScreenAsImage();
                    this.currentCommands.extractingAsImage = false;
                    PdfDecoder.showMouseBox = false;
                }
                this.pageOfHighlight = -1;
            } else if (event.getButton() == 3 && this.currentGUI.getProperties().getValue("allowRightClick").toLowerCase().equals("true")) {
                if (!this.menuCreated) {
                    this.createRightClickMenu();
                }
                if (this.currentCommands.pages.getHighlightedImage() == null) {
                    this.extractImage.setEnabled(false);
                } else {
                    this.extractImage.setEnabled(true);
                }
                if (this.decode_pdf.getTextLines().getHighlightedAreas(this.commonValues.getCurrentPage()) == null) {
                    this.extractText.setEnabled(false);
                    this.find.setEnabled(false);
                    this.speakHighlighted.setEnabled(false);
                    this.copy.setEnabled(false);
                } else {
                    this.extractText.setEnabled(true);
                    this.find.setEnabled(true);
                    this.speakHighlighted.setEnabled(true);
                    this.copy.setEnabled(true);
                }
                if (this.decode_pdf != null && this.decode_pdf.isOpen()) {
                    this.rightClick.show(this.decode_pdf, event.getX(), event.getY());
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (event.getButton() == 1 || event.getButton() == 0) {
            this.altIsDown = event.isAltDown();
            if (!this.startHighlighting) {
                this.startHighlighting = true;
            }
            Point values = this.getCoordsOnPage(event.getX(), event.getY(), this.commonValues.getCurrentPage());
            if (this.pageMouseIsOver == this.pageOfHighlight) {
                this.commonValues.m_x2 = (int)values.getX();
                this.commonValues.m_y2 = (int)values.getY();
            }
            if (this.commonValues.isPDF()) {
                this.generateNewCursorBox();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    protected int[] updateXY(int originalX, int originalY) {
        float scaling = this.currentGUI.getScaling();
        int inset = GUI.getPDFDisplayInset();
        int rotation = this.currentGUI.getRotation();
        int x = (int)((float)(this.currentGUI.AdjustForAlignment(originalX) - inset) / scaling);
        int y = (int)((float)(originalY - inset) / scaling);
        if (this.commonValues.maxViewY != 0) {
            x = (int)((double)((float)x - (float)this.commonValues.dx * scaling) / this.commonValues.viewportScale);
            y = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)y / scaling - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)scaling);
        }
        int[] ret = new int[2];
        if (rotation == 90) {
            ret[1] = x + this.currentGUI.cropY;
            ret[0] = y + this.currentGUI.cropX;
        } else if (rotation == 180) {
            ret[0] = this.currentGUI.mediaW - (x + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
            ret[1] = y + this.currentGUI.cropY;
        } else if (rotation == 270) {
            ret[1] = this.currentGUI.mediaH - (x + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
            ret[0] = this.currentGUI.mediaW - (y + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
        } else {
            ret[0] = x + this.currentGUI.cropX;
            ret[1] = this.currentGUI.mediaH - (y + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
        }
        return ret;
    }

    private void createRightClickMenu() {
        this.copy = new JMenuItem(Messages.getMessage("PdfRightClick.copy"));
        this.selectAll = new JMenuItem(Messages.getMessage("PdfRightClick.selectAll"));
        this.deselectall = new JMenuItem(Messages.getMessage("PdfRightClick.deselectAll"));
        this.extract = new JMenu(Messages.getMessage("PdfRightClick.extract"));
        this.extractText = new JMenuItem(Messages.getMessage("PdfRightClick.extractText"));
        this.extractImage = new JMenuItem(Messages.getMessage("PdfRightClick.extractImage"));
        this.snapshotIcon = new ImageIcon(this.getClass().getResource("/org/jpedal/examples/viewer/res/snapshot_menu.gif"));
        this.snapShot = new JMenuItem(Messages.getMessage("PdfRightClick.snapshot"), this.snapshotIcon);
        this.find = new JMenuItem(Messages.getMessage("PdfRightClick.find"));
        this.speakHighlighted = new JMenuItem("Speak Highlighted text");
        this.rightClick.add(this.copy);
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SwingMouseSelector.this.decode_pdf.getDisplayView() == 1) {
                    ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.currentCommands.executeCommand(25, null);
                } else if (Viewer.showMessages) {
                    JOptionPane.showMessageDialog(SwingMouseSelector.this.currentGUI.getFrame(), "Copy is only avalible in single page display mode");
                }
            }
        });
        this.rightClick.addSeparator();
        this.rightClick.add(this.selectAll);
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.currentCommands.executeCommand(26, null);
            }
        });
        this.rightClick.add(this.deselectall);
        this.deselectall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.currentCommands.executeCommand(27, null);
            }
        });
        this.rightClick.addSeparator();
        this.rightClick.add(this.extract);
        this.extract.add(this.extractText);
        this.extractText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SwingMouseSelector.this.decode_pdf.getDisplayView() == 1) {
                    ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.currentCommands.extractSelectedText();
                } else if (Viewer.showMessages) {
                    JOptionPane.showMessageDialog(SwingMouseSelector.this.currentGUI.getFrame(), "Text Extraction is only avalible in single page display mode");
                }
            }
        });
        this.extract.add(this.extractImage);
        this.extractImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((SwingMouseSelector)SwingMouseSelector.this).currentCommands.pages.getHighlightedImage() == null) {
                    if (Viewer.showMessages) {
                        JOptionPane.showMessageDialog(SwingMouseSelector.this.decode_pdf, "No image has been selected for extraction.", "No image selected", 0);
                    }
                } else if (SwingMouseSelector.this.decode_pdf.getDisplayView() == 1) {
                    JFileChooser jf = new JFileChooser();
                    FileFilter ff1 = new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory() || f.getName().toLowerCase().endsWith(".jpg") || f.getName().toLowerCase().endsWith(".jpeg");
                        }

                        @Override
                        public String getDescription() {
                            return "JPG (*.jpg)";
                        }
                    };
                    FileFilter ff2 = new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory() || f.getName().toLowerCase().endsWith(".png");
                        }

                        @Override
                        public String getDescription() {
                            return "PNG (*.png)";
                        }
                    };
                    FileFilter ff3 = new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory() || f.getName().toLowerCase().endsWith(".tif") || f.getName().toLowerCase().endsWith(".tiff");
                        }

                        @Override
                        public String getDescription() {
                            return "TIF (*.tiff)";
                        }
                    };
                    jf.addChoosableFileFilter(ff3);
                    jf.addChoosableFileFilter(ff2);
                    jf.addChoosableFileFilter(ff1);
                    jf.showSaveDialog(null);
                    File f = jf.getSelectedFile();
                    boolean failed = false;
                    if (f != null) {
                        String filename = f.getAbsolutePath();
                        String type = jf.getFileFilter().getDescription().substring(0, 3).toLowerCase();
                        if (filename.indexOf(46) != -1) {
                            String testExt = filename.substring(filename.indexOf(46) + 1).toLowerCase();
                            if (testExt.equals("jpg") || testExt.equals("jpeg")) {
                                type = "jpg";
                            } else if (testExt.equals("png")) {
                                type = "png";
                            } else if (testExt.equals("tif") || testExt.equals("tiff")) {
                                type = "tiff";
                            } else {
                                if (Viewer.showMessages) {
                                    JOptionPane.showMessageDialog(null, "Sorry, we can not currently save images to ." + testExt + " files.");
                                }
                                failed = true;
                            }
                        }
                        if (type.equals("tif")) {
                            type = "tiff";
                        }
                        if (type.equals("all")) {
                            type = "png";
                        }
                        if (!filename.toLowerCase().endsWith('.' + type)) {
                            filename = filename + '.' + type;
                        }
                        if (!failed) {
                            SwingMouseSelector.this.decode_pdf.getDynamicRenderer().saveImage(SwingMouseSelector.this.id, filename, type);
                        }
                    }
                }
            }
        });
        this.extract.add(this.snapShot);
        this.snapShot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.currentCommands.executeCommand(13, null);
            }
        });
        this.rightClick.addSeparator();
        this.rightClick.add(this.find);
        this.find.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int hyphenOption;
                int findAllOption;
                int temp;
                Rectangle coords = SwingMouseSelector.this.decode_pdf.getCursorBoxOnScreen();
                if (coords == null) {
                    if (Viewer.showMessages) {
                        JOptionPane.showMessageDialog(SwingMouseSelector.this.decode_pdf, "There is no text selected.\nPlease highlight the text you wish to search.", "No Text selected", 0);
                    }
                    return;
                }
                String textToFind = SwingMouseSelector.this.currentGUI.showInputDialog(Messages.getMessage("PdfViewerMessage.GetUserInput"));
                if (textToFind == null || textToFind.length() < 1) {
                    return;
                }
                int t_x1 = coords.x;
                int t_x2 = coords.x + coords.width;
                int t_y1 = coords.y;
                int t_y2 = coords.y + coords.height;
                if (t_y1 < t_y2) {
                    temp = t_y2;
                    t_y2 = t_y1;
                    t_y1 = temp;
                }
                if (t_x1 > t_x2) {
                    temp = t_x2;
                    t_x2 = t_x1;
                    t_x1 = temp;
                }
                if (t_x1 < ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropX) {
                    t_x1 = ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropX;
                }
                if (t_x1 > ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.mediaW - ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropX) {
                    t_x1 = ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.mediaW - ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropX;
                }
                if (t_x2 < ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropX) {
                    t_x2 = ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropX;
                }
                if (t_x2 > ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.mediaW - ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropX) {
                    t_x2 = ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.mediaW - ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropX;
                }
                if (t_y1 < ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropY) {
                    t_y1 = ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropY;
                }
                if (t_y1 > ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.mediaH - ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropY) {
                    t_y1 = ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.mediaH - ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropY;
                }
                if (t_y2 < ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropY) {
                    t_y2 = ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropY;
                }
                if (t_y2 > ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.mediaH - ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropY) {
                    t_y2 = ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.mediaH - ((SwingMouseSelector)SwingMouseSelector.this).currentGUI.cropY;
                }
                int searchType = 0;
                int caseSensitiveOption = SwingMouseSelector.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewercase.message"), null, 0);
                if (caseSensitiveOption == 0) {
                    searchType |= 2;
                }
                if ((findAllOption = SwingMouseSelector.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerfindAll.message"), null, 0)) == 1) {
                    searchType |= 4;
                }
                if ((hyphenOption = SwingMouseSelector.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerfindHyphen.message"), null, 0)) == 0) {
                    searchType |= 8;
                }
                if (textToFind != null) {
                    try {
                        float[] co_ords = SwingMouseSelector.this.decode_pdf.getGroupingObject().findText(new Rectangle(t_x1, t_y1, t_x2 - t_x1, t_y2 - t_y1), SwingMouseSelector.this.commonValues.getCurrentPage(), new String[]{textToFind}, searchType);
                        if (co_ords != null) {
                            if (co_ords.length < 3) {
                                SwingMouseSelector.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.Found") + ' ' + co_ords[0] + ',' + co_ords[1]);
                            } else {
                                StringBuilder displayCoords = new StringBuilder();
                                String coordsMessage = Messages.getMessage("PdfViewerMessage.FoundAt");
                                for (int i = 0; i < co_ords.length; i += 5) {
                                    displayCoords.append(coordsMessage).append(' ');
                                    displayCoords.append(co_ords[i]);
                                    displayCoords.append(',');
                                    displayCoords.append(co_ords[i + 1]);
                                    displayCoords.append('\n');
                                    coordsMessage = co_ords[i + 4] == -101.0f ? Messages.getMessage("PdfViewerMessage.FoundAtHyphen") : Messages.getMessage("PdfViewerMessage.FoundAt");
                                }
                                SwingMouseSelector.this.currentGUI.showMessageDialog(displayCoords.toString());
                            }
                        } else {
                            SwingMouseSelector.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NotFound"));
                        }
                    }
                    catch (PdfException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.menuCreated = true;
        this.decode_pdf.add(this.rightClick);
    }

    protected void generateNewCursorBox() {
        if (this.old_m_x2 != -1 | this.old_m_y2 != -1 | Math.abs(this.commonValues.m_x2 - this.old_m_x2) > 5 | Math.abs(this.commonValues.m_y2 - this.old_m_y2) > 5) {
            int top_x = this.commonValues.m_x1;
            if (this.commonValues.m_x1 > this.commonValues.m_x2) {
                top_x = this.commonValues.m_x2;
            }
            int top_y = this.commonValues.m_y1;
            if (this.commonValues.m_y1 > this.commonValues.m_y2) {
                top_y = this.commonValues.m_y2;
            }
            int w = Math.abs(this.commonValues.m_x2 - this.commonValues.m_x1);
            int h = Math.abs(this.commonValues.m_y2 - this.commonValues.m_y1);
            Rectangle currentRectangle = new Rectangle(top_x, top_y, w, h);
            this.decode_pdf.updateCursorBoxOnScreen(currentRectangle, DecoderOptions.highlightColor);
            if (!this.currentCommands.extractingAsImage) {
                int type = this.decode_pdf.getDynamicRenderer().getObjectUnderneath(this.commonValues.m_x1, this.commonValues.m_y1);
                if (this.altIsDown && type != 1 && type != 4 && type != 5 && type != 6) {
                    this.decode_pdf.getTextLines().addHighlights(new Rectangle[]{currentRectangle}, true, this.pageOfHighlight);
                } else {
                    Rectangle r = new Rectangle(this.commonValues.m_x1, this.commonValues.m_y1, this.commonValues.m_x2 - this.commonValues.m_x1, this.commonValues.m_y2 - this.commonValues.m_y1);
                    this.decode_pdf.getTextLines().addHighlights(new Rectangle[]{r}, false, this.pageOfHighlight);
                }
            }
            this.old_m_x2 = this.commonValues.m_x2;
            this.old_m_y2 = this.commonValues.m_y2;
        }
        ((SingleDisplay)this.decode_pdf.getExternalHandler(16)).refreshDisplay();
        this.decode_pdf.repaint();
    }

    private Point getPageCoordsInSingleDisplayMode(int x, int y, int page) {
        if (this.currentGUI.useNewLayout) {
            int pageHeight;
            int pageWidth;
            int[] flag = new int[]{1, 0};
            if (this.currentGUI.getRotation() % 180 == 90) {
                pageWidth = this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(page);
                pageHeight = this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(page);
            } else {
                pageWidth = this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(page);
                pageHeight = this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(page);
            }
            Rectangle pageArea = new Rectangle(this.decode_pdf.getWidth() / 2 - pageWidth / 2, this.decode_pdf.getInsetH(), pageWidth, pageHeight);
            flag[1] = pageArea.contains(x, y) ? 1 : 0;
            if (this.pageOfHighlight == -1 && this.startHighlighting) {
                this.pageOfHighlight = page;
            }
            this.pageMouseIsOver = page;
            this.currentGUI.setMultibox(flag);
        }
        float scaling = this.currentGUI.getScaling();
        int inset = GUI.getPDFDisplayInset();
        int rotation = this.currentGUI.getRotation();
        int ex = this.currentGUI.AdjustForAlignment(x) - inset;
        int ey = y - inset;
        if (this.commonValues.maxViewY != 0) {
            ex = (int)((double)((float)ex - (float)this.commonValues.dx * scaling) / this.commonValues.viewportScale);
            ey = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)ey / scaling - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)scaling);
        }
        x = (int)((float)ex / scaling);
        y = (int)((float)ey / scaling);
        if (rotation == 90) {
            int tmp = x + this.currentGUI.cropY;
            x = y + this.currentGUI.cropX;
            y = tmp;
        } else if (rotation == 180) {
            x = this.currentGUI.cropW + this.currentGUI.cropX - x;
            y += this.currentGUI.cropY;
        } else if (rotation == 270) {
            int tmp = this.currentGUI.cropH + this.currentGUI.cropY - x;
            x = this.currentGUI.cropW + this.currentGUI.cropX - y;
            y = tmp;
        } else {
            x += this.currentGUI.cropX;
            y = this.decode_pdf.getDisplayView() == 1 ? this.currentGUI.cropH + this.currentGUI.cropY - y : this.currentGUI.cropY + y;
        }
        return new Point(x, y);
    }

    private Point getPageCoordsInContinuousDisplayMode(int x, int y, int page) {
        SingleDisplay pages = (SingleDisplay)this.decode_pdf.getExternalHandler(16);
        if (this.currentGUI.useNewLayout) {
            int[] flag = new int[]{1, 0};
            int xAdjustment = this.decode_pdf.getWidth() / 2 - this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(page) / 2;
            xAdjustment = xAdjustment < 0 ? 0 : (xAdjustment -= pages.getXCordForPage(page));
            Rectangle pageArea = new Rectangle(pages.getXCordForPage(page) + xAdjustment, pages.getYCordForPage(page), this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(page), this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(page));
            if (pageArea.contains(x, y)) {
                flag[1] = 1;
            }
            if (flag[1] == 0) {
                if (y < pageArea.y && page > 1) {
                    while (flag[1] == 0 && page > 1) {
                        if (!(pageArea = new Rectangle(pages.getXCordForPage(--page) + xAdjustment, pages.getYCordForPage(page), this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(page), this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(page))).contains(x, y)) continue;
                        flag[1] = 1;
                    }
                } else if ((double)y > pageArea.getMaxY() && page < this.commonValues.getPageCount()) {
                    while (flag[1] == 0 && page < this.commonValues.getPageCount()) {
                        if (!(pageArea = new Rectangle(pages.getXCordForPage(++page) + xAdjustment, pages.getYCordForPage(page), this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(page), this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(page))).contains(x, y)) continue;
                        flag[1] = 1;
                    }
                }
            }
            if (this.pageOfHighlight == -1 && this.startHighlighting) {
                this.pageOfHighlight = page;
            }
            this.pageMouseIsOver = page;
            y = pages.getYCordForPage(page) + this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(page) + this.decode_pdf.getInsetH() - y;
            this.currentGUI.setMultibox(flag);
        }
        float scaling = this.currentGUI.getScaling();
        int inset = GUI.getPDFDisplayInset();
        int rotation = this.currentGUI.getRotation();
        int ex = this.currentGUI.AdjustForAlignment(x) - inset;
        int ey = y - inset;
        if (this.commonValues.maxViewY != 0) {
            ex = (int)((double)((float)ex - (float)this.commonValues.dx * scaling) / this.commonValues.viewportScale);
            ey = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)ey / scaling - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)scaling);
        }
        x = (int)((float)ex / scaling);
        y = (int)((float)ey / scaling);
        if (rotation == 90) {
            int tmp = x + this.currentGUI.cropY;
            x = y + this.currentGUI.cropX;
            y = tmp;
        } else if (rotation == 180) {
            x = this.currentGUI.cropW + this.currentGUI.cropX - x;
            y += this.currentGUI.cropY;
        } else if (rotation == 270) {
            int tmp = this.currentGUI.cropH + this.currentGUI.cropY - x;
            x = this.currentGUI.cropW + this.currentGUI.cropX - y;
            y = tmp;
        } else {
            x += this.currentGUI.cropX;
            y = this.decode_pdf.getDisplayView() == 1 ? this.currentGUI.cropH + this.currentGUI.cropY - y : this.currentGUI.cropY + y;
        }
        return new Point(x, y);
    }

    private Point getPageCoordsInContinuousFacingDisplayMode(int x, int y, int page) {
        SingleDisplay pages = (SingleDisplay)this.decode_pdf.getExternalHandler(16);
        if (this.currentGUI.useNewLayout) {
            Rectangle pageArea;
            int xAdjustment;
            int[] flag = new int[]{1, 0};
            if (page != 1 && x > this.decode_pdf.getWidth() / 2 && page < this.commonValues.getPageCount()) {
                ++page;
            }
            if ((xAdjustment = this.decode_pdf.getWidth() / 2 - this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(page) - this.decode_pdf.getInsetW()) < 0) {
                System.err.println("x adjustment is less than 0");
                xAdjustment = 0;
            }
            if ((pageArea = new Rectangle(pages.getXCordForPage(page) + xAdjustment, pages.getYCordForPage(page), this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(page), this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(page))).contains(x, y)) {
                flag[1] = 1;
            }
            if (flag[1] == 0) {
                if (y < pageArea.y && page > 1) {
                    while (flag[1] == 0 && page > 1) {
                        xAdjustment = this.decode_pdf.getWidth() / 2 - this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(--page) - this.decode_pdf.getInsetW();
                        if (xAdjustment < 0) {
                            xAdjustment = 0;
                        }
                        if (!(pageArea = new Rectangle(pages.getXCordForPage(page) + xAdjustment, pages.getYCordForPage(page), this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(page), this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(page))).contains(x, y)) continue;
                        flag[1] = 1;
                    }
                } else if ((double)y > pageArea.getMaxY() && page < this.commonValues.getPageCount()) {
                    while (flag[1] == 0 && page < this.commonValues.getPageCount()) {
                        xAdjustment = this.decode_pdf.getWidth() / 2 - this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(++page) - this.decode_pdf.getInsetW();
                        if (xAdjustment < 0) {
                            xAdjustment = 0;
                        }
                        if (!(pageArea = new Rectangle(pages.getXCordForPage(page) + xAdjustment, pages.getYCordForPage(page), this.decode_pdf.getPdfPageData().getScaledCropBoxWidth(page), this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(page))).contains(x, y)) continue;
                        flag[1] = 1;
                    }
                }
            }
            if (this.pageOfHighlight == -1 && this.startHighlighting) {
                this.pageOfHighlight = page;
            }
            this.pageMouseIsOver = page;
            y = pages.getYCordForPage(page) + this.decode_pdf.getPdfPageData().getScaledCropBoxHeight(page) + this.decode_pdf.getInsetH() - y;
            x -= pages.getXCordForPage(page) - this.decode_pdf.getInsetW();
            this.currentGUI.setMultibox(flag);
        }
        float scaling = this.currentGUI.getScaling();
        int inset = GUI.getPDFDisplayInset();
        int rotation = this.currentGUI.getRotation();
        int ex = this.currentGUI.AdjustForAlignment(x) - inset;
        int ey = y - inset;
        if (this.commonValues.maxViewY != 0) {
            ex = (int)((double)((float)ex - (float)this.commonValues.dx * scaling) / this.commonValues.viewportScale);
            ey = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)ey / scaling - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)scaling);
        }
        x = (int)((float)ex / scaling);
        y = (int)((float)ey / scaling);
        if (rotation == 90) {
            int tmp = x + this.currentGUI.cropY;
            x = y + this.currentGUI.cropX;
            y = tmp;
        } else if (rotation == 180) {
            x = this.currentGUI.cropW + this.currentGUI.cropX - x;
            y += this.currentGUI.cropY;
        } else if (rotation == 270) {
            int tmp = this.currentGUI.cropH + this.currentGUI.cropY - x;
            x = this.currentGUI.cropW + this.currentGUI.cropX - y;
            y = tmp;
        } else {
            x += this.currentGUI.cropX;
            y = this.decode_pdf.getDisplayView() == 1 ? this.currentGUI.cropH + this.currentGUI.cropY - y : this.currentGUI.cropY + y;
        }
        return new Point(x, y);
    }

    private Point getPageCoordsInFacingDisplayMode(int x, int y, int page) {
        if (this.currentGUI.useNewLayout) {
            int[] flag = new int[]{1, 0};
            flag[1] = 0;
            this.currentGUI.setMultibox(flag);
        }
        float scaling = this.currentGUI.getScaling();
        int inset = GUI.getPDFDisplayInset();
        int rotation = this.currentGUI.getRotation();
        int ex = this.currentGUI.AdjustForAlignment(x) - inset;
        int ey = y - inset;
        if (this.commonValues.maxViewY != 0) {
            ex = (int)((double)((float)ex - (float)this.commonValues.dx * scaling) / this.commonValues.viewportScale);
            ey = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)ey / scaling - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)scaling);
        }
        x = (int)((float)ex / scaling);
        y = (int)((float)ey / scaling);
        if (rotation == 90) {
            int tmp = x + this.currentGUI.cropY;
            x = y + this.currentGUI.cropX;
            y = tmp;
        } else if (rotation == 180) {
            x = this.currentGUI.cropW + this.currentGUI.cropX - x;
            y += this.currentGUI.cropY;
        } else if (rotation == 270) {
            int tmp = this.currentGUI.cropH + this.currentGUI.cropY - x;
            x = this.currentGUI.cropW + this.currentGUI.cropX - y;
            y = tmp;
        } else {
            x += this.currentGUI.cropX;
            y = this.decode_pdf.getDisplayView() == 1 ? this.currentGUI.cropH + this.currentGUI.cropY - y : this.currentGUI.cropY + y;
        }
        return new Point(x, y);
    }

    public Point getCoordsOnPage(int x, int y, int page) {
        Point pagePosition = null;
        switch (this.decode_pdf.getDisplayView()) {
            case 1: {
                pagePosition = this.getPageCoordsInSingleDisplayMode(x, y, page);
                x = pagePosition.x;
                y = pagePosition.y;
                break;
            }
            case 2: {
                pagePosition = this.getPageCoordsInContinuousDisplayMode(x, y, page);
                x = pagePosition.x;
                y = pagePosition.y;
                break;
            }
            case 3: {
                pagePosition = this.getPageCoordsInFacingDisplayMode(x, y, page);
                x = pagePosition.x;
                y = pagePosition.y;
                break;
            }
            case 4: {
                pagePosition = this.getPageCoordsInContinuousFacingDisplayMode(x, y, page);
                x = pagePosition.x;
                y = pagePosition.y;
                break;
            }
        }
        return new Point(x, y);
    }

    public void repaintArea(Rectangle screenBox, int maxY) {
        int strip = 10;
        float scaling = this.decode_pdf.getScaling();
        int x = (int)((float)screenBox.x * scaling) - strip;
        int y = (int)((float)(maxY - screenBox.y - screenBox.height) * scaling) - strip;
        int width = (int)((float)(screenBox.x + screenBox.width) * scaling) + strip + strip;
        int height = (int)((float)(screenBox.y + screenBox.height) * scaling) + strip + strip;
        RepaintManager currentManager = RepaintManager.currentManager(this.decode_pdf);
        currentManager.addDirtyRegion(this.decode_pdf, x, y, width, height);
    }
}

